/*
 * Copyright (c) 2018, Infinitay <https://github.com/Infinitay>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice, this
 *    list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package net.runelite.api;

/**
 * An enumeration of PK skulls.
 */
public final class SkullIcon
{
	/**
	 * White skull from PVP world or wilderness
	 */
	public static final int SKULL = 0;
	/**
	 * Red skull from Tzhaar Fight Pits
	 */
	public static final int SKULL_FIGHT_PIT = 1;
	/**
	 * White skull used on High Risk worlds
	 */
	public static final int SKULL_HIGH_RISK = 2;
	/**
	 * Forinthry surge buff in the Revenant caves
	 */
	public static final int FORINTHRY_SURGE = 3;
	/**
	 * Grey skull used on Deadman worlds
	 */
	public static final int SKULL_DEADMAN = 7;
	/**
	 * PK skull carrying one loot key
	 */
	public static final int LOOT_KEYS_ONE = 8;
	/**
	 * PK skull carrying two loot keys
	 */
	public static final int LOOT_KEYS_TWO = 9;
	/**
	 * PK skull carrying two loot keys
	 */
	public static final int LOOT_KEYS_THREE = 10;
	/**
	 * PK skull carrying two loot keys
	 */
	public static final int LOOT_KEYS_FOUR = 11;
	/**
	 * PK skull carrying two loot keys
	 */
	public static final int LOOT_KEYS_FIVE = 12;
	/**
	 * Forinthry surge skull used on Deadman worlds
	 */
	public static final int FORINTHRY_SURGE_DEADMAN = 14;
	/**
	 * Forinthry surge while carrying one loot key
	 */
	public static final int FORINTHRY_SURGE_KEYS_ONE = 15;
	/**
	 * Forinthry surge while carrying two loot keys
	 */
	public static final int FORINTHRY_SURGE_KEYS_TWO = 16;
	/**
	 * Forinthry surge while carrying three loot keys
	 */
	public static final int FORINTHRY_SURGE_KEYS_THREE = 17;
	/**
	 * Forinthry surge while carrying four loot keys
	 */
	public static final int FORINTHRY_SURGE_KEYS_FOUR = 18;
	/**
	 * Forinthry surge while carrying five loot keys
	 */
	public static final int FORINTHRY_SURGE_KEYS_FIVE = 19;

	/**
	 * The player does not have a skull.
	 */
	public static final int NONE = -1;

}
