/*
 * Copyright (c) 2025 Abex
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice, this
 *    list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package net.runelite.api.gameval;

@SuppressWarnings("unused")
public final class SpriteID
{
	// This file is partially automatically generated. All fields with an integer
	// literal initializer are generated. All other fields (with a reference
	// initializer) are created manually and not named by Jagex.

	public static final int BACKLEFT1 = 4;
	public static final int MAPBACK = 12;
	public static final int COMPASS = 169;
	public static final int TRADEBACKING = 297;
	public static final int CROSS = 299;
	public static final int MAPDOTS = 300;
	public static final int LEFTARROW = 308;
	public static final int RIGHTARROW = 309;
	public static final int SCROLLBAR = 316;
	public static final int MAPSCENE = 317;
	public static final int INFERNAL_CAPE = 318;
	public static final int MAPMARKER = 422;
	public static final int MOD_ICONS = 423;
	public static final int MAPEDGE = 424;
	public static final int LEFTARROW_SMALL = 425;
	public static final int RIGHTARROW_SMALL = 426;
	public static final int BLACKMARK = 427;
	public static final int BUTTON_BROWN = 428;
	public static final int BUTTON_RED = 429;
	public static final int CHEST = 430;
	public static final int COINS = 431;
	public static final int KEY = 432;
	public static final int KEYS = 433;
	public static final int PEN = 434;
	public static final int STARTGAME = 435;
	public static final int TITLESCROLL = 436;
	public static final int LETTER = 437;
	public static final int BUTTON_BROWN_BIG = 438;
	public static final int HEADICONS_PK = 439;
	public static final int HEADICONS_PRAYER = 440;
	public static final int HEADICONS_HINT = 441;
	public static final int OVERLAY_MULTIWAY = 442;
	public static final int OVERLAY_DUEL = 443;
	public static final int TEX_BROWN = 444;
	public static final int TEX_RED = 445;
	public static final int NUMBER_BUTTON = 446;
	public static final int DOOR = 447;
	public static final int WATER = 448;
	public static final int WALL = 449;
	public static final int PLANKS = 450;
	public static final int ELFDOOR = 451;
	public static final int DARKWOOD = 452;
	public static final int ROOF = 453;
	public static final int DAMAGE = 454;
	public static final int LEAFYTREE = 455;
	public static final int TREESTUMP = 456;
	public static final int MOSSY = 457;
	public static final int RAILINGS = 458;
	public static final int PAINTING1 = 459;
	public static final int PAINTING2 = 460;
	public static final int MARBLE = 461;
	public static final int WOOD2 = 462;
	public static final int FOUNTAIN = 463;
	public static final int THATCHED = 464;
	public static final int CARGONET = 465;
	public static final int BOOKS = 466;
	public static final int ELFROOF2 = 467;
	public static final int ELFWOOD = 468;
	public static final int MOSSYBRICKS = 469;
	public static final int GUNGYWATER = 470;
	public static final int WEB = 471;
	public static final int ELFROOF = 472;
	public static final int MOSSYDAMAGE = 473;
	public static final int BAMBOO = 474;
	public static final int WILLOWTEX3 = 475;
	public static final int LAVA = 476;
	public static final int BARK = 477;
	public static final int MAPLETREE = 478;
	public static final int STARS = 479;
	public static final int ELFBRICK = 480;
	public static final int ELFWALL = 481;
	public static final int CHAINMAIL = 482;
	public static final int MUMMY = 483;
	public static final int ELFPAINTING = 484;
	public static final int LAVA_ANIMATED = 485;
	public static final int LEAFYTREE_DISEASED = 486;
	public static final int STONE_TILES = 487;
	public static final int ROOF2 = 488;
	public static final int PEBBLEFLOOR = 490;
	public static final int WALL_WHITE = 491;
	public static final int GLYPHS = 492;
	public static final int CANVAS = 493;
	public static final int P11_FULL = 494;
	public static final int P12_FULL = 495;
	public static final int B12_FULL = 496;
	public static final int Q8_FULL = 497;
	public static final int LOGO = 498;
	public static final int TITLEBOX = 499;
	public static final int TITLEBUTTON = 500;
	public static final int RUNES = 501;
	public static final int HLOADING2 = 529;
	public static final int CRAG = 530;
	public static final int WATER_ANIMATED = 531;
	public static final int MARBLE_POH = 532;
	public static final int OLD_TILES = 533;
	public static final int OLD_TILES_LIGHTER = 643;
	public static final int WOODENFLOOR_NEW = 644;
	public static final int QUILL_OBLIQUE_LARGE = 645;
	public static final int QUILL_CAPS_LARGE = 646;
	public static final int LUNAR_ALPHABET = 647;
	public static final int LUNAR_ALPHABET_LRG = 648;
	public static final int COMBATBOXELONG = 652;
	public static final int COMBATBOXES_SPECIAL_ATTACK = 657;
	public static final int EQUIP_SCREEN_BUTTON = 658;
	public static final int OPTIONS_POH_ICON = 678;
	public static final int COMBAT_SHIELD = 760;
	public static final int XMAS_SNOWFLAKE = 763;
	public static final int BARBASSAULT_FONT = 764;
	public static final int TITLE_MUTE = 811;
	public static final int SL_BACK = 814;
	public static final int SL_FLAGS = 815;
	public static final int SL_ARROWS = 816;
	public static final int SL_STARS = 817;
	public static final int SL_BUTTON = 818;
	public static final int SUROK_FONT = 819;
	public static final int DREAM_INV_BRDR = 837;
	public static final int DREAM_MONSTER_ICON = 838;
	public static final int MIRROR = 861;
	public static final int GRIM_MUSICALNOTES1 = 865;
	public static final int OLD_TILES_GREEN = 866;
	public static final int TRADEBACKING_DARK = 897;
	public static final int EXCLAMATION_MARK = 937;
	public static final int CHAT_BACKGROUND = 1017;
	public static final int MAIN_STONES_BOTTOM = 1018;
	public static final int VOLUME_OPTIONS_BOBBLE_SLIDER = 1019;
	public static final int SIDE_BACKGROUND = 1031;
	public static final int SIDE_BACKGROUND_BOTTOM = 1032;
	public static final int SIDE_BACKGROUND_LEFT1 = 1033;
	public static final int SIDE_BACKGROUND_LEFT2 = 1034;
	public static final int SIDE_BACKGROUND_RIGHT = 1035;
	public static final int SIDE_BACKGROUND_TOP = 1036;
	public static final int MINI_LEFT = 1037;
	public static final int MINI_RIGHT = 1038;
	public static final int MAIN_TOP = 1039;
	public static final int TRADEBACKING_LIGHT = 1040;
	public static final int MISCGRAPHICS_BUTTONMIDDLE_GREY = 1048;
	public static final int MISCGRAPHICS_BUTTONMIDDLE_RED = 1049;
	public static final int LAVA_ANIMATED_RED = 1075;
	public static final int LAVA_ANIMATED_WHITE = 1076;
	public static final int FRIENDS_CHANGED_NAME = 1093;
	public static final int MAPFUNCTION_INFOICON = 1094;
	public static final int WELCOMESCREEN_BANNER_DEFAULT = 1104;
	public static final int GE_BACKBUTTON = 1122;
	public static final int MISCGRAPHICS_BUTTONTILE_NW_GREY = 1141;
	public static final int MISCGRAPHICS_BUTTONTILE_NC_GREY = 1142;
	public static final int MISCGRAPHICS_BUTTONTILE_NE_GREY = 1143;
	public static final int MISCGRAPHICS_BUTTONTILE_CW_GREY = 1144;
	public static final int MISCGRAPHICS_BUTTONTILE_CC_GREY = 1145;
	public static final int MISCGRAPHICS_BUTTONTILE_CE_GREY = 1146;
	public static final int MISCGRAPHICS_BUTTONTILE_SW_GREY = 1147;
	public static final int MISCGRAPHICS_BUTTONTILE_SC_GREY = 1148;
	public static final int MISCGRAPHICS_BUTTONTILE_SE_GREY = 1149;
	public static final int MISCGRAPHICS_BUTTONTILE_NW_RED = 1150;
	public static final int MISCGRAPHICS_BUTTONTILE_NC_RED = 1151;
	public static final int MISCGRAPHICS_BUTTONTILE_NE_RED = 1152;
	public static final int MISCGRAPHICS_BUTTONTILE_CW_RED = 1153;
	public static final int MISCGRAPHICS_BUTTONTILE_CC_RED = 1154;
	public static final int MISCGRAPHICS_BUTTONTILE_CE_RED = 1155;
	public static final int MISCGRAPHICS_BUTTONTILE_SW_RED = 1156;
	public static final int MISCGRAPHICS_BUTTONTILE_SC_RED = 1157;
	public static final int MISCGRAPHICS_BUTTONTILE_SE_RED = 1158;
	public static final int OSRS_STRETCH_MAPSURROUND = 1177;
	public static final int RESIZE_MAP_MASK = 1178;
	public static final int RESIZE_COMPASS_MASK = 1179;
	public static final int FIXED_MINIMAP_COVER = 1182;
	public static final int FIXED_MAP_MASK = 1183;
	public static final int FIXED_COMPASS_MASK = 1184;
	public static final int SIDEICONS_LOGOUT = 1191;
	public static final int STOP = 1193;
	public static final int SAVE = 1194;
	public static final int LOAD = 1195;
	public static final int FIXED_MAP_CLICKMASK = 1200;
	public static final int SLIDER_BOBBLE = 1201;
	public static final int TICK = 1210;
	public static final int LOGO_DEADMAN_MODE = 1228;
	public static final int INFO = 1236;
	public static final int ARCEUUS_SIGIL = 1242;
	public static final int HOSIDIUS_SIGIL = 1243;
	public static final int LOVAKENGJ_SIGIL = 1244;
	public static final int PISCARILIUS_SIGIL = 1245;
	public static final int SHAYZIEN_SIGIL = 1246;
	public static final int WHISTLE = 1343;
	public static final int CHERRYBLOSSOM = 1396;
	public static final int REFRESH = 1412;
	public static final int RING_30 = 1438;
	public static final int MINI_TOPRIGHT = 1441;
	public static final int VERDANA_11PT_REGULAR = 1442;
	public static final int VERDANA_11PT_BOLD = 1443;
	public static final int VERDANA_11PT_REGULAR_MULTILINE = 1444;
	public static final int VERDANA_13PT_REGULAR = 1445;
	public static final int VERDANA_13PT_BOLD = 1446;
	public static final int VERDANA_15PT_REGULAR = 1447;
	public static final int TRADEBACKING_BEIGE = 1545;
	public static final int MINI_BOTTOM = 1611;
	public static final int KEYBOARD_KEY_LEFT = 1612;
	public static final int KEYBOARD_KEY_MIDDLE = 1613;
	public static final int KEYBOARD_KEY_RIGHT = 1614;
	public static final int OSM_PRESS_FNMODE = 1615;
	public static final int OSM_DRAG_CAMERA = 1616;
	public static final int OSM_PRESS_INTERACT = 1618;
	public static final int OSM_PRESS_MINIMISE = 1619;
	public static final int OSM_TAP_INTERACT = 1620;
	public static final int OSM_TAP_PRESS = 1621;
	public static final int CLICKCIRCLE_FILLED = 1625;
	public static final int CLICKCIRCLE_OUTLINE = 1626;
	public static final int RAIDS_CHALLENGE_ICON = 1627;
	public static final int HIEROGLYPHIC_SET1 = 1635;
	public static final int LEAFYTREE_TILED = 1648;
	public static final int TITLEBUTTON_LARGE = 1649;
	public static final int RING_40 = 1697;
	public static final int OPTIONS_BUTTONS = 1700;
	public static final int OPTIONS_BUTTONS_LARGE = 1701;
	public static final int PVP_WARNING_ICON = 1728;
	public static final int ARROWKEYS = 1747;
	public static final int LOGO_OSRS = 2132;
	public static final int PLAY_NOW_TEXT = 2133;
	public static final int LOGIN_ICONS = 2134;
	public static final int TITLEBUTTON_WIDE = 2135;
	public static final int DRAG_HANDLE = 2148;
	public static final int RESIZE_MAP_CLICKMASK = 2154;
	public static final int CLUEQUEST_MAP = 2155;
	public static final int LARGE_MULTI_USE_ICONS = 2209;
	public static final int ADVENTUREPATH_PLACEHOLDER = 2220;
	public static final int AP_SOTE_FREE_TRIAL = 2227;
	public static final int GETTING_STARTED_WITH_ATTACK = 2228;
	public static final int GETTING_A_GRIP_ON_IT = 2229;
	public static final int WEAPONS_MASTER = 2230;
	public static final int GETTING_STARTED_WITH_STRENGTH = 2231;
	public static final int BUILDING_MUSCLE = 2232;
	public static final int BODY_BUILDER = 2233;
	public static final int GETTING_STARTED_WITH_DEFENCE = 2234;
	public static final int STICKS_AND_STONES = 2235;
	public static final int MITHRIL_DEFENCE = 2236;
	public static final int GETTING_STARTED_WITH_MAGIC = 2237;
	public static final int STRIKING_A_POSE = 2238;
	public static final int BRINGER_OF_CHAOS = 2239;
	public static final int GETTING_STARTED_WITH_RANGED = 2240;
	public static final int HONING_MY_AIM = 2241;
	public static final int SHARPSHOOTER = 2242;
	public static final int LOGO_SPEEDRUNNING = 2243;
	public static final int BROWN_BORDER = 2247;
	public static final int BUTTON_BROWN_SMALL = 2248;
	public static final int TRADEBACKING_GREY = 2268;
	public static final int LOGO_SEASONAL_MODE = 2269;
	public static final int LEFTARROW_HIGHLIGHT = 2385;
	public static final int LEAGUE_PROGRESS_BAR_INDICATOR = 2388;
	public static final int RIGHTARROW_HIGHLIGHT = 2389;
	public static final int FIXED_MAP_CLICKMASK_WIKI = 2422;
	public static final int NO_PATH = 2495;
	public static final int BANKBUTTON_ARROW_GREEN = 2496;
	public static final int GETTING_STARTED_WITH_FISHING = 2498;
	public static final int GETTING_STARTED_WITH_MINING = 2499;
	public static final int GETTING_STARTED_WITH_WOODCUTTING = 2500;
	public static final int OVERLAY_SINGLEWAY_PLUS = 2518;
	public static final int SINGLE_ARROW = 2519;
	public static final int MAP_RESIZE = 2523;
	public static final int SCROLL_ICON = 2534;
	public static final int AUTOMATIC_WIZARD = 2560;
	public static final int LEAGUES_MEMBERSHIP_BANNER = 2590;
	public static final int UPGRADE_MEMBERSHIP_BUTTON = 2591;
	public static final int UPGRADE_MEMBERSHIP_BUTTON_HIGHLIGHT = 2592;
	public static final int LEAGUE_MAP = 2603;
	public static final int TRAILBLAZER_PROGRESS_BAR_INDICATOR = 2720;
	public static final int TRAILBLAZER_MAP_EMPTY = 2721;
	public static final int TRAILBLAZER_MAP_MISTHALIN = 2722;
	public static final int TRAILBLAZER_MAP_KARAMJA = 2723;
	public static final int TRAILBLAZER_MAP_WILDERNESS = 2724;
	public static final int TRAILBLAZER_MAP_ASGARNIA = 2725;
	public static final int TRAILBLAZER_MAP_KANDARIN = 2726;
	public static final int TRAILBLAZER_MAP_DESERT = 2727;
	public static final int TRAILBLAZER_MAP_FREMENNIK = 2728;
	public static final int TRAILBLAZER_MAP_TIRANNWN = 2729;
	public static final int TRAILBLAZER_MAP_MORYTANIA = 2730;
	public static final int TRAILBLAZER_LARGEMAP_ASGARNIA_1 = 2787;
	public static final int TRAILBLAZER_LARGEMAP_ASGARNIA_2 = 2788;
	public static final int TRAILBLAZER_LARGEMAP_ASGARNIA_3 = 2789;
	public static final int TRAILBLAZER_LARGEMAP_DESERT_1 = 2790;
	public static final int TRAILBLAZER_LARGEMAP_DESERT_2 = 2791;
	public static final int TRAILBLAZER_LARGEMAP_FREMENNIK_1 = 2792;
	public static final int TRAILBLAZER_LARGEMAP_FREMENNIK_2 = 2793;
	public static final int TRAILBLAZER_LARGEMAP_FREMENNIK_3 = 2794;
	public static final int TRAILBLAZER_LARGEMAP_FREMENNIK_4 = 2795;
	public static final int TRAILBLAZER_LARGEMAP_FREMENNIK_5 = 2796;
	public static final int TRAILBLAZER_LARGEMAP_KANDARIN_1 = 2797;
	public static final int TRAILBLAZER_LARGEMAP_KANDARIN_2 = 2798;
	public static final int TRAILBLAZER_LARGEMAP_KANDARIN_3 = 2799;
	public static final int TRAILBLAZER_LARGEMAP_KANDARIN_4 = 2800;
	public static final int TRAILBLAZER_LARGEMAP_KANDARIN_5 = 2801;
	public static final int TRAILBLAZER_LARGEMAP_KARAMJA_1 = 2802;
	public static final int TRAILBLAZER_LARGEMAP_KARAMJA_2 = 2803;
	public static final int TRAILBLAZER_LARGEMAP_KARAMJA_3 = 2804;
	public static final int TRAILBLAZER_LARGEMAP_MISTHALIN_1 = 2805;
	public static final int TRAILBLAZER_LARGEMAP_MISTHALIN_2 = 2806;
	public static final int TRAILBLAZER_LARGEMAP_MISTHALIN_3 = 2807;
	public static final int TRAILBLAZER_LARGEMAP_MISTHALIN_4 = 2808;
	public static final int TRAILBLAZER_LARGEMAP_MORYTANIA_1 = 2809;
	public static final int TRAILBLAZER_LARGEMAP_MORYTANIA_2 = 2810;
	public static final int TRAILBLAZER_LARGEMAP_MORYTANIA_3 = 2811;
	public static final int TRAILBLAZER_LARGEMAP_TIRANNWN_1 = 2812;
	public static final int TRAILBLAZER_LARGEMAP_TIRANNWN_2 = 2813;
	public static final int TRAILBLAZER_LARGEMAP_TIRANNWN_3 = 2814;
	public static final int TRAILBLAZER_LARGEMAP_WILDERNESS_1 = 2815;
	public static final int TRAILBLAZER_LARGEMAP_WILDERNESS_2 = 2816;
	public static final int TRAILBLAZER_LARGEMAP_WILDERNESS_3 = 2817;
	public static final int BLANK = 3023;
	public static final int ICON_SKULL = 3024;
	public static final int ICON_CROWN = 3025;
	public static final int ICON_WIZARD = 3026;
	public static final int ICON_COMEDY = 3027;
	public static final int ICON_HELMET = 3028;
	public static final int ICON_SWORDS = 3029;
	public static final int ICON_TRAGEDY = 3030;
	public static final int ICON_TOOLS = 3031;
	public static final int ICON_TOOLS2 = 3032;
	public static final int ICON_ARROWS = 3033;
	public static final int ICON_BALANCE = 3034;
	public static final int ICON_BANDIT = 3035;
	public static final int ICON_BONES = 3036;
	public static final int ICON_CABBAGE = 3037;
	public static final int ICON_CAT = 3038;
	public static final int ICON_COMPASS = 3039;
	public static final int ICON_FISH = 3040;
	public static final int ICON_HEART = 3041;
	public static final int ICON_HOLY = 3042;
	public static final int ICON_HUNTER = 3043;
	public static final int ICON_RING = 3044;
	public static final int ICON_ROBIN = 3045;
	public static final int ICON_ROSE = 3046;
	public static final int ICON_SHIELD = 3047;
	public static final int ICON_UNHOLY = 3048;
	public static final int ICON_IRON_STANDARD = 3049;
	public static final int ICON_IRON_ULTIMATE = 3050;
	public static final int LEAFYTREE_TILED02 = 3364;
	public static final int LEAFYTREE02 = 3365;
	public static final int RESIZE_MAP_CLICKMASK_BOND = 3513;
	public static final int HITMARK_BLOCKED = 3521;
	public static final int HEART_ICON = 3522;
	public static final int ICE = 3523;
	public static final int MEMBERSHIP_BANNER_SKILL = 3583;
	public static final int MEMBERSHIP_BANNER_AREA = 3584;
	public static final int MEMBERSHIP_BANNER_BOSS = 3585;
	public static final int MEMBERSHIP_BANNER_DIARY = 3586;
	public static final int MEMBERSHIP_BANNER_MINIGAME = 3587;
	public static final int MEMBERSHIP_BANNER_QUEST = 3588;
	public static final int MEMBERSHIP_BANNER_TRANSPORT = 3589;
	public static final int MEMBERSHIP_BANNER_WORN = 3590;
	public static final int MEMBERSHIP_BANNER_DRAGONSLAYER = 3591;
	public static final int HIEROGLYPHIC_SET2 = 3592;
	public static final int ROOF_SNOW = 3601;
	public static final int ROOF_SNOW02 = 3602;
	public static final int TEXTURE_TEST01 = 3603;
	public static final int CLICKCIRCLE_FILLED_YELLOW_ONLY = 4351;
	public static final int TEXTURE_STONE01 = 4377;
	public static final int GIANTS_FOUNDRY_QUALITY_BAR = 4513;
	public static final int PVPA_HEART = 4522;
	public static final int TOA_INVOCATIONS_PROGRESS_BAR_INDICATOR = 4659;
	public static final int TOA_INFO_ICON = 4663;
	public static final int FOG01 = 4664;
	public static final int FOG02 = 4665;
	public static final int FOG03 = 4666;
	public static final int SKULLS01 = 4667;
	public static final int FSW_BANNER_LARGE01 = 4672;
	public static final int FSW_BANNER_MEDIUM01 = 4673;
	public static final int FSW_BANNER_SMALL01 = 4674;
	public static final int OSM_BANNER_LARGE01 = 4675;
	public static final int OSM_BANNER_MEDIUM01 = 4676;
	public static final int OSM_BANNER_SMALL01 = 4677;
	public static final int TGOD_GARDEN_1_PLANT_DIAGRAM = 4678;
	public static final int TGOD_GARDEN_1_LAKE_MAP = 4679;
	public static final int TGOD_GARDEN_2_FOREST_MAP = 4680;
	public static final int TGOD_GARDEN_2_POISON_DIAGRAM = 4681;
	public static final int TGOD_GARDEN_2_RUNE_DIAGRAM = 4682;
	public static final int TGOD_GARDEN_3_BUCKET_DIAGRAM = 4683;
	public static final int TGOD_GARDEN_3_CARVING_DIAGRAM = 4684;
	public static final int TGOD_GARDEN_3_PACKAGE_DIAGRAM = 4685;
	public static final int TGOD_GARDEN_3_TRANSFER_DIAGRAM = 4686;
	public static final int TGOD_GARDEN_4_CREATURE_DIAGRAM = 4687;
	public static final int TGOD_GARDEN_4_DELIVERY_DIAGRAM = 4688;
	public static final int TGOD_GARDEN_4_LIGHT_DIAGRAM = 4689;
	public static final int TGOD_GARDEN_4_RECYCLING_DIAGRAM = 4690;
	public static final int TGOD_GARDEN_4_RUNE_DIAGRAM = 4691;
	public static final int LEFTARROW_SMALL_HIGHLIGHT = 4728;
	public static final int RIGHTARROW_SMALL_HIGHLIGHT = 4729;
	public static final int DIRECTIONAL_LOCK = 4733;
	public static final int COMBINATION_LOCK = 4738;
	public static final int SOTN_MAP = 4746;
	public static final int SKULLS02 = 4890;
	public static final int SKULLS03 = 4891;
	public static final int SKULLS04 = 4923;
	public static final int WORLDSWITCHER_FILTER = 4939;
	public static final int WORLDSWITCHER_FILTERED = 4940;
	public static final int TRADEBACKING_RED = 4948;
	public static final int DIRECTIONAL_LOCK_2 = 4949;
	public static final int POG_MACHINE = 5233;
	public static final int POG_EXCHANGER = 5234;
	public static final int BOND_GRAPHIC_128X64 = 5256;
	public static final int LEAGUE_4_LARGEMAP_DESERT_1 = 5275;
	public static final int LEAGUE_4_LARGEMAP_DESERT_2 = 5276;
	public static final int LEAGUE_4_LARGEMAP_DESERT_3 = 5277;
	public static final int LEAGUE_4_LARGEMAP_KOUREND_1 = 5278;
	public static final int LEAGUE_4_LARGEMAP_KOUREND_2 = 5279;
	public static final int LEAGUE_4_LARGEMAP_KOUREND_3 = 5280;
	public static final int LEAGUE_4_LARGEMAP_KOUREND_4 = 5281;
	public static final int LEAGUE_4_RELICS_MEDIUM_HEADICON = 5390;
	public static final int LEAGUE_4_PROGRESS_BAR_INDICATOR = 5447;
	public static final int LEAGUE_4_MAP_EMPTY = 5448;
	public static final int LEAGUE_4_MAP_MISTHALIN = 5449;
	public static final int LEAGUE_4_MAP_KARAMJA = 5450;
	public static final int LEAGUE_4_MAP_WILDERNESS = 5451;
	public static final int LEAGUE_4_MAP_ASGARNIA = 5452;
	public static final int LEAGUE_4_MAP_KANDARIN = 5453;
	public static final int LEAGUE_4_MAP_DESERT = 5454;
	public static final int LEAGUE_4_MAP_FREMENNIK = 5455;
	public static final int LEAGUE_4_MAP_TIRANNWN = 5456;
	public static final int LEAGUE_4_MAP_MORYTANIA = 5457;
	public static final int LEAGUE_4_MAP_KOUREND = 5458;
	public static final int LEAGUE_4_BLOODTHIRSTY_HEADICON = 5529;
	public static final int MOSSYBRICKS02 = 5530;
	public static final int COBBLESTONE01 = 5601;
	public static final int COBBLESTONE02 = 5602;
	public static final int LEAFY_ACACIA01 = 5603;
	public static final int LEAFY_STONEPINE01 = 5604;
	public static final int STONE_BRICK01 = 5605;
	public static final int STONE_BRICK02 = 5606;
	public static final int WGS_FONT_SCRATCH = 5607;
	public static final int WGS_FONT_SCRATCH_LARGE = 5608;
	public static final int NUMBER_PAD_BACKGROUND = 5650;
	public static final int P12_FULL_MONOSPACE = 5675;
	public static final int P12_FULL_MONOSPACE_CHARACTERS = 5676;
	public static final int COMPASS_OUTLINE = 5813;
	public static final int BORDER_MAP_COMPASS = 5832;
	public static final int LEAGUE_5_MAP_EMPTY = 5865;
	public static final int LEAGUE_5_MAP_MISTHALIN = 5866;
	public static final int LEAGUE_5_MAP_KARAMJA = 5867;
	public static final int LEAGUE_5_MAP_WILDERNESS = 5868;
	public static final int LEAGUE_5_MAP_ASGARNIA = 5869;
	public static final int LEAGUE_5_MAP_KANDARIN = 5870;
	public static final int LEAGUE_5_MAP_DESERT = 5871;
	public static final int LEAGUE_5_MAP_FREMENNIK = 5872;
	public static final int LEAGUE_5_MAP_TIRANNWN = 5873;
	public static final int LEAGUE_5_MAP_MORYTANIA = 5874;
	public static final int LEAGUE_5_MAP_KOUREND = 5875;
	public static final int LEAGUE_5_MAP_VARLAMORE = 5876;
	public static final int LEAGUE_5_RELICS_MEDIUM_HEADICON = 6069;
	public static final int LEAGUE_5_PROGRESS_BAR_INDICATOR = 6126;
	public static final int LEAGUE_5_COMBAT_MASTERY_ICON_MEDIUM = 6283;
	public static final int LEAGUE_5_COMBAT_MASTERY_ICON_LARGE = 6284;
	public static final int LEAGUE_5_COMBAT_MASTERY_HIGHLIGHT_SMALL = 6285;
	public static final int LEAGUE_5_COMBAT_MASTERY_HIGHLIGHT_MEDIUM = 6286;
	public static final int LEAGUE_5_COMBAT_MASTERY_HIGHLIGHT_SMALL_GLOW = 6287;
	public static final int LEAGUE_5_COMBAT_MASTERY_HIGHLIGHT_MEDIUM_GLOW = 6288;
	public static final int LEAGUE_5_LARGEMAP_VARLAMORE_1 = 6295;
	public static final int LEAGUE_5_LARGEMAP_VARLAMORE_2 = 6296;
	public static final int LEAGUE_5_LARGEMAP_VARLAMORE_3 = 6297;
	public static final int LEAGUE_5_LARGEMAP_VARLAMORE_4 = 6298;
	public static final int LEAGUE_5_LARGEMAP_VARLAMORE_5 = 6299;
	public static final int LEAFYTREE_FROSTY = 6313;
	public static final int LEAFYTREE_TILED_FROSTY = 6314;
	public static final int INVISIBLE_FONT = 6315;
	public static final int HEADICONS_ET = 6405;
	public static final int TEXTURE_THATCHED02 = 6408;
	public static final int FARMING_UNDEAD_ICON = 6414;
	public static final int TRADEBACKING_GREEN = 6415;
	public static final int TRADEBACKING_DARK_GREEN = 6416;
	public static final int CLASSIC01_BUTTON_BLUE_DEFAULT_TOP_LEFT = 6449;
	public static final int CLASSIC01_BUTTON_BLUE_DEFAULT_TOP_RIGHT = 6450;
	public static final int CLASSIC01_BUTTON_BLUE_DEFAULT_BOTTOM_LEFT = 6451;
	public static final int CLASSIC01_BUTTON_BLUE_DEFAULT_BOTTOM_RIGHT = 6452;
	public static final int CLASSIC01_BUTTON_BLUE_DEFAULT_LEFT = 6453;
	public static final int CLASSIC01_BUTTON_BLUE_DEFAULT_TOP = 6454;
	public static final int CLASSIC01_BUTTON_BLUE_DEFAULT_RIGHT = 6455;
	public static final int CLASSIC01_BUTTON_BLUE_DEFAULT_BOTTOM = 6456;
	public static final int CLASSIC01_BUTTON_BLUE_DEFAULT_CENTRE = 6457;
	public static final int CLASSIC01_BUTTON_BLUE_MOUSEOVER_TOP_LEFT = 6458;
	public static final int CLASSIC01_BUTTON_BLUE_MOUSEOVER_TOP_RIGHT = 6459;
	public static final int CLASSIC01_BUTTON_BLUE_MOUSEOVER_BOTTOM_LEFT = 6460;
	public static final int CLASSIC01_BUTTON_BLUE_MOUSEOVER_BOTTOM_RIGHT = 6461;
	public static final int CLASSIC01_BUTTON_BLUE_MOUSEOVER_LEFT = 6462;
	public static final int CLASSIC01_BUTTON_BLUE_MOUSEOVER_TOP = 6463;
	public static final int CLASSIC01_BUTTON_BLUE_MOUSEOVER_RIGHT = 6464;
	public static final int CLASSIC01_BUTTON_BLUE_MOUSEOVER_BOTTOM = 6465;
	public static final int CLASSIC01_BUTTON_BLUE_MOUSEOVER_CENTRE = 6466;
	public static final int CLASSIC01_BUTTON_BLUE_PRESSED_TOP_LEFT = 6467;
	public static final int CLASSIC01_BUTTON_BLUE_PRESSED_TOP_RIGHT = 6468;
	public static final int CLASSIC01_BUTTON_BLUE_PRESSED_BOTTOM_LEFT = 6469;
	public static final int CLASSIC01_BUTTON_BLUE_PRESSED_BOTTOM_RIGHT = 6470;
	public static final int CLASSIC01_BUTTON_BLUE_PRESSED_LEFT = 6471;
	public static final int CLASSIC01_BUTTON_BLUE_PRESSED_TOP = 6472;
	public static final int CLASSIC01_BUTTON_BLUE_PRESSED_RIGHT = 6473;
	public static final int CLASSIC01_BUTTON_BLUE_PRESSED_BOTTOM = 6474;
	public static final int CLASSIC01_BUTTON_BLUE_PRESSED_CENTRE = 6475;
	public static final int CLASSIC01_BUTTON_GREEN_DEFAULT_TOP_LEFT = 6476;
	public static final int CLASSIC01_BUTTON_GREEN_DEFAULT_TOP_RIGHT = 6477;
	public static final int CLASSIC01_BUTTON_GREEN_DEFAULT_BOTTOM_LEFT = 6478;
	public static final int CLASSIC01_BUTTON_GREEN_DEFAULT_BOTTOM_RIGHT = 6479;
	public static final int CLASSIC01_BUTTON_GREEN_DEFAULT_LEFT = 6480;
	public static final int CLASSIC01_BUTTON_GREEN_DEFAULT_TOP = 6481;
	public static final int CLASSIC01_BUTTON_GREEN_DEFAULT_RIGHT = 6482;
	public static final int CLASSIC01_BUTTON_GREEN_DEFAULT_BOTTOM = 6483;
	public static final int CLASSIC01_BUTTON_GREEN_DEFAULT_CENTRE = 6484;
	public static final int CLASSIC01_BUTTON_GREEN_MOUSEOVER_TOP_LEFT = 6485;
	public static final int CLASSIC01_BUTTON_GREEN_MOUSEOVER_TOP_RIGHT = 6486;
	public static final int CLASSIC01_BUTTON_GREEN_MOUSEOVER_BOTTOM_LEFT = 6487;
	public static final int CLASSIC01_BUTTON_GREEN_MOUSEOVER_BOTTOM_RIGHT = 6488;
	public static final int CLASSIC01_BUTTON_GREEN_MOUSEOVER_LEFT = 6489;
	public static final int CLASSIC01_BUTTON_GREEN_MOUSEOVER_TOP = 6490;
	public static final int CLASSIC01_BUTTON_GREEN_MOUSEOVER_RIGHT = 6491;
	public static final int CLASSIC01_BUTTON_GREEN_MOUSEOVER_BOTTOM = 6492;
	public static final int CLASSIC01_BUTTON_GREEN_MOUSEOVER_CENTRE = 6493;
	public static final int CLASSIC01_BUTTON_GREEN_PRESSED_TOP_LEFT = 6494;
	public static final int CLASSIC01_BUTTON_GREEN_PRESSED_TOP_RIGHT = 6495;
	public static final int CLASSIC01_BUTTON_GREEN_PRESSED_BOTTOM_LEFT = 6496;
	public static final int CLASSIC01_BUTTON_GREEN_PRESSED_BOTTOM_RIGHT = 6497;
	public static final int CLASSIC01_BUTTON_GREEN_PRESSED_LEFT = 6498;
	public static final int CLASSIC01_BUTTON_GREEN_PRESSED_TOP = 6499;
	public static final int CLASSIC01_BUTTON_GREEN_PRESSED_RIGHT = 6500;
	public static final int CLASSIC01_BUTTON_GREEN_PRESSED_BOTTOM = 6501;
	public static final int CLASSIC01_BUTTON_GREEN_PRESSED_CENTRE = 6502;
	public static final int CLASSIC01_BUTTON_YELLOW_DEFAULT_TOP_LEFT = 6503;
	public static final int CLASSIC01_BUTTON_YELLOW_DEFAULT_TOP_RIGHT = 6504;
	public static final int CLASSIC01_BUTTON_YELLOW_DEFAULT_BOTTOM_LEFT = 6505;
	public static final int CLASSIC01_BUTTON_YELLOW_DEFAULT_BOTTOM_RIGHT = 6506;
	public static final int CLASSIC01_BUTTON_YELLOW_DEFAULT_LEFT = 6507;
	public static final int CLASSIC01_BUTTON_YELLOW_DEFAULT_TOP = 6508;
	public static final int CLASSIC01_BUTTON_YELLOW_DEFAULT_RIGHT = 6509;
	public static final int CLASSIC01_BUTTON_YELLOW_DEFAULT_BOTTOM = 6510;
	public static final int CLASSIC01_BUTTON_YELLOW_DEFAULT_CENTRE = 6511;
	public static final int CLASSIC01_BUTTON_YELLOW_MOUSEOVER_TOP_LEFT = 6512;
	public static final int CLASSIC01_BUTTON_YELLOW_MOUSEOVER_TOP_RIGHT = 6513;
	public static final int CLASSIC01_BUTTON_YELLOW_MOUSEOVER_BOTTOM_LEFT = 6514;
	public static final int CLASSIC01_BUTTON_YELLOW_MOUSEOVER_BOTTOM_RIGHT = 6515;
	public static final int CLASSIC01_BUTTON_YELLOW_MOUSEOVER_LEFT = 6516;
	public static final int CLASSIC01_BUTTON_YELLOW_MOUSEOVER_TOP = 6517;
	public static final int CLASSIC01_BUTTON_YELLOW_MOUSEOVER_RIGHT = 6518;
	public static final int CLASSIC01_BUTTON_YELLOW_MOUSEOVER_BOTTOM = 6519;
	public static final int CLASSIC01_BUTTON_YELLOW_MOUSEOVER_CENTRE = 6520;
	public static final int CLASSIC01_BUTTON_YELLOW_PRESSED_TOP_LEFT = 6521;
	public static final int CLASSIC01_BUTTON_YELLOW_PRESSED_TOP_RIGHT = 6522;
	public static final int CLASSIC01_BUTTON_YELLOW_PRESSED_BOTTOM_LEFT = 6523;
	public static final int CLASSIC01_BUTTON_YELLOW_PRESSED_BOTTOM_RIGHT = 6524;
	public static final int CLASSIC01_BUTTON_YELLOW_PRESSED_LEFT = 6525;
	public static final int CLASSIC01_BUTTON_YELLOW_PRESSED_TOP = 6526;
	public static final int CLASSIC01_BUTTON_YELLOW_PRESSED_RIGHT = 6527;
	public static final int CLASSIC01_BUTTON_YELLOW_PRESSED_BOTTOM = 6528;
	public static final int CLASSIC01_BUTTON_YELLOW_PRESSED_CENTRE = 6529;
	public static final int CLASSIC01_BUTTON_RED_DEFAULT_TOP_LEFT = 6530;
	public static final int CLASSIC01_BUTTON_RED_DEFAULT_TOP_RIGHT = 6531;
	public static final int CLASSIC01_BUTTON_RED_DEFAULT_BOTTOM_LEFT = 6532;
	public static final int CLASSIC01_BUTTON_RED_DEFAULT_BOTTOM_RIGHT = 6533;
	public static final int CLASSIC01_BUTTON_RED_DEFAULT_LEFT = 6534;
	public static final int CLASSIC01_BUTTON_RED_DEFAULT_TOP = 6535;
	public static final int CLASSIC01_BUTTON_RED_DEFAULT_RIGHT = 6536;
	public static final int CLASSIC01_BUTTON_RED_DEFAULT_BOTTOM = 6537;
	public static final int CLASSIC01_BUTTON_RED_DEFAULT_CENTRE = 6538;
	public static final int CLASSIC01_BUTTON_RED_MOUSEOVER_TOP_LEFT = 6539;
	public static final int CLASSIC01_BUTTON_RED_MOUSEOVER_TOP_RIGHT = 6540;
	public static final int CLASSIC01_BUTTON_RED_MOUSEOVER_BOTTOM_LEFT = 6541;
	public static final int CLASSIC01_BUTTON_RED_MOUSEOVER_BOTTOM_RIGHT = 6542;
	public static final int CLASSIC01_BUTTON_RED_MOUSEOVER_LEFT = 6543;
	public static final int CLASSIC01_BUTTON_RED_MOUSEOVER_TOP = 6544;
	public static final int CLASSIC01_BUTTON_RED_MOUSEOVER_RIGHT = 6545;
	public static final int CLASSIC01_BUTTON_RED_MOUSEOVER_BOTTOM = 6546;
	public static final int CLASSIC01_BUTTON_RED_MOUSEOVER_CENTRE = 6547;
	public static final int CLASSIC01_BUTTON_RED_PRESSED_TOP_LEFT = 6548;
	public static final int CLASSIC01_BUTTON_RED_PRESSED_TOP_RIGHT = 6549;
	public static final int CLASSIC01_BUTTON_RED_PRESSED_BOTTOM_LEFT = 6550;
	public static final int CLASSIC01_BUTTON_RED_PRESSED_BOTTOM_RIGHT = 6551;
	public static final int CLASSIC01_BUTTON_RED_PRESSED_LEFT = 6552;
	public static final int CLASSIC01_BUTTON_RED_PRESSED_TOP = 6553;
	public static final int CLASSIC01_BUTTON_RED_PRESSED_RIGHT = 6554;
	public static final int CLASSIC01_BUTTON_RED_PRESSED_BOTTOM = 6555;
	public static final int CLASSIC01_BUTTON_RED_PRESSED_CENTRE = 6556;
	public static final int CLASSIC02_BUTTON_BLUE_DEFAULT_TOP_LEFT = 6557;
	public static final int CLASSIC02_BUTTON_BLUE_DEFAULT_TOP_RIGHT = 6558;
	public static final int CLASSIC02_BUTTON_BLUE_DEFAULT_BOTTOM_LEFT = 6559;
	public static final int CLASSIC02_BUTTON_BLUE_DEFAULT_BOTTOM_RIGHT = 6560;
	public static final int CLASSIC02_BUTTON_BLUE_DEFAULT_LEFT = 6561;
	public static final int CLASSIC02_BUTTON_BLUE_DEFAULT_TOP = 6562;
	public static final int CLASSIC02_BUTTON_BLUE_DEFAULT_RIGHT = 6563;
	public static final int CLASSIC02_BUTTON_BLUE_DEFAULT_BOTTOM = 6564;
	public static final int CLASSIC02_BUTTON_BLUE_DEFAULT_CENTRE = 6565;
	public static final int CLASSIC02_BUTTON_BLUE_MOUSEOVER_TOP_LEFT = 6566;
	public static final int CLASSIC02_BUTTON_BLUE_MOUSEOVER_TOP_RIGHT = 6567;
	public static final int CLASSIC02_BUTTON_BLUE_MOUSEOVER_BOTTOM_LEFT = 6568;
	public static final int CLASSIC02_BUTTON_BLUE_MOUSEOVER_BOTTOM_RIGHT = 6569;
	public static final int CLASSIC02_BUTTON_BLUE_MOUSEOVER_LEFT = 6570;
	public static final int CLASSIC02_BUTTON_BLUE_MOUSEOVER_TOP = 6571;
	public static final int CLASSIC02_BUTTON_BLUE_MOUSEOVER_RIGHT = 6572;
	public static final int CLASSIC02_BUTTON_BLUE_MOUSEOVER_BOTTOM = 6573;
	public static final int CLASSIC02_BUTTON_BLUE_MOUSEOVER_CENTRE = 6574;
	public static final int CLASSIC02_BUTTON_BLUE_PRESSED_TOP_LEFT = 6575;
	public static final int CLASSIC02_BUTTON_BLUE_PRESSED_TOP_RIGHT = 6576;
	public static final int CLASSIC02_BUTTON_BLUE_PRESSED_BOTTOM_LEFT = 6577;
	public static final int CLASSIC02_BUTTON_BLUE_PRESSED_BOTTOM_RIGHT = 6578;
	public static final int CLASSIC02_BUTTON_BLUE_PRESSED_LEFT = 6579;
	public static final int CLASSIC02_BUTTON_BLUE_PRESSED_TOP = 6580;
	public static final int CLASSIC02_BUTTON_BLUE_PRESSED_RIGHT = 6581;
	public static final int CLASSIC02_BUTTON_BLUE_PRESSED_BOTTOM = 6582;
	public static final int CLASSIC02_BUTTON_BLUE_PRESSED_CENTRE = 6583;
	public static final int CLASSIC02_BUTTON_GREEN_DEFAULT_TOP_LEFT = 6584;
	public static final int CLASSIC02_BUTTON_GREEN_DEFAULT_TOP_RIGHT = 6585;
	public static final int CLASSIC02_BUTTON_GREEN_DEFAULT_BOTTOM_LEFT = 6586;
	public static final int CLASSIC02_BUTTON_GREEN_DEFAULT_BOTTOM_RIGHT = 6587;
	public static final int CLASSIC02_BUTTON_GREEN_DEFAULT_LEFT = 6588;
	public static final int CLASSIC02_BUTTON_GREEN_DEFAULT_TOP = 6589;
	public static final int CLASSIC02_BUTTON_GREEN_DEFAULT_RIGHT = 6590;
	public static final int CLASSIC02_BUTTON_GREEN_DEFAULT_BOTTOM = 6591;
	public static final int CLASSIC02_BUTTON_GREEN_DEFAULT_CENTRE = 6592;
	public static final int CLASSIC02_BUTTON_GREEN_MOUSEOVER_TOP_LEFT = 6593;
	public static final int CLASSIC02_BUTTON_GREEN_MOUSEOVER_TOP_RIGHT = 6594;
	public static final int CLASSIC02_BUTTON_GREEN_MOUSEOVER_BOTTOM_LEFT = 6595;
	public static final int CLASSIC02_BUTTON_GREEN_MOUSEOVER_BOTTOM_RIGHT = 6596;
	public static final int CLASSIC02_BUTTON_GREEN_MOUSEOVER_LEFT = 6597;
	public static final int CLASSIC02_BUTTON_GREEN_MOUSEOVER_TOP = 6598;
	public static final int CLASSIC02_BUTTON_GREEN_MOUSEOVER_RIGHT = 6599;
	public static final int CLASSIC02_BUTTON_GREEN_MOUSEOVER_BOTTOM = 6600;
	public static final int CLASSIC02_BUTTON_GREEN_MOUSEOVER_CENTRE = 6601;
	public static final int CLASSIC02_BUTTON_GREEN_PRESSED_TOP_LEFT = 6602;
	public static final int CLASSIC02_BUTTON_GREEN_PRESSED_TOP_RIGHT = 6603;
	public static final int CLASSIC02_BUTTON_GREEN_PRESSED_BOTTOM_LEFT = 6604;
	public static final int CLASSIC02_BUTTON_GREEN_PRESSED_BOTTOM_RIGHT = 6605;
	public static final int CLASSIC02_BUTTON_GREEN_PRESSED_LEFT = 6606;
	public static final int CLASSIC02_BUTTON_GREEN_PRESSED_TOP = 6607;
	public static final int CLASSIC02_BUTTON_GREEN_PRESSED_RIGHT = 6608;
	public static final int CLASSIC02_BUTTON_GREEN_PRESSED_BOTTOM = 6609;
	public static final int CLASSIC02_BUTTON_GREEN_PRESSED_CENTRE = 6610;
	public static final int MASTERY_BINGO01_28X28 = 6751;
	public static final int MASTERY_BINGO01_56X56 = 6752;
	public static final int SIMPLE_BUTTON_DEFAULT_TOP_LEFT = 6765;
	public static final int SIMPLE_BUTTON_DEFAULT_TOP_RIGHT = 6766;
	public static final int SIMPLE_BUTTON_DEFAULT_BOTTOM_LEFT = 6767;
	public static final int SIMPLE_BUTTON_DEFAULT_BOTTOM_RIGHT = 6768;
	public static final int SIMPLE_BUTTON_DEFAULT_LEFT = 6769;
	public static final int SIMPLE_BUTTON_DEFAULT_TOP = 6770;
	public static final int SIMPLE_BUTTON_DEFAULT_RIGHT = 6771;
	public static final int SIMPLE_BUTTON_DEFAULT_BOTTOM = 6772;
	public static final int SIMPLE_BUTTON_DEFAULT_CENTRE = 6773;
	public static final int SIMPLE_BUTTON_MOUSEOVER_CENTRE = 6774;
	public static final int SIMPLE_BUTTON_TOGGLED_TOP_LEFT = 6775;
	public static final int SIMPLE_BUTTON_TOGGLED_TOP_RIGHT = 6776;
	public static final int SIMPLE_BUTTON_TOGGLED_BOTTOM_LEFT = 6777;
	public static final int SIMPLE_BUTTON_TOGGLED_BOTTOM_RIGHT = 6778;
	public static final int SIMPLE_BUTTON_TOGGLED_LEFT = 6779;
	public static final int SIMPLE_BUTTON_TOGGLED_TOP = 6780;
	public static final int SIMPLE_BUTTON_TOGGLED_RIGHT = 6781;
	public static final int SIMPLE_BUTTON_TOGGLED_BOTTOM = 6782;
	public static final int SIMPLE_BUTTON_TOGGLED_CENTRE = 6783;
	public static final int SIMPLE_BUTTON_TOGGLED_MOUSEOVER_CENTRE = 6784;
	public static final int SIMPLE_BUTTON_PRESSED_CENTRE = 6785;
	public static final int LOGO_UGC_WORLD = 6786;

	public static final class _2XStandardSpellsOn
	{
		public static final int _0 = 0;
		public static final int _1 = 1;
		public static final int _2 = 2;
		public static final int _3 = 3;
		public static final int _4 = 5;
		public static final int _5 = 6;
		public static final int _6 = 7;
		public static final int _7 = 8;
		public static final int _8 = 9;
		public static final int _9 = 10;
		public static final int _10 = 11;
		public static final int _11 = 13;
		public static final int _12 = 14;
		public static final int _13 = 305;
		public static final int _14 = 306;
		public static final int _15 = 307;
		public static final int _16 = 1098;
		public static final int _17 = 1099;
		public static final int _18 = 1100;
		public static final int _19 = 1751;
		public static final int _20 = 1752;
		public static final int _21 = 1753;
		public static final int _22 = 1754;
		public static final int _23 = 1755;
		public static final int _24 = 1756;
		public static final int _25 = 1757;
		public static final int _26 = 1758;
		public static final int _27 = 1759;
		public static final int _28 = 1760;
		public static final int _29 = 1761;
		public static final int _30 = 1762;
		public static final int _31 = 1763;
		public static final int _32 = 1764;
		public static final int _33 = 1765;
		public static final int _34 = 1766;
		public static final int _35 = 1767;
		public static final int _36 = 1768;
		public static final int _37 = 1769;
		public static final int _38 = 1770;
		public static final int _39 = 1771;
		public static final int _40 = 1772;
		public static final int _41 = 1773;
		public static final int _42 = 1774;
		public static final int _43 = 1775;
		public static final int _44 = 1776;
		public static final int _45 = 1777;
		public static final int _46 = 1778;
		public static final int _47 = 1779;
		public static final int _48 = 1780;
		public static final int _49 = 1781;
		public static final int _50 = 1782;
		public static final int _51 = 1783;
		public static final int _52 = 1784;
		public static final int _53 = 1785;
		public static final int _54 = 1786;
		public static final int _55 = 1787;
		public static final int _56 = 1788;
		public static final int _57 = 1789;
		public static final int _58 = 1790;
		public static final int _59 = 1791;
		public static final int _60 = 1792;
		public static final int _61 = 1793;
		public static final int _62 = 1794;
		public static final int _63 = 1795;
		public static final int _64 = 1796;
		public static final int _65 = 1797;
		public static final int _66 = 1798;
		public static final int _67 = 1799;
		public static final int _68 = 1800;
		public static final int _69 = 1801;
		public static final int _70 = 1802;
		public static final int _71 = 1803;
		public static final int _72 = 1804;
		public static final int _73 = 1805;
		public static final int _74 = 1806;
		public static final int _75 = 1807;
		public static final int _76 = 1808;
		public static final int _77 = 1809;
		public static final int _78 = 1810;
		public static final int _79 = 1811;
	}

	public static final class Magicon
	{
		public static final int _0 = 15;
		public static final int _1 = 16;
		public static final int _2 = 17;
		public static final int _3 = 18;
		public static final int _4 = 19;
		public static final int _5 = 20;
		public static final int _6 = 21;
		public static final int _7 = 22;
		public static final int _8 = 23;
		public static final int _9 = 24;
		public static final int _10 = 25;
		public static final int _11 = 26;
		public static final int _12 = 27;
		public static final int _13 = 28;
		public static final int _14 = 29;
		public static final int _15 = 30;
		public static final int _16 = 31;
		public static final int _17 = 32;
		public static final int _18 = 33;
		public static final int _19 = 34;
		public static final int _20 = 35;
		public static final int _21 = 36;
		public static final int _22 = 37;
		public static final int _23 = 38;
		public static final int _24 = 39;
		public static final int _25 = 40;
		public static final int _26 = 41;
		public static final int _27 = 42;
		public static final int _28 = 43;
		public static final int _29 = 44;
		public static final int _30 = 45;
		public static final int _31 = 46;
		public static final int _32 = 47;
		public static final int _33 = 48;
		public static final int _34 = 49;
		public static final int _35 = 50;
		public static final int _36 = 51;
		public static final int _37 = 52;
		public static final int _38 = 53;
		public static final int _39 = 54;
		public static final int _40 = 55;
		public static final int _41 = 56;
		public static final int _42 = 57;
		public static final int _43 = 58;
		public static final int _44 = 59;
		public static final int _45 = 60;
		public static final int _46 = 61;
		public static final int _47 = 62;
		public static final int _48 = 63;
		public static final int _49 = 64;

		public static final int WIND_STRIKE = _0;
		public static final int CONFUSE = _1;
		public static final int WATER_STRIKE = _2;
		public static final int LVL_1_ENCHANT = _3;
		public static final int EARTH_STRIKE = _4;
		public static final int WEAKEN = _5;
		public static final int FIRE_STRIKE = _6;
		public static final int BONES_TO_BANANAS = _7;
		public static final int WIND_BOLT = _8;
		public static final int CURSE = _9;
		public static final int LOW_LEVEL_ALCHEMY = _10;
		public static final int WATER_BOLT = _11;
		public static final int VARROCK_TELEPORT = _12;
		public static final int LVL_2_ENCHANT = _13;
		public static final int EARTH_BOLT = _14;
		public static final int LUMBRIDGE_TELEPORT = _15;
		public static final int TELEKINETIC_GRAB = _16;
		public static final int FIRE_BOLT = _17;
		public static final int FALADOR_TELEPORT = _18;
		public static final int CRUMBLE_UNDEAD = _19;
		public static final int WIND_BLAST = _20;
		public static final int SUPERHEAT_ITEM = _21;
		public static final int CAMELOT_TELEPORT = _22;
		public static final int WATER_BLAST = _23;
		public static final int LVL_3_ENCHANT = _24;
		public static final int EARTH_BLAST = _25;
		public static final int HIGH_LEVEL_ALCHEMY = _26;
		public static final int CHARGE_WATER_ORB = _27;
		public static final int LVL_4_ENCHANT = _28;
		public static final int FIRE_BLAST = _29;
		public static final int CHARGE_EARTH_ORB = _30;
		public static final int WIND_WAVE = _31;
		public static final int CHARGE_FIRE_ORB = _32;
		public static final int WATER_WAVE = _33;
		public static final int CHARGE_AIR_ORB = _34;
		public static final int LVL_5_ENCHANT = _35;
		public static final int EARTH_WAVE = _36;
		public static final int FIRE_WAVE = _37;
		public static final int IBAN_BLAST = _38;
		public static final int ARDOUGNE_TELEPORT = _39;
		public static final int WATCHTOWER_TELEPORT = _40;
		public static final int VULNERABILITY = _41;
		public static final int ENFEEBLE = _42;
		public static final int STUN = _43;
		public static final int FLAMES_OF_ZAMORAK = _44;
		public static final int CLAWS_OF_GUTHIX = _45;
		public static final int SARADOMIN_STRIKE = _46;
		public static final int CALL_ANIMAL = _47;
		public static final int RAISE_SKELETON = _48;
		public static final int SUMMON_DEMON = _49;
	}

	public static final class Magicoff
	{
		public static final int _0 = 65;
		public static final int _1 = 66;
		public static final int _2 = 67;
		public static final int _3 = 68;
		public static final int _4 = 69;
		public static final int _5 = 70;
		public static final int _6 = 71;
		public static final int _7 = 72;
		public static final int _8 = 73;
		public static final int _9 = 74;
		public static final int _10 = 75;
		public static final int _11 = 76;
		public static final int _12 = 77;
		public static final int _13 = 78;
		public static final int _14 = 79;
		public static final int _15 = 80;
		public static final int _16 = 81;
		public static final int _17 = 82;
		public static final int _18 = 83;
		public static final int _19 = 84;
		public static final int _20 = 85;
		public static final int _21 = 86;
		public static final int _22 = 87;
		public static final int _23 = 88;
		public static final int _24 = 89;
		public static final int _25 = 90;
		public static final int _26 = 91;
		public static final int _27 = 92;
		public static final int _28 = 93;
		public static final int _29 = 94;
		public static final int _30 = 95;
		public static final int _31 = 96;
		public static final int _32 = 97;
		public static final int _33 = 98;
		public static final int _34 = 99;
		public static final int _35 = 100;
		public static final int _36 = 101;
		public static final int _37 = 102;
		public static final int _38 = 103;
		public static final int _39 = 104;
		public static final int _40 = 105;
		public static final int _41 = 106;
		public static final int _42 = 107;
		public static final int _43 = 108;
		public static final int _44 = 109;
		public static final int _45 = 110;
		public static final int _46 = 111;
		public static final int _47 = 112;
		public static final int _48 = 113;
		public static final int _49 = 114;

		public static final int WIND_STRIKE = _0;
		public static final int CONFUSE = _1;
		public static final int WATER_STRIKE = _2;
		public static final int LVL_1_ENCHANT = _3;
		public static final int EARTH_STRIKE = _4;
		public static final int WEAKEN = _5;
		public static final int FIRE_STRIKE = _6;
		public static final int BONES_TO_BANANAS = _7;
		public static final int WIND_BOLT = _8;
		public static final int CURSE = _9;
		public static final int LOW_LEVEL_ALCHEMY = _10;
		public static final int WATER_BOLT = _11;
		public static final int VARROCK_TELEPORT = _12;
		public static final int LVL_2_ENCHANT = _13;
		public static final int EARTH_BOLT = _14;
		public static final int LUMBRIDGE_TELEPORT = _15;
		public static final int TELEKINETIC_GRAB = _16;
		public static final int FIRE_BOLT = _17;
		public static final int FALADOR_TELEPORT = _18;
		public static final int CRUMBLE_UNDEAD = _19;
		public static final int WIND_BLAST = _20;
		public static final int SUPERHEAT_ITEM = _21;
		public static final int CAMELOT_TELEPORT = _22;
		public static final int WATER_BLAST = _23;
		public static final int LVL_3_ENCHANT = _24;
		public static final int EARTH_BLAST = _25;
		public static final int HIGH_LEVEL_ALCHEMY = _26;
		public static final int CHARGE_WATER_ORB = _27;
		public static final int LVL_4_ENCHANT = _28;
		public static final int FIRE_BLAST = _29;
		public static final int CHARGE_EARTH_ORB = _30;
		public static final int WIND_WAVE = _31;
		public static final int CHARGE_FIRE_ORB = _32;
		public static final int WATER_WAVE = _33;
		public static final int CHARGE_AIR_ORB = _34;
		public static final int LVL_5_ENCHANT = _35;
		public static final int EARTH_WAVE = _36;
		public static final int FIRE_WAVE = _37;
		public static final int IBAN_BLAST = _38;
		public static final int ARDOUGNE_TELEPORT = _39;
		public static final int WATCHTOWER_TELEPORT = _40;
		public static final int VULNERABILITY = _41;
		public static final int ENFEEBLE = _42;
		public static final int STUN = _43;
		public static final int FLAMES_OF_ZAMORAK = _44;
		public static final int CLAWS_OF_GUTHIX = _45;
		public static final int SARADOMIN_STRIKE = _46;
		public static final int CALL_ANIMAL = _47;
		public static final int RAISE_SKELETON = _48;
		public static final int SUMMON_DEMON = _49;
	}

	public static final class Prayeron
	{
		public static final int _0 = 115;
		public static final int _1 = 116;
		public static final int _2 = 117;
		public static final int _3 = 118;
		public static final int _4 = 119;
		public static final int _5 = 120;
		public static final int _6 = 121;
		public static final int _7 = 122;
		public static final int _8 = 123;
		public static final int _9 = 124;
		public static final int _10 = 125;
		public static final int _11 = 126;
		public static final int _12 = 127;
		public static final int _13 = 128;
		public static final int _14 = 129;
		public static final int _15 = 130;
		public static final int _16 = 131;
		public static final int _17 = 132;
		public static final int _18 = 133;
		public static final int _19 = 134;
		public static final int _20 = 502;
		public static final int _21 = 503;
		public static final int _22 = 504;
		public static final int _23 = 505;
		public static final int _24 = 944;
		public static final int _25 = 945;
		public static final int _26 = 946;
		public static final int _27 = 947;
		public static final int _28 = 1420;
		public static final int _29 = 1421;
		public static final int _30 = 1422;
		public static final int _31 = 1423;

		public static final int THICK_SKIN = _0;
		public static final int BURST_OF_STRENGTH = _1;
		public static final int CLARITY_OF_THOUGHT = _2;
		public static final int ROCK_SKIN = _3;
		public static final int SUPERHUMAN_STRENGTH = _4;
		public static final int IMPROVED_REFLEXES = _5;
		public static final int RAPID_RESTORE = _6;
		public static final int RAPID_HEAL = _7;
		public static final int PROTECT_ITEM = _8;
		public static final int STEEL_SKIN = _9;
		public static final int ULTIMATE_STRENGTH = _10;
		public static final int INCREDIBLE_REFLEXES = _11;
		public static final int PROTECT_FROM_MAGIC = _12;
		public static final int PROTECT_FROM_MISSILES = _13;
		public static final int PROTECT_FROM_MELEE = _14;
		public static final int REDEMPTION = _15;
		public static final int RETRIBUTION = _16;
		public static final int SMITE = _17;
		public static final int SHARP_EYE = _18;
		public static final int MYSTIC_WILL = _19;
		public static final int HAWK_EYE = _20;
		public static final int MYSTIC_LORE = _21;
		public static final int EAGLE_EYE = _22;
		public static final int MYSTIC_MIGHT = _23;
		public static final int PROTECT_FROM_SUMMONING = _24;
		public static final int CHIVALRY = _25;
		public static final int PIETY = _26;
		public static final int PRESERVE = _27;
		public static final int RIGOUR = _28;
		public static final int AUGURY = _29;
		public static final int DEADEYE = _30;
		public static final int MYSTIC_VIGOUR = _31;
	}

	public static final class Prayeroff
	{
		public static final int _0 = 135;
		public static final int _1 = 136;
		public static final int _2 = 137;
		public static final int _3 = 138;
		public static final int _4 = 139;
		public static final int _5 = 140;
		public static final int _6 = 141;
		public static final int _7 = 142;
		public static final int _8 = 143;
		public static final int _9 = 144;
		public static final int _10 = 145;
		public static final int _11 = 146;
		public static final int _12 = 147;
		public static final int _13 = 148;
		public static final int _14 = 149;
		public static final int _15 = 150;
		public static final int _16 = 151;
		public static final int _17 = 152;
		public static final int _18 = 153;
		public static final int _19 = 154;
		public static final int _20 = 506;
		public static final int _21 = 507;
		public static final int _22 = 508;
		public static final int _23 = 509;
		public static final int _24 = 948;
		public static final int _25 = 949;
		public static final int _26 = 950;
		public static final int _27 = 951;
		public static final int _28 = 1424;
		public static final int _29 = 1425;
		public static final int _30 = 1426;
		public static final int _31 = 1427;

		public static final int THICK_SKIN_DISABLED = _0;
		public static final int BURST_OF_STRENGTH_DISABLED = _1;
		public static final int CLARITY_OF_THOUGHT_DISABLED = _2;
		public static final int ROCK_SKIN_DISABLED = _3;
		public static final int SUPERHUMAN_STRENGTH_DISABLED = _4;
		public static final int IMPROVED_REFLEXES_DISABLED = _5;
		public static final int RAPID_RESTORE_DISABLED = _6;
		public static final int RAPID_HEAL_DISABLED = _7;
		public static final int PROTECT_ITEM_DISABLED = _8;
		public static final int STEEL_SKIN_DISABLED = _9;
		public static final int ULTIMATE_STRENGTH_DISABLED = _10;
		public static final int INCREDIBLE_REFLEXES_DISABLED = _11;
		public static final int PROTECT_FROM_MAGIC_DISABLED = _12;
		public static final int PROTECT_FROM_MISSILES_DISABLED = _13;
		public static final int PROTECT_FROM_MELEE_DISABLED = _14;
		public static final int REDEMPTION_DISABLED = _15;
		public static final int RETRIBUTION_DISABLED = _16;
		public static final int SMITE_DISABLED = _17;
		public static final int SHARP_EYE_DISABLED = _18;
		public static final int MYSTIC_WILL_DISABLED = _19;
		public static final int HAWK_EYE_DISABLED = _20;
		public static final int MYSTIC_LORE_DISABLED = _21;
		public static final int EAGLE_EYE_DISABLED = _22;
		public static final int MYSTIC_MIGHT_DISABLED = _23;
		public static final int PROTECT_FROM_SUMMONING_DISABLED = _24;
		public static final int CHIVALRY_DISABLED = _25;
		public static final int PIETY_DISABLED = _26;
		public static final int PRESERVE_DISABLED = _27;
		public static final int RIGOUR_DISABLED = _28;
		public static final int AUGURY_DISABLED = _29;
		public static final int DEADEYE_DISABLED = _30;
		public static final int MYSTIC_VIGOUR_DISABLED = _31;
	}

	public static final class GeItembackdrop
	{
		public static final int _2 = 155;
		public static final int _0 = 1120;
		public static final int _1 = 1121;

		public static final int BOX = _0;
		public static final int GLOWING = _1;
	}

	public static final class Wornicons
	{
		public static final int _0 = 156;
		public static final int _1 = 157;
		public static final int _2 = 158;
		public static final int _3 = 159;
		public static final int _4 = 160;
		public static final int _5 = 161;
		public static final int _6 = 162;
		public static final int _7 = 163;
		public static final int _8 = 164;
		public static final int _9 = 165;
		public static final int _10 = 166;
		public static final int _11 = 167;

		public static final int HEAD = _0;
		public static final int CAPE = _1;
		public static final int NECK = _2;
		public static final int WEAPON = _3;
		public static final int RING = _4;
		public static final int TORSO = _5;
		public static final int SHIELD = _6;
		public static final int LEGS = _7;
		public static final int HANDS = _8;
		public static final int FEET = _9;
		public static final int AMMUNITION = _10;
	}

	public static final class SideIcons
	{
		public static final int _0 = 168;
		public static final int _1 = 898;
		public static final int _2 = 899;
		public static final int _3 = 900;
		public static final int _4 = 901;
		public static final int _5 = 902;
		public static final int _6 = 903;
		public static final int _7 = 904;
		public static final int _8 = 905;
		public static final int _9 = 906;
		public static final int _10 = 907;
		public static final int _11 = 908;
		public static final int _12 = 909;
		public static final int _13 = 910;
		public static final int _14 = 1055;
		public static final int _15 = 1056;
		public static final int _16 = 1298;
		public static final int _17 = 1413;
		public static final int _18 = 1579;
		public static final int _19 = 1580;
		public static final int _20 = 1581;
		public static final int _21 = 1708;
		public static final int _22 = 1709;
		public static final int _23 = 1710;
		public static final int _24 = 2295;
		public static final int _25 = 2296;
		public static final int _26 = 2297;
		public static final int _27 = 2298;
		public static final int _28 = 2299;
		public static final int _29 = 2300;
		public static final int _30 = 2301;
		public static final int _31 = 2302;
		public static final int _32 = 3553;
		public static final int _33 = 3554;
		public static final int _34 = 3555;
		public static final int _35 = 3556;
		public static final int _36 = 3557;
		public static final int _37 = 3558;
		public static final int _38 = 3559;
		public static final int _39 = 3560;
		public static final int _40 = 4794;
		public static final int _41 = 4795;
		public static final int _42 = 4796;
		public static final int _43 = 4797;
		public static final int _44 = 4798;
		public static final int _45 = 4799;
		public static final int _46 = 4800;
		public static final int _47 = 4801;
		public static final int _48 = 4802;
		public static final int _49 = 4803;
		public static final int _50 = 4804;
		public static final int _51 = 4805;
		public static final int _52 = 4806;
		public static final int _53 = 4807;
		public static final int _54 = 4808;
		public static final int _55 = 4809;
		public static final int _56 = 4810;
		public static final int _57 = 4811;
		public static final int _58 = 4812;
		public static final int _59 = 4813;
		public static final int _60 = 4814;
		public static final int _61 = 4815;
		public static final int _62 = 4816;
		public static final int _63 = 4817;
		public static final int _64 = 5797;
		public static final int _65 = 5798;
		public static final int _66 = 5799;
		public static final int _67 = 5800;
		public static final int _68 = 5801;
		public static final int _69 = 5802;
		public static final int _70 = 5803;
		public static final int _71 = 5804;

		public static final int COMBAT = _0;
		public static final int STATS = _1;
		public static final int QUEST = _2;
		public static final int INVENTORY = _3;
		public static final int EQUIPMENT = _4;
		public static final int MAGIC = _6;
		public static final int FRIENDS_CHAT = _7;
		public static final int LOGOUT = _10;
		public static final int OPTIONS = _11;
		public static final int EMOTES = _12;
		public static final int MUSIC = _13;
		public static final int HOUSE = _14;
		public static final int MINIGAMES = _15;
		public static final int ACHIEVEMENT_DIARIES = _16;
		public static final int KOUREND = _17;
		public static final int RAIDING_PARTY = _18;
		public static final int SPELLBOOK_ANCIENT_MAGICKS = _19;
		public static final int SPELLBOOK_LUNAR = _20;
		public static final int SPELLBOOK_ARCEUUS = _21;
	}

	public static final class Miscgraphics
	{
		public static final int _0 = 170;
		public static final int _1 = 171;
		public static final int _2 = 172;
		public static final int _3 = 173;
		public static final int _4 = 174;
		public static final int _5 = 175;
		public static final int _6 = 176;
		public static final int _7 = 177;
		public static final int _8 = 178;
		public static final int _9 = 179;
		public static final int _10 = 180;
		public static final int _11 = 181;
		public static final int _12 = 182;
		public static final int _13 = 183;
		public static final int _14 = 184;

		public static final int EQUIPMENT_SLOT_TILE = _0;
		public static final int IRON_RIVETS_SQUARE = _1;
		public static final int IRON_RIVETS_VERTICAL = _2;
		public static final int IRON_RIVETS_HORIZONTAL = _3;
		public static final int STATS_TILE_HALF_LEFT = _4;
		public static final int STATS_TILE_HALF_RIGHT_WITH_SLASH = _5;
		public static final int STATS_TILE_HALF_RIGHT = _6;
		public static final int STATS_TILE_HALF_LEFT_SELECTED = _7;
		public static final int STATS_TILE_HALF_RIGHT_SELECTED = _8;
		public static final int EQUIPMENT_SLOT_SELECTED = _9;
		public static final int PURO_PURO_ROUND_CHECK_BOX = _10;
		public static final int PURO_PURO_ROUND_CHECK_BOX_CHECKED_RED = _11;
		public static final int STATS_TILE_HALF_RIGHT_WITH_SLASH_SELECTED = _12;
		public static final int STATS_TILE_HALF_LEFT_BLACK = _13;
		public static final int STATS_TILE_HALF_RIGHT_BLACK = _14;
	}

	public static final class Miscgraphics2
	{
		public static final int _0 = 185;
		public static final int _1 = 186;
		public static final int _2 = 187;
		public static final int _3 = 188;
		public static final int _4 = 189;
		public static final int _5 = 190;
		public static final int _6 = 191;
		public static final int _7 = 192;
		public static final int _8 = 193;
		public static final int _9 = 194;

		public static final int MUSIC_PLAYER_BUTTON = _0;
		public static final int MUSIC_PLAYER_BUTTON_SELECTED = _1;
	}

	public static final class Miscgraphics3
	{
		public static final int _0 = 195;
		public static final int _1 = 196;
		public static final int _2 = 1366;
		public static final int _3 = 1367;

		public static final int UNKNOWN_BUTTON_SQUARE_SMALL = _0;
		public static final int UNKNOWN_BUTTON_SQUARE_SMALL_SELECTED = _1;
		public static final int HOUSE_VIEWER_ROTATE_CLOCKWISE = _2;
		public static final int HOUSE_VIEWER_ROTATE_ANTICLOCKWISE = _3;
	}

	public static final class Staticons
	{
		public static final int _0 = 197;
		public static final int _1 = 198;
		public static final int _2 = 199;
		public static final int _3 = 200;
		public static final int _4 = 201;
		public static final int _5 = 202;
		public static final int _6 = 203;
		public static final int _7 = 204;
		public static final int _8 = 205;
		public static final int _9 = 206;
		public static final int _10 = 207;
		public static final int _11 = 208;
		public static final int _12 = 209;
		public static final int _13 = 210;
		public static final int _14 = 211;
		public static final int _15 = 212;
		public static final int _16 = 213;
		public static final int _17 = 214;

		public static final int ATTACK = _0;
		public static final int STRENGTH = _1;
		public static final int DEFENCE = _2;
		public static final int RANGED = _3;
		public static final int PRAYER = _4;
		public static final int MAGIC = _5;
		public static final int HITPOINTS = _6;
		public static final int AGILITY = _7;
		public static final int HERBLORE = _8;
		public static final int THIEVING = _9;
		public static final int CRAFTING = _10;
		public static final int FLETCHING = _11;
		public static final int MINING = _12;
		public static final int SMITHING = _13;
		public static final int FISHING = _14;
		public static final int COOKING = _15;
		public static final int FIREMAKING = _16;
		public static final int WOODCUTTING = _17;
	}

	public static final class Staticons2
	{
		public static final int _0 = 215;
		public static final int _1 = 216;
		public static final int _2 = 217;
		public static final int _3 = 218;
		public static final int _4 = 219;
		public static final int _5 = 220;
		public static final int _6 = 221;
		public static final int _7 = 222;
		public static final int _8 = 223;
		public static final int _9 = 224;
		public static final int _10 = 225;
		public static final int _11 = 226;
		public static final int _12 = 227;
		public static final int _13 = 228;
		public static final int _14 = 229;
		public static final int _15 = 230;
		public static final int _16 = 231;
		public static final int _17 = 232;

		public static final int RUNECRAFT = _0;
		public static final int SLAYER = _1;
		public static final int FARMING = _2;
		public static final int SHOVEL = _3;
		public static final int RAT_PITS_ZONE_RAT = _4;
		public static final int HUNTER = _5;
		public static final int CONSTRUCTION = _6;
		public static final int TOTAL = _7;
		public static final int UNKNOWN_EMPTY_VIAL = _8;
		public static final int UNKNOWN_DRAGON_DAGGER_P = _9;
	}

	public static final class Combaticons
	{
		public static final int _0 = 233;
		public static final int _1 = 234;
		public static final int _2 = 235;
		public static final int _3 = 236;
		public static final int _4 = 237;
		public static final int _5 = 238;
		public static final int _6 = 239;
		public static final int _7 = 240;
		public static final int _8 = 241;
		public static final int _9 = 242;
		public static final int _10 = 243;
		public static final int _11 = 244;
		public static final int _12 = 245;
		public static final int _13 = 246;
		public static final int _14 = 247;
		public static final int _15 = 248;
		public static final int _16 = 249;
		public static final int _17 = 250;
		public static final int _18 = 251;
		public static final int _19 = 252;

		public static final int AXE_BLOCK = _0;
		public static final int AXE_CHOP = _1;
		public static final int AXE_HACK = _2;
		public static final int AXE_SMASH = _3;
		public static final int SWORD_BLOCK = _4;
		public static final int SWORD_SLASH = _5;
		public static final int SWORD_CHOP = _6;
		public static final int SWORD_STAB = _7;
		public static final int SPEAR_LUNGE = _8;
		public static final int SPEAR_POUND = _9;
		public static final int MACE_BLOCK = _10;
		public static final int MACE_PUMMEL = _11;
		public static final int MACE_SPIKE = _12;
		public static final int MACE_POUND = _13;
		public static final int UNARMED_PUNCH = _14;
		public static final int UNARMED_KICK = _15;
		public static final int UNARMED_BLOCK = _16;
		public static final int SPEAR_BLOCK = _17;
		public static final int SPEAR_SWIPE = _18;
		public static final int STAFF_BLOCK = _19;
	}

	public static final class Combaticons2
	{
		public static final int _0 = 253;
		public static final int _1 = 254;
		public static final int _2 = 255;
		public static final int _3 = 256;
		public static final int _4 = 257;
		public static final int _5 = 258;
		public static final int _6 = 259;
		public static final int _7 = 260;
		public static final int _8 = 261;
		public static final int _9 = 262;
		public static final int _10 = 263;
		public static final int _11 = 264;
		public static final int _12 = 265;
		public static final int _13 = 266;
		public static final int _14 = 267;
		public static final int _15 = 268;
		public static final int _16 = 269;
		public static final int _17 = 270;
		public static final int _18 = 271;
		public static final int _19 = 272;

		public static final int HAMMER_BLOCK = _0;
		public static final int HAMMER = _1;
		public static final int HAMMER_POUND = _2;
		public static final int HAMMER_PUMMEL = _3;
		public static final int STAKE = _4;
		public static final int CROSSBOW_ACCURATE = _5;
		public static final int CROSSBOW_RAPID = _6;
		public static final int CROSSBOW_LONGRANGE = _7;
		public static final int SCYTHE_BLOCK = _8;
		public static final int SCYTHE_CHOP = _9;
		public static final int MAGIC_ACCURATE = _10;
		public static final int MAGIC_RAPID = _11;
		public static final int MAGIC_LONGRANGE = _12;
		public static final int STAFF_BASH = _13;
		public static final int STAFF_POUND = _14;
		public static final int BOW_ACCURATE = _15;
		public static final int BOW_RAPID = _16;
		public static final int BOW_LONGRANGE = _17;
		public static final int SCYTHE_JAB = _18;
		public static final int SCYTHE_REAP = _19;
	}

	public static final class Combaticons3
	{
		public static final int _0 = 273;
		public static final int _1 = 274;
		public static final int _2 = 275;
		public static final int _3 = 276;
		public static final int _4 = 277;
		public static final int _5 = 278;
		public static final int _6 = 279;
		public static final int _7 = 280;
		public static final int _8 = 281;
		public static final int _9 = 282;
		public static final int _10 = 283;
		public static final int _11 = 284;
		public static final int _12 = 285;
		public static final int _13 = 286;
		public static final int _14 = 287;
		public static final int _15 = 288;
		public static final int _16 = 289;
		public static final int _17 = 290;
		public static final int _18 = 291;
		public static final int _19 = 292;

		public static final int PICKAXE_BLOCK = _0;
		public static final int PICKAXE_SPIKE = _1;
		public static final int PICKAXE_SMASH = _2;
		public static final int PICKAXE_IMPALE = _3;
		public static final int CLAWS_LUNGE = _4;
		public static final int CLAWS_SLASH = _5;
		public static final int CLAWS_CHOP = _6;
		public static final int CLAWS_BLOCK = _7;
		public static final int CHINCHOMPA_LONG_FUSE = _8;
		public static final int CHINCHOMPA_MEDIUM_FUSE = _9;
		public static final int HALBERD_BLOCK = _10;
		public static final int HALBERD_JAB = _11;
		public static final int HALBERD_SWIPE = _12;
		public static final int WHIP_FLICK = _13;
		public static final int WHIP_LASH = _14;
		public static final int CHINCHOMPA_SHORT_FUSE = _15;
		public static final int SALAMANDER_SCORCH = _16;
		public static final int SALAMANDER_FLARE = _17;
		public static final int SALAMANDER_BLAZE = _18;
	}

	public static final class Combatboxes
	{
		public static final int _0 = 293;
		public static final int _1 = 294;
		public static final int _2 = 295;
		public static final int _3 = 296;

		public static final int BUTTON_NARROW = _0;
		public static final int BUTTON_NARROW_SELECTED = _1;
		public static final int BUTTON_THIN = _2;
		public static final int BUTTON_THIN_SELECTED = _3;
	}

	public static final class HeadiconsPkInterface
	{
		public static final int _14 = 298;
		public static final int _0 = 523;
		public static final int _1 = 524;
		public static final int _2 = 525;
		public static final int _3 = 526;
		public static final int _4 = 527;
		public static final int _5 = 528;
		public static final int _6 = 1095;
		public static final int _7 = 1096;
		public static final int _8 = 1097;
		public static final int _9 = 1221;
		public static final int _10 = 1222;
		public static final int _11 = 1223;
		public static final int _12 = 1224;
		public static final int _13 = 1225;
		public static final int _15 = 2271;
		public static final int _16 = 2501;
		public static final int _17 = 2502;
		public static final int _18 = 2503;
		public static final int _19 = 2504;
		public static final int _20 = 2505;
		public static final int _21 = 6316;
		public static final int _22 = 6333;
		public static final int _23 = 6334;
		public static final int _24 = 6335;
		public static final int _25 = 6336;
		public static final int _26 = 6337;
		public static final int _27 = 6338;
		public static final int _28 = 6383;
		public static final int _29 = 6384;
		public static final int _30 = 6385;
		public static final int _31 = 6386;
		public static final int _32 = 6387;
		public static final int _33 = 6388;
		public static final int _34 = 6389;

		public static final int PLAYER_KILLER_SKULL = _0;
		public static final int FIGHT_PITS_WINNER_SKULL_RED = _1;
		public static final int BOUNTY_HUNTER_TARGET_WEALTH_5_VERY_HIGH = _2;
		public static final int BOUNTY_HUNTER_TARGET_WEALTH_4_HIGH = _3;
		public static final int BOUNTY_HUNTER_TARGET_WEALTH_1_VERY_LOW = _7;
		public static final int DEADMAN_BANK_KEYS_5 = _8;
		public static final int DEADMAN_BANK_KEYS_4 = _9;
		public static final int DEADMAN_BANK_KEYS_3 = _10;
		public static final int DEADMAN_BANK_KEYS_2 = _11;
		public static final int DEADMAN_BANK_KEYS_1 = _12;
	}

	public static final class Sworddecor
	{
		public static final int _0 = 301;
		public static final int _1 = 302;
		public static final int _2 = 303;
		public static final int _3 = 304;

		public static final int LEFT = _0;
		public static final int RIGHT = _1;
		public static final int RIGHT_SHADOWED = _2;
		public static final int LEFT_SHADOWED = _3;
	}

	public static final class Steelborder
	{
		public static final int _0 = 310;
		public static final int _1 = 311;
		public static final int _2 = 312;
		public static final int _3 = 313;

		public static final int TOP_LEFT = _0;
		public static final int TOP_RIGHT = _1;
		public static final int BOTTOM_LEFT = _2;
		public static final int BOTTOM_RIGHT = _3;
	}

	public static final class Steelborder2
	{
		public static final int _0 = 314;
		public static final int _1 = 315;

		public static final int EDGE_TOP = _0;
		public static final int EDGE_RIGHT = _1;
	}

	public static final class Magicon2
	{
		public static final int _0 = 319;
		public static final int _1 = 320;
		public static final int _2 = 321;
		public static final int _3 = 322;
		public static final int _4 = 323;
		public static final int _5 = 324;
		public static final int _6 = 325;
		public static final int _7 = 326;
		public static final int _8 = 327;
		public static final int _9 = 328;
		public static final int _10 = 329;
		public static final int _11 = 330;
		public static final int _12 = 331;
		public static final int _13 = 332;
		public static final int _14 = 333;
		public static final int _15 = 334;
		public static final int _16 = 335;
		public static final int _17 = 336;
		public static final int _18 = 337;
		public static final int _19 = 338;
		public static final int _20 = 339;
		public static final int _21 = 340;
		public static final int _22 = 341;
		public static final int _23 = 342;
		public static final int _24 = 343;
		public static final int _25 = 344;
		public static final int _26 = 345;
		public static final int _27 = 346;
		public static final int _28 = 347;
		public static final int _29 = 348;
		public static final int _30 = 349;
		public static final int _31 = 350;
		public static final int _32 = 351;
		public static final int _33 = 352;
		public static final int _34 = 353;
		public static final int _35 = 354;
		public static final int _36 = 355;
		public static final int _37 = 356;
		public static final int _38 = 357;
		public static final int _39 = 358;
		public static final int _40 = 359;
		public static final int _41 = 360;
		public static final int _42 = 361;
		public static final int _43 = 362;
		public static final int _44 = 363;
		public static final int _45 = 364;
		public static final int _46 = 365;
		public static final int _47 = 366;
		public static final int _48 = 367;
		public static final int _49 = 368;

		public static final int BIND = _0;
		public static final int SNARE = _1;
		public static final int ENTANGLE = _2;
		public static final int CHARGE = _3;
		public static final int TROLLHEIM_TELEPORT = _4;
		public static final int MAGIC_DART = _5;
		public static final int ICE_RUSH = _6;
		public static final int ICE_BURST = _7;
		public static final int ICE_BLITZ = _8;
		public static final int ICE_BARRAGE = _9;
		public static final int SMOKE_RUSH = _10;
		public static final int SMOKE_BURST = _11;
		public static final int SMOKE_BLITZ = _12;
		public static final int SMOKE_BARRAGE = _13;
		public static final int BLOOD_RUSH = _14;
		public static final int BLOOD_BURST = _15;
		public static final int BLOOD_BLITZ = _16;
		public static final int BLOOD_BARRAGE = _17;
		public static final int SHADOW_RUSH = _18;
		public static final int SHADOW_BURST = _19;
		public static final int SHADOW_BLITZ = _20;
		public static final int SHADOW_BARRAGE = _21;
		public static final int PADDEWWA_TELEPORT = _22;
		public static final int SENNTISTEN_TELEPORT = _23;
		public static final int KHARYRLL_TELEPORT = _24;
		public static final int LASSAR_TELEPORT = _25;
		public static final int DAREEYAK_TELEPORT = _26;
		public static final int CARRALLANGAR_TELEPORT = _27;
		public static final int ANNAKARL_TELEPORT = _28;
		public static final int GHORROCK_TELEPORT = _29;
		public static final int TELEOTHER_LUMBRIDGE = _30;
		public static final int TELEOTHER_FALADOR = _31;
		public static final int TELEOTHER_CAMELOT = _32;
		public static final int TELE_BLOCK = _33;
		public static final int LVL_6_ENCHANT = _34;
		public static final int BONES_TO_PEACHES = _35;
		public static final int TELEPORT_TO_HOUSE = _36;
		public static final int LUMBRIDGE_HOME_TELEPORT = _37;
		public static final int TELEPORT_TO_APE_ATOLL = _38;
		public static final int ENCHANT_CROSSBOW_BOLT = _39;
		public static final int TELEPORT_TO_BOUNTY_TARGET = _40;
		public static final int TELEPORT_TO_KOUREND = _41;
		public static final int LVL_7_ENCHANT = _42;
		public static final int WIND_SURGE = _43;
		public static final int WATER_SURGE = _44;
		public static final int EARTH_SURGE = _45;
		public static final int FIRE_SURGE = _46;
		public static final int CIVITAS_ILLA_FORTIS_TELEPORT = _48;
	}

	public static final class Magicoff2
	{
		public static final int _0 = 369;
		public static final int _1 = 370;
		public static final int _2 = 371;
		public static final int _3 = 372;
		public static final int _4 = 373;
		public static final int _5 = 374;
		public static final int _6 = 375;
		public static final int _7 = 376;
		public static final int _8 = 377;
		public static final int _9 = 378;
		public static final int _10 = 379;
		public static final int _11 = 380;
		public static final int _12 = 381;
		public static final int _13 = 382;
		public static final int _14 = 383;
		public static final int _15 = 384;
		public static final int _16 = 385;
		public static final int _17 = 386;
		public static final int _18 = 387;
		public static final int _19 = 388;
		public static final int _20 = 389;
		public static final int _21 = 390;
		public static final int _22 = 391;
		public static final int _23 = 392;
		public static final int _24 = 393;
		public static final int _25 = 394;
		public static final int _26 = 395;
		public static final int _27 = 396;
		public static final int _28 = 397;
		public static final int _29 = 398;
		public static final int _30 = 399;
		public static final int _31 = 400;
		public static final int _32 = 401;
		public static final int _33 = 402;
		public static final int _34 = 403;
		public static final int _35 = 404;
		public static final int _36 = 405;
		public static final int _37 = 406;
		public static final int _38 = 407;
		public static final int _39 = 408;
		public static final int _40 = 409;
		public static final int _41 = 410;
		public static final int _42 = 411;
		public static final int _43 = 412;
		public static final int _44 = 413;
		public static final int _45 = 414;
		public static final int _46 = 415;
		public static final int _47 = 416;
		public static final int _48 = 417;
		public static final int _49 = 418;

		public static final int BIND = _0;
		public static final int SNARE = _1;
		public static final int ENTANGLE = _2;
		public static final int CHARGE = _3;
		public static final int TROLLHEIM_TELEPORT = _4;
		public static final int MAGIC_DART = _5;
		public static final int ICE_RUSH = _6;
		public static final int ICE_BURST = _7;
		public static final int ICE_BLITZ = _8;
		public static final int ICE_BARRAGE = _9;
		public static final int SMOKE_RUSH = _10;
		public static final int SMOKE_BURST = _11;
		public static final int SMOKE_BLITZ = _12;
		public static final int SMOKE_BARRAGE = _13;
		public static final int BLOOD_RUSH = _14;
		public static final int BLOOD_BURST = _15;
		public static final int BLOOD_BLITZ = _16;
		public static final int BLOOD_BARRAGE = _17;
		public static final int SHADOW_RUSH = _18;
		public static final int SHADOW_BURST = _19;
		public static final int SHADOW_BLITZ = _20;
		public static final int SHADOW_BARRAGE = _21;
		public static final int PADDEWWA_TELEPORT = _22;
		public static final int SENNTISTEN_TELEPORT = _23;
		public static final int KHARYRLL_TELEPORT = _24;
		public static final int LASSAR_TELEPORT = _25;
		public static final int DAREEYAK_TELEPORT = _26;
		public static final int CARRALLANGAR_TELEPORT = _27;
		public static final int ANNAKARL_TELEPORT = _28;
		public static final int GHORROCK_TELEPORT = _29;
		public static final int TELEOTHER_LUMBRIDGE = _30;
		public static final int TELEOTHER_FALADOR = _31;
		public static final int TELEOTHER_CAMELOT = _32;
		public static final int TELE_BLOCK = _33;
		public static final int LVL_6_ENCHANT = _34;
		public static final int BONES_TO_PEACHES = _35;
		public static final int TELEPORT_TO_HOUSE = _36;
		public static final int LUMBRIDGE_HOME_TELEPORT = _37;
		public static final int TELEPORT_TO_APE_ATOLL = _38;
		public static final int ENCHANT_CROSSBOW_BOLT = _39;
		public static final int TELEPORT_TO_BOUNTY_TARGET = _40;
		public static final int TELEPORT_TO_KOUREND = _41;
		public static final int LVL_7_ENCHANT = _42;
		public static final int WIND_SURGE = _43;
		public static final int WATER_SURGE = _44;
		public static final int EARTH_SURGE = _45;
		public static final int FIRE_SURGE = _46;
	}

	public static final class GnomeballButtons
	{
		public static final int _0 = 419;
		public static final int _1 = 420;
		public static final int _2 = 421;
	}

	public static final class RedGreenArrows
	{
		public static final int _0 = 489;
		public static final int _1 = 534;

		public static final int GREEN_UP = _0;
		public static final int RED_DOWN = _1;
	}

	public static final class MapdotsInterface
	{
		public static final int _0 = 510;
		public static final int _1 = 511;
		public static final int _2 = 512;
		public static final int _3 = 513;
		public static final int _4 = 514;
		public static final int _5 = 1044;
		public static final int _6 = 3337;

		public static final int RED_ITEM = _0;
		public static final int YELLOW_NPC = _1;
		public static final int WHITE_PLAYER = _2;
		public static final int GREEN_PLAYER_FRIEND = _3;
		public static final int BLUE_PLAYER_TEAM_CAPE = _4;
		public static final int PURPLE_PLAYER_FRIENDS_CHAT = _5;
	}

	public static final class CrossInterface
	{
		public static final int _0 = 515;
		public static final int _1 = 516;
		public static final int _2 = 517;
		public static final int _3 = 518;
		public static final int _4 = 519;
		public static final int _5 = 520;
		public static final int _6 = 521;
		public static final int _7 = 522;

		public static final int YELLOW_CLICK_ANIMATION_1 = _0;
		public static final int YELLOW_CLICK_ANIMATION_2 = _1;
		public static final int YELLOW_CLICK_ANIMATION_3 = _2;
		public static final int YELLOW_CLICK_ANIMATION_4 = _3;
		public static final int RED_CLICK_ANIMATION_1 = _4;
		public static final int RED_CLICK_ANIMATION_2 = _5;
		public static final int RED_CLICK_ANIMATION_3 = _6;
		public static final int RED_CLICK_ANIMATION_4 = _7;
	}

	public static final class CloseButtons
	{
		public static final int _0 = 535;
		public static final int _1 = 536;
		public static final int _2 = 537;
		public static final int _3 = 538;
		public static final int _4 = 539;
		public static final int _5 = 540;
		public static final int _6 = 541;
		public static final int _7 = 542;
		public static final int _10 = 2152;
		public static final int _11 = 2153;
		public static final int _8 = 2217;
		public static final int _9 = 2218;
		public static final int _12 = 2948;
		public static final int _13 = 2949;
		public static final int _14 = 2950;
		public static final int _15 = 2951;
		public static final int _16 = 2952;
		public static final int _17 = 2953;

		public static final int BUTTON = _0;
		public static final int HOVERED = _1;
		public static final int PARCHMENT = _2;
		public static final int PARCHMENT_HOVERED = _3;
		public static final int RED_X = _4;
		public static final int RED_X_HOVERED = _5;
		public static final int BROWN_X = _6;
		public static final int BROWN_X_HOVERED = _7;
	}

	public static final class LunarMagicOn
	{
		public static final int _0 = 543;
		public static final int _1 = 544;
		public static final int _2 = 545;
		public static final int _3 = 546;
		public static final int _4 = 547;
		public static final int _5 = 548;
		public static final int _6 = 549;
		public static final int _7 = 550;
		public static final int _8 = 551;
		public static final int _9 = 552;
		public static final int _10 = 553;
		public static final int _11 = 554;
		public static final int _12 = 555;
		public static final int _13 = 556;
		public static final int _14 = 557;
		public static final int _15 = 558;
		public static final int _16 = 559;
		public static final int _17 = 560;
		public static final int _18 = 561;
		public static final int _19 = 562;
		public static final int _20 = 563;
		public static final int _21 = 564;
		public static final int _22 = 565;
		public static final int _23 = 566;
		public static final int _24 = 567;
		public static final int _25 = 568;
		public static final int _26 = 569;
		public static final int _27 = 570;
		public static final int _28 = 571;
		public static final int _29 = 572;
		public static final int _30 = 573;
		public static final int _31 = 574;
		public static final int _32 = 575;
		public static final int _33 = 576;
		public static final int _34 = 577;
		public static final int _35 = 578;
		public static final int _36 = 579;
		public static final int _37 = 580;
		public static final int _38 = 581;
		public static final int _39 = 582;
		public static final int _40 = 583;
		public static final int _41 = 584;
		public static final int _42 = 585;
		public static final int _43 = 586;
		public static final int _44 = 587;
		public static final int _45 = 588;
		public static final int _46 = 589;
		public static final int _47 = 590;
		public static final int _48 = 591;
		public static final int _49 = 592;

		public static final int BAKE_PIE = _0;
		public static final int MOONCLAN_TELEPORT = _1;
		public static final int WATERBIRTH_TELEPORT = _2;
		public static final int BOW_AND_ARROW = _3;
		public static final int BARBARIAN_TELEPORT = _4;
		public static final int SUPERGLASS_MAKE = _5;
		public static final int KHAZARD_TELEPORT = _6;
		public static final int STRING_JEWELLERY = _7;
		public static final int BOOST_POTION_SHARE = _8;
		public static final int MAGIC_IMBUE = _9;
		public static final int FERTILE_SOIL = _10;
		public static final int STAT_RESTORE_POT_SHARE = _11;
		public static final int FISHING_GUILD_TELEPORT = _12;
		public static final int CATHERBY_TELEPORT = _13;
		public static final int ICE_PLATEAU_TELEPORT = _14;
		public static final int ENERGY_TRANSFER = _15;
		public static final int CURE_OTHER = _16;
		public static final int HEAL_OTHER = _17;
		public static final int VENGEANCE_OTHER = _18;
		public static final int CURE_ME = _19;
		public static final int GEOMANCY = _20;
		public static final int VENGEANCE = _21;
		public static final int CURE_GROUP = _22;
		public static final int HEAL_GROUP = _23;
		public static final int CURE_PLANT = _24;
		public static final int NPC_CONTACT = _25;
		public static final int TELE_GROUP_MOONCLAN = _26;
		public static final int TELE_GROUP_WATERBIRTH = _27;
		public static final int TELE_GROUP_BARBARIAN = _28;
		public static final int TELE_GROUP_KHAZARD = _29;
		public static final int TELE_GROUP_FISHING_GUILD = _30;
		public static final int TELE_GROUP_CATHERBY = _31;
		public static final int TELE_GROUP_ICE_PLATEAU = _32;
		public static final int STAT_SPY = _33;
		public static final int MONSTER_EXAMINE = _34;
		public static final int HUMIDIFY = _35;
		public static final int HUNTER_KIT = _36;
		public static final int DREAM = _37;
		public static final int PLANK_MAKE = _38;
		public static final int SPELLBOOK_SWAP = _39;
		public static final int TAN_LEATHER = _40;
		public static final int RECHARGE_DRAGONSTONE = _41;
		public static final int SPIN_FLAX = _42;
		public static final int OURANIA_TELEPORT = _43;
	}

	public static final class LunarMagicOff
	{
		public static final int _0 = 593;
		public static final int _1 = 594;
		public static final int _2 = 595;
		public static final int _3 = 596;
		public static final int _4 = 597;
		public static final int _5 = 598;
		public static final int _6 = 599;
		public static final int _7 = 600;
		public static final int _8 = 601;
		public static final int _9 = 602;
		public static final int _10 = 603;
		public static final int _11 = 604;
		public static final int _12 = 605;
		public static final int _13 = 606;
		public static final int _14 = 607;
		public static final int _15 = 608;
		public static final int _16 = 609;
		public static final int _17 = 610;
		public static final int _18 = 611;
		public static final int _19 = 612;
		public static final int _20 = 613;
		public static final int _21 = 614;
		public static final int _22 = 615;
		public static final int _23 = 616;
		public static final int _24 = 617;
		public static final int _25 = 618;
		public static final int _26 = 619;
		public static final int _27 = 620;
		public static final int _28 = 621;
		public static final int _29 = 622;
		public static final int _30 = 623;
		public static final int _31 = 624;
		public static final int _32 = 625;
		public static final int _33 = 626;
		public static final int _34 = 627;
		public static final int _35 = 628;
		public static final int _36 = 629;
		public static final int _37 = 630;
		public static final int _38 = 631;
		public static final int _39 = 632;
		public static final int _40 = 633;
		public static final int _41 = 634;
		public static final int _42 = 635;
		public static final int _43 = 636;
		public static final int _44 = 637;
		public static final int _45 = 638;
		public static final int _46 = 639;
		public static final int _47 = 640;
		public static final int _48 = 641;
		public static final int _49 = 642;

		public static final int BAKE_PIE = _0;
		public static final int MOONCLAN_TELEPORT = _1;
		public static final int WATERBIRTH_TELEPORT = _2;
		public static final int BOW_AND_ARROW = _3;
		public static final int BARBARIAN_TELEPORT = _4;
		public static final int SUPERGLASS_MAKE = _5;
		public static final int KHAZARD_TELEPORT = _6;
		public static final int STRING_JEWELLERY = _7;
		public static final int BOOST_POTION_SHARE = _8;
		public static final int MAGIC_IMBUE = _9;
		public static final int FERTILE_SOIL = _10;
		public static final int STAT_RESTORE_POT_SHARE = _11;
		public static final int FISHING_GUILD_TELEPORT = _12;
		public static final int CATHERBY_TELEPORT = _13;
		public static final int ICE_PLATEAU_TELEPORT = _14;
		public static final int ENERGY_TRANSFER = _15;
		public static final int CURE_OTHER = _16;
		public static final int HEAL_OTHER = _17;
		public static final int VENGEANCE_OTHER = _18;
		public static final int CURE_ME = _19;
		public static final int GEOMANCY = _20;
		public static final int VENGEANCE = _21;
		public static final int CURE_GROUP = _22;
		public static final int HEAL_GROUP = _23;
		public static final int CURE_PLANT = _24;
		public static final int NPC_CONTACT = _25;
		public static final int TELE_GROUP_MOONCLAN = _26;
		public static final int TELE_GROUP_WATERBIRTH = _27;
		public static final int TELE_GROUP_BARBARIAN = _28;
		public static final int TELE_GROUP_KHAZARD = _29;
		public static final int TELE_GROUP_FISHING_GUILD = _30;
		public static final int TELE_GROUP_CATHERBY = _31;
		public static final int TELE_GROUP_ICE_PLATEAU = _32;
		public static final int STAT_SPY = _33;
		public static final int MONSTER_EXAMINE = _34;
		public static final int HUMIDIFY = _35;
		public static final int HUNTER_KIT = _36;
		public static final int DREAM = _37;
		public static final int PLANK_MAKE = _38;
		public static final int SPELLBOOK_SWAP = _39;
		public static final int TAN_LEATHER = _40;
		public static final int RECHARGE_DRAGONSTONE = _41;
		public static final int SPIN_FLAX = _42;
		public static final int OURANIA_TELEPORT = _43;
	}

	public static final class OptionsIconsSmall
	{
		public static final int _0 = 649;
		public static final int _1 = 650;
		public static final int _2 = 651;
		public static final int _3 = 677;
		public static final int _6 = 911;
		public static final int _4 = 1702;
		public static final int _5 = 1703;
		public static final int _7 = 3338;
		public static final int _8 = 3339;
		public static final int _9 = 3340;
		public static final int _10 = 3341;
		public static final int _11 = 3342;
		public static final int _12 = 3343;
		public static final int _13 = 3344;
		public static final int _14 = 3345;
		public static final int _15 = 3346;
		public static final int _16 = 3347;
		public static final int _17 = 3348;
		public static final int _18 = 3349;
		public static final int _19 = 3350;

		public static final int EQUIPMENT_WEIGHT = _0;
		public static final int WORLD_MAP_KEY_EFFECTS_THUNDERBOLT = _1;
		public static final int PRAYER = _2;
		public static final int RUN_ENERGY = _3;
		public static final int SOUND = _6;
		public static final int FRIENDS = _4;
		public static final int IGNORES = _5;
	}

	public static final class CombatboxesLarge
	{
		public static final int _0 = 653;
		public static final int _1 = 654;

		public static final int BUTTON = _0;
		public static final int SELECTED = _1;
	}

	public static final class CombatboxesVeryLarge
	{
		public static final int _0 = 655;
		public static final int _1 = 656;

		public static final int BUTTON = _0;
		public static final int SELECTED = _1;
	}

	public static final class OptionsIcons
	{
		public static final int _0 = 659;
		public static final int _1 = 660;
		public static final int _2 = 661;
		public static final int _3 = 662;
		public static final int _4 = 663;
		public static final int _5 = 664;
		public static final int _6 = 665;
		public static final int _7 = 666;
		public static final int _8 = 667;
		public static final int _9 = 668;
		public static final int _10 = 669;
		public static final int _11 = 670;
		public static final int _12 = 671;
		public static final int _13 = 672;
		public static final int _14 = 673;
		public static final int _15 = 674;
		public static final int _16 = 675;
		public static final int _17 = 676;
		public static final int _18 = 912;
		public static final int _19 = 1045;
		public static final int _20 = 1057;
		public static final int _21 = 1073;
		public static final int _22 = 1084;
		public static final int _23 = 1085;
		public static final int _24 = 1086;
		public static final int _25 = 1087;
		public static final int _26 = 1088;
		public static final int _27 = 1089;
		public static final int _28 = 1090;
		public static final int _29 = 1091;
		public static final int _30 = 1159;
		public static final int _31 = 1160;
		public static final int _32 = 1161;
		public static final int _33 = 1162;
		public static final int _34 = 1163;
		public static final int _35 = 1164;
		public static final int _36 = 1165;
		public static final int _37 = 1166;
		public static final int _38 = 1167;
		public static final int _39 = 1168;
		public static final int _40 = 1562;
		public static final int _41 = 1563;
		public static final int _42 = 1564;
		public static final int _43 = 1565;
		public static final int _44 = 1566;
		public static final int _45 = 1567;
		public static final int _46 = 1568;
		public static final int _47 = 1569;
		public static final int _48 = 1570;
		public static final int _49 = 1571;
		public static final int _50 = 1653;
		public static final int _51 = 1654;
		public static final int _52 = 1655;
		public static final int _53 = 1656;
		public static final int _54 = 1657;
		public static final int _55 = 1658;
		public static final int _56 = 1659;
		public static final int _57 = 1660;
		public static final int _58 = 1661;
		public static final int _59 = 1662;

		public static final int SCREEN_BRIGHTNESS = _0;
		public static final int MUSIC_VOLUME = _1;
		public static final int SOUND_EFFECT_VOLUME = _2;
		public static final int CHAT_EFFECTS = _3;
		public static final int MOUSE_BUTTONS = _4;
		public static final int SPLIT_PRIVATE_CHAT = _5;
		public static final int ACCEPT_AID = _6;
		public static final int MUSIC_DISABLED = _7;
		public static final int SOUND_EFFECTS_DISABLED = _8;
		public static final int UNKNOWN_SWORD_GRIP = _9;
		public static final int WALKING = _10;
		public static final int RUNNING = _11;
		public static final int WALKING_DISABLED = _12;
		public static final int RUNNING_DISABLED = _13;
		public static final int AREA_SOUND_VOLUME = _14;
		public static final int AREA_SOUND_DISABLED = _15;
		public static final int EQUIPMENT_EQUIPMENT_STATS = _16;
		public static final int HOUSE_OPTIONS = _17;
		public static final int EQUIPMENT_ITEMS_LOST_ON_DEATH = _18;
		public static final int PROFANITY_FILTER = _19;
		public static final int DATA_ORBS = _20;
		public static final int CAMERA = _21;
		public static final int DISPLAY = _22;
		public static final int CHAT = _23;
		public static final int ROOFS = _24;
		public static final int XP_TO_NEXT_LEVEL = _25;
		public static final int CONTROLS = _26;
		public static final int LOGIN_LOGOUT_NOTIFICATION_TIMEOUT = _27;
		public static final int EQUIPMENT_GUIDE_PRICES = _28;
		public static final int SIDE_PANELS = _29;
		public static final int TRANSPARENT_CHATBOX = _30;
		public static final int TRANSPARENT_SIDE_PANEL = _31;
		public static final int KEYBINDINGS = _32;
		public static final int SCROLL_WHEEL_ZOOM = _33;
		public static final int HIDE_PRIVATE_CHAT = _34;
		public static final int NOTIFICATIONS = _35;
		public static final int SHIFT_CLICK_DROP = _36;
		public static final int FOLLOWER_RIGHT_CLICK_MENU = _37;
		public static final int PRAYER_TOOLTIPS = _38;
		public static final int SPECIAL_ATTACK_TOOLTIP = _39;
		public static final int FINGER_POINTING_AT_MENU = _40;
		public static final int DISPLAY_ICON_VERTICAL = _41;
		public static final int F1_BUTTON_DISABLED = _42;
		public static final int TWO_FINGERS_POINTING_AT_MAGNIFYING_GLASS = _43;
		public static final int SHIFT_KEY_DISABLED = _44;
		public static final int FINGER_POINTING_AT_PET = _45;
		public static final int SCROLL = _46;
		public static final int MOBILE_FINGER_ON_INTERFACE = _50;
	}

	public static final class OptionsSlider
	{
		public static final int _0 = 679;
		public static final int _1 = 680;
		public static final int _2 = 681;
		public static final int _3 = 682;
		public static final int _4 = 683;
		public static final int _5 = 684;
		public static final int _6 = 685;
		public static final int _7 = 686;
		public static final int _8 = 1617;
		public static final int _9 = 1622;
		public static final int _10 = 1638;
		public static final int _11 = 1639;

		public static final int _1_OF_4 = _0;
		public static final int _2_OF_4 = _1;
		public static final int _3_OF_4 = _2;
		public static final int _4_OF_4 = _3;
		public static final int THUMB_1_OF_4 = _4;
		public static final int THUMB_2_OF_4 = _5;
		public static final int THUMB_3_OF_4 = _6;
		public static final int THUMB_4_OF_4 = _7;
	}

	public static final class OptionsSliderFive
	{
		public static final int _0 = 687;
		public static final int _1 = 688;
		public static final int _2 = 689;
		public static final int _3 = 690;
		public static final int _4 = 691;
		public static final int _5 = 692;
		public static final int _6 = 693;
		public static final int _7 = 694;
		public static final int _8 = 695;
		public static final int _9 = 696;

		public static final int THUMB_1_OF_5 = _0;
		public static final int THUMB_2_OF_5 = _1;
		public static final int THUMB_3_OF_5 = _2;
		public static final int THUMB_4_OF_5 = _3;
		public static final int THUMB_5_OF_5 = _4;
		public static final int _1_OF_5 = _5;
		public static final int _2_OF_5 = _6;
		public static final int _3_OF_5 = _7;
		public static final int _4_OF_5 = _8;
		public static final int _5_OF_5 = _9;
	}

	public static final class OptionsRadioButtons
	{
		public static final int _0 = 697;
		public static final int _1 = 698;
		public static final int _2 = 699;
		public static final int _3 = 1192;
		public static final int _4 = 1211;
		public static final int _5 = 1212;
		public static final int _6 = 1213;
		public static final int _7 = 1214;

		public static final int EMPTY = _0;
		public static final int CROSS_RED = _1;
		public static final int CHECK_GREEN = _2;
		public static final int CHECK_RED = _3;
		public static final int EMPTY_HOVER = _4;
		public static final int CROSS_RED_HOVER = _5;
		public static final int CHECK_GREEN_HOVER = _6;
		public static final int CHECK_RED_HOVER = _7;
	}

	public static final class Emotes
	{
		public static final int _0 = 700;
		public static final int _1 = 701;
		public static final int _2 = 702;
		public static final int _3 = 703;
		public static final int _4 = 704;
		public static final int _5 = 705;
		public static final int _6 = 706;
		public static final int _7 = 707;
		public static final int _8 = 708;
		public static final int _9 = 709;
		public static final int _10 = 710;
		public static final int _11 = 711;
		public static final int _12 = 712;
		public static final int _13 = 713;
		public static final int _14 = 714;
		public static final int _15 = 715;
		public static final int _16 = 716;
		public static final int _17 = 717;
		public static final int _18 = 718;
		public static final int _19 = 719;
		public static final int _20 = 720;
		public static final int _21 = 721;
		public static final int _22 = 722;
		public static final int _23 = 723;
		public static final int _24 = 724;
		public static final int _25 = 725;
		public static final int _26 = 726;
		public static final int _27 = 727;
		public static final int _28 = 728;
		public static final int _29 = 729;
		public static final int _30 = 730;
		public static final int _31 = 731;
		public static final int _32 = 732;
		public static final int _33 = 733;
		public static final int _34 = 734;
		public static final int _35 = 735;
		public static final int _36 = 736;
		public static final int _37 = 737;
		public static final int _38 = 738;
		public static final int _39 = 739;
		public static final int _40 = 1202;
		public static final int _41 = 1203;
		public static final int _42 = 1204;
		public static final int _43 = 1205;
		public static final int _44 = 1350;
		public static final int _45 = 1351;
		public static final int _46 = 1352;
		public static final int _47 = 1353;
		public static final int _48 = 2423;
		public static final int _49 = 2424;
		public static final int _50 = 2425;
		public static final int _51 = 2426;
		public static final int _52 = 3604;
		public static final int _53 = 3606;
		public static final int _54 = 3607;
		public static final int _55 = 3608;
		public static final int _56 = 5245;
		public static final int _57 = 5246;
		public static final int _58 = 5247;
		public static final int _59 = 5248;

		public static final int YES = _0;
		public static final int NO = _1;
		public static final int THINK = _2;
		public static final int BOW = _3;
		public static final int ANGRY = _4;
		public static final int CRY = _5;
		public static final int LAUGH = _6;
		public static final int CHEER = _7;
		public static final int WAVE = _8;
		public static final int BECKON = _9;
		public static final int DANCE = _10;
		public static final int CLAP = _11;
		public static final int PANIC = _12;
		public static final int JIG = _13;
		public static final int SPIN = _14;
		public static final int HEADBANG = _15;
		public static final int JUMP_FOR_JOY = _16;
		public static final int RASPBERRY = _17;
		public static final int YAWN = _18;
		public static final int SALUTE = _19;
		public static final int SHRUG = _20;
		public static final int BLOW_KISS = _21;
		public static final int GLASS_BOX = _22;
		public static final int CLIMB_ROPE = _23;
		public static final int LEAN = _24;
		public static final int GLASS_WALL = _25;
		public static final int GOBLIN_BOW = _26;
		public static final int GOBLIN_SALUTE = _27;
		public static final int SCARED = _28;
		public static final int SLAP_HEAD = _29;
		public static final int STAMP = _30;
		public static final int FLAP = _31;
		public static final int IDEA = _32;
		public static final int ZOMBIE_WALK = _33;
		public static final int ZOMBIE_DANCE = _34;
		public static final int RABBIT_HOP = _35;
		public static final int SKILLCAPE = _36;
		public static final int ZOMBIE_HAND = _37;
		public static final int AIR_GUITAR = _38;
		public static final int JOG = _39;
		public static final int SIT_UP = _40;
		public static final int STAR_JUMP = _41;
		public static final int PUSH_UP = _42;
		public static final int HYPERMOBILE_DRINKER = _43;
		public static final int URI_TRANSFORM = _44;
		public static final int SMOOTH_DANCE = _45;
		public static final int CRAZY_DANCE = _46;
		public static final int PREMIER_SHIELD = _47;
	}

	public static final class EmotesLocked
	{
		public static final int _0 = 740;
		public static final int _1 = 741;
		public static final int _2 = 742;
		public static final int _3 = 743;
		public static final int _4 = 744;
		public static final int _5 = 745;
		public static final int _6 = 746;
		public static final int _7 = 747;
		public static final int _8 = 748;
		public static final int _9 = 749;
		public static final int _10 = 750;
		public static final int _11 = 751;
		public static final int _12 = 752;
		public static final int _13 = 753;
		public static final int _14 = 754;
		public static final int _15 = 755;
		public static final int _16 = 756;
		public static final int _17 = 757;
		public static final int _18 = 758;
		public static final int _19 = 759;
		public static final int _20 = 1206;
		public static final int _21 = 1207;
		public static final int _22 = 1208;
		public static final int _23 = 1209;
		public static final int _24 = 1354;
		public static final int _25 = 1355;
		public static final int _26 = 1356;
		public static final int _27 = 1357;
		public static final int _28 = 2427;
		public static final int _29 = 2428;
		public static final int _30 = 2429;
		public static final int _31 = 2430;
		public static final int _32 = 5249;
		public static final int _33 = 5250;
		public static final int _34 = 5251;
		public static final int _35 = 5252;
		public static final int _36 = 6339;
		public static final int _37 = 6340;
		public static final int _38 = 6341;
		public static final int _39 = 6342;

		public static final int SHRUG = _0;
		public static final int BLOW_KISS = _1;
		public static final int GLASS_BOX = _2;
		public static final int CLIMB_ROPE = _3;
		public static final int LEAN = _4;
		public static final int GLASS_WALL = _5;
		public static final int GOBLIN_BOW = _6;
		public static final int GOBLIN_SALUTE = _7;
		public static final int SCARED = _8;
		public static final int SLAP_HEAD = _9;
		public static final int STAMP = _10;
		public static final int FLAP = _11;
		public static final int IDEA = _12;
		public static final int ZOMBIE_WALK = _13;
		public static final int ZOMBIE_DANCE = _14;
		public static final int RABBIT_HOP = _15;
		public static final int SKILLCAPE = _16;
		public static final int ZOMBIE_HAND = _17;
		public static final int AIR_GUITAR = _18;
		public static final int JOG = _19;
		public static final int SIT_UP = _20;
		public static final int STAR_JUMP = _21;
		public static final int PUSH_UP = _22;
		public static final int HYPERMOBILE_DRINKER = _23;
		public static final int URI_TRANSFORM = _24;
		public static final int SMOOTH_DANCE = _25;
		public static final int CRAZY_DANCE = _26;
		public static final int PREMIER_SHIELD = _27;
		public static final int FORTIS_SALUTE = _34;
	}

	public static final class OptionsBoxes
	{
		public static final int _0 = 761;
		public static final int _1 = 762;

		public static final int EMPTY = _0;
		public static final int SELECTED = _1;
	}

	public static final class BarbassaultIcons
	{
		public static final int _0 = 765;
		public static final int _1 = 766;
		public static final int _2 = 767;
		public static final int _3 = 768;
		public static final int _4 = 769;
		public static final int _5 = 770;
		public static final int _6 = 771;
		public static final int _7 = 772;
		public static final int _8 = 1750;

		public static final int WAVE = _0;
		public static final int EAR = _1;
		public static final int MOUTH = _2;
		public static final int HORN_FOR_ATTACKER = _3;
		public static final int HORN_FOR_DEFENDER = _4;
		public static final int HORN_FOR_COLLECTOR = _5;
		public static final int HORN_FOR_HEALER = _6;
	}

	public static final class ScrollbarV2
	{
		public static final int _0 = 773;
		public static final int _1 = 788;
		public static final int _2 = 4533;
		public static final int _3 = 4534;

		public static final int ARROW_UP = _0;
		public static final int ARROW_DOWN = _1;
		public static final int ARROW_LEFT = _2;
		public static final int ARROW_RIGHT = _3;
	}

	public static final class SideiconsInterface
	{
		public static final int _0 = 774;
		public static final int _1 = 775;
		public static final int _2 = 776;
		public static final int _3 = 777;
		public static final int _4 = 778;
		public static final int _5 = 779;
		public static final int _6 = 780;
		public static final int _7 = 781;
		public static final int _8 = 782;
		public static final int _9 = 783;
		public static final int _10 = 784;
		public static final int _11 = 785;
		public static final int _12 = 786;
		public static final int _13 = 787;
		public static final int _14 = 1052;
		public static final int _15 = 1053;
		public static final int _16 = 1299;
		public static final int _17 = 1414;
		public static final int _18 = 1582;
		public static final int _19 = 1583;
		public static final int _20 = 1584;
		public static final int _21 = 1711;
		public static final int _22 = 1712;
		public static final int _23 = 1713;
		public static final int _24 = 2303;
		public static final int _25 = 2304;
		public static final int _26 = 2305;
		public static final int _27 = 2306;
		public static final int _28 = 2307;
		public static final int _29 = 2308;
		public static final int _30 = 2309;
		public static final int _31 = 2310;
		public static final int _32 = 3561;
		public static final int _33 = 3562;
		public static final int _34 = 3563;
		public static final int _35 = 3564;
		public static final int _36 = 3565;
		public static final int _37 = 3566;
		public static final int _38 = 3567;
		public static final int _39 = 3568;
		public static final int _40 = 4818;
		public static final int _41 = 4819;
		public static final int _42 = 4820;
		public static final int _43 = 4821;
		public static final int _44 = 4822;
		public static final int _45 = 4823;
		public static final int _46 = 4824;
		public static final int _47 = 4825;
		public static final int _48 = 4826;
		public static final int _49 = 4827;
		public static final int _50 = 4828;
		public static final int _51 = 4829;
		public static final int _52 = 4830;
		public static final int _53 = 4831;
		public static final int _54 = 4832;
		public static final int _55 = 4833;
		public static final int _56 = 4834;
		public static final int _57 = 4835;
		public static final int _58 = 4836;
		public static final int _59 = 4837;
		public static final int _60 = 4838;
		public static final int _61 = 4839;
		public static final int _62 = 4840;
		public static final int _63 = 4841;
		public static final int _64 = 5805;
		public static final int _65 = 5806;
		public static final int _66 = 5807;
		public static final int _67 = 5808;
		public static final int _68 = 5809;
		public static final int _69 = 5810;
		public static final int _70 = 5811;
		public static final int _71 = 5812;

		public static final int COMBAT = _0;
		public static final int STATS = _1;
		public static final int QUESTS = _2;
		public static final int INVENTORY = _3;
		public static final int EQUIPMENT = _4;
		public static final int PRAYER = _5;
		public static final int MAGIC = _6;
		public static final int CHAT_CHANNEL = _7;
		public static final int FRIENDS = _8;
		public static final int IGNORES = _9;
		public static final int LOGOUT = _10;
		public static final int OPTIONS = _11;
		public static final int EMOTES = _12;
		public static final int MUSIC = _13;
		public static final int MINIGAMES = _15;
		public static final int ACHIEVEMENT_DIARIES = _16;
		public static final int KOUREND = _17;
		public static final int RAIDING_PARTY = _18;
		public static final int SPELLBOOK_ANCIENT_MAGICKS = _19;
		public static final int SPELLBOOK_LUNAR = _20;
		public static final int SPELLBOOK_ARCEUUS = _21;
		public static final int ADVENTURE_PATHS = _23;
		public static final int CLAN = _28;
		public static final int CHARACTER_SUMMARY = _30;
	}

	public static final class ScrollbarDraggerV2
	{
		public static final int _0 = 789;
		public static final int _1 = 790;
		public static final int _2 = 791;
		public static final int _3 = 792;

		public static final int TOP = _0;
		public static final int MIDDLE = _1;
		public static final int BOTTOM = _2;
		public static final int TRACK = _3;
	}

	public static final class ScrollbarParchmentV2
	{
		public static final int _0 = 793;
		public static final int _1 = 794;

		public static final int UP = _0;
		public static final int DOWN = _1;
	}

	public static final class ScrollbarParchmentDraggerV2
	{
		public static final int _0 = 795;
		public static final int _1 = 796;
		public static final int _2 = 797;
		public static final int _3 = 798;

		public static final int TOP = _0;
		public static final int MIDDLE = _1;
		public static final int BOTTOM = _2;
		public static final int TRACK = _3;
	}

	public static final class CloseButtonsV2
	{
		public static final int _0 = 799;
		public static final int _1 = 800;

		public static final int BUTTON = _0;
		public static final int HOVERED = _1;
	}

	public static final class ScrollbarSep
	{
		public static final int _0 = 801;
		public static final int _1 = 802;

		public static final int ARROW_UP = _0;
		public static final int ARROW_DOWN = _1;
	}

	public static final class PengEmotes
	{
		public static final int _0 = 803;
		public static final int _1 = 804;
		public static final int _2 = 805;
		public static final int _3 = 806;
		public static final int _4 = 807;
		public static final int _5 = 808;
		public static final int _6 = 809;
		public static final int _7 = 810;

		public static final int SHIVER = _0;
		public static final int SPIN = _1;
		public static final int CLAP = _2;
		public static final int BOW = _3;
		public static final int CHEER = _4;
		public static final int WAVE = _5;
		public static final int PREEN = _6;
		public static final int FLAP = _7;
	}

	public static final class Combatboxesmed
	{
		public static final int _0 = 812;
		public static final int _1 = 813;

		public static final int BUTTON = _0;
		public static final int SELECTED = _1;
	}

	public static final class V2StoneBorders
	{
		public static final int _0 = 820;
		public static final int _1 = 821;
		public static final int _2 = 822;
		public static final int _3 = 823;
		public static final int _4 = 824;
		public static final int _5 = 825;
		public static final int _6 = 826;
		public static final int _7 = 827;
		public static final int _8 = 828;
		public static final int _9 = 829;
		public static final int _10 = 830;
		public static final int _11 = 839;
		public static final int _12 = 840;
		public static final int _13 = 841;
		public static final int _14 = 842;
		public static final int _15 = 843;
		public static final int _16 = 844;
		public static final int _17 = 845;
		public static final int _18 = 846;
		public static final int _19 = 847;
		public static final int _20 = 848;
		public static final int _21 = 849;
		public static final int _22 = 850;
		public static final int _23 = 851;
		public static final int _24 = 852;
		public static final int _25 = 853;
		public static final int _26 = 854;
		public static final int _27 = 855;
		public static final int _28 = 856;
		public static final int _29 = 857;
		public static final int _30 = 858;
		public static final int _31 = 859;
		public static final int _32 = 860;

		public static final int SIDE_PANEL_EDGE_TOP = _0;
		public static final int SIDE_PANEL_EDGE_LEFT = _1;
		public static final int SIDE_PANEL_EDGE_BOTTOM = _2;
		public static final int SIDE_PANEL_EDGE_RIGHT = _3;
		public static final int SIDE_PANEL_CORNER_TOP_LEFT = _4;
		public static final int SIDE_PANEL_CORNER_TOP_RIGHT = _5;
		public static final int SIDE_PANEL_CORNER_BOTTOM_LEFT = _6;
		public static final int SIDE_PANEL_CORNER_BOTTOM_RIGHT = _7;
		public static final int SIDE_PANEL_EDGE_HORIZONTAL = _8;
		public static final int SIDE_PANEL_INTERSECTION_LEFT = _9;
		public static final int SIDE_PANEL_INTERSECTION_RIGHT = _10;
		public static final int SIDE_PANEL_INTERSECTION_BOTTOM = _11;
		public static final int SIDE_PANEL_INTERSECTION_TOP = _12;
		public static final int EDGE_VERTICAL = _13;
		public static final int INTERSECTION_TOP = _14;
		public static final int INTERSECTION_BOTTOM = _15;
		public static final int INTERSECTION_LEFT = _16;
		public static final int INTERSECTION_RIGHT = _17;
		public static final int CORNER_TOP_LEFT = _18;
		public static final int CORNER_TOP_RIGHT = _19;
		public static final int CORNER_BOTTOM_LEFT = _20;
		public static final int CORNER_BOTTOM_RIGHT = _21;
		public static final int INTERSECTION_MIDDLE = _22;
	}

	public static final class V2StoneCloseButton
	{
		public static final int _0 = 831;
		public static final int _1 = 832;

		public static final int BUTTON = _0;
		public static final int HOVERED = _1;
	}

	public static final class WildDitchSignButton
	{
		public static final int _0 = 833;
		public static final int _1 = 834;
		public static final int _2 = 943;

		public static final int BUTTON = _0;
		public static final int HOVERED = _1;
		public static final int HOVERED_WITH_RED_X = _2;
	}

	public static final class AchievementDiaryIcons
	{
		public static final int _0 = 835;
		public static final int _1 = 836;
		public static final int _2 = 1054;
		public static final int _3 = 1297;
		public static final int _4 = 2219;
		public static final int _5 = 2272;
		public static final int _6 = 2273;
		public static final int _7 = 2274;
		public static final int _8 = 2275;
		public static final int _9 = 2276;
		public static final int _10 = 3609;
		public static final int _11 = 3610;
		public static final int _12 = 3611;
		public static final int _13 = 3612;
		public static final int _14 = 3613;

		public static final int BLUE_QUESTS = _0;
		public static final int GREEN_ACHIEVEMENT_DIARIES = _1;
		public static final int RED_MINIGAMES = _2;
		public static final int PURPLE_KOUREND = _3;
		public static final int ORANGE_ADVENTURE_PATHS = _4;
		public static final int BROWN_CHARACTER_SUMMARY = _9;
	}

	public static final class GrimMusicalnotes
	{
		public static final int _0 = 862;
		public static final int _1 = 863;
		public static final int _2 = 864;

		public static final int BEAMED = _0;
		public static final int CROTCHET = _1;
		public static final int MINIM = _2;
	}

	public static final class IiImplingIcons
	{
		public static final int _0 = 867;
		public static final int _1 = 868;
		public static final int _2 = 869;
		public static final int _3 = 870;
		public static final int _4 = 871;
		public static final int _5 = 872;
		public static final int _6 = 873;
		public static final int _7 = 874;
		public static final int _8 = 875;
		public static final int _9 = 876;
		public static final int _10 = 877;
		public static final int _11 = 878;

		public static final int GOURMET = _0;
		public static final int BABY = _1;
		public static final int DRAGON = _2;
		public static final int NATURE = _3;
		public static final int ECLECTIC = _4;
		public static final int IMPLING_IN_JAR = _5;
		public static final int YOUNG = _6;
		public static final int MAGPIE = _7;
		public static final int ESSENCE = _8;
		public static final int EARTH = _9;
		public static final int NINJA = _10;
		public static final int LUCKY = _11;
	}

	public static final class AmeConfirmButton
	{
		public static final int _0 = 879;
		public static final int _1 = 880;

		public static final int BUTTON = _0;
		public static final int HOVERED = _1;
	}

	public static final class SideiconsNew
	{
		public static final int _0 = 881;
		public static final int _1 = 882;
		public static final int _2 = 883;
		public static final int _3 = 884;
		public static final int _4 = 885;
		public static final int _5 = 886;
		public static final int _6 = 887;
		public static final int _7 = 888;
		public static final int _8 = 889;
		public static final int _9 = 890;
		public static final int _10 = 891;
		public static final int _11 = 892;
		public static final int _12 = 893;
		public static final int _13 = 894;
		public static final int _14 = 895;
		public static final int _15 = 896;

		public static final int COMBAT = _0;
		public static final int STATS = _1;
		public static final int QUESTS = _2;
		public static final int EQUIPMENT = _4;
		public static final int PRAYER = _5;
		public static final int MAGIC = _6;
		public static final int FRIENDS = _7;
		public static final int IGNORES = _8;
		public static final int LOGOUT = _9;
		public static final int OPTIONS = _10;
		public static final int EMOTES = _11;
		public static final int MUSIC = _12;
		public static final int HOUSE = _13;
		public static final int SUMMONING = _15;
	}

	public static final class V2StoneButton
	{
		public static final int _0 = 913;
		public static final int _1 = 914;
		public static final int _2 = 915;
		public static final int _3 = 916;
		public static final int _4 = 917;
		public static final int _5 = 918;
		public static final int _6 = 919;
		public static final int _7 = 920;

		public static final int TOP_LEFT = _0;
		public static final int TOP_RIGHT = _1;
		public static final int BOTTOM_LEFT = _2;
		public static final int BOTTOM_RIGHT = _3;
		public static final int LEFT = _4;
		public static final int TOP = _5;
		public static final int RIGHT = _6;
		public static final int BOTTOM = _7;
	}

	public static final class V2StoneButtonIn
	{
		public static final int _0 = 921;
		public static final int _1 = 922;
		public static final int _2 = 923;
		public static final int _3 = 924;
		public static final int _4 = 925;
		public static final int _5 = 926;
		public static final int _6 = 927;
		public static final int _7 = 928;
		public static final int _8 = 1546;
		public static final int _9 = 1547;
		public static final int _10 = 1548;
		public static final int _11 = 1549;
		public static final int _12 = 1550;
		public static final int _13 = 1551;
		public static final int _14 = 1552;
		public static final int _15 = 1553;
		public static final int _16 = 4692;
		public static final int _17 = 4693;
		public static final int _18 = 4694;
		public static final int _19 = 4695;
		public static final int _20 = 4696;
		public static final int _21 = 4697;
		public static final int _22 = 4698;
		public static final int _23 = 4699;

		public static final int A_TOP_LEFT = _0;
		public static final int A_TOP_RIGHT = _1;
		public static final int A_BOTTOM_LEFT = _2;
		public static final int A_BOTTOM_RIGHT = _3;
		public static final int A_LEFT = _4;
		public static final int A_TOP = _5;
		public static final int A_RIGHT = _6;
		public static final int A_BOTTOM = _7;
		public static final int B_TOP_LEFT = _8;
		public static final int B_TOP_RIGHT = _9;
		public static final int B_BOTTOM_LEFT = _10;
		public static final int B_BOTTOM_RIGHT = _11;
		public static final int B_LEFT = _12;
		public static final int B_TOP = _13;
		public static final int B_RIGHT = _14;
		public static final int B_BOTTOM = _15;
	}

	public static final class V2StoneButtonOut
	{
		public static final int _0 = 929;
		public static final int _1 = 930;
		public static final int _2 = 931;
		public static final int _3 = 932;
		public static final int _4 = 933;
		public static final int _5 = 934;
		public static final int _6 = 935;
		public static final int _7 = 936;
		public static final int _8 = 1554;
		public static final int _9 = 1555;
		public static final int _10 = 1556;
		public static final int _11 = 1557;
		public static final int _12 = 1558;
		public static final int _13 = 1559;
		public static final int _14 = 1560;
		public static final int _15 = 1561;
		public static final int _16 = 4700;
		public static final int _17 = 4701;
		public static final int _18 = 4702;
		public static final int _19 = 4703;
		public static final int _20 = 4704;
		public static final int _21 = 4705;
		public static final int _22 = 4706;
		public static final int _23 = 4707;

		public static final int A_TOP_LEFT = _0;
		public static final int A_TOP_RIGHT = _1;
		public static final int A_BOTTOM_LEFT = _2;
		public static final int A_BOTTOM_RIGHT = _3;
		public static final int A_MAP_EDGE_LEFT = _4;
		public static final int A_MAP_EDGE_TOP = _5;
		public static final int A_MAP_EDGE_RIGHT = _6;
		public static final int A_MAP_EDGE_BOTTOM = _7;
		public static final int B_TOP_LEFT = _8;
		public static final int B_TOP_RIGHT = _9;
		public static final int B_BOTTOM_LEFT = _10;
		public static final int B_BOTTOM_RIGHT = _11;
		public static final int B_LEFT = _12;
		public static final int B_TOP = _13;
		public static final int B_RIGHT = _14;
		public static final int B_BOTTOM = _15;
	}

	public static final class AmeConfirmButtonNoBack
	{
		public static final int _0 = 938;
		public static final int _1 = 939;

		public static final int THUMB_UP = _0;
		public static final int THUMB_UP_HOVERED = _1;
	}

	public static final class WarningIcons
	{
		public static final int _0 = 940;
		public static final int _1 = 941;
		public static final int _2 = 942;

		public static final int DISABLED = _0;
		public static final int ROUND_CHECK_BUTTON = _1;
		public static final int ROUND_CHECK_BUTTON_CHECKED = _2;
	}

	public static final class Tabs
	{
		public static final int _0 = 952;
		public static final int _1 = 953;

		public static final int SLANTED_TAB = _0;
		public static final int SLANTED_TAB_HOVERED = _1;
	}

	public static final class V2StoneBordersAlt
	{
		public static final int _0 = 954;
		public static final int _1 = 955;
		public static final int _2 = 956;
		public static final int _3 = 957;
		public static final int _4 = 958;
		public static final int _5 = 959;
		public static final int _6 = 960;
		public static final int _7 = 961;
		public static final int _8 = 962;
		public static final int _9 = 963;
		public static final int _10 = 964;
		public static final int _11 = 965;
		public static final int _12 = 966;
		public static final int _13 = 967;
		public static final int _14 = 968;
		public static final int _15 = 969;
		public static final int _16 = 970;
		public static final int _17 = 971;
		public static final int _18 = 972;
		public static final int _19 = 973;
		public static final int _20 = 974;
		public static final int _21 = 975;
		public static final int _22 = 976;
		public static final int _23 = 977;
		public static final int _24 = 978;
		public static final int _25 = 979;
		public static final int _26 = 980;
		public static final int _27 = 981;
		public static final int _28 = 982;
		public static final int _29 = 983;
		public static final int _30 = 984;
		public static final int _31 = 985;
		public static final int _32 = 986;
	}

	public static final class V2BordersSlim
	{
		public static final int _0 = 987;
		public static final int _1 = 988;
		public static final int _2 = 989;
		public static final int _3 = 990;
		public static final int _4 = 991;
		public static final int _5 = 992;
		public static final int _6 = 993;
		public static final int _7 = 994;
		public static final int _8 = 995;
		public static final int _9 = 996;
		public static final int _10 = 997;
		public static final int _11 = 2864;
		public static final int _12 = 2865;
		public static final int _13 = 2866;
		public static final int _14 = 2867;
		public static final int _15 = 2868;
		public static final int _16 = 2869;
		public static final int _17 = 2870;
		public static final int _18 = 2871;
		public static final int _19 = 2872;
		public static final int _20 = 2873;
		public static final int _21 = 2874;
		public static final int _22 = 2875;
		public static final int _23 = 2876;
		public static final int _24 = 2877;
		public static final int _25 = 2878;
		public static final int _26 = 2879;
		public static final int _27 = 2880;
		public static final int _28 = 2881;
		public static final int _29 = 2882;
		public static final int _30 = 2883;
		public static final int _31 = 2884;
		public static final int _32 = 2885;
		public static final int _33 = 2886;
		public static final int _34 = 2887;
		public static final int _35 = 2888;
		public static final int _36 = 2889;
		public static final int _37 = 2890;
		public static final int _38 = 2891;
		public static final int _39 = 2892;
		public static final int _40 = 2893;
		public static final int _41 = 2894;
		public static final int _42 = 2895;
		public static final int _43 = 2896;

		public static final int HORIZONTAL_A = _0;
		public static final int VERTICAL_A = _1;
		public static final int HORIZONTAL_B = _2;
		public static final int VERTICAL_B = _3;
		public static final int TOP_LEFT = _4;
		public static final int TOP_RIGHT = _5;
		public static final int BOTTOM_LEFT = _6;
		public static final int BOTTOM_RIGHT = _7;
		public static final int HORIZONTAL_C = _8;
		public static final int INTERSECTION_LEFT = _9;
		public static final int INTERSECTION_RIGHT = _10;
	}

	public static final class TabsSplit
	{
		public static final int _0 = 998;
		public static final int _1 = 999;
		public static final int _2 = 1000;
		public static final int _3 = 1001;
		public static final int _4 = 1002;
		public static final int _5 = 1003;

		public static final int EDGE_LEFT = _0;
		public static final int MIDDLE = _1;
		public static final int EDGE_RIGHT = _2;
		public static final int EDGE_LEFT_HOVERED = _3;
		public static final int MIDDLE_HOVERED = _4;
		public static final int EDGE_RIGHT_HOVERED = _5;
	}

	public static final class SettingsTabs
	{
		public static final int _0 = 1004;
		public static final int _1 = 1005;
		public static final int _2 = 1006;
		public static final int _3 = 1007;
		public static final int _4 = 1008;
		public static final int _5 = 1009;
		public static final int _6 = 1010;
		public static final int _7 = 1011;
		public static final int _8 = 1012;
		public static final int _9 = 1013;
		public static final int _10 = 1014;
		public static final int _11 = 2834;
		public static final int _12 = 2835;
		public static final int _13 = 2836;
		public static final int _14 = 2837;
		public static final int _15 = 2838;
		public static final int _16 = 2839;
		public static final int _17 = 2840;
		public static final int _18 = 2841;
		public static final int _19 = 2842;
		public static final int _20 = 2843;
		public static final int _21 = 2844;
		public static final int _22 = 2845;
		public static final int _23 = 2846;
		public static final int _24 = 3614;
		public static final int _25 = 3615;
		public static final int _26 = 3616;
		public static final int _27 = 3617;
		public static final int _28 = 3618;
		public static final int _29 = 3619;
		public static final int _30 = 3620;
		public static final int _31 = 3621;
	}

	public static final class TabsLarge
	{
		public static final int _0 = 1015;
		public static final int _1 = 1016;

		public static final int TAB = _0;
		public static final int HOVERED = _1;
	}

	public static final class PvpwIcons
	{
		public static final int _4 = 1020;
		public static final int _0 = 1046;
		public static final int _1 = 1047;
		public static final int _2 = 1239;
		public static final int _3 = 2225;
		public static final int _5 = 3380;
		public static final int _6 = 3381;
		public static final int _7 = 3406;

		public static final int PLAYER_KILLER_SKULL = _0;
		public static final int PLAYER_KILLING_DISABLED_OVERLAY = _1;
		public static final int DEADMAN_EXCLAMATION_MARK_SKULLED_WARNING = _2;
	}

	public static final class MenuButtons
	{
		public static final int _4 = 1021;
		public static final int _5 = 1022;
		public static final int _0 = 2289;
		public static final int _1 = 2290;
		public static final int _2 = 2521;
		public static final int _3 = 2522;
		public static final int _6 = 4539;
		public static final int _7 = 4540;
		public static final int _8 = 4541;
		public static final int _9 = 4542;
		public static final int _10 = 4543;
		public static final int _11 = 4544;
	}

	public static final class MagicNecroOn
	{
		public static final int _50 = 1023;
		public static final int _51 = 1024;
		public static final int _52 = 1025;
		public static final int _53 = 1101;
		public static final int _0 = 1247;
		public static final int _1 = 1248;
		public static final int _2 = 1249;
		public static final int _3 = 1250;
		public static final int _4 = 1251;
		public static final int _5 = 1252;
		public static final int _6 = 1253;
		public static final int _7 = 1254;
		public static final int _8 = 1255;
		public static final int _9 = 1256;
		public static final int _10 = 1257;
		public static final int _11 = 1258;
		public static final int _12 = 1259;
		public static final int _13 = 1260;
		public static final int _14 = 1261;
		public static final int _15 = 1262;
		public static final int _16 = 1263;
		public static final int _17 = 1264;
		public static final int _18 = 1265;
		public static final int _19 = 1266;
		public static final int _20 = 1267;
		public static final int _21 = 1268;
		public static final int _22 = 1269;
		public static final int _23 = 1270;
		public static final int _24 = 1271;
		public static final int _25 = 1300;
		public static final int _26 = 1301;
		public static final int _27 = 1302;
		public static final int _28 = 1303;
		public static final int _29 = 1304;
		public static final int _30 = 1305;
		public static final int _31 = 1306;
		public static final int _32 = 1307;
		public static final int _33 = 1308;
		public static final int _34 = 1309;
		public static final int _35 = 1310;
		public static final int _36 = 1311;
		public static final int _37 = 1312;
		public static final int _38 = 1313;
		public static final int _39 = 1314;
		public static final int _40 = 1315;
		public static final int _41 = 1316;
		public static final int _42 = 1317;
		public static final int _43 = 1318;
		public static final int _54 = 1719;
		public static final int _55 = 1720;
		public static final int _56 = 1721;
		public static final int _57 = 1722;
		public static final int _58 = 1723;
		public static final int _59 = 1724;
		public static final int _44 = 2979;
		public static final int _45 = 2980;
		public static final int _46 = 2981;
		public static final int _47 = 2982;
		public static final int _48 = 2983;
		public static final int _49 = 2984;

		public static final int BASIC_REANIMATION = _0;
		public static final int ADEPT_REANIMATION = _1;
		public static final int EXPERT_REANIMATION = _2;
		public static final int MASTER_REANIMATION = _3;
		public static final int ARCEUUS_LIBRARY_TELEPORT = _5;
		public static final int DRAYNOR_MANOR_TELEPORT = _6;
		public static final int SALVE_GRAVEYARD_TELEPORT = _7;
		public static final int MIND_ALTAR_TELEPORT = _9;
		public static final int RESPAWN_TELEPORT = _10;
		public static final int FENKENSTRAINS_CASTLE_TELEPORT = _12;
		public static final int WEST_ARDOUGNE_TELEPORT = _13;
		public static final int HARMONY_ISLAND_TELEPORT = _14;
		public static final int BARROWS_TELEPORT = _15;
		public static final int APE_ATOLL_TELEPORT = _16;
		public static final int CEMETERY_TELEPORT = _17;
		public static final int RESURRECT_CROPS = _19;
		public static final int GHOSTLY_GRASP = _20;
		public static final int SKELETAL_GRASP = _21;
		public static final int UNDEAD_GRASP = _22;
		public static final int RESURRECT_LESSER_GHOST = _23;
		public static final int INFERIOR_DEMONBANE = _27;
		public static final int SUPERIOR_DEMONBANE = _28;
		public static final int DARK_DEMONBANE = _29;
		public static final int MARK_OF_DARKNESS = _30;
		public static final int WARD_OF_ARCEUUS = _31;
		public static final int LESSER_CORRUPTION = _32;
		public static final int GREATER_CORRUPTION = _33;
		public static final int DEATH_CHARGE = _35;
		public static final int DEMONIC_OFFERING = _36;
		public static final int SINISTER_OFFERING = _37;
		public static final int SHADOW_VEIL = _40;
		public static final int DARK_LURE = _41;
		public static final int VILE_VIGOUR = _42;
		public static final int DEGRIME = _43;
		public static final int RESURRECT_SUPERIOR_SKELETON = _46;
		public static final int RESURRECT_GREATER_ZOMBIE = _49;
	}

	public static final class SideStoneHighlights
	{
		public static final int _0 = 1026;
		public static final int _1 = 1027;
		public static final int _2 = 1028;
		public static final int _3 = 1029;
		public static final int _4 = 1030;

		public static final int TOP_LEFT = _0;
		public static final int TOP_RIGHT = _1;
		public static final int BOTTOM_LEFT = _2;
		public static final int BOTTOM_RIGHT = _3;
		public static final int MIDDLE = _4;
	}

	public static final class Bankbuttons
	{
		public static final int _0 = 1041;
		public static final int _1 = 1042;
		public static final int _2 = 1043;
		public static final int _3 = 1074;
		public static final int _4 = 1226;
		public static final int _5 = 1227;
		public static final int _6 = 1235;
		public static final int _7 = 1342;
		public static final int _8 = 2226;
		public static final int _9 = 2818;
		public static final int _10 = 2819;
		public static final int _11 = 2820;
		public static final int _12 = 2821;
		public static final int _13 = 2822;
		public static final int _14 = 2823;
		public static final int _15 = 2824;

		public static final int DEPOSIT_INVENTORY = _0;
		public static final int DEPOSIT_EQUIPMENT = _1;
		public static final int SEARCH = _2;
		public static final int DEPOSIT_LOOTING_BAG = _3;
		public static final int RAID_SEND_TO_INVENTORY = _4;
		public static final int RAID_SEND_TO_BANK = _5;
		public static final int RAID_SEND_TO_TRASH = _6;
		public static final int PLACEHOLDERS_LOCK = _7;
	}

	public static final class Sortarrows
	{
		public static final int _0 = 1050;
		public static final int _1 = 1051;

		public static final int ASCENDING = _0;
		public static final int DESCENDING = _1;
	}

	public static final class OrbIcon
	{
		public static final int _4 = 1058;
		public static final int _0 = 1067;
		public static final int _1 = 1068;
		public static final int _2 = 1069;
		public static final int _3 = 1070;
		public static final int _5 = 1092;
		public static final int _6 = 1610;
		public static final int _7 = 1668;
		public static final int _8 = 3015;
		public static final int _9 = 3016;
		public static final int _10 = 3017;
		public static final int _11 = 3018;
		public static final int _12 = 3019;
		public static final int _13 = 3020;
		public static final int _14 = 3021;
		public static final int _15 = 3022;
		public static final int _16 = 5755;
		public static final int _17 = 5756;
		public static final int _18 = 5757;
		public static final int _19 = 5758;
		public static final int _20 = 5759;
		public static final int _21 = 5760;
		public static final int _22 = 5761;
		public static final int _23 = 5762;

		public static final int PRAYER_ICON_ACTIVATED = _4;
		public static final int HITPOINTS = _0;
		public static final int PRAYER = _1;
		public static final int WALK = _2;
		public static final int RUN = _3;
		public static final int RUN_ICON_SLOWED_DEPLETION = _5;
		public static final int SPECIAL = _6;
	}

	public static final class OrbFiller
	{
		public static final int _0 = 1059;
		public static final int _1 = 1060;
		public static final int _2 = 1061;
		public static final int _3 = 1062;
		public static final int _4 = 1063;
		public static final int _5 = 1064;
		public static final int _6 = 1065;
		public static final int _7 = 1066;
		public static final int _8 = 1102;
		public static final int _9 = 1607;
		public static final int _10 = 1608;
		public static final int _11 = 1609;
		public static final int _12 = 1636;
		public static final int _13 = 1637;
		public static final int _14 = 2208;
		public static final int _15 = 3574;
		public static final int _16 = 3575;
		public static final int _17 = 3576;
		public static final int _18 = 4547;
		public static final int _19 = 4548;
		public static final int _20 = 4549;

		public static final int EMPTY = _0;
		public static final int HITPOINTS = _1;
		public static final int HITPOINTS_POISON = _2;
		public static final int HITPOINTS_DISEASE = _3;
		public static final int PRAYER = _4;
		public static final int RUN = _5;
		public static final int RUN_ACTIVATED = _6;
		public static final int PRAYER_ACTIVATED = _7;
		public static final int HITPOINTS_VENOM = _8;
		public static final int SPECIAL = _9;
		public static final int SPECIAL_ACTIVATED = _10;
	}

	public static final class OrbFrame
	{
		public static final int _0 = 1071;
		public static final int _1 = 1072;
		public static final int _2 = 2140;

		public static final int FRAME = _0;
		public static final int FRAME_HOVERED = _1;
	}

	public static final class Banktabs
	{
		public static final int _0 = 1077;
		public static final int _1 = 1078;
		public static final int _2 = 1079;
		public static final int _3 = 1080;

		public static final int TAB = _0;
		public static final int HOVERED = _1;
		public static final int SELECTED = _2;
		public static final int EMPTY = _3;
	}

	public static final class BanktabIcons
	{
		public static final int _0 = 1081;
		public static final int _1 = 1082;
		public static final int _2 = 1083;
		public static final int _3 = 2417;

		public static final int ALL_ITEMS = _0;
		public static final int ADD = _1;
		public static final int WRENCH = _2;
		public static final int EQUIPMENT = _3;
	}

	public static final class SpeedrunTrophies
	{
		public static final int _4 = 1103;
		public static final int _0 = 3581;
		public static final int _1 = 3582;
		public static final int _2 = 4340;
		public static final int _3 = 4341;
	}

	public static final class Hitmark
	{
		public static final int _14 = 1105;
		public static final int _15 = 1339;
		public static final int _0 = 1358;
		public static final int _1 = 1359;
		public static final int _2 = 1360;
		public static final int _3 = 1361;
		public static final int _4 = 1362;
		public static final int _5 = 1363;
		public static final int _6 = 1419;
		public static final int _16 = 1544;
		public static final int _7 = 1628;
		public static final int _8 = 1629;
		public static final int _9 = 1630;
		public static final int _10 = 1631;
		public static final int _11 = 1632;
		public static final int _12 = 1633;
		public static final int _13 = 1634;
		public static final int _36 = 2245;
		public static final int _17 = 2270;
		public static final int _18 = 3405;
		public static final int _19 = 3512;
		public static final int _20 = 3519;
		public static final int _21 = 3520;
		public static final int _22 = 3569;
		public static final int _23 = 3570;
		public static final int _24 = 3571;
		public static final int _25 = 3572;
		public static final int _26 = 3573;
		public static final int _27 = 4556;
		public static final int _28 = 4557;
		public static final int _29 = 4558;
		public static final int _30 = 4559;
		public static final int _31 = 4560;
		public static final int _32 = 4561;
		public static final int _33 = 4562;
		public static final int _34 = 4563;
		public static final int _35 = 4564;
		public static final int _37 = 4763;
		public static final int _38 = 4764;
		public static final int _39 = 4765;
		public static final int _40 = 4766;
		public static final int _41 = 4767;
		public static final int _42 = 4768;
		public static final int _43 = 4769;
		public static final int _44 = 4770;

		public static final int SPECIALEFFECT_PROMO_BANNER = _14;
		public static final int HITSPLAT_BLUE_MISS = _0;
		public static final int HITSPLAT_GREEN_POISON = _2;
		public static final int DEADMAN_SPECIAL_LOGO = _16;
		public static final int HITSPLAT_DARK_GREEN_VENOM = _11;
		public static final int COLOSSEUM_DOOM = _40;
		public static final int BURN_DAMAGE = _41;
	}

	public static final class GeIcons
	{
		public static final int _0 = 1106;
		public static final int _1 = 1107;
		public static final int _2 = 1108;
		public static final int _3 = 1109;
		public static final int _4 = 1110;
		public static final int _5 = 1111;

		public static final int MAKE_OFFER_SELL = _0;
		public static final int MAKE_OFFER_SELL_HOVERED = _1;
		public static final int MAKE_OFFER_BUY = _2;
		public static final int MAKE_OFFER_BUY_HOVERED = _3;
		public static final int BUTTON = _4;
		public static final int BUTTON_HOVERED = _5;
	}

	public static final class GeSmallicons
	{
		public static final int _0 = 1112;
		public static final int _1 = 1113;
		public static final int _2 = 1114;
		public static final int _3 = 1115;
		public static final int _4 = 1116;
		public static final int _5 = 1117;
		public static final int _6 = 1118;
		public static final int _7 = 1119;

		public static final int GUIDE_PRICE = _0;
		public static final int SEARCH = _1;
		public static final int FAST_DECREMENT_ARROW = _2;
		public static final int FAST_INCREMENT_ARROW = _3;
		public static final int DECREMENT_BUTTON = _4;
		public static final int INCREMENT_BUTTON = _5;
		public static final int COLLECTION_BOX_OFFER_BUY = _6;
		public static final int COLLECTION_BOX_OFFER_SELL = _7;
	}

	public static final class GeTextbackdrop
	{
		public static final int _0 = 1123;
		public static final int _1 = 1124;
		public static final int _2 = 1125;

		public static final int LEFT = _0;
		public static final int MIDDLE = _1;
		public static final int RIGHT = _2;
	}

	public static final class GeCancel
	{
		public static final int _0 = 1126;
		public static final int _1 = 1127;

		public static final int BUTTON = _0;
		public static final int HOVERED = _1;
	}

	public static final class IconBuffbar32x32
	{
		public static final int _0 = 1128;
		public static final int _1 = 1129;
	}

	public static final class WorldswitcherStars
	{
		public static final int _0 = 1130;
		public static final int _1 = 1131;
		public static final int _2 = 1237;
		public static final int _3 = 1238;
		public static final int _4 = 1338;
		public static final int _5 = 2311;
		public static final int _6 = 4350;
		public static final int _7 = 4671;
		public static final int _8 = 4924;
		public static final int _9 = 4927;
		public static final int _10 = 4928;
		public static final int _11 = 4929;
		public static final int _12 = 4930;
		public static final int _13 = 4931;
		public static final int _14 = 4932;
		public static final int _15 = 4933;
		public static final int _16 = 4934;
		public static final int _17 = 4935;

		public static final int FREE = _0;
		public static final int MEMBERS = _1;
		public static final int PVP = _2;
		public static final int DEADMAN = _3;
		public static final int BLUE = _4;
	}

	public static final class WorldswitcherFlags
	{
		public static final int _0 = 1132;
		public static final int _1 = 1133;
		public static final int _2 = 1134;
		public static final int _3 = 1135;
		public static final int _4 = 1136;
		public static final int _5 = 1137;
		public static final int _6 = 1138;
		public static final int _7 = 1139;
		public static final int _8 = 1140;
		public static final int _9 = 4936;
		public static final int _10 = 4937;
		public static final int _11 = 4938;

		public static final int NONE = _0;
		public static final int USA = _1;
		public static final int CANADA = _2;
		public static final int UK = _3;
		public static final int NETHERLANDS = _4;
		public static final int AUSTRALIA = _5;
		public static final int SWEDEN = _6;
		public static final int FINLAND = _7;
		public static final int GERMANY = _8;
		public static final int US_WEST = _9;
		public static final int US_EAST = _10;
	}

	public static final class WindowmodeIcons
	{
		public static final int _0 = 1169;
		public static final int _1 = 1170;
		public static final int _2 = 1171;
		public static final int _3 = 1172;
		public static final int _4 = 1572;
		public static final int _5 = 1573;
		public static final int _6 = 1574;
		public static final int _7 = 1575;

		public static final int FIXED_MODE_DISABLED = _0;
		public static final int RESIZEABLE_MODE_DISABLED = _1;
		public static final int FIXED_MODE_DISABLED_VERTICAL = _2;
		public static final int RESIZEABLE_MODE_DISABLED_VERTICAL = _3;
		public static final int FIXED_MODE_ENABLED = _4;
		public static final int RESIZEABLE_MODE_ENABLED = _5;
		public static final int FIXED_MODE_ENABLED_VERTICAL = _6;
		public static final int RESIZEABLE_MODE_ENABLED_VERTICAL = _7;
	}

	public static final class OsrsStretchSideTopbottom
	{
		public static final int _0 = 1173;
		public static final int _1 = 1174;

		public static final int TOP_ROW = _0;
		public static final int BOTTOM_ROW = _1;
	}

	public static final class OsrsStretchSideColumns
	{
		public static final int _0 = 1175;
		public static final int _1 = 1176;

		public static final int EDGE_LEFT = _0;
		public static final int EDGE_RIGHT = _1;
	}

	public static final class PreEocStones
	{
		public static final int _0 = 1180;
		public static final int _1 = 1181;

		public static final int MIDDLE = _0;
		public static final int MIDDLE_SELECTED = _1;
	}

	public static final class ScrollbarTransArrows
	{
		public static final int _0 = 1185;
		public static final int _1 = 1186;

		public static final int UP = _0;
		public static final int DOWN = _1;
	}

	public static final class ScrollbarTransDragger
	{
		public static final int _0 = 1187;
		public static final int _1 = 1188;
		public static final int _2 = 1189;
		public static final int _3 = 1190;

		public static final int THUMB_TOP = _0;
		public static final int THUMB_MIDDLE = _1;
		public static final int THUMB_BOTTOM = _3;
	}

	public static final class OrbXp
	{
		public static final int _0 = 1196;
		public static final int _1 = 1197;
		public static final int _2 = 1198;
		public static final int _3 = 1199;

		public static final int ORB = _0;
		public static final int ACTIVATED = _1;
		public static final int HOVERED = _2;
		public static final int ACTIVATED_HOVERED = _3;
	}

	public static final class Checkbox
	{
		public static final int _0 = 1215;
		public static final int _1 = 1216;
		public static final int _2 = 1217;
		public static final int _3 = 1218;
		public static final int _4 = 1219;
		public static final int _5 = 1220;

		public static final int EMPTY = _0;
		public static final int CROSSED = _1;
		public static final int CHECKED = _2;
		public static final int HOVERED = _3;
		public static final int CROSSED_HOVERED = _4;
		public static final int CHECKED_HOVERED = _5;
	}

	public static final class CombatboxesSplit
	{
		public static final int _0 = 1229;
		public static final int _1 = 1230;
		public static final int _2 = 1231;
		public static final int _3 = 1232;
		public static final int _4 = 1233;
		public static final int _5 = 1234;

		public static final int LEFT = _0;
		public static final int MIDDLE = _1;
		public static final int RIGHT = _2;
		public static final int LEFT_SELECTED = _3;
		public static final int MIDDLE_SELECTED = _4;
		public static final int RIGHT_SELECTED = _5;
	}

	public static final class ZeahBook
	{
		public static final int _0 = 1240;
		public static final int _1 = 1241;

		public static final int BUTTON = _0;
		public static final int HOVERED = _1;
	}

	public static final class MagicNecroOff
	{
		public static final int _0 = 1272;
		public static final int _1 = 1273;
		public static final int _2 = 1274;
		public static final int _3 = 1275;
		public static final int _4 = 1276;
		public static final int _5 = 1277;
		public static final int _6 = 1278;
		public static final int _7 = 1279;
		public static final int _8 = 1280;
		public static final int _9 = 1281;
		public static final int _10 = 1282;
		public static final int _11 = 1283;
		public static final int _12 = 1284;
		public static final int _13 = 1285;
		public static final int _14 = 1286;
		public static final int _15 = 1287;
		public static final int _16 = 1288;
		public static final int _17 = 1289;
		public static final int _18 = 1290;
		public static final int _19 = 1291;
		public static final int _20 = 1292;
		public static final int _21 = 1293;
		public static final int _22 = 1294;
		public static final int _23 = 1295;
		public static final int _24 = 1296;
		public static final int _25 = 1319;
		public static final int _26 = 1320;
		public static final int _27 = 1321;
		public static final int _28 = 1322;
		public static final int _29 = 1323;
		public static final int _30 = 1324;
		public static final int _31 = 1325;
		public static final int _32 = 1326;
		public static final int _33 = 1327;
		public static final int _34 = 1328;
		public static final int _35 = 1329;
		public static final int _36 = 1330;
		public static final int _37 = 1331;
		public static final int _38 = 1332;
		public static final int _39 = 1333;
		public static final int _40 = 1334;
		public static final int _41 = 1335;
		public static final int _42 = 1336;
		public static final int _43 = 1337;
		public static final int _50 = 1725;
		public static final int _44 = 2985;
		public static final int _45 = 2986;
		public static final int _46 = 2987;
		public static final int _47 = 2988;
		public static final int _48 = 2989;
		public static final int _49 = 2990;
		public static final int _51 = 3351;
		public static final int _52 = 3352;
		public static final int _53 = 3353;
		public static final int _54 = 3354;
		public static final int _55 = 3355;
		public static final int _56 = 3356;
		public static final int _57 = 3357;
		public static final int _58 = 3358;
		public static final int _59 = 3359;

		public static final int MARK_OF_DARKNESS_DISABLED = _30;
		public static final int WARD_OF_ARCEUUS_DISABLED = _31;
		public static final int GREATER_CORRUPTION_DISABLED = _33;
		public static final int DEATH_CHARGE_DISABLED = _35;
		public static final int SHADOW_VEIL_DISABLED = _40;
		public static final int RESURRECT_SUPERIOR_SKELETON_DISABLED = _46;
	}

	public static final class FavouriteIcons
	{
		public static final int _0 = 1340;
		public static final int _1 = 1341;

		public static final int REMOVE = _0;
		public static final int ADD = _1;
	}

	public static final class BanktabsSmall
	{
		public static final int _0 = 1344;
		public static final int _1 = 1345;
	}

	public static final class DeadmanDeathtype
	{
		public static final int _0 = 1346;
		public static final int _1 = 1347;
		public static final int _2 = 1348;
		public static final int _3 = 1349;

		public static final int DEATH_TO_PVM = _0;
		public static final int DEATH_TO_PVP = _1;
		public static final int DEATH_WHILE_SKULLED = _2;
		public static final int DEATH_WHILE_SKULLED_IN_SAFE_ZONE = _3;
	}

	public static final class FastForward
	{
		public static final int _0 = 1364;
		public static final int _1 = 1365;

		public static final int BUTTON = _0;
		public static final int HOVERED = _1;
	}

	public static final class PohRoomLayouts
	{
		public static final int _0 = 1368;
		public static final int _1 = 1369;
		public static final int _2 = 1370;
		public static final int _3 = 1371;
		public static final int _4 = 1372;
		public static final int _5 = 1373;
		public static final int _6 = 1374;
		public static final int _7 = 1375;
		public static final int _8 = 1376;
		public static final int _9 = 1377;
		public static final int _10 = 1378;
		public static final int _11 = 1379;
		public static final int _12 = 1380;
		public static final int _13 = 1381;
		public static final int _14 = 1382;
		public static final int _15 = 1383;
		public static final int _16 = 1384;
		public static final int _17 = 1385;
		public static final int _18 = 1386;
		public static final int _19 = 1387;
		public static final int _20 = 1388;
		public static final int _21 = 1389;
		public static final int _22 = 1390;
		public static final int _23 = 1391;
		public static final int _24 = 1392;
		public static final int _25 = 1393;
		public static final int _26 = 1394;
		public static final int _27 = 1395;

		public static final int PARLOUR = _0;
		public static final int GARDEN = _1;
		public static final int KITCHEN = _2;
		public static final int DINING_ROOM = _3;
		public static final int BEDROOM = _4;
		public static final int GAMES_ROOM = _5;
		public static final int SKILL_HALL = _6;
		public static final int QUEST_HALL = _7;
		public static final int CHAPEL = _8;
		public static final int WORKSHOP = _9;
		public static final int STUDY = _10;
		public static final int PORTAL_CHAMBER = _11;
		public static final int THRONE_ROOM = _12;
		public static final int OUBLIETTE = _13;
		public static final int DUNGEON_CORRIDOR = _14;
		public static final int DUNGEON_JUNCTION = _15;
		public static final int DUNGEON_STAIRS_ROOM = _16;
		public static final int TREASURE_ROOM = _17;
		public static final int FORMAL_GARDEN = _18;
		public static final int COMBAT_ROOM = _19;
		public static final int COSTUME_ROOM = _20;
		public static final int MENAGERIE_INDOORS = _21;
		public static final int MENAGERIE_OUTDOORS = _22;
		public static final int SUPERIOR_GARDEN = _23;
		public static final int ACHIEVEMENT_GALLERY = _24;
	}

	public static final class WintIcons
	{
		public static final int _0 = 1397;
		public static final int _1 = 1398;
		public static final int _2 = 1399;
		public static final int _3 = 1400;

		public static final int CRAFTING = _0;
		public static final int FIREMAKING_LOGS = _1;
		public static final int FIREMAKING = _2;
		public static final int MAGIC_RED = _3;
	}

	public static final class TinyCombatStaticons
	{
		public static final int _0 = 1401;
		public static final int _1 = 1402;
		public static final int _2 = 1403;
		public static final int _3 = 1404;
		public static final int _4 = 1405;
		public static final int _5 = 1406;
		public static final int _6 = 1407;

		public static final int ATTACK = _0;
		public static final int STRENGTH = _1;
		public static final int DEFENCE = _2;
		public static final int RANGED = _3;
		public static final int PRAYER = _4;
		public static final int MAGIC = _5;
		public static final int HITPOINTS = _6;
	}

	public static final class IronIcons
	{
		public static final int _5 = 1408;
		public static final int _0 = 3548;
		public static final int _1 = 3549;
		public static final int _2 = 3550;
		public static final int _3 = 3551;
		public static final int _4 = 3552;
	}

	public static final class PvpaRankicons
	{
		public static final int _0 = 1409;
		public static final int _1 = 1410;
		public static final int _2 = 1411;
		public static final int _3 = 4517;
		public static final int _4 = 4518;
		public static final int _5 = 4519;
		public static final int _6 = 4520;
		public static final int _7 = 4521;
	}

	public static final class HeadbarShield100
	{
		public static final int _0 = 1415;
		public static final int _1 = 1416;

		public static final int COX_GREEN = _0;
		public static final int COX_BLUE = _1;
	}

	public static final class HeadbarOlmtimer100
	{
		public static final int _0 = 1417;
		public static final int _1 = 1418;

		public static final int YELLOW = _0;
		public static final int RED = _1;
	}

	public static final class Reset
	{
		public static final int _0 = 1428;
		public static final int _1 = 1429;

		public static final int BUTTON = _0;
		public static final int HOVERED = _1;
	}

	public static final class Clickcross
	{
		public static final int _0 = 1430;
		public static final int _1 = 1431;
		public static final int _2 = 1432;
		public static final int _3 = 1433;
		public static final int _4 = 1434;
		public static final int _5 = 1435;
		public static final int _6 = 1436;
		public static final int _7 = 1437;

		public static final int YELLOW_CLICK_ANIMATION_1 = _0;
		public static final int YELLOW_CLICK_ANIMATION_2 = _1;
		public static final int YELLOW_CLICK_ANIMATION_3 = _2;
		public static final int YELLOW_CLICK_ANIMATION_4 = _3;
		public static final int RED_CLICK_ANIMATION_1 = _4;
		public static final int RED_CLICK_ANIMATION_2 = _5;
		public static final int RED_CLICK_ANIMATION_3 = _6;
		public static final int RED_CLICK_ANIMATION_4 = _7;
	}

	public static final class WorldmapIcon
	{
		public static final int _0 = 1439;
		public static final int _1 = 1440;
		public static final int _2 = 2204;
		public static final int _3 = 2205;

		public static final int PLANET = _0;
		public static final int PLANET_HOVERED = _1;
	}

	public static final class Mapfunction
	{
		public static final int _0 = 1448;
		public static final int _1 = 1449;
		public static final int _2 = 1450;
		public static final int _3 = 1451;
		public static final int _4 = 1452;
		public static final int _5 = 1453;
		public static final int _6 = 1454;
		public static final int _7 = 1455;
		public static final int _8 = 1456;
		public static final int _9 = 1457;
		public static final int _10 = 1458;
		public static final int _11 = 1459;
		public static final int _12 = 1460;
		public static final int _13 = 1461;
		public static final int _14 = 1462;
		public static final int _15 = 1463;
		public static final int _16 = 1464;
		public static final int _17 = 1465;
		public static final int _18 = 1466;
		public static final int _19 = 1467;
		public static final int _20 = 1468;
		public static final int _21 = 1469;
		public static final int _22 = 1470;
		public static final int _23 = 1471;
		public static final int _24 = 1472;
		public static final int _25 = 1473;
		public static final int _26 = 1474;
		public static final int _27 = 1475;
		public static final int _28 = 1476;
		public static final int _29 = 1477;
		public static final int _30 = 1478;
		public static final int _31 = 1479;
		public static final int _32 = 1480;
		public static final int _33 = 1481;
		public static final int _34 = 1482;
		public static final int _35 = 1483;
		public static final int _36 = 1484;
		public static final int _37 = 1485;
		public static final int _38 = 1486;
		public static final int _39 = 1487;
		public static final int _40 = 1488;
		public static final int _41 = 1489;
		public static final int _42 = 1490;
		public static final int _43 = 1491;
		public static final int _44 = 1492;
		public static final int _45 = 1493;
		public static final int _46 = 1494;
		public static final int _47 = 1495;
		public static final int _48 = 1496;
		public static final int _49 = 1497;
		public static final int _50 = 1498;
		public static final int _51 = 1499;
		public static final int _52 = 1500;
		public static final int _53 = 1501;
		public static final int _54 = 1502;
		public static final int _55 = 1503;
		public static final int _56 = 1504;
		public static final int _57 = 1505;
		public static final int _58 = 1506;
		public static final int _59 = 1507;
		public static final int _60 = 1508;
		public static final int _61 = 1509;
		public static final int _62 = 1510;
		public static final int _63 = 1511;
		public static final int _64 = 1512;
		public static final int _65 = 1513;
		public static final int _66 = 1514;
		public static final int _67 = 1515;
		public static final int _68 = 1516;
		public static final int _69 = 1517;
		public static final int _70 = 1518;
		public static final int _71 = 1519;
		public static final int _72 = 1520;
		public static final int _73 = 1521;
		public static final int _74 = 1522;
		public static final int _75 = 1523;
		public static final int _76 = 1524;
		public static final int _77 = 1525;
		public static final int _78 = 1526;
		public static final int _79 = 1527;
		public static final int _80 = 1528;
		public static final int _81 = 1529;
		public static final int _82 = 1530;
		public static final int _83 = 1531;
		public static final int _84 = 1532;
		public static final int _85 = 1533;
		public static final int _86 = 1534;
		public static final int _87 = 1535;
		public static final int _88 = 1536;
		public static final int _89 = 1537;
		public static final int _90 = 1538;
		public static final int _91 = 1669;
		public static final int _92 = 1670;
		public static final int _93 = 1671;
		public static final int _94 = 1672;
		public static final int _95 = 1673;
		public static final int _96 = 1674;
		public static final int _97 = 1675;
		public static final int _98 = 1676;
		public static final int _99 = 1677;
		public static final int _100 = 1678;
		public static final int _101 = 1679;
		public static final int _102 = 1680;
		public static final int _103 = 1681;
		public static final int _104 = 1682;
		public static final int _105 = 1683;
		public static final int _106 = 1684;
		public static final int _107 = 1685;
		public static final int _108 = 1686;
		public static final int _109 = 1687;
		public static final int _110 = 1688;
		public static final int _111 = 1689;
		public static final int _112 = 1690;
		public static final int _113 = 1691;
		public static final int _114 = 1692;
		public static final int _115 = 1693;
		public static final int _116 = 1694;
		public static final int _117 = 1695;
		public static final int _118 = 1696;
		public static final int _119 = 2210;
		public static final int _120 = 2211;
		public static final int _121 = 2212;
		public static final int _122 = 2213;
		public static final int _123 = 2214;
		public static final int _124 = 2215;
		public static final int _125 = 2216;
		public static final int _126 = 2960;
		public static final int _127 = 2961;
		public static final int _128 = 2962;
		public static final int _129 = 2963;
		public static final int _130 = 2964;
		public static final int _131 = 2965;
		public static final int _132 = 2966;
		public static final int _133 = 4941;
		public static final int _134 = 4942;
		public static final int _135 = 4943;
		public static final int _136 = 4944;
		public static final int _137 = 4945;
		public static final int _138 = 4946;
		public static final int _139 = 4947;

		public static final int GENERAL_STORE = _0;
		public static final int SWORD_SHOP = _1;
		public static final int MAGIC_SHOP = _2;
		public static final int AXE_SHOP = _3;
		public static final int HELMET_SHOP = _4;
		public static final int BANK = _5;
		public static final int QUEST_START = _6;
		public static final int AMULET_SHOP = _7;
		public static final int MINING_SITE = _8;
		public static final int FURNACE = _9;
		public static final int ANVIL = _10;
		public static final int COMBAT_TRAINING = _11;
		public static final int DUNGEON = _12;
		public static final int STAFF_SHOP = _13;
		public static final int PLATEBODY_SHOP = _14;
		public static final int PLATELEGS_SHOP = _15;
		public static final int SCIMITAR_SHOP = _16;
		public static final int ARCHERY_SHOP = _17;
		public static final int SHIELD_SHOP = _18;
		public static final int ALTAR = _19;
		public static final int HERBALIST = _20;
		public static final int JEWELLERY_SHOP = _21;
		public static final int GEM_SHOP = _22;
		public static final int CRAFTING_SHOP = _23;
		public static final int CANDLE_SHOP = _24;
		public static final int FISHING_SHOP = _25;
		public static final int FISHING_SPOT = _26;
		public static final int CLOTHES_SHOP = _27;
		public static final int APOTHECARY = _28;
		public static final int SILK_TRADER = _29;
		public static final int FOOD_SHOP_KEBAB = _30;
		public static final int PUB = _31;
		public static final int MACE_SHOP = _32;
		public static final int TANNERY = _33;
		public static final int RARE_TREES = _34;
		public static final int SPINNING_WHEEL = _35;
		public static final int FOOD_SHOP = _36;
		public static final int FOOD_SHOP_CUTLERY = _37;
		public static final int MINIGAME = _38;
		public static final int WATER_SOURCE = _39;
		public static final int COOKING_RANGE = _40;
		public static final int PLATESKIRT_SHOP = _41;
		public static final int POTTERY_WHEEL = _42;
		public static final int WINDMILL = _43;
		public static final int MINING_SHOP = _44;
		public static final int CHAINMAIL_SHOP = _45;
		public static final int SILVER_SHOP = _46;
		public static final int FUR_TRADER = _47;
		public static final int SPICE_SHOP = _48;
		public static final int AGILITY_TRAINING = _49;
		public static final int FOOD_SHOP_FRUIT = _50;
		public static final int SLAYER_MASTER = _51;
		public static final int HAIRDRESSER = _52;
		public static final int FARMING_PATCH = _53;
		public static final int MAKEOVER_MAGE = _54;
		public static final int GUIDE = _55;
		public static final int TRANSPORTATION = _56;
		public static final int HOUSE_PORTAL = _57;
		public static final int FARMING_SHOP = _58;
		public static final int LOOM = _59;
		public static final int BREWERY = _60;
		public static final int DAIRY_CHURN = _61;
		public static final int STAGNANT_WATER_SOURCE = _62;
		public static final int HUNTER_TRAINING = _63;
		public static final int POLL_BOOTH = _64;
		public static final int HUNTER_SHOP = _65;
		public static final int INFORMATION_I_1514 = _66;
		public static final int ESTATE_AGENT = _67;
		public static final int SAWMILL = _68;
		public static final int STONEMASON = _69;
		public static final int AGILITY_SHORT_CUT = _70;
		public static final int WOODCUTTING_STUMP = _71;
		public static final int HOLIDAY_EVENT = _72;
		public static final int SANDPIT = _73;
		public static final int TASK_MASTER = _74;
		public static final int PET_SHOP = _75;
		public static final int BOUNTY_HUNTER_TRADER = _76;
		public static final int IRON_MAN_TUTORS = _77;
		public static final int PRICING_EXPERT_WEAPONS_AND_ARMOUR = _78;
		public static final int PRICING_EXPERT_LOGS = _79;
		public static final int PRICING_EXPERT_HERBS = _80;
		public static final int PRICING_EXPERT_RUNES = _81;
		public static final int PRICING_EXPERT_ORES_AND_BARS = _82;
		public static final int GRAND_EXCHANGE = _83;
		public static final int KOUREND_TASK = _84;
		public static final int RAIDS_LOBBY = _85;
		public static final int MAP_LINK_DOWNSTAIRS = _86;
		public static final int MAP_LINK_UPSTAIRS = _87;
	}

	public static final class WorldmapMarker
	{
		public static final int _0 = 1539;
		public static final int _1 = 1540;
		public static final int _2 = 1541;
		public static final int _3 = 2520;
		public static final int _4 = 2547;
		public static final int _5 = 2548;
		public static final int _6 = 4550;
		public static final int _7 = 4551;
		public static final int _8 = 4552;

		public static final int YOU_ARE_HERE = _0;
		public static final int OFFSCREEN_FOCUS_ARROW = _1;
		public static final int OFFSCREEN_FOCUS_ARROW_DIAGONAL = _2;
	}

	public static final class Arrow
	{
		public static final int _0 = 1542;
		public static final int _1 = 1543;

		public static final int BROWN_UP = _0;
		public static final int YELLOW_UP = _1;
	}

	public static final class PohDoors
	{
		public static final int _0 = 1576;
		public static final int _1 = 1577;
		public static final int _2 = 1578;

		public static final int CLOSED = _0;
		public static final int OPEN = _1;
		public static final int INVISIBLE = _2;
	}

	public static final class Miscgraphics4
	{
		public static final int _0 = 1585;
		public static final int _1 = 1586;
		public static final int _2 = 1587;
		public static final int _3 = 1588;
		public static final int _4 = 1589;
		public static final int _5 = 1590;
		public static final int _6 = 1591;
		public static final int _7 = 1592;
		public static final int _8 = 1593;
		public static final int _9 = 1594;
		public static final int _10 = 1595;
		public static final int _11 = 1596;
		public static final int _12 = 1597;
		public static final int _13 = 1598;
		public static final int _14 = 1599;
	}

	public static final class Thumbs
	{
		public static final int _0 = 1600;
		public static final int _1 = 1601;
		public static final int _2 = 1602;
		public static final int _3 = 1603;

		public static final int UP = _0;
		public static final int DOWN = _1;
		public static final int UP_HOVERED = _2;
		public static final int DOWN_HOVERED = _3;
	}

	public static final class Spectator
	{
		public static final int _0 = 1604;
		public static final int _1 = 1605;
		public static final int _2 = 1606;

		public static final int HITPOINTS = _0;
		public static final int PRAYER = _1;
		public static final int SPECIAL = _2;
	}

	public static final class OsmFnModeIcons
	{
		public static final int _0 = 1623;
		public static final int _1 = 1624;
		public static final int _2 = 1650;
		public static final int _3 = 1651;
		public static final int _4 = 1652;
		public static final int _5 = 1663;
		public static final int _6 = 1664;
		public static final int _7 = 1665;
		public static final int _8 = 1666;
		public static final int _9 = 1667;

		public static final int ENABLED = _0;
		public static final int DISABLED = _1;
	}

	public static final class OsmStatusIcons
	{
		public static final int _0 = 1640;
		public static final int _1 = 1641;
		public static final int _2 = 1642;
		public static final int _3 = 1643;
		public static final int _4 = 1644;
		public static final int _5 = 1645;
		public static final int _6 = 1646;
		public static final int _7 = 1647;
	}

	public static final class WorldmapIconLarge
	{
		public static final int _0 = 1698;
		public static final int _1 = 1699;
		public static final int _2 = 2206;
		public static final int _3 = 2207;
	}

	public static final class AccManIcons
	{
		public static final int _0 = 1704;
		public static final int _1 = 1705;
		public static final int _2 = 1706;
		public static final int _3 = 1707;
		public static final int _4 = 2149;
		public static final int _5 = 2150;
		public static final int _6 = 2151;
		public static final int _7 = 2410;
		public static final int _8 = 2411;
		public static final int _9 = 2412;
		public static final int _10 = 2413;
		public static final int _11 = 2414;
		public static final int _12 = 2415;
		public static final int _13 = 2416;
		public static final int _14 = 2932;
		public static final int _15 = 2933;
		public static final int _16 = 2934;
		public static final int _17 = 2935;
		public static final int _18 = 2936;
		public static final int _19 = 2937;
		public static final int _20 = 2938;
	}

	public static final class OsmFunctionButtons
	{
		public static final int _0 = 1714;
		public static final int _1 = 1715;
		public static final int _2 = 1716;
		public static final int _3 = 1717;
		public static final int _4 = 1718;
	}

	public static final class MobileStones
	{
		public static final int _0 = 1726;
		public static final int _1 = 1727;
	}

	public static final class StoneborderCloseButton
	{
		public static final int _0 = 1729;
		public static final int _1 = 1730;
	}

	public static final class SteelborderCloseButton
	{
		public static final int _0 = 1731;
		public static final int _1 = 1732;
	}

	public static final class OgeTitle
	{
		public static final int _0 = 1733;
		public static final int _1 = 1734;
		public static final int _2 = 1735;
		public static final int _3 = 1736;
		public static final int _4 = 1737;
	}

	public static final class OpenButtons
	{
		public static final int _0 = 1738;
		public static final int _1 = 1739;
		public static final int _2 = 1740;
		public static final int _3 = 1741;
		public static final int _4 = 2291;
		public static final int _5 = 2292;
		public static final int _6 = 2293;
		public static final int _7 = 2294;
	}

	public static final class OgeImages
	{
		public static final int _0 = 1742;
		public static final int _1 = 1743;
		public static final int _2 = 1744;
		public static final int _3 = 1745;
		public static final int _4 = 1746;
	}

	public static final class CombatAutoretaliate
	{
		public static final int _0 = 1748;
		public static final int _1 = 1749;
	}

	public static final class _2XStandardSpellsOff
	{
		public static final int _0 = 1812;
		public static final int _1 = 1813;
		public static final int _2 = 1814;
		public static final int _3 = 1815;
		public static final int _4 = 1816;
		public static final int _5 = 1817;
		public static final int _6 = 1818;
		public static final int _7 = 1819;
		public static final int _8 = 1820;
		public static final int _9 = 1821;
		public static final int _10 = 1822;
		public static final int _11 = 1823;
		public static final int _12 = 1824;
		public static final int _13 = 1825;
		public static final int _14 = 1826;
		public static final int _15 = 1827;
		public static final int _16 = 1828;
		public static final int _17 = 1829;
		public static final int _18 = 1830;
		public static final int _19 = 1831;
		public static final int _20 = 1832;
		public static final int _21 = 1833;
		public static final int _22 = 1834;
		public static final int _23 = 1835;
		public static final int _24 = 1836;
		public static final int _25 = 1837;
		public static final int _26 = 1838;
		public static final int _27 = 1839;
		public static final int _28 = 1840;
		public static final int _29 = 1841;
		public static final int _30 = 1842;
		public static final int _31 = 1843;
		public static final int _32 = 1844;
		public static final int _33 = 1845;
		public static final int _34 = 1846;
		public static final int _35 = 1847;
		public static final int _36 = 1848;
		public static final int _37 = 1849;
		public static final int _38 = 1850;
		public static final int _39 = 1851;
		public static final int _40 = 1852;
		public static final int _41 = 1853;
		public static final int _42 = 1854;
		public static final int _43 = 1855;
		public static final int _44 = 1856;
		public static final int _45 = 1857;
		public static final int _46 = 1858;
		public static final int _47 = 1859;
		public static final int _48 = 1860;
		public static final int _49 = 1861;
		public static final int _50 = 1862;
		public static final int _51 = 1863;
		public static final int _52 = 1864;
		public static final int _53 = 1865;
		public static final int _54 = 1866;
		public static final int _55 = 1867;
		public static final int _56 = 1868;
		public static final int _57 = 1869;
		public static final int _58 = 1870;
		public static final int _59 = 1871;
		public static final int _60 = 1872;
		public static final int _61 = 1873;
		public static final int _62 = 1874;
		public static final int _63 = 1875;
		public static final int _64 = 1876;
		public static final int _65 = 1877;
		public static final int _66 = 1878;
		public static final int _67 = 1879;
		public static final int _68 = 1880;
		public static final int _69 = 1881;
		public static final int _70 = 1882;
		public static final int _71 = 1883;
		public static final int _72 = 1884;
		public static final int _73 = 1885;
		public static final int _74 = 1886;
		public static final int _75 = 1887;
		public static final int _76 = 1888;
		public static final int _77 = 1889;
		public static final int _78 = 1890;
		public static final int _79 = 1891;
	}

	public static final class _2XAncientSpellsOn
	{
		public static final int _0 = 1892;
		public static final int _1 = 1893;
		public static final int _2 = 1894;
		public static final int _3 = 1895;
		public static final int _4 = 1896;
		public static final int _5 = 1897;
		public static final int _6 = 1898;
		public static final int _7 = 1899;
		public static final int _8 = 1900;
		public static final int _9 = 1901;
		public static final int _10 = 1902;
		public static final int _11 = 1903;
		public static final int _12 = 1904;
		public static final int _13 = 1905;
		public static final int _14 = 1906;
		public static final int _15 = 1907;
		public static final int _16 = 1908;
		public static final int _17 = 1909;
		public static final int _18 = 1910;
		public static final int _19 = 1911;
		public static final int _20 = 1912;
		public static final int _21 = 1913;
		public static final int _22 = 1914;
		public static final int _23 = 1915;
		public static final int _24 = 1916;
		public static final int _25 = 1917;
		public static final int _26 = 1918;
		public static final int _27 = 1919;
		public static final int _28 = 1920;
		public static final int _29 = 1921;
	}

	public static final class _2XAncientSpellsOff
	{
		public static final int _0 = 1922;
		public static final int _1 = 1923;
		public static final int _2 = 1924;
		public static final int _3 = 1925;
		public static final int _4 = 1926;
		public static final int _5 = 1927;
		public static final int _6 = 1928;
		public static final int _7 = 1929;
		public static final int _8 = 1930;
		public static final int _9 = 1931;
		public static final int _10 = 1932;
		public static final int _11 = 1933;
		public static final int _12 = 1934;
		public static final int _13 = 1935;
		public static final int _14 = 1936;
		public static final int _15 = 1937;
		public static final int _16 = 1938;
		public static final int _17 = 1939;
		public static final int _18 = 1940;
		public static final int _19 = 1941;
		public static final int _20 = 1942;
		public static final int _21 = 1943;
		public static final int _22 = 1944;
		public static final int _23 = 1945;
		public static final int _24 = 1946;
		public static final int _25 = 1947;
		public static final int _26 = 1948;
		public static final int _27 = 1949;
		public static final int _28 = 1950;
		public static final int _29 = 1951;
	}

	public static final class _2XLunarSpellsOn
	{
		public static final int _0 = 1952;
		public static final int _1 = 1953;
		public static final int _2 = 1954;
		public static final int _3 = 1955;
		public static final int _4 = 1956;
		public static final int _5 = 1957;
		public static final int _6 = 1958;
		public static final int _7 = 1959;
		public static final int _8 = 1960;
		public static final int _9 = 1961;
		public static final int _10 = 1962;
		public static final int _11 = 1963;
		public static final int _12 = 1964;
		public static final int _13 = 1965;
		public static final int _14 = 1966;
		public static final int _15 = 1967;
		public static final int _16 = 1968;
		public static final int _17 = 1969;
		public static final int _18 = 1970;
		public static final int _19 = 1971;
		public static final int _20 = 1972;
		public static final int _21 = 1973;
		public static final int _22 = 1974;
		public static final int _23 = 1975;
		public static final int _24 = 1976;
		public static final int _25 = 1977;
		public static final int _26 = 1978;
		public static final int _27 = 1979;
		public static final int _28 = 1980;
		public static final int _29 = 1981;
		public static final int _30 = 1982;
		public static final int _31 = 1983;
		public static final int _32 = 1984;
		public static final int _33 = 1985;
		public static final int _34 = 1986;
		public static final int _35 = 1987;
		public static final int _36 = 1988;
		public static final int _37 = 1989;
		public static final int _38 = 1990;
		public static final int _39 = 1991;
		public static final int _40 = 1992;
		public static final int _41 = 1993;
		public static final int _42 = 1994;
		public static final int _43 = 1995;
		public static final int _44 = 1996;
		public static final int _45 = 1997;
		public static final int _46 = 1998;
		public static final int _47 = 1999;
		public static final int _48 = 2000;
		public static final int _49 = 2001;
	}

	public static final class _2XLunarSpellsOff
	{
		public static final int _0 = 2002;
		public static final int _1 = 2003;
		public static final int _2 = 2004;
		public static final int _3 = 2005;
		public static final int _4 = 2006;
		public static final int _5 = 2007;
		public static final int _6 = 2008;
		public static final int _7 = 2009;
		public static final int _8 = 2010;
		public static final int _9 = 2011;
		public static final int _10 = 2012;
		public static final int _11 = 2013;
		public static final int _12 = 2014;
		public static final int _13 = 2015;
		public static final int _14 = 2016;
		public static final int _15 = 2017;
		public static final int _16 = 2018;
		public static final int _17 = 2019;
		public static final int _18 = 2020;
		public static final int _19 = 2021;
		public static final int _20 = 2022;
		public static final int _21 = 2023;
		public static final int _22 = 2024;
		public static final int _23 = 2025;
		public static final int _24 = 2026;
		public static final int _25 = 2027;
		public static final int _26 = 2028;
		public static final int _27 = 2029;
		public static final int _28 = 2030;
		public static final int _29 = 2031;
		public static final int _30 = 2032;
		public static final int _31 = 2033;
		public static final int _32 = 2034;
		public static final int _33 = 2035;
		public static final int _34 = 2036;
		public static final int _35 = 2037;
		public static final int _36 = 2038;
		public static final int _37 = 2039;
		public static final int _38 = 2040;
		public static final int _39 = 2041;
		public static final int _40 = 2042;
		public static final int _41 = 2043;
		public static final int _42 = 2044;
		public static final int _43 = 2045;
		public static final int _44 = 2046;
		public static final int _45 = 2047;
		public static final int _46 = 2048;
		public static final int _47 = 2049;
		public static final int _48 = 2050;
		public static final int _49 = 2051;
	}

	public static final class _2XNecroSpellsOn
	{
		public static final int _0 = 2052;
		public static final int _1 = 2053;
		public static final int _2 = 2054;
		public static final int _3 = 2055;
		public static final int _4 = 2056;
		public static final int _5 = 2057;
		public static final int _6 = 2058;
		public static final int _7 = 2059;
		public static final int _8 = 2060;
		public static final int _9 = 2061;
		public static final int _10 = 2062;
		public static final int _11 = 2063;
		public static final int _12 = 2064;
		public static final int _13 = 2065;
		public static final int _14 = 2066;
		public static final int _15 = 2067;
		public static final int _16 = 2068;
		public static final int _17 = 2069;
		public static final int _18 = 2070;
		public static final int _19 = 2071;
		public static final int _20 = 2072;
		public static final int _21 = 2073;
		public static final int _22 = 2074;
		public static final int _23 = 2075;
		public static final int _24 = 2076;
		public static final int _25 = 2077;
		public static final int _26 = 2078;
		public static final int _27 = 2079;
		public static final int _28 = 2080;
		public static final int _29 = 2081;
		public static final int _30 = 2082;
		public static final int _31 = 2083;
		public static final int _32 = 2084;
		public static final int _33 = 2085;
		public static final int _34 = 2086;
		public static final int _35 = 2087;
		public static final int _36 = 2088;
		public static final int _37 = 2089;
		public static final int _38 = 2090;
		public static final int _39 = 2091;
		public static final int _40 = 2991;
		public static final int _41 = 2992;
		public static final int _42 = 2993;
		public static final int _43 = 2994;
		public static final int _44 = 2995;
		public static final int _45 = 2996;
		public static final int _46 = 2997;
		public static final int _47 = 2998;
		public static final int _48 = 2999;
		public static final int _49 = 3000;
	}

	public static final class _2XNecroSpellsOff
	{
		public static final int _0 = 2092;
		public static final int _1 = 2093;
		public static final int _2 = 2094;
		public static final int _3 = 2095;
		public static final int _4 = 2096;
		public static final int _5 = 2097;
		public static final int _6 = 2098;
		public static final int _7 = 2099;
		public static final int _8 = 2100;
		public static final int _9 = 2101;
		public static final int _10 = 2102;
		public static final int _11 = 2103;
		public static final int _12 = 2104;
		public static final int _13 = 2105;
		public static final int _14 = 2106;
		public static final int _15 = 2107;
		public static final int _16 = 2108;
		public static final int _17 = 2109;
		public static final int _18 = 2110;
		public static final int _19 = 2111;
		public static final int _20 = 2112;
		public static final int _21 = 2113;
		public static final int _22 = 2114;
		public static final int _23 = 2115;
		public static final int _24 = 2116;
		public static final int _25 = 2117;
		public static final int _26 = 2118;
		public static final int _27 = 2119;
		public static final int _28 = 2120;
		public static final int _29 = 2121;
		public static final int _30 = 2122;
		public static final int _31 = 2123;
		public static final int _32 = 2124;
		public static final int _33 = 2125;
		public static final int _34 = 2126;
		public static final int _35 = 2127;
		public static final int _36 = 2128;
		public static final int _37 = 2129;
		public static final int _38 = 2130;
		public static final int _39 = 2131;
		public static final int _40 = 3001;
		public static final int _41 = 3002;
		public static final int _42 = 3003;
		public static final int _43 = 3004;
		public static final int _44 = 3005;
		public static final int _45 = 3006;
		public static final int _46 = 3007;
		public static final int _47 = 3008;
		public static final int _48 = 3009;
		public static final int _49 = 3010;
	}

	public static final class TitlebuttonWide42
	{
		public static final int _0 = 2136;
		public static final int _1 = 2137;
	}

	public static final class Ring34
	{
		public static final int _0 = 2138;
		public static final int _1 = 3517;
		public static final int _2 = 3518;
	}

	public static final class StonyBasalt
	{
		public static final int _0 = 2139;
		public static final int _1 = 2141;
	}

	public static final class DashedBorder
	{
		public static final int _0 = 2142;
		public static final int _1 = 2143;
		public static final int _2 = 2144;
		public static final int _3 = 2145;
		public static final int _4 = 2146;
		public static final int _5 = 2147;
	}

	public static final class ModIconsInterface
	{
		public static final int _0 = 2156;
		public static final int _1 = 2157;
		public static final int _2 = 2158;
		public static final int _3 = 2159;
		public static final int _4 = 2160;
		public static final int _5 = 2161;
		public static final int _6 = 2162;
		public static final int _7 = 2163;
		public static final int _8 = 2164;
		public static final int _9 = 2165;
		public static final int _10 = 2166;
		public static final int _11 = 2167;
		public static final int _12 = 2168;
		public static final int _13 = 2169;
		public static final int _14 = 2170;
		public static final int _15 = 2171;
		public static final int _16 = 2172;
		public static final int _17 = 2173;
		public static final int _18 = 2174;
		public static final int _19 = 2175;
		public static final int _20 = 2506;
		public static final int _21 = 2507;
		public static final int _22 = 2508;
		public static final int _23 = 2509;
		public static final int _24 = 2510;
		public static final int _25 = 2511;
		public static final int _26 = 2512;
		public static final int _27 = 2513;
		public static final int _28 = 2514;
		public static final int _29 = 2515;
		public static final int _30 = 2580;
		public static final int _31 = 2581;
		public static final int _32 = 2582;
		public static final int _33 = 2583;
		public static final int _34 = 2584;
		public static final int _35 = 2585;
		public static final int _36 = 2586;
		public static final int _37 = 2587;
		public static final int _38 = 2588;
		public static final int _39 = 2589;
		public static final int _40 = 3370;
		public static final int _41 = 3371;
		public static final int _42 = 3372;
		public static final int _43 = 3373;
		public static final int _44 = 3374;
		public static final int _45 = 3375;
		public static final int _46 = 3376;
		public static final int _47 = 3377;
		public static final int _48 = 3378;
		public static final int _49 = 3379;
		public static final int _50 = 4523;
		public static final int _51 = 4524;
		public static final int _52 = 4525;
		public static final int _53 = 4526;
		public static final int _54 = 4527;
		public static final int _55 = 4528;
		public static final int _56 = 4529;
		public static final int _57 = 4530;
		public static final int _58 = 4531;
		public static final int _59 = 4532;
	}

	public static final class StandardHealth30
	{
		public static final int _0 = 2176;
		public static final int _1 = 2177;

		public static final int FRONT = _0;
		public static final int BACK = _1;
	}

	public static final class StandardHealth50
	{
		public static final int _0 = 2178;
		public static final int _1 = 2179;

		public static final int FRONT = _0;
		public static final int BACK = _1;
	}

	public static final class StandardHealth60
	{
		public static final int _0 = 2180;
		public static final int _1 = 2181;

		public static final int FRONT = _0;
		public static final int BACK = _1;
	}

	public static final class StandardHealth80
	{
		public static final int _0 = 2182;
		public static final int _1 = 2183;

		public static final int FRONT = _0;
		public static final int BACK = _1;
	}

	public static final class StandardHealth100
	{
		public static final int _0 = 2184;
		public static final int _1 = 2185;

		public static final int FRONT = _0;
		public static final int BACK = _1;
	}

	public static final class StandardHealth120
	{
		public static final int _0 = 2186;
		public static final int _1 = 2187;

		public static final int FRONT = _0;
		public static final int BACK = _1;
	}

	public static final class StandardHealth140
	{
		public static final int _0 = 2188;
		public static final int _1 = 2189;

		public static final int FRONT = _0;
		public static final int BACK = _1;
	}

	public static final class StandardHealth160
	{
		public static final int _0 = 2190;
		public static final int _1 = 2191;

		public static final int FRONT = _0;
		public static final int BACK = _1;
	}

	public static final class GauntletMapIcons
	{
		public static final int _0 = 2192;
		public static final int _1 = 2193;
		public static final int _2 = 2194;
		public static final int _3 = 2195;
		public static final int _4 = 2196;
		public static final int _5 = 2197;
		public static final int _6 = 2198;
		public static final int _7 = 2199;
		public static final int _8 = 2200;
		public static final int _9 = 2201;
		public static final int _10 = 2202;
		public static final int _11 = 2203;
	}

	public static final class AdventurepathInFocus
	{
		public static final int _0 = 2221;
		public static final int _1 = 2222;
	}

	public static final class AdventurepathInFocusSmall
	{
		public static final int _0 = 2223;
		public static final int _1 = 2224;
	}

	public static final class FrexRunes
	{
		public static final int _0 = 2244;
		public static final int _1 = 2259;
		public static final int _2 = 2260;
		public static final int _3 = 2261;
		public static final int _4 = 2262;
		public static final int _5 = 2263;
	}

	public static final class CloseArrows
	{
		public static final int _0 = 2246;
		public static final int _1 = 4668;
		public static final int _2 = 4669;
		public static final int _3 = 4670;
	}

	public static final class RightarrowSmallStone
	{
		public static final int _0 = 2249;
		public static final int _1 = 2250;
	}

	public static final class PohBoardIcons
	{
		public static final int _0 = 2251;
		public static final int _1 = 2252;
		public static final int _2 = 2253;
		public static final int _3 = 2254;
		public static final int _4 = 2255;
		public static final int _5 = 2256;
		public static final int _6 = 2257;
		public static final int _7 = 2258;
	}

	public static final class FrexTicks
	{
		public static final int _0 = 2264;
		public static final int _1 = 2265;
	}

	public static final class SquareButton
	{
		public static final int _0 = 2266;
		public static final int _1 = 2267;
	}

	public static final class TabsShort
	{
		public static final int _0 = 2277;
		public static final int _1 = 2278;
		public static final int _2 = 2279;
		public static final int _3 = 2280;
		public static final int _4 = 2281;
		public static final int _5 = 2282;
		public static final int _6 = 2406;
		public static final int _7 = 2407;
		public static final int _8 = 6317;
		public static final int _9 = 6318;
		public static final int _10 = 6319;
		public static final int _11 = 6320;
		public static final int _12 = 6321;
		public static final int _13 = 6322;
		public static final int _14 = 6323;
		public static final int _15 = 6324;
	}

	public static final class TabsTall
	{
		public static final int _0 = 2283;
		public static final int _1 = 2284;
		public static final int _2 = 2285;
		public static final int _3 = 2286;
		public static final int _4 = 2287;
		public static final int _5 = 2288;
		public static final int _6 = 2408;
		public static final int _7 = 2409;
		public static final int _8 = 6325;
		public static final int _9 = 6326;
		public static final int _10 = 6327;
		public static final int _11 = 6328;
		public static final int _12 = 6329;
		public static final int _13 = 6330;
		public static final int _14 = 6331;
		public static final int _15 = 6332;
	}

	public static final class OpenButtonsSmall
	{
		public static final int _0 = 2312;
		public static final int _1 = 2313;
		public static final int _2 = 2314;
		public static final int _3 = 2315;
	}

	public static final class LeagueTaskTiers
	{
		public static final int _0 = 2316;
		public static final int _1 = 2317;
		public static final int _2 = 2318;
		public static final int _3 = 2319;
		public static final int _4 = 2320;
		public static final int _5 = 3739;
		public static final int _6 = 3740;
		public static final int _7 = 3741;
		public static final int _8 = 3742;
		public static final int _9 = 3743;
	}

	public static final class LeagueRelicsLarge
	{
		public static final int _0 = 2321;
		public static final int _1 = 2322;
		public static final int _2 = 2323;
		public static final int _3 = 2324;
		public static final int _4 = 2325;
		public static final int _5 = 2326;
		public static final int _6 = 2327;
		public static final int _7 = 2328;
		public static final int _8 = 2329;
		public static final int _9 = 2330;
		public static final int _10 = 2331;
		public static final int _11 = 2332;
		public static final int _12 = 2333;
		public static final int _13 = 2334;
		public static final int _14 = 2335;
		public static final int _15 = 2336;
		public static final int _16 = 2337;
		public static final int _17 = 2338;
		public static final int _18 = 2339;
		public static final int _19 = 2340;
		public static final int _20 = 2341;
		public static final int _21 = 2342;
		public static final int _22 = 2343;
		public static final int _23 = 2344;
		public static final int _24 = 2345;
		public static final int _25 = 2346;
		public static final int _26 = 2347;
		public static final int _27 = 2348;
		public static final int _28 = 2349;
		public static final int _29 = 2350;
		public static final int _30 = 2351;
		public static final int _31 = 2352;
	}

	public static final class LeagueRelics
	{
		public static final int _0 = 2353;
		public static final int _1 = 2354;
		public static final int _2 = 2355;
		public static final int _3 = 2356;
		public static final int _4 = 2357;
		public static final int _5 = 2358;
		public static final int _6 = 2359;
		public static final int _7 = 2360;
		public static final int _8 = 2361;
		public static final int _9 = 2362;
		public static final int _10 = 2363;
		public static final int _11 = 2364;
		public static final int _12 = 2365;
		public static final int _13 = 2366;
		public static final int _14 = 2367;
		public static final int _15 = 2368;
		public static final int _16 = 2369;
		public static final int _17 = 2370;
		public static final int _18 = 2371;
		public static final int _19 = 2372;
		public static final int _20 = 2373;
		public static final int _21 = 2374;
		public static final int _22 = 2375;
		public static final int _23 = 2376;
		public static final int _24 = 2377;
		public static final int _25 = 2378;
		public static final int _26 = 2379;
		public static final int _27 = 2380;
		public static final int _28 = 2381;
		public static final int _29 = 2382;
		public static final int _30 = 2383;
		public static final int _31 = 2384;
		public static final int _32 = 2939;
		public static final int _33 = 2940;
		public static final int _34 = 2941;
		public static final int _35 = 2942;
		public static final int _36 = 2943;
		public static final int _37 = 2944;
		public static final int _38 = 2945;
		public static final int _39 = 2946;
	}

	public static final class LeagueProgressBar
	{
		public static final int _0 = 2386;
		public static final int _1 = 2387;
	}

	public static final class LeagueRelicsTli
	{
		public static final int _0 = 2390;
		public static final int _1 = 2391;
		public static final int _2 = 2392;
		public static final int _3 = 2393;
		public static final int _4 = 2394;
		public static final int _5 = 2395;
		public static final int _6 = 2396;
		public static final int _7 = 2397;
		public static final int _8 = 2398;
		public static final int _9 = 2399;
		public static final int _10 = 2400;
		public static final int _11 = 2401;
		public static final int _12 = 2402;
		public static final int _13 = 2403;
		public static final int _14 = 2404;
		public static final int _15 = 2405;
	}

	public static final class IcyBasalt
	{
		public static final int _0 = 2418;
		public static final int _1 = 2419;
	}

	public static final class WikiIcon
	{
		public static final int _0 = 2420;
		public static final int _1 = 2421;

		public static final int DESELECTED = _0;
		public static final int SELECTED = _1;
	}

	public static final class StandardHealth40
	{
		public static final int _0 = 2431;
		public static final int _1 = 2432;

		public static final int FRONT = _0;
		public static final int BACK = _1;
	}

	public static final class StandardShield30
	{
		public static final int _0 = 2433;
		public static final int _1 = 2434;

		public static final int FRONT = _0;
		public static final int BACK = _1;
	}

	public static final class StandardShield40
	{
		public static final int _0 = 2435;
		public static final int _1 = 2436;

		public static final int FRONT = _0;
		public static final int BACK = _1;
	}

	public static final class StandardShield50
	{
		public static final int _0 = 2437;
		public static final int _1 = 2438;

		public static final int FRONT = _0;
		public static final int BACK = _1;
	}

	public static final class StandardShield60
	{
		public static final int _0 = 2439;
		public static final int _1 = 2440;

		public static final int FRONT = _0;
		public static final int BACK = _1;
	}

	public static final class StandardShield80
	{
		public static final int _0 = 2441;
		public static final int _1 = 2442;

		public static final int FRONT = _0;
		public static final int BACK = _1;
	}

	public static final class StandardShield100
	{
		public static final int _0 = 2443;
		public static final int _1 = 2444;

		public static final int FRONT = _0;
		public static final int BACK = _1;
	}

	public static final class StandardShield120
	{
		public static final int _0 = 2445;
		public static final int _1 = 2446;

		public static final int FRONT = _0;
		public static final int BACK = _1;
	}

	public static final class StandardShield140
	{
		public static final int _0 = 2447;
		public static final int _1 = 2448;

		public static final int FRONT = _0;
		public static final int BACK = _1;
	}

	public static final class StandardShield160
	{
		public static final int _0 = 2449;
		public static final int _1 = 2450;

		public static final int FRONT = _0;
		public static final int BACK = _1;
	}

	public static final class StandardArmour30
	{
		public static final int _0 = 2451;
		public static final int _1 = 2452;

		public static final int FRONT = _0;
		public static final int BACK = _1;
	}

	public static final class StandardArmour40
	{
		public static final int _0 = 2453;
		public static final int _1 = 2454;

		public static final int FRONT = _0;
		public static final int BACK = _1;
	}

	public static final class StandardArmour50
	{
		public static final int _0 = 2455;
		public static final int _1 = 2456;

		public static final int FRONT = _0;
		public static final int BACK = _1;
	}

	public static final class StandardArmour60
	{
		public static final int _0 = 2457;
		public static final int _1 = 2458;

		public static final int FRONT = _0;
		public static final int BACK = _1;
	}

	public static final class StandardArmour80
	{
		public static final int _0 = 2459;
		public static final int _1 = 2460;

		public static final int FRONT = _0;
		public static final int BACK = _1;
	}

	public static final class StandardArmour100
	{
		public static final int _0 = 2461;
		public static final int _1 = 2462;

		public static final int FRONT = _0;
		public static final int BACK = _1;
	}

	public static final class StandardArmour120
	{
		public static final int _0 = 2463;
		public static final int _1 = 2464;

		public static final int FRONT = _0;
		public static final int BACK = _1;
	}

	public static final class StandardArmour140
	{
		public static final int _0 = 2465;
		public static final int _1 = 2466;

		public static final int FRONT = _0;
		public static final int BACK = _1;
	}

	public static final class StandardArmour160
	{
		public static final int _0 = 2467;
		public static final int _1 = 2468;

		public static final int FRONT = _0;
		public static final int BACK = _1;
	}

	public static final class StandardCharge30
	{
		public static final int _0 = 2469;
		public static final int _1 = 2470;

		public static final int FRONT = _0;
		public static final int BACK = _1;
	}

	public static final class StandardCharge40
	{
		public static final int _0 = 2471;
		public static final int _1 = 2472;

		public static final int FRONT = _0;
		public static final int BACK = _1;
	}

	public static final class StandardCharge50
	{
		public static final int _0 = 2473;
		public static final int _1 = 2474;

		public static final int FRONT = _0;
		public static final int BACK = _1;
	}

	public static final class StandardCharge60
	{
		public static final int _0 = 2475;
		public static final int _1 = 2476;

		public static final int FRONT = _0;
		public static final int BACK = _1;
	}

	public static final class StandardCharge80
	{
		public static final int _0 = 2477;
		public static final int _1 = 2478;

		public static final int FRONT = _0;
		public static final int BACK = _1;
	}

	public static final class StandardCharge100
	{
		public static final int _0 = 2479;
		public static final int _1 = 2480;

		public static final int FRONT = _0;
		public static final int BACK = _1;
	}

	public static final class StandardCharge120
	{
		public static final int _0 = 2481;
		public static final int _1 = 2482;

		public static final int FRONT = _0;
		public static final int BACK = _1;
	}

	public static final class StandardCharge140
	{
		public static final int _0 = 2483;
		public static final int _1 = 2484;

		public static final int FRONT = _0;
		public static final int BACK = _1;
	}

	public static final class StandardCharge160
	{
		public static final int _0 = 2485;
		public static final int _1 = 2486;

		public static final int FRONT = _0;
		public static final int BACK = _1;
	}

	public static final class ApBorder
	{
		public static final int _0 = 2487;
		public static final int _1 = 2488;
		public static final int _2 = 2489;
		public static final int _3 = 2490;
		public static final int _4 = 2491;
		public static final int _5 = 2492;
		public static final int _6 = 2493;
		public static final int _7 = 2494;
	}

	public static final class GeTextbackdropTall
	{
		public static final int _0 = 2497;
		public static final int _1 = 2947;
		public static final int _2 = 2969;
	}

	public static final class HudBrackets
	{
		public static final int _0 = 2516;
		public static final int _1 = 2517;
	}

	public static final class HighlightBorder
	{
		public static final int _0 = 2524;
		public static final int _1 = 2525;
		public static final int _2 = 2526;
		public static final int _3 = 2527;
		public static final int _4 = 2528;
		public static final int _5 = 2529;
		public static final int _6 = 2530;
		public static final int _7 = 2531;
	}

	public static final class QuestionButton
	{
		public static final int _0 = 2532;
		public static final int _1 = 2533;
	}

	public static final class SquareButtonLarge
	{
		public static final int _0 = 2535;
		public static final int _1 = 2536;
		public static final int _2 = 2537;
	}

	public static final class RectButton
	{
		public static final int _0 = 2538;
		public static final int _1 = 2539;
	}

	public static final class Myq5TombButtons
	{
		public static final int _0 = 2540;
		public static final int _1 = 2541;
		public static final int _2 = 2542;
		public static final int _3 = 2543;
		public static final int _4 = 2544;
		public static final int _5 = 2545;
	}

	public static final class SteelborderDivider
	{
		public static final int _0 = 2546;
		public static final int _1 = 2561;
		public static final int _2 = 2562;
		public static final int _3 = 2563;
	}

	public static final class ApPathIcon
	{
		public static final int _0 = 2549;
		public static final int _1 = 2550;
		public static final int _2 = 2551;
		public static final int _3 = 2552;
		public static final int _4 = 2553;
		public static final int _5 = 2554;
	}

	public static final class ApPathBanner
	{
		public static final int _0 = 2555;
		public static final int _1 = 2556;
		public static final int _2 = 2557;
		public static final int _3 = 2558;
		public static final int _4 = 2559;
	}

	public static final class TabsModalShort
	{
		public static final int _0 = 2564;
		public static final int _1 = 2565;
		public static final int _2 = 2566;
		public static final int _3 = 2567;
		public static final int _4 = 2568;
		public static final int _5 = 2569;
		public static final int _6 = 2570;
		public static final int _7 = 2571;
	}

	public static final class TabsModalTall
	{
		public static final int _0 = 2572;
		public static final int _1 = 2573;
		public static final int _2 = 2574;
		public static final int _3 = 2575;
		public static final int _4 = 2576;
		public static final int _5 = 2577;
		public static final int _6 = 2578;
		public static final int _7 = 2579;
	}

	public static final class LeagueRelicsOutline
	{
		public static final int _0 = 2593;
		public static final int _1 = 2594;
		public static final int _2 = 5272;
		public static final int _3 = 6300;
	}

	public static final class LeagueTinyRelic
	{
		public static final int _0 = 2595;
		public static final int _1 = 2596;
		public static final int _2 = 3744;
		public static final int _3 = 5274;
		public static final int _4 = 6303;
	}

	public static final class LeagueTutorial
	{
		public static final int _0 = 2597;
		public static final int _1 = 2598;
		public static final int _2 = 2599;
		public static final int _3 = 2600;
		public static final int _4 = 2601;
		public static final int _5 = 2602;
	}

	public static final class TrailblazerRelicsLarge
	{
		public static final int _0 = 2604;
		public static final int _1 = 2605;
		public static final int _2 = 2606;
		public static final int _3 = 2607;
		public static final int _4 = 2608;
		public static final int _5 = 2609;
		public static final int _6 = 2610;
		public static final int _7 = 2611;
		public static final int _8 = 2612;
		public static final int _9 = 2613;
		public static final int _10 = 2614;
		public static final int _11 = 2615;
		public static final int _12 = 2616;
		public static final int _13 = 2617;
		public static final int _14 = 2618;
		public static final int _15 = 2619;
		public static final int _16 = 2620;
		public static final int _17 = 2621;
		public static final int _18 = 2622;
		public static final int _19 = 2623;
		public static final int _20 = 2624;
		public static final int _21 = 2625;
		public static final int _22 = 2626;
		public static final int _23 = 2627;
		public static final int _24 = 2628;
		public static final int _25 = 2629;
		public static final int _26 = 2630;
		public static final int _27 = 2631;
		public static final int _28 = 2632;
		public static final int _29 = 2633;
		public static final int _30 = 2634;
		public static final int _31 = 2635;
		public static final int _32 = 2636;
		public static final int _33 = 2637;
		public static final int _34 = 2638;
		public static final int _35 = 2639;
		public static final int _36 = 2640;
		public static final int _37 = 2641;
		public static final int _38 = 2642;
		public static final int _39 = 2643;
		public static final int _40 = 2644;
		public static final int _41 = 2645;
		public static final int _42 = 2646;
		public static final int _43 = 2647;
		public static final int _44 = 2648;
		public static final int _45 = 2649;
		public static final int _46 = 2650;
		public static final int _47 = 2651;
	}

	public static final class TrailblazerRelics
	{
		public static final int _0 = 2652;
		public static final int _1 = 2653;
		public static final int _2 = 2654;
		public static final int _3 = 2655;
		public static final int _4 = 2656;
		public static final int _5 = 2657;
		public static final int _6 = 2658;
		public static final int _7 = 2659;
		public static final int _8 = 2660;
		public static final int _9 = 2661;
		public static final int _10 = 2662;
		public static final int _11 = 2663;
		public static final int _12 = 2664;
		public static final int _13 = 2665;
		public static final int _14 = 2666;
		public static final int _15 = 2667;
		public static final int _16 = 2668;
		public static final int _17 = 2669;
		public static final int _18 = 2670;
		public static final int _19 = 2671;
		public static final int _20 = 2672;
		public static final int _21 = 2673;
		public static final int _22 = 2674;
		public static final int _23 = 2675;
		public static final int _24 = 2676;
		public static final int _25 = 2677;
		public static final int _26 = 2678;
		public static final int _27 = 2679;
		public static final int _28 = 2680;
		public static final int _29 = 2681;
		public static final int _30 = 2682;
		public static final int _31 = 2683;
		public static final int _32 = 2684;
		public static final int _33 = 2685;
		public static final int _34 = 2686;
		public static final int _35 = 2687;
		public static final int _36 = 2688;
		public static final int _37 = 2689;
		public static final int _38 = 2690;
		public static final int _39 = 2691;
		public static final int _40 = 2692;
		public static final int _41 = 2693;
		public static final int _42 = 2694;
		public static final int _43 = 2695;
		public static final int _44 = 2696;
		public static final int _45 = 2697;
		public static final int _46 = 2698;
		public static final int _47 = 2699;
	}

	public static final class TrailblazerRelicsTli
	{
		public static final int _0 = 2700;
		public static final int _1 = 2701;
		public static final int _2 = 2702;
		public static final int _3 = 2703;
		public static final int _4 = 2704;
		public static final int _5 = 2705;
		public static final int _6 = 2706;
		public static final int _7 = 2707;
		public static final int _8 = 2708;
		public static final int _9 = 2709;
		public static final int _10 = 2710;
		public static final int _11 = 2711;
		public static final int _12 = 2712;
		public static final int _13 = 2713;
		public static final int _14 = 2714;
		public static final int _15 = 2715;
		public static final int _16 = 2716;
		public static final int _17 = 2717;
	}

	public static final class TrailblazerProgressBar
	{
		public static final int _0 = 2718;
		public static final int _1 = 2719;
	}

	public static final class TrailblazerMapShields
	{
		public static final int _0 = 2731;
		public static final int _1 = 2732;
		public static final int _2 = 2733;
		public static final int _3 = 2734;
		public static final int _4 = 2735;
		public static final int _5 = 2736;
		public static final int _6 = 2737;
		public static final int _7 = 2738;
		public static final int _8 = 2739;
		public static final int _9 = 2740;
		public static final int _10 = 2741;
		public static final int _11 = 2742;
		public static final int _12 = 2743;
		public static final int _13 = 2744;
		public static final int _14 = 2745;
		public static final int _15 = 2746;
		public static final int _16 = 2747;
		public static final int _17 = 2748;
	}

	public static final class TrailblazerMapShieldsLarge
	{
		public static final int _0 = 2749;
		public static final int _1 = 2750;
		public static final int _2 = 2751;
		public static final int _3 = 2752;
		public static final int _4 = 2753;
		public static final int _5 = 2754;
		public static final int _6 = 2755;
		public static final int _7 = 2756;
		public static final int _8 = 2757;
		public static final int _9 = 2758;
		public static final int _10 = 2759;
		public static final int _11 = 2760;
		public static final int _12 = 2761;
		public static final int _13 = 2762;
		public static final int _14 = 2763;
		public static final int _15 = 2764;
		public static final int _16 = 2765;
		public static final int _17 = 2766;
	}

	public static final class TrailblazerMapNames
	{
		public static final int _0 = 2767;
		public static final int _1 = 2768;
		public static final int _2 = 2769;
		public static final int _3 = 2770;
		public static final int _4 = 2771;
		public static final int _5 = 2772;
		public static final int _6 = 2773;
		public static final int _7 = 2774;
		public static final int _8 = 2775;
		public static final int _9 = 2776;
		public static final int _10 = 2777;
		public static final int _11 = 2778;
		public static final int _12 = 2779;
		public static final int _13 = 2780;
		public static final int _14 = 2781;
		public static final int _15 = 2782;
		public static final int _16 = 2783;
		public static final int _17 = 2784;
		public static final int _18 = 2785;
		public static final int _19 = 2786;
	}

	public static final class ChatchannelRankIcons
	{
		public static final int _0 = 2825;
		public static final int _1 = 2826;
		public static final int _2 = 2827;
		public static final int _3 = 2828;
		public static final int _4 = 2829;
		public static final int _5 = 2830;
		public static final int _6 = 2831;
		public static final int _7 = 2832;
		public static final int _8 = 2833;

		public static final int SMILEY_FRIEND = _0;
		public static final int CROWN_JAGEX_MODERATOR = _1;
		public static final int KEY_CHANNEL_OWNER = _2;
		public static final int GOLD_STAR_GENERAL = _3;
		public static final int SILVER_STAR_CAPTAIN = _4;
		public static final int BRONZE_STAR_LIEUTENANT = _5;
		public static final int TRIPLE_CHEVRON_SERGEANT = _6;
		public static final int DOUBLE_CHEVRON_CORPORAL = _7;
		public static final int SINGLE_CHEVRON_RECRUIT = _8;
	}

	public static final class ToggleBox
	{
		public static final int _0 = 2847;
		public static final int _1 = 2848;
		public static final int _2 = 2849;
		public static final int _3 = 2850;
		public static final int _4 = 2851;
		public static final int _5 = 6411;
		public static final int _6 = 6412;
		public static final int _7 = 6413;
	}

	public static final class SettingsSlider
	{
		public static final int _0 = 2852;
		public static final int _1 = 2853;
		public static final int _2 = 2854;
		public static final int _3 = 2855;
		public static final int _4 = 2856;
		public static final int _5 = 2857;
		public static final int _6 = 2858;
		public static final int _7 = 2859;
		public static final int _8 = 2860;
		public static final int _9 = 2861;
		public static final int _10 = 2862;
		public static final int _11 = 2863;
		public static final int _12 = 4894;
		public static final int _13 = 4895;
		public static final int _14 = 4896;
		public static final int _15 = 4897;
		public static final int _16 = 4898;
		public static final int _17 = 4899;

		public static final int HANDLE_BLUE = _6;
		public static final int HANDLE_RED = _7;
		public static final int HANDLE_GREEN = _8;
	}

	public static final class V2BordersSlimJoins
	{
		public static final int _0 = 2897;
		public static final int _1 = 2898;
		public static final int _2 = 2899;
		public static final int _3 = 2900;
		public static final int _4 = 2901;
		public static final int _5 = 2902;
		public static final int _6 = 2903;
		public static final int _7 = 2904;
		public static final int _8 = 2905;
		public static final int _9 = 2906;
		public static final int _10 = 2907;
		public static final int _11 = 2908;
		public static final int _12 = 2909;
		public static final int _13 = 2910;
		public static final int _14 = 2911;
		public static final int _15 = 2912;
		public static final int _16 = 2913;
		public static final int _17 = 2914;
		public static final int _18 = 2915;
		public static final int _19 = 2916;
		public static final int _20 = 2917;
		public static final int _21 = 2918;
		public static final int _22 = 2919;
		public static final int _23 = 2920;
	}

	public static final class SoulWarsStaticons
	{
		public static final int _0 = 2921;
		public static final int _1 = 2922;
		public static final int _2 = 2923;
		public static final int _3 = 2924;
		public static final int _4 = 2925;
		public static final int _5 = 2926;
		public static final int _6 = 2927;
		public static final int _7 = 2928;
	}

	public static final class SoulWarsGameicons
	{
		public static final int _0 = 2929;
		public static final int _1 = 2930;
		public static final int _2 = 2931;
	}

	public static final class ScrollbarV2Dark
	{
		public static final int _0 = 2954;
		public static final int _1 = 2955;
	}

	public static final class ScrollbarDraggerV2Dark
	{
		public static final int _0 = 2956;
		public static final int _1 = 2957;
		public static final int _2 = 2958;
		public static final int _3 = 2959;
	}

	public static final class HeadbarShootingStar50
	{
		public static final int _0 = 2967;
		public static final int _1 = 2968;

		public static final int FRONT = _0;
		public static final int BACK = _1;
	}

	public static final class GiantsFoundryMouldsBig
	{
		public static final int _0 = 2970;
		public static final int _1 = 3593;
		public static final int _2 = 3594;
		public static final int _3 = 4352;
		public static final int _4 = 4378;
		public static final int _5 = 4379;
		public static final int _6 = 4380;
		public static final int _7 = 4381;
		public static final int _8 = 4382;
		public static final int _9 = 4383;
		public static final int _10 = 4384;
		public static final int _11 = 4385;
		public static final int _12 = 4386;
		public static final int _13 = 4387;
		public static final int _14 = 4388;
		public static final int _15 = 4389;
		public static final int _16 = 4390;
		public static final int _17 = 4391;
		public static final int _18 = 4392;
		public static final int _19 = 4393;
		public static final int _20 = 4394;
		public static final int _21 = 4395;
		public static final int _22 = 4396;
		public static final int _23 = 4397;
		public static final int _24 = 4398;
		public static final int _25 = 4399;
		public static final int _26 = 4400;
		public static final int _27 = 4401;
		public static final int _28 = 4402;
		public static final int _29 = 4403;
		public static final int _30 = 4404;
		public static final int _31 = 4405;
		public static final int _32 = 4406;
		public static final int _33 = 4407;
		public static final int _34 = 4408;
	}

	public static final class StandardHealth70
	{
		public static final int _0 = 2971;
		public static final int _1 = 2972;

		public static final int FRONT = _0;
		public static final int BACK = _1;
	}

	public static final class StandardShield70
	{
		public static final int _0 = 2973;
		public static final int _1 = 2974;

		public static final int FRONT = _0;
		public static final int BACK = _1;
	}

	public static final class StandardArmour70
	{
		public static final int _0 = 2975;
		public static final int _1 = 2976;

		public static final int FRONT = _0;
		public static final int BACK = _1;
	}

	public static final class StandardCharge70
	{
		public static final int _0 = 2977;
		public static final int _1 = 2978;

		public static final int FRONT = _0;
		public static final int BACK = _1;
	}

	public static final class MagicSpellPadlocks
	{
		public static final int _0 = 3011;
		public static final int _1 = 3012;
		public static final int _2 = 3013;
		public static final int _3 = 3014;
	}

	public static final class ChatTabButton
	{
		public static final int _0 = 3051;
		public static final int _1 = 3052;
		public static final int _2 = 3053;
		public static final int _3 = 3054;
		public static final int _4 = 3055;
		public static final int _5 = 3056;

		public static final int BUTTON = _0;
		public static final int HOVERED = _1;
		public static final int NEW_MESSAGES = _4;
		public static final int SELECTED = _2;
		public static final int SELECTED_HOVERED = _3;
	}

	public static final class ReportButton
	{
		public static final int _0 = 3057;
		public static final int _1 = 3058;

		public static final int BUTTON = _0;
		public static final int HOVERED = _1;
	}

	public static final class ChatTypeIcon
	{
		public static final int _0 = 3059;
		public static final int _1 = 3060;
		public static final int _2 = 3061;
	}

	public static final class ClanRankIcons
	{
		public static final int _0 = 3062;
		public static final int _1 = 3063;
		public static final int _2 = 3064;
		public static final int _3 = 3065;
		public static final int _4 = 3066;
		public static final int _5 = 3067;
		public static final int _6 = 3068;
		public static final int _7 = 3069;
		public static final int _8 = 3070;
		public static final int _9 = 3071;
		public static final int _10 = 3072;
		public static final int _11 = 3073;
		public static final int _12 = 3074;
		public static final int _13 = 3075;
		public static final int _14 = 3076;
		public static final int _15 = 3077;
		public static final int _16 = 3078;
		public static final int _17 = 3079;
		public static final int _18 = 3080;
		public static final int _19 = 3081;
		public static final int _20 = 3082;
		public static final int _21 = 3083;
		public static final int _22 = 3084;
		public static final int _23 = 3085;
		public static final int _24 = 3086;
		public static final int _25 = 3087;
		public static final int _26 = 3088;
		public static final int _27 = 3089;
		public static final int _28 = 3090;
		public static final int _29 = 3091;
		public static final int _30 = 3092;
		public static final int _31 = 3093;
		public static final int _32 = 3094;
		public static final int _33 = 3095;
		public static final int _34 = 3096;
		public static final int _35 = 3097;
		public static final int _36 = 3098;
		public static final int _37 = 3099;
		public static final int _38 = 3100;
		public static final int _39 = 3101;
		public static final int _40 = 3102;
		public static final int _41 = 3103;
		public static final int _42 = 3104;
		public static final int _43 = 3105;
		public static final int _44 = 3106;
		public static final int _45 = 3107;
		public static final int _46 = 3108;
		public static final int _47 = 3109;
		public static final int _48 = 3110;
		public static final int _49 = 3111;
		public static final int _50 = 3112;
		public static final int _51 = 3113;
		public static final int _52 = 3114;
		public static final int _53 = 3115;
		public static final int _54 = 3116;
		public static final int _55 = 3117;
		public static final int _56 = 3118;
		public static final int _57 = 3119;
		public static final int _58 = 3120;
		public static final int _59 = 3121;
		public static final int _60 = 3122;
		public static final int _61 = 3123;
		public static final int _62 = 3124;
		public static final int _63 = 3125;
		public static final int _64 = 3126;
		public static final int _65 = 3127;
		public static final int _66 = 3128;
		public static final int _67 = 3129;
		public static final int _68 = 3130;
		public static final int _69 = 3131;
		public static final int _70 = 3132;
		public static final int _71 = 3133;
		public static final int _72 = 3134;
		public static final int _73 = 3135;
		public static final int _74 = 3136;
		public static final int _75 = 3137;
		public static final int _76 = 3138;
		public static final int _77 = 3139;
		public static final int _78 = 3140;
		public static final int _79 = 3141;
		public static final int _80 = 3142;
		public static final int _81 = 3143;
		public static final int _82 = 3144;
		public static final int _83 = 3145;
		public static final int _84 = 3146;
		public static final int _85 = 3147;
		public static final int _86 = 3148;
		public static final int _87 = 3149;
		public static final int _88 = 3150;
		public static final int _89 = 3151;
		public static final int _90 = 3152;
		public static final int _91 = 3153;
		public static final int _92 = 3154;
		public static final int _93 = 3155;
		public static final int _94 = 3156;
		public static final int _95 = 3157;
		public static final int _96 = 3158;
		public static final int _97 = 3159;
		public static final int _98 = 3160;
		public static final int _99 = 3161;
		public static final int _100 = 3162;
		public static final int _101 = 3163;
		public static final int _102 = 3164;
		public static final int _103 = 3165;
		public static final int _104 = 3166;
		public static final int _105 = 3167;
		public static final int _106 = 3168;
		public static final int _107 = 3169;
		public static final int _108 = 3170;
		public static final int _109 = 3171;
		public static final int _110 = 3172;
		public static final int _111 = 3173;
		public static final int _112 = 3174;
		public static final int _113 = 3175;
		public static final int _114 = 3176;
		public static final int _115 = 3177;
		public static final int _116 = 3178;
		public static final int _117 = 3179;
		public static final int _118 = 3180;
		public static final int _119 = 3181;
		public static final int _120 = 3182;
		public static final int _121 = 3183;
		public static final int _122 = 3184;
		public static final int _123 = 3185;
		public static final int _124 = 3186;
		public static final int _125 = 3187;
		public static final int _126 = 3188;
		public static final int _127 = 3189;
		public static final int _128 = 3190;
		public static final int _129 = 3191;
		public static final int _130 = 3192;
		public static final int _131 = 3193;
		public static final int _132 = 3194;
		public static final int _133 = 3195;
		public static final int _134 = 3196;
		public static final int _135 = 3197;
		public static final int _136 = 3198;
		public static final int _137 = 3199;
		public static final int _138 = 3200;
		public static final int _139 = 3201;
		public static final int _140 = 3202;
		public static final int _141 = 3203;
		public static final int _142 = 3204;
		public static final int _143 = 3205;
		public static final int _144 = 3206;
		public static final int _145 = 3207;
		public static final int _146 = 3208;
		public static final int _147 = 3209;
		public static final int _148 = 3210;
		public static final int _149 = 3211;
		public static final int _150 = 3212;
		public static final int _151 = 3213;
		public static final int _152 = 3214;
		public static final int _153 = 3215;
		public static final int _154 = 3216;
		public static final int _155 = 3217;
		public static final int _156 = 3218;
		public static final int _157 = 3219;
		public static final int _158 = 3220;
		public static final int _159 = 3221;
		public static final int _160 = 3222;
		public static final int _161 = 3223;
		public static final int _162 = 3224;
		public static final int _163 = 3225;
		public static final int _164 = 3226;
		public static final int _165 = 3227;
		public static final int _166 = 3228;
		public static final int _167 = 3229;
		public static final int _168 = 3230;
		public static final int _169 = 3231;
		public static final int _170 = 3232;
		public static final int _171 = 3233;
		public static final int _172 = 3234;
		public static final int _173 = 3235;
		public static final int _174 = 3236;
		public static final int _175 = 3237;
		public static final int _176 = 3238;
		public static final int _177 = 3239;
		public static final int _178 = 3240;
		public static final int _179 = 3241;
		public static final int _180 = 3242;
		public static final int _181 = 3243;
		public static final int _182 = 3244;
		public static final int _183 = 3245;
		public static final int _184 = 3246;
		public static final int _185 = 3247;
		public static final int _186 = 3248;
		public static final int _187 = 3249;
		public static final int _188 = 3250;
		public static final int _189 = 3251;
		public static final int _190 = 3252;
		public static final int _191 = 3253;
		public static final int _192 = 3254;
		public static final int _193 = 3255;
		public static final int _194 = 3256;
		public static final int _195 = 3257;
		public static final int _196 = 3258;
		public static final int _197 = 3259;
		public static final int _198 = 3260;
		public static final int _199 = 3261;
		public static final int _200 = 3262;
		public static final int _201 = 3263;
		public static final int _202 = 3264;
		public static final int _203 = 3265;
		public static final int _204 = 3266;
		public static final int _205 = 3267;
		public static final int _206 = 3268;
		public static final int _207 = 3269;
		public static final int _208 = 3270;
		public static final int _209 = 3271;
		public static final int _210 = 3272;
		public static final int _211 = 3273;
		public static final int _212 = 3274;
		public static final int _213 = 3275;
		public static final int _214 = 3276;
		public static final int _215 = 3277;
		public static final int _216 = 3278;
		public static final int _217 = 3279;
		public static final int _218 = 3280;
		public static final int _219 = 3281;
		public static final int _220 = 3282;
		public static final int _221 = 3283;
		public static final int _222 = 3284;
		public static final int _223 = 3285;
		public static final int _224 = 3286;
		public static final int _225 = 3287;
		public static final int _226 = 3288;
		public static final int _227 = 3289;
		public static final int _228 = 3290;
		public static final int _229 = 3291;
		public static final int _230 = 3292;
		public static final int _231 = 3293;
		public static final int _232 = 3294;
		public static final int _233 = 3295;
		public static final int _234 = 3296;
		public static final int _235 = 3297;
		public static final int _236 = 3298;
		public static final int _237 = 3299;
		public static final int _238 = 3300;
		public static final int _239 = 3301;
		public static final int _240 = 3302;
		public static final int _241 = 3303;
		public static final int _242 = 3304;
		public static final int _243 = 3305;
		public static final int _244 = 3306;
		public static final int _245 = 3307;
		public static final int _246 = 3308;
		public static final int _247 = 3309;
		public static final int _248 = 3310;
		public static final int _249 = 3311;
		public static final int _250 = 3312;
		public static final int _251 = 3313;
		public static final int _252 = 3314;
		public static final int _253 = 3315;
		public static final int _254 = 3316;
		public static final int _255 = 3317;
		public static final int _256 = 3318;
		public static final int _257 = 3319;
		public static final int _258 = 3320;
		public static final int _259 = 3321;
		public static final int _260 = 3322;
		public static final int _261 = 3323;
		public static final int _262 = 3324;
		public static final int _263 = 3325;
		public static final int _264 = 3326;
		public static final int _265 = 3327;
		public static final int _266 = 3328;
		public static final int _267 = 3329;
		public static final int _268 = 3330;
		public static final int _269 = 3331;
		public static final int _270 = 3332;
		public static final int _271 = 3333;
		public static final int _272 = 3334;
		public static final int _273 = 3335;
		public static final int _274 = 3336;
	}

	public static final class _2XMagicSpellPadlocks
	{
		public static final int _0 = 3360;
		public static final int _1 = 3361;
		public static final int _2 = 3362;
		public static final int _3 = 3363;
	}

	public static final class GodWarsIcons
	{
		public static final int _0 = 3366;
		public static final int _1 = 3367;
		public static final int _2 = 3368;
		public static final int _3 = 3369;
		public static final int _4 = 3605;
	}

	public static final class TabsEtchedCorner
	{
		public static final int _0 = 3382;
		public static final int _1 = 3383;
		public static final int _2 = 3384;
		public static final int _3 = 3385;
	}

	public static final class AccountIcons
	{
		public static final int _0 = 3386;
		public static final int _1 = 3387;
		public static final int _2 = 3388;
		public static final int _3 = 3389;
		public static final int _4 = 3390;
	}

	public static final class CaProgressBar
	{
		public static final int _0 = 3391;
		public static final int _1 = 3392;
	}

	public static final class CaTierSwords
	{
		public static final int _0 = 3393;
		public static final int _1 = 3394;
		public static final int _2 = 3395;
		public static final int _3 = 3396;
		public static final int _4 = 3397;
		public static final int _5 = 3398;
	}

	public static final class CaTierSwordsSmall
	{
		public static final int _0 = 3399;
		public static final int _1 = 3400;
		public static final int _2 = 3401;
		public static final int _3 = 3402;
		public static final int _4 = 3403;
		public static final int _5 = 3404;
	}

	public static final class DeadmanSigilIcons
	{
		public static final int _0 = 3407;
		public static final int _1 = 3408;
		public static final int _2 = 3409;
		public static final int _3 = 3410;
		public static final int _4 = 3411;
		public static final int _5 = 3412;
		public static final int _6 = 3413;
		public static final int _7 = 3414;
		public static final int _8 = 3415;
		public static final int _9 = 3416;
		public static final int _10 = 3417;
		public static final int _11 = 3418;
		public static final int _12 = 3419;
		public static final int _13 = 3420;
		public static final int _14 = 3421;
		public static final int _15 = 3422;
		public static final int _16 = 3423;
		public static final int _17 = 3424;
		public static final int _18 = 3425;
		public static final int _19 = 3426;
		public static final int _20 = 3427;
		public static final int _21 = 3428;
		public static final int _22 = 3429;
		public static final int _23 = 3430;
		public static final int _24 = 3431;
		public static final int _25 = 3432;
		public static final int _26 = 3433;
		public static final int _27 = 3434;
		public static final int _28 = 3435;
		public static final int _29 = 3436;
		public static final int _30 = 3437;
		public static final int _31 = 3438;
		public static final int _32 = 3439;
		public static final int _33 = 3440;
		public static final int _34 = 3441;
		public static final int _35 = 3442;
		public static final int _36 = 3443;
		public static final int _37 = 3444;
		public static final int _38 = 3445;
		public static final int _39 = 3446;
		public static final int _40 = 3447;
		public static final int _41 = 3448;
		public static final int _42 = 3449;
		public static final int _43 = 3450;
		public static final int _44 = 3451;
		public static final int _45 = 3452;
		public static final int _46 = 3453;
		public static final int _47 = 3454;
	}

	public static final class DeadmanSigilIconsTli
	{
		public static final int _0 = 3455;
		public static final int _1 = 3456;
		public static final int _2 = 3457;
		public static final int _3 = 3458;
		public static final int _4 = 3459;
		public static final int _5 = 3460;
		public static final int _6 = 3461;
		public static final int _7 = 3462;
		public static final int _8 = 3463;
		public static final int _9 = 3464;
		public static final int _10 = 3465;
		public static final int _11 = 3466;
		public static final int _12 = 3467;
		public static final int _13 = 3468;
		public static final int _14 = 3469;
		public static final int _15 = 3470;
		public static final int _16 = 3471;
		public static final int _17 = 3472;
		public static final int _18 = 3473;
		public static final int _19 = 3474;
		public static final int _20 = 3475;
		public static final int _21 = 3476;
		public static final int _22 = 3477;
		public static final int _23 = 3478;
		public static final int _24 = 3479;
		public static final int _25 = 3480;
		public static final int _26 = 3481;
		public static final int _27 = 3482;
		public static final int _28 = 3483;
		public static final int _29 = 3484;
		public static final int _30 = 3485;
		public static final int _31 = 3486;
		public static final int _32 = 3487;
		public static final int _33 = 3488;
		public static final int _34 = 3489;
		public static final int _35 = 3490;
		public static final int _36 = 3491;
		public static final int _37 = 3492;
		public static final int _38 = 3493;
		public static final int _39 = 3494;
		public static final int _40 = 3495;
		public static final int _41 = 3496;
		public static final int _42 = 3497;
		public static final int _43 = 3498;
		public static final int _44 = 3499;
		public static final int _45 = 3500;
		public static final int _46 = 3501;
		public static final int _47 = 3502;
	}

	public static final class DeadmanSigilSkulls
	{
		public static final int _0 = 3503;
		public static final int _1 = 3504;
		public static final int _2 = 3505;
		public static final int _3 = 3506;
		public static final int _4 = 3507;
		public static final int _5 = 3508;
		public static final int _6 = 3509;
		public static final int _7 = 3510;
		public static final int _8 = 3511;
	}

	public static final class Storeorb
	{
		public static final int _0 = 3514;
		public static final int _1 = 3515;
		public static final int _2 = 3516;
	}

	public static final class RoundedTabs
	{
		public static final int _0 = 3524;
		public static final int _1 = 3525;
		public static final int _2 = 3526;
		public static final int _3 = 3527;
		public static final int _4 = 3528;
		public static final int _5 = 3529;
		public static final int _6 = 3530;
		public static final int _7 = 3531;
		public static final int _8 = 3532;
		public static final int _9 = 3533;
		public static final int _10 = 3534;
		public static final int _11 = 3535;
		public static final int _12 = 3536;
		public static final int _13 = 3537;
		public static final int _14 = 3538;
		public static final int _15 = 3539;
		public static final int _16 = 3540;
		public static final int _17 = 3541;
		public static final int _18 = 3542;
		public static final int _19 = 3543;
		public static final int _20 = 3544;
		public static final int _21 = 3545;
		public static final int _22 = 3546;
		public static final int _23 = 3547;
	}

	public static final class PopoutIcons
	{
		public static final int _0 = 3577;
		public static final int _1 = 3578;
		public static final int _2 = 3579;
		public static final int _3 = 4900;
	}

	public static final class BondRedemptionIcons
	{
		public static final int _3 = 3580;
		public static final int _0 = 5253;
		public static final int _1 = 5254;
		public static final int _2 = 5255;
	}

	public static final class GroupIcon
	{
		public static final int _0 = 3595;
		public static final int _1 = 3596;
	}

	public static final class RomanNumerals
	{
		public static final int _0 = 3597;
		public static final int _1 = 3598;
		public static final int _2 = 3599;
		public static final int _3 = 3600;
	}

	public static final class ButtonPolished
	{
		public static final int _0 = 3622;
		public static final int _1 = 3623;
		public static final int _2 = 3624;
		public static final int _3 = 3625;
		public static final int _4 = 3626;
		public static final int _5 = 3627;
		public static final int _6 = 3628;
		public static final int _7 = 3629;
		public static final int _8 = 3630;
		public static final int _9 = 3631;
		public static final int _10 = 3632;
		public static final int _11 = 3633;
		public static final int _12 = 3634;
		public static final int _13 = 3635;
		public static final int _14 = 3636;
		public static final int _15 = 3637;
		public static final int _16 = 3638;
		public static final int _17 = 3639;
		public static final int _18 = 3640;
		public static final int _19 = 3641;
		public static final int _20 = 3642;
		public static final int _21 = 3643;
		public static final int _22 = 3644;
		public static final int _23 = 3645;
		public static final int _24 = 3646;
		public static final int _25 = 3647;
		public static final int _26 = 3648;
		public static final int _27 = 3649;
		public static final int _28 = 3650;
		public static final int _29 = 3651;
		public static final int _30 = 3652;
		public static final int _31 = 3653;
		public static final int _32 = 3654;
		public static final int _33 = 3655;
		public static final int _34 = 3656;
		public static final int _35 = 3657;
		public static final int _36 = 3658;
		public static final int _37 = 3659;
		public static final int _38 = 3660;
		public static final int _39 = 3661;
		public static final int _40 = 3662;
		public static final int _41 = 3663;
		public static final int _42 = 3664;
		public static final int _43 = 3665;
		public static final int _44 = 3666;
		public static final int _45 = 3667;
		public static final int _46 = 3668;
		public static final int _47 = 3669;
		public static final int _48 = 3670;
		public static final int _49 = 3671;
		public static final int _50 = 3672;
		public static final int _51 = 3673;
		public static final int _52 = 3674;
		public static final int _53 = 3675;
		public static final int _54 = 3676;
		public static final int _55 = 3677;
		public static final int _56 = 3678;
		public static final int _57 = 3679;
		public static final int _58 = 3680;
		public static final int _59 = 3681;
		public static final int _60 = 3682;
		public static final int _61 = 3683;
		public static final int _62 = 3684;
		public static final int _63 = 3685;
		public static final int _64 = 3686;
		public static final int _65 = 3687;
		public static final int _66 = 3688;
		public static final int _67 = 3689;
		public static final int _68 = 3690;
		public static final int _69 = 3691;
		public static final int _70 = 3692;
		public static final int _71 = 3693;
		public static final int _72 = 3694;
		public static final int _73 = 3695;
		public static final int _74 = 3696;
		public static final int _75 = 3697;
		public static final int _76 = 3698;
		public static final int _77 = 3699;
		public static final int _78 = 3700;
		public static final int _79 = 3701;
		public static final int _80 = 3702;
		public static final int _81 = 3703;
		public static final int _82 = 3704;
		public static final int _83 = 3705;
		public static final int _84 = 3706;
		public static final int _85 = 3707;
		public static final int _86 = 3708;
		public static final int _87 = 3709;
		public static final int _88 = 3710;
		public static final int _89 = 3711;
		public static final int _90 = 3712;
		public static final int _91 = 3713;
		public static final int _92 = 3714;
		public static final int _93 = 3715;
		public static final int _94 = 3716;
		public static final int _95 = 3717;
		public static final int _96 = 3718;
		public static final int _97 = 3719;
		public static final int _98 = 3720;
		public static final int _99 = 3721;
		public static final int _100 = 3722;
		public static final int _101 = 3723;
		public static final int _102 = 3724;
		public static final int _103 = 3725;
		public static final int _104 = 3726;
		public static final int _105 = 3727;
		public static final int _106 = 3728;
		public static final int _107 = 3729;
		public static final int _108 = 3730;
		public static final int _109 = 3731;
		public static final int _110 = 3732;
		public static final int _111 = 3733;
		public static final int _112 = 3734;
		public static final int _113 = 3735;
		public static final int _114 = 3736;
		public static final int _115 = 3737;
		public static final int _116 = 3738;
	}

	public static final class League3Numerals
	{
		public static final int _0 = 3745;
		public static final int _1 = 3746;
		public static final int _2 = 3747;
		public static final int _3 = 3748;
		public static final int _4 = 3749;
		public static final int _5 = 3750;
		public static final int _6 = 3751;
		public static final int _7 = 3752;
		public static final int _8 = 3753;
		public static final int _9 = 3754;
		public static final int _10 = 3755;
		public static final int _11 = 3756;
		public static final int _12 = 3757;
		public static final int _13 = 3758;
	}

	public static final class League3FragmentBack
	{
		public static final int _0 = 3759;
		public static final int _1 = 3760;
		public static final int _2 = 3761;
		public static final int _3 = 3762;
		public static final int _4 = 3763;
		public static final int _5 = 3764;
		public static final int _6 = 3765;
		public static final int _7 = 3766;
		public static final int _8 = 3767;
		public static final int _9 = 3768;
		public static final int _10 = 3769;
		public static final int _11 = 3770;
		public static final int _12 = 3771;
		public static final int _13 = 3772;
		public static final int _14 = 3773;
		public static final int _15 = 3774;
		public static final int _16 = 3775;
		public static final int _17 = 3776;
		public static final int _18 = 3777;
		public static final int _19 = 3778;
	}

	public static final class League3FragmentBase
	{
		public static final int _0 = 3779;
		public static final int _1 = 3780;
		public static final int _2 = 3781;
		public static final int _3 = 3782;
		public static final int _4 = 3783;
		public static final int _5 = 3784;
		public static final int _6 = 3785;
		public static final int _7 = 3786;
		public static final int _8 = 3787;
		public static final int _9 = 3788;
		public static final int _10 = 3789;
		public static final int _11 = 3790;
		public static final int _12 = 3791;
		public static final int _13 = 3792;
		public static final int _14 = 3793;
		public static final int _15 = 3794;
		public static final int _16 = 3795;
		public static final int _17 = 3796;
		public static final int _18 = 3797;
		public static final int _19 = 3798;
		public static final int _20 = 3799;
		public static final int _21 = 3800;
		public static final int _22 = 3801;
		public static final int _23 = 3802;
		public static final int _24 = 3803;
		public static final int _25 = 3804;
		public static final int _26 = 3805;
		public static final int _27 = 3806;
		public static final int _28 = 3807;
		public static final int _29 = 3808;
		public static final int _30 = 3809;
		public static final int _31 = 3810;
		public static final int _32 = 3811;
		public static final int _33 = 3812;
		public static final int _34 = 3813;
		public static final int _35 = 3814;
		public static final int _36 = 3815;
		public static final int _37 = 3816;
		public static final int _38 = 3817;
		public static final int _39 = 3818;
		public static final int _40 = 3819;
		public static final int _41 = 3820;
		public static final int _42 = 3821;
		public static final int _43 = 3822;
		public static final int _44 = 3823;
		public static final int _45 = 3824;
		public static final int _46 = 3825;
		public static final int _47 = 3826;
		public static final int _48 = 3827;
		public static final int _49 = 3828;
		public static final int _50 = 3829;
		public static final int _51 = 3830;
		public static final int _52 = 3831;
		public static final int _53 = 3832;
		public static final int _54 = 3833;
		public static final int _55 = 3834;
		public static final int _56 = 3835;
		public static final int _57 = 3836;
		public static final int _58 = 3837;
		public static final int _59 = 3838;
		public static final int _60 = 3839;
		public static final int _61 = 3840;
		public static final int _62 = 3841;
		public static final int _63 = 3842;
		public static final int _64 = 3843;
		public static final int _65 = 3844;
		public static final int _66 = 3845;
		public static final int _67 = 3846;
		public static final int _68 = 3847;
		public static final int _69 = 3848;
		public static final int _70 = 3849;
		public static final int _71 = 3850;
		public static final int _72 = 3851;
		public static final int _73 = 3852;
		public static final int _74 = 3853;
		public static final int _75 = 3854;
		public static final int _76 = 3855;
		public static final int _77 = 3856;
		public static final int _78 = 3857;
		public static final int _79 = 3858;
	}

	public static final class League3FragmentGlow
	{
		public static final int _0 = 3859;
		public static final int _1 = 3860;
		public static final int _2 = 3861;
		public static final int _3 = 3862;
		public static final int _4 = 3863;
		public static final int _5 = 3864;
		public static final int _6 = 3865;
		public static final int _7 = 3866;
		public static final int _8 = 3867;
		public static final int _9 = 3868;
		public static final int _10 = 3869;
		public static final int _11 = 3870;
		public static final int _12 = 3871;
		public static final int _13 = 3872;
		public static final int _14 = 3873;
		public static final int _15 = 3874;
		public static final int _16 = 3875;
		public static final int _17 = 3876;
		public static final int _18 = 3877;
		public static final int _19 = 3878;
	}

	public static final class League3IconsLight
	{
		public static final int _0 = 3879;
		public static final int _1 = 3880;
		public static final int _2 = 3881;
		public static final int _3 = 3882;
		public static final int _4 = 3883;
		public static final int _5 = 3884;
		public static final int _6 = 3885;
		public static final int _7 = 3886;
		public static final int _8 = 3887;
		public static final int _9 = 3888;
		public static final int _10 = 3889;
		public static final int _11 = 3890;
		public static final int _12 = 3891;
		public static final int _13 = 3892;
		public static final int _14 = 3893;
		public static final int _15 = 3894;
		public static final int _16 = 3895;
		public static final int _17 = 3896;
		public static final int _18 = 3897;
		public static final int _19 = 3898;
		public static final int _20 = 3899;
		public static final int _21 = 3900;
		public static final int _22 = 3901;
		public static final int _23 = 3902;
		public static final int _24 = 3903;
		public static final int _25 = 3904;
		public static final int _26 = 3905;
		public static final int _27 = 3906;
		public static final int _28 = 3907;
		public static final int _29 = 3908;
		public static final int _30 = 3909;
		public static final int _31 = 3910;
		public static final int _32 = 3911;
		public static final int _33 = 3912;
		public static final int _34 = 3913;
		public static final int _35 = 3914;
		public static final int _36 = 3915;
		public static final int _37 = 3916;
		public static final int _38 = 3917;
		public static final int _39 = 3918;
		public static final int _40 = 3919;
		public static final int _41 = 3920;
		public static final int _42 = 3921;
		public static final int _43 = 3922;
		public static final int _44 = 3923;
		public static final int _45 = 3924;
		public static final int _46 = 3925;
		public static final int _47 = 3926;
		public static final int _48 = 3927;
		public static final int _49 = 3928;
		public static final int _50 = 3929;
		public static final int _51 = 3930;
		public static final int _52 = 3931;
		public static final int _53 = 3932;
		public static final int _54 = 3933;
		public static final int _55 = 3934;
		public static final int _56 = 3935;
		public static final int _57 = 3936;
		public static final int _58 = 3937;
		public static final int _59 = 3938;
		public static final int _60 = 3939;
		public static final int _61 = 3940;
		public static final int _62 = 3941;
		public static final int _63 = 3942;
		public static final int _64 = 3943;
		public static final int _65 = 3944;
		public static final int _66 = 3945;
		public static final int _67 = 3946;
		public static final int _68 = 3947;
		public static final int _69 = 3948;
		public static final int _70 = 3949;
		public static final int _71 = 3950;
		public static final int _72 = 3951;
		public static final int _73 = 3952;
		public static final int _74 = 3953;
		public static final int _75 = 3954;
		public static final int _76 = 3955;
		public static final int _77 = 3956;
		public static final int _78 = 3957;
		public static final int _79 = 3958;
		public static final int _80 = 3959;
		public static final int _81 = 3960;
		public static final int _82 = 3961;
		public static final int _83 = 3962;
		public static final int _84 = 3963;
		public static final int _85 = 3964;
		public static final int _86 = 3965;
		public static final int _87 = 3966;
		public static final int _88 = 3967;
		public static final int _89 = 3968;
		public static final int _90 = 3969;
		public static final int _91 = 3970;
		public static final int _92 = 3971;
		public static final int _93 = 3972;
		public static final int _94 = 3973;
		public static final int _95 = 3974;
		public static final int _96 = 3975;
		public static final int _97 = 3976;
		public static final int _98 = 3977;
		public static final int _99 = 3978;
		public static final int _100 = 3979;
		public static final int _101 = 3980;
		public static final int _102 = 3981;
		public static final int _103 = 3982;
		public static final int _104 = 3983;
		public static final int _105 = 3984;
		public static final int _106 = 3985;
		public static final int _107 = 3986;
		public static final int _108 = 3987;
		public static final int _109 = 3988;
		public static final int _110 = 3989;
		public static final int _111 = 3990;
		public static final int _112 = 3991;
		public static final int _113 = 3992;
		public static final int _114 = 3993;
		public static final int _115 = 3994;
		public static final int _116 = 3995;
		public static final int _117 = 3996;
		public static final int _118 = 3997;
		public static final int _119 = 3998;
		public static final int _120 = 3999;
		public static final int _121 = 4000;
		public static final int _122 = 4001;
		public static final int _123 = 4002;
		public static final int _124 = 4003;
		public static final int _125 = 4004;
		public static final int _126 = 4005;
		public static final int _127 = 4006;
		public static final int _128 = 4007;
		public static final int _129 = 4008;
		public static final int _130 = 4009;
		public static final int _131 = 4010;
		public static final int _132 = 4011;
		public static final int _133 = 4012;
		public static final int _134 = 4013;
		public static final int _135 = 4014;
		public static final int _136 = 4015;
		public static final int _137 = 4016;
		public static final int _138 = 4017;
		public static final int _139 = 4018;
		public static final int _140 = 4019;
		public static final int _141 = 4020;
		public static final int _142 = 4021;
		public static final int _143 = 4022;
		public static final int _144 = 4023;
		public static final int _145 = 4024;
		public static final int _146 = 4025;
		public static final int _147 = 4026;
		public static final int _148 = 4027;
		public static final int _149 = 4028;
		public static final int _150 = 4029;
		public static final int _151 = 4030;
		public static final int _152 = 4031;
		public static final int _153 = 4032;
		public static final int _154 = 4033;
		public static final int _155 = 4034;
		public static final int _156 = 4035;
		public static final int _157 = 4036;
		public static final int _158 = 4037;
		public static final int _159 = 4038;
	}

	public static final class League3Sparks1
	{
		public static final int _0 = 4039;
		public static final int _1 = 4040;
		public static final int _2 = 4041;
		public static final int _3 = 4042;
		public static final int _4 = 4043;
		public static final int _5 = 4044;
	}

	public static final class League3BossIcons
	{
		public static final int _0 = 4045;
		public static final int _1 = 4046;
		public static final int _2 = 4047;
		public static final int _3 = 4048;
		public static final int _4 = 4049;
		public static final int _5 = 4050;
		public static final int _6 = 4051;
		public static final int _7 = 4052;
		public static final int _8 = 4053;
		public static final int _9 = 4054;
		public static final int _10 = 4055;
		public static final int _11 = 4056;
		public static final int _12 = 4057;
		public static final int _13 = 4058;
		public static final int _14 = 4059;
		public static final int _15 = 4060;
		public static final int _16 = 4061;
		public static final int _17 = 4062;
		public static final int _18 = 4063;
		public static final int _19 = 4064;
		public static final int _20 = 4065;
		public static final int _21 = 4066;
		public static final int _22 = 4067;
		public static final int _23 = 4068;
		public static final int _24 = 4069;
		public static final int _25 = 4070;
		public static final int _26 = 4071;
		public static final int _27 = 4072;
		public static final int _28 = 4073;
		public static final int _29 = 4074;
		public static final int _30 = 4075;
		public static final int _31 = 4076;
		public static final int _32 = 4077;
		public static final int _33 = 4078;
		public static final int _34 = 4079;
		public static final int _35 = 4080;
		public static final int _36 = 4081;
		public static final int _37 = 4082;
		public static final int _38 = 4083;
		public static final int _39 = 4084;
	}

	public static final class League3Button
	{
		public static final int _0 = 4085;
		public static final int _1 = 4086;
		public static final int _2 = 4087;
		public static final int _3 = 4088;
		public static final int _4 = 4089;
		public static final int _5 = 4090;
		public static final int _6 = 4091;
		public static final int _7 = 4092;
		public static final int _8 = 4093;
		public static final int _9 = 4094;
		public static final int _10 = 4095;
		public static final int _11 = 4096;
		public static final int _12 = 4097;
		public static final int _13 = 4098;
		public static final int _14 = 4099;
		public static final int _15 = 4100;
		public static final int _16 = 4101;
		public static final int _17 = 4102;
		public static final int _18 = 4103;
		public static final int _19 = 4104;
		public static final int _20 = 4105;
		public static final int _21 = 4106;
		public static final int _22 = 4107;
		public static final int _23 = 4108;
	}

	public static final class League3ProgressBar
	{
		public static final int _0 = 4109;
		public static final int _1 = 4110;
	}

	public static final class League3Triskele
	{
		public static final int _0 = 4111;
		public static final int _1 = 4112;
	}

	public static final class League3Relics
	{
		public static final int _0 = 4113;
		public static final int _1 = 4114;
		public static final int _2 = 4115;
		public static final int _3 = 4116;
		public static final int _4 = 4117;
		public static final int _5 = 4118;
		public static final int _6 = 4119;
		public static final int _7 = 4120;
		public static final int _8 = 4121;
		public static final int _9 = 4122;
		public static final int _10 = 4123;
		public static final int _11 = 4124;
		public static final int _12 = 4125;
		public static final int _13 = 4126;
		public static final int _14 = 4127;
		public static final int _15 = 4128;
		public static final int _16 = 4129;
		public static final int _17 = 4130;
		public static final int _18 = 4131;
		public static final int _19 = 4132;
		public static final int _20 = 4133;
		public static final int _21 = 4134;
		public static final int _22 = 4135;
		public static final int _23 = 4136;
		public static final int _24 = 4137;
		public static final int _25 = 4138;
		public static final int _26 = 4139;
		public static final int _27 = 4140;
		public static final int _28 = 4141;
		public static final int _29 = 4142;
		public static final int _30 = 4143;
		public static final int _31 = 4144;
		public static final int _32 = 4145;
		public static final int _33 = 4146;
		public static final int _34 = 4147;
		public static final int _35 = 4148;
		public static final int _36 = 4149;
		public static final int _37 = 4150;
		public static final int _38 = 4151;
		public static final int _39 = 4152;
		public static final int _40 = 4153;
		public static final int _41 = 4154;
		public static final int _42 = 4155;
		public static final int _43 = 4156;
		public static final int _44 = 4157;
		public static final int _45 = 4158;
		public static final int _46 = 4159;
		public static final int _47 = 4160;
	}

	public static final class League3RelicsTli
	{
		public static final int _0 = 4161;
		public static final int _1 = 4162;
		public static final int _2 = 4163;
		public static final int _3 = 4164;
		public static final int _4 = 4165;
		public static final int _5 = 4166;
		public static final int _6 = 4167;
		public static final int _7 = 4168;
		public static final int _8 = 4169;
		public static final int _9 = 4170;
		public static final int _10 = 4171;
		public static final int _11 = 4172;
		public static final int _12 = 4173;
		public static final int _13 = 4174;
		public static final int _14 = 4175;
		public static final int _15 = 4176;
		public static final int _16 = 4177;
		public static final int _17 = 4178;
	}

	public static final class League3RelicsLarge
	{
		public static final int _0 = 4179;
		public static final int _1 = 4180;
		public static final int _2 = 4181;
		public static final int _3 = 4182;
		public static final int _4 = 4183;
		public static final int _5 = 4184;
		public static final int _6 = 4185;
		public static final int _7 = 4186;
		public static final int _8 = 4187;
		public static final int _9 = 4188;
		public static final int _10 = 4189;
		public static final int _11 = 4190;
		public static final int _12 = 4191;
		public static final int _13 = 4192;
		public static final int _14 = 4193;
		public static final int _15 = 4194;
		public static final int _16 = 4195;
		public static final int _17 = 4196;
		public static final int _18 = 4197;
		public static final int _19 = 4198;
		public static final int _20 = 4199;
		public static final int _21 = 4200;
		public static final int _22 = 4201;
		public static final int _23 = 4202;
		public static final int _24 = 4203;
		public static final int _25 = 4204;
		public static final int _26 = 4205;
		public static final int _27 = 4206;
		public static final int _28 = 4207;
		public static final int _29 = 4208;
		public static final int _30 = 4209;
		public static final int _31 = 4210;
		public static final int _32 = 4211;
		public static final int _33 = 4212;
		public static final int _34 = 4213;
		public static final int _35 = 4214;
		public static final int _36 = 4215;
		public static final int _37 = 4216;
		public static final int _38 = 4217;
		public static final int _39 = 4218;
		public static final int _40 = 4219;
		public static final int _41 = 4220;
		public static final int _42 = 4221;
		public static final int _43 = 4222;
		public static final int _44 = 4223;
		public static final int _45 = 4224;
		public static final int _46 = 4225;
		public static final int _47 = 4226;
	}

	public static final class League3Tutorial
	{
		public static final int _0 = 4227;
		public static final int _1 = 4228;
		public static final int _2 = 4229;
		public static final int _3 = 4230;
		public static final int _4 = 4231;
		public static final int _5 = 4232;
	}

	public static final class League3FragmentBarLabels
	{
		public static final int _0 = 4233;
		public static final int _1 = 4234;
		public static final int _2 = 4235;
	}

	public static final class IconStat50x50
	{
		public static final int _0 = 4236;
		public static final int _1 = 4237;
		public static final int _2 = 4238;
		public static final int _3 = 4239;
		public static final int _4 = 4240;
		public static final int _5 = 4241;
		public static final int _6 = 4242;
		public static final int _7 = 4243;
		public static final int _8 = 4244;
		public static final int _9 = 4245;
		public static final int _10 = 4246;
		public static final int _11 = 4247;
		public static final int _12 = 4248;
		public static final int _13 = 4249;
		public static final int _14 = 4250;
		public static final int _15 = 4251;
		public static final int _16 = 4252;
		public static final int _17 = 4253;
		public static final int _18 = 4254;
		public static final int _19 = 4255;
		public static final int _20 = 4256;
		public static final int _21 = 4257;
		public static final int _22 = 4258;
		public static final int _23 = 4259;
	}

	public static final class IconBoss25x25
	{
		public static final int _0 = 4260;
		public static final int _1 = 4261;
		public static final int _2 = 4262;
		public static final int _3 = 4263;
		public static final int _4 = 4264;
		public static final int _5 = 4265;
		public static final int _6 = 4266;
		public static final int _7 = 4267;
		public static final int _8 = 4268;
		public static final int _9 = 4269;
		public static final int _10 = 4270;
		public static final int _11 = 4271;
		public static final int _12 = 4272;
		public static final int _13 = 4273;
		public static final int _14 = 4274;
		public static final int _15 = 4275;
		public static final int _16 = 4276;
		public static final int _17 = 4277;
		public static final int _18 = 4278;
		public static final int _19 = 4279;
		public static final int _20 = 4280;
		public static final int _21 = 4281;
		public static final int _22 = 4282;
		public static final int _23 = 4283;
		public static final int _24 = 4284;
		public static final int _25 = 4285;
		public static final int _26 = 4286;
		public static final int _27 = 4287;
		public static final int _28 = 4288;
		public static final int _29 = 4289;
		public static final int _30 = 4290;
		public static final int _31 = 4291;
		public static final int _32 = 4292;
		public static final int _33 = 4293;
		public static final int _34 = 4294;
		public static final int _35 = 4295;
		public static final int _36 = 4296;
		public static final int _37 = 4297;
		public static final int _38 = 4298;
		public static final int _39 = 4299;
		public static final int _40 = 5621;
		public static final int _41 = 5622;
		public static final int _42 = 5623;
		public static final int _43 = 5624;
		public static final int _44 = 5625;
		public static final int _45 = 5626;
		public static final int _46 = 5627;
		public static final int _47 = 5628;
		public static final int _48 = 5629;
		public static final int _49 = 5630;
		public static final int _50 = 5631;
		public static final int _51 = 5632;
		public static final int _52 = 5633;
		public static final int _53 = 5634;
		public static final int _54 = 5635;
		public static final int _55 = 5636;
		public static final int _56 = 5637;
		public static final int _57 = 5638;
		public static final int _58 = 5639;
		public static final int _59 = 5640;
		public static final int _60 = 6343;
		public static final int _61 = 6344;
		public static final int _62 = 6345;
		public static final int _63 = 6346;
		public static final int _64 = 6347;
		public static final int _65 = 6348;
		public static final int _66 = 6349;
		public static final int _67 = 6350;
		public static final int _68 = 6351;
		public static final int _69 = 6352;

		public static final int MIMIC = _0;
		public static final int OBOR = _1;
		public static final int BRYOPHYTA = _2;
		public static final int GIANT_MOLE = _3;
		public static final int GROTESQUE_GUARDIANS = _4;
		public static final int TEMPOROSS = _5;
		public static final int WINTERTODT = _6;
		public static final int BARROWS_CHESTS = _7;
		public static final int SARACHNIS = _9;
		public static final int KALPHITE_QUEEN = _10;
		public static final int HESPORI = _11;
		public static final int SKOTIZO = _12;
		public static final int ZALCANO = _13;
		public static final int KING_BLACK_DRAGON = _14;
		public static final int KRAKEN = _15;
		public static final int ABYSSAL_SIRE = _16;
		public static final int THERMONUCLEAR_SMOKE_DEVIL = _17;
		public static final int THE_GAUNTLET = _18;
		public static final int ZULRAH = _19;
		public static final int CERBERUS = _20;
		public static final int VORKATH = _21;
		public static final int GENERAL_GRAARDOR = _22;
		public static final int KRIL_TSUTSAROTH = _23;
		public static final int COMMANDER_ZILYANA = _24;
		public static final int KREEARRA = _25;
		public static final int NIGHTMARE = _26;
		public static final int CORPOREAL_BEAST = _27;
		public static final int CHAMBERS_OF_XERIC = _28;
		public static final int ALCHEMICAL_HYDRA = _29;
		public static final int THEATRE_OF_BLOOD = _30;
		public static final int NEX = _31;
		public static final int DAGANNOTH_SUPREME = _32;
		public static final int DAGANNOTH_REX = _33;
		public static final int DAGANNOTH_PRIME = _34;
		public static final int THE_CORRUPTED_GAUNTLET = _35;
		public static final int CHAMBERS_OF_XERIC_CHALLENGE_MODE = _36;
		public static final int TOMBS_OF_AMASCUT = _37;
		public static final int TOMBS_OF_AMASCUT_EXPERT = _38;
		public static final int PHANTOM_MUSPAH = _39;
		public static final int CHAOS_ELEMENTAL = _40;
		public static final int ARTIO_CALLISTO = _41;
		public static final int CALVARION_VETION = _42;
		public static final int SPINDEL_VENENATIS = _43;
		public static final int CHAOS_FANATIC = _44;
		public static final int CRAZY_ARCHAEOLOGIST = _45;
		public static final int DERANGED_ARCHAEOLOGIST = _46;
		public static final int SCORPIA = _47;
		public static final int TZTOK_JAD = _48;
		public static final int TZKAL_ZUK = _49;
		public static final int THE_WHISPERER = _50;
		public static final int DUKE_SUCELLUS = _51;
		public static final int THE_LEVIATHAN = _52;
		public static final int VARDORVIS = _53;
		public static final int SCURRIUS = _54;
		public static final int SOL_HEREDIT = _55;
		public static final int LUNAR_CHESTS = _56;
		public static final int ARAXXOR = _57;
		public static final int AMOXLIATL = _58;
		public static final int THE_HUEYCOATL = _59;
		public static final int ROYAL_TITANS = _62;
		public static final int YAMA = _63;
		public static final int DOOM_OF_MOKHAIOTL = _64;
	}

	public static final class IconBoss50x50
	{
		public static final int _0 = 4300;
		public static final int _1 = 4301;
		public static final int _2 = 4302;
		public static final int _3 = 4303;
		public static final int _4 = 4304;
		public static final int _5 = 4305;
		public static final int _6 = 4306;
		public static final int _7 = 4307;
		public static final int _8 = 4308;
		public static final int _9 = 4309;
		public static final int _10 = 4310;
		public static final int _11 = 4311;
		public static final int _12 = 4312;
		public static final int _13 = 4313;
		public static final int _14 = 4314;
		public static final int _15 = 4315;
		public static final int _16 = 4316;
		public static final int _17 = 4317;
		public static final int _18 = 4318;
		public static final int _19 = 4319;
		public static final int _20 = 4320;
		public static final int _21 = 4321;
		public static final int _22 = 4322;
		public static final int _23 = 4323;
		public static final int _24 = 4324;
		public static final int _25 = 4325;
		public static final int _26 = 4326;
		public static final int _27 = 4327;
		public static final int _28 = 4328;
		public static final int _29 = 4329;
		public static final int _30 = 4330;
		public static final int _31 = 4331;
		public static final int _32 = 4332;
		public static final int _33 = 4333;
		public static final int _34 = 4334;
		public static final int _35 = 4335;
		public static final int _36 = 4336;
		public static final int _37 = 4337;
		public static final int _38 = 4338;
		public static final int _39 = 4339;
		public static final int _40 = 6353;
		public static final int _41 = 6354;
		public static final int _42 = 6355;
		public static final int _43 = 6356;
		public static final int _44 = 6357;
		public static final int _45 = 6358;
		public static final int _46 = 6359;
		public static final int _47 = 6360;
		public static final int _48 = 6361;
		public static final int _49 = 6362;
		public static final int _50 = 6363;
		public static final int _51 = 6364;
		public static final int _52 = 6365;
		public static final int _53 = 6366;
		public static final int _54 = 6367;
		public static final int _55 = 6368;
		public static final int _56 = 6369;
		public static final int _57 = 6370;
		public static final int _58 = 6371;
		public static final int _59 = 6372;
		public static final int _60 = 6373;
		public static final int _61 = 6374;
		public static final int _62 = 6375;
		public static final int _63 = 6376;
		public static final int _64 = 6377;
		public static final int _65 = 6378;
		public static final int _66 = 6379;
		public static final int _67 = 6380;
		public static final int _68 = 6381;
		public static final int _69 = 6382;
	}

	public static final class ArrowsCurved
	{
		public static final int _0 = 4342;
		public static final int _1 = 4343;
		public static final int _2 = 4344;
		public static final int _3 = 4345;
	}

	public static final class LotgButtons
	{
		public static final int _0 = 4346;
		public static final int _1 = 4347;
		public static final int _2 = 4348;
		public static final int _3 = 4349;
	}

	public static final class IconRune32x32
	{
		public static final int _0 = 4353;
		public static final int _1 = 4354;
		public static final int _2 = 4355;
		public static final int _3 = 4356;
		public static final int _4 = 4357;
		public static final int _5 = 4358;
		public static final int _6 = 4359;
		public static final int _7 = 4360;
		public static final int _8 = 4361;
		public static final int _9 = 4362;
		public static final int _10 = 4363;
		public static final int _11 = 4364;
		public static final int _12 = 4365;
		public static final int _13 = 4366;
		public static final int _14 = 4367;
		public static final int _15 = 4368;
		public static final int _16 = 4369;
		public static final int _17 = 4370;
		public static final int _18 = 4371;
		public static final int _19 = 4372;
		public static final int _20 = 4373;
		public static final int _21 = 4374;
		public static final int _22 = 4375;
		public static final int _23 = 4376;
	}

	public static final class GiantsFoundryMouldsSmall
	{
		public static final int _0 = 4409;
		public static final int _1 = 4410;
		public static final int _2 = 4411;
		public static final int _3 = 4412;
		public static final int _4 = 4413;
		public static final int _5 = 4414;
		public static final int _6 = 4415;
		public static final int _7 = 4416;
		public static final int _8 = 4417;
		public static final int _9 = 4418;
		public static final int _10 = 4419;
		public static final int _11 = 4420;
		public static final int _12 = 4421;
		public static final int _13 = 4422;
		public static final int _14 = 4423;
		public static final int _15 = 4424;
		public static final int _16 = 4425;
		public static final int _17 = 4426;
		public static final int _18 = 4427;
		public static final int _19 = 4428;
		public static final int _20 = 4429;
		public static final int _21 = 4430;
		public static final int _22 = 4431;
		public static final int _23 = 4432;
		public static final int _24 = 4433;
		public static final int _25 = 4434;
		public static final int _26 = 4435;
		public static final int _27 = 4436;
		public static final int _28 = 4437;
		public static final int _29 = 4438;
		public static final int _30 = 4439;
		public static final int _31 = 4440;
		public static final int _32 = 4441;
	}

	public static final class GiantsFoundryToolIcon
	{
		public static final int _0 = 4442;
		public static final int _1 = 4443;
		public static final int _2 = 4444;
		public static final int _3 = 4445;
		public static final int _4 = 4446;
		public static final int _5 = 4447;
		public static final int _6 = 4448;
		public static final int _7 = 4449;
	}

	public static final class GiantsFoundryHudBar
	{
		public static final int _0 = 4450;
		public static final int _1 = 4451;
		public static final int _2 = 4452;
		public static final int _3 = 4453;
		public static final int _4 = 4454;
		public static final int _5 = 4455;
		public static final int _6 = 4456;
		public static final int _7 = 4457;
		public static final int _8 = 4458;
		public static final int _9 = 4459;
		public static final int _10 = 4460;
		public static final int _11 = 4461;
		public static final int _12 = 4462;
		public static final int _13 = 4463;
		public static final int _14 = 4464;
		public static final int _15 = 4465;
		public static final int _16 = 4466;
		public static final int _17 = 4467;
		public static final int _18 = 4468;
		public static final int _19 = 4469;
		public static final int _20 = 4470;
		public static final int _21 = 4471;
		public static final int _22 = 4472;
		public static final int _23 = 4473;
		public static final int _24 = 4474;
		public static final int _25 = 4475;
		public static final int _26 = 4476;
		public static final int _27 = 4477;
		public static final int _28 = 4478;
		public static final int _29 = 4479;
		public static final int _30 = 4480;
		public static final int _31 = 4481;
		public static final int _32 = 4482;
		public static final int _33 = 4483;
		public static final int _34 = 4484;
		public static final int _35 = 4485;
		public static final int _36 = 4486;
		public static final int _37 = 4487;
		public static final int _38 = 4488;
		public static final int _39 = 4489;
		public static final int _40 = 4490;
		public static final int _41 = 4491;
		public static final int _42 = 4492;
		public static final int _43 = 4493;
		public static final int _44 = 4494;
		public static final int _45 = 4495;
		public static final int _46 = 4496;
		public static final int _47 = 4497;
		public static final int _48 = 4498;
		public static final int _49 = 4499;
		public static final int _50 = 4500;
		public static final int _51 = 4501;
		public static final int _52 = 4502;
		public static final int _53 = 4503;
		public static final int _54 = 4504;
		public static final int _55 = 4505;
		public static final int _56 = 4506;
		public static final int _57 = 4507;
		public static final int _58 = 4508;
		public static final int _59 = 4509;
		public static final int _60 = 4510;
		public static final int _61 = 4511;
		public static final int _62 = 4512;
	}

	public static final class GiantsFoundryToolMapIcon
	{
		public static final int _0 = 4514;
		public static final int _1 = 4515;
		public static final int _2 = 4516;
	}

	public static final class ScrollbarDraggerHorizontalV2
	{
		public static final int _0 = 4535;
		public static final int _1 = 4536;
		public static final int _2 = 4537;
		public static final int _3 = 4538;
	}

	public static final class SettingsTabsAltActiveEnd
	{
		public static final int _0 = 4545;
		public static final int _1 = 4546;
	}

	public static final class WorldmapMarkerMini
	{
		public static final int _0 = 4553;
		public static final int _1 = 4554;
		public static final int _2 = 4555;
	}

	public static final class ToaGroupingIcons
	{
		public static final int _0 = 4565;
		public static final int _1 = 4566;
		public static final int _2 = 4567;
		public static final int _3 = 4568;
		public static final int _4 = 4569;
		public static final int _5 = 4570;
		public static final int _6 = 4571;
		public static final int _7 = 4572;
		public static final int _8 = 4573;
		public static final int _9 = 4574;
		public static final int _10 = 4575;
		public static final int _11 = 4576;
		public static final int _12 = 4577;
		public static final int _13 = 4578;
		public static final int _14 = 4579;
		public static final int _15 = 4580;
		public static final int _16 = 4581;
		public static final int _17 = 4582;
	}

	public static final class ToaInvocationIcons
	{
		public static final int _0 = 4583;
		public static final int _1 = 4584;
		public static final int _2 = 4585;
		public static final int _3 = 4586;
		public static final int _4 = 4587;
		public static final int _5 = 4588;
		public static final int _6 = 4589;
		public static final int _7 = 4590;
		public static final int _8 = 4591;
		public static final int _9 = 4592;
		public static final int _10 = 4593;
		public static final int _11 = 4594;
		public static final int _12 = 4595;
		public static final int _13 = 4596;
		public static final int _14 = 4597;
		public static final int _15 = 4598;
		public static final int _16 = 4599;
		public static final int _17 = 4600;
		public static final int _18 = 4601;
		public static final int _19 = 4602;
		public static final int _20 = 4603;
		public static final int _21 = 4604;
		public static final int _22 = 4605;
		public static final int _23 = 4606;
	}

	public static final class ToaInvocationIconsBlack
	{
		public static final int _0 = 4607;
		public static final int _1 = 4608;
		public static final int _2 = 4609;
		public static final int _3 = 4610;
		public static final int _4 = 4611;
		public static final int _5 = 4612;
		public static final int _6 = 4613;
		public static final int _7 = 4614;
		public static final int _8 = 4615;
		public static final int _9 = 4616;
		public static final int _10 = 4617;
		public static final int _11 = 4618;
		public static final int _12 = 4619;
		public static final int _13 = 4620;
		public static final int _14 = 4621;
		public static final int _15 = 4622;
		public static final int _16 = 4623;
		public static final int _17 = 4624;
		public static final int _18 = 4625;
		public static final int _19 = 4626;
		public static final int _20 = 4627;
		public static final int _21 = 4628;
		public static final int _22 = 4629;
		public static final int _23 = 4630;
	}

	public static final class ToaInvocationIconsSmall
	{
		public static final int _0 = 4631;
		public static final int _1 = 4632;
		public static final int _2 = 4633;
		public static final int _3 = 4634;
		public static final int _4 = 4635;
		public static final int _5 = 4636;
		public static final int _6 = 4637;
		public static final int _7 = 4638;
		public static final int _8 = 4639;
		public static final int _9 = 4640;
		public static final int _10 = 4641;
		public static final int _11 = 4642;
		public static final int _12 = 4643;
		public static final int _13 = 4644;
		public static final int _14 = 4645;
		public static final int _15 = 4646;
		public static final int _16 = 4647;
		public static final int _17 = 4648;
		public static final int _18 = 4649;
		public static final int _19 = 4650;
		public static final int _20 = 4651;
		public static final int _21 = 4652;
		public static final int _22 = 4653;
		public static final int _23 = 4654;
	}

	public static final class ToaInvocationsProgresBar
	{
		public static final int _0 = 4655;
		public static final int _1 = 4656;
		public static final int _2 = 4657;
		public static final int _3 = 4658;
	}

	public static final class ToaDifficultyIcons
	{
		public static final int _0 = 4660;
		public static final int _1 = 4661;
		public static final int _2 = 4662;
	}

	public static final class StandardPrayer30
	{
		public static final int _0 = 4708;
		public static final int _1 = 4709;

		public static final int FRONT = _0;
		public static final int BACK = _1;
	}

	public static final class StandardPrayer40
	{
		public static final int _0 = 4710;
		public static final int _1 = 4711;

		public static final int FRONT = _0;
		public static final int BACK = _1;
	}

	public static final class StandardPrayer50
	{
		public static final int _0 = 4712;
		public static final int _1 = 4713;

		public static final int FRONT = _0;
		public static final int BACK = _1;
	}

	public static final class StandardPrayer60
	{
		public static final int _0 = 4714;
		public static final int _1 = 4715;

		public static final int FRONT = _0;
		public static final int BACK = _1;
	}

	public static final class StandardPrayer70
	{
		public static final int _0 = 4716;
		public static final int _1 = 4717;

		public static final int FRONT = _0;
		public static final int BACK = _1;
	}

	public static final class StandardPrayer80
	{
		public static final int _0 = 4718;
		public static final int _1 = 4719;

		public static final int FRONT = _0;
		public static final int BACK = _1;
	}

	public static final class StandardPrayer100
	{
		public static final int _0 = 4720;
		public static final int _1 = 4721;

		public static final int FRONT = _0;
		public static final int BACK = _1;
	}

	public static final class StandardPrayer120
	{
		public static final int _0 = 4722;
		public static final int _1 = 4723;

		public static final int FRONT = _0;
		public static final int BACK = _1;
	}

	public static final class StandardPrayer140
	{
		public static final int _0 = 4724;
		public static final int _1 = 4725;

		public static final int FRONT = _0;
		public static final int BACK = _1;
	}

	public static final class StandardPrayer160
	{
		public static final int _0 = 4726;
		public static final int _1 = 4727;

		public static final int FRONT = _0;
		public static final int BACK = _1;
	}

	public static final class Lockpicking
	{
		public static final int _0 = 4730;
		public static final int _1 = 4731;
		public static final int _2 = 4732;
	}

	public static final class DirectionalLockArrows
	{
		public static final int _0 = 4734;
		public static final int _1 = 4735;
		public static final int _2 = 4736;
		public static final int _3 = 4737;
	}

	public static final class CombinationLockJoin
	{
		public static final int _0 = 4739;
		public static final int _1 = 4740;
		public static final int _2 = 4741;
	}

	public static final class CombinationLockArrows
	{
		public static final int _0 = 4742;
		public static final int _1 = 4743;
		public static final int _2 = 4744;
		public static final int _3 = 4745;
		public static final int _4 = 5585;
		public static final int _5 = 5586;
		public static final int _6 = 5587;
		public static final int _7 = 5588;
	}

	public static final class SotnCipher
	{
		public static final int _0 = 4747;
		public static final int _1 = 4748;
		public static final int _2 = 4749;
		public static final int _3 = 4750;
		public static final int _4 = 4751;
		public static final int _5 = 4752;
		public static final int _6 = 4753;
		public static final int _7 = 4754;
		public static final int _8 = 4755;
		public static final int _9 = 4756;
		public static final int _10 = 4757;
		public static final int _11 = 4758;
		public static final int _12 = 4759;
		public static final int _13 = 4760;
		public static final int _14 = 4761;
		public static final int _15 = 4762;
	}

	public static final class StandardPoison30
	{
		public static final int _0 = 4771;
		public static final int _1 = 4772;

		public static final int FRONT = _0;
		public static final int BACK = _1;
	}

	public static final class StandardPoison40
	{
		public static final int _0 = 4773;
		public static final int _1 = 4774;

		public static final int FRONT = _0;
		public static final int BACK = _1;
	}

	public static final class StandardPoison50
	{
		public static final int _0 = 4775;
		public static final int _1 = 4776;

		public static final int FRONT = _0;
		public static final int BACK = _1;
	}

	public static final class StandardPoison60
	{
		public static final int _0 = 4777;
		public static final int _1 = 4778;

		public static final int FRONT = _0;
		public static final int BACK = _1;
	}

	public static final class StandardPoison70
	{
		public static final int _0 = 4779;
		public static final int _1 = 4780;

		public static final int FRONT = _0;
		public static final int BACK = _1;
	}

	public static final class StandardPoison80
	{
		public static final int _0 = 4781;
		public static final int _1 = 4782;

		public static final int FRONT = _0;
		public static final int BACK = _1;
	}

	public static final class StandardPoison100
	{
		public static final int _0 = 4783;
		public static final int _1 = 4784;

		public static final int FRONT = _0;
		public static final int BACK = _1;
	}

	public static final class StandardPoison120
	{
		public static final int _0 = 4785;
		public static final int _1 = 4786;

		public static final int FRONT = _0;
		public static final int BACK = _1;
	}

	public static final class StandardPoison140
	{
		public static final int _0 = 4787;
		public static final int _1 = 4788;

		public static final int FRONT = _0;
		public static final int BACK = _1;
	}

	public static final class StandardPoison160
	{
		public static final int _0 = 4789;
		public static final int _1 = 4790;

		public static final int FRONT = _0;
		public static final int BACK = _1;
	}

	public static final class CrossBig
	{
		public static final int _0 = 4791;
		public static final int _1 = 4792;
		public static final int _2 = 4793;
	}

	public static final class IconPrayerZaros01_30x30
	{
		public static final int _0 = 4842;
		public static final int _1 = 4843;
		public static final int _2 = 4844;
		public static final int _3 = 4845;
		public static final int _4 = 4846;
		public static final int _5 = 4847;
		public static final int _6 = 4848;
		public static final int _7 = 4849;
		public static final int _8 = 4850;
		public static final int _9 = 4851;
		public static final int _10 = 4852;
		public static final int _11 = 4853;
		public static final int _12 = 4854;
		public static final int _13 = 4855;
		public static final int _14 = 4856;
		public static final int _15 = 4857;
		public static final int _16 = 4858;
		public static final int _17 = 4859;
		public static final int _18 = 4860;
		public static final int _19 = 4861;
		public static final int _20 = 4862;
		public static final int _21 = 4863;
		public static final int _22 = 4864;
		public static final int _23 = 4865;

		public static final int ANCIENT_STRENGTH = _1;
		public static final int ANCIENT_SIGHT = _2;
		public static final int ANCIENT_WILL = _3;
		public static final int TRINITAS = _8;
		public static final int DECIMATE = _12;
		public static final int ANNIHILATE = _13;
		public static final int VAPORISE = _14;
		public static final int DAMPEN_MELEE = _7;
		public static final int DAMPEN_RANGED = _6;
		public static final int DAMPEN_MAGIC = _5;
		public static final int PURGE = _10;
		public static final int REJUVENATION = _0;
		public static final int RUINOUS_GRACE = _4;
		public static final int WRATH = _20;
		public static final int METABOLISE = _11;
		public static final int BERSERKER = _9;
		public static final int FUMUS_VOW = _16;
		public static final int CRUORS_VOW = _18;
		public static final int UMBRAS_VOW = _17;
		public static final int GLACIES_VOW = _19;
		public static final int INTENSIFY = _22;
		public static final int REBUKE = _15;
		public static final int VINDICATION = _21;
		public static final int PROTECT_ITEM = _23;
	}

	public static final class IconPrayerZaros02_30x30
	{
		public static final int _0 = 4866;
		public static final int _1 = 4867;
		public static final int _2 = 4868;
		public static final int _3 = 4869;
		public static final int _4 = 4870;
		public static final int _5 = 4871;
		public static final int _6 = 4872;
		public static final int _7 = 4873;
		public static final int _8 = 4874;
		public static final int _9 = 4875;
		public static final int _10 = 4876;
		public static final int _11 = 4877;
		public static final int _12 = 4878;
		public static final int _13 = 4879;
		public static final int _14 = 4880;
		public static final int _15 = 4881;
		public static final int _16 = 4882;
		public static final int _17 = 4883;
		public static final int _18 = 4884;
		public static final int _19 = 4885;
		public static final int _20 = 4886;
		public static final int _21 = 4887;
		public static final int _22 = 4888;
		public static final int _23 = 4889;
	}

	public static final class Prayerglow
	{
		public static final int _0 = 4892;
		public static final int _1 = 4893;

		public static final int ACTIVATED = _0;
	}

	public static final class GroundItemsPlusminus
	{
		public static final int _0 = 4901;
		public static final int _1 = 4902;
		public static final int _2 = 4903;
		public static final int _3 = 4904;
		public static final int _4 = 4905;
		public static final int _5 = 4906;
		public static final int _6 = 4907;
		public static final int _7 = 4908;
	}

	public static final class GroundItemsVisibility
	{
		public static final int _0 = 4909;
		public static final int _1 = 4910;
	}

	public static final class IconTrackerLoot01_30x30
	{
		public static final int _0 = 4911;
		public static final int _1 = 4912;
		public static final int _2 = 4913;
		public static final int _3 = 4914;
		public static final int _4 = 4915;
		public static final int _5 = 4916;
		public static final int _6 = 4917;
		public static final int _7 = 4918;
		public static final int _8 = 4919;
		public static final int _9 = 4920;
		public static final int _10 = 4921;
		public static final int _11 = 4922;
	}

	public static final class Miscgraphics5
	{
		public static final int _0 = 4925;
		public static final int _1 = 4926;
	}

	public static final class SlidingCipherInner
	{
		public static final int _0 = 4950;
		public static final int _1 = 4951;
		public static final int _2 = 4952;
		public static final int _3 = 4953;
		public static final int _4 = 4954;
	}

	public static final class SlidingCipherOuter
	{
		public static final int _0 = 4955;
		public static final int _1 = 4956;
	}

	public static final class CombinationLockSymbols
	{
		public static final int _0 = 4957;
		public static final int _1 = 4958;
		public static final int _2 = 4959;
		public static final int _3 = 4960;
		public static final int _4 = 4961;
		public static final int _5 = 4962;
		public static final int _6 = 4963;
		public static final int _7 = 4964;
		public static final int _8 = 4965;
		public static final int _9 = 4966;
		public static final int _10 = 4967;
		public static final int _11 = 4968;
		public static final int _12 = 4969;
		public static final int _13 = 4970;
		public static final int _14 = 4971;
		public static final int _15 = 4972;
		public static final int _16 = 4973;
		public static final int _17 = 4974;
		public static final int _18 = 4975;
		public static final int _19 = 4976;
	}

	public static final class MorseCode
	{
		public static final int _0 = 4977;
		public static final int _1 = 4978;
		public static final int _2 = 4979;
		public static final int _3 = 4980;
		public static final int _4 = 4981;
		public static final int _5 = 4982;
		public static final int _6 = 4983;
		public static final int _7 = 4984;
		public static final int _8 = 4985;
		public static final int _9 = 4986;
		public static final int _10 = 4987;
		public static final int _11 = 4988;
		public static final int _12 = 4989;
		public static final int _13 = 4990;
		public static final int _14 = 4991;
		public static final int _15 = 4992;
		public static final int _16 = 4993;
		public static final int _17 = 4994;
		public static final int _18 = 4995;
		public static final int _19 = 4996;
		public static final int _20 = 4997;
		public static final int _21 = 4998;
		public static final int _22 = 4999;
		public static final int _23 = 5000;
		public static final int _24 = 5001;
		public static final int _25 = 5002;
		public static final int _26 = 5003;
		public static final int _27 = 5004;
		public static final int _28 = 5005;
		public static final int _29 = 5006;
		public static final int _30 = 5007;
		public static final int _31 = 5008;
		public static final int _32 = 5009;
		public static final int _33 = 5010;
		public static final int _34 = 5011;
		public static final int _35 = 5012;
		public static final int _36 = 5013;
		public static final int _37 = 5014;
		public static final int _38 = 5015;
		public static final int _39 = 5016;
		public static final int _40 = 5017;
		public static final int _41 = 5018;
		public static final int _42 = 5019;
		public static final int _43 = 5020;
		public static final int _44 = 5021;
		public static final int _45 = 5022;
		public static final int _46 = 5023;
		public static final int _47 = 5024;
		public static final int _48 = 5025;
		public static final int _49 = 5026;
		public static final int _50 = 5027;
		public static final int _51 = 5028;
	}

	public static final class MorseCodeSingles
	{
		public static final int _0 = 5029;
		public static final int _1 = 5030;
		public static final int _2 = 5031;
		public static final int _3 = 5032;
	}

	public static final class Dt2Icons
	{
		public static final int _0 = 5033;
		public static final int _1 = 5034;
		public static final int _2 = 5035;
		public static final int _3 = 5036;
		public static final int _4 = 5037;
		public static final int _5 = 5038;
		public static final int _6 = 5039;
		public static final int _7 = 5040;
	}

	public static final class DeadmanSigilCombatIconsLarge
	{
		public static final int _0 = 5041;
		public static final int _1 = 5042;
		public static final int _2 = 5043;
		public static final int _3 = 5044;
		public static final int _4 = 5045;
		public static final int _5 = 5046;
		public static final int _6 = 5047;
		public static final int _7 = 5048;
		public static final int _8 = 5049;
		public static final int _9 = 5050;
		public static final int _10 = 5051;
		public static final int _11 = 5052;
		public static final int _12 = 5053;
		public static final int _13 = 5054;
		public static final int _14 = 5055;
		public static final int _15 = 5056;
		public static final int _16 = 5057;
		public static final int _17 = 5058;
		public static final int _18 = 5059;
		public static final int _19 = 5060;
		public static final int _20 = 5061;
		public static final int _21 = 5062;
		public static final int _22 = 5063;
		public static final int _23 = 5064;
		public static final int _24 = 5065;
		public static final int _25 = 5066;
		public static final int _26 = 5067;
		public static final int _27 = 5068;
		public static final int _28 = 5069;
		public static final int _29 = 5070;
		public static final int _30 = 5071;
		public static final int _31 = 5072;
	}

	public static final class DeadmanSigilCombatIconsSmall
	{
		public static final int _0 = 5073;
		public static final int _1 = 5074;
		public static final int _2 = 5075;
		public static final int _3 = 5076;
		public static final int _4 = 5077;
		public static final int _5 = 5078;
		public static final int _6 = 5079;
		public static final int _7 = 5080;
		public static final int _8 = 5081;
		public static final int _9 = 5082;
		public static final int _10 = 5083;
		public static final int _11 = 5084;
		public static final int _12 = 5085;
		public static final int _13 = 5086;
		public static final int _14 = 5087;
		public static final int _15 = 5088;
		public static final int _16 = 5089;
		public static final int _17 = 5090;
		public static final int _18 = 5091;
		public static final int _19 = 5092;
		public static final int _20 = 5093;
		public static final int _21 = 5094;
		public static final int _22 = 5095;
		public static final int _23 = 5096;
		public static final int _24 = 5097;
		public static final int _25 = 5098;
		public static final int _26 = 5099;
		public static final int _27 = 5100;
		public static final int _28 = 5101;
		public static final int _29 = 5102;
		public static final int _30 = 5103;
		public static final int _31 = 5104;
	}

	public static final class DeadmanSigilSkillingIconsLarge
	{
		public static final int _0 = 5105;
		public static final int _1 = 5106;
		public static final int _2 = 5107;
		public static final int _3 = 5108;
		public static final int _4 = 5109;
		public static final int _5 = 5110;
		public static final int _6 = 5111;
		public static final int _7 = 5112;
		public static final int _8 = 5113;
		public static final int _9 = 5114;
		public static final int _10 = 5115;
		public static final int _11 = 5116;
		public static final int _12 = 5117;
		public static final int _13 = 5118;
		public static final int _14 = 5119;
		public static final int _15 = 5120;
		public static final int _16 = 5121;
		public static final int _17 = 5122;
		public static final int _18 = 5123;
		public static final int _19 = 5124;
		public static final int _20 = 5125;
		public static final int _21 = 5126;
		public static final int _22 = 5127;
		public static final int _23 = 5128;
		public static final int _24 = 5129;
		public static final int _25 = 5130;
		public static final int _26 = 5131;
		public static final int _27 = 5132;
		public static final int _28 = 5133;
		public static final int _29 = 5134;
		public static final int _30 = 5135;
		public static final int _31 = 5136;
	}

	public static final class DeadmanSigilSkillingIconsSmall
	{
		public static final int _0 = 5137;
		public static final int _1 = 5138;
		public static final int _2 = 5139;
		public static final int _3 = 5140;
		public static final int _4 = 5141;
		public static final int _5 = 5142;
		public static final int _6 = 5143;
		public static final int _7 = 5144;
		public static final int _8 = 5145;
		public static final int _9 = 5146;
		public static final int _10 = 5147;
		public static final int _11 = 5148;
		public static final int _12 = 5149;
		public static final int _13 = 5150;
		public static final int _14 = 5151;
		public static final int _15 = 5152;
		public static final int _16 = 5153;
		public static final int _17 = 5154;
		public static final int _18 = 5155;
		public static final int _19 = 5156;
		public static final int _20 = 5157;
		public static final int _21 = 5158;
		public static final int _22 = 5159;
		public static final int _23 = 5160;
		public static final int _24 = 5161;
		public static final int _25 = 5162;
		public static final int _26 = 5163;
		public static final int _27 = 5164;
		public static final int _28 = 5165;
		public static final int _29 = 5166;
		public static final int _30 = 5167;
		public static final int _31 = 5168;
	}

	public static final class DeadmanSigilUtilityIconsLarge
	{
		public static final int _0 = 5169;
		public static final int _1 = 5170;
		public static final int _2 = 5171;
		public static final int _3 = 5172;
		public static final int _4 = 5173;
		public static final int _5 = 5174;
		public static final int _6 = 5175;
		public static final int _7 = 5176;
		public static final int _8 = 5177;
		public static final int _9 = 5178;
		public static final int _10 = 5179;
		public static final int _11 = 5180;
		public static final int _12 = 5181;
		public static final int _13 = 5182;
		public static final int _14 = 5183;
		public static final int _15 = 5184;
		public static final int _16 = 5185;
		public static final int _17 = 5186;
		public static final int _18 = 5187;
		public static final int _19 = 5188;
		public static final int _20 = 5189;
		public static final int _21 = 5190;
		public static final int _22 = 5191;
		public static final int _23 = 5192;
		public static final int _24 = 5193;
		public static final int _25 = 5194;
		public static final int _26 = 5195;
		public static final int _27 = 5196;
		public static final int _28 = 5197;
		public static final int _29 = 5198;
		public static final int _30 = 5199;
		public static final int _31 = 5200;
	}

	public static final class DeadmanSigilUtilityIconsSmall
	{
		public static final int _0 = 5201;
		public static final int _1 = 5202;
		public static final int _2 = 5203;
		public static final int _3 = 5204;
		public static final int _4 = 5205;
		public static final int _5 = 5206;
		public static final int _6 = 5207;
		public static final int _7 = 5208;
		public static final int _8 = 5209;
		public static final int _9 = 5210;
		public static final int _10 = 5211;
		public static final int _11 = 5212;
		public static final int _12 = 5213;
		public static final int _13 = 5214;
		public static final int _14 = 5215;
		public static final int _15 = 5216;
		public static final int _16 = 5217;
		public static final int _17 = 5218;
		public static final int _18 = 5219;
		public static final int _19 = 5220;
		public static final int _20 = 5221;
		public static final int _21 = 5222;
		public static final int _22 = 5223;
		public static final int _23 = 5224;
		public static final int _24 = 5225;
		public static final int _25 = 5226;
		public static final int _26 = 5227;
		public static final int _27 = 5228;
		public static final int _28 = 5229;
		public static final int _29 = 5230;
		public static final int _30 = 5231;
		public static final int _31 = 5232;
	}

	public static final class PogButtons
	{
		public static final int _0 = 5235;
		public static final int _1 = 5236;
		public static final int _2 = 5237;
		public static final int _3 = 5238;
	}

	public static final class PogExchangeButtons
	{
		public static final int _0 = 5239;
		public static final int _1 = 5240;
	}

	public static final class PogSlots
	{
		public static final int _0 = 5241;
		public static final int _1 = 5242;
	}

	public static final class PogWindows
	{
		public static final int _0 = 5243;
		public static final int _1 = 5244;
	}

	public static final class IconBonds30x30
	{
		public static final int _0 = 5257;
		public static final int _1 = 5258;
		public static final int _2 = 5259;
	}

	public static final class IconArrow32x16
	{
		public static final int _0 = 5260;
		public static final int _1 = 5261;
		public static final int _2 = 5262;
		public static final int _3 = 5263;
	}

	public static final class LeagueTrophyIcons
	{
		public static final int _0 = 5264;
		public static final int _1 = 5265;
		public static final int _2 = 5266;
		public static final int _3 = 5267;
		public static final int _4 = 5268;
		public static final int _5 = 5269;
		public static final int _6 = 5270;
		public static final int _7 = 5271;
	}

	public static final class Satisfaction5Scale
	{
		public static final int _0 = 5273;
		public static final int _1 = 6304;
		public static final int _2 = 6305;
		public static final int _3 = 6306;
		public static final int _4 = 6307;
		public static final int _5 = 6308;
		public static final int _6 = 6309;
		public static final int _7 = 6310;
		public static final int _8 = 6311;
		public static final int _9 = 6312;
	}

	public static final class League4RelicsLarge
	{
		public static final int _0 = 5282;
		public static final int _1 = 5283;
		public static final int _2 = 5284;
		public static final int _3 = 5285;
		public static final int _4 = 5286;
		public static final int _5 = 5287;
		public static final int _6 = 5288;
		public static final int _7 = 5289;
		public static final int _8 = 5290;
		public static final int _9 = 5291;
		public static final int _10 = 5292;
		public static final int _11 = 5293;
		public static final int _12 = 5294;
		public static final int _13 = 5295;
		public static final int _14 = 5296;
		public static final int _15 = 5297;
		public static final int _16 = 5298;
		public static final int _17 = 5299;
		public static final int _18 = 5300;
		public static final int _19 = 5301;
		public static final int _20 = 5302;
		public static final int _21 = 5303;
		public static final int _22 = 5304;
		public static final int _23 = 5305;
		public static final int _24 = 5306;
		public static final int _25 = 5307;
		public static final int _26 = 5308;
	}

	public static final class League4Relics
	{
		public static final int _0 = 5309;
		public static final int _1 = 5310;
		public static final int _2 = 5311;
		public static final int _3 = 5312;
		public static final int _4 = 5313;
		public static final int _5 = 5314;
		public static final int _6 = 5315;
		public static final int _7 = 5316;
		public static final int _8 = 5317;
		public static final int _9 = 5318;
		public static final int _10 = 5319;
		public static final int _11 = 5320;
		public static final int _12 = 5321;
		public static final int _13 = 5322;
		public static final int _14 = 5323;
		public static final int _15 = 5324;
		public static final int _16 = 5325;
		public static final int _17 = 5326;
		public static final int _18 = 5327;
		public static final int _19 = 5328;
		public static final int _20 = 5329;
		public static final int _21 = 5330;
		public static final int _22 = 5331;
		public static final int _23 = 5332;
		public static final int _24 = 5333;
		public static final int _25 = 5334;
		public static final int _26 = 5335;
	}

	public static final class League4RelicsOff
	{
		public static final int _0 = 5336;
		public static final int _1 = 5337;
		public static final int _2 = 5338;
		public static final int _3 = 5339;
		public static final int _4 = 5340;
		public static final int _5 = 5341;
		public static final int _6 = 5342;
		public static final int _7 = 5343;
		public static final int _8 = 5344;
		public static final int _9 = 5345;
		public static final int _10 = 5346;
		public static final int _11 = 5347;
		public static final int _12 = 5348;
		public static final int _13 = 5349;
		public static final int _14 = 5350;
		public static final int _15 = 5351;
		public static final int _16 = 5352;
		public static final int _17 = 5353;
		public static final int _18 = 5354;
		public static final int _19 = 5355;
		public static final int _20 = 5356;
		public static final int _21 = 5357;
		public static final int _22 = 5358;
		public static final int _23 = 5359;
		public static final int _24 = 5360;
		public static final int _25 = 5361;
		public static final int _26 = 5362;
	}

	public static final class League4RelicsMedium
	{
		public static final int _0 = 5363;
		public static final int _1 = 5364;
		public static final int _2 = 5365;
		public static final int _3 = 5366;
		public static final int _4 = 5367;
		public static final int _5 = 5368;
		public static final int _6 = 5369;
		public static final int _7 = 5370;
		public static final int _8 = 5371;
		public static final int _9 = 5372;
		public static final int _10 = 5373;
		public static final int _11 = 5374;
		public static final int _12 = 5375;
		public static final int _13 = 5376;
		public static final int _14 = 5377;
		public static final int _15 = 5378;
		public static final int _16 = 5379;
		public static final int _17 = 5380;
		public static final int _18 = 5381;
		public static final int _19 = 5382;
		public static final int _20 = 5383;
		public static final int _21 = 5384;
		public static final int _22 = 5385;
		public static final int _23 = 5386;
		public static final int _24 = 5387;
		public static final int _25 = 5388;
		public static final int _26 = 5389;
	}

	public static final class League4RelicsMediumOff
	{
		public static final int _0 = 5391;
		public static final int _1 = 5392;
		public static final int _2 = 5393;
		public static final int _3 = 5394;
		public static final int _4 = 5395;
		public static final int _5 = 5396;
		public static final int _6 = 5397;
		public static final int _7 = 5398;
		public static final int _8 = 5399;
		public static final int _9 = 5400;
		public static final int _10 = 5401;
		public static final int _11 = 5402;
		public static final int _12 = 5403;
		public static final int _13 = 5404;
		public static final int _14 = 5405;
		public static final int _15 = 5406;
		public static final int _16 = 5407;
		public static final int _17 = 5408;
		public static final int _18 = 5409;
		public static final int _19 = 5410;
		public static final int _20 = 5411;
		public static final int _21 = 5412;
		public static final int _22 = 5413;
		public static final int _23 = 5414;
		public static final int _24 = 5415;
		public static final int _25 = 5416;
		public static final int _26 = 5417;
	}

	public static final class League4RelicsTli
	{
		public static final int _0 = 5418;
		public static final int _1 = 5419;
		public static final int _2 = 5420;
		public static final int _3 = 5421;
		public static final int _4 = 5422;
		public static final int _5 = 5423;
		public static final int _6 = 5424;
		public static final int _7 = 5425;
		public static final int _8 = 5426;
		public static final int _9 = 5427;
		public static final int _10 = 5428;
		public static final int _11 = 5429;
		public static final int _12 = 5430;
		public static final int _13 = 5431;
		public static final int _14 = 5432;
		public static final int _15 = 5433;
		public static final int _16 = 5434;
		public static final int _17 = 5435;
		public static final int _18 = 5436;
		public static final int _19 = 5437;
		public static final int _20 = 5438;
		public static final int _21 = 5439;
		public static final int _22 = 5440;
		public static final int _23 = 5441;
		public static final int _24 = 5442;
		public static final int _25 = 5443;
		public static final int _26 = 5444;
	}

	public static final class League4ProgressBar
	{
		public static final int _0 = 5445;
		public static final int _1 = 5446;
	}

	public static final class League4MapShields01
	{
		public static final int _0 = 5459;
		public static final int _1 = 5460;
		public static final int _2 = 5461;
		public static final int _3 = 5462;
		public static final int _4 = 5463;
		public static final int _5 = 5464;
		public static final int _6 = 5465;
		public static final int _7 = 5466;
		public static final int _8 = 5467;
		public static final int _9 = 5468;
		public static final int _10 = 5469;
		public static final int _11 = 5470;
		public static final int _12 = 5471;
		public static final int _13 = 5472;
		public static final int _14 = 5473;
		public static final int _15 = 5474;
		public static final int _16 = 5475;
		public static final int _17 = 5476;
		public static final int _18 = 5477;
		public static final int _19 = 5478;
	}

	public static final class League4MapShields02
	{
		public static final int _0 = 5479;
		public static final int _1 = 5480;
		public static final int _2 = 5481;
		public static final int _3 = 5482;
		public static final int _4 = 5483;
		public static final int _5 = 5484;
		public static final int _6 = 5485;
		public static final int _7 = 5486;
		public static final int _8 = 5487;
		public static final int _9 = 5488;
		public static final int _10 = 5489;
		public static final int _11 = 5490;
		public static final int _12 = 5491;
		public static final int _13 = 5492;
		public static final int _14 = 5493;
		public static final int _15 = 5494;
		public static final int _16 = 5495;
		public static final int _17 = 5496;
		public static final int _18 = 5497;
		public static final int _19 = 5498;
		public static final int _20 = 5499;
		public static final int _21 = 5500;
		public static final int _22 = 5501;
		public static final int _23 = 5502;
		public static final int _24 = 5503;
		public static final int _25 = 5504;
		public static final int _26 = 5505;
		public static final int _27 = 5506;
		public static final int _28 = 5507;
		public static final int _29 = 5508;
	}

	public static final class League4MapNames
	{
		public static final int _0 = 5509;
		public static final int _1 = 5510;
		public static final int _2 = 5511;
		public static final int _3 = 5512;
		public static final int _4 = 5513;
		public static final int _5 = 5514;
		public static final int _6 = 5515;
		public static final int _7 = 5516;
		public static final int _8 = 5517;
		public static final int _9 = 5518;
		public static final int _10 = 5519;
		public static final int _11 = 5520;
		public static final int _12 = 5521;
		public static final int _13 = 5522;
		public static final int _14 = 5523;
		public static final int _15 = 5524;
		public static final int _16 = 5525;
		public static final int _17 = 5526;
		public static final int _18 = 5527;
		public static final int _19 = 5528;
	}

	public static final class BadgeColosseumModifiers01_64x64
	{
		public static final int _0 = 5531;
		public static final int _1 = 5532;
		public static final int _2 = 5533;
	}

	public static final class IconColosseumModifiers01_64x64
	{
		public static final int _0 = 5534;
		public static final int _1 = 5535;
		public static final int _2 = 5536;
		public static final int _3 = 5537;
		public static final int _4 = 5538;
		public static final int _5 = 5539;
		public static final int _6 = 5540;
		public static final int _7 = 5541;
		public static final int _8 = 5542;
		public static final int _9 = 5543;
		public static final int _10 = 5544;
		public static final int _11 = 5545;
		public static final int _12 = 5546;
		public static final int _13 = 5547;
		public static final int _14 = 5548;
	}

	public static final class IconColosseumModifiers02_64x64
	{
		public static final int _0 = 5549;
		public static final int _1 = 5550;
		public static final int _2 = 5551;
		public static final int _3 = 5552;
		public static final int _4 = 5553;
		public static final int _5 = 5554;
		public static final int _6 = 5555;
		public static final int _7 = 5556;
		public static final int _8 = 5557;
		public static final int _9 = 5558;
		public static final int _10 = 5559;
		public static final int _11 = 5560;
		public static final int _12 = 5561;
		public static final int _13 = 5562;
		public static final int _14 = 5563;
	}

	public static final class IconColosseumModifiers03_64x64
	{
		public static final int _0 = 5564;
		public static final int _1 = 5565;
		public static final int _2 = 5566;
		public static final int _3 = 5567;
		public static final int _4 = 5568;
		public static final int _5 = 5569;
		public static final int _6 = 5570;
		public static final int _7 = 5571;
		public static final int _8 = 5572;
		public static final int _9 = 5573;
		public static final int _10 = 5574;
		public static final int _11 = 5575;
		public static final int _12 = 5576;
		public static final int _13 = 5577;
		public static final int _14 = 5578;
	}

	public static final class HeadbarBlood120
	{
		public static final int _0 = 5579;
		public static final int _1 = 5580;

		public static final int FRONT = _0;
		public static final int BACK = _1;
	}

	public static final class HeadbarIce120
	{
		public static final int _0 = 5581;
		public static final int _1 = 5582;

		public static final int FRONT = _0;
		public static final int BACK = _1;
	}

	public static final class HeadbarHeat120
	{
		public static final int _0 = 5583;
		public static final int _1 = 5584;

		public static final int FRONT = _0;
		public static final int BACK = _1;
	}

	public static final class Arrows25
	{
		public static final int _0 = 5589;
		public static final int _1 = 5590;
		public static final int _2 = 5591;
		public static final int _3 = 5592;
	}

	public static final class Arrows40
	{
		public static final int _0 = 5593;
		public static final int _1 = 5594;
		public static final int _2 = 5595;
		public static final int _3 = 5596;
		public static final int _4 = 5597;
		public static final int _5 = 5598;
		public static final int _6 = 5599;
		public static final int _7 = 5600;
	}

	public static final class StandardHealth90
	{
		public static final int _0 = 5609;
		public static final int _1 = 5610;

		public static final int FRONT = _0;
		public static final int BACK = _1;
	}

	public static final class StandardShield90
	{
		public static final int _0 = 5611;
		public static final int _1 = 5612;

		public static final int FRONT = _0;
		public static final int BACK = _1;
	}

	public static final class StandardArmour90
	{
		public static final int _0 = 5613;
		public static final int _1 = 5614;

		public static final int FRONT = _0;
		public static final int BACK = _1;
	}

	public static final class StandardCharge90
	{
		public static final int _0 = 5615;
		public static final int _1 = 5616;

		public static final int FRONT = _0;
		public static final int BACK = _1;
	}

	public static final class StandardPrayer90
	{
		public static final int _0 = 5617;
		public static final int _1 = 5618;

		public static final int FRONT = _0;
		public static final int BACK = _1;
	}

	public static final class StandardPoison90
	{
		public static final int _0 = 5619;
		public static final int _1 = 5620;

		public static final int FRONT = _0;
		public static final int BACK = _1;
	}

	public static final class OverlayTdMultiway
	{
		public static final int _0 = 5641;
		public static final int _1 = 5642;
		public static final int _2 = 5643;
	}

	public static final class HeadbarBlood90
	{
		public static final int _0 = 5644;
		public static final int _1 = 5645;

		public static final int FRONT = _0;
		public static final int BACK = _1;
	}

	public static final class HeadbarIce90
	{
		public static final int _0 = 5646;
		public static final int _1 = 5647;

		public static final int FRONT = _0;
		public static final int BACK = _1;
	}

	public static final class HeadbarHeat90
	{
		public static final int _0 = 5648;
		public static final int _1 = 5649;

		public static final int FRONT = _0;
		public static final int BACK = _1;
	}

	public static final class NumberPadButtons
	{
		public static final int _0 = 5651;
		public static final int _1 = 5652;
		public static final int _2 = 5653;
		public static final int _3 = 5654;
		public static final int _4 = 5655;
		public static final int _5 = 5656;
		public static final int _6 = 5657;
		public static final int _7 = 5658;
		public static final int _8 = 5659;
		public static final int _9 = 5660;
	}

	public static final class NumberPadArrows
	{
		public static final int _0 = 5661;
		public static final int _1 = 5662;
	}

	public static final class IconAlchemyChemicals01_27x27
	{
		public static final int _0 = 5663;
		public static final int _1 = 5664;
		public static final int _2 = 5665;
	}

	public static final class IconAlchemyChemicals01_20x20
	{
		public static final int _0 = 5666;
		public static final int _1 = 5667;
		public static final int _2 = 5668;
	}

	public static final class IconAlchemyChemicals01_18x18
	{
		public static final int _0 = 5669;
		public static final int _1 = 5670;
		public static final int _2 = 5671;
	}

	public static final class IconAlchemyMachines01_20x20
	{
		public static final int _0 = 5672;
		public static final int _1 = 5673;
		public static final int _2 = 5674;
	}

	public static final class HiscoresIcons
	{
		public static final int _0 = 5677;
		public static final int _1 = 5678;
		public static final int _2 = 5679;
		public static final int _3 = 5680;
		public static final int _4 = 5681;
		public static final int _5 = 5682;
		public static final int _6 = 5683;
		public static final int _7 = 5684;
		public static final int _8 = 5685;
		public static final int _9 = 5686;
	}

	public static final class HiscoresActivities
	{
		public static final int _0 = 5687;
		public static final int _1 = 5688;
		public static final int _2 = 5689;
		public static final int _3 = 5690;
		public static final int _4 = 5691;
		public static final int _5 = 5692;
		public static final int _6 = 5693;
		public static final int _7 = 5694;
	}

	public static final class HiscoresBosses
	{
		public static final int _0 = 5695;
		public static final int _1 = 5696;
		public static final int _2 = 5697;
		public static final int _3 = 5698;
		public static final int _4 = 5699;
		public static final int _5 = 5700;
		public static final int _6 = 5701;
		public static final int _7 = 5702;
		public static final int _8 = 5703;
		public static final int _9 = 5704;
		public static final int _10 = 5705;
		public static final int _11 = 5706;
		public static final int _12 = 5707;
		public static final int _13 = 5708;
		public static final int _14 = 5709;
		public static final int _15 = 5710;
		public static final int _16 = 5711;
		public static final int _17 = 5712;
		public static final int _18 = 5713;
		public static final int _19 = 5714;
		public static final int _20 = 5715;
		public static final int _21 = 5716;
		public static final int _22 = 5717;
		public static final int _23 = 5718;
		public static final int _24 = 5719;
		public static final int _25 = 5720;
		public static final int _26 = 5721;
		public static final int _27 = 5722;
		public static final int _28 = 5723;
		public static final int _29 = 5724;
		public static final int _30 = 5725;
		public static final int _31 = 5726;
		public static final int _32 = 5727;
		public static final int _33 = 5728;
		public static final int _34 = 5729;
		public static final int _35 = 5730;
		public static final int _36 = 5731;
		public static final int _37 = 5732;
		public static final int _38 = 5733;
		public static final int _39 = 5734;
		public static final int _40 = 5735;
		public static final int _41 = 5736;
		public static final int _42 = 5737;
		public static final int _43 = 5738;
		public static final int _44 = 5739;
		public static final int _45 = 5740;
		public static final int _46 = 5741;
		public static final int _47 = 5742;
		public static final int _48 = 5743;
		public static final int _49 = 5744;
		public static final int _50 = 5745;
		public static final int _51 = 5746;
		public static final int _52 = 5747;
		public static final int _53 = 5748;
		public static final int _54 = 5749;
		public static final int _55 = 5750;
		public static final int _56 = 5751;
		public static final int _57 = 5752;
		public static final int _58 = 5753;
		public static final int _59 = 5754;
	}

	public static final class OsmChatButtons
	{
		public static final int _0 = 5763;
		public static final int _1 = 5764;
		public static final int _2 = 5765;
		public static final int _3 = 5766;
	}

	public static final class TliButton01Square40x40
	{
		public static final int _0 = 5767;
		public static final int _1 = 5768;
		public static final int _2 = 5769;
		public static final int _3 = 5770;
		public static final int _4 = 5771;
		public static final int _5 = 5772;
	}

	public static final class TliButton01Rectangle58x40
	{
		public static final int _0 = 5773;
		public static final int _1 = 5774;
		public static final int _2 = 5775;
	}

	public static final class TliButton01Rectangle52x40
	{
		public static final int _0 = 5776;
		public static final int _1 = 5777;
		public static final int _2 = 5778;
	}

	public static final class TliButton01Rectangle58x24
	{
		public static final int _0 = 5779;
		public static final int _1 = 5780;
		public static final int _2 = 5781;
	}

	public static final class TliButton01Accordion58x43
	{
		public static final int _0 = 5782;
		public static final int _1 = 5783;
		public static final int _2 = 5784;
		public static final int _3 = 5785;
		public static final int _4 = 5786;
		public static final int _5 = 5787;
		public static final int _6 = 5788;
		public static final int _7 = 5789;
		public static final int _8 = 5790;
	}

	public static final class TliButton01Orbinfo65x34
	{
		public static final int _0 = 5791;
		public static final int _1 = 5792;
		public static final int _2 = 5793;
	}

	public static final class TliButton01Orb01_34x34
	{
		public static final int _0 = 5794;
		public static final int _1 = 5795;
		public static final int _2 = 5796;
	}

	public static final class _9SliceDark01_3x3
	{
		public static final int _0 = 5814;
		public static final int _1 = 5815;
		public static final int _2 = 5816;
		public static final int _3 = 5817;
		public static final int _4 = 5818;
		public static final int _5 = 5819;
		public static final int _6 = 5820;
		public static final int _7 = 5821;
		public static final int _8 = 5822;
	}

	public static final class _9SliceChiselled01_4x4
	{
		public static final int _0 = 5823;
		public static final int _1 = 5824;
		public static final int _2 = 5825;
		public static final int _3 = 5826;
		public static final int _4 = 5827;
		public static final int _5 = 5828;
		public static final int _6 = 5829;
		public static final int _7 = 5830;
		public static final int _8 = 5831;
	}

	public static final class CoaArrows
	{
		public static final int _0 = 5833;
		public static final int _1 = 5834;
		public static final int _2 = 5835;
		public static final int _3 = 5836;
		public static final int _4 = 5837;
		public static final int _5 = 5838;
		public static final int _6 = 5839;
		public static final int _7 = 5840;
	}

	public static final class CoaStrips
	{
		public static final int _0 = 5841;
		public static final int _1 = 5842;
		public static final int _2 = 5843;
		public static final int _3 = 5844;
		public static final int _4 = 5845;
		public static final int _5 = 5846;
		public static final int _6 = 5847;
		public static final int _7 = 5848;
		public static final int _8 = 5849;
		public static final int _9 = 5850;
		public static final int _10 = 5851;
		public static final int _11 = 5852;
	}

	public static final class IconActivities25x25
	{
		public static final int _0 = 5853;
		public static final int _1 = 5854;
		public static final int _2 = 5855;
		public static final int _3 = 5856;
		public static final int _4 = 5857;
		public static final int _5 = 5858;
		public static final int _6 = 5859;
		public static final int _7 = 5860;
		public static final int _8 = 5861;
		public static final int _9 = 5862;
		public static final int _10 = 6390;
		public static final int _11 = 6391;
		public static final int _12 = 6392;
		public static final int _13 = 6393;
		public static final int _14 = 6394;
		public static final int _15 = 6395;
		public static final int _16 = 6396;
		public static final int _17 = 6397;
		public static final int _18 = 6398;
		public static final int _19 = 6399;

		public static final int CLUE_SCROLL_ALL = _0;
		public static final int BOUNTY_HUNTER_HUNTER = _1;
		public static final int BOUNTY_HUNTER_ROGUE = _2;
		public static final int LAST_MAN_STANDING = _3;
		public static final int LEAGUE_POINTS = _4;
		public static final int SOUL_WARS_ZEAL = _5;
		public static final int PVP_ARENA_RANK = _6;
		public static final int RIFTS_CLOSED = _7;
		public static final int DEADMAN_POINTS = _8;
		public static final int COLOSSEUM_GLORY = _9;
		public static final int COLLECTIONS_LOGGED = _10;
	}

	public static final class HeadbarBlood30
	{
		public static final int _0 = 5863;
		public static final int _1 = 5864;

		public static final int FRONT = _0;
		public static final int BACK = _1;
	}

	public static final class League5MapShields01
	{
		public static final int _0 = 5877;
		public static final int _1 = 5878;
		public static final int _2 = 5879;
		public static final int _3 = 5880;
		public static final int _4 = 5881;
		public static final int _5 = 5882;
		public static final int _6 = 5883;
		public static final int _7 = 5884;
		public static final int _8 = 5885;
		public static final int _9 = 5886;
		public static final int _10 = 5887;
		public static final int _11 = 5888;
		public static final int _12 = 5889;
		public static final int _13 = 5890;
		public static final int _14 = 5891;
		public static final int _15 = 5892;
		public static final int _16 = 5893;
		public static final int _17 = 5894;
		public static final int _18 = 5895;
		public static final int _19 = 5896;
		public static final int _20 = 5897;
		public static final int _21 = 5898;
		public static final int _22 = 5899;
		public static final int _23 = 5900;
	}

	public static final class League5MapShields02
	{
		public static final int _0 = 5901;
		public static final int _1 = 5902;
		public static final int _2 = 5903;
		public static final int _3 = 5904;
		public static final int _4 = 5905;
		public static final int _5 = 5906;
		public static final int _6 = 5907;
		public static final int _7 = 5908;
		public static final int _8 = 5909;
		public static final int _9 = 5910;
		public static final int _10 = 5911;
		public static final int _11 = 5912;
		public static final int _12 = 5913;
		public static final int _13 = 5914;
		public static final int _14 = 5915;
		public static final int _15 = 5916;
		public static final int _16 = 5917;
		public static final int _17 = 5918;
		public static final int _18 = 5919;
		public static final int _19 = 5920;
		public static final int _20 = 5921;
		public static final int _21 = 5922;
		public static final int _22 = 5923;
		public static final int _23 = 5924;
		public static final int _24 = 5925;
		public static final int _25 = 5926;
		public static final int _26 = 5927;
		public static final int _27 = 5928;
		public static final int _28 = 5929;
		public static final int _29 = 5930;
		public static final int _30 = 5931;
		public static final int _31 = 5932;
		public static final int _32 = 5933;
		public static final int _33 = 5934;
		public static final int _34 = 5935;
		public static final int _35 = 5936;
	}

	public static final class League5MapNames
	{
		public static final int _0 = 5937;
		public static final int _1 = 5938;
		public static final int _2 = 5939;
		public static final int _3 = 5940;
		public static final int _4 = 5941;
		public static final int _5 = 5942;
		public static final int _6 = 5943;
		public static final int _7 = 5944;
		public static final int _8 = 5945;
		public static final int _9 = 5946;
		public static final int _10 = 5947;
		public static final int _11 = 5948;
		public static final int _12 = 5949;
		public static final int _13 = 5950;
		public static final int _14 = 5951;
		public static final int _15 = 5952;
		public static final int _16 = 5953;
		public static final int _17 = 5954;
		public static final int _18 = 5955;
		public static final int _19 = 5956;
		public static final int _20 = 5957;
		public static final int _21 = 5958;
		public static final int _22 = 5959;
		public static final int _23 = 5960;
	}

	public static final class League5RelicsLarge
	{
		public static final int _0 = 5961;
		public static final int _1 = 5962;
		public static final int _2 = 5963;
		public static final int _3 = 5964;
		public static final int _4 = 5965;
		public static final int _5 = 5966;
		public static final int _6 = 5967;
		public static final int _7 = 5968;
		public static final int _8 = 5969;
		public static final int _9 = 5970;
		public static final int _10 = 5971;
		public static final int _11 = 5972;
		public static final int _12 = 5973;
		public static final int _13 = 5974;
		public static final int _14 = 5975;
		public static final int _15 = 5976;
		public static final int _16 = 5977;
		public static final int _17 = 5978;
		public static final int _18 = 5979;
		public static final int _19 = 5980;
		public static final int _20 = 5981;
		public static final int _21 = 5982;
		public static final int _22 = 5983;
		public static final int _23 = 5984;
		public static final int _24 = 5985;
		public static final int _25 = 5986;
		public static final int _26 = 5987;
	}

	public static final class League5Relics
	{
		public static final int _0 = 5988;
		public static final int _1 = 5989;
		public static final int _2 = 5990;
		public static final int _3 = 5991;
		public static final int _4 = 5992;
		public static final int _5 = 5993;
		public static final int _6 = 5994;
		public static final int _7 = 5995;
		public static final int _8 = 5996;
		public static final int _9 = 5997;
		public static final int _10 = 5998;
		public static final int _11 = 5999;
		public static final int _12 = 6000;
		public static final int _13 = 6001;
		public static final int _14 = 6002;
		public static final int _15 = 6003;
		public static final int _16 = 6004;
		public static final int _17 = 6005;
		public static final int _18 = 6006;
		public static final int _19 = 6007;
		public static final int _20 = 6008;
		public static final int _21 = 6009;
		public static final int _22 = 6010;
		public static final int _23 = 6011;
		public static final int _24 = 6012;
		public static final int _25 = 6013;
		public static final int _26 = 6014;
	}

	public static final class League5RelicsOff
	{
		public static final int _0 = 6015;
		public static final int _1 = 6016;
		public static final int _2 = 6017;
		public static final int _3 = 6018;
		public static final int _4 = 6019;
		public static final int _5 = 6020;
		public static final int _6 = 6021;
		public static final int _7 = 6022;
		public static final int _8 = 6023;
		public static final int _9 = 6024;
		public static final int _10 = 6025;
		public static final int _11 = 6026;
		public static final int _12 = 6027;
		public static final int _13 = 6028;
		public static final int _14 = 6029;
		public static final int _15 = 6030;
		public static final int _16 = 6031;
		public static final int _17 = 6032;
		public static final int _18 = 6033;
		public static final int _19 = 6034;
		public static final int _20 = 6035;
		public static final int _21 = 6036;
		public static final int _22 = 6037;
		public static final int _23 = 6038;
		public static final int _24 = 6039;
		public static final int _25 = 6040;
		public static final int _26 = 6041;
	}

	public static final class League5RelicsMedium
	{
		public static final int _0 = 6042;
		public static final int _1 = 6043;
		public static final int _2 = 6044;
		public static final int _3 = 6045;
		public static final int _4 = 6046;
		public static final int _5 = 6047;
		public static final int _6 = 6048;
		public static final int _7 = 6049;
		public static final int _8 = 6050;
		public static final int _9 = 6051;
		public static final int _10 = 6052;
		public static final int _11 = 6053;
		public static final int _12 = 6054;
		public static final int _13 = 6055;
		public static final int _14 = 6056;
		public static final int _15 = 6057;
		public static final int _16 = 6058;
		public static final int _17 = 6059;
		public static final int _18 = 6060;
		public static final int _19 = 6061;
		public static final int _20 = 6062;
		public static final int _21 = 6063;
		public static final int _22 = 6064;
		public static final int _23 = 6065;
		public static final int _24 = 6066;
		public static final int _25 = 6067;
		public static final int _26 = 6068;
	}

	public static final class League5RelicsMediumOff
	{
		public static final int _0 = 6070;
		public static final int _1 = 6071;
		public static final int _2 = 6072;
		public static final int _3 = 6073;
		public static final int _4 = 6074;
		public static final int _5 = 6075;
		public static final int _6 = 6076;
		public static final int _7 = 6077;
		public static final int _8 = 6078;
		public static final int _9 = 6079;
		public static final int _10 = 6080;
		public static final int _11 = 6081;
		public static final int _12 = 6082;
		public static final int _13 = 6083;
		public static final int _14 = 6084;
		public static final int _15 = 6085;
		public static final int _16 = 6086;
		public static final int _17 = 6087;
		public static final int _18 = 6088;
		public static final int _19 = 6089;
		public static final int _20 = 6090;
		public static final int _21 = 6091;
		public static final int _22 = 6092;
		public static final int _23 = 6093;
		public static final int _24 = 6094;
		public static final int _25 = 6095;
		public static final int _26 = 6096;
	}

	public static final class League5RelicsTli
	{
		public static final int _0 = 6097;
		public static final int _1 = 6098;
		public static final int _2 = 6099;
		public static final int _3 = 6100;
		public static final int _4 = 6101;
		public static final int _5 = 6102;
		public static final int _6 = 6103;
		public static final int _7 = 6104;
		public static final int _8 = 6105;
		public static final int _9 = 6106;
		public static final int _10 = 6107;
		public static final int _11 = 6108;
		public static final int _12 = 6109;
		public static final int _13 = 6110;
		public static final int _14 = 6111;
		public static final int _15 = 6112;
		public static final int _16 = 6113;
		public static final int _17 = 6114;
		public static final int _18 = 6115;
		public static final int _19 = 6116;
		public static final int _20 = 6117;
		public static final int _21 = 6118;
		public static final int _22 = 6119;
		public static final int _23 = 6120;
		public static final int _24 = 6121;
		public static final int _25 = 6122;
		public static final int _26 = 6123;
	}

	public static final class League5ProgressBar
	{
		public static final int _0 = 6124;
		public static final int _1 = 6125;
	}

	public static final class League5CombatMasteryLarge
	{
		public static final int _0 = 6127;
		public static final int _1 = 6128;
		public static final int _2 = 6129;
		public static final int _3 = 6130;
		public static final int _4 = 6131;
		public static final int _5 = 6132;
		public static final int _6 = 6133;
		public static final int _7 = 6134;
		public static final int _8 = 6135;
		public static final int _9 = 6136;
		public static final int _10 = 6137;
		public static final int _11 = 6138;
		public static final int _12 = 6139;
		public static final int _13 = 6140;
		public static final int _14 = 6141;
		public static final int _15 = 6142;
		public static final int _16 = 6143;
		public static final int _17 = 6144;
	}

	public static final class League5CombatMasteryLargeOff
	{
		public static final int _0 = 6145;
		public static final int _1 = 6146;
		public static final int _2 = 6147;
		public static final int _3 = 6148;
		public static final int _4 = 6149;
		public static final int _5 = 6150;
		public static final int _6 = 6151;
		public static final int _7 = 6152;
		public static final int _8 = 6153;
		public static final int _9 = 6154;
		public static final int _10 = 6155;
		public static final int _11 = 6156;
		public static final int _12 = 6157;
		public static final int _13 = 6158;
		public static final int _14 = 6159;
		public static final int _15 = 6160;
		public static final int _16 = 6161;
		public static final int _17 = 6162;
	}

	public static final class League5CombatMasteryMedium
	{
		public static final int _0 = 6163;
		public static final int _1 = 6164;
		public static final int _2 = 6165;
		public static final int _3 = 6166;
		public static final int _4 = 6167;
		public static final int _5 = 6168;
		public static final int _6 = 6169;
		public static final int _7 = 6170;
		public static final int _8 = 6171;
		public static final int _9 = 6172;
		public static final int _10 = 6173;
		public static final int _11 = 6174;
		public static final int _12 = 6175;
		public static final int _13 = 6176;
		public static final int _14 = 6177;
		public static final int _15 = 6178;
		public static final int _16 = 6179;
		public static final int _17 = 6180;
	}

	public static final class League5CombatMasteryMediumOff
	{
		public static final int _0 = 6181;
		public static final int _1 = 6182;
		public static final int _2 = 6183;
		public static final int _3 = 6184;
		public static final int _4 = 6185;
		public static final int _5 = 6186;
		public static final int _6 = 6187;
		public static final int _7 = 6188;
		public static final int _8 = 6189;
		public static final int _9 = 6190;
		public static final int _10 = 6191;
		public static final int _11 = 6192;
		public static final int _12 = 6193;
		public static final int _13 = 6194;
		public static final int _14 = 6195;
		public static final int _15 = 6196;
		public static final int _16 = 6197;
		public static final int _17 = 6198;
	}

	public static final class League5CombatMasterySmall
	{
		public static final int _0 = 6199;
		public static final int _1 = 6200;
		public static final int _2 = 6201;
		public static final int _3 = 6202;
		public static final int _4 = 6203;
		public static final int _5 = 6204;
		public static final int _6 = 6205;
		public static final int _7 = 6206;
		public static final int _8 = 6207;
		public static final int _9 = 6208;
		public static final int _10 = 6209;
		public static final int _11 = 6210;
		public static final int _12 = 6211;
		public static final int _13 = 6212;
		public static final int _14 = 6213;
		public static final int _15 = 6214;
		public static final int _16 = 6215;
		public static final int _17 = 6216;
	}

	public static final class League5CombatMasterySmallOff
	{
		public static final int _0 = 6217;
		public static final int _1 = 6218;
		public static final int _2 = 6219;
		public static final int _3 = 6220;
		public static final int _4 = 6221;
		public static final int _5 = 6222;
		public static final int _6 = 6223;
		public static final int _7 = 6224;
		public static final int _8 = 6225;
		public static final int _9 = 6226;
		public static final int _10 = 6227;
		public static final int _11 = 6228;
		public static final int _12 = 6229;
		public static final int _13 = 6230;
		public static final int _14 = 6231;
		public static final int _15 = 6232;
		public static final int _16 = 6233;
		public static final int _17 = 6234;
		public static final int _18 = 6235;
		public static final int _19 = 6236;
		public static final int _20 = 6237;
		public static final int _21 = 6238;
		public static final int _22 = 6239;
		public static final int _23 = 6240;
	}

	public static final class League5CombatMasteryTli
	{
		public static final int _0 = 6241;
		public static final int _1 = 6242;
		public static final int _2 = 6243;
		public static final int _3 = 6244;
		public static final int _4 = 6245;
		public static final int _5 = 6246;
		public static final int _6 = 6247;
		public static final int _7 = 6248;
		public static final int _8 = 6249;
		public static final int _9 = 6250;
		public static final int _10 = 6251;
		public static final int _11 = 6252;
		public static final int _12 = 6253;
		public static final int _13 = 6254;
		public static final int _14 = 6255;
		public static final int _15 = 6256;
		public static final int _16 = 6257;
		public static final int _17 = 6258;
	}

	public static final class League5CombatMasteryTierSmall
	{
		public static final int _0 = 6259;
		public static final int _1 = 6260;
		public static final int _2 = 6261;
		public static final int _3 = 6262;
		public static final int _4 = 6263;
		public static final int _5 = 6264;
	}

	public static final class League5CombatMasteryTierSmallOff
	{
		public static final int _0 = 6265;
		public static final int _1 = 6266;
		public static final int _2 = 6267;
		public static final int _3 = 6268;
		public static final int _4 = 6269;
		public static final int _5 = 6270;
	}

	public static final class League5CombatMasteryTierMedium
	{
		public static final int _0 = 6271;
		public static final int _1 = 6272;
		public static final int _2 = 6273;
		public static final int _3 = 6274;
		public static final int _4 = 6275;
		public static final int _5 = 6276;
	}

	public static final class League5CombatMasteryTierMediumOff
	{
		public static final int _0 = 6277;
		public static final int _1 = 6278;
		public static final int _2 = 6279;
		public static final int _3 = 6280;
		public static final int _4 = 6281;
		public static final int _5 = 6282;
	}

	public static final class League5Sparks1
	{
		public static final int _0 = 6289;
		public static final int _1 = 6290;
		public static final int _2 = 6291;
	}

	public static final class League5Sparks2
	{
		public static final int _0 = 6292;
		public static final int _1 = 6293;
		public static final int _2 = 6294;
	}

	public static final class LeagueRelicsOutline60x60
	{
		public static final int _0 = 6301;
		public static final int _1 = 6302;
	}

	public static final class IconYama34x34
	{
		public static final int _0 = 6400;
		public static final int _1 = 6401;
		public static final int _2 = 6402;
		public static final int _3 = 6403;
		public static final int _4 = 6404;
	}

	public static final class JigsawButtons
	{
		public static final int _0 = 6406;
		public static final int _1 = 6407;
	}

	public static final class GeModify
	{
		public static final int _0 = 6409;
		public static final int _1 = 6410;
	}

	public static final class V2StoneButtonGreen
	{
		public static final int _0 = 6417;
		public static final int _1 = 6418;
		public static final int _2 = 6419;
		public static final int _3 = 6420;
		public static final int _4 = 6421;
		public static final int _5 = 6422;
		public static final int _6 = 6423;
		public static final int _7 = 6424;
	}

	public static final class V2StoneButtonInGreen
	{
		public static final int _0 = 6425;
		public static final int _1 = 6426;
		public static final int _2 = 6427;
		public static final int _3 = 6428;
		public static final int _4 = 6429;
		public static final int _5 = 6430;
		public static final int _6 = 6431;
		public static final int _7 = 6432;
		public static final int _8 = 6433;
		public static final int _9 = 6434;
		public static final int _10 = 6435;
		public static final int _11 = 6436;
		public static final int _12 = 6437;
		public static final int _13 = 6438;
		public static final int _14 = 6439;
		public static final int _15 = 6440;
		public static final int _16 = 6441;
		public static final int _17 = 6442;
		public static final int _18 = 6443;
		public static final int _19 = 6444;
		public static final int _20 = 6445;
		public static final int _21 = 6446;
		public static final int _22 = 6447;
		public static final int _23 = 6448;
	}

	public static final class RelicBingo01_30x30_01
	{
		public static final int _0 = 6611;
		public static final int _1 = 6612;
		public static final int _2 = 6613;
		public static final int _3 = 6614;
		public static final int _4 = 6615;
		public static final int _5 = 6616;
		public static final int _6 = 6617;
		public static final int _7 = 6618;
		public static final int _8 = 6619;
		public static final int _9 = 6620;
		public static final int _10 = 6621;
		public static final int _11 = 6622;
		public static final int _12 = 6623;
		public static final int _13 = 6624;
		public static final int _14 = 6625;
		public static final int _15 = 6626;
		public static final int _16 = 6627;
		public static final int _17 = 6628;
		public static final int _18 = 6629;
		public static final int _19 = 6630;
		public static final int _20 = 6631;
		public static final int _21 = 6632;
		public static final int _22 = 6633;
		public static final int _23 = 6634;
		public static final int _24 = 6635;
		public static final int _25 = 6636;
		public static final int _26 = 6637;
	}

	public static final class RelicBingo01_30x30_02
	{
		public static final int _0 = 6638;
		public static final int _1 = 6639;
		public static final int _2 = 6640;
		public static final int _3 = 6641;
		public static final int _4 = 6642;
		public static final int _5 = 6643;
		public static final int _6 = 6644;
		public static final int _7 = 6645;
		public static final int _8 = 6646;
		public static final int _9 = 6647;
		public static final int _10 = 6648;
		public static final int _11 = 6649;
		public static final int _12 = 6650;
		public static final int _13 = 6651;
		public static final int _14 = 6652;
		public static final int _15 = 6653;
		public static final int _16 = 6654;
		public static final int _17 = 6655;
		public static final int _18 = 6656;
		public static final int _19 = 6657;
		public static final int _20 = 6658;
		public static final int _21 = 6659;
		public static final int _22 = 6660;
		public static final int _23 = 6661;
		public static final int _24 = 6662;
		public static final int _25 = 6663;
		public static final int _26 = 6664;
	}

	public static final class RelicBingo01_60x60_01
	{
		public static final int _0 = 6665;
		public static final int _1 = 6666;
		public static final int _2 = 6667;
		public static final int _3 = 6668;
		public static final int _4 = 6669;
		public static final int _5 = 6670;
		public static final int _6 = 6671;
		public static final int _7 = 6672;
		public static final int _8 = 6673;
		public static final int _9 = 6674;
		public static final int _10 = 6675;
		public static final int _11 = 6676;
		public static final int _12 = 6677;
		public static final int _13 = 6678;
		public static final int _14 = 6679;
		public static final int _15 = 6680;
		public static final int _16 = 6681;
		public static final int _17 = 6682;
		public static final int _18 = 6683;
		public static final int _19 = 6684;
		public static final int _20 = 6685;
		public static final int _21 = 6686;
		public static final int _22 = 6687;
		public static final int _23 = 6688;
		public static final int _24 = 6689;
		public static final int _25 = 6690;
		public static final int _26 = 6691;
	}

	public static final class RelicBingo01_60x60_02
	{
		public static final int _0 = 6692;
		public static final int _1 = 6693;
		public static final int _2 = 6694;
		public static final int _3 = 6695;
		public static final int _4 = 6696;
		public static final int _5 = 6697;
		public static final int _6 = 6698;
		public static final int _7 = 6699;
		public static final int _8 = 6700;
		public static final int _9 = 6701;
		public static final int _10 = 6702;
		public static final int _11 = 6703;
		public static final int _12 = 6704;
		public static final int _13 = 6705;
		public static final int _14 = 6706;
		public static final int _15 = 6707;
		public static final int _16 = 6708;
		public static final int _17 = 6709;
		public static final int _18 = 6710;
		public static final int _19 = 6711;
		public static final int _20 = 6712;
		public static final int _21 = 6713;
		public static final int _22 = 6714;
		public static final int _23 = 6715;
		public static final int _24 = 6716;
		public static final int _25 = 6717;
		public static final int _26 = 6718;
	}

	public static final class ShieldBingo01_29x29
	{
		public static final int _0 = 6719;
		public static final int _1 = 6720;
		public static final int _2 = 6721;
		public static final int _3 = 6722;
		public static final int _4 = 6723;
		public static final int _5 = 6724;
		public static final int _6 = 6725;
		public static final int _7 = 6726;
		public static final int _8 = 6727;
		public static final int _9 = 6728;
	}

	public static final class ShieldBingo01_58x58
	{
		public static final int _0 = 6729;
		public static final int _1 = 6730;
		public static final int _2 = 6731;
		public static final int _3 = 6732;
		public static final int _4 = 6733;
		public static final int _5 = 6734;
		public static final int _6 = 6735;
		public static final int _7 = 6736;
		public static final int _8 = 6737;
		public static final int _9 = 6738;
	}

	public static final class XpBingo01_29x29
	{
		public static final int _0 = 6739;
		public static final int _1 = 6740;
		public static final int _2 = 6741;
		public static final int _3 = 6742;
		public static final int _4 = 6743;
		public static final int _5 = 6744;
	}

	public static final class XpBingo01_58x58
	{
		public static final int _0 = 6745;
		public static final int _1 = 6746;
		public static final int _2 = 6747;
		public static final int _3 = 6748;
		public static final int _4 = 6749;
		public static final int _5 = 6750;
	}

	public static final class IconMob25x25
	{
		public static final int _0 = 6753;
		public static final int _1 = 6754;
		public static final int _2 = 6755;
		public static final int _3 = 6756;
	}

	public static final class IconMob50x50
	{
		public static final int _0 = 6757;
		public static final int _1 = 6758;
		public static final int _2 = 6759;
		public static final int _3 = 6760;
	}

	public static final class IconCompassRose50x50
	{
		public static final int _0 = 6761;
		public static final int _1 = 6762;
		public static final int _2 = 6763;
		public static final int _3 = 6764;
	}

	public static final class PipProgress12x12
	{
		public static final int _0 = 6787;
		public static final int _1 = 6788;
	}

	public static final class PollStatus
	{
		public static final int _0 = 6789;
		public static final int _1 = 6790;
		public static final int _2 = 6791;
		public static final int _3 = 6792;
	}

	public static final class PollCategory
	{
		public static final int _0 = 6793;
		public static final int _1 = 6794;
		public static final int _2 = 6795;
	}
}
