/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.loottracker;

import java.util.Arrays;
import lombok.NonNull;
import net.runelite.client.plugins.loottracker.LootTrackerItem;
import net.runelite.http.api.loottracker.LootRecordType;

class LootTrackerRecord {
    @NonNull
    private final String title;
    private final String subTitle;
    private final LootRecordType type;
    private LootTrackerItem[] items;
    private int kills;

    boolean matches(String id, LootRecordType type) {
        if (id == null) {
            return true;
        }
        return this.title.equals(id) && this.type == type;
    }

    void merge(LootTrackerRecord record) {
        assert (this.title.equals(record.title));
        assert (this.type == record.type);
        block0: for (LootTrackerItem item : record.items) {
            for (int idx = 0; idx < this.items.length; ++idx) {
                LootTrackerItem r = this.items[idx];
                if (r.getId() != item.getId()) continue;
                int qty = r.getQuantity() + item.getQuantity();
                if (qty < 0) {
                    qty = Integer.MAX_VALUE;
                }
                this.items[idx] = new LootTrackerItem(r.getId(), r.getName(), qty, r.getGePrice(), r.getHaPrice(), r.isIgnored());
                continue block0;
            }
            this.items = Arrays.copyOf(this.items, this.items.length + 1);
            this.items[this.items.length - 1] = item;
        }
        this.kills += record.kills;
    }

    @NonNull
    public String getTitle() {
        return this.title;
    }

    public String getSubTitle() {
        return this.subTitle;
    }

    public LootRecordType getType() {
        return this.type;
    }

    public LootTrackerItem[] getItems() {
        return this.items;
    }

    public int getKills() {
        return this.kills;
    }

    public LootTrackerRecord(@NonNull String title, String subTitle, LootRecordType type, LootTrackerItem[] items, int kills) {
        if (title == null) {
            throw new NullPointerException("title is marked non-null but is null");
        }
        this.title = title;
        this.subTitle = subTitle;
        this.type = type;
        this.items = items;
        this.kills = kills;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LootTrackerRecord)) {
            return false;
        }
        LootTrackerRecord other = (LootTrackerRecord)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        LootRecordType this$type = this.getType();
        LootRecordType other$type = other.getType();
        return !(this$type == null ? other$type != null : !this$type.equals(other$type));
    }

    protected boolean canEqual(Object other) {
        return other instanceof LootTrackerRecord;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        LootRecordType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        return result;
    }
}

