/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.objectindicators;

import com.google.common.base.MoreObjects;
import com.google.common.base.Strings;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.google.inject.Provides;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.swing.SwingUtilities;
import net.runelite.api.Client;
import net.runelite.api.DecorativeObject;
import net.runelite.api.GameObject;
import net.runelite.api.GroundObject;
import net.runelite.api.Menu;
import net.runelite.api.MenuAction;
import net.runelite.api.MenuEntry;
import net.runelite.api.ObjectComposition;
import net.runelite.api.Scene;
import net.runelite.api.Tile;
import net.runelite.api.TileObject;
import net.runelite.api.WallObject;
import net.runelite.api.WorldEntity;
import net.runelite.api.WorldView;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.DecorativeObjectDespawned;
import net.runelite.api.events.DecorativeObjectSpawned;
import net.runelite.api.events.GameObjectDespawned;
import net.runelite.api.events.GameObjectSpawned;
import net.runelite.api.events.GroundObjectDespawned;
import net.runelite.api.events.GroundObjectSpawned;
import net.runelite.api.events.MenuEntryAdded;
import net.runelite.api.events.WallObjectDespawned;
import net.runelite.api.events.WallObjectSpawned;
import net.runelite.api.events.WorldViewLoaded;
import net.runelite.api.events.WorldViewUnloaded;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ProfileChanged;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.plugins.objectindicators.ColorTileObject;
import net.runelite.client.plugins.objectindicators.ObjectIndicatorsConfig;
import net.runelite.client.plugins.objectindicators.ObjectIndicatorsOverlay;
import net.runelite.client.plugins.objectindicators.ObjectPoint;
import net.runelite.client.ui.components.colorpicker.ColorPickerManager;
import net.runelite.client.ui.components.colorpicker.RuneliteColorPicker;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.util.ColorUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Object Markers", description="Enable marking of objects using the Shift key", tags={"overlay", "objects", "mark", "marker"}, enabledByDefault=false)
public class ObjectIndicatorsPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(ObjectIndicatorsPlugin.class);
    private static final int TOA_PUZZLE_ROOM = 14162;
    private static final String CONFIG_GROUP = "objectindicators";
    private static final String MARK = "Mark object";
    private static final String UNMARK = "Unmark object";
    private final List<ColorTileObject> objects = new ArrayList<ColorTileObject>();
    private final Map<Integer, Set<ObjectPoint>> points = new HashMap<Integer, Set<ObjectPoint>>();
    @Inject
    private Client client;
    @Inject
    private ConfigManager configManager;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private ObjectIndicatorsOverlay overlay;
    @Inject
    private ObjectIndicatorsConfig config;
    @Inject
    private Gson gson;
    @Inject
    private ColorPickerManager colorPickerManager;
    @Inject
    private ClientThread clientThread;

    @Provides
    ObjectIndicatorsConfig provideConfig(ConfigManager configManager) {
        return configManager.getConfig(ObjectIndicatorsConfig.class);
    }

    @Override
    protected void startUp() {
        this.overlayManager.add(this.overlay);
        this.clientThread.invokeLater(() -> this.loadPoints());
    }

    @Override
    protected void shutDown() {
        this.overlayManager.remove(this.overlay);
        this.points.clear();
        this.objects.clear();
    }

    @Subscribe
    public void onProfileChanged(ProfileChanged e) {
        this.clientThread.invokeLater(() -> this.loadPoints());
    }

    @Subscribe
    public void onWallObjectSpawned(WallObjectSpawned event) {
        this.checkObjectPoints((TileObject)event.getWallObject());
    }

    @Subscribe
    public void onWallObjectDespawned(WallObjectDespawned event) {
        this.objects.removeIf(o -> o.getTileObject() == event.getWallObject());
    }

    @Subscribe
    public void onGameObjectSpawned(GameObjectSpawned event) {
        this.checkObjectPoints((TileObject)event.getGameObject());
    }

    @Subscribe
    public void onDecorativeObjectSpawned(DecorativeObjectSpawned event) {
        this.checkObjectPoints((TileObject)event.getDecorativeObject());
    }

    @Subscribe
    public void onGameObjectDespawned(GameObjectDespawned event) {
        this.objects.removeIf(o -> o.getTileObject() == event.getGameObject());
    }

    @Subscribe
    public void onDecorativeObjectDespawned(DecorativeObjectDespawned event) {
        this.objects.removeIf(o -> o.getTileObject() == event.getDecorativeObject());
    }

    @Subscribe
    public void onGroundObjectSpawned(GroundObjectSpawned event) {
        GroundObject groundObject = event.getGroundObject();
        if (WorldPoint.fromLocalInstance((Client)this.client, (LocalPoint)groundObject.getLocalLocation()).getRegionID() == 14162) {
            return;
        }
        this.checkObjectPoints((TileObject)groundObject);
    }

    @Subscribe
    public void onGroundObjectDespawned(GroundObjectDespawned event) {
        this.objects.removeIf(o -> o.getTileObject() == event.getGroundObject());
    }

    private void loadPoints() {
        this.points.clear();
        WorldView wv = this.client.getTopLevelWorldView();
        this.loadPoints(wv);
        for (WorldEntity we : wv.worldEntities()) {
            this.loadPoints(we.getWorldView());
        }
    }

    private void loadPoints(WorldView wv) {
        int[] regions = wv.getMapRegions();
        if (regions == null) {
            return;
        }
        for (int regionId : regions) {
            Set<ObjectPoint> regionPoints = this.loadPoints(regionId);
            if (regionPoints == null) continue;
            this.points.put(regionId, regionPoints);
        }
    }

    @Subscribe
    public void onWorldViewLoaded(WorldViewLoaded event) {
        this.loadPoints(event.getWorldView());
    }

    @Subscribe
    public void onWorldViewUnloaded(WorldViewUnloaded event) {
        WorldView wv = event.getWorldView();
        this.objects.removeIf(c -> c.getTileObject().getWorldView() == wv);
        if (wv.isTopLevel()) {
            Arrays.stream(wv.getMapRegions()).forEach(this.points::remove);
        }
    }

    @Subscribe
    public void onMenuEntryAdded(MenuEntryAdded event) {
        if (event.getType() != MenuAction.EXAMINE_OBJECT.getId() || !this.client.isKeyPressed(81)) {
            return;
        }
        int worldId = event.getMenuEntry().getWorldViewId();
        WorldView wv = this.client.getWorldView(worldId);
        if (wv == null) {
            return;
        }
        TileObject tileObject = this.findTileObject(wv, event.getActionParam0(), event.getActionParam1(), event.getIdentifier());
        if (tileObject == null) {
            return;
        }
        int idx = -1;
        Optional<ColorTileObject> marked = this.objects.stream().filter(o -> o.getTileObject() == tileObject).findFirst();
        this.client.createMenuEntry(idx--).setOption(marked.isPresent() ? UNMARK : MARK).setTarget(event.getTarget()).setWorldViewId(worldId).setParam0(event.getActionParam0()).setParam1(event.getActionParam1()).setIdentifier(event.getIdentifier()).setType(MenuAction.RUNELITE).onClick(this::markObject);
        if (marked.isPresent()) {
            idx = this.createTagBorderColorMenu(idx, event.getTarget(), tileObject, marked.get());
            idx = this.createTagFillColorMenu(idx, event.getTarget(), tileObject, marked.get());
            idx = this.createTagStyleMenu(idx, event.getTarget(), tileObject);
        }
    }

    private int createTagBorderColorMenu(int idx, String target, TileObject object, ColorTileObject colorTileObject) {
        List<Color> colors = this.getUsedColors(ObjectPoint::getBorderColor);
        for (Color default_ : new Color[]{Color.RED, Color.GREEN, Color.BLUE, Color.YELLOW, Color.MAGENTA}) {
            if (colors.size() >= 5 || colors.contains(default_)) continue;
            colors.add(default_);
        }
        MenuEntry parent = this.client.createMenuEntry(idx--).setOption("Mark border color").setTarget(target).setType(MenuAction.RUNELITE);
        Menu submenu = parent.createSubMenu();
        for (Color c : colors) {
            submenu.createMenuEntry(0).setOption(ColorUtil.prependColorTag("Set color", c)).setType(MenuAction.RUNELITE).onClick(e -> this.updateObjectConfig(object, p -> p.setBorderColor(c)));
        }
        submenu.createMenuEntry(0).setOption("Pick color").setType(MenuAction.RUNELITE).onClick(e -> SwingUtilities.invokeLater(() -> {
            RuneliteColorPicker colorPicker = this.colorPickerManager.create(this.client, (Color)MoreObjects.firstNonNull((Object)colorTileObject.getBorderColor(), (Object)this.config.markerColor()), "Mark Border Color", false);
            colorPicker.setOnClose(c -> this.clientThread.invokeLater(() -> this.updateObjectConfig(object, p -> p.setBorderColor((Color)c))));
            colorPicker.setVisible(true);
        }));
        return idx;
    }

    private int createTagFillColorMenu(int idx, String target, TileObject object, ColorTileObject colorTileObject) {
        List<Color> colors = this.getUsedColors(ObjectPoint::getFillColor);
        for (Color default_ : new Color[]{Color.RED, Color.GREEN, Color.BLUE, Color.YELLOW, Color.MAGENTA}) {
            default_ = ColorUtil.colorWithAlpha(default_, default_.getAlpha() / 12);
            if (colors.size() >= 5 || colors.contains(default_)) continue;
            colors.add(default_);
        }
        MenuEntry parent = this.client.createMenuEntry(idx--).setOption("Mark fill color").setTarget(target).setType(MenuAction.RUNELITE);
        Menu submenu = parent.createSubMenu();
        for (Color c : colors) {
            submenu.createMenuEntry(0).setOption(ColorUtil.prependColorTag("Set color", c)).setType(MenuAction.RUNELITE).onClick(e -> this.updateObjectConfig(object, p -> p.setFillColor(c)));
        }
        submenu.createMenuEntry(0).setOption("Pick color").setType(MenuAction.RUNELITE).onClick(e -> SwingUtilities.invokeLater(() -> {
            Color previousColor = (Color)MoreObjects.firstNonNull((Object)colorTileObject.getFillColor(), (Object)new Color(0, 0, 0, 50));
            RuneliteColorPicker colorPicker = this.colorPickerManager.create(this.client, previousColor, "Mark Fill Color", false);
            colorPicker.setOnClose(c -> this.clientThread.invokeLater(() -> this.updateObjectConfig(object, p -> p.setFillColor((Color)c))));
            colorPicker.setVisible(true);
        }));
        submenu.createMenuEntry(0).setOption("Reset").setType(MenuAction.RUNELITE).onClick(e -> this.updateObjectConfig(object, p -> p.setFillColor(null)));
        return idx;
    }

    private int createTagStyleMenu(int idx, String target, TileObject object) {
        MenuEntry parent = this.client.createMenuEntry(idx--).setOption("Mark style").setTarget(target).setType(MenuAction.RUNELITE);
        Menu submenu = parent.createSubMenu();
        submenu.createMenuEntry(0).setOption("Hull").setType(MenuAction.RUNELITE).onClick(e -> this.updateObjectConfig(object, c -> c.setHull(c.getHull() != Boolean.TRUE)));
        submenu.createMenuEntry(0).setOption("Outline").setType(MenuAction.RUNELITE).onClick(e -> this.updateObjectConfig(object, c -> c.setOutline(c.getOutline() != Boolean.TRUE)));
        submenu.createMenuEntry(0).setOption("Clickbox").setType(MenuAction.RUNELITE).onClick(e -> this.updateObjectConfig(object, c -> c.setClickbox(c.getClickbox() != Boolean.TRUE)));
        submenu.createMenuEntry(0).setOption("Tile").setType(MenuAction.RUNELITE).onClick(e -> this.updateObjectConfig(object, c -> c.setTile(c.getTile() != Boolean.TRUE)));
        submenu.createMenuEntry(0).setOption("Reset").setType(MenuAction.RUNELITE).onClick(e -> this.updateObjectConfig(object, c -> {
            c.setHull(null);
            c.setOutline(null);
            c.setClickbox(null);
            c.setTile(null);
        }));
        return idx;
    }

    private void markObject(MenuEntry entry) {
        WorldView wv = this.client.getWorldView(entry.getWorldViewId());
        if (wv == null) {
            return;
        }
        TileObject object = this.findTileObject(wv, entry.getParam0(), entry.getParam1(), entry.getIdentifier());
        if (object == null) {
            return;
        }
        ObjectComposition objectDefinition = this.getObjectComposition(object.getId());
        String name = objectDefinition.getName();
        if (Strings.isNullOrEmpty((String)name) || name.equals("null")) {
            return;
        }
        WorldPoint worldPoint = WorldPoint.fromLocalInstance((Client)this.client, (LocalPoint)object.getLocalLocation());
        int regionId = worldPoint.getRegionID();
        Color borderColor = this.config.markerColor();
        Color fillColor = this.config.fillColor();
        ObjectPoint point = new ObjectPoint(object.getId(), name, regionId, worldPoint.getRegionX(), worldPoint.getRegionY(), worldPoint.getPlane(), borderColor, fillColor, null, null, null, null);
        Set objectPoints = this.points.computeIfAbsent(regionId, k -> new HashSet());
        if (objectPoints.removeIf(ObjectIndicatorsPlugin.findObjectPredicate(objectDefinition, object, worldPoint))) {
            this.unmarkObjects(this.client.getTopLevelWorldView(), worldPoint, objectDefinition);
            log.debug("Unmarking object: {}", (Object)point);
        } else {
            objectPoints.add(point);
            this.markObjects(this.client.getTopLevelWorldView(), worldPoint, objectDefinition);
            log.debug("Marking object: {}", (Object)point);
        }
        this.savePoints(regionId, objectPoints);
    }

    private void updateObjectConfig(TileObject object, Consumer<ObjectPoint> c) {
        WorldPoint worldPoint = WorldPoint.fromLocalInstance((Client)this.client, (LocalPoint)object.getLocalLocation());
        int regionId = worldPoint.getRegionID();
        Set<ObjectPoint> objectPoints = this.points.get(regionId);
        if (objectPoints.isEmpty()) {
            return;
        }
        ObjectComposition objectComposition = this.getObjectComposition(object.getId());
        ObjectPoint objectPoint = objectPoints.stream().filter(ObjectIndicatorsPlugin.findObjectPredicate(objectComposition, object, worldPoint)).findFirst().orElse(null);
        if (objectPoint == null) {
            return;
        }
        c.accept(objectPoint);
        this.savePoints(regionId, objectPoints);
        for (ColorTileObject o : new ArrayList<ColorTileObject>(this.objects)) {
            if (o.getTileObject().getId() != object.getId()) continue;
            this.objects.remove(o);
            this.checkObjectPoints(o.getTileObject());
        }
    }

    private void checkObjectPoints(TileObject object) {
        String name;
        if (object.getPlane() < 0) {
            return;
        }
        WorldPoint worldPoint = WorldPoint.fromLocalInstance((Client)this.client, (LocalPoint)object.getLocalLocation(), (int)object.getPlane());
        Set<ObjectPoint> objectPoints = this.points.get(worldPoint.getRegionID());
        if (objectPoints == null) {
            return;
        }
        ObjectComposition objectComposition = this.client.getObjectDefinition(object.getId());
        if (objectComposition.getImpostorIds() == null && (Strings.isNullOrEmpty((String)(name = objectComposition.getName())) || name.equals("null"))) {
            return;
        }
        for (ObjectPoint objectPoint : objectPoints) {
            if (worldPoint.getRegionX() != objectPoint.getRegionX() || worldPoint.getRegionY() != objectPoint.getRegionY() || worldPoint.getPlane() != objectPoint.getZ() || objectPoint.getId() != object.getId()) continue;
            log.debug("Marking object {} due to matching {}", (Object)object, (Object)objectPoint);
            int flags = (objectPoint.getHull() == Boolean.TRUE ? 1 : 0) | (objectPoint.getOutline() == Boolean.TRUE ? 2 : 0) | (objectPoint.getClickbox() == Boolean.TRUE ? 4 : 0) | (objectPoint.getTile() == Boolean.TRUE ? 8 : 0);
            this.objects.add(new ColorTileObject(object, objectComposition, objectPoint.getName(), objectPoint.getBorderColor(), objectPoint.getFillColor(), (byte)flags));
            break;
        }
    }

    private TileObject findTileObject(WorldView wv, int x, int y, int id) {
        int level = wv.getPlane();
        Scene scene = wv.getScene();
        Tile[][][] tiles = scene.getTiles();
        Tile tile = tiles[level][x][y];
        if (tile == null) {
            return null;
        }
        GameObject[] tileGameObjects = tile.getGameObjects();
        DecorativeObject tileDecorativeObject = tile.getDecorativeObject();
        WallObject tileWallObject = tile.getWallObject();
        GroundObject groundObject = tile.getGroundObject();
        if (this.objectIdEquals((TileObject)tileWallObject, id)) {
            return tileWallObject;
        }
        if (this.objectIdEquals((TileObject)tileDecorativeObject, id)) {
            return tileDecorativeObject;
        }
        if (this.objectIdEquals((TileObject)groundObject, id)) {
            return groundObject;
        }
        for (GameObject object : tileGameObjects) {
            if (!this.objectIdEquals((TileObject)object, id)) continue;
            return object;
        }
        return null;
    }

    private boolean objectIdEquals(TileObject tileObject, int id) {
        if (tileObject == null) {
            return false;
        }
        if (tileObject.getId() == id) {
            return true;
        }
        ObjectComposition comp = this.client.getObjectDefinition(tileObject.getId());
        if (comp.getImpostorIds() != null) {
            for (int impostorId : comp.getImpostorIds()) {
                if (impostorId != id) continue;
                return true;
            }
        }
        return false;
    }

    private void markObjects(WorldView wv, WorldPoint p, ObjectComposition objectConfig) {
        for (WorldPoint sp : WorldPoint.toLocalInstance((WorldView)wv, (WorldPoint)p)) {
            int y;
            int x = sp.getX() - wv.getBaseX();
            TileObject object = this.findTileObject(wv, x, y = sp.getY() - wv.getBaseY(), objectConfig.getId());
            if (object == null) continue;
            this.objects.add(new ColorTileObject(object, this.client.getObjectDefinition(object.getId()), objectConfig.getName(), this.config.markerColor(), this.config.fillColor(), 0));
        }
        for (WorldView sub : wv.worldViews()) {
            this.markObjects(sub, p, objectConfig);
        }
    }

    private void unmarkObjects(WorldView wv, WorldPoint p, ObjectComposition objectConfig) {
        for (WorldPoint sp : WorldPoint.toLocalInstance((WorldView)wv, (WorldPoint)p)) {
            int y;
            int x = sp.getX() - wv.getBaseX();
            TileObject object = this.findTileObject(wv, x, y = sp.getY() - wv.getBaseY(), objectConfig.getId());
            if (object == null || this.objects.removeIf(o -> o.getTileObject() == object)) continue;
            log.warn("unable to find object point for unmarked object {}", (Object)object.getId());
        }
        for (WorldView sub : wv.worldViews()) {
            this.unmarkObjects(sub, p, objectConfig);
        }
    }

    private static Predicate<ObjectPoint> findObjectPredicate(ObjectComposition objectComposition, TileObject object, WorldPoint worldPoint) {
        return op -> (op.getId() == -1 || op.getId() == object.getId() || op.getName().equals(objectComposition.getName())) && op.getRegionX() == worldPoint.getRegionX() && op.getRegionY() == worldPoint.getRegionY() && op.getZ() == worldPoint.getPlane();
    }

    private void savePoints(int id, Set<ObjectPoint> points) {
        if (points.isEmpty()) {
            this.configManager.unsetConfiguration(CONFIG_GROUP, "region_" + id);
        } else {
            String json = this.gson.toJson(points);
            this.configManager.setConfiguration(CONFIG_GROUP, "region_" + id, json);
        }
    }

    private Set<ObjectPoint> loadPoints(int id) {
        String json = this.configManager.getConfiguration(CONFIG_GROUP, "region_" + id);
        if (Strings.isNullOrEmpty((String)json)) {
            return null;
        }
        Set points = (Set)this.gson.fromJson(json, new TypeToken<Set<ObjectPoint>>(){}.getType());
        return points.stream().filter(point -> !point.getName().equals("null")).collect(Collectors.toSet());
    }

    @Nullable
    private ObjectComposition getObjectComposition(int id) {
        ObjectComposition objectComposition = this.client.getObjectDefinition(id);
        return objectComposition.getImpostorIds() == null ? objectComposition : objectComposition.getImpostor();
    }

    private List<Color> getUsedColors(Function<ObjectPoint, Color> getColor) {
        ArrayList<Color> colors = new ArrayList<Color>();
        for (int region : this.client.getMapRegions()) {
            Set<ObjectPoint> points = this.points.get(region);
            if (points == null) continue;
            for (ObjectPoint p : points) {
                Color c = getColor.apply(p);
                if (!(c != null & !colors.contains(c))) continue;
                colors.add(c);
                if (colors.size() < 5) continue;
                return colors;
            }
        }
        return colors;
    }

    List<ColorTileObject> getObjects() {
        return this.objects;
    }
}

