/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.gpu;

import java.util.Arrays;
import net.runelite.api.Projection;
import net.runelite.api.Scene;
import net.runelite.client.plugins.gpu.GpuPlugin;
import net.runelite.client.plugins.gpu.VBO;
import org.lwjgl.opengl.GL33C;

class VAO {
    static final int VERT_SIZE = 24;
    final VBO vbo;
    int vao;
    int[] lengths = new int[4];
    Projection[] projs = new Projection[4];
    Scene[] scenes = new Scene[4];
    int off = 0;

    VAO(int size) {
        this.vbo = new VBO(size);
    }

    void init() {
        this.vao = GL33C.glGenVertexArrays();
        GL33C.glBindVertexArray((int)this.vao);
        this.vbo.init(35048);
        GL33C.glBindBuffer((int)34962, (int)this.vbo.bufId);
        GL33C.glEnableVertexAttribArray((int)0);
        GL33C.glVertexAttribPointer((int)0, (int)3, (int)5126, (boolean)false, (int)24, (long)0L);
        GL33C.glEnableVertexAttribArray((int)1);
        GL33C.glVertexAttribIPointer((int)1, (int)1, (int)5124, (int)24, (long)12L);
        GL33C.glEnableVertexAttribArray((int)2);
        GL33C.glVertexAttribIPointer((int)2, (int)4, (int)5122, (int)24, (long)16L);
        GL33C.glBindBuffer((int)34962, (int)0);
        GL33C.glBindVertexArray((int)0);
    }

    void destroy() {
        this.vbo.destroy();
        GL33C.glDeleteVertexArrays((int)this.vao);
        this.vao = 0;
    }

    void addRange(Projection projection, Scene scene) {
        assert (this.vbo.mapped);
        if (this.off > 0 && this.lengths[this.off - 1] == this.vbo.vb.position()) {
            return;
        }
        if (this.lengths.length == this.off) {
            int l = this.lengths.length << 1;
            this.lengths = Arrays.copyOf(this.lengths, l);
            this.projs = Arrays.copyOf(this.projs, l);
            this.scenes = Arrays.copyOf(this.scenes, l);
        }
        this.lengths[this.off] = this.vbo.vb.position();
        this.projs[this.off] = projection;
        this.scenes[this.off] = scene;
        ++this.off;
    }

    void draw() {
        assert (!this.vbo.mapped);
        int start = 0;
        for (int i = 0; i < this.off; ++i) {
            int end = this.lengths[i];
            Projection p = this.projs[i];
            Scene scene = this.scenes[i];
            int count = end - start;
            GpuPlugin.updateEntityProjection(p);
            GL33C.glUniform4i((int)GpuPlugin.uniEntityTint, (int)scene.getOverrideHue(), (int)scene.getOverrideSaturation(), (int)scene.getOverrideLuminance(), (int)scene.getOverrideAmount());
            GL33C.glBindVertexArray((int)this.vao);
            GL33C.glDrawArrays((int)4, (int)(start / 6), (int)(count / 6));
            start = end;
        }
    }

    void reset() {
        Arrays.fill(this.projs, 0, this.off, null);
        Arrays.fill(this.scenes, 0, this.off, null);
        this.off = 0;
    }
}

