/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.cluescrolls.clues;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import java.awt.Color;
import java.awt.Graphics2D;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.runelite.api.Client;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.client.plugins.cluescrolls.ClueScrollPlugin;
import net.runelite.client.plugins.cluescrolls.clues.ClueScroll;
import net.runelite.client.plugins.cluescrolls.clues.Enemy;
import net.runelite.client.plugins.cluescrolls.clues.LocationClueScroll;
import net.runelite.client.ui.overlay.OverlayUtil;
import net.runelite.client.ui.overlay.components.LineComponent;
import net.runelite.client.ui.overlay.components.PanelComponent;
import net.runelite.client.ui.overlay.components.TitleComponent;

public class CoordinateClue
extends ClueScroll
implements LocationClueScroll {
    private static final int DEFAULT_RESOURCE_AREA_COST = 7500;
    static final ImmutableMap<WorldPoint, CoordinateClue> CLUES = List.of(CoordinateClue.builder().itemId(2809).location(new WorldPoint(2479, 3158, 0)).directions("South of fruit tree patch, west of Tree Gnome Village.").build(), CoordinateClue.builder().itemId(3588).location(new WorldPoint(2887, 3154, 0)).directions("West of Banana plantation on Karamja.").build(), CoordinateClue.builder().itemId(3590).location(new WorldPoint(2743, 3151, 0)).directions("Entrance of Brimhaven dungeon.").build(), CoordinateClue.builder().itemId(7313).location(new WorldPoint(3184, 3150, 0)).directions("South of Lumbridge Swamp.").build(), CoordinateClue.builder().itemId(2823).location(new WorldPoint(3217, 3177, 0)).directions("East of Lumbridge Swamp.").build(), CoordinateClue.builder().itemId(2819).location(new WorldPoint(3007, 3144, 0)).directions("Near the entrance to the Asgarnian Ice Dungeon, south of Port Sarim (AIQ).").build(), CoordinateClue.builder().itemId(7309).location(new WorldPoint(2896, 3119, 0)).directions("Near Karambwan fishing spot (DKP).").build(), CoordinateClue.builder().itemId(2805).location(new WorldPoint(2697, 3207, 0)).directions("Centre of Moss Giant Island, west of Brimhaven.").build(), CoordinateClue.builder().itemId(2803).location(new WorldPoint(2679, 3110, 0)).directions("North of Hazelmere's house (CLS).").build(), CoordinateClue.builder().itemId(12035).location(new WorldPoint(3510, 3074, 0)).directions("East of Uzer (DLQ).").build(), CoordinateClue.builder().itemId(2801).location(new WorldPoint(3160, 3251, 0)).directions("West of trapdoor leading to H.A.M Hideout.").build(), CoordinateClue.builder().itemId(2813).location(new WorldPoint(2643, 3252, 0)).directions("South of Ardougne Zoo, North of Tower of Life (DJP).").build(), CoordinateClue.builder().itemId(12041).location(new WorldPoint(2322, 3061, 0)).directions("South-west of Castle wars (BKP).").build(), CoordinateClue.builder().itemId(7317).location(new WorldPoint(2875, 3046, 0)).directions("North of nature altar, north of Shilo Village (CKR).").build(), CoordinateClue.builder().itemId(2817).location(new WorldPoint(2849, 3033, 0)).directions("West of nature altar, north of Shilo Village (CKR).").build(), CoordinateClue.builder().itemId(2815).location(new WorldPoint(2848, 3296, 0)).directions("North of Crandor island.").build(), CoordinateClue.builder().itemId(7307).location(new WorldPoint(2583, 2990, 0)).directions("Feldip Hills, south-east of Gu'Tanoth (AKS).").build(), CoordinateClue.builder().itemId(2825).location(new WorldPoint(3179, 3344, 0)).directions("In the cow pen north of the Lumbridge windmill.").build(), CoordinateClue.builder().itemId(2807).location(new WorldPoint(2383, 3370, 0)).directions("West of the outpost").build(), CoordinateClue.builder().itemId(12051).location(new WorldPoint(3312, 3375, 0)).directions("North-west of Exam Centre, on the hill.").build(), CoordinateClue.builder().itemId(12043).location(new WorldPoint(3121, 3384, 0)).directions("North-east of Draynor Manor, near River Lum.").build(), CoordinateClue.builder().itemId(3584).location(new WorldPoint(3430, 3388, 0)).directions("West of Mort Myre Swamp (BKR).").build(), CoordinateClue.builder().itemId(2821).location(new WorldPoint(2920, 3403, 0)).directions("South-east of Taverley, near Lady of the Lake.").build(), CoordinateClue.builder().itemId(12033).location(new WorldPoint(2594, 2899, 0)).directions("South-east of Feldip Hills, by the crimson swifts (AKS).").build(), CoordinateClue.builder().itemId(3592).location(new WorldPoint(2387, 3435, 0)).directions("West of Tree Gnome Stronghold, near the pen containing terrorbirds.").build(), CoordinateClue.builder().itemId(2811).location(new WorldPoint(2512, 3467, 0)).directions("Baxtorian Falls (Bring rope).").build(), CoordinateClue.builder().itemId(12045).location(new WorldPoint(2381, 3468, 0)).directions("West of Tree Gnome Stronghold, north of the pen with terrorbirds.").build(), CoordinateClue.builder().itemId(7311).location(new WorldPoint(3005, 3475, 0)).directions("Ice Mountain, west of Edgeville Monastery.").build(), CoordinateClue.builder().itemId(12049).location(new WorldPoint(2585, 3505, 0)).directions("By the shore line north of the Coal Trucks.").build(), CoordinateClue.builder().itemId(3582).location(new WorldPoint(3443, 3515, 0)).directions("South of Slayer Tower (CKS).").build(), CoordinateClue.builder().itemId(3594).location(new WorldPoint(2416, 3516, 0)).directions("Tree Gnome Stronghold, west of Grand Tree, near swamp.").build(), CoordinateClue.builder().itemId(12053).location(new WorldPoint(3429, 3523, 0)).directions("South of Slayer Tower (CKS).").build(), CoordinateClue.builder().itemId(12047).location(new WorldPoint(2363, 3531, 0)).directions("North-east of Eagles' Peak (AKQ).").build(), CoordinateClue.builder().itemId(3586).location(new WorldPoint(2919, 3535, 0)).directions("East of Burthorpe pub.").build(), CoordinateClue.builder().itemId(12037).location(new WorldPoint(3548, 3560, 0)).directions("Inside Fenkenstrain's Castle.").build(), CoordinateClue.builder().itemId(19774).location(new WorldPoint(1476, 3566, 0)).directions("Graveyard of Heroes in west Shayzien.").build(), CoordinateClue.builder().itemId(7315).location(new WorldPoint(2735, 3638, 0)).directions("East of Rellekka, north-west of Golden Apple Tree (AJR).").build(), CoordinateClue.builder().itemId(12039).location(new WorldPoint(2681, 3653, 0)).directions("Rellekka, in the garden of the south-east house.").build(), CoordinateClue.builder().itemId(7305).location(new WorldPoint(2537, 3881, 0)).directions("Miscellania (CIP).").build(), CoordinateClue.builder().itemId(23136).location(new WorldPoint(2828, 3234, 0)).directions("Southern coast of Crandor.").build(), CoordinateClue.builder().itemId(23135).location(new WorldPoint(1247, 3726, 0)).directions("Just inside the Farming Guild").build(), CoordinateClue.builder().itemId(23137).location(new WorldPoint(3764, 3900, 0)).directions("On the small island north-east of Fossil Island's mushroom forest.").build(), CoordinateClue.builder().itemId(28909).location(new WorldPoint(1659, 3111, 0)).directions("Dig west of the Bazaar in Civitas illa Fortis.").build(), CoordinateClue.builder().itemId(31275).location(new WorldPoint(3183, 2453, 0)).directions("Center of the Great Conch.").build(), CoordinateClue.builder().itemId(3560).location(new WorldPoint(2209, 3161, 0)).directions("North-east of Tyras Camp (BJS if 76 Agility).").enemy(Enemy.SARADOMIN_WIZARD).build(), CoordinateClue.builder().itemId(3562).location(new WorldPoint(2181, 3206, 0)).directions("South of Iorwerth Camp.").enemy(Enemy.SARADOMIN_WIZARD).build(), CoordinateClue.builder().itemId(12554).location(new WorldPoint(3081, 3209, 0)).directions("Small Island (CLP).").enemy(Enemy.SARADOMIN_WIZARD).build(), CoordinateClue.builder().itemId(3554).location(new WorldPoint(3399, 3246, 0)).directions("Behind Emir's Arena.").build(), CoordinateClue.builder().itemId(12558).location(new WorldPoint(2699, 3251, 0)).directions("Little island (AIR).").enemy(Enemy.SARADOMIN_WIZARD).build(), CoordinateClue.builder().itemId(19844).location(new WorldPoint(3546, 3251, 0)).directions("North-east of Burgh de Rott.").enemy(Enemy.SARADOMIN_WIZARD).build(), CoordinateClue.builder().itemId(12562).location(new WorldPoint(3544, 3256, 0)).directions("North-east of Burgh de Rott.").enemy(Enemy.SARADOMIN_WIZARD).build(), CoordinateClue.builder().itemId(12560).location(new WorldPoint(2841, 3267, 0)).directions("Crandor island.").enemy(Enemy.SARADOMIN_WIZARD).build(), CoordinateClue.builder().itemId(3552).location(new WorldPoint(3168, 3041, 0)).directions("Bedabin Camp.").enemy(Enemy.SARADOMIN_WIZARD).build(), CoordinateClue.builder().itemId(3546).location(new WorldPoint(2542, 3031, 0)).directions("Gu'Tanoth, may require 20gp.").enemy(Enemy.SARADOMIN_WIZARD).build(), CoordinateClue.builder().itemId(3548).location(new WorldPoint(2581, 3030, 0)).directions("Gu'Tanoth island, enter cave north-west of Feldip Hills (AKS).").enemy(Enemy.SARADOMIN_WIZARD).build(), CoordinateClue.builder().itemId(3538).location(new WorldPoint(2961, 3024, 0)).directions("Ship yard (DKP).").enemy(Enemy.SARADOMIN_WIZARD).build(), CoordinateClue.builder().itemId(7256).location(new WorldPoint(2339, 3311, 0)).directions("East of Prifddinas on Arandar mountain pass.").enemy(Enemy.SARADOMIN_WIZARD).build(), CoordinateClue.builder().itemId(3542).location(new WorldPoint(3440, 3341, 0)).directions("Nature Spirit's grotto (BIP).").enemy(Enemy.SARADOMIN_WIZARD).build(), CoordinateClue.builder().itemId(3530).location(new WorldPoint(2763, 2974, 0)).directions("Cairn Isle, west of Shilo Village (CKR).").enemy(Enemy.SARADOMIN_WIZARD).build(), CoordinateClue.builder().itemId(7258).location(new WorldPoint(3138, 2969, 0)).directions("West of Bandit Camp in Kharidian Desert.").enemy(Enemy.SARADOMIN_WIZARD).build(), CoordinateClue.builder().itemId(3540).location(new WorldPoint(2924, 2963, 0)).directions("On the southern part of eastern Karamja, west of the gnome glider.").enemy(Enemy.SARADOMIN_WIZARD).build(), CoordinateClue.builder().itemId(3534).location(new WorldPoint(2838, 2914, 0)).directions("Kharazi Jungle, near water pool (CKR).").enemy(Enemy.SARADOMIN_WIZARD).build(), CoordinateClue.builder().itemId(3544).location(new WorldPoint(3441, 3419, 0)).directions("Mort Myre Swamp (BKR).").enemy(Enemy.SARADOMIN_WIZARD).build(), CoordinateClue.builder().itemId(3536).location(new WorldPoint(2950, 2902, 0)).directions("South-east of Kharazi Jungle.").enemy(Enemy.SARADOMIN_WIZARD).build(), CoordinateClue.builder().itemId(3532).location(new WorldPoint(2775, 2891, 0)).directions("South-west of Kharazi Jungle.").enemy(Enemy.SARADOMIN_WIZARD).build(), CoordinateClue.builder().itemId(7262).location(new WorldPoint(3113, 3602, 0)).directions("Wilderness. South-west of Ferox Enclave (level 11).").enemy(Enemy.ZAMORAK_WIZARD).build(), CoordinateClue.builder().itemId(3526).location(new WorldPoint(2892, 3675, 0)).directions("On the summit of Trollheim.").enemy(Enemy.SARADOMIN_WIZARD).build(), CoordinateClue.builder().itemId(2743).location(new WorldPoint(3168, 3677, 0)).directions("Wilderness. Graveyard of Shadows.").enemy(Enemy.ZAMORAK_WIZARD).build(), CoordinateClue.builder().itemId(3528).location(new WorldPoint(2853, 3690, 0)).directions("Entrance to the troll Stronghold.").enemy(Enemy.SARADOMIN_WIZARD).build(), CoordinateClue.builder().itemId(7264).location(new WorldPoint(3305, 3692, 0)).directions("Wilderness. West of eastern green dragons.").enemy(Enemy.ZAMORAK_WIZARD).build(), CoordinateClue.builder().itemId(2745).location(new WorldPoint(3055, 3696, 0)).directions("Wilderness. Bandit Camp.").enemy(Enemy.ZAMORAK_WIZARD).build(), CoordinateClue.builder().itemId(12564).location(new WorldPoint(3302, 3696, 0)).directions("Wilderness. West of eastern green dragons.").enemy(Enemy.ZAMORAK_WIZARD).build(), CoordinateClue.builder().itemId(19840).location(new WorldPoint(1479, 3699, 0)).directions("Lizardman Canyon (DJR).").enemy(Enemy.SARADOMIN_WIZARD).build(), CoordinateClue.builder().itemId(7266).location(new WorldPoint(2712, 3732, 0)).directions("North-east of Rellekka (DKS).").enemy(Enemy.SARADOMIN_WIZARD).build(), CoordinateClue.builder().itemId(7260).location(new WorldPoint(2970, 3749, 0)).directions("Wilderness. Forgotten Cemetery.").enemy(Enemy.ZAMORAK_WIZARD).build(), CoordinateClue.builder().itemId(3556).location(new WorldPoint(3094, 3764, 0)).directions("Wilderness. Mining site north of Bandit Camp.").enemy(Enemy.ZAMORAK_WIZARD).build(), CoordinateClue.builder().itemId(2747).location(new WorldPoint(3311, 3769, 0)).directions("Wilderness. South of the Silk Chasm (Venenatis).").enemy(Enemy.ZAMORAK_WIZARD).build(), CoordinateClue.builder().itemId(19842).location(new WorldPoint(1460, 3782, 0)).directions("Lovakengj, near burning man.").enemy(Enemy.SARADOMIN_WIZARD).build(), CoordinateClue.builder().itemId(2741).location(new WorldPoint(3244, 3792, 0)).directions("Wilderness. South-east of Lava Dragon Isle by some Chaos Dwarves.").enemy(Enemy.ZAMORAK_WIZARD).build(), CoordinateClue.builder().itemId(2733).location(new WorldPoint(3140, 3804, 0)).directions("Wilderness. North of black chinchompa hunter area.").enemy(Enemy.ZAMORAK_WIZARD).build(), CoordinateClue.builder().itemId(2735).location(new WorldPoint(2946, 3819, 0)).directions("Wilderness. Chaos Temple (level 38).").enemy(Enemy.ZAMORAK_WIZARD).build(), CoordinateClue.builder().itemId(21526).location(new WorldPoint(3771, 3825, 0)).directions("Fossil Island. East of Museum Camp.").enemy(Enemy.SARADOMIN_WIZARD).build(), CoordinateClue.builder().itemId(2737).location(new WorldPoint(3013, 3846, 0)).directions("Wilderness. West of Lava Maze, before KBD's lair.").enemy(Enemy.ZAMORAK_WIZARD).build(), CoordinateClue.builder().itemId(2723).location(new WorldPoint(3058, 3884, 0)).directions("Wilderness. Near runite ore north of Lava Maze.").enemy(Enemy.ZAMORAK_WIZARD).build(), CoordinateClue.builder().itemId(2731).location(new WorldPoint(3290, 3889, 0)).directions("Wilderness. Demonic Ruins.").enemy(Enemy.ZAMORAK_WIZARD).build(), CoordinateClue.builder().itemId(21527).location(new WorldPoint(3765, 3899, 0)).directions("Small Island north of Fossil Island.").enemy(Enemy.SARADOMIN_WIZARD).build(), CoordinateClue.builder().itemId(12556).location(new WorldPoint(2505, 3899, 0)).directions("Small Island north-west of Miscellania (AJS).").enemy(Enemy.SARADOMIN_WIZARD).build(), CoordinateClue.builder().itemId(3558).location(new WorldPoint(3285, 3942, 0)).directions("Wilderness. Rogues' Castle.").enemy(Enemy.ZAMORAK_WIZARD).build(), CoordinateClue.builder().itemId(2727).location(new WorldPoint(3159, 3959, 0)).directions("Wilderness. North of Deserted Keep, west of Resource Area.").enemy(Enemy.ZAMORAK_WIZARD).build(), CoordinateClue.builder().itemId(2739).location(new WorldPoint(3039, 3960, 0)).directions("Wilderness. Pirates' Hideout.").enemy(Enemy.ZAMORAK_WIZARD).build(), CoordinateClue.builder().itemId(2725).location(new WorldPoint(2987, 3963, 0)).directions("Wilderness. West of Wilderness Agility Course.").enemy(Enemy.ZAMORAK_WIZARD).build(), CoordinateClue.builder().itemId(2729).location(new WorldPoint(3189, 3963, 0)).directions("Wilderness. North of Resource Area, near magic axe hut.").enemy(Enemy.ZAMORAK_WIZARD).build(), CoordinateClue.builder().itemId(23167).location(new WorldPoint(2341, 3697, 0)).directions("North-east of the Piscatoris Fishing Colony bank.").enemy(Enemy.SARADOMIN_WIZARD).build(), CoordinateClue.builder().itemId(23168).location(new WorldPoint(3143, 3774, 0)).directions("In level 32 Wilderness, by the black chinchompa hunting area.").enemy(Enemy.ZAMORAK_WIZARD).build(), CoordinateClue.builder().itemId(23169).location(new WorldPoint(2970, 3913, 0)).directions("Frozen Waste Plateau, south-west of Wilderness Agility Course.").enemy(Enemy.ZAMORAK_WIZARD).build(), CoordinateClue.builder().location(new WorldPoint(1410, 3611, 0)).directions("Lake Molch dock west of Shayzien Encampment.").enemy(Enemy.SARADOMIN_WIZARD).build(), CoordinateClue.builder().itemId(25790).location(new WorldPoint(1409, 3483, 0)).directions("South of Shayziens' Wall.").enemy(Enemy.SARADOMIN_WIZARD).build(), CoordinateClue.builder().itemId(31273).location(new WorldPoint(1193, 2774, 0)).directions("On Laguna Aurorae.").enemy(Enemy.SARADOMIN_WIZARD).build(), CoordinateClue.builder().itemId(12089).location(new WorldPoint(2357, 3151, 0)).directions("Lletya.").enemy(Enemy.ARMADYLEAN_OR_BANDOSIAN_GUARD).build(), CoordinateClue.builder().itemId(12091).location(new WorldPoint(3587, 3180, 0)).directions("Meiyerditch.").enemy(Enemy.ARMADYLEAN_OR_BANDOSIAN_GUARD).build(), CoordinateClue.builder().itemId(12110).location(new WorldPoint(2820, 3078, 0)).directionsProvider(plugin -> "Tai Bwo Wannai hardwood grove." + CoordinateClue.getHardwoodGroveCost(plugin)).enemy(Enemy.ARMADYLEAN_OR_BANDOSIAN_GUARD).build(), CoordinateClue.builder().itemId(12086).location(new WorldPoint(3811, 3060, 0)).directions("Small island north-east of Mos Le'Harmless.").enemy(Enemy.ARMADYLEAN_OR_BANDOSIAN_GUARD).lightSourceVarbitId(6534).build(), CoordinateClue.builder().itemId(12111).location(new WorldPoint(2180, 3282, 0)).directions("North of Iorwerth Camp.").enemy(Enemy.ARMADYLEAN_OR_BANDOSIAN_GUARD).build(), CoordinateClue.builder().itemId(12107).location(new WorldPoint(2870, 2997, 0)).directions("North-east corner in Shilo Village.").enemy(Enemy.ARMADYLEAN_OR_BANDOSIAN_GUARD).build(), CoordinateClue.builder().itemId(12100).location(new WorldPoint(3302, 2988, 0)).directions("On top of a cliff to the west of Pollnivneach.").enemy(Enemy.ARMADYLEAN_OR_BANDOSIAN_GUARD).build(), CoordinateClue.builder().itemId(12098).location(new WorldPoint(2511, 2980, 0)).directions("Just south of Gu'Tanoth, west of gnome glider (AKS).").enemy(Enemy.ARMADYLEAN_OR_BANDOSIAN_GUARD).build(), CoordinateClue.builder().itemId(12102).location(new WorldPoint(2732, 3372, 0)).directions("Legends' Guild.").enemy(Enemy.ARMADYLEAN_OR_BANDOSIAN_GUARD).build(), CoordinateClue.builder().itemId(12103).location(new WorldPoint(3573, 3425, 0)).directions("North of Dessous's tomb from Desert Treasure.").enemy(Enemy.ARMADYLEAN_OR_BANDOSIAN_GUARD).build(), CoordinateClue.builder().itemId(12088).location(new WorldPoint(3828, 2848, 0)).directions("East of Harmony Island.").enemy(Enemy.ARMADYLEAN_OR_BANDOSIAN_GUARD).build(), CoordinateClue.builder().itemId(12099).location(new WorldPoint(3225, 2838, 0)).directions("South of Desert Treasure pyramid.").enemy(Enemy.ARMADYLEAN_OR_BANDOSIAN_GUARD).build(), CoordinateClue.builder().itemId(19813).location(new WorldPoint(1773, 3510, 0)).directions("Ruins north of the Hosidius mine.").enemy(Enemy.ARMADYLEAN_OR_BANDOSIAN_GUARD).build(), CoordinateClue.builder().itemId(12085).location(new WorldPoint(3822, 3562, 0)).directions("North-east of Dragontooth Island. Bring a Ghostspeak Amulet and 25 Ecto-tokens to reach the island.").enemy(Enemy.ARMADYLEAN_OR_BANDOSIAN_GUARD).build(), CoordinateClue.builder().itemId(12108).location(new WorldPoint(3603, 3564, 0)).directions("North of the wrecked ship, outside of Port Phasmatys.").enemy(Enemy.ARMADYLEAN_OR_BANDOSIAN_GUARD).build(), CoordinateClue.builder().itemId(12106).location(new WorldPoint(2936, 2721, 0)).directions("Eastern shore of Crash Island.").enemy(Enemy.ARMADYLEAN_OR_BANDOSIAN_GUARD).build(), CoordinateClue.builder().itemId(12096).location(new WorldPoint(2697, 2705, 0)).directions("South-west of Ape Atoll.").enemy(Enemy.ARMADYLEAN_OR_BANDOSIAN_GUARD).build(), CoordinateClue.builder().itemId(12104).location(new WorldPoint(2778, 3678, 0)).directions("Mountain Camp.").enemy(Enemy.ARMADYLEAN_OR_BANDOSIAN_GUARD).build(), CoordinateClue.builder().itemId(12090).location(new WorldPoint(2827, 3740, 0)).directions("West of the entrance to the Ice Path, where the Troll child resides.").enemy(Enemy.ARMADYLEAN_OR_BANDOSIAN_GUARD).build(), CoordinateClue.builder().itemId(12094).location(new WorldPoint(2359, 3799, 0)).directions("Neitiznot.").enemy(Enemy.ARMADYLEAN_OR_BANDOSIAN_GUARD).build(), CoordinateClue.builder().itemId(12105).location(new WorldPoint(2194, 3807, 0)).directions("Pirates' Cove.").enemy(Enemy.ARMADYLEAN_OR_BANDOSIAN_GUARD).build(), CoordinateClue.builder().itemId(12087).location(new WorldPoint(2700, 3808, 0)).directions("Northwestern part of the Trollweiss and Rellekka Hunter area (DKS).").enemy(Enemy.ARMADYLEAN_OR_BANDOSIAN_GUARD).build(), CoordinateClue.builder().itemId(12109).location(new WorldPoint(3215, 3835, 0)).directions("Wilderness. Lava Dragon Isle.").enemy(Enemy.ARMADYLEAN_OR_BANDOSIAN_GUARD).build(), CoordinateClue.builder().itemId(12101).location(new WorldPoint(3369, 3894, 0)).directions("Wilderness. Fountain of Rune.").enemy(Enemy.ARMADYLEAN_OR_BANDOSIAN_GUARD).build(), CoordinateClue.builder().itemId(12092).location(new WorldPoint(2065, 3923, 0)).directions("Outside the western wall on Lunar Isle.").enemy(Enemy.ARMADYLEAN_OR_BANDOSIAN_GUARD).build(), CoordinateClue.builder().itemId(12095).location(new WorldPoint(3188, 3933, 0)).directionsProvider(plugin -> "Wilderness Resource Area." + CoordinateClue.getResourceAreaCost(plugin)).enemy(Enemy.ARMADYLEAN_OR_BANDOSIAN_GUARD).build(), CoordinateClue.builder().itemId(12097).location(new WorldPoint(3043, 3940, 0)).directions("Wilderness. South of Pirates' Hideout.").enemy(Enemy.ARMADYLEAN_OR_BANDOSIAN_GUARD).build(), CoordinateClue.builder().itemId(12093).location(new WorldPoint(3380, 3963, 0)).directions("Wilderness. North of Volcano.").enemy(Enemy.ARMADYLEAN_OR_BANDOSIAN_GUARD).build(), CoordinateClue.builder().itemId(23146).location(new WorldPoint(3051, 3736, 0)).directions("East of the Wilderness Obelisk in 28 Wilderness.").enemy(Enemy.ARMADYLEAN_OR_BANDOSIAN_GUARD).build(), CoordinateClue.builder().itemId(23148).location(new WorldPoint(2316, 3814, 0)).directions("West of Neitiznot, near the bridge.").enemy(Enemy.ARMADYLEAN_OR_BANDOSIAN_GUARD).build(), CoordinateClue.builder().itemId(23147).location(new WorldPoint(2872, 3937, 0)).directions("Weiss.").enemy(Enemy.ARMADYLEAN_OR_BANDOSIAN_GUARD).build(), CoordinateClue.builder().itemId(24253).location(new WorldPoint(2484, 4016, 0)).directions("Northeast corner of the Island of Stone.").enemy(Enemy.ARMADYLEAN_OR_BANDOSIAN_GUARD).build(), CoordinateClue.builder().itemId(23770).location(new WorldPoint(2222, 3331, 0)).directions("Prifddinas, west of the Tower of Voices").enemy(Enemy.ARMADYLEAN_OR_BANDOSIAN_GUARD).build(), CoordinateClue.builder().itemId(22000).location(new WorldPoint(3560, 3987, 0)).directions("Lithkren. Digsite pendant teleport if unlocked, otherwise take rowboat from west of Mushroom Meadow Mushtree.").enemy(Enemy.ARMADYLEAN_OR_BANDOSIAN_GUARD).build(), CoordinateClue.builder().itemId(25499).location(new WorldPoint(2318, 2954, 0)).directions("North-east corner of the Isle of Souls (BJP).").enemy(Enemy.BANDOSIAN_GUARD).build(), CoordinateClue.builder().itemId(25498).location(new WorldPoint(2094, 2889, 0)).directions("West side of the Isle of Souls.").enemy(Enemy.ARMADYLEAN_GUARD).build(), CoordinateClue.builder().itemId(25787).location(new WorldPoint(1451, 3509, 0)).directions("Ruins of Morra.").enemy(Enemy.ARMADYLEAN_OR_BANDOSIAN_GUARD).build(), CoordinateClue.builder().itemId(26944).location(new WorldPoint(3318, 2706, 0)).directions("Necropolis mine").enemy(Enemy.ARMADYLEAN_OR_BANDOSIAN_GUARD).build(), CoordinateClue.builder().itemId(28912).location(new WorldPoint(1557, 3183, 0)).directions("North of Ortus Farm").enemy(Enemy.ARMADYLEAN_OR_BANDOSIAN_GUARD).build(), CoordinateClue.builder().itemId(29855).location(new WorldPoint(1571, 3245, 0)).directions("At the top of The Proudspire").enemy(Enemy.ARMADYLEAN_OR_BANDOSIAN_GUARD).build(), CoordinateClue.builder().itemId(30931).location(new WorldPoint(1321, 3323, 0)).directions("South of Custodia Pass").enemy(Enemy.SARADOMIN_WIZARD).build(), CoordinateClue.builder().itemId(31271).location(new WorldPoint(2081, 3184, 0)).directions("On Lledrith Island").enemy(Enemy.ARMADYLEAN_OR_BANDOSIAN_GUARD).build(), CoordinateClue.builder().itemId(19835).location(new WorldPoint(2178, 3209, 0)).directions("South of Iorwerth Camp.").enemy(Enemy.BRASSICAN_MAGE).build(), CoordinateClue.builder().itemId(19835).location(new WorldPoint(2155, 3100, 0)).directions("South of Port Tyras (BJS if 76 Agility).").enemy(Enemy.BRASSICAN_MAGE).build(), CoordinateClue.builder().itemId(19835).location(new WorldPoint(2217, 3092, 0)).directions("Poison Waste island (DLR).").enemy(Enemy.BRASSICAN_MAGE).build(), CoordinateClue.builder().itemId(19835).location(new WorldPoint(3830, 3060, 0)).directions("Small island located north-east of Mos Le'Harmless.").enemy(Enemy.BRASSICAN_MAGE).lightSourceVarbitId(6534).build(), CoordinateClue.builder().itemId(19835).location(new WorldPoint(2834, 3271, 0)).directions("Crandor island.").enemy(Enemy.BRASSICAN_MAGE).build(), CoordinateClue.builder().itemId(19835).location(new WorldPoint(2732, 3284, 0)).directions("Witchaven.").enemy(Enemy.BRASSICAN_MAGE).build(), CoordinateClue.builder().itemId(19835).location(new WorldPoint(3622, 3320, 0)).directions("Meiyerditch. Outside mine.").enemy(Enemy.BRASSICAN_MAGE).build(), CoordinateClue.builder().itemId(19835).location(new WorldPoint(2303, 3328, 0)).directions("East of Prifddinas.").enemy(Enemy.BRASSICAN_OR_WIZARDS).build(), CoordinateClue.builder().itemId(19835).location(new WorldPoint(3570, 3405, 0)).directions("North of Dessous's tomb from Desert Treasure.").enemy(Enemy.BRASSICAN_MAGE).build(), CoordinateClue.builder().itemId(19835).location(new WorldPoint(2840, 3423, 0)).directions("Water Obelisk Island.").enemy(Enemy.BRASSICAN_MAGE).build(), CoordinateClue.builder().itemId(19835).location(new WorldPoint(3604, 3564, 0)).directions("North of the wrecked ship, outside of Port Phasmatys (ALQ).").enemy(Enemy.BRASSICAN_MAGE).build(), CoordinateClue.builder().itemId(19835).location(new WorldPoint(3085, 3569, 0)).directions("Wilderness. Obelisk of Air.").enemy(Enemy.BRASSICAN_MAGE).build(), CoordinateClue.builder().itemId(19835).location(new WorldPoint(2934, 2727, 0)).directions("Eastern shore of Crash Island.").enemy(Enemy.BRASSICAN_MAGE).build(), CoordinateClue.builder().itemId(19835).location(new WorldPoint(1451, 3695, 0)).directions("West side of Lizardman Canyon with Lizardman shaman.").enemy(Enemy.ANCIENT_WIZARDS).build(), CoordinateClue.builder().itemId(19835).location(new WorldPoint(2538, 3739, 0)).directions("Waterbirth Island. Bring a pet rock and rune thrownaxe OR have 85 agility.").enemy(Enemy.BRASSICAN_MAGE).build(), CoordinateClue.builder().itemId(19835).location(new WorldPoint(1248, 3751, 0)).directions("In the north wing of the Farming Guild.").enemy(Enemy.BRASSICAN_MAGE).build(), CoordinateClue.builder().itemId(19835).location(new WorldPoint(1698, 3792, 0)).directions("Arceuus church.").enemy(Enemy.ANCIENT_WIZARDS).build(), CoordinateClue.builder().itemId(19835).location(new WorldPoint(2951, 3820, 0)).directions("Wilderness. Chaos Temple (level 38).").enemy(Enemy.ANCIENT_WIZARDS).build(), CoordinateClue.builder().itemId(19835).location(new WorldPoint(2202, 3825, 0)).directions("Pirates' Cove, between Lunar Isle and Rellekka.").enemy(Enemy.ANCIENT_WIZARDS).build(), CoordinateClue.builder().itemId(19835).location(new WorldPoint(1761, 3853, 0)).directions("Arceuus essence mine (CIS).").enemy(Enemy.BRASSICAN_MAGE).build(), CoordinateClue.builder().itemId(19835).location(new WorldPoint(2090, 3863, 0)).directions("South of Lunar Isle, west of Astral altar.").enemy(Enemy.BRASSICAN_MAGE).build(), CoordinateClue.builder().itemId(19835).location(new WorldPoint(1442, 3878, 0)).directions("Northern area of the Lovakengj Sulphur Mine. Facemask or Slayer Helmet recommended.").enemy(Enemy.BRASSICAN_MAGE).build(), CoordinateClue.builder().itemId(19835).location(new WorldPoint(3380, 3929, 0)).directions("Wilderness. Near Volcano.").enemy(Enemy.ANCIENT_WIZARDS).build(), CoordinateClue.builder().itemId(19835).location(new WorldPoint(3188, 3939, 0)).directions("Wilderness. Resource Area.").enemy(Enemy.BRASSICAN_MAGE).build(), CoordinateClue.builder().itemId(19835).location(new WorldPoint(3304, 3941, 0)).directions("Wilderness. East of Rogues' Castle.").enemy(Enemy.ANCIENT_WIZARDS).build(), CoordinateClue.builder().itemId(19835).location(new WorldPoint(3028, 3928, 0)).directions("Wilderness. South-east of Agility Training Area.").enemy(Enemy.BRASSICAN_MAGE).build(), CoordinateClue.builder().itemId(19835).location(new WorldPoint(1769, 3418, 0)).directions("Crabclaw Isle").enemy(Enemy.ANCIENT_WIZARDS).build()).stream().collect(Collectors.collectingAndThen(Collectors.toMap(CoordinateClue::getLocation, clue -> clue), ImmutableMap::copyOf));
    private final int itemId;
    private final Function<ClueScrollPlugin, String> directionsProvider;
    @Nullable
    private final Enemy enemy;
    private final int lightSourceVarbitId;
    private final WorldPoint location;
    @Nullable
    private final WorldPoint mirrorLocation;

    private CoordinateClue(@Nullable Integer itemId, @Nullable String directions, @Nullable Function<ClueScrollPlugin, String> directionsProvider, @Nullable Enemy enemy, WorldPoint location, @Nullable Integer lightSourceVarbitId) {
        this.itemId = itemId != null ? itemId : -1;
        this.directionsProvider = directionsProvider != null ? directionsProvider : plugin -> directions;
        this.enemy = enemy;
        this.location = location;
        this.mirrorLocation = location == null ? null : WorldPoint.getMirrorPoint((WorldPoint)location, (boolean)false);
        this.lightSourceVarbitId = lightSourceVarbitId == null ? -1 : lightSourceVarbitId;
        this.setFirePitVarbitId(this.lightSourceVarbitId);
        this.setRequiresLight(this.lightSourceVarbitId != -1);
        this.setRequiresSpade(true);
    }

    public static CoordinateClue forLocation(WorldPoint location) {
        return (CoordinateClue)CLUES.get((Object)location);
    }

    @VisibleForTesting
    String getDirections(ClueScrollPlugin plugin) {
        return this.getDirectionsProvider().apply(plugin);
    }

    @Override
    public WorldPoint getLocation(ClueScrollPlugin plugin) {
        return this.location;
    }

    @Override
    public WorldPoint[] getLocations(ClueScrollPlugin plugin) {
        if (this.mirrorLocation != null && this.mirrorLocation != this.location) {
            return new WorldPoint[]{this.location, this.mirrorLocation};
        }
        return new WorldPoint[]{this.location};
    }

    @Override
    public void makeOverlayHint(PanelComponent panelComponent, ClueScrollPlugin plugin) {
        panelComponent.getChildren().add(TitleComponent.builder().text("Coordinate Clue").build());
        CoordinateClue solution = (CoordinateClue)CLUES.get((Object)this.location);
        if (solution != null) {
            panelComponent.getChildren().add(LineComponent.builder().left(solution.getDirections(plugin)).build());
            panelComponent.getChildren().add(LineComponent.builder().build());
        }
        panelComponent.getChildren().add(LineComponent.builder().left("Click the clue scroll on your world map to see dig location.").build());
        this.renderOverlayNote(panelComponent, plugin);
    }

    @Override
    public void makeWorldOverlayHint(Graphics2D graphics, ClueScrollPlugin plugin) {
        for (WorldPoint worldPoint : this.getLocations(plugin)) {
            LocalPoint localLocation = LocalPoint.fromWorld((Client)plugin.getClient(), (WorldPoint)worldPoint);
            if (localLocation == null) continue;
            OverlayUtil.renderTileOverlay(plugin.getClient(), graphics, localLocation, plugin.getSpadeImage(), Color.ORANGE);
        }
    }

    public static CoordinateClue forItemId(int itemId) {
        for (CoordinateClue clue : CLUES.values()) {
            if (clue.itemId != itemId) continue;
            return clue;
        }
        return null;
    }

    @Override
    public int[] getConfigKeys() {
        return new int[]{this.location.hashCode()};
    }

    private static String getResourceAreaCost(ClueScrollPlugin plugin) {
        if (plugin.getClient().getVarbitValue(4469) == 1) {
            return "";
        }
        int resourceAreaCost = 7500;
        if (plugin.getClient().getVarbitValue(4468) == 1) {
            resourceAreaCost = 3750;
        } else if (plugin.getClient().getVarbitValue(4467) == 1) {
            resourceAreaCost = 6000;
        }
        return String.format(" An entry fee of %,d coins is required.", resourceAreaCost);
    }

    private static String getHardwoodGroveCost(ClueScrollPlugin plugin) {
        if (plugin.getClient().getVarbitValue(4566) == 1) {
            return "";
        }
        return " An entry fee of 100 trading sticks is required.";
    }

    public static CoordinateClueBuilder builder() {
        return new CoordinateClueBuilder();
    }

    public int getItemId() {
        return this.itemId;
    }

    @Override
    @Nullable
    public Enemy getEnemy() {
        return this.enemy;
    }

    @Nullable
    public WorldPoint getMirrorLocation() {
        return this.mirrorLocation;
    }

    private Function<ClueScrollPlugin, String> getDirectionsProvider() {
        return this.directionsProvider;
    }

    public int getLightSourceVarbitId() {
        return this.lightSourceVarbitId;
    }

    private WorldPoint getLocation() {
        return this.location;
    }

    public static class CoordinateClueBuilder {
        private Integer itemId;
        private String directions;
        private Function<ClueScrollPlugin, String> directionsProvider;
        private Enemy enemy;
        private WorldPoint location;
        private Integer lightSourceVarbitId;

        CoordinateClueBuilder() {
        }

        public CoordinateClueBuilder itemId(@Nullable Integer itemId) {
            this.itemId = itemId;
            return this;
        }

        public CoordinateClueBuilder directions(@Nullable String directions) {
            this.directions = directions;
            return this;
        }

        public CoordinateClueBuilder directionsProvider(@Nullable Function<ClueScrollPlugin, String> directionsProvider) {
            this.directionsProvider = directionsProvider;
            return this;
        }

        public CoordinateClueBuilder enemy(@Nullable Enemy enemy) {
            this.enemy = enemy;
            return this;
        }

        public CoordinateClueBuilder location(WorldPoint location) {
            this.location = location;
            return this;
        }

        public CoordinateClueBuilder lightSourceVarbitId(@Nullable Integer lightSourceVarbitId) {
            this.lightSourceVarbitId = lightSourceVarbitId;
            return this;
        }

        public CoordinateClue build() {
            return new CoordinateClue(this.itemId, this.directions, this.directionsProvider, this.enemy, this.location, this.lightSourceVarbitId);
        }

        public String toString() {
            return "CoordinateClue.CoordinateClueBuilder(itemId=" + this.itemId + ", directions=" + this.directions + ", directionsProvider=" + String.valueOf(this.directionsProvider) + ", enemy=" + String.valueOf((Object)this.enemy) + ", location=" + String.valueOf(this.location) + ", lightSourceVarbitId=" + this.lightSourceVarbitId + ")";
        }
    }
}

