/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.gpu;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.opengl.GL33C;

class VBO {
    final int size;
    private int usage;
    int bufId;
    private ByteBuffer buffer;
    IntBuffer vb;
    int len;
    boolean mapped;

    VBO(int size) {
        this.size = size;
    }

    void init(int usage) {
        this.usage = usage;
        this.bufId = GL33C.glGenBuffers();
        GL33C.glBindBuffer((int)34962, (int)this.bufId);
        GL33C.glBufferData((int)34962, (long)this.size, (int)usage);
        GL33C.glBindBuffer((int)34962, (int)0);
    }

    void destroy() {
        if (this.mapped) {
            GL33C.glBindBuffer((int)34962, (int)this.bufId);
            GL33C.glUnmapBuffer((int)34962);
            GL33C.glBindBuffer((int)34962, (int)0);
            this.mapped = false;
        }
        GL33C.glDeleteBuffers((int)this.bufId);
        this.bufId = 0;
    }

    void map() {
        assert (!this.mapped);
        GL33C.glBindBuffer((int)34962, (int)this.bufId);
        this.buffer = GL33C.glMapBufferRange((int)34962, (long)0L, (long)this.size, (int)(2 | (this.usage == 35044 ? 0 : 24)), (ByteBuffer)this.buffer);
        if (this.buffer == null) {
            throw new RuntimeException("unable to map GL buffer " + this.bufId + " size " + this.size);
        }
        this.vb = this.buffer.asIntBuffer();
        GL33C.glBindBuffer((int)34962, (int)0);
        this.mapped = true;
    }

    void unmap() {
        assert (this.mapped);
        this.len = this.vb.position();
        this.vb = null;
        GL33C.glBindBuffer((int)34962, (int)this.bufId);
        if (this.usage != 35044) {
            GL33C.glFlushMappedBufferRange((int)34962, (long)0L, (long)((long)this.len * 4L));
        }
        GL33C.glUnmapBuffer((int)34962);
        GL33C.glBindBuffer((int)34962, (int)0);
        this.mapped = false;
    }
}

