/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.gpu;

import com.google.common.base.Stopwatch;
import com.google.common.primitives.Ints;
import com.google.inject.Provides;
import java.awt.Canvas;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import javax.inject.Inject;
import javax.swing.SwingUtilities;
import net.runelite.api.BufferProvider;
import net.runelite.api.Client;
import net.runelite.api.FloatProjection;
import net.runelite.api.GameObject;
import net.runelite.api.GameState;
import net.runelite.api.Model;
import net.runelite.api.Player;
import net.runelite.api.Projection;
import net.runelite.api.Renderable;
import net.runelite.api.Scene;
import net.runelite.api.TextureProvider;
import net.runelite.api.TileObject;
import net.runelite.api.WorldEntity;
import net.runelite.api.WorldView;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.PostClientTick;
import net.runelite.api.hooks.DrawCallbacks;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.callback.RenderCallbackManager;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.plugins.PluginInstantiationException;
import net.runelite.client.plugins.PluginManager;
import net.runelite.client.plugins.gpu.FacePrioritySorter;
import net.runelite.client.plugins.gpu.GLBuffer;
import net.runelite.client.plugins.gpu.GpuFloatBuffer;
import net.runelite.client.plugins.gpu.GpuPluginConfig;
import net.runelite.client.plugins.gpu.Mat4;
import net.runelite.client.plugins.gpu.RegionManager;
import net.runelite.client.plugins.gpu.SceneUploader;
import net.runelite.client.plugins.gpu.Shader;
import net.runelite.client.plugins.gpu.ShaderException;
import net.runelite.client.plugins.gpu.TextureManager;
import net.runelite.client.plugins.gpu.VAO;
import net.runelite.client.plugins.gpu.VAOList;
import net.runelite.client.plugins.gpu.VBO;
import net.runelite.client.plugins.gpu.Zone;
import net.runelite.client.plugins.gpu.config.AntiAliasingMode;
import net.runelite.client.plugins.gpu.config.UIScalingMode;
import net.runelite.client.plugins.gpu.template.Template;
import net.runelite.client.ui.ClientUI;
import net.runelite.client.ui.DrawManager;
import net.runelite.rlawt.AWTContext;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL33C;
import org.lwjgl.opengl.GL43C;
import org.lwjgl.opengl.GL45C;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.opengl.GLUtil;
import org.lwjgl.system.Callback;
import org.lwjgl.system.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="GPU", description="Offloads rendering to GPU", tags={"fog", "draw distance"}, loadInSafeMode=false)
public class GpuPlugin
extends Plugin
implements DrawCallbacks {
    private static final Logger log = LoggerFactory.getLogger(GpuPlugin.class);
    static final int MAX_DISTANCE = 184;
    static final int MAX_FOG_DEPTH = 100;
    static final int SCENE_OFFSET = 40;
    private static final int UNIFORM_BUFFER_SIZE = 20;
    private static final int NUM_ZONES = 23;
    private static final int MAX_WORLDVIEWS = 4096;
    @Inject
    private Client client;
    @Inject
    private ClientUI clientUI;
    @Inject
    private ClientThread clientThread;
    @Inject
    private GpuPluginConfig config;
    @Inject
    private TextureManager textureManager;
    @Inject
    private RegionManager regionManager;
    @Inject
    private DrawManager drawManager;
    @Inject
    private PluginManager pluginManager;
    @Inject
    private RenderCallbackManager renderCallbackManager;
    private Canvas canvas;
    private AWTContext awtContext;
    private Callback debugCallback;
    private boolean lwjglInitted = false;
    private GLCapabilities glCapabilities;
    static final Shader PROGRAM = new Shader().add(35633, "vert.glsl").add(35632, "frag.glsl");
    static final Shader UI_PROGRAM = new Shader().add(35633, "vertui.glsl").add(35632, "fragui.glsl");
    static int glProgram;
    private int glUiProgram;
    private int interfaceTexture;
    private int interfacePbo;
    private int vaoUiHandle;
    private int vboUiHandle;
    private int fboScene;
    private boolean sceneFboValid;
    private int rboColorBuffer;
    private int rboDepthBuffer;
    private int textureArrayId;
    private final GLBuffer glUniformBuffer = new GLBuffer("uniform buffer");
    private int lastCanvasWidth;
    private int lastCanvasHeight;
    private int lastStretchedCanvasWidth;
    private int lastStretchedCanvasHeight;
    private AntiAliasingMode lastAntiAliasingMode;
    private int lastAnisotropicFilteringLevel = -1;
    private GpuFloatBuffer uniformBuffer;
    private int cameraX;
    private int cameraY;
    private int cameraZ;
    private int cameraYaw;
    private int cameraPitch;
    private int minLevel;
    private int level;
    private int maxLevel;
    private Set<Integer> hideRoofIds;
    private VAOList vaoO;
    private VAOList vaoA;
    private VAOList vaoPO;
    private SceneUploader clientUploader;
    private SceneUploader mapUploader;
    private FacePrioritySorter facePrioritySorter;
    private SceneContext root;
    private SceneContext[] subs;
    private Zone[][] nextZones;
    private Map<Integer, Integer> nextRoofChanges;
    private int uniUseFog;
    private int uniFogColor;
    private int uniFogDepth;
    private int uniDrawDistance;
    private int uniExpandedMapLoadingChunks;
    private int uniSmoothBanding;
    private int uniWorldProj;
    private static int uniEntityProj;
    static int uniEntityTint;
    private int uniBrightness;
    private int uniTex;
    private int uniTexSourceDimensions;
    private int uniTexTargetDimensions;
    private int uniUiAlphaOverlay;
    private int uniTextures;
    private int uniTextureAnimations;
    private int uniBlockMain;
    private int uniTextureLightMode;
    private int uniTick;
    static int uniBase;
    private static Projection lastProjection;
    private static final int ALPHA_ZSORT_CLOSE = 2048;

    SceneContext context(Scene scene) {
        int wvid = scene.getWorldViewId();
        if (wvid == -1) {
            return this.root;
        }
        return this.subs[wvid];
    }

    SceneContext context(WorldView wv) {
        int wvid = wv.getId();
        if (wvid == -1) {
            return this.root;
        }
        return this.subs[wvid];
    }

    @Override
    protected void startUp() {
        this.root = new SceneContext(23, 23);
        this.subs = new SceneContext[4096];
        this.clientUploader = new SceneUploader(this.renderCallbackManager);
        this.mapUploader = new SceneUploader(this.renderCallbackManager);
        this.facePrioritySorter = new FacePrioritySorter(this.clientUploader);
        this.clientThread.invoke(() -> {
            try {
                this.fboScene = -1;
                this.lastAnisotropicFilteringLevel = -1;
                AWTContext.loadNatives();
                this.canvas = this.client.getCanvas();
                Object object = this.canvas.getTreeLock();
                synchronized (object) {
                    if (!this.canvas.isValid()) {
                        return false;
                    }
                    this.awtContext = new AWTContext((Component)this.canvas);
                    this.awtContext.configurePixelFormat(0, 0, 0);
                }
                this.awtContext.createGLContext();
                this.canvas.setIgnoreRepaint(true);
                Configuration.SHARED_LIBRARY_EXTRACT_DIRECTORY.set((Object)"lwjgl-rl");
                this.glCapabilities = GL.createCapabilities();
                log.info("Using device: {}", (Object)GL33C.glGetString((int)7937));
                log.info("Using driver: {}", (Object)GL33C.glGetString((int)7938));
                if (!this.glCapabilities.OpenGL33) {
                    throw new RuntimeException("OpenGL 3.3 is required but not available");
                }
                this.lwjglInitted = true;
                this.checkGLErrors();
                if (log.isDebugEnabled() && this.glCapabilities.glDebugMessageControl != 0L) {
                    this.debugCallback = GLUtil.setupDebugMessageCallback();
                    if (this.debugCallback != null) {
                        GL43C.glDebugMessageControl((int)33350, (int)33361, (int)4352, (int)131185, (boolean)false);
                        GL43C.glDebugMessageControl((int)33350, (int)33360, (int)4352, (int)131154, (boolean)false);
                    }
                }
                this.setupSyncMode();
                this.initBuffers();
                this.initVao();
                this.initProgram();
                this.initInterfaceTexture();
                if (this.glCapabilities.OpenGL45) {
                    GL45C.glClipControl((int)36001, (int)37727);
                }
                this.client.setDrawCallbacks((DrawCallbacks)this);
                this.client.setGpuFlags(1 | (this.config.removeVertexSnapping() ? 8 : 0) | 0x10);
                this.client.setExpandedMapLoading(this.config.expandedMapLoadingZones());
                this.client.resizeCanvas();
                this.lastCanvasHeight = -1;
                this.lastCanvasWidth = -1;
                this.lastStretchedCanvasHeight = -1;
                this.lastStretchedCanvasWidth = -1;
                this.lastAntiAliasingMode = null;
                this.textureArrayId = -1;
                if (this.client.getGameState() == GameState.LOGGED_IN) {
                    this.startupWorldLoad();
                }
                this.checkGLErrors();
            }
            catch (Throwable e) {
                log.error("Error starting GPU plugin", e);
                SwingUtilities.invokeLater(() -> {
                    try {
                        this.pluginManager.setPluginEnabled(this, false);
                        this.pluginManager.stopPlugin(this);
                    }
                    catch (PluginInstantiationException ex) {
                        log.error("error stopping plugin", (Throwable)ex);
                    }
                });
                this.shutDown();
            }
            return true;
        });
    }

    private void startupWorldLoad() {
        WorldView root = this.client.getTopLevelWorldView();
        Scene scene = root.getScene();
        this.loadScene(root, scene);
        this.swapScene(scene);
        for (WorldEntity subEntity : root.worldEntities()) {
            WorldView sub = subEntity.getWorldView();
            log.debug("WorldView loading: {}", (Object)sub.getId());
            this.loadSubScene(sub, sub.getScene());
            this.swapSub(sub.getScene());
        }
    }

    @Override
    protected void shutDown() {
        this.clientThread.invoke(() -> {
            this.client.setGpuFlags(0);
            this.client.setDrawCallbacks(null);
            this.client.setUnlockedFps(false);
            this.client.setExpandedMapLoading(0);
            if (this.lwjglInitted) {
                if (this.textureArrayId != -1) {
                    this.textureManager.freeTextureArray(this.textureArrayId);
                    this.textureArrayId = -1;
                }
                this.root.free();
                this.shutdownInterfaceTexture();
                this.shutdownProgram();
                this.shutdownVao();
                this.shutdownBuffers();
                this.shutdownFbo();
            }
            if (this.awtContext != null) {
                this.awtContext.destroy();
                this.awtContext = null;
            }
            if (this.debugCallback != null) {
                this.debugCallback.free();
                this.debugCallback = null;
            }
            this.glCapabilities = null;
            this.client.resizeCanvas();
        });
    }

    @Provides
    GpuPluginConfig provideConfig(ConfigManager configManager) {
        return configManager.getConfig(GpuPluginConfig.class);
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged configChanged) {
        if (configChanged.getGroup().equals("gpu")) {
            if (configChanged.getKey().equals("unlockFps") || configChanged.getKey().equals("vsyncMode") || configChanged.getKey().equals("fpsTarget")) {
                log.debug("Rebuilding sync mode");
                this.clientThread.invokeLater(this::setupSyncMode);
            } else if (configChanged.getKey().equals("expandedMapLoadingChunks")) {
                this.clientThread.invokeLater(() -> {
                    this.client.setExpandedMapLoading(this.config.expandedMapLoadingZones());
                    if (this.client.getGameState() == GameState.LOGGED_IN) {
                        this.client.setGameState(GameState.LOADING);
                    }
                });
            } else if (configChanged.getKey().equals("removeVertexSnapping")) {
                log.debug("Toggle {}", (Object)configChanged.getKey());
                this.client.setGpuFlags(1 | (this.config.removeVertexSnapping() ? 8 : 0) | 0x10);
            } else if (configChanged.getKey().equals("uiScalingMode") || configChanged.getKey().equals("colorBlindMode")) {
                this.clientThread.invokeLater(() -> {
                    log.debug("Recompiling shaders");
                    this.shutdownProgram();
                    this.initProgram();
                });
            }
        }
    }

    private void setupSyncMode() {
        boolean unlockFps = this.config.unlockFps();
        this.client.setUnlockedFps(unlockFps);
        GpuPluginConfig.SyncMode syncMode = unlockFps ? this.config.syncMode() : GpuPluginConfig.SyncMode.OFF;
        int swapInterval = 0;
        switch (syncMode) {
            case ON: {
                swapInterval = 1;
                break;
            }
            case OFF: {
                swapInterval = 0;
                break;
            }
            case ADAPTIVE: {
                swapInterval = -1;
            }
        }
        int actualSwapInterval = this.awtContext.setSwapInterval(swapInterval);
        if (actualSwapInterval != swapInterval) {
            log.info("unsupported swap interval {}, got {}", (Object)swapInterval, (Object)actualSwapInterval);
        }
        this.client.setUnlockedFpsTarget(actualSwapInterval == 0 ? this.config.fpsTarget() : 0);
        this.checkGLErrors();
    }

    private Template createTemplate() {
        Template template = new Template();
        template.add(key -> {
            switch (key) {
                case "texture_config": {
                    return "#define TEXTURE_COUNT 256\n";
                }
                case "sampling_mode": {
                    return "#define SAMPLING_MODE " + this.config.uiScalingMode().ordinal() + "\n";
                }
                case "colorblind_mode": {
                    return "#define COLORBLIND_MODE " + this.config.colorBlindMode().ordinal() + "\n";
                }
            }
            return null;
        });
        template.addInclude(GpuPlugin.class);
        return template;
    }

    private void initProgram() throws ShaderException {
        GL33C.glBindVertexArray((int)this.vaoUiHandle);
        Template template = this.createTemplate();
        glProgram = PROGRAM.compile(template);
        this.glUiProgram = UI_PROGRAM.compile(template);
        GL33C.glBindVertexArray((int)0);
        this.initUniforms();
    }

    private void initUniforms() {
        this.uniWorldProj = GL33C.glGetUniformLocation((int)glProgram, (CharSequence)"worldProj");
        uniEntityProj = GL33C.glGetUniformLocation((int)glProgram, (CharSequence)"entityProj");
        uniEntityTint = GL33C.glGetUniformLocation((int)glProgram, (CharSequence)"entityTint");
        this.uniSmoothBanding = GL33C.glGetUniformLocation((int)glProgram, (CharSequence)"smoothBanding");
        this.uniBrightness = GL33C.glGetUniformLocation((int)glProgram, (CharSequence)"brightness");
        this.uniUseFog = GL33C.glGetUniformLocation((int)glProgram, (CharSequence)"useFog");
        this.uniFogColor = GL33C.glGetUniformLocation((int)glProgram, (CharSequence)"fogColor");
        this.uniFogDepth = GL33C.glGetUniformLocation((int)glProgram, (CharSequence)"fogDepth");
        this.uniDrawDistance = GL33C.glGetUniformLocation((int)glProgram, (CharSequence)"drawDistance");
        this.uniExpandedMapLoadingChunks = GL33C.glGetUniformLocation((int)glProgram, (CharSequence)"expandedMapLoadingChunks");
        this.uniTextureLightMode = GL33C.glGetUniformLocation((int)glProgram, (CharSequence)"textureLightMode");
        this.uniTick = GL33C.glGetUniformLocation((int)glProgram, (CharSequence)"tick");
        this.uniBlockMain = GL33C.glGetUniformBlockIndex((int)glProgram, (CharSequence)"uniforms");
        this.uniTextures = GL33C.glGetUniformLocation((int)glProgram, (CharSequence)"textures");
        this.uniTextureAnimations = GL33C.glGetUniformLocation((int)glProgram, (CharSequence)"textureAnimations");
        uniBase = GL33C.glGetUniformLocation((int)glProgram, (CharSequence)"base");
        this.uniTex = GL33C.glGetUniformLocation((int)this.glUiProgram, (CharSequence)"tex");
        this.uniTexTargetDimensions = GL33C.glGetUniformLocation((int)this.glUiProgram, (CharSequence)"targetDimensions");
        this.uniTexSourceDimensions = GL33C.glGetUniformLocation((int)this.glUiProgram, (CharSequence)"sourceDimensions");
        this.uniUiAlphaOverlay = GL33C.glGetUniformLocation((int)this.glUiProgram, (CharSequence)"alphaOverlay");
    }

    private void shutdownProgram() {
        GL33C.glDeleteProgram((int)glProgram);
        glProgram = 0;
        GL33C.glDeleteProgram((int)this.glUiProgram);
        this.glUiProgram = 0;
    }

    private void initVao() {
        this.vaoUiHandle = GL33C.glGenVertexArrays();
        this.vboUiHandle = GL33C.glGenBuffers();
        GL33C.glBindVertexArray((int)this.vaoUiHandle);
        FloatBuffer vboUiBuf = GpuFloatBuffer.allocateDirect(20);
        vboUiBuf.put(new float[]{1.0f, 1.0f, 0.0f, 1.0f, 0.0f, 1.0f, -1.0f, 0.0f, 1.0f, 1.0f, -1.0f, -1.0f, 0.0f, 0.0f, 1.0f, -1.0f, 1.0f, 0.0f, 0.0f, 0.0f});
        vboUiBuf.rewind();
        GL33C.glBindBuffer((int)34962, (int)this.vboUiHandle);
        GL33C.glBufferData((int)34962, (FloatBuffer)vboUiBuf, (int)35044);
        GL33C.glVertexAttribPointer((int)0, (int)3, (int)5126, (boolean)false, (int)20, (long)0L);
        GL33C.glEnableVertexAttribArray((int)0);
        GL33C.glVertexAttribPointer((int)1, (int)2, (int)5126, (boolean)false, (int)20, (long)12L);
        GL33C.glEnableVertexAttribArray((int)1);
        GL33C.glBindVertexArray((int)0);
        GL33C.glBindBuffer((int)34962, (int)0);
    }

    private void shutdownVao() {
        GL33C.glDeleteBuffers((int)this.vboUiHandle);
        this.vboUiHandle = 0;
        GL33C.glDeleteVertexArrays((int)this.vaoUiHandle);
        this.vaoUiHandle = 0;
    }

    private void initBuffers() {
        this.uniformBuffer = new GpuFloatBuffer(20);
        this.initGlBuffer(this.glUniformBuffer);
        Zone.initBuffer();
        this.vaoO = new VAOList();
        this.vaoA = new VAOList();
        this.vaoPO = new VAOList();
    }

    private void initGlBuffer(GLBuffer glBuffer) {
        glBuffer.glBufferId = GL33C.glGenBuffers();
    }

    private void shutdownBuffers() {
        this.destroyGlBuffer(this.glUniformBuffer);
        this.uniformBuffer = null;
        Zone.freeBuffer();
        if (this.vaoO != null) {
            this.vaoO.free();
        }
        if (this.vaoA != null) {
            this.vaoA.free();
        }
        if (this.vaoPO != null) {
            this.vaoPO.free();
        }
        this.vaoPO = null;
        this.vaoA = null;
        this.vaoO = null;
    }

    private void destroyGlBuffer(GLBuffer glBuffer) {
        if (glBuffer.glBufferId != -1) {
            GL33C.glDeleteBuffers((int)glBuffer.glBufferId);
            glBuffer.glBufferId = -1;
        }
        glBuffer.size = -1;
    }

    private void initInterfaceTexture() {
        this.interfacePbo = GL33C.glGenBuffers();
        this.interfaceTexture = GL33C.glGenTextures();
        GL33C.glBindTexture((int)3553, (int)this.interfaceTexture);
        GL33C.glTexParameteri((int)3553, (int)10242, (int)33071);
        GL33C.glTexParameteri((int)3553, (int)10243, (int)33071);
        GL33C.glTexParameteri((int)3553, (int)10241, (int)9729);
        GL33C.glTexParameteri((int)3553, (int)10240, (int)9729);
        GL33C.glBindTexture((int)3553, (int)0);
    }

    private void shutdownInterfaceTexture() {
        GL33C.glDeleteBuffers((int)this.interfacePbo);
        GL33C.glDeleteTextures((int)this.interfaceTexture);
        this.interfaceTexture = -1;
    }

    private void initFbo(int width, int height, int aaSamples) {
        GraphicsConfiguration graphicsConfiguration = this.clientUI.getGraphicsConfiguration();
        AffineTransform transform = graphicsConfiguration.getDefaultTransform();
        width = this.getScaledValue(transform.getScaleX(), width);
        height = this.getScaledValue(transform.getScaleY(), height);
        if (aaSamples > 0) {
            GL33C.glEnable((int)32925);
        } else {
            GL33C.glDisable((int)32925);
        }
        this.fboScene = GL33C.glGenFramebuffers();
        GL33C.glBindFramebuffer((int)36160, (int)this.fboScene);
        this.rboColorBuffer = GL33C.glGenRenderbuffers();
        GL33C.glBindRenderbuffer((int)36161, (int)this.rboColorBuffer);
        GL33C.glRenderbufferStorageMultisample((int)36161, (int)aaSamples, (int)6408, (int)width, (int)height);
        GL33C.glFramebufferRenderbuffer((int)36160, (int)36064, (int)36161, (int)this.rboColorBuffer);
        this.rboDepthBuffer = GL33C.glGenRenderbuffers();
        GL33C.glBindRenderbuffer((int)36161, (int)this.rboDepthBuffer);
        GL33C.glRenderbufferStorageMultisample((int)36161, (int)aaSamples, (int)36012, (int)width, (int)height);
        GL33C.glFramebufferRenderbuffer((int)36160, (int)36096, (int)36161, (int)this.rboDepthBuffer);
        int status = GL33C.glCheckFramebufferStatus((int)36160);
        if (status != 36053) {
            throw new RuntimeException("FBO is incomplete. status: " + status);
        }
        GL33C.glBindFramebuffer((int)36160, (int)this.awtContext.getFramebuffer(false));
        GL33C.glBindRenderbuffer((int)36161, (int)0);
    }

    private void shutdownFbo() {
        if (this.fboScene != -1) {
            GL33C.glDeleteFramebuffers((int)this.fboScene);
            this.fboScene = -1;
        }
        if (this.rboColorBuffer != 0) {
            GL33C.glDeleteRenderbuffers((int)this.rboColorBuffer);
            this.rboColorBuffer = 0;
        }
        if (this.rboDepthBuffer != 0) {
            GL33C.glDeleteRenderbuffers((int)this.rboDepthBuffer);
            this.rboDepthBuffer = 0;
        }
    }

    static void updateEntityProjection(Projection projection) {
        if (lastProjection != projection) {
            float[] p = projection instanceof FloatProjection ? ((FloatProjection)projection).getProjection() : Mat4.identity();
            GL33C.glUniformMatrix4fv((int)uniEntityProj, (boolean)false, (float[])p);
            lastProjection = projection;
        }
    }

    public void preSceneDraw(Scene scene, float cameraX, float cameraY, float cameraZ, float cameraPitch, float cameraYaw, int minLevel, int level, int maxLevel, Set<Integer> hideRoofIds) {
        this.cameraX = (int)cameraX;
        this.cameraY = (int)cameraY;
        this.cameraZ = (int)cameraZ;
        this.cameraYaw = this.client.getCameraYaw();
        this.cameraPitch = this.client.getCameraPitch();
        this.minLevel = minLevel;
        this.level = level;
        this.maxLevel = maxLevel;
        this.hideRoofIds = hideRoofIds;
        if (scene.getWorldViewId() == -1) {
            this.preSceneDrawToplevel(scene, cameraX, cameraY, cameraZ, cameraPitch, cameraYaw);
        } else {
            Scene toplevel = this.client.getScene();
            this.vaoO.addRange(null, toplevel);
            this.vaoPO.addRange(null, toplevel);
            GL33C.glUniform4i((int)uniEntityTint, (int)scene.getOverrideHue(), (int)scene.getOverrideSaturation(), (int)scene.getOverrideLuminance(), (int)scene.getOverrideAmount());
        }
    }

    private void preSceneDrawToplevel(Scene scene, float cameraX, float cameraY, float cameraZ, float cameraPitch, float cameraYaw) {
        int stretchedCanvasHeight;
        scene.setDrawDistance(this.getDrawDistance());
        this.uniformBuffer.clear();
        this.uniformBuffer.put(cameraYaw).put(cameraPitch).put(cameraX).put(cameraY).put(cameraZ);
        this.uniformBuffer.flip();
        GL33C.glBindBuffer((int)35345, (int)this.glUniformBuffer.glBufferId);
        GL33C.glBufferData((int)35345, (FloatBuffer)this.uniformBuffer.getBuffer(), (int)35048);
        GL33C.glBindBuffer((int)35345, (int)0);
        this.uniformBuffer.clear();
        GL33C.glBindBufferBase((int)35345, (int)0, (int)this.glUniformBuffer.glBufferId);
        this.checkGLErrors();
        int canvasHeight = this.client.getCanvasHeight();
        int canvasWidth = this.client.getCanvasWidth();
        int viewportHeight = this.client.getViewportHeight();
        int viewportWidth = this.client.getViewportWidth();
        AntiAliasingMode antiAliasingMode = this.config.antiAliasingMode();
        Dimension stretchedDimensions = this.client.getStretchedDimensions();
        int stretchedCanvasWidth = this.client.isStretchedEnabled() ? stretchedDimensions.width : canvasWidth;
        int n = stretchedCanvasHeight = this.client.isStretchedEnabled() ? stretchedDimensions.height : canvasHeight;
        if (this.lastStretchedCanvasWidth != stretchedCanvasWidth || this.lastStretchedCanvasHeight != stretchedCanvasHeight || this.lastAntiAliasingMode != antiAliasingMode) {
            this.shutdownFbo();
            GL33C.glBindFramebuffer((int)36160, (int)this.awtContext.getFramebuffer(false));
            int forcedAASamples = GL33C.glGetInteger((int)32937);
            int maxSamples = GL33C.glGetInteger((int)36183);
            int samples = forcedAASamples != 0 ? forcedAASamples : Math.min(antiAliasingMode.getSamples(), maxSamples);
            log.debug("AA samples: {}, max samples: {}, forced samples: {}", new Object[]{samples, maxSamples, forcedAASamples});
            this.initFbo(stretchedCanvasWidth, stretchedCanvasHeight, samples);
            this.lastStretchedCanvasWidth = stretchedCanvasWidth;
            this.lastStretchedCanvasHeight = stretchedCanvasHeight;
            this.lastAntiAliasingMode = antiAliasingMode;
        }
        GL33C.glBindFramebuffer((int)36009, (int)this.fboScene);
        int sky = this.client.getSkyboxColor();
        GL33C.glClearColor((float)((float)(sky >> 16 & 0xFF) / 255.0f), (float)((float)(sky >> 8 & 0xFF) / 255.0f), (float)((float)(sky & 0xFF) / 255.0f), (float)1.0f);
        GL33C.glClearDepth((double)0.0);
        GL33C.glClear((int)16640);
        int anisotropicFilteringLevel = this.config.anisotropicFilteringLevel();
        if (this.textureArrayId != -1 && this.lastAnisotropicFilteringLevel != anisotropicFilteringLevel) {
            this.textureManager.setAnisotropicFilteringLevel(this.textureArrayId, anisotropicFilteringLevel);
            this.lastAnisotropicFilteringLevel = anisotropicFilteringLevel;
        }
        int renderWidthOff = this.client.getViewportXOffset();
        int renderHeightOff = this.client.getViewportYOffset();
        int renderCanvasHeight = canvasHeight;
        int renderViewportHeight = viewportHeight;
        int renderViewportWidth = viewportWidth;
        if (this.client.isStretchedEnabled()) {
            Dimension dim = this.client.getStretchedDimensions();
            renderCanvasHeight = dim.height;
            double scaleFactorY = dim.getHeight() / (double)canvasHeight;
            double scaleFactorX = dim.getWidth() / (double)canvasWidth;
            boolean padding = true;
            renderViewportHeight = (int)Math.ceil(scaleFactorY * (double)renderViewportHeight) + 2;
            renderViewportWidth = (int)Math.ceil(scaleFactorX * (double)renderViewportWidth) + 2;
            renderHeightOff = (int)Math.floor(scaleFactorY * (double)renderHeightOff) - 1;
            renderWidthOff = (int)Math.floor(scaleFactorX * (double)renderWidthOff) - 1;
        }
        this.glDpiAwareViewport(renderWidthOff, renderCanvasHeight - renderViewportHeight - renderHeightOff, renderViewportWidth, renderViewportHeight);
        GL33C.glUseProgram((int)glProgram);
        int drawDistance = this.getDrawDistance();
        int fogDepth = this.config.fogDepth();
        GL33C.glUniform1i((int)this.uniUseFog, (int)(fogDepth > 0 ? 1 : 0));
        GL33C.glUniform4f((int)this.uniFogColor, (float)((float)(sky >> 16 & 0xFF) / 255.0f), (float)((float)(sky >> 8 & 0xFF) / 255.0f), (float)((float)(sky & 0xFF) / 255.0f), (float)1.0f);
        GL33C.glUniform1i((int)this.uniFogDepth, (int)fogDepth);
        GL33C.glUniform1i((int)this.uniDrawDistance, (int)(drawDistance * 128));
        GL33C.glUniform1i((int)this.uniExpandedMapLoadingChunks, (int)this.client.getExpandedMapLoading());
        TextureProvider textureProvider = this.client.getTextureProvider();
        GL33C.glUniform1f((int)this.uniBrightness, (float)((float)textureProvider.getBrightness()));
        GL33C.glUniform1f((int)this.uniSmoothBanding, (float)(this.config.smoothBanding() ? 0.0f : 1.0f));
        GL33C.glUniform1f((int)this.uniTextureLightMode, (float)(this.config.brightTextures() ? 1.0f : 0.0f));
        if (this.client.getGameState() == GameState.LOGGED_IN) {
            GL33C.glUniform1i((int)this.uniTick, (int)(this.client.getGameCycle() & 0x7F));
        }
        float[] projectionMatrix = Mat4.scale(this.client.getScale(), this.client.getScale(), 1.0f);
        Mat4.mul(projectionMatrix, Mat4.projection(viewportWidth, viewportHeight, 50.0f));
        Mat4.mul(projectionMatrix, Mat4.rotateX(cameraPitch));
        Mat4.mul(projectionMatrix, Mat4.rotateY(cameraYaw));
        Mat4.mul(projectionMatrix, Mat4.translate(-cameraX, -cameraY, -cameraZ));
        GL33C.glUniformMatrix4fv((int)this.uniWorldProj, (boolean)false, (float[])projectionMatrix);
        projectionMatrix = Mat4.identity();
        GL33C.glUniformMatrix4fv((int)uniEntityProj, (boolean)false, (float[])projectionMatrix);
        GL33C.glUniform4i((int)uniEntityTint, (int)0, (int)0, (int)0, (int)0);
        GL33C.glUniformBlockBinding((int)glProgram, (int)this.uniBlockMain, (int)0);
        GL33C.glUniform1i((int)this.uniTextures, (int)1);
        GL33C.glEnable((int)2884);
        GL33C.glEnable((int)3042);
        GL33C.glBlendFuncSeparate((int)770, (int)771, (int)1, (int)1);
        GL33C.glDepthFunc((int)516);
        GL33C.glEnable((int)2929);
        this.checkGLErrors();
    }

    public void postSceneDraw(Scene scene) {
        if (scene.getWorldViewId() == -1) {
            this.postDrawToplevel();
        } else {
            GL33C.glUniform4i((int)uniEntityTint, (int)0, (int)0, (int)0, (int)0);
        }
    }

    private void postDrawToplevel() {
        GL33C.glDisable((int)3042);
        GL33C.glDisable((int)2884);
        GL33C.glDisable((int)2929);
        GL33C.glBindFramebuffer((int)36009, (int)this.awtContext.getFramebuffer(false));
        this.sceneFboValid = true;
    }

    private void blitSceneFbo() {
        int width = this.lastStretchedCanvasWidth;
        int height = this.lastStretchedCanvasHeight;
        GraphicsConfiguration graphicsConfiguration = this.clientUI.getGraphicsConfiguration();
        AffineTransform transform = graphicsConfiguration.getDefaultTransform();
        width = this.getScaledValue(transform.getScaleX(), width);
        height = this.getScaledValue(transform.getScaleY(), height);
        int defaultFbo = this.awtContext.getFramebuffer(false);
        GL33C.glBindFramebuffer((int)36008, (int)this.fboScene);
        GL33C.glBindFramebuffer((int)36009, (int)defaultFbo);
        GL33C.glBlitFramebuffer((int)0, (int)0, (int)width, (int)height, (int)0, (int)0, (int)width, (int)height, (int)16384, (int)9728);
        GL33C.glBindFramebuffer((int)36008, (int)defaultFbo);
        this.checkGLErrors();
    }

    public void drawZoneOpaque(Projection entityProjection, Scene scene, int zx, int zz) {
        GpuPlugin.updateEntityProjection(entityProjection);
        SceneContext ctx = this.context(scene);
        if (ctx == null) {
            return;
        }
        Zone z = ctx.zones[zx][zz];
        if (!z.initialized) {
            return;
        }
        int offset = scene.getWorldViewId() == -1 ? 5 : 0;
        z.renderOpaque(zx - offset, zz - offset, this.minLevel, this.level, this.maxLevel, this.hideRoofIds);
        this.checkGLErrors();
    }

    public void drawZoneAlpha(Projection entityProjection, Scene scene, int level, int zx, int zz) {
        boolean close;
        GpuPlugin.updateEntityProjection(entityProjection);
        SceneContext ctx = this.context(scene);
        if (ctx == null) {
            return;
        }
        this.vaoA.unmap();
        Zone z = ctx.zones[zx][zz];
        if (!z.initialized) {
            return;
        }
        int offset = scene.getWorldViewId() == -1 ? 5 : 0;
        int dx = this.cameraX - (zx - offset << 10);
        int dz = this.cameraZ - (zz - offset << 10);
        boolean bl = close = dx * dx + dz * dz < 0x400000;
        if (level == 0) {
            z.alphaSort(zx - offset, zz - offset, this.cameraX, this.cameraY, this.cameraZ);
            z.multizoneLocs(scene, zx - offset, zz - offset, this.cameraX, this.cameraZ, ctx.zones);
        }
        z.renderAlpha(zx - offset, zz - offset, this.cameraYaw, this.cameraPitch, this.minLevel, this.level, this.maxLevel, level, this.hideRoofIds, !close);
        this.checkGLErrors();
    }

    public void drawPass(Projection projection, Scene scene, int pass) {
        block8: {
            SceneContext ctx;
            block7: {
                VAO vao;
                int i;
                ctx = this.context(scene);
                if (ctx == null) {
                    return;
                }
                GpuPlugin.updateEntityProjection(projection);
                if (pass != 0) break block7;
                this.vaoO.addRange(projection, scene);
                this.vaoPO.addRange(projection, scene);
                if (scene.getWorldViewId() != -1) break block8;
                GL33C.glUniform3i((int)uniBase, (int)0, (int)0, (int)0);
                int sz = this.vaoO.unmap();
                for (i = 0; i < sz; ++i) {
                    vao = this.vaoO.vaos.get(i);
                    vao.draw();
                    vao.reset();
                }
                sz = this.vaoPO.unmap();
                if (sz <= 0) break block8;
                GL33C.glDepthMask((boolean)false);
                for (i = 0; i < sz; ++i) {
                    vao = this.vaoPO.vaos.get(i);
                    vao.draw();
                }
                GL33C.glDepthMask((boolean)true);
                GL33C.glColorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
                for (i = 0; i < sz; ++i) {
                    vao = this.vaoPO.vaos.get(i);
                    vao.draw();
                    vao.reset();
                }
                GL33C.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
                break block8;
            }
            if (pass == 1) {
                for (int x = 0; x < ctx.sizeX; ++x) {
                    for (int z = 0; z < ctx.sizeZ; ++z) {
                        Zone zone = ctx.zones[x][z];
                        zone.removeTemp();
                    }
                }
            }
        }
        this.checkGLErrors();
    }

    public void drawDynamic(Projection worldProjection, Scene scene, TileObject tileObject, Renderable r, Model m, int orient, int x, int y, int z) {
        SceneContext ctx = this.context(scene);
        if (ctx == null) {
            return;
        }
        if (!this.renderCallbackManager.drawObject(scene, tileObject)) {
            return;
        }
        int size = m.getFaceCount() * 3 * 24;
        if (m.getFaceTransparencies() == null) {
            VAO o = this.vaoO.get(size);
            this.clientUploader.uploadTempModel(m, orient, x, y, z, o.vbo.vb);
        } else {
            m.calculateBoundsCylinder();
            VAO o = this.vaoO.get(size);
            VAO a = this.vaoA.get(size);
            int start = a.vbo.vb.position();
            try {
                this.facePrioritySorter.uploadSortedModel(worldProjection, m, orient, x, y, z, o.vbo.vb, a.vbo.vb);
            }
            catch (Exception ex) {
                log.debug("error drawing entity", (Throwable)ex);
            }
            int end = a.vbo.vb.position();
            if (end > start) {
                int offset = scene.getWorldViewId() == -1 ? 40 : 0;
                int zx = (x >> 10) + (offset >> 3);
                int zz = (z >> 10) + (offset >> 3);
                Zone zone = ctx.zones[zx][zz];
                int plane = Math.min(this.maxLevel, tileObject.getPlane());
                zone.addTempAlphaModel(a.vao, start, end, plane, x & 0x3FF, y, z & 0x3FF);
            }
        }
    }

    public void drawTemp(Projection worldProjection, Scene scene, GameObject gameObject, Model m, int orient, int x, int y, int z) {
        SceneContext ctx = this.context(scene);
        if (ctx == null) {
            return;
        }
        if (!this.renderCallbackManager.drawObject(scene, (TileObject)gameObject)) {
            return;
        }
        Renderable renderable = gameObject.getRenderable();
        int size = m.getFaceCount() * 3 * 24;
        if (renderable instanceof Player || m.getFaceTransparencies() != null) {
            VAO o = renderable instanceof Player ? this.vaoPO.get(size) : this.vaoO.get(size);
            VAO a = this.vaoA.get(size);
            int start = a.vbo.vb.position();
            m.calculateBoundsCylinder();
            try {
                this.facePrioritySorter.uploadSortedModel(worldProjection, m, orient, x, y, z, o.vbo.vb, a.vbo.vb);
            }
            catch (Exception ex) {
                log.debug("error drawing entity", (Throwable)ex);
            }
            int end = a.vbo.vb.position();
            if (end > start) {
                int offset = scene.getWorldViewId() == -1 ? 5 : 0;
                int zx = (gameObject.getX() >> 10) + offset;
                int zz = (gameObject.getY() >> 10) + offset;
                Zone zone = ctx.zones[zx][zz];
                zone.addTempAlphaModel(a.vao, start, end, gameObject.getPlane(), x & 0x3FF, y - renderable.getModelHeight(), z & 0x3FF);
            }
        } else {
            VAO o = this.vaoO.get(size);
            this.clientUploader.uploadTempModel(m, orient, x, y, z, o.vbo.vb);
        }
    }

    public void invalidateZone(Scene scene, int zx, int zz) {
        SceneContext ctx = this.context(scene);
        if (ctx == null) {
            return;
        }
        Zone z = ctx.zones[zx][zz];
        if (!z.invalidate) {
            z.invalidate = true;
            log.debug("Zone invalidated: wx={} x={} z={}", new Object[]{scene.getWorldViewId(), zx, zz});
        }
    }

    @Subscribe
    public void onPostClientTick(PostClientTick event) {
        WorldView wv = this.client.getTopLevelWorldView();
        if (wv == null) {
            return;
        }
        this.rebuild(wv);
        for (WorldEntity we : wv.worldEntities()) {
            wv = we.getWorldView();
            this.rebuild(wv);
        }
    }

    private void rebuild(WorldView wv) {
        SceneContext ctx = this.context(wv);
        if (ctx == null) {
            return;
        }
        for (int x = 0; x < ctx.sizeX; ++x) {
            for (int z = 0; z < ctx.sizeZ; ++z) {
                Zone zone = ctx.zones[x][z];
                if (!zone.invalidate) continue;
                assert (zone.initialized);
                zone.free();
                Zone zone2 = new Zone();
                ctx.zones[x][z] = zone2;
                zone = zone2;
                Scene scene = wv.getScene();
                this.clientUploader.zoneSize(scene, zone, x, z);
                VBO o = null;
                VBO a = null;
                int sz = zone.sizeO * 20 * 3;
                if (sz > 0) {
                    o = new VBO(sz);
                    o.init(35044);
                    o.map();
                }
                if ((sz = zone.sizeA * 20 * 3) > 0) {
                    a = new VBO(sz);
                    a.init(35044);
                    a.map();
                }
                zone.init(o, a);
                this.clientUploader.uploadZone(scene, zone, x, z);
                zone.unmap();
                zone.initialized = true;
                zone.dirty = true;
                log.debug("Rebuilt zone wv={} x={} z={}", new Object[]{wv.getId(), x, z});
            }
        }
    }

    private void prepareInterfaceTexture(int canvasWidth, int canvasHeight) {
        if (canvasWidth != this.lastCanvasWidth || canvasHeight != this.lastCanvasHeight) {
            this.lastCanvasWidth = canvasWidth;
            this.lastCanvasHeight = canvasHeight;
            GL33C.glBindBuffer((int)35052, (int)this.interfacePbo);
            GL33C.glBufferData((int)35052, (long)((long)(canvasWidth * canvasHeight) * 4L), (int)35040);
            GL33C.glBindBuffer((int)35052, (int)0);
            GL33C.glBindTexture((int)3553, (int)this.interfaceTexture);
            GL33C.glTexImage2D((int)3553, (int)0, (int)6408, (int)canvasWidth, (int)canvasHeight, (int)0, (int)32993, (int)5121, (long)0L);
            GL33C.glBindTexture((int)3553, (int)0);
        }
        BufferProvider bufferProvider = this.client.getBufferProvider();
        int[] pixels = bufferProvider.getPixels();
        int width = bufferProvider.getWidth();
        int height = bufferProvider.getHeight();
        GL33C.glBindBuffer((int)35052, (int)this.interfacePbo);
        ByteBuffer interfaceBuf = GL33C.glMapBuffer((int)35052, (int)35001);
        if (interfaceBuf != null) {
            interfaceBuf.asIntBuffer().put(pixels, 0, width * height);
            GL33C.glUnmapBuffer((int)35052);
        }
        GL33C.glBindTexture((int)3553, (int)this.interfaceTexture);
        GL33C.glTexSubImage2D((int)3553, (int)0, (int)0, (int)0, (int)width, (int)height, (int)32993, (int)33639, (long)0L);
        GL33C.glBindBuffer((int)35052, (int)0);
        GL33C.glBindTexture((int)3553, (int)0);
    }

    public void draw(int overlayColor) {
        GameState gameState = this.client.getGameState();
        if (gameState == GameState.STARTING) {
            return;
        }
        TextureProvider textureProvider = this.client.getTextureProvider();
        if (this.textureArrayId == -1 && textureProvider != null) {
            this.textureArrayId = this.textureManager.initTextureArray(textureProvider);
            if (this.textureArrayId > -1) {
                float[] texAnims = this.textureManager.computeTextureAnimations(textureProvider);
                GL33C.glUseProgram((int)glProgram);
                GL33C.glUniform2fv((int)this.uniTextureAnimations, (float[])texAnims);
                GL33C.glUseProgram((int)0);
            }
        }
        int canvasHeight = this.client.getCanvasHeight();
        int canvasWidth = this.client.getCanvasWidth();
        this.prepareInterfaceTexture(canvasWidth, canvasHeight);
        GL33C.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GL33C.glClear((int)16384);
        if (this.sceneFboValid) {
            this.blitSceneFbo();
        }
        this.drawUi(overlayColor, canvasHeight, canvasWidth);
        try {
            this.awtContext.swapBuffers();
        }
        catch (RuntimeException ex) {
            if (!this.canvas.isValid()) {
                return;
            }
            log.error("error swapping buffers", (Throwable)ex);
            SwingUtilities.invokeLater(() -> {
                try {
                    this.pluginManager.stopPlugin(this);
                }
                catch (PluginInstantiationException ex2) {
                    log.error("error stopping plugin", (Throwable)ex2);
                }
            });
            return;
        }
        this.drawManager.processDrawComplete(this::screenshot);
        GL33C.glBindFramebuffer((int)36160, (int)this.awtContext.getFramebuffer(false));
        this.checkGLErrors();
    }

    private void drawUi(int overlayColor, int canvasHeight, int canvasWidth) {
        GL33C.glEnable((int)3042);
        GL33C.glBlendFunc((int)1, (int)771);
        GL33C.glBindTexture((int)3553, (int)this.interfaceTexture);
        UIScalingMode uiScalingMode = this.config.uiScalingMode();
        GL33C.glUseProgram((int)this.glUiProgram);
        GL33C.glUniform1i((int)this.uniTex, (int)0);
        GL33C.glUniform2i((int)this.uniTexSourceDimensions, (int)canvasWidth, (int)canvasHeight);
        GL33C.glUniform4f((int)this.uniUiAlphaOverlay, (float)((float)(overlayColor >> 16 & 0xFF) / 255.0f), (float)((float)(overlayColor >> 8 & 0xFF) / 255.0f), (float)((float)(overlayColor & 0xFF) / 255.0f), (float)((float)(overlayColor >>> 24) / 255.0f));
        if (this.client.isStretchedEnabled()) {
            Dimension dim = this.client.getStretchedDimensions();
            this.glDpiAwareViewport(0, 0, dim.width, dim.height);
            GL33C.glUniform2i((int)this.uniTexTargetDimensions, (int)dim.width, (int)dim.height);
        } else {
            this.glDpiAwareViewport(0, 0, canvasWidth, canvasHeight);
            GraphicsConfiguration graphicsConfiguration = this.clientUI.getGraphicsConfiguration();
            AffineTransform t = graphicsConfiguration.getDefaultTransform();
            GL33C.glUniform2i((int)this.uniTexTargetDimensions, (int)this.getScaledValue(t.getScaleX(), canvasWidth), (int)this.getScaledValue(t.getScaleY(), canvasHeight));
        }
        int function = uiScalingMode == UIScalingMode.LINEAR || uiScalingMode == UIScalingMode.HYBRID ? 9729 : 9728;
        GL33C.glTexParameteri((int)3553, (int)10241, (int)function);
        GL33C.glTexParameteri((int)3553, (int)10240, (int)function);
        GL33C.glBindVertexArray((int)this.vaoUiHandle);
        GL33C.glDrawArrays((int)6, (int)0, (int)4);
        GL33C.glBindTexture((int)3553, (int)0);
        GL33C.glBindVertexArray((int)0);
        GL33C.glUseProgram((int)0);
        GL33C.glBlendFunc((int)770, (int)771);
        GL33C.glDisable((int)3042);
    }

    private Image screenshot() {
        int width = this.client.getCanvasWidth();
        int height = this.client.getCanvasHeight();
        if (this.client.isStretchedEnabled()) {
            Dimension dim = this.client.getStretchedDimensions();
            width = dim.width;
            height = dim.height;
        }
        GraphicsConfiguration graphicsConfiguration = this.clientUI.getGraphicsConfiguration();
        AffineTransform t = graphicsConfiguration.getDefaultTransform();
        width = this.getScaledValue(t.getScaleX(), width);
        height = this.getScaledValue(t.getScaleY(), height);
        ByteBuffer buffer = ByteBuffer.allocateDirect(width * height * 4).order(ByteOrder.nativeOrder());
        GL33C.glReadBuffer((int)this.awtContext.getBufferMode());
        GL33C.glReadPixels((int)0, (int)0, (int)width, (int)height, (int)6408, (int)5121, (ByteBuffer)buffer);
        BufferedImage image = new BufferedImage(width, height, 1);
        int[] pixels = ((DataBufferInt)image.getRaster().getDataBuffer()).getData();
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int r = buffer.get() & 0xFF;
                int g = buffer.get() & 0xFF;
                int b = buffer.get() & 0xFF;
                buffer.get();
                pixels[(height - y - 1) * width + x] = r << 16 | g << 8 | b;
            }
        }
        return image;
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged gameStateChanged) {
        GameState state = gameStateChanged.getGameState();
        if (state.getState() < GameState.LOADING.getState()) {
            this.sceneFboValid = false;
        }
        if (state == GameState.STARTING) {
            if (this.textureArrayId != -1) {
                this.textureManager.freeTextureArray(this.textureArrayId);
            }
            this.textureArrayId = -1;
            this.lastAnisotropicFilteringLevel = -1;
        }
    }

    public void loadScene(WorldView worldView, Scene scene) {
        if (scene.getWorldViewId() > -1) {
            this.loadSubScene(worldView, scene);
            return;
        }
        assert (scene.getWorldViewId() == -1);
        if (this.nextZones != null) {
            throw new RuntimeException("Double zone load!");
        }
        SceneContext ctx = this.root;
        Scene prev = this.client.getTopLevelWorldView().getScene();
        this.regionManager.prepare(scene);
        int dx = scene.getBaseX() - prev.getBaseX() >> 3;
        int dy = scene.getBaseY() - prev.getBaseY() >> 3;
        int SCENE_ZONES = 23;
        for (int x = 0; x < 23; ++x) {
            for (int z = 0; z < 23; ++z) {
                ctx.zones[x][z].cull = true;
            }
        }
        Zone[][] newZones = new Zone[23][23];
        GameState gameState = this.client.getGameState();
        if (prev.isInstance() == scene.isInstance() && gameState == GameState.LOGGED_IN) {
            int[][][] prevTemplates = prev.getInstanceTemplateChunks();
            int[][][] curTemplates = scene.getInstanceTemplateChunks();
            for (int x = 0; x < 23; ++x) {
                block5: for (int z = 0; z < 23; ++z) {
                    int ox = x + dx;
                    int oz = z + dy;
                    if (!GpuPlugin.canReuse(ctx.zones, ox, oz)) continue;
                    if (scene.isInstance()) {
                        int jx = x - 5;
                        int jz = z - 5;
                        int jox = ox - 5;
                        int joz = oz - 5;
                        if (jx >= 0 && jx < 13 && jz >= 0 && jz < 13 && jox >= 0 && jox < 13 && joz >= 0 && joz < 13) {
                            for (int level = 0; level < 4; ++level) {
                                int prevTemplate = prevTemplates[level][jox][joz];
                                int curTemplate = curTemplates[level][jx][jz];
                                if (prevTemplate == curTemplate) continue;
                                log.error("Instance template reuse mismatch! prev={} cur={}", (Object)prevTemplate, (Object)curTemplate);
                                continue block5;
                            }
                        }
                    }
                    Zone old = ctx.zones[ox][oz];
                    assert (old.initialized);
                    if (old.dirty) continue;
                    assert (old.sizeO > 0 || old.sizeA > 0);
                    assert (old.cull);
                    old.cull = false;
                    newZones[x][z] = old;
                }
            }
        }
        for (int x = 0; x < 23; ++x) {
            for (int z = 0; z < 23; ++z) {
                if (newZones[x][z] != null) continue;
                newZones[x][z] = new Zone();
            }
        }
        Stopwatch sw = Stopwatch.createStarted();
        int len = 0;
        int lena = 0;
        int reused = 0;
        int newzones = 0;
        for (int x = 0; x < 23; ++x) {
            for (int z = 0; z < 23; ++z) {
                Zone zone = newZones[x][z];
                if (!zone.initialized) {
                    assert (zone.glVao == 0);
                    assert (zone.glVaoA == 0);
                    this.mapUploader.zoneSize(scene, zone, x, z);
                    len += zone.sizeO;
                    lena += zone.sizeA;
                    ++newzones;
                    continue;
                }
                ++reused;
            }
        }
        log.debug("Scene size time {} reused {} new {} len opaque {} size opaque {}kb len alpha {} size alpha {}kb", new Object[]{sw, reused, newzones, len, len * 20 * 3 / 1024, lena, lena * 20 * 3 / 1024});
        CountDownLatch latch = new CountDownLatch(1);
        this.clientThread.invoke(() -> {
            for (int x = 0; x < 23; ++x) {
                for (int z = 0; z < 23; ++z) {
                    Zone zone = newZones[x][z];
                    if (zone.initialized) continue;
                    VBO o = null;
                    VBO a = null;
                    int sz = zone.sizeO * 20 * 3;
                    if (sz > 0) {
                        o = new VBO(sz);
                        o.init(35044);
                        o.map();
                    }
                    if ((sz = zone.sizeA * 20 * 3) > 0) {
                        a = new VBO(sz);
                        a.init(35044);
                        a.map();
                    }
                    zone.init(o, a);
                }
            }
            latch.countDown();
        });
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        sw = Stopwatch.createStarted();
        for (int x = 0; x < 23; ++x) {
            for (int z = 0; z < 23; ++z) {
                Zone zone = newZones[x][z];
                if (zone.initialized) continue;
                this.mapUploader.uploadZone(scene, zone, x, z);
            }
        }
        log.debug("Scene upload time {}", (Object)sw);
        int[][][] prids = prev.getRoofs();
        int[][][] nrids = scene.getRoofs();
        dx <<= 3;
        dy <<= 3;
        HashMap<Integer, Integer> roofChanges = new HashMap<Integer, Integer>();
        sw = Stopwatch.createStarted();
        for (int level = 0; level < 4; ++level) {
            for (int x = 0; x < 184; ++x) {
                for (int z = 0; z < 184; ++z) {
                    int ox = x + dx;
                    int oz = z + dy;
                    if (ox < 0 || oz < 0 || ox >= 184 || oz >= 184) continue;
                    int prid = prids[level][ox][oz];
                    int nrid = nrids[level][x][z];
                    if (prid <= 0 || nrid <= 0 || prid == nrid) continue;
                    Integer old = roofChanges.putIfAbsent(prid, nrid);
                    if (old == null) {
                        log.trace("Roof change: {} -> {}", (Object)prid, (Object)nrid);
                        continue;
                    }
                    if (old == nrid) continue;
                    log.debug("Roof change mismatch: {} -> {} vs {}", new Object[]{prid, nrid, old});
                }
            }
        }
        sw.stop();
        log.debug("Roof remapping time {}", (Object)sw);
        this.nextZones = newZones;
        this.nextRoofChanges = roofChanges;
    }

    private static boolean canReuse(Zone[][] zones, int zx, int zz) {
        for (int x = zx - 1; x <= zx + 1; ++x) {
            if (x < 0 || x >= 23) {
                return false;
            }
            for (int z = zz - 1; z <= zz + 1; ++z) {
                if (z < 0 || z >= 23) {
                    return false;
                }
                Zone zone = zones[x][z];
                if (!zone.initialized) {
                    return false;
                }
                if (zone.sizeO != 0 || zone.sizeA != 0) continue;
                return false;
            }
        }
        return true;
    }

    private void loadSubScene(WorldView worldView, Scene scene) {
        SceneContext ctx;
        int worldViewId = scene.getWorldViewId();
        assert (worldViewId != -1);
        log.debug("Loading world view {}", (Object)worldViewId);
        SceneContext ctx0 = this.subs[worldViewId];
        if (ctx0 != null) {
            log.info("Reload of an already loaded worldview?");
            return;
        }
        this.subs[worldViewId] = ctx = new SceneContext(worldView.getSizeX() >> 3, worldView.getSizeY() >> 3);
        for (int x = 0; x < ctx.sizeX; ++x) {
            for (int z = 0; z < ctx.sizeZ; ++z) {
                Zone zone = ctx.zones[x][z];
                this.mapUploader.zoneSize(scene, zone, x, z);
            }
        }
        CountDownLatch latch = new CountDownLatch(1);
        this.clientThread.invoke(() -> {
            for (int x = 0; x < ctx.sizeX; ++x) {
                for (int z = 0; z < ctx.sizeZ; ++z) {
                    Zone zone = ctx.zones[x][z];
                    VBO o = null;
                    VBO a = null;
                    int sz = zone.sizeO * 20 * 3;
                    if (sz > 0) {
                        o = new VBO(sz);
                        o.init(35044);
                        o.map();
                    }
                    if ((sz = zone.sizeA * 20 * 3) > 0) {
                        a = new VBO(sz);
                        a.init(35044);
                        a.map();
                    }
                    zone.init(o, a);
                }
            }
            latch.countDown();
        });
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        for (int x = 0; x < ctx.sizeX; ++x) {
            for (int z = 0; z < ctx.sizeZ; ++z) {
                Zone zone = ctx.zones[x][z];
                this.mapUploader.uploadZone(scene, zone, x, z);
            }
        }
    }

    public void despawnWorldView(WorldView worldView) {
        int worldViewId = worldView.getId();
        if (worldViewId > -1) {
            log.debug("WorldView despawn: {}", (Object)worldViewId);
            SceneContext sub = this.subs[worldViewId];
            if (sub == null) {
                return;
            }
            sub.free();
            this.subs[worldViewId] = null;
        }
    }

    public void swapScene(Scene scene) {
        Zone zone;
        int z;
        int x;
        if (scene.getWorldViewId() > -1) {
            this.swapSub(scene);
            return;
        }
        SceneContext ctx = this.root;
        for (x = 0; x < ctx.sizeX; ++x) {
            for (z = 0; z < ctx.sizeZ; ++z) {
                zone = ctx.zones[x][z];
                if (zone.cull) {
                    zone.free();
                    continue;
                }
                zone.updateRoofs(this.nextRoofChanges);
            }
        }
        this.nextRoofChanges = null;
        ctx.zones = this.nextZones;
        this.nextZones = null;
        for (x = 0; x < ctx.zones.length; ++x) {
            for (z = 0; z < ctx.zones[0].length; ++z) {
                zone = ctx.zones[x][z];
                if (zone.initialized) continue;
                zone.unmap();
                zone.initialized = true;
            }
        }
        this.checkGLErrors();
    }

    private void swapSub(Scene scene) {
        SceneContext ctx = this.context(scene);
        if (ctx == null) {
            return;
        }
        for (int x = 0; x < ctx.sizeX; ++x) {
            for (int z = 0; z < ctx.sizeZ; ++z) {
                Zone zone = ctx.zones[x][z];
                if (zone.initialized) continue;
                zone.unmap();
                zone.initialized = true;
            }
        }
        log.debug("WorldView ready: {}", (Object)scene.getWorldViewId());
    }

    private int getScaledValue(double scale, int value) {
        return (int)((double)value * scale);
    }

    private void glDpiAwareViewport(int x, int y, int width, int height) {
        GraphicsConfiguration graphicsConfiguration = this.clientUI.getGraphicsConfiguration();
        AffineTransform t = graphicsConfiguration.getDefaultTransform();
        GL33C.glViewport((int)this.getScaledValue(t.getScaleX(), x), (int)this.getScaledValue(t.getScaleY(), y), (int)this.getScaledValue(t.getScaleX(), width), (int)this.getScaledValue(t.getScaleY(), height));
    }

    private int getDrawDistance() {
        return Ints.constrainToRange((int)this.config.drawDistance(), (int)0, (int)184);
    }

    private void checkGLErrors() {
        if (!log.isDebugEnabled()) {
            return;
        }
        int err;
        while ((err = GL33C.glGetError()) != 0) {
            Object errStr;
            switch (err) {
                case 1280: {
                    errStr = "INVALID_ENUM";
                    break;
                }
                case 1281: {
                    errStr = "INVALID_VALUE";
                    break;
                }
                case 1282: {
                    errStr = "INVALID_OPERATION";
                    break;
                }
                case 1286: {
                    errStr = "INVALID_FRAMEBUFFER_OPERATION";
                    break;
                }
                default: {
                    errStr = "" + err;
                }
            }
            log.debug("glGetError:", (Throwable)new Exception((String)errStr));
        }
        return;
    }

    static class SceneContext {
        final int sizeX;
        final int sizeZ;
        Zone[][] zones;

        SceneContext(int sizeX, int sizeZ) {
            this.sizeX = sizeX;
            this.sizeZ = sizeZ;
            this.zones = new Zone[sizeX][sizeZ];
            for (int x = 0; x < sizeX; ++x) {
                for (int z = 0; z < sizeZ; ++z) {
                    this.zones[x][z] = new Zone();
                }
            }
        }

        void free() {
            for (int x = 0; x < this.sizeX; ++x) {
                for (int z = 0; z < this.sizeZ; ++z) {
                    this.zones[x][z].free();
                }
            }
        }
    }
}

