/*
 * Copyright (c) 2018, Tomas Slusny <slusnucky@gmail.com>
 * Copyright (c) 2018, Seth <Sethtroll3@gmail.com>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice, this
 *    list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package net.runelite.client.game;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import javax.annotation.Nullable;
import lombok.Getter;
import net.runelite.api.gameval.ItemID;

/**
 * Converts untradeable items to it's tradeable counterparts
 */
@Getter
public enum ItemMapping
{
	// Barrows equipment
	ITEM_AHRIMS_HOOD(ItemID.BARROWS_AHRIM_HEAD, ItemID.BARROWS_AHRIM_HEAD_25, ItemID.BARROWS_AHRIM_HEAD_50, ItemID.BARROWS_AHRIM_HEAD_75, ItemID.BARROWS_AHRIM_HEAD_100, ItemID.BARROWS_AHRIM_HEAD_ORNAMENT, ItemID.BARROWS_AHRIM_HEAD_ORNAMENT_25, ItemID.BARROWS_AHRIM_HEAD_ORNAMENT_50, ItemID.BARROWS_AHRIM_HEAD_ORNAMENT_75, ItemID.BARROWS_AHRIM_HEAD_ORNAMENT_100),
	ITEM_AHRIMS_HOOD_0(ItemID.BARROWS_AHRIM_HEAD_BROKEN, ItemID.BARROWS_AHRIM_HEAD_ORNAMENT_BROKEN),
	ITEM_AHRIMS_ROBETOP(ItemID.BARROWS_AHRIM_BODY, ItemID.BARROWS_AHRIM_BODY_25, ItemID.BARROWS_AHRIM_BODY_50, ItemID.BARROWS_AHRIM_BODY_75, ItemID.BARROWS_AHRIM_BODY_100, ItemID.BARROWS_AHRIM_BODY_ORNAMENT, ItemID.BARROWS_AHRIM_BODY_ORNAMENT_25, ItemID.BARROWS_AHRIM_BODY_ORNAMENT_50, ItemID.BARROWS_AHRIM_BODY_ORNAMENT_75, ItemID.BARROWS_AHRIM_BODY_ORNAMENT_100),
	ITEM_AHRIMS_ROBETOP_0(ItemID.BARROWS_AHRIM_BODY_BROKEN, ItemID.BARROWS_AHRIM_BODY_ORNAMENT_BROKEN),
	ITEM_AHRIMS_ROBEBOTTOM(ItemID.BARROWS_AHRIM_LEGS, ItemID.BARROWS_AHRIM_LEGS_25, ItemID.BARROWS_AHRIM_LEGS_50, ItemID.BARROWS_AHRIM_LEGS_75, ItemID.BARROWS_AHRIM_LEGS_100, ItemID.BARROWS_AHRIM_LEGS_ORNAMENT, ItemID.BARROWS_AHRIM_LEGS_ORNAMENT_25, ItemID.BARROWS_AHRIM_LEGS_ORNAMENT_50, ItemID.BARROWS_AHRIM_LEGS_ORNAMENT_75, ItemID.BARROWS_AHRIM_LEGS_ORNAMENT_100),
	ITEM_AHRIMS_ROBEBOTTOM_0(ItemID.BARROWS_AHRIM_LEGS_BROKEN, ItemID.BARROWS_AHRIM_LEGS_ORNAMENT_BROKEN),
	ITEM_AHRIMS_STAFF(ItemID.BARROWS_AHRIM_WEAPON, ItemID.BARROWS_AHRIM_WEAPON_25, ItemID.BARROWS_AHRIM_WEAPON_50, ItemID.BARROWS_AHRIM_WEAPON_75, ItemID.BARROWS_AHRIM_WEAPON_100, ItemID.BARROWS_AHRIM_WEAPON_ORNAMENT, ItemID.BARROWS_AHRIM_WEAPON_ORNAMENT_25, ItemID.BARROWS_AHRIM_WEAPON_ORNAMENT_50, ItemID.BARROWS_AHRIM_WEAPON_ORNAMENT_75, ItemID.BARROWS_AHRIM_WEAPON_ORNAMENT_100),
	ITEM_AHRIMS_STAFF_0(ItemID.BARROWS_AHRIM_WEAPON_BROKEN, ItemID.BARROWS_AHRIM_WEAPON_ORNAMENT_BROKEN),
	ITEM_ECHO_AHRIMS_HOOD(ItemID.BARROWS_AHRIM_HEAD_ORNAMENT, ItemID.BARROWS_AHRIM_HEAD_ORNAMENT_25, ItemID.BARROWS_AHRIM_HEAD_ORNAMENT_50, ItemID.BARROWS_AHRIM_HEAD_ORNAMENT_75, ItemID.BARROWS_AHRIM_HEAD_ORNAMENT_100),
	ITEM_ECHO_AHRIMS_ROBETOP(ItemID.BARROWS_AHRIM_BODY_ORNAMENT, ItemID.BARROWS_AHRIM_BODY_ORNAMENT_25, ItemID.BARROWS_AHRIM_BODY_ORNAMENT_50, ItemID.BARROWS_AHRIM_BODY_ORNAMENT_75, ItemID.BARROWS_AHRIM_BODY_ORNAMENT_100),
	ITEM_ECHO_AHRIMS_ROBEBOTTOM(ItemID.BARROWS_AHRIM_LEGS_ORNAMENT, ItemID.BARROWS_AHRIM_LEGS_ORNAMENT_25, ItemID.BARROWS_AHRIM_LEGS_ORNAMENT_50, ItemID.BARROWS_AHRIM_LEGS_ORNAMENT_75, ItemID.BARROWS_AHRIM_LEGS_ORNAMENT_100),
	ITEM_ECHO_AHRIMS_STAFF(ItemID.BARROWS_AHRIM_WEAPON_ORNAMENT, ItemID.BARROWS_AHRIM_WEAPON_ORNAMENT_25, ItemID.BARROWS_AHRIM_WEAPON_ORNAMENT_50, ItemID.BARROWS_AHRIM_WEAPON_ORNAMENT_75, ItemID.BARROWS_AHRIM_WEAPON_ORNAMENT_100),
	ITEM_KARILS_COIF(ItemID.BARROWS_KARIL_HEAD, ItemID.BARROWS_KARIL_HEAD_25, ItemID.BARROWS_KARIL_HEAD_50, ItemID.BARROWS_KARIL_HEAD_75, ItemID.BARROWS_KARIL_HEAD_100),
	ITEM_KARILS_LEATHERTOP(ItemID.BARROWS_KARIL_BODY, ItemID.BARROWS_KARIL_BODY_25, ItemID.BARROWS_KARIL_BODY_50, ItemID.BARROWS_KARIL_BODY_75, ItemID.BARROWS_KARIL_BODY_100),
	ITEM_KARILS_LEATHERSKIRT(ItemID.BARROWS_KARIL_LEGS, ItemID.BARROWS_KARIL_LEGS_25, ItemID.BARROWS_KARIL_LEGS_50, ItemID.BARROWS_KARIL_LEGS_75, ItemID.BARROWS_KARIL_LEGS_100),
	ITEM_KARILS_CROSSBOW(ItemID.BARROWS_KARIL_WEAPON, ItemID.BARROWS_KARIL_WEAPON_25, ItemID.BARROWS_KARIL_WEAPON_50, ItemID.BARROWS_KARIL_WEAPON_75, ItemID.BARROWS_KARIL_WEAPON_100),
	ITEM_DHAROKS_HELM(ItemID.BARROWS_DHAROK_HEAD, ItemID.BARROWS_DHAROK_HEAD_25, ItemID.BARROWS_DHAROK_HEAD_50, ItemID.BARROWS_DHAROK_HEAD_75, ItemID.BARROWS_DHAROK_HEAD_100),
	ITEM_DHAROKS_PLATEBODY(ItemID.BARROWS_DHAROK_BODY, ItemID.BARROWS_DHAROK_BODY_25, ItemID.BARROWS_DHAROK_BODY_50, ItemID.BARROWS_DHAROK_BODY_75, ItemID.BARROWS_DHAROK_BODY_100),
	ITEM_DHAROKS_PLATELEGS(ItemID.BARROWS_DHAROK_LEGS, ItemID.BARROWS_DHAROK_LEGS_25, ItemID.BARROWS_DHAROK_LEGS_50, ItemID.BARROWS_DHAROK_LEGS_75, ItemID.BARROWS_DHAROK_LEGS_100),
	ITEM_DHAROKS_GREATEAXE(ItemID.BARROWS_DHAROK_WEAPON, ItemID.BARROWS_DHAROK_WEAPON_25, ItemID.BARROWS_DHAROK_WEAPON_50, ItemID.BARROWS_DHAROK_WEAPON_75, ItemID.BARROWS_DHAROK_WEAPON_100),
	ITEM_GUTHANS_HELM(ItemID.BARROWS_GUTHAN_HEAD, ItemID.BARROWS_GUTHAN_HEAD_25, ItemID.BARROWS_GUTHAN_HEAD_50, ItemID.BARROWS_GUTHAN_HEAD_75, ItemID.BARROWS_GUTHAN_HEAD_100),
	ITEM_GUTHANS_PLATEBODY(ItemID.BARROWS_GUTHAN_BODY, ItemID.BARROWS_GUTHAN_BODY_25, ItemID.BARROWS_GUTHAN_BODY_50, ItemID.BARROWS_GUTHAN_BODY_75, ItemID.BARROWS_GUTHAN_BODY_100),
	ITEM_GUTHANS_CHAINSKIRT(ItemID.BARROWS_GUTHAN_LEGS, ItemID.BARROWS_GUTHAN_LEGS_25, ItemID.BARROWS_GUTHAN_LEGS_50, ItemID.BARROWS_GUTHAN_LEGS_75, ItemID.BARROWS_GUTHAN_LEGS_100),
	ITEM_GUTHANS_WARSPEAR(ItemID.BARROWS_GUTHAN_WEAPON, ItemID.BARROWS_GUTHAN_WEAPON_25, ItemID.BARROWS_GUTHAN_WEAPON_50, ItemID.BARROWS_GUTHAN_WEAPON_75, ItemID.BARROWS_GUTHAN_WEAPON_100),
	ITEM_TORAGS_HELM(ItemID.BARROWS_TORAG_HEAD, ItemID.BARROWS_TORAG_HEAD_25, ItemID.BARROWS_TORAG_HEAD_50, ItemID.BARROWS_TORAG_HEAD_75, ItemID.BARROWS_TORAG_HEAD_100),
	ITEM_TORAGS_PLATEBODY(ItemID.BARROWS_TORAG_BODY, ItemID.BARROWS_TORAG_BODY_25, ItemID.BARROWS_TORAG_BODY_50, ItemID.BARROWS_TORAG_BODY_75, ItemID.BARROWS_TORAG_BODY_100),
	ITEM_TORAGS_PLATELEGS(ItemID.BARROWS_TORAG_LEGS, ItemID.BARROWS_TORAG_LEGS_25, ItemID.BARROWS_TORAG_LEGS_50, ItemID.BARROWS_TORAG_LEGS_75, ItemID.BARROWS_TORAG_LEGS_100),
	ITEM_TORAGS_HAMMERS(ItemID.BARROWS_TORAG_WEAPON, ItemID.BARROWS_TORAG_WEAPON_25, ItemID.BARROWS_TORAG_WEAPON_50, ItemID.BARROWS_TORAG_WEAPON_75, ItemID.BARROWS_TORAG_WEAPON_100),
	ITEM_VERACS_HELM(ItemID.BARROWS_VERAC_HEAD, ItemID.BARROWS_VERAC_HEAD_25, ItemID.BARROWS_VERAC_HEAD_50, ItemID.BARROWS_VERAC_HEAD_75, ItemID.BARROWS_VERAC_HEAD_100),
	ITEM_VERACS_BRASSARD(ItemID.BARROWS_VERAC_BODY, ItemID.BARROWS_VERAC_BODY_25, ItemID.BARROWS_VERAC_BODY_50, ItemID.BARROWS_VERAC_BODY_75, ItemID.BARROWS_VERAC_BODY_100),
	ITEM_VERACS_PLATESKIRT(ItemID.BARROWS_VERAC_LEGS, ItemID.BARROWS_VERAC_LEGS_25, ItemID.BARROWS_VERAC_LEGS_50, ItemID.BARROWS_VERAC_LEGS_75, ItemID.BARROWS_VERAC_LEGS_100),
	ITEM_VERACS_FLAIL(ItemID.BARROWS_VERAC_WEAPON, ItemID.BARROWS_VERAC_WEAPON_25, ItemID.BARROWS_VERAC_WEAPON_50, ItemID.BARROWS_VERAC_WEAPON_75, ItemID.BARROWS_VERAC_WEAPON_100),

	// Dragon equipment ornament kits
	ITEM_DRAGON_2H_SWORD(ItemID.DRAGON_2H_SWORD, ItemID.BH_DRAGON_2H_SWORD_CORRUPTED),
	ITEM_DRAGON_BATTLEAXE(ItemID.DRAGON_BATTLEAXE, ItemID.BH_DRAGON_BATTLEAXE_CORRUPTED),
	ITEM_DRAGON_CLAWS(ItemID.DRAGON_CLAWS, ItemID.BH_DRAGON_CLAWS_CORRUPTED),
	ITEM_DRAGON_CROSSBOW(ItemID.XBOWS_CROSSBOW_DRAGON, ItemID.BH_XBOWS_CROSSBOW_DRAGON_CORRUPTED),
	ITEM_DRAGON_DAGGER(ItemID.DRAGON_DAGGER, ItemID.BH_DRAGON_DAGGER_CORRUPTED),
	ITEM_DRAGON_DAGGER_P(ItemID.DRAGON_DAGGER_P, ItemID.BH_DRAGON_DAGGER_P_CORRUPTED),
	ITEM_DRAGON_DAGGER_P_(ItemID.DRAGON_DAGGER_P_, ItemID.BH_DRAGON_DAGGER_P__CORRUPTED),
	ITEM_DRAGON_DAGGER_P__(ItemID.DRAGON_DAGGER_P__, ItemID.BH_DRAGON_DAGGER_P___CORRUPTED),
	ITEM_DRAGON_HALBERD(ItemID.DRAGON_HALBERD, ItemID.BH_DRAGON_HALBERD_CORRUPTED),
	// Dragon longsword and Dragon mace are included in "Bounty hunter" section
	ITEM_DRAGON_SCIMITAR(ItemID.DRAGON_SCIMITAR, ItemID.DRAGON_SCIMITAR_ORNAMENT, ItemID.BH_DRAGON_SCIMITAR_CORRUPTED),
	ITEM_DRAGON_SCIMITAR_ORNAMENT_KIT(ItemID.DRAGON_SCIMITAR_ORNAMENT_KIT, ItemID.DRAGON_SCIMITAR_ORNAMENT),
	ITEM_DRAGON_SPEAR(ItemID.DRAGON_SPEAR, ItemID.BH_DRAGON_SPEAR_CORRUPTED),
	ITEM_DRAGON_SPEAR_P(ItemID.DRAGON_SPEAR_P, ItemID.BH_DRAGON_SPEAR_P_CORRUPTED),
	ITEM_DRAGON_SPEAR_P_(ItemID.DRAGON_SPEAR_P_, ItemID.BH_DRAGON_SPEAR_P__CORRUPTED),
	ITEM_DRAGON_SPEAR_P__(ItemID.DRAGON_SPEAR_P__, ItemID.BH_DRAGON_SPEAR_P___CORRUPTED),
	ITEM_DRAGON_SWORD(ItemID.DRAGON_SHORTSWORD, ItemID.BH_DRAGON_SHORTSWORD_CORRUPTED),
	ITEM_DRAGON_WARHAMMER(ItemID.DRAGON_WARHAMMER, ItemID.BH_DRAGON_WARHAMMER_CORRUPTED),
	ITEM_DRAGON_DEFENDER(ItemID.DD_ORNAMENT_KIT, ItemID.DRAGON_PARRYINGDAGGER_T),
	ITEM_DRAGON_PICKAXE(ItemID.DRAGON_PICKAXE, ItemID.DRAGON_PICKAXE_PRETTY, ItemID.ZALCANO_PICKAXE, ItemID.TRAILBLAZER_PICKAXE_NO_INFERNAL, ItemID.TRAILBLAZER_RELOADED_PICKAXE_NO_INFERNAL),
	ITEM_DRAGON_PICKAXE_OR(ItemID.ZALCANO_PICKAXE_KIT, ItemID.ZALCANO_PICKAXE),
	ITEM_DRAGON_AXE(ItemID.DRAGON_AXE, ItemID.TRAILBLAZER_AXE_NO_INFERNAL, ItemID.TRAILBLAZER_RELOADED_AXE_NO_INFERNAL),
	ITEM_DRAGON_HARPOON(ItemID.DRAGON_HARPOON, ItemID.TRAILBLAZER_HARPOON_NO_INFERNAL, ItemID.TRAILBLAZER_RELOADED_HARPOON_NO_INFERNAL),
	ITEM_INFERNAL_PICKAXE_OR(ItemID.INFERNAL_PICKAXE, ItemID.TRAILBLAZER_PICKAXE, ItemID.TRAILBLAZER_RELOADED_PICKAXE),
	ITEM_INFERNAL_PICKAXE_OR_UNCHARGED(ItemID.INFERNAL_PICKAXE_EMPTY, ItemID.TRAILBLAZER_PICKAXE_EMPTY, ItemID.TRAILBLAZER_RELOADED_PICKAXE_EMPTY),
	ITEM_INFERNAL_AXE_OR(ItemID.INFERNAL_AXE, ItemID.TRAILBLAZER_AXE, ItemID.TRAILBLAZER_RELOADED_AXE),
	ITEM_INFERNAL_AXE_OR_UNCHARGED(ItemID.INFERNAL_AXE_EMPTY, ItemID.TRAILBLAZER_AXE_EMPTY, ItemID.TRAILBLAZER_RELOADED_AXE_EMPTY),
	ITEM_INFERNAL_HARPOON_OR(ItemID.INFERNAL_HARPOON, ItemID.TRAILBLAZER_HARPOON, ItemID.TRAILBLAZER_RELOADED_HARPOON),
	ITEM_INFERNAL_HARPOON_OR_UNCHARGED(ItemID.INFERNAL_HARPOON_EMPTY, ItemID.TRAILBLAZER_HARPOON_EMPTY, ItemID.TRAILBLAZER_RELOADED_HARPOON_EMPTY),
	ITEM_TRAILBLAZER_TOOL_ORNAMENT_KIT(ItemID.TRAILBLAZER_TOOL_ORNAMENTKIT, ItemID.TRAILBLAZER_PICKAXE_NO_INFERNAL, ItemID.TRAILBLAZER_RELOADED_PICKAXE_NO_INFERNAL, ItemID.TRAILBLAZER_AXE_NO_INFERNAL, ItemID.TRAILBLAZER_HARPOON_NO_INFERNAL, ItemID.TRAILBLAZER_PICKAXE, ItemID.TRAILBLAZER_AXE, ItemID.TRAILBLAZER_HARPOON, ItemID.TRAILBLAZER_RELOADED_HARPOON, ItemID.TRAILBLAZER_PICKAXE_EMPTY, ItemID.TRAILBLAZER_RELOADED_PICKAXE_EMPTY, ItemID.TRAILBLAZER_AXE_EMPTY, ItemID.TRAILBLAZER_RELOADED_AXE_EMPTY, ItemID.TRAILBLAZER_HARPOON_EMPTY, ItemID.TRAILBLAZER_RELOADED_HARPOON_EMPTY),
	ITEM_DRAGON_KITESHIELD(ItemID.DRAGON_KITESHIELD, ItemID.DRAGON_KITESHIELD_GOLD),
	ITEM_DRAGON_KITESHIELD_ORNAMENT_KIT(ItemID.DRAGON_KITESHIELD_KIT, ItemID.DRAGON_KITESHIELD_GOLD),
	ITEM_DRAGON_FULL_HELM(ItemID.BRUT_DRAGON_FULL_HELM, ItemID.DRAGON_FULL_HELM_GOLD),
	ITEM_DRAGON_FULL_HELM_ORNAMENT_KIT(ItemID.DRAGON_FULL_HELM_KIT, ItemID.DRAGON_FULL_HELM_GOLD),
	ITEM_DRAGON_MED_HELM(ItemID.DRAGON_MED_HELM, ItemID.BH_DRAGON_MED_HELM_CORRUPTED),
	ITEM_DRAGON_CHAINBODY(ItemID.DRAGON_CHAINBODY, ItemID.DRAGON_CHAINBODY_GOLD, ItemID.BH_DRAGON_CHAINBODY_CORRUPTED),
	ITEM_DRAGON_CHAINBODY_ORNAMENT_KIT(ItemID.DRAGON_CHAINBODY_KIT, ItemID.DRAGON_CHAINBODY_GOLD),
	ITEM_DRAGON_PLATEBODY(ItemID.DRAGON_PLATEBODY, ItemID.DRAGON_PLATEBODY_GOLD),
	ITEM_DRAGON_PLATEBODY_ORNAMENT_KIT(ItemID.DRAGON_PLATEBODY_KIT, ItemID.DRAGON_PLATEBODY_GOLD),
	ITEM_DRAGON_PLATESKIRT(ItemID.DRAGON_PLATESKIRT, ItemID.DRAGON_PLATESKIRT_GOLD, ItemID.BH_DRAGON_PLATESKIRT_CORRUPTED),
	ITEM_DRAGON_SKIRT_ORNAMENT_KIT(ItemID.DRAGON_PLATELEGS_KIT, ItemID.DRAGON_PLATESKIRT_GOLD),
	ITEM_DRAGON_PLATELEGS(ItemID.DRAGON_PLATELEGS, ItemID.DRAGON_PLATELEGS_GOLD, ItemID.BH_DRAGON_PLATELEGS_CORRUPTED),
	ITEM_DRAGON_LEGS_ORNAMENT_KIT(ItemID.DRAGON_PLATELEGS_KIT, ItemID.DRAGON_PLATELEGS_GOLD),
	ITEM_DRAGON_SQ_SHIELD(ItemID.DRAGON_SQ_SHIELD, ItemID.DRAGON_SQ_SHIELD_GOLD, ItemID.BH_DRAGON_SQ_SHIELD_CORRUPTED),
	ITEM_DRAGON_SQ_SHIELD_ORNAMENT_KIT(ItemID.DRAGON_SQ_SHIELD_KIT, ItemID.DRAGON_SQ_SHIELD_GOLD),
	ITEM_DRAGON_BOOTS(ItemID.DRAGON_BOOTS, ItemID.DRAGON_BOOTS_GOLD, ItemID.BH_DRAGON_BOOTS_CORRUPTED),
	ITEM_DRAGON_BOOTS_ORNAMENT_KIT(ItemID.DRAGON_BOOTS_KIT, ItemID.DRAGON_BOOTS_GOLD),

	// Rune ornament kits
	ITEM_RUNE_SCIMITAR_GUTHIX(ItemID.RUNE_SCIMITAR, ItemID.RUNE_SCIMITAR_GUTHIX),
	ITEM_RUNE_SCIMITAR_ORNAMENT_KIT_GUTHIX(ItemID.RUNE_SCIMITAR_ORNAMENT_KIT_GUTHIX, ItemID.RUNE_SCIMITAR_GUTHIX),
	ITEM_RUNE_SCIMITAR_SARADOMIN(ItemID.RUNE_SCIMITAR, ItemID.RUNE_SCIMITAR_SARADOMIN),
	ITEM_RUNE_SCIMITAR_ORNAMENT_KIT_SARADOMIN(ItemID.RUNE_SCIMITAR_ORNAMENT_KIT_SARADOMIN, ItemID.RUNE_SCIMITAR_SARADOMIN),
	ITEM_RUNE_SCIMITAR_ZAMORAK(ItemID.RUNE_SCIMITAR, ItemID.RUNE_SCIMITAR_ZAMORAK),
	ITEM_RUNE_SCIMITAR_ORNAMENT_KIT_ZAMORAK(ItemID.RUNE_SCIMITAR_ORNAMENT_KIT_ZAMORAK, ItemID.RUNE_SCIMITAR_ZAMORAK),
	ITEM_RUNE_DEFENDER(ItemID.RUNE_PARRYINGDAGGER, ItemID.RUNE_PARRYINGDAGGER_T, ItemID.RUNE_PARRYINGDAGGER_T_TROUVER),
	ITEM_RUNE_DEFENDER_ORNAMENT_KIT(ItemID.RD_ORNAMENT_KIT, ItemID.RUNE_PARRYINGDAGGER_T, ItemID.RUNE_PARRYINGDAGGER_T_TROUVER),
	ITEM_RUNE_CROSSBOW(ItemID.XBOWS_CROSSBOW_RUNITE, ItemID.LEAGUE_3_RUNE_XBOW),

	// Godsword ornament kits
	ITEM_ARMADYL_GODSWORD(ItemID.AGS, ItemID.AGSG, ItemID.DEADMAN_AGS),
	ITEM_ARMADYL_GODSWORD_ORNAMENT_KIT(ItemID.AGS_ORNAMENT_KIT, ItemID.AGSG),
	ITEM_BANDOS_GODSWORD(ItemID.BGS, ItemID.BGSG),
	ITEM_BANDOS_GODSWORD_ORNAMENT_KIT(ItemID.BGS_ORNAMENT_KIT, ItemID.BGSG),
	ITEM_ZAMORAK_GODSWORD(ItemID.ZGS, ItemID.ZGSG),
	ITEM_ZAMORAK_GODSWORD_ORNAMENT_KIT(ItemID.ZGS_ORNAMENT_KIT, ItemID.ZGSG),
	ITEM_SARADOMIN_GODSWORD(ItemID.SGS, ItemID.SGSG),
	ITEM_SARADOMIN_GODSWORD_ORNAMENT_KIT(ItemID.SGS_ORNAMENT_KIT, ItemID.SGSG),

	// Jewellery ornament kits
	ITEM_AMULET_OF_TORTURE(ItemID.ZENYTE_AMULET_ENCHANTED, ItemID.ZENYTE_AMULET_ORNAMENT),
	ITEM_TORTURE_ORNAMENT_KIT(ItemID.TORTURE_KIT, ItemID.ZENYTE_AMULET_ORNAMENT),
	ITEM_NECKLACE_OF_ANGUISH(ItemID.ZENYTE_NECKLACE_ENCHANTED, ItemID.ZENYTE_NECKLACE_ORNAMENT),
	ITEM_ANGUISH_ORNAMENT_KIT(ItemID.ANGUISH_KIT, ItemID.ZENYTE_NECKLACE_ORNAMENT),
	ITEM_OCCULT_NECKLACE(ItemID.OCCULT_NECKLACE, ItemID.OCCULT_NECKLACE_ORNAMENT),
	ITEM_OCCULT_ORNAMENT_KIT(ItemID.OCCULT_KIT, ItemID.OCCULT_NECKLACE_ORNAMENT),
	ITEM_AMULET_OF_FURY(ItemID.ENCHANTED_ONYX_AMULET, ItemID.FURY_ORNAMENT, ItemID.BLOOD_AMULET),
	ITEM_FURY_ORNAMENT_KIT(ItemID.FURY_KIT, ItemID.FURY_ORNAMENT),
	ITEM_TORMENTED_BRACELET(ItemID.ZENYTE_BRACELET_ENCHANTED, ItemID.ZENYTE_BRACELET_ENCHANTED_ORNAMENT),
	ITEM_TORMENTED_ORNAMENT_KIT(ItemID.TORMENTED_KIT, ItemID.ZENYTE_BRACELET_ENCHANTED_ORNAMENT),
	ITEM_BERSERKER_NECKLACE(ItemID.JEWL_BESERKER_NECKLACE, ItemID.JEWL_BESERKER_NECKLACE_ORNAMENT),
	ITEM_BERSERKER_NECKLACE_ORNAMENT_KIT(ItemID.BESERKER_NECKLACE_ORNAMENT_KIT, ItemID.JEWL_BESERKER_NECKLACE_ORNAMENT),

	// Other ornament kits
	ITEM_SHATTERED_RELICS_VARIETY_ORNAMENT_KIT(ItemID.LEAGUE_3_WEAPON_VARIETY_PACK, ItemID.LEAGUE_3_RUNE_XBOW, ItemID.LEAGUE_3_WHIP_TENTACLE, ItemID.LEAGUE_3_WHIP, ItemID.LEAGUE_3_BOOK_GUTHIX, ItemID.LEAGUE_3_BOOK_ZAROS, ItemID.LEAGUE_3_BOOK_ARMADYL, ItemID.LEAGUE_3_BOOK_BANDOS, ItemID.LEAGUE_3_BOOK_SARADOMIN, ItemID.LEAGUE_3_BOOK_ZAMORAK),
	ITEM_SHATTERED_RELICS_VOID_ORNAMENT_KIT(ItemID.LEAGUE_3_VOID_KIT, ItemID.LEAGUE_3_VOID_KNIGHT_TOP_ELITE, ItemID.LEAGUE_3_VOID_KNIGHT_ROBES_ELITE, ItemID.LEAGUE_3_VOID_KNIGHT_TOP, ItemID.LEAGUE_3_VOID_KNIGHT_ROBES, ItemID.LEAGUE_3_VOID_KNIGHT_GLOVES, ItemID.LEAGUE_3_VOID_MAGE_HELM, ItemID.LEAGUE_3_VOID_MELEE_HELM, ItemID.LEAGUE_3_VOID_RANGE_HELM, ItemID.LEAGUE_3_VOID_KNIGHT_TOP_TROUVER, ItemID.LEAGUE_3_VOID_KNIGHT_ROBES_TROUVER, ItemID.LEAGUE_3_VOID_KNIGHT_GLOVES_TROUVER, ItemID.LEAGUE_3_VOID_KNIGHT_TOP_ELITE_TROUVER, ItemID.LEAGUE_3_VOID_KNIGHT_ROBES_ELITE_TROUVER, ItemID.LEAGUE_3_VOID_MAGE_HELM_TROUVER, ItemID.LEAGUE_3_VOID_RANGE_HELM_TROUVER, ItemID.LEAGUE_3_VOID_MELEE_HELM_TROUVER),
	ITEM_MYSTIC_BOOTS(ItemID.MYSTIC_BOOTS, ItemID.LEAGUE_3_MYSTIC_BOOTS),
	ITEM_MYSTIC_GLOVES(ItemID.MYSTIC_GLOVES, ItemID.LEAGUE_3_MYSTIC_GLOVES),
	ITEM_MYSTIC_HAT(ItemID.MYSTIC_HAT, ItemID.LEAGUE_3_MYSTIC_HAT),
	ITEM_MYSTIC_ROBE_BOTTOM(ItemID.MYSTIC_ROBE_BOTTOM, ItemID.LEAGUE_3_MYSTIC_ROBE_BOTTOM),
	ITEM_MYSTIC_ROBE_TOP(ItemID.MYSTIC_ROBE_TOP, ItemID.LEAGUE_3_MYSTIC_ROBE_TOP),
	ITEM_SHATTERED_RELICS_MYSTIC_ORNAMENT_KIT(ItemID.LEAGUE_3_MYSTIC_ORNAMENT_PACK, ItemID.LEAGUE_3_MYSTIC_BOOTS, ItemID.LEAGUE_3_MYSTIC_GLOVES, ItemID.LEAGUE_3_MYSTIC_HAT, ItemID.LEAGUE_3_MYSTIC_ROBE_BOTTOM, ItemID.LEAGUE_3_MYSTIC_ROBE_TOP),
	ITEM_CANNON_BARRELS(ItemID.TWPART3, ItemID.LEAGUE_3_MULTICANNON_BARRELS),
	ITEM_CANNON_BASE(ItemID.TWPART1, ItemID.LEAGUE_3_MULTICANNON_BASE),
	ITEM_CANNON_FURNACE(ItemID.TWPART4, ItemID.LEAGUE_3_MULTICANNON_FURNACE),
	ITEM_CANNON_STAND(ItemID.TWPART2, ItemID.LEAGUE_3_MULTICANNON_STAND),
	ITEM_SHATTERED_CANNON_ORNAMENT_KIT(ItemID.LEAGUE_3_MULTICANNON_PACK, ItemID.LEAGUE_3_MULTICANNON_BARRELS, ItemID.LEAGUE_3_MULTICANNON_BASE, ItemID.LEAGUE_3_MULTICANNON_FURNACE, ItemID.LEAGUE_3_MULTICANNON_STAND),
	ITEM_ELDER_MAUL(ItemID.ELDER_MAUL, ItemID.ELDER_MAUL_ORNAMENT),
	ITEM_HEAVY_BALLISTA(ItemID.HEAVY_BALLISTA, ItemID.HEAVY_BALLISTA_ORNAMENT),
	ITEM_ELDER_CHAOS_HOOD(ItemID.ELDERCHAOS_HOOD, ItemID.ELDERCHAOS_HOOD_PRETTY),
	ITEM_ELDER_CHAOS_TOP(ItemID.ELDERCHAOS_TOP, ItemID.ELDERCHAOS_TOP_PRETTY),
	ITEM_ELDER_CHAOS_ROBE(ItemID.ELDERCHAOS_BOTTOM, ItemID.ELDERCHAOS_BOTTOM_PRETTY),
	ITEM_TRAILBLAZER_RELOADED_BLOWPIPE_ORNAMENT_KIT(ItemID.TOXIC_BLOWPIPE_ORNAMENT_KIT, ItemID.TOXIC_BLOWPIPE_LOADED_ORNAMENT, ItemID.TOXIC_BLOWPIPE_ORNAMENT),
	ITEM_DINHS_BULWARK(ItemID.DINHS_BULWARK, ItemID.DINHS_BULWARK_ORNAMENT),
	ITEM_TRAILBLAZER_RELOADED_BULWARK_ORNAMENT_KIT(ItemID.DINHS_BULWARK_ORNAMENT_KIT, ItemID.DINHS_BULWARK_ORNAMENT),
	ITEM_ECHO_AHRIMS_ORNAMENT_KIT(ItemID.BARROWS_AHRIM_ORNAMENT_KIT, true, 1L, ItemID.BARROWS_AHRIM_HEAD_ORNAMENT, ItemID.BARROWS_AHRIM_BODY_ORNAMENT, ItemID.BARROWS_AHRIM_LEGS_ORNAMENT, ItemID.BARROWS_AHRIM_WEAPON_ORNAMENT),
	ITEM_VIRTUS_MASK(ItemID.VIRTUS_MASK, ItemID.VIRTUS_MASK_ORNAMENT),
	ITEM_VIRTUS_ROBE_TOP(ItemID.VIRTUS_TOP, ItemID.VIRTUS_TOP_ORNAMENT),
	ITEM_VIRTUS_ROBE_BOTTOM(ItemID.VIRTUS_LEGS, ItemID.VIRTUS_LEGS_ORNAMENT),
	ITEM_ECHO_VIRTUS_ORNAMENT_KIT(ItemID.VIRTUS_ORNAMENT_KIT, ItemID.VIRTUS_MASK_ORNAMENT, ItemID.VIRTUS_TOP_ORNAMENT, ItemID.VIRTUS_LEGS_ORNAMENT),
	ITEM_ECHO_VENATOR_BOW_ORNAMENT_KIT(ItemID.VENATOR_BOW_ORNAMENT_KIT, ItemID.VENATOR_BOW_ORNAMENT_UNCHARGED, ItemID.VENATOR_BOW_ORNAMENT),

	// Ensouled heads
	ITEM_ENSOULED_GOBLIN_HEAD(ItemID.ARCEUUS_CORPSE_GOBLIN, ItemID.ARCEUUS_CORPSE_GOBLIN_INITIAL),
	ITEM_ENSOULED_MONKEY_HEAD(ItemID.ARCEUUS_CORPSE_MONKEY, ItemID.ARCEUUS_CORPSE_MONKEY_INITIAL),
	ITEM_ENSOULED_IMP_HEAD(ItemID.ARCEUUS_CORPSE_IMP, ItemID.ARCEUUS_CORPSE_IMP_INITIAL),
	ITEM_ENSOULED_MINOTAUR_HEAD(ItemID.ARCEUUS_CORPSE_MINOTAUR, ItemID.ARCEUUS_CORPSE_MINOTAUR_INITIAL),
	ITEM_ENSOULED_SCORPION_HEAD(ItemID.ARCEUUS_CORPSE_SCORPION, ItemID.ARCEUUS_CORPSE_SCORPION_INITIAL),
	ITEM_ENSOULED_BEAR_HEAD(ItemID.ARCEUUS_CORPSE_BEAR, ItemID.ARCEUUS_CORPSE_BEAR_INITIAL),
	ITEM_ENSOULED_UNICORN_HEAD(ItemID.ARCEUUS_CORPSE_UNICORN, ItemID.ARCEUUS_CORPSE_UNICORN_INITIAL),
	ITEM_ENSOULED_DOG_HEAD(ItemID.ARCEUUS_CORPSE_DOG, ItemID.ARCEUUS_CORPSE_DOG_INITIAL),
	ITEM_ENSOULED_CHAOS_DRUID_HEAD(ItemID.ARCEUUS_CORPSE_CHAOSDRUID, ItemID.ARCEUUS_CORPSE_CHAOSDRUID_INITIAL),
	ITEM_ENSOULED_GIANT_HEAD(ItemID.ARCEUUS_CORPSE_GIANT, ItemID.ARCEUUS_CORPSE_GIANT_INITIAL),
	ITEM_ENSOULED_OGRE_HEAD(ItemID.ARCEUUS_CORPSE_OGRE, ItemID.ARCEUUS_CORPSE_OGRE_INITIAL),
	ITEM_ENSOULED_ELF_HEAD(ItemID.ARCEUUS_CORPSE_ELF, ItemID.ARCEUUS_CORPSE_ELF_INITIAL),
	ITEM_ENSOULED_TROLL_HEAD(ItemID.ARCEUUS_CORPSE_TROLL, ItemID.ARCEUUS_CORPSE_TROLL_INITIAL),
	ITEM_ENSOULED_HORROR_HEAD(ItemID.ARCEUUS_CORPSE_HORROR, ItemID.ARCEUUS_CORPSE_HORROR_INITIAL),
	ITEM_ENSOULED_KALPHITE_HEAD(ItemID.ARCEUUS_CORPSE_KALPHITE, ItemID.ARCEUUS_CORPSE_KALPHITE_INITIAL),
	ITEM_ENSOULED_DAGANNOTH_HEAD(ItemID.ARCEUUS_CORPSE_DAGANNOTH, ItemID.ARCEUUS_CORPSE_DAGANNOTH_INITIAL),
	ITEM_ENSOULED_BLOODVELD_HEAD(ItemID.ARCEUUS_CORPSE_BLOODVELD, ItemID.ARCEUUS_CORPSE_BLOODVELD_INITIAL),
	ITEM_ENSOULED_TZHAAR_HEAD(ItemID.ARCEUUS_CORPSE_TZHAAR, ItemID.ARCEUUS_CORPSE_TZHAAR_INITIAL),
	ITEM_ENSOULED_DEMON_HEAD(ItemID.ARCEUUS_CORPSE_DEMON, ItemID.ARCEUUS_CORPSE_DEMON_INITIAL),
	ITEM_ENSOULED_HELLHOUND_HEAD(ItemID.ARCEUUS_CORPSE_HELLHOUND, ItemID.ARCEUUS_CORPSE_HELLHOUND_INITIAL),
	ITEM_ENSOULED_AVIANSIE_HEAD(ItemID.ARCEUUS_CORPSE_AVIANSIE, ItemID.ARCEUUS_CORPSE_AVIANSIE_INITIAL),
	ITEM_ENSOULED_ABYSSAL_HEAD(ItemID.ARCEUUS_CORPSE_ABYSSAL, ItemID.ARCEUUS_CORPSE_ABYSSAL_INITIAL),
	ITEM_ENSOULED_DRAGON_HEAD(ItemID.ARCEUUS_CORPSE_DRAGON, ItemID.ARCEUUS_CORPSE_DRAGON_INITIAL),

	// Imbued rings
	ITEM_BERSERKER_RING(ItemID.BERZERKER_RING, true, 1L, ItemID.NZONE_BERZERKER_RING),
	ITEM_SEERS_RING(ItemID.SEER_RING, true, 1L, ItemID.NZONE_SEER_RING),
	ITEM_WARRIOR_RING(ItemID.WARRIOR_RING, true, 1L, ItemID.NZONE_WARRIOR_RING),
	ITEM_ARCHERS_RING(ItemID.RANGER_RING, true, 1L, ItemID.NZONE_RANGER_RING),
	ITEM_TREASONOUS_RING(ItemID.SHARP_RING, true, 1L, ItemID.NZONE_SHARP_RING),
	ITEM_TYRANNICAL_RING(ItemID.HEAVY_RING, true, 1L, ItemID.NZONE_HEAVY_RING),
	ITEM_RING_OF_THE_GODS(ItemID.ROTG, true, 1L, ItemID.NZONE_ROTG),
	ITEM_RING_OF_SUFFERING(ItemID.ZENYTE_RING_ENCHANTED, true, 1L, ItemID.NZONE_ZENYTE_RING_ENCHANTED),
	ITEM_GRANITE_RING(ItemID.GRANITE_RING, true, 1L, ItemID.NZONE_GRANITE_RING),

	// Bounty hunter
	ITEM_GRANITE_MAUL(ItemID.GRANITE_MAUL, ItemID.GRANITE_MAUL_PRETTY),
	ITEM_MAGIC_SHORTBOW(ItemID.MAGIC_SHORTBOW, ItemID.MAGIC_SHORTBOW_I),
	ITEM_MAGIC_SHORTBOW_SCROLL(ItemID.BH_IMBUE_MAGICSHORTBOW, ItemID.MAGIC_SHORTBOW_I),
	ITEM_SARADOMINS_BLESSED_SWORD(ItemID.TEAR_OF_SARADOMIN, ItemID.BLESSED_SARADOMIN_SWORD_DEGRADED),
	ITEM_ABYSSAL_DAGGER(ItemID.ABYSSAL_DAGGER, ItemID.BH_ABYSSAL_DAGGER_IMBUE),
	ITEM_DRAGON_LONGSWORD(ItemID.DRAGON_LONGSWORD, ItemID.BH_DRAGON_LONGSWORD_IMBUE, ItemID.BH_DRAGON_LONGSWORD_CORRUPTED),
	ITEM_DRAGON_MACE(ItemID.DRAGON_MACE, ItemID.BH_DRAGON_MACE_IMBUE, ItemID.BH_DRAGON_MACE_CORRUPTED),

	// Jewellery with charges
	ITEM_RING_OF_WEALTH(ItemID.RING_OF_WEALTH, true, 1L, ItemID.RING_OF_WEALTH_1),
	ITEM_RING_OF_WEALTH_SCROLL(ItemID.BH_IMBUE_RINGOFWEALTH, ItemID.RING_OF_WEALTH_I, ItemID.RING_OF_WEALTH_I1, ItemID.RING_OF_WEALTH_I2, ItemID.RING_OF_WEALTH_I3, ItemID.RING_OF_WEALTH_I4, ItemID.RING_OF_WEALTH_I5),
	ITEM_AMULET_OF_GLORY(ItemID.AMULET_OF_GLORY, ItemID.AMULET_OF_GLORY_1, ItemID.AMULET_OF_GLORY_2, ItemID.AMULET_OF_GLORY_3, ItemID.AMULET_OF_GLORY_5),
	ITEM_AMULET_OF_GLORY_T(ItemID.TRAIL_AMULET_OF_GLORY, ItemID.TRAIL_AMULET_OF_GLORY_1, ItemID.TRAIL_AMULET_OF_GLORY_2, ItemID.TRAIL_AMULET_OF_GLORY_3, ItemID.TRAIL_AMULET_OF_GLORY_5),
	ITEM_SKILLS_NECKLACE(ItemID.JEWL_NECKLACE_OF_SKILLS, ItemID.JEWL_NECKLACE_OF_SKILLS_1, ItemID.JEWL_NECKLACE_OF_SKILLS_2, ItemID.JEWL_NECKLACE_OF_SKILLS_3, ItemID.JEWL_NECKLACE_OF_SKILLS_5),
	ITEM_RING_OF_DUELING(ItemID.RING_OF_DUELING_8, ItemID.RING_OF_DUELING_1, ItemID.RING_OF_DUELING_2, ItemID.RING_OF_DUELING_3, ItemID.RING_OF_DUELING_4, ItemID.RING_OF_DUELING_5, ItemID.RING_OF_DUELING_6, ItemID.RING_OF_DUELING_7),
	ITEM_GAMES_NECKLACE(ItemID.NECKLACE_OF_MINIGAMES_8, ItemID.NECKLACE_OF_MINIGAMES_1, ItemID.NECKLACE_OF_MINIGAMES_2, ItemID.NECKLACE_OF_MINIGAMES_3, ItemID.NECKLACE_OF_MINIGAMES_4, ItemID.NECKLACE_OF_MINIGAMES_5, ItemID.NECKLACE_OF_MINIGAMES_6, ItemID.NECKLACE_OF_MINIGAMES_7),
	ITEM_RING_OF_THE_ELEMENTS(ItemID.RING_OF_ELEMENTS, ItemID.RING_OF_ELEMENTS_CHARGED),

	// Degradable/charged weaponry/armour
	ITEM_ABYSSAL_WHIP(ItemID.ABYSSAL_WHIP, ItemID.ABYSSAL_WHIP_LAVA, ItemID.ABYSSAL_WHIP_ICE, ItemID.LEAGUE_3_WHIP),
	ITEM_KRAKEN_TENTACLE(ItemID.KRAKEN_TENTACLE, ItemID.ABYSSAL_TENTACLE, ItemID.LEAGUE_3_WHIP_TENTACLE),
	ITEM_TRIDENT_OF_THE_SEAS(ItemID.TOTS_UNCHARGED, ItemID.TOTS_CHARGED),
	ITEM_TRIDENT_OF_THE_SEAS_E(ItemID.TOTS_I_UNCHARGED, ItemID.TOTS_I_CHARGED),
	ITEM_TRIDENT_OF_THE_SWAMP(ItemID.TOXIC_TOTS_UNCHARGED, ItemID.TOXIC_TOTS_CHARGED),
	ITEM_TRIDENT_OF_THE_SWAMP_E(ItemID.TOXIC_TOTS_I_UNCHARGED, ItemID.TOXIC_TOTS_I_CHARGED),
	ITEM_TOXIC_BLOWPIPE(ItemID.TOXIC_BLOWPIPE, ItemID.TOXIC_BLOWPIPE_LOADED, ItemID.TOXIC_BLOWPIPE_ORNAMENT, ItemID.TOXIC_BLOWPIPE_LOADED_ORNAMENT),
	ITEM_TOXIC_STAFF_OFF_THE_DEAD(ItemID.TOXIC_SOTD, ItemID.TOXIC_SOTD_CHARGED),
	ITEM_SERPENTINE_HELM(ItemID.SERPENTINE_HELM, ItemID.SERPENTINE_HELM_CHARGED, ItemID.SERPENTINE_HELM_CYAN, ItemID.SERPENTINE_HELM_CHARGED_CYAN, ItemID.SERPENTINE_HELM_RED, ItemID.SERPENTINE_HELM_CHARGED_RED),
	ITEM_DRAGONFIRE_SHIELD(ItemID.DRAGONFIRE_SHIELD_UNCHARGED, ItemID.DRAGONFIRE_SHIELD),
	ITEM_DRAGONFIRE_WARD(ItemID.DRAGONFIRE_WARD_UNCHARGED, ItemID.DRAGONFIRE_WARD),
	ITEM_ANCIENT_WYVERN_SHIELD(ItemID.WYVERN_SHIELD_UNCHARGED, ItemID.WYVERN_SHIELD),
	ITEM_SANGUINESTI_STAFF(ItemID.SANGUINESTI_STAFF_UNCHARGED, ItemID.SANGUINESTI_STAFF, ItemID.SANGUINESTI_STAFF_UNCHARGED_OR, ItemID.SANGUINESTI_STAFF_OR),
	ITEM_SCYTHE_OF_VITUR(ItemID.SCYTHE_OF_VITUR_UNCHARGED, ItemID.SCYTHE_OF_VITUR, ItemID.SCYTHE_OF_VITUR_UNCHARGED_OR, ItemID.SCYTHE_OF_VITUR_OR, ItemID.SCYTHE_OF_VITUR_UNCHARGED_BL, ItemID.SCYTHE_OF_VITUR_BL),
	ITEM_TOME_OF_FIRE(ItemID.TOME_OF_FIRE_UNCHARGED, ItemID.TOME_OF_FIRE),
	ITEM_TOME_OF_WATER(ItemID.TOME_OF_WATER_UNCHARGED, ItemID.TOME_OF_WATER),
	ITEM_TOME_OF_EARTH(ItemID.TOME_OF_EARTH_UNCHARGED, ItemID.TOME_OF_EARTH),
	ITEM_CRAWS_BOW(ItemID.WILD_CAVE_BOW_UNCHARGED, ItemID.WILD_CAVE_BOW_CHARGED),
	ITEM_VIGGORAS_CHAINMACE(ItemID.WILD_CAVE_CHAINMACE_UNCHARGED, ItemID.WILD_CAVE_CHAINMACE_CHARGED),
	ITEM_THAMMARONS_SCEPTRE(ItemID.WILD_CAVE_SCEPTRE_UNCHARGED, ItemID.WILD_CAVE_SCEPTRE_CHARGED),
	ITEM_WEBWEAVER_BOW(ItemID.WILD_CAVE_WEBWEAVER_UNCHARGED, ItemID.WILD_CAVE_WEBWEAVER_CHARGED),
	ITEM_URSINE_CHAINMACE(ItemID.WILD_CAVE_URSINE_UNCHARGED, ItemID.WILD_CAVE_URSINE_CHARGED),
	ITEM_ACCURSED_SCEPTRE(ItemID.WILD_CAVE_ACCURSED_UNCHARGED, ItemID.WILD_CAVE_ACCURSED_CHARGED),
	ITEM_ACCURSED_SCEPTRE_A(ItemID.WILD_CAVE_ACCURSED_UNCHARGED_RECOL, ItemID.WILD_CAVE_ACCURSED_CHARGED_RECOL),
	ITEM_BRYOPHYTAS_STAFF(ItemID.NATURE_STAFF_UNCHARGED, ItemID.NATURE_STAFF_CHARGED),
	ITEM_RING_OF_ENDURANCE(ItemID.RING_OF_ENDURANCE_NOCHARGES, ItemID.RING_OF_ENDURANCE),
	ITEM_TUMEKENS_SHADOW(ItemID.TUMEKENS_SHADOW_UNCHARGED, ItemID.TUMEKENS_SHADOW),
	ITEM_PHARAOHS_SCEPTRE(ItemID.PHARAOHS_SCEPTRE, true, 1L, ItemID.NTK_JEWELLED_SCEPTRE_3),
	ITEM_VENATOR_BOW(ItemID.VENATOR_BOW_UNCHARGED, ItemID.VENATOR_BOW, ItemID.VENATOR_BOW_ORNAMENT_UNCHARGED, ItemID.VENATOR_BOW_ORNAMENT),
	ITEM_TONALZTICS_OF_RALOS(ItemID.TONALZTICS_OF_RALOS_UNCHARGED, ItemID.TONALZTICS_OF_RALOS_CHARGED),
	ITEM_GUARDIAN_BOOTS(ItemID.GUARDIAN_BOOTS, ItemID.ECHO_BOOTS),
	ITEM_EYE_OF_AYAK(ItemID.EYE_OF_AYAK_UNCHARGED, ItemID.EYE_OF_AYAK),

	// Lunar Chest armour
	ITEM_BLUE_MOON_HELM(ItemID.FROST_MOON_HELM, ItemID.FROST_MOON_HELM_DEGRADED),
	ITEM_BLUE_MOON_CHESTPLATE(ItemID.FROST_MOON_CHESTPLATE, ItemID.FROST_MOON_CHESTPLATE_DEGRADED),
	ITEM_BLUE_MOON_TASSETS(ItemID.FROST_MOON_TASSETS, ItemID.FROST_MOON_TASSETS_DEGRADED),
	ITEM_ECLIPSE_MOON_HELM(ItemID.ECLIPSE_MOON_HELM, ItemID.ECLIPSE_MOON_HELM_DEGRADED),
	ITEM_ECLIPSE_MOON_CHESTPLATE(ItemID.ECLIPSE_MOON_CHESTPLATE, ItemID.ECLIPSE_MOON_CHESTPLATE_DEGRADED),
	ITEM_ECLIPSE_MOON_TASSETS(ItemID.ECLIPSE_MOON_TASSETS, ItemID.ECLIPSE_MOON_TASSETS_DEGRADED),
	ITEM_BLOOD_MOON_HELM(ItemID.BLOOD_MOON_HELM, ItemID.BLOOD_MOON_HELM_DEGRADED),
	ITEM_BLOOD_MOON_CHESTPLATE(ItemID.BLOOD_MOON_CHESTPLATE, ItemID.BLOOD_MOON_CHESTPLATE_DEGRADED),
	ITEM_BLOOD_MOON_TASSETS(ItemID.BLOOD_MOON_TASSETS, ItemID.BLOOD_MOON_TASSETS_DEGRADED),

	// Tombs of Amascut gear
	ITEM_ELIDINIS_WARD(ItemID.ELIDINIS_WARD, ItemID.ELIDINIS_WARD_FORTIFIED, ItemID.ELIDINIS_WARD_ORNAMENT),
	ITEM_OSMUMTENS_FANG(ItemID.OSMUMTENS_FANG, ItemID.OSMUMTENS_FANG_ORNAMENT),

	// Infinity colour kits
	ITEM_INFINITY_TOP(ItemID.MAGICTRAINING_INFINITYTOP, ItemID.BR_INFINITY_BODY, ItemID.INFINITY_TOP_TRIM, ItemID.INFINITY_TOP_GOLD),
	ITEM_INFINITY_TOP_LIGHT_COLOUR_KIT(ItemID.LIGHT_INF_KIT, ItemID.INFINITY_TOP_GOLD),
	ITEM_INFINITY_TOP_DARK_COLOUR_KIT(ItemID.DARK_INF_KIT, ItemID.INFINITY_TOP_TRIM),
	ITEM_INFINITY_BOTTOMS(ItemID.MAGICTRAINING_INFINITYBOTTOM, ItemID.BR_INFINITY_LEGS, ItemID.INFINITY_BOTTOM_TRIM, ItemID.INFINITY_BOTTOM_GOLD),
	ITEM_INFINITY_BOTTOMS_LIGHT_COLOUR_KIT(ItemID.LIGHT_INF_KIT, ItemID.INFINITY_BOTTOM_GOLD),
	ITEM_INFINITY_BOTTOMS_DARK_COLOUR_KIT(ItemID.DARK_INF_KIT, ItemID.INFINITY_BOTTOM_TRIM),
	ITEM_INFINITY_HAT(ItemID.MAGICTRAINING_INFINITYHAT, ItemID.INFINITY_HAT_TRIM, ItemID.INFINITY_HAT_GOLD),
	ITEM_INFINITY_HAT_LIGHT_COLOUR_KIT(ItemID.LIGHT_INF_KIT, ItemID.INFINITY_HAT_GOLD),
	ITEM_INFINITY_HAT_DARK_COLOUR_KIT(ItemID.DARK_INF_KIT, ItemID.INFINITY_HAT_TRIM),

	// Miscellaneous ornament kits
	ITEM_DARK_BOW(ItemID.DARKBOW, ItemID.DARKBOW_GREEN, ItemID.DARKBOW_BLUE, ItemID.DARKBOW_YELLOW, ItemID.DARKBOW_WHITE, ItemID.BR_DARKBOW, ItemID.BH_DARKBOW_IMBUE, ItemID.DEADMAN_DARKBOW),
	ITEM_ODIUM_WARD(ItemID.ODIUM_WARD, ItemID.ODIUM_WARD_PRETTY),
	ITEM_MALEDICTION_WARD(ItemID.MALEDICTION_WARD, ItemID.MALEDICTION_WARD_PRETTY),
	ITEM_STEAM_BATTLESTAFF(ItemID.STEAM_BATTLESTAFF, ItemID.STEAM_BATTLESTAFF_PRETTY),
	ITEM_LAVA_BATTLESTAFF(ItemID.LAVA_BATTLESTAFF, ItemID.LAVA_BATTLESTAFF_PRETTY),
	ITEM_TZHAAR_KET_OM(ItemID.TZHAAR_MAUL, ItemID.TZHAAR_MAUL_T),
	ITEM_TZHAAR_KET_OM_ORNAMENT_KIT(ItemID.TZHAAR_MAUL_ORNAMENT_KIT, ItemID.TZHAAR_MAUL_T),
	ITEM_DRAGON_HUNTER_CROSSBOW(ItemID.DRAGONHUNTER_XBOW, ItemID.DRAGONHUNTER_XBOW_KBD, ItemID.DRAGONHUNTER_XBOW_VORKATH),
	ITEM_VOIDWAKER(ItemID.VOIDWAKER, ItemID.DEADMAN_VOIDWAKER),
	ITEM_AMULET_OF_RANCOUR(ItemID.AMULET_OF_RANCOUR, ItemID.AMULET_OF_RANCOUR_RECOL),

	// Slayer helm/black mask
	ITEM_BLACK_MASK(ItemID.HARMLESS_BLACK_MASK, true, 1L, ItemID.HARMLESS_BLACK_MASK, ItemID.SLAYER_HELM),

	// Revertible items
	ITEM_HYDRA_LEATHER(ItemID.HYDRA_LEATHER, ItemID.FEROCIOUS_GLOVES),
	ITEM_HYDRA_TAIL(ItemID.HYDRA_TAIL, ItemID.BONECRUSHER_NECKLACE),
	ITEM_DRAGONBONE_NECKLACE(ItemID.DRAGONBONE_NECKLACE, ItemID.BONECRUSHER_NECKLACE),
	ITEM_BOTTOMLESS_COMPOST_BUCKET(ItemID.BOTTOMLESS_COMPOST_BUCKET, ItemID.BOTTOMLESS_COMPOST_BUCKET_FILLED),
	ITEM_BASILISK_JAW(ItemID.BASILISK_JAW, ItemID.NEITIZNOT_FACEGUARD),
	ITEM_HELM_OF_NEITIZNOT(ItemID.FRIS_KINGLY_HELM, ItemID.NEITIZNOT_FACEGUARD, ItemID.BH_FRIS_KINGLY_HELM_CORRUPTED),
	ITEM_TWISTED_HORNS(ItemID.TWISTED_HORNS, ItemID.SLAYER_HELM_TWISTED, ItemID.SLAYER_HELM_I_TWISTED, ItemID.SW_SLAYER_HELM_I_TWISTED, ItemID.PVPA_SLAYER_HELM_I_TWISTED),
	ITEM_ELDRITCH_ORB(ItemID.ELDRITCH_ORB, ItemID.NIGHTMARE_STAFF_ELDRITCH),
	ITEM_HARMONISED_ORB(ItemID.HARMONISED_ORB, ItemID.NIGHTMARE_STAFF_HARMONISED),
	ITEM_VOLATILE_ORB(ItemID.VOLATILE_ORB, ItemID.NIGHTMARE_STAFF_VOLATILE, ItemID.DEADMAN_NIGHTMARE_STAFF_VOLATILE),
	ITEM_NIGHTMARE_STAFF(ItemID.NIGHTMARE_STAFF, ItemID.NIGHTMARE_STAFF_ELDRITCH, ItemID.NIGHTMARE_STAFF_HARMONISED, ItemID.NIGHTMARE_STAFF_VOLATILE, ItemID.DEADMAN_NIGHTMARE_STAFF_VOLATILE),
	ITEM_GHRAZI_RAPIER(ItemID.GHRAZI_RAPIER, ItemID.GHRAZI_RAPIER_OR),
	ITEM_MASTER_SCROLL_BOOK(ItemID.BOOKOFSCROLLS_EMPTY, ItemID.BOOKOFSCROLLS_CHARGED),
	ITEM_ARCANE_SIGIL(ItemID.ARCANE_SIGIL, ItemID.ELIDINIS_WARD_FORTIFIED, ItemID.ELIDINIS_WARD_ORNAMENT),
	ITEM_TORMENTED_SYNAPSE(ItemID.TORMENTED_SYNAPSE, ItemID.EMBERLIGHT, ItemID.SCORCHING_BOW, ItemID.PURGING_STAFF),
	ITEM_AVERNIC_TREADS(ItemID.AVERNIC_TREADS, ItemID.AVERNIC_TREADS_MAX, ItemID.AVERNIC_TREADS_MAGIC, ItemID.AVERNIC_TREADS_MELEE, ItemID.AVERNIC_TREADS_RANGED, ItemID.AVERNIC_TREADS_MELEE_MAGIC, ItemID.AVERNIC_TREADS_MELEE_RANGED, ItemID.AVERNIC_TREADS_RANGED_MAGIC),
	ITEM_PRIMORDIAL_BOOTS(ItemID.PRIMORDIAL_BOOTS, ItemID.AVERNIC_TREADS_MAX, ItemID.AVERNIC_TREADS_MELEE, ItemID.AVERNIC_TREADS_MELEE_MAGIC, ItemID.AVERNIC_TREADS_MELEE_RANGED),
	ITEM_PEGASIAN_BOOTS(ItemID.PEGASIAN_BOOTS, ItemID.AVERNIC_TREADS_MAX, ItemID.AVERNIC_TREADS_RANGED, ItemID.AVERNIC_TREADS_RANGED_MAGIC, ItemID.AVERNIC_TREADS_MELEE_RANGED),
	ITEM_ETERNAL_BOOTS(ItemID.ETERNAL_BOOTS, ItemID.AVERNIC_TREADS_MAX, ItemID.AVERNIC_TREADS_MAGIC, ItemID.AVERNIC_TREADS_MELEE_MAGIC, ItemID.AVERNIC_TREADS_RANGED_MAGIC),

	// Trouver Parchment
	ITEM_TROUVER_PARCHMENT(
		ItemID.TROUVER_PARCHMENT, ItemID.SKILLCAPE_MAX_INFERNALCAPE_TROUVER, ItemID.SKILLCAPE_MAX_FIRECAPE_TROUVER, ItemID.SKILLCAPE_MAX_ASSEMBLER_TROUVER, ItemID.BRONZE_PARRYINGDAGGER_TROUVER, ItemID.IRON_PARRYINGDAGGER_TROUVER, ItemID.STEEL_PARRYINGDAGGER_TROUVER, ItemID.BLACK_PARRYINGDAGGER_TROUVER, ItemID.MITHRIL_PARRYINGDAGGER_TROUVER, ItemID.ADAMANT_PARRYINGDAGGER_TROUVER,
		ItemID.RUNE_PARRYINGDAGGER_TROUVER, ItemID.DRAGON_PARRYINGDAGGER_TROUVER, ItemID.CASTLEWARS_SWORD_3_TROUVER, ItemID.CASTLEWARS_ARMOUR_BODY_3_TROUVER, ItemID.CASTLEWARS_ARMOUR_LEGS_3_TROUVER, ItemID.CASTLEWARS_MED_HELM_3_TROUVER, ItemID.CASTLEWARS_SHIELD_3_TROUVER, ItemID.CASTLEWARS_ARMOUR_SKIRT_3_TROUVER, ItemID.CASTLEWARS_MAGE_TOP_TROUVER, ItemID.CASTLEWARS_MAGE_LEGS_TROUVER,
		ItemID.CASTLEWARS_MAGE_HAT_TROUVER, ItemID.CASTLEWARS_RANGE_TOP_TROUVER, ItemID.CASTLEWARS_RANGE_LEGS_TROUVER, ItemID.CASTLEWARS_RANGE_QUIVER_TROUVER, ItemID.CASTLEWARS_SARADOMIN_HALO_TROUVER, ItemID.CASTLEWARS_ZAMORAK_HALO_TROUVER, ItemID.CASTLEWARS_GUTHIX_HALO_TROUVER, ItemID.BARBASSAULT_PENANCE_HEALER_HAT_TROUVER, ItemID.BARBASSAULT_PENANCE_FIGHTER_HAT_TROUVER, ItemID.BARBASSAULT_PENANCE_RANGER_HAT_TROUVER,
		ItemID.BARBASSAULT_PENANCE_FIGHTER_TORSO_TROUVER, ItemID.BARBASSAULT_PENANCE_RANGER_LEGS_TROUVER, ItemID.PEST_VOID_KNIGHT_TOP_TROUVER, ItemID.ELITE_VOID_KNIGHT_TOP_TROUVER, ItemID.PEST_VOID_KNIGHT_ROBES_TROUVER, ItemID.ELITE_VOID_KNIGHT_ROBES_TROUVER, ItemID.PEST_VOID_KNIGHT_MACE_TROUVER, ItemID.PEST_VOID_KNIGHT_GLOVES_TROUVER, ItemID.GAME_PEST_MAGE_HELM_TROUVER, ItemID.GAME_PEST_ARCHER_HELM_TROUVER,
		ItemID.GAME_PEST_MELEE_HELM_TROUVER, ItemID.INFERNAL_DEFENDER_TROUVER, ItemID.ARMADYL_HALO_TROUVER, ItemID.BANDOS_HALO_TROUVER, ItemID.SEREN_HALO_TROUVER, ItemID.ZAROS_HALO_TROUVER, ItemID.BRASSICA_HALO_TROUVER, ItemID.AVAS_ASSEMBLER_TROUVER, ItemID.TZHAAR_CAPE_FIRE_TROUVER, ItemID.INFERNAL_CAPE_TROUVER, ItemID.SKILLCAPE_MAX_SARADOMIN2_TROUVER,
		ItemID.SKILLCAPE_MAX_ZAMORAK2_TROUVER, ItemID.SKILLCAPE_MAX_GUTHIX2_TROUVER, ItemID.MA2_SARADOMIN_CAPE_TROUVER, ItemID.MA2_ZAMORAK_CAPE_TROUVER, ItemID.MA2_GUTHIX_CAPE_TROUVER, ItemID.BH_RUNE_POUCH_TROUVER, ItemID.BARBASSAULT_PENANCE_RUNNER_HAT_TROUVER, ItemID.CASTLEWARS_BOOTS_3_TROUVER, ItemID.CASTLEWARS_FULL_HELM_3_TROUVER,
		ItemID.AVAS_ASSEMBLER_MASORI_TROUVER, ItemID.SKILLCAPE_MAX_ASSEMBLER_MASORI_TROUVER, ItemID.RUNE_PARRYINGDAGGER_T_TROUVER, ItemID.LEAGUE_3_VOID_KNIGHT_TOP_TROUVER, ItemID.LEAGUE_3_VOID_KNIGHT_ROBES_TROUVER, ItemID.LEAGUE_3_VOID_KNIGHT_GLOVES_TROUVER, ItemID.LEAGUE_3_VOID_KNIGHT_TOP_ELITE_TROUVER, ItemID.LEAGUE_3_VOID_KNIGHT_ROBES_ELITE_TROUVER, ItemID.LEAGUE_3_VOID_MAGE_HELM_TROUVER,
		ItemID.LEAGUE_3_VOID_RANGE_HELM_TROUVER, ItemID.LEAGUE_3_VOID_MELEE_HELM_TROUVER, ItemID.BARRONITE_MACE_TROUVER),

	ITEM_TROUVER_PARCHMENT_REFUND_LARGE(
		ItemID.COINS, 475000L, ItemID.SKILLCAPE_MAX_INFERNALCAPE_TROUVER, ItemID.SKILLCAPE_MAX_FIRECAPE_TROUVER, ItemID.SKILLCAPE_MAX_ASSEMBLER_TROUVER, ItemID.RUNE_PARRYINGDAGGER_TROUVER, ItemID.DRAGON_PARRYINGDAGGER_TROUVER, ItemID.CASTLEWARS_SWORD_3_TROUVER, ItemID.CASTLEWARS_ARMOUR_BODY_3_TROUVER, ItemID.CASTLEWARS_ARMOUR_LEGS_3_TROUVER, ItemID.CASTLEWARS_MED_HELM_3_TROUVER, ItemID.CASTLEWARS_SHIELD_3_TROUVER,
		ItemID.CASTLEWARS_ARMOUR_SKIRT_3_TROUVER, ItemID.CASTLEWARS_MAGE_TOP_TROUVER, ItemID.CASTLEWARS_MAGE_LEGS_TROUVER, ItemID.CASTLEWARS_MAGE_HAT_TROUVER, ItemID.CASTLEWARS_RANGE_TOP_TROUVER, ItemID.CASTLEWARS_RANGE_LEGS_TROUVER, ItemID.CASTLEWARS_RANGE_QUIVER_TROUVER, ItemID.CASTLEWARS_SARADOMIN_HALO_TROUVER,
		ItemID.CASTLEWARS_ZAMORAK_HALO_TROUVER, ItemID.CASTLEWARS_GUTHIX_HALO_TROUVER, ItemID.BARBASSAULT_PENANCE_HEALER_HAT_TROUVER, ItemID.BARBASSAULT_PENANCE_FIGHTER_HAT_TROUVER, ItemID.BARBASSAULT_PENANCE_RANGER_HAT_TROUVER, ItemID.BARBASSAULT_PENANCE_FIGHTER_TORSO_TROUVER, ItemID.BARBASSAULT_PENANCE_RANGER_LEGS_TROUVER, ItemID.PEST_VOID_KNIGHT_TOP_TROUVER, ItemID.ELITE_VOID_KNIGHT_TOP_TROUVER, ItemID.PEST_VOID_KNIGHT_ROBES_TROUVER, ItemID.ELITE_VOID_KNIGHT_ROBES_TROUVER, ItemID.PEST_VOID_KNIGHT_MACE_TROUVER,
		ItemID.PEST_VOID_KNIGHT_GLOVES_TROUVER, ItemID.GAME_PEST_MAGE_HELM_TROUVER, ItemID.GAME_PEST_ARCHER_HELM_TROUVER, ItemID.GAME_PEST_MELEE_HELM_TROUVER, ItemID.INFERNAL_DEFENDER_TROUVER, ItemID.ARMADYL_HALO_TROUVER, ItemID.BANDOS_HALO_TROUVER, ItemID.SEREN_HALO_TROUVER, ItemID.ZAROS_HALO_TROUVER, ItemID.BRASSICA_HALO_TROUVER, ItemID.AVAS_ASSEMBLER_TROUVER,
		ItemID.TZHAAR_CAPE_FIRE_TROUVER, ItemID.INFERNAL_CAPE_TROUVER, ItemID.SKILLCAPE_MAX_SARADOMIN2_TROUVER, ItemID.SKILLCAPE_MAX_ZAMORAK2_TROUVER, ItemID.SKILLCAPE_MAX_GUTHIX2_TROUVER, ItemID.MA2_SARADOMIN_CAPE_TROUVER, ItemID.MA2_ZAMORAK_CAPE_TROUVER, ItemID.MA2_GUTHIX_CAPE_TROUVER, ItemID.BH_RUNE_POUCH_TROUVER, ItemID.BARBASSAULT_PENANCE_RUNNER_HAT_TROUVER, ItemID.CASTLEWARS_BOOTS_3_TROUVER, ItemID.CASTLEWARS_FULL_HELM_3_TROUVER,
		ItemID.AVAS_ASSEMBLER_MASORI_TROUVER, ItemID.SKILLCAPE_MAX_ASSEMBLER_MASORI_TROUVER, ItemID.RUNE_PARRYINGDAGGER_T_TROUVER, ItemID.LEAGUE_3_VOID_KNIGHT_TOP_TROUVER, ItemID.LEAGUE_3_VOID_KNIGHT_ROBES_TROUVER, ItemID.LEAGUE_3_VOID_KNIGHT_GLOVES_TROUVER, ItemID.LEAGUE_3_VOID_KNIGHT_TOP_ELITE_TROUVER, ItemID.LEAGUE_3_VOID_KNIGHT_ROBES_ELITE_TROUVER, ItemID.LEAGUE_3_VOID_MAGE_HELM_TROUVER,
		ItemID.LEAGUE_3_VOID_RANGE_HELM_TROUVER, ItemID.LEAGUE_3_VOID_MELEE_HELM_TROUVER, ItemID.BARRONITE_MACE_TROUVER),
	ITEM_TROUVER_PARCHMENT_REFUND_SMALL(ItemID.COINS, 47500L, ItemID.BRONZE_PARRYINGDAGGER_TROUVER, ItemID.IRON_PARRYINGDAGGER_TROUVER, ItemID.STEEL_PARRYINGDAGGER_TROUVER, ItemID.BLACK_PARRYINGDAGGER_TROUVER, ItemID.MITHRIL_PARRYINGDAGGER_TROUVER, ItemID.ADAMANT_PARRYINGDAGGER_TROUVER),

	// Crystal items
	ITEM_CRYSTAL_TOOL_SEED(ItemID.PRIF_TOOL_SEED, ItemID.CRYSTAL_AXE, ItemID.CRYSTAL_AXE_INACTIVE, ItemID.CRYSTAL_AXE_2H, ItemID.CRYSTAL_AXE_2H_INACTIVE, ItemID.CRYSTAL_HARPOON, ItemID.CRYSTAL_HARPOON_INACTIVE, ItemID.CRYSTAL_PICKAXE, ItemID.CRYSTAL_PICKAXE_INACTIVE),
	ITEM_CRYSTAL_AXE(ItemID.DRAGON_AXE, ItemID.CRYSTAL_AXE, ItemID.CRYSTAL_AXE_INACTIVE),
	ITEM_CRYSTAL_FELLING_AXE(ItemID.DRAGON_AXE_2H, ItemID.CRYSTAL_AXE_2H, ItemID.CRYSTAL_AXE_2H_INACTIVE),
	ITEM_CRYSTAL_HARPOON(ItemID.DRAGON_HARPOON, ItemID.CRYSTAL_HARPOON, ItemID.CRYSTAL_HARPOON_INACTIVE),
	ITEM_CRYSTAL_PICKAXE(ItemID.DRAGON_PICKAXE, ItemID.CRYSTAL_PICKAXE, ItemID.CRYSTAL_PICKAXE_INACTIVE),
	ITEM_BLADE_OF_SAELDOR(ItemID.BLADE_OF_SAELDOR_INACTIVE, true, 1L, ItemID.BLADE_OF_SAELDOR),
	ITEM_CRYSTAL_BOW(ItemID.CRYSTAL_SEED_OLD, ItemID.CRYSTAL_BOW, ItemID.CRYSTAL_BOW_2500, ItemID.CRYSTAL_BOW_INACTIVE),
	ITEM_CRYSTAL_HALBERD(ItemID.CRYSTAL_SEED_OLD, ItemID.CRYSTAL_HALBERD, ItemID.CRYSTAL_HALBERD_2500, ItemID.CRYSTAL_HALBERD_INACTIVE),
	ITEM_CRYSTAL_SHIELD(ItemID.CRYSTAL_SEED_OLD, ItemID.CRYSTAL_SHIELD, ItemID.CRYSTAL_SHIELD_2500, ItemID.CRYSTAL_SHIELD_INACTIVE),
	ITEM_CRYSTAL_HELMET(ItemID.PRIF_ARMOUR_SEED, true, 1L, ItemID.CRYSTAL_HELMET),
	ITEM_CRYSTAL_LEGS(ItemID.PRIF_ARMOUR_SEED, true, 2L, ItemID.CRYSTAL_PLATELEGS),
	ITEM_CRYSTAL_BODY(ItemID.PRIF_ARMOUR_SEED, true, 3L, ItemID.CRYSTAL_CHESTPLATE),
	ITEM_BOW_OF_FAERDHINEN(ItemID.BOW_OF_FAERDHINEN_INACTIVE, true, 1L, ItemID.BOW_OF_FAERDHINEN),

	// Bird nests
	ITEM_BIRD_NEST(ItemID.BIRD_NEST_EMPTY, ItemID.BIRD_NEST_EGG_RED, ItemID.BIRD_NEST_EGG_GREEN, ItemID.BIRD_NEST_EGG_BLUE, ItemID.BIRD_NEST_SEEDS, ItemID.BIRD_NEST_RING, ItemID.BIRD_NEST_CHEAPSEEDS, ItemID.BIRD_NEST_DECENTSEEDS, ItemID.BIRD_NEST_SEEDS_JAN2019, ItemID.BIRD_NEST_DECENTSEEDS_JAN2019, ItemID.WC_CLUE_NEST_EASY, ItemID.WC_CLUE_NEST_MEDIUM, ItemID.WC_CLUE_NEST_HARD, ItemID.WC_CLUE_NEST_ELITE),

	// Ancestral robes
	ITEM_ANCESTRAL_HAT(ItemID.ANCESTRAL_HAT, ItemID.ANCESTRAL_HAT_TWISTED),
	ITEM_ANCESTRAL_ROBE_TOP(ItemID.ANCESTRAL_ROBE_TOP, ItemID.ANCESTRAL_ROBE_TOP_TWISTED),
	ITEM_ANCESTRAL_ROBE_BOTTOM(ItemID.ANCESTRAL_ROBE_BOTTOM, ItemID.ANCESTRAL_ROBE_BOTTOM_TWISTED),

	// Torva armor
	ITEM_TORVA_FULL_HELM(ItemID.TORVA_HELM, ItemID.TORVA_HELM_SANGUINE),
	ITEM_TORVA_PLATEBODY(ItemID.TORVA_CHEST, ItemID.TORVA_CHEST_SANGUINE),
	ITEM_TORVA_PLATELEGS(ItemID.TORVA_LEGS, ItemID.TORVA_LEGS_SANGUINE),

	// Oathplate armor
	ITEM_OATHPLATE_HELM(ItemID.OATHPLATE_HELM, ItemID.RADIANT_OATHPLATE_HELM),
	ITEM_OATHPLATE_BODY(ItemID.OATHPLATE_CHEST, ItemID.RADIANT_OATHPLATE_CHEST),
	ITEM_OATHPLATE_LEGS(ItemID.OATHPLATE_LEGS, ItemID.RADIANT_OATHPLATE_LEGS),

	// Graceful
	ITEM_MARK_OF_GRACE(ItemID.AMYLASE, true, 10L, ItemID.GRACE),
	ITEM_GRACEFUL_HOOD(ItemID.GRACE, true, 28L, ItemID.GRACEFUL_HOOD),
	ITEM_GRACEFUL_TOP(ItemID.GRACE, true, 44L, ItemID.GRACEFUL_TOP),
	ITEM_GRACEFUL_LEGS(ItemID.GRACE, true, 48L, ItemID.GRACEFUL_LEGS),
	ITEM_GRACEFUL_GLOVES(ItemID.GRACE, true, 24L, ItemID.GRACEFUL_GLOVES),
	ITEM_GRACEFUL_BOOTS(ItemID.GRACE, true, 32L, ItemID.GRACEFUL_BOOTS),
	ITEM_GRACEFUL_CAPE(ItemID.GRACE, true, 32L, ItemID.GRACEFUL_CAPE),

	// Trailblazer Graceful Ornament Kit
	ITEM_TRAILBLAZER_GRACEFUL_HOOD(ItemID.TRAILBLAZER_GRACEFUL_KIT, ItemID.GRACEFUL_HOOD_TRAILBLAZER),
	ITEM_TRAILBLAZER_GRACEFUL_TOP(ItemID.TRAILBLAZER_GRACEFUL_KIT, ItemID.GRACEFUL_TOP_TRAILBLAZER),
	ITEM_TRAILBLAZER_GRACEFUL_LEGS(ItemID.TRAILBLAZER_GRACEFUL_KIT, ItemID.GRACEFUL_LEGS_TRAILBLAZER),
	ITEM_TRAILBLAZER_GRACEFUL_GLOVES(ItemID.TRAILBLAZER_GRACEFUL_KIT, ItemID.GRACEFUL_GLOVES_TRAILBLAZER),
	ITEM_TRAILBLAZER_GRACEFUL_BOOTS(ItemID.TRAILBLAZER_GRACEFUL_KIT, ItemID.GRACEFUL_BOOTS_TRAILBLAZER),
	ITEM_TRAILBLAZER_GRACEFUL_CAPE(ItemID.TRAILBLAZER_GRACEFUL_KIT, ItemID.GRACEFUL_CAPE_TRAILBLAZER),

	// 10 golden nuggets = 100 soft clay
	ITEM_GOLDEN_NUGGET(ItemID.SOFTCLAY, true, 10L, ItemID.MOTHERLODE_NUGGET),
	ITEM_PROSPECTOR_HELMET(ItemID.MOTHERLODE_NUGGET, true, 32L, ItemID.MOTHERLODE_REWARD_HAT),
	ITEM_PROSPECTOR_JACKET(ItemID.MOTHERLODE_NUGGET, true, 48L, ItemID.MOTHERLODE_REWARD_TOP),
	ITEM_PROSPECTOR_LEGS(ItemID.MOTHERLODE_NUGGET, true, 40L, ItemID.MOTHERLODE_REWARD_LEGS),
	ITEM_PROSPECTOR_BOOTS(ItemID.MOTHERLODE_NUGGET, true, 24L, ItemID.MOTHERLODE_REWARD_BOOTS),

	// 10 unidentified minerals = 100 soft clay
	ITEM_UNIDENTIFIED_MINERALS(ItemID.SOFTCLAY, true, 10L, ItemID.MGUILD_MINERALS),

	// Converted to coins
	ITEM_TATTERED_PAGE(ItemID.COINS, true, 1000L, ItemID.HOSDUN_MOON_PAGE, ItemID.HOSDUN_SUN_PAGE, ItemID.HOSDUN_TEMPLE_PAGE),
	ITEM_LONG_BONE(ItemID.COINS, true, 1000L, ItemID.DORGESH_CONSTRUCTION_BONE),
	ITEM_CURVED_BONE(ItemID.COINS, true, 2000L, ItemID.DORGESH_CONSTRUCTION_BONE_CURVED),
	ITEM_PERFECT_SHELL(ItemID.COINS, true, 600L, ItemID.DORGESH_TORTOISE_SHELL),
	ITEM_PERFECT_SNAIL_SHELL(ItemID.COINS, true, 600L, ItemID.DORGESH_SNAIL_SHELL),
	ITEM_SNAIL_SHELL(ItemID.COINS, true, 600L, ItemID.TEMPLETREK_SNAIL_SHELL),
	ITEM_TORTOISE_SHELL(ItemID.COINS, true, 250L, ItemID.BATTLE_TORTOISE_SHELL);

	@VisibleForTesting
	static final Multimap<Integer, ItemMapping> MAPPINGS = HashMultimap.create();
	private final int tradeableItem;
	private final int[] untradableItems;
	private final long quantity;
	private final boolean includeVariations;

	static
	{
		for (final ItemMapping item : values())
		{
			for (int itemId : item.untradableItems)
			{
				if (item.includeVariations)
				{
					for (final Integer variation : ItemVariationMapping.getVariations(ItemVariationMapping.map(itemId)))
					{
						if (variation != item.tradeableItem)
						{
							MAPPINGS.put(variation, item);
						}
					}
				}
				else
				{
					MAPPINGS.put(itemId, item);
				}
			}
		}
	}

	ItemMapping(int tradeableItem, boolean includeVariations, long quantity, int... untradableItems)
	{
		this.tradeableItem = tradeableItem;
		this.untradableItems = untradableItems;
		this.quantity = quantity;
		this.includeVariations = includeVariations;
	}

	ItemMapping(int tradeableItem, long quantity, int... untradableItems)
	{
		this(tradeableItem, false, quantity, untradableItems);
	}

	ItemMapping(int tradeableItem, int... untradableItems)
	{
		this(tradeableItem, 1L, untradableItems);
	}

	/**
	 * Get collection of items that are mapped from single item id.
	 *
	 * @param itemId the item id
	 * @return the collection
	 */
	@Nullable
	public static Collection<ItemMapping> map(int itemId)
	{
		final Collection<ItemMapping> mapping = MAPPINGS.get(itemId);

		if (mapping.isEmpty())
		{
			return null;
		}

		return mapping;
	}
}
