/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.gpu;

import java.nio.IntBuffer;
import java.util.Arrays;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.Client;
import net.runelite.api.Model;
import net.runelite.api.Perspective;
import net.runelite.api.Projection;
import net.runelite.client.plugins.gpu.SceneUploader;

@Singleton
class FacePrioritySorter {
    static final int[] distances = new int[6500];
    static final char[] distanceFaceCount = new char[6000];
    static final char[][] distanceToFaces = new char[6000][1024];
    private static final float[] modelCanvasX = new float[6500];
    private static final float[] modelCanvasY = new float[6500];
    static final float[] modelLocalX = new float[6500];
    static final float[] modelLocalY = new float[6500];
    static final float[] modelLocalZ = new float[6500];
    static final int[] numOfPriority = new int[12];
    private static final int[] eq10 = new int[4000];
    private static final int[] eq11 = new int[4000];
    private static final int[] lt10 = new int[12];
    static final int[][] orderedFaces = new int[12][4000];
    static final int MAX_VERTEX_COUNT = 6500;
    private static final int MAX_DIAMETER = 6000;
    private static final int ZSORT_GROUP_SIZE = 1024;
    private static final int MAX_FACES_PER_PRIORITY = 4000;
    private final Client client;

    int uploadSortedModel(Projection proj, Model model, int orientation, int x, int y, int z, IntBuffer opaqueBuffer, IntBuffer alphaBuffer) {
        int vertexCount = model.getVerticesCount();
        float[] verticesX = model.getVerticesX();
        float[] verticesY = model.getVerticesY();
        float[] verticesZ = model.getVerticesZ();
        int faceCount = model.getFaceCount();
        int[] indices1 = model.getFaceIndices1();
        int[] indices2 = model.getFaceIndices2();
        int[] indices3 = model.getFaceIndices3();
        int[] faceColors3 = model.getFaceColors3();
        byte[] faceRenderPriorities = model.getFaceRenderPriorities();
        int centerX = this.client.getCenterX();
        int centerY = this.client.getCenterY();
        int zoom = this.client.get3dZoom();
        float orientSine = 0.0f;
        float orientCosine = 0.0f;
        if (orientation != 0) {
            orientSine = (float)Perspective.SINE[orientation] / 65536.0f;
            orientCosine = (float)Perspective.COSINE[orientation] / 65536.0f;
        }
        float[] p = proj.project((float)x, (float)y, (float)z);
        int zero = (int)p[2];
        for (int v = 0; v < vertexCount; ++v) {
            float vertexX = verticesX[v];
            float vertexY = verticesY[v];
            float vertexZ = verticesZ[v];
            if (orientation != 0) {
                float x0 = vertexX;
                vertexX = vertexZ * orientSine + x0 * orientCosine;
                vertexZ = vertexZ * orientCosine - x0 * orientSine;
            }
            FacePrioritySorter.modelLocalX[v] = vertexX += (float)x;
            FacePrioritySorter.modelLocalY[v] = vertexY += (float)y;
            FacePrioritySorter.modelLocalZ[v] = vertexZ += (float)z;
            p = proj.project(vertexX, vertexY, vertexZ);
            if (p[2] < 50.0f) {
                return 0;
            }
            FacePrioritySorter.modelCanvasX[v] = (float)centerX + p[0] * (float)zoom / p[2];
            FacePrioritySorter.modelCanvasY[v] = (float)centerY + p[1] * (float)zoom / p[2];
            FacePrioritySorter.distances[v] = (int)p[2] - zero;
        }
        int diameter = model.getDiameter();
        int radius = model.getRadius();
        if (diameter >= 6000) {
            return 0;
        }
        Arrays.fill(distanceFaceCount, 0, diameter, '\u0000');
        for (int i = 0; i < faceCount; i = (int)((char)(i + 1))) {
            float aY;
            float cX;
            float bY;
            int v3;
            float cY;
            int v2;
            float bX;
            int v1;
            float aX;
            if (faceColors3[i] == -2 || !(((aX = modelCanvasX[v1 = indices1[i]]) - (bX = modelCanvasX[v2 = indices2[i]])) * ((cY = modelCanvasY[v3 = indices3[i]]) - (bY = modelCanvasY[v2])) - ((cX = modelCanvasX[v3]) - bX) * ((aY = modelCanvasY[v1]) - bY) > 0.0f)) continue;
            int distance = radius + (distances[v1] + distances[v2] + distances[v3]) / 3;
            assert (distance >= 0 && distance < diameter);
            int n = distance;
            char c = distanceFaceCount[n];
            distanceFaceCount[n] = (char)(c + '\u0001');
            FacePrioritySorter.distanceToFaces[distance][c] = i;
        }
        int len = 0;
        if (faceRenderPriorities == null) {
            for (int i = diameter - 1; i >= 0; --i) {
                int cnt = distanceFaceCount[i];
                if (cnt <= 0) continue;
                char[] faces = distanceToFaces[i];
                for (int faceIdx = 0; faceIdx < cnt; ++faceIdx) {
                    char face = faces[faceIdx];
                    len += this.pushFace(model, face, opaqueBuffer, alphaBuffer);
                }
            }
        } else {
            Arrays.fill(numOfPriority, 0);
            Arrays.fill(lt10, 0);
            for (int i = diameter - 1; i >= 0; --i) {
                int cnt = distanceFaceCount[i];
                if (cnt <= 0) continue;
                char[] faces = distanceToFaces[i];
                for (int faceIdx = 0; faceIdx < cnt; ++faceIdx) {
                    byte pri;
                    int face = faces[faceIdx];
                    byte by = pri = faceRenderPriorities[face];
                    numOfPriority[by] = numOfPriority[by] + 1;
                    FacePrioritySorter.orderedFaces[pri][distIdx] = face;
                    if (pri < 10) {
                        byte by2 = pri;
                        lt10[by2] = lt10[by2] + i;
                        continue;
                    }
                    if (pri == 10) {
                        FacePrioritySorter.eq10[distIdx] = i;
                        continue;
                    }
                    FacePrioritySorter.eq11[distIdx] = i;
                }
            }
            int avg12 = 0;
            if (numOfPriority[1] > 0 || numOfPriority[2] > 0) {
                avg12 = (lt10[1] + lt10[2]) / (numOfPriority[1] + numOfPriority[2]);
            }
            int avg34 = 0;
            if (numOfPriority[3] > 0 || numOfPriority[4] > 0) {
                avg34 = (lt10[3] + lt10[4]) / (numOfPriority[3] + numOfPriority[4]);
            }
            int avg68 = 0;
            if (numOfPriority[6] > 0 || numOfPriority[8] > 0) {
                avg68 = (lt10[8] + lt10[6]) / (numOfPriority[8] + numOfPriority[6]);
            }
            int drawnFaces = 0;
            int numDynFaces = numOfPriority[10];
            int[] dynFaces = orderedFaces[10];
            int[] dynFaceDistances = eq10;
            if (drawnFaces == numDynFaces) {
                drawnFaces = 0;
                numDynFaces = numOfPriority[11];
                dynFaces = orderedFaces[11];
                dynFaceDistances = eq11;
            }
            int currFaceDistance = drawnFaces < numDynFaces ? dynFaceDistances[drawnFaces] : -1000;
            for (int pri = 0; pri < 10; ++pri) {
                int face;
                while (pri == 0 && currFaceDistance > avg12) {
                    face = dynFaces[drawnFaces++];
                    len += this.pushFace(model, face, opaqueBuffer, alphaBuffer);
                    if (drawnFaces == numDynFaces && dynFaces != orderedFaces[11]) {
                        drawnFaces = 0;
                        numDynFaces = numOfPriority[11];
                        dynFaces = orderedFaces[11];
                        dynFaceDistances = eq11;
                    }
                    if (drawnFaces < numDynFaces) {
                        currFaceDistance = dynFaceDistances[drawnFaces];
                        continue;
                    }
                    currFaceDistance = -1000;
                }
                while (pri == 3 && currFaceDistance > avg34) {
                    face = dynFaces[drawnFaces++];
                    len += this.pushFace(model, face, opaqueBuffer, alphaBuffer);
                    if (drawnFaces == numDynFaces && dynFaces != orderedFaces[11]) {
                        drawnFaces = 0;
                        numDynFaces = numOfPriority[11];
                        dynFaces = orderedFaces[11];
                        dynFaceDistances = eq11;
                    }
                    if (drawnFaces < numDynFaces) {
                        currFaceDistance = dynFaceDistances[drawnFaces];
                        continue;
                    }
                    currFaceDistance = -1000;
                }
                while (pri == 5 && currFaceDistance > avg68) {
                    face = dynFaces[drawnFaces++];
                    len += this.pushFace(model, face, opaqueBuffer, alphaBuffer);
                    if (drawnFaces == numDynFaces && dynFaces != orderedFaces[11]) {
                        drawnFaces = 0;
                        numDynFaces = numOfPriority[11];
                        dynFaces = orderedFaces[11];
                        dynFaceDistances = eq11;
                    }
                    if (drawnFaces < numDynFaces) {
                        currFaceDistance = dynFaceDistances[drawnFaces];
                        continue;
                    }
                    currFaceDistance = -1000;
                }
                int priNum = numOfPriority[pri];
                int[] priFaces = orderedFaces[pri];
                for (int faceIdx = 0; faceIdx < priNum; ++faceIdx) {
                    int face2 = priFaces[faceIdx];
                    len += this.pushFace(model, face2, opaqueBuffer, alphaBuffer);
                }
            }
            while (currFaceDistance != -1000) {
                int face = dynFaces[drawnFaces++];
                len += this.pushFace(model, face, opaqueBuffer, alphaBuffer);
                if (drawnFaces == numDynFaces && dynFaces != orderedFaces[11]) {
                    drawnFaces = 0;
                    dynFaces = orderedFaces[11];
                    numDynFaces = numOfPriority[11];
                    dynFaceDistances = eq11;
                }
                if (drawnFaces < numDynFaces) {
                    currFaceDistance = dynFaceDistances[drawnFaces];
                    continue;
                }
                currFaceDistance = -1000;
            }
        }
        return len;
    }

    private int pushFace(Model model, int face, IntBuffer opaqueBuffer, IntBuffer alphaBuffer) {
        boolean alpha;
        int[] indices1 = model.getFaceIndices1();
        int[] indices2 = model.getFaceIndices2();
        int[] indices3 = model.getFaceIndices3();
        int[] faceColors1 = model.getFaceColors1();
        int[] faceColors2 = model.getFaceColors2();
        int[] faceColors3 = model.getFaceColors3();
        byte overrideAmount = model.getOverrideAmount();
        byte overrideHue = model.getOverrideHue();
        byte overrideSat = model.getOverrideSaturation();
        byte overrideLum = model.getOverrideLuminance();
        short[] faceTextures = model.getFaceTextures();
        byte[] transparencies = model.getFaceTransparencies();
        byte[] bias = model.getFaceBias();
        int triangleA = indices1[face];
        int triangleB = indices2[face];
        int triangleC = indices3[face];
        int color1 = faceColors1[face];
        int color2 = faceColors2[face];
        int color3 = faceColors3[face];
        boolean bl = alpha = transparencies != null && transparencies[face] != 0;
        if (color3 == -1) {
            color2 = color3 = color1;
        }
        if ((faceTextures == null || faceTextures[face] == -1) && overrideAmount > 0) {
            color1 = SceneUploader.interpolateHSL(color1, overrideHue, overrideSat, overrideLum, overrideAmount);
            color2 = SceneUploader.interpolateHSL(color2, overrideHue, overrideSat, overrideLum, overrideAmount);
            color3 = SceneUploader.interpolateHSL(color3, overrideHue, overrideSat, overrideLum, overrideAmount);
        }
        float vx1 = modelLocalX[triangleA];
        float vy1 = modelLocalY[triangleA];
        float vz1 = modelLocalZ[triangleA];
        float vx2 = modelLocalX[triangleB];
        float vy2 = modelLocalY[triangleB];
        float vz2 = modelLocalZ[triangleB];
        float vx3 = modelLocalX[triangleC];
        float vy3 = modelLocalY[triangleC];
        float vz3 = modelLocalZ[triangleC];
        SceneUploader.computeFaceUvs(model, face);
        int su0 = (int)(SceneUploader.u0 * 256.0f);
        int sv0 = (int)(SceneUploader.v0 * 256.0f);
        int su1 = (int)(SceneUploader.u1 * 256.0f);
        int sv1 = (int)(SceneUploader.v1 * 256.0f);
        int su2 = (int)(SceneUploader.u2 * 256.0f);
        int sv2 = (int)(SceneUploader.v2 * 256.0f);
        int alphaBias = 0;
        alphaBias |= transparencies != null ? (transparencies[face] & 0xFF) << 24 : 0;
        int texture = faceTextures != null ? faceTextures[face] + 1 : 0;
        IntBuffer vb = alpha ? alphaBuffer : opaqueBuffer;
        SceneUploader.putfff4(vb, vx1, vy1, vz1, (alphaBias |= bias != null ? (bias[face] & 0xFF) << 16 : 0) | color1);
        SceneUploader.put2222(vb, texture, su0, sv0, 0);
        SceneUploader.putfff4(vb, vx2, vy2, vz2, alphaBias | color2);
        SceneUploader.put2222(vb, texture, su1, sv1, 0);
        SceneUploader.putfff4(vb, vx3, vy3, vz3, alphaBias | color3);
        SceneUploader.put2222(vb, texture, su2, sv2, 0);
        return 3;
    }

    @Inject
    public FacePrioritySorter(Client client) {
        this.client = client;
    }
}

