/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.cluescrolls.clues;

import com.google.common.collect.ImmutableList;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.runelite.api.Client;
import net.runelite.api.EquipmentInventorySlot;
import net.runelite.api.Item;
import net.runelite.api.Perspective;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.client.game.ItemVariationMapping;
import net.runelite.client.plugins.cluescrolls.ClueScrollOverlay;
import net.runelite.client.plugins.cluescrolls.ClueScrollPlugin;
import net.runelite.client.plugins.cluescrolls.clues.ClueScroll;
import net.runelite.client.plugins.cluescrolls.clues.Enemy;
import net.runelite.client.plugins.cluescrolls.clues.LocationClueScroll;
import net.runelite.client.plugins.cluescrolls.clues.emote.Emote;
import net.runelite.client.plugins.cluescrolls.clues.emote.STASHUnit;
import net.runelite.client.plugins.cluescrolls.clues.item.AnyRequirementCollection;
import net.runelite.client.plugins.cluescrolls.clues.item.ItemRequirement;
import net.runelite.client.plugins.cluescrolls.clues.item.ItemRequirements;
import net.runelite.client.plugins.cluescrolls.clues.item.SingleItemRequirement;
import net.runelite.client.ui.FontManager;
import net.runelite.client.ui.overlay.OverlayUtil;
import net.runelite.client.ui.overlay.components.LineComponent;
import net.runelite.client.ui.overlay.components.PanelComponent;
import net.runelite.client.ui.overlay.components.TitleComponent;

public class EmoteClue
extends ClueScroll
implements LocationClueScroll {
    private static final AnyRequirementCollection ANY_SLAYER_HELMET = ItemRequirements.any("Any slayer helmet", (ItemRequirement[])ItemVariationMapping.getVariations(11864).stream().map(ItemRequirements::item).toArray(SingleItemRequirement[]::new));
    private static final AnyRequirementCollection ANY_RING_OF_WEALTH = ItemRequirements.any("Any ring of wealth", (ItemRequirement[])ItemVariationMapping.getVariations(2572).stream().map(ItemRequirements::item).toArray(SingleItemRequirement[]::new));
    private static final AnyRequirementCollection ANY_PHARAOHS_SCEPTRE = ItemRequirements.any("Pharaoh's sceptre", (ItemRequirement[])ItemVariationMapping.getVariations(9044).stream().map(ItemRequirements::item).toArray(SingleItemRequirement[]::new));
    private static final AnyRequirementCollection ANY_TEAM_CAPE = ItemRequirements.any("Any team cape", (ItemRequirement[])Stream.of(ItemVariationMapping.getVariations(4315).stream(), Stream.of(20217, 20214, 20211)).reduce(Stream::concat).orElseGet(Stream::empty).map(ItemRequirements::item).toArray(SingleItemRequirement[]::new));
    static final AnyRequirementCollection ACTIVE_CRYSTAL_BOW_OR_BOW_OF_FAERDHINEN = ItemRequirements.any("Crystal Bow or Bow of Faerdhinen", (ItemRequirement[])Stream.of(ItemVariationMapping.getVariations(25862).stream(), Stream.of(23983, 24123)).reduce(Stream::concat).orElseGet(Stream::empty).filter(itemId -> itemId != 25862).map(ItemRequirements::item).toArray(SingleItemRequirement[]::new));
    static final List<EmoteClue> CLUES = ImmutableList.of((Object)new EmoteClue(12544, "Beckon on the east coast of the Kharazi Jungle. Beware of double agents! Equip any vestment stole and a heraldic rune shield.", "Kharazi Jungle", STASHUnit.NORTHEAST_CORNER_OF_THE_KHARAZI_JUNGLE, new WorldPoint(2954, 2933, 0), Enemy.DOUBLE_AGENT_108, Emote.BECKON, ItemRequirements.any("Any stole", ItemRequirements.item(10472), ItemRequirements.item(10470), ItemRequirements.item(10474), ItemRequirements.item(12257), ItemRequirements.item(12269), ItemRequirements.item(12201)), ItemRequirements.any("Any heraldic rune shield", ItemRequirements.item(7336), ItemRequirements.item(7342), ItemRequirements.item(7348), ItemRequirements.item(7354), ItemRequirements.item(7360))), (Object)new EmoteClue(10264, "Cheer in the Barbarian Agility Arena. Headbang before you talk to me. Equip a steel platebody, maple shortbow and a Wilderness cape.", "Barbarian Outpost", STASHUnit.BARBARIAN_OUTPOST_OBSTACLE_COURSE, new WorldPoint(2552, 3556, 0), Emote.CHEER, Emote.HEADBANG, ItemRequirements.item(1119), ItemRequirements.item(853), ANY_TEAM_CAPE), (Object)new EmoteClue(12078, "Bow upstairs in the Edgeville Monastery. Equip a completed prayer book.", "Edgeville Monastery", STASHUnit.SOUTHEAST_CORNER_OF_THE_MONASTERY, new WorldPoint(3056, 3484, 1), Emote.BOW, ItemRequirements.any("Any god book", ItemRequirements.item(3840), ItemRequirements.item(3844), ItemRequirements.item(3842), ItemRequirements.item(12610), ItemRequirements.item(12608), ItemRequirements.item(12612), ItemRequirements.item(26496), ItemRequirements.item(26488), ItemRequirements.item(26498), ItemRequirements.item(26492), ItemRequirements.item(26494), ItemRequirements.item(26490))), (Object)new EmoteClue(12076, "Cheer in the Shadow dungeon. Equip a rune crossbow, climbing boots and any mitre.", "Shadow dungeon", STASHUnit.ENTRANCE_OF_THE_CAVE_OF_DAMIS, new WorldPoint(2629, 5071, 0), Emote.CHEER, ItemRequirements.any("Any mitre", ItemRequirements.item(10454), ItemRequirements.item(10452), ItemRequirements.item(10456), ItemRequirements.item(12203), ItemRequirements.item(12271), ItemRequirements.item(12259)), ItemRequirements.any("Rune crossbow", ItemRequirements.item(9185), ItemRequirements.item(26486)), ItemRequirements.any("Climbing boots", ItemRequirements.item(3105), ItemRequirements.item(23413)), ItemRequirements.any("Ring of visibility or ring of shadows", ItemRequirements.item(4657), ItemRequirements.item(28327), ItemRequirements.item(28329))), (Object)new EmoteClue(12550, "Cheer at the top of the agility pyramid. Beware of double agents! Equip a blue mystic robe top and any rune heraldic shield.", "Agility Pyramid", STASHUnit.AGILITY_PYRAMID, new WorldPoint(3043, 4697, 3), Enemy.DOUBLE_AGENT_108, Emote.CHEER, ItemRequirements.item(4091), ItemRequirements.any("Any rune heraldic shield", ItemRequirements.item(7336), ItemRequirements.item(7342), ItemRequirements.item(7348), ItemRequirements.item(7354), ItemRequirements.item(7360))), (Object)new EmoteClue(19835, "Dance in Iban's temple. Beware of double agents! Equip Iban's staff, a black mystic top and a black mystic bottom.", "Iban's temple", STASHUnit.WELL_OF_VOYAGE, new WorldPoint(2011, 4712, 0), Enemy.DOUBLE_AGENT_141, Emote.DANCE, ItemRequirements.any("Any iban's staff", ItemRequirements.item(1409), ItemRequirements.item(12658)), ItemRequirements.item(4101), ItemRequirements.item(4103)), (Object)new EmoteClue(12079, "Dance on the Fishing Platform. Equip barrows gloves, an amulet of glory and a dragon med helm.", "Fishing Platform", STASHUnit.SOUTHEAST_CORNER_OF_THE_FISHING_PLATFORM, new WorldPoint(2782, 3273, 0), Emote.DANCE, ItemRequirements.any("Any amulet of glory", ItemRequirements.item(1704), ItemRequirements.item(1706), ItemRequirements.item(1708), ItemRequirements.item(1710), ItemRequirements.item(1712), ItemRequirements.item(11976), ItemRequirements.item(11978)), ItemRequirements.item(7462), ItemRequirements.item(1149)), (Object)new EmoteClue(19835, "Flap at the death altar. Beware of double agents! Equip a death tiara, a legend's cape and any ring of wealth.", "Death altar", STASHUnit.DEATH_ALTAR, new WorldPoint(2205, 4838, 0), Enemy.DOUBLE_AGENT_141, Emote.FLAP, ANY_RING_OF_WEALTH, ItemRequirements.item(5547), ItemRequirements.item(1052)), (Object)new EmoteClue(19791, "Headbang in the Fight Arena pub. Equip a pirate bandana, a dragonstone necklace and and a magic longbow.", "Fight Arena pub", STASHUnit.OUTSIDE_THE_BAR_BY_THE_FIGHT_ARENA, new WorldPoint(2568, 3149, 0), Emote.HEADBANG, ItemRequirements.any("Any pirate bandana", ItemRequirements.item(7112), ItemRequirements.item(7124), ItemRequirements.item(7130), ItemRequirements.item(7136)), ItemRequirements.item(1664), ItemRequirements.item(859)), (Object)new EmoteClue(19835, "Do a jig at the barrows chest. Beware of double agents! Equip any full barrows set.", "Barrows chest", STASHUnit.BARROWS_CHEST, new WorldPoint(3551, 9694, 0), Enemy.DOUBLE_AGENT_141, Emote.JIG, ItemRequirements.any("Any full barrows set", ItemRequirements.all(ItemRequirements.any("Ahrim's hood", ItemRequirements.item(4708), ItemRequirements.range(4856, 4860), ItemRequirements.item(30445), ItemRequirements.item(30519), ItemRequirements.item(30525), ItemRequirements.item(30531), ItemRequirements.item(30537), ItemRequirements.item(30543)), ItemRequirements.any("Ahrim's staff", ItemRequirements.item(4710), ItemRequirements.range(4862, 4866), ItemRequirements.item(30568), ItemRequirements.range(30570, 30574)), ItemRequirements.any("Ahrim's robetop", ItemRequirements.item(4712), ItemRequirements.range(4868, 4872), ItemRequirements.item(30447), ItemRequirements.item(30521), ItemRequirements.item(30527), ItemRequirements.item(30533), ItemRequirements.item(30539), ItemRequirements.item(30545)), ItemRequirements.any("Ahrim's robeskirt", ItemRequirements.item(4714), ItemRequirements.range(4874, 4878), ItemRequirements.item(30449), ItemRequirements.item(30523), ItemRequirements.item(30529), ItemRequirements.item(30535), ItemRequirements.item(30541), ItemRequirements.item(30547))), ItemRequirements.all(ItemRequirements.any("Dharok's helm", ItemRequirements.item(4716), ItemRequirements.range(4880, 4884)), ItemRequirements.any("Dharok's greataxe", ItemRequirements.item(4718), ItemRequirements.range(4886, 4890)), ItemRequirements.any("Dharok's platebody", ItemRequirements.item(4720), ItemRequirements.range(4892, 4896)), ItemRequirements.any("Dharok's platelegs", ItemRequirements.item(4722), ItemRequirements.range(4898, 4902))), ItemRequirements.all(ItemRequirements.any("Guthan's helm", ItemRequirements.item(4724), ItemRequirements.range(4904, 4908)), ItemRequirements.any("Guthan's warspear", ItemRequirements.item(4726), ItemRequirements.range(4910, 4914)), ItemRequirements.any("Guthan's platebody", ItemRequirements.item(4728), ItemRequirements.range(4916, 4920)), ItemRequirements.any("Guthan's chainskirt", ItemRequirements.item(4730), ItemRequirements.range(4922, 4926))), ItemRequirements.all(ItemRequirements.any("Karil's coif", ItemRequirements.item(4732), ItemRequirements.range(4928, 4932)), ItemRequirements.any("Karil's crossbow", ItemRequirements.item(4734), ItemRequirements.range(4934, 4938)), ItemRequirements.any("Karil's leathertop", ItemRequirements.item(4736), ItemRequirements.range(4940, 4944)), ItemRequirements.any("Karil's leatherskirt", ItemRequirements.item(4738), ItemRequirements.range(4946, 4950))), ItemRequirements.all(ItemRequirements.any("Torag's helm", ItemRequirements.item(4745), ItemRequirements.range(4952, 4956)), ItemRequirements.any("Torag's hammers", ItemRequirements.item(4747), ItemRequirements.range(4958, 4962)), ItemRequirements.any("Torag's platebody", ItemRequirements.item(4749), ItemRequirements.range(4964, 4968)), ItemRequirements.any("Torag's platelegs", ItemRequirements.item(4751), ItemRequirements.range(4970, 4974))), ItemRequirements.all(ItemRequirements.any("Verac's helm", ItemRequirements.item(4753), ItemRequirements.range(4976, 4980)), ItemRequirements.any("Verac's flail", ItemRequirements.item(4755), ItemRequirements.range(4982, 4986)), ItemRequirements.any("Verac's brassard", ItemRequirements.item(4757), ItemRequirements.range(4988, 4992)), ItemRequirements.any("Verac's plateskirt", ItemRequirements.item(4759), ItemRequirements.range(4994, 4998))))), (Object)new EmoteClue(12548, "Jig at Jiggig. Beware of double agents! Equip a Rune spear, rune platelegs and any rune heraldic helm.", "Jiggig", STASHUnit.IN_THE_MIDDLE_OF_JIGGIG, new WorldPoint(2477, 3047, 0), Enemy.DOUBLE_AGENT_108, Emote.JIG, ItemRequirements.range("Any rune heraldic helm", 10286, 10294), ItemRequirements.item(1247), ItemRequirements.item(1079)), (Object)new EmoteClue(10212, "Cheer at the games room. Have nothing equipped at all when you do.", "Burthorpe Games Room", null, new WorldPoint(2207, 4952, 0), Emote.CHEER, ItemRequirements.emptySlot("Nothing at all", EquipmentInventorySlot.values())), (Object[])new EmoteClue[]{new EmoteClue(10224, "Panic on the pier where you catch the Fishing trawler. Have nothing equipped at all when you do.", "Fishing trawler", null, new WorldPoint(2676, 3169, 0), Emote.PANIC, ItemRequirements.emptySlot("Nothing at all", EquipmentInventorySlot.values())), new EmoteClue(10240, "Panic in the heart of the Haunted Woods. Beware of double agents! Have no items equipped when you do.", "Haunted Woods (ALQ)", null, new WorldPoint(3611, 3492, 0), Enemy.DOUBLE_AGENT_108, Emote.PANIC, ItemRequirements.emptySlot("Nothing at all", EquipmentInventorySlot.values())), new EmoteClue(19835, "Show your anger towards the Statue of Saradomin in Ellamaria's garden. Beware of double agents! Equip a zamorak godsword.", "Varrock Castle", STASHUnit.BY_THE_BEAR_CAGE_IN_VARROCK_PALACE_GARDENS, new WorldPoint(3230, 3478, 0), Enemy.DOUBLE_AGENT_141, Emote.ANGRY, ItemRequirements.any("Zamorak godsword", ItemRequirements.item(11808), ItemRequirements.item(20374))), new EmoteClue(19835, "Show your anger at the Wise old man. Beware of double agents! Equip an abyssal whip, a legend's cape and some spined chaps.", "Draynor Village", STASHUnit.BEHIND_MISS_SCHISM_IN_DRAYNOR_VILLAGE, new WorldPoint(3088, 3254, 0), Enemy.DOUBLE_AGENT_141, Emote.ANGRY, ItemRequirements.any("Abyssal whip", ItemRequirements.item(4151), ItemRequirements.item(12773), ItemRequirements.item(12774), ItemRequirements.item(26482), ItemRequirements.item(12006), ItemRequirements.item(26484)), ItemRequirements.item(1052), ItemRequirements.item(6135)), new EmoteClue(19835, "Beckon by a collection of crystalline maple trees. Beware of double agents! Equip Bryophyta's staff and a nature tiara.", "North of Prifddinas", STASHUnit.CRYSTALLINE_MAPLE_TREES, new WorldPoint(2211, 3427, 0), Enemy.DOUBLE_AGENT_141, Emote.BECKON, ItemRequirements.range("Bryophyta's staff", 22368, 22370), ItemRequirements.item(5541)), new EmoteClue(10274, "Beckon in the Digsite, near the eastern winch. Bow before you talk to me. Equip a green gnome hat, snakeskin boots and an iron pickaxe.", "Digsite", STASHUnit.DIGSITE, new WorldPoint(3370, 3425, 0), Emote.BECKON, Emote.BOW, ItemRequirements.item(658), ItemRequirements.item(6328), ItemRequirements.item(1267)), new EmoteClue(10260, "Beckon in Tai Bwo Wannai. Clap before you talk to me. Equip green dragonhide chaps, a ring of dueling and a mithril medium helmet.", "Tai Bwo Wannai", STASHUnit.SOUTH_OF_THE_SHRINE_IN_TAI_BWO_WANNAI_VILLAGE, new WorldPoint(2803, 3073, 0), Emote.BECKON, Emote.CLAP, ItemRequirements.item(1099), ItemRequirements.any("Ring of dueling", ItemRequirements.item(2566), ItemRequirements.item(2564), ItemRequirements.item(2562), ItemRequirements.item(2560), ItemRequirements.item(2558), ItemRequirements.item(2556), ItemRequirements.item(2554), ItemRequirements.item(2552)), ItemRequirements.item(1143)), new EmoteClue(19776, "Beckon in the Shayzien Combat Ring. Show your anger before you talk to me. Equip an adamant platebody, adamant full helm and adamant platelegs.", "Shayzien Combat Ring", STASHUnit.WEST_OF_THE_SHAYZIEN_COMBAT_RING, new WorldPoint(1543, 3623, 0), Emote.BECKON, Emote.ANGRY, ItemRequirements.item(1073), ItemRequirements.item(1123), ItemRequirements.item(1161)), new EmoteClue(19835, "Bow near Lord Iorwerth. Beware of double agents! Equip a charged crystal bow.", "Lord Iorwerth's camp", STASHUnit.TENT_IN_LORD_IORWERTHS_ENCAMPMENT, new WorldPoint(2205, 3252, 0), Enemy.DOUBLE_AGENT_141, Emote.BOW, ACTIVE_CRYSTAL_BOW_OR_BOW_OF_FAERDHINEN), new EmoteClue(19835, "Bow in the Iorwerth Camp. Beware of double agents! Equip a charged crystal bow.", "Lord Iorwerth's camp", STASHUnit.TENT_IN_LORD_IORWERTHS_ENCAMPMENT, new WorldPoint(2205, 3252, 0), Enemy.DOUBLE_AGENT_141, Emote.BOW, ACTIVE_CRYSTAL_BOW_OR_BOW_OF_FAERDHINEN), new EmoteClue(10188, "Bow outside the entrance to the Legends' Guild. Equip iron platelegs, an emerald amulet and an oak longbow.", "Legend's Guild", STASHUnit.OUTSIDE_THE_LEGENDS_GUILD_GATES, new WorldPoint(2729, 3349, 0), Emote.BOW, ItemRequirements.item(1067), ItemRequirements.item(845), ItemRequirements.item(1696)), new EmoteClue(19789, "Bow on the ground floor of the Legends' Guild. Equip a Cape of Legends, a dragon battleaxe and an amulet of glory.", "Legend's Guild", STASHUnit.OUTSIDE_THE_LEGENDS_GUILD_DOOR, new WorldPoint(2728, 3377, 0), Emote.BOW, ItemRequirements.item(1052), ItemRequirements.any("Dragon battleaxe", ItemRequirements.item(1377), ItemRequirements.item(28037)), ItemRequirements.any("Any amulet of glory", ItemRequirements.item(1704), ItemRequirements.item(1706), ItemRequirements.item(1708), ItemRequirements.item(1710), ItemRequirements.item(1712), ItemRequirements.item(11976), ItemRequirements.item(11978))), new EmoteClue(10232, "Bow in the office of the Emir's Arena. Equip an iron chain body, leather chaps and coif.", "Emir's Arena", STASHUnit.EMIRS_ARENA_TICKET_OFFICE, new WorldPoint(3314, 3241, 0), Emote.BOW, ItemRequirements.item(1101), ItemRequirements.item(1095), ItemRequirements.item(1169)), new EmoteClue(10238, "Bow at the top of the lighthouse. Beware of double agents! Equip a blue dragonhide body, blue dragonhide vambraces and no jewelry.", "Lighthouse", STASHUnit.TOP_FLOOR_OF_THE_LIGHTHOUSE, new WorldPoint(2511, 3641, 2), Enemy.DOUBLE_AGENT_108, Emote.BOW, ItemRequirements.item(2499), ItemRequirements.item(2487), ItemRequirements.emptySlot("No jewellery", EquipmentInventorySlot.AMULET, EquipmentInventorySlot.RING)), new EmoteClue(28910, "Bow within the temple in Civitas illa Fortis. Equip any piece of sunfire fanatic armour.", "Civitas illa Fortis", STASHUnit.TEMPLE_SOUTHEAST_OF_THE_BAZAAR, new WorldPoint(1699, 3087, 0), Emote.BOW, ItemRequirements.any("Any piece of Sunfire Fanatic armour", ItemRequirements.item(28933), ItemRequirements.item(28936), ItemRequirements.item(28939))), new EmoteClue(10252, "Blow a kiss between the tables in Shilo Village bank. Beware of double agents! Equip a blue mystic hat, bone spear and rune platebody.", "Shilo Village", STASHUnit.SHILO_VILLAGE_BANK, new WorldPoint(2851, 2954, 0), Enemy.DOUBLE_AGENT_108, Emote.BLOW_KISS, ItemRequirements.item(4089), ItemRequirements.item(5016), ItemRequirements.item(1127)), new EmoteClue(12075, "Blow a kiss in the heart of the lava maze. Equip black dragonhide chaps, a spotted cape and a rolling pin.", "Lava maze", STASHUnit.NEAR_A_LADDER_IN_THE_WILDERNESS_LAVA_MAZE, new WorldPoint(3069, 3861, 0), Emote.BLOW_KISS, ItemRequirements.item(2497), ItemRequirements.any("Spotted cape", ItemRequirements.item(10069), ItemRequirements.item(10073)), ItemRequirements.item(7445)), new EmoteClue(19835, "Blow a kiss outside K'ril Tsutsaroth's chamber. Beware of double agents! Equip a zamorak full helm and the shadow sword.", "K'ril's chamber", STASHUnit.OUTSIDE_KRIL_TSUTSAROTHS_ROOM, new WorldPoint(2925, 5333, 2), Enemy.DOUBLE_AGENT_141, Emote.BLOW_KISS, ItemRequirements.item(2657), ItemRequirements.item(10858)), new EmoteClue(10210, "Cheer at the Druids' Circle. Equip a blue wizard hat, a bronze two-handed sword and HAM boots.", "Taverley stone circle", STASHUnit.TAVERLEY_STONE_CIRCLE, new WorldPoint(2924, 3478, 0), Emote.CHEER, ItemRequirements.item(579), ItemRequirements.item(1307), ItemRequirements.item(4310)), new EmoteClue(12031, "Cheer in the Edgeville general store. Dance before you talk to me. Equip a brown apron, leather boots and leather gloves.", "Edgeville", STASHUnit.NORTH_OF_EVIL_DAVES_HOUSE_IN_EDGEVILLE, new WorldPoint(3080, 3509, 0), Emote.CHEER, Emote.DANCE, ItemRequirements.item(1757), ItemRequirements.item(1061), ItemRequirements.item(1059)), new EmoteClue(10272, "Cheer in the Ogre Pen in the Training Camp. Show you are angry before you talk to me. Equip a green dragonhide body and chaps and a steel square shield.", "King Lathas' camp", STASHUnit.OGRE_CAGE_IN_KING_LATHAS_TRAINING_CAMP, new WorldPoint(2527, 3375, 0), Emote.CHEER, Emote.ANGRY, ItemRequirements.item(1135), ItemRequirements.item(1099), ItemRequirements.item(1177)), new EmoteClue(19835, "Cheer in the Entrana church. Beware of double agents! Equip a full set of black dragonhide armour.", "Entrana church", STASHUnit.ENTRANA_CHAPEL, new WorldPoint(2852, 3349, 0), Enemy.DOUBLE_AGENT_141, Emote.CHEER, ItemRequirements.item(2491), ItemRequirements.item(2497), ItemRequirements.item(2503)), new EmoteClue(10192, "Cheer for the monks at Port Sarim. Equip a coif, steel plateskirt and a sapphire necklace.", "Port Sarim", STASHUnit.NEAR_THE_ENTRANA_FERRY_IN_PORT_SARIM, new WorldPoint(3047, 3237, 0), Emote.CHEER, ItemRequirements.item(1169), ItemRequirements.item(1083), ItemRequirements.item(1656)), new EmoteClue(10228, "Clap in the main exam room in the Exam Centre. Equip a white apron, green gnome boots and leather gloves.", "Exam Centre", STASHUnit.OUTSIDE_THE_DIGSITE_EXAM_CENTRE, new WorldPoint(3361, 3339, 0), Emote.CLAP, ItemRequirements.item(1005), ItemRequirements.item(628), ItemRequirements.item(1059)), new EmoteClue(10182, "Clap on the causeway to the Wizards' Tower. Equip an iron medium helmet, emerald ring and a white apron.", "Wizards' Tower", STASHUnit.ON_THE_BRIDGE_TO_THE_MISTHALIN_WIZARDS_TOWER, new WorldPoint(3113, 3196, 0), Emote.CLAP, ItemRequirements.item(1137), ItemRequirements.item(1639), ItemRequirements.item(1005)), new EmoteClue(10206, "Clap on the top level of the mill, north of East Ardougne. Equip a blue gnome robe top, HAM robe bottom and an unenchanted tiara.", "East Ardougne", STASHUnit.UPSTAIRS_IN_THE_ARDOUGNE_WINDMILL, new WorldPoint(2635, 3385, 3), Emote.CLAP, ItemRequirements.item(640), ItemRequirements.item(4300), ItemRequirements.item(5525)), new EmoteClue(12025, "Clap in Seers court house. Spin before you talk to me. Equip an adamant halberd, blue mystic robe bottom and a diamond ring.", "Seers Village", STASHUnit.OUTSIDE_THE_SEERS_VILLAGE_COURTHOUSE, new WorldPoint(2735, 3469, 0), Emote.CLAP, Emote.SPIN, ItemRequirements.item(3200), ItemRequirements.item(4093), ItemRequirements.item(1643)), new EmoteClue(19835, "Clap in the magic axe hut. Beware of double agents! Equip only some flared trousers.", "Magic axe hut", STASHUnit.OUTSIDE_THE_WILDERNESS_AXE_HUT, new WorldPoint(3191, 3960, 0), Enemy.DOUBLE_AGENT_141, Emote.CLAP, ItemRequirements.item(10394), ItemRequirements.item(1523), ItemRequirements.emptySlot("Nothing else", EquipmentInventorySlot.HEAD, EquipmentInventorySlot.CAPE, EquipmentInventorySlot.AMULET, EquipmentInventorySlot.WEAPON, EquipmentInventorySlot.BODY, EquipmentInventorySlot.SHIELD, EquipmentInventorySlot.GLOVES, EquipmentInventorySlot.BOOTS, EquipmentInventorySlot.RING, EquipmentInventorySlot.AMMO)), new EmoteClue(23046, "Clap your hands north of Mount Karuulm Spin before you talk to me. Equip an adamant warhammer, a ring of life and a pair of mithril boots.", "Mount Karuulm", STASHUnit.NORTH_OF_MOUNT_KARUULM, new WorldPoint(1306, 3839, 0), Emote.CLAP, Emote.SPIN, ItemRequirements.item(1345), ItemRequirements.item(2570), ItemRequirements.item(4127)), new EmoteClue(10276, "Cry in the Catherby Ranging shop. Bow before you talk to me. Equip blue gnome boots, a hard leather body and an unblessed silver sickle.", "Catherby", STASHUnit.HICKTONS_ARCHERY_EMPORIUM, new WorldPoint(2823, 3443, 0), Emote.CRY, Emote.BOW, ItemRequirements.item(630), ItemRequirements.item(1131), ItemRequirements.item(2961)), new EmoteClue(12027, "Cry on the shore of Catherby beach. Laugh before you talk to me, equip an adamant sq shield, a bone dagger and mithril platebody.", "Catherby", STASHUnit.OUTSIDE_HARRYS_FISHING_SHOP_IN_CATHERBY, new WorldPoint(2852, 3429, 0), Emote.CRY, Emote.LAUGH, ItemRequirements.item(1183), ItemRequirements.item(8872), ItemRequirements.item(1121)), new EmoteClue(10266, "Cry on top of the western tree in the Gnome Agility Arena. Indicate 'no' before you talk to me. Equip a steel kiteshield, ring of forging and green dragonhide chaps.", "Gnome Stronghold", STASHUnit.GNOME_STRONGHOLD_BALANCING_ROPE, new WorldPoint(2473, 3420, 2), Emote.CRY, Emote.NO, ItemRequirements.item(1193), ItemRequirements.item(2568), ItemRequirements.item(1099)), new EmoteClue(19835, "Cry in the TzHaar gem store. Beware of double agents! Equip a fire cape and TokTz-Xil-Ul.", "Tzhaar gem store", STASHUnit.TZHAAR_GEM_STORE, new WorldPoint(2463, 5149, 0), Enemy.DOUBLE_AGENT_141, Emote.CRY, ItemRequirements.any("Fire cape", ItemRequirements.item(6570), ItemRequirements.item(24223), ItemRequirements.item(13329), ItemRequirements.item(24134), ItemRequirements.item(21295), ItemRequirements.item(24224), ItemRequirements.item(21285), ItemRequirements.item(24133)), ItemRequirements.item(6522)), new EmoteClue(19780, "Cry in the Draynor Village jail. Jump for joy before you talk to me. Equip an adamant sword, a sapphire amulet and an adamant plateskirt.", "Draynor Village jail", STASHUnit.OUTSIDE_DRAYNOR_VILLAGE_JAIL, new WorldPoint(3128, 3245, 0), Emote.CRY, Emote.JUMP_FOR_JOY, ItemRequirements.item(1287), ItemRequirements.item(1694), ItemRequirements.item(1091)), new EmoteClue(10200, "Dance at the crossroads north of Draynor. Equip an iron chain body, a sapphire ring and a longbow.", "Draynor Village", STASHUnit.CROSSROADS_NORTH_OF_DRAYNOR_VILLAGE, new WorldPoint(3109, 3294, 0), Emote.DANCE, ItemRequirements.item(1101), ItemRequirements.item(1637), ItemRequirements.item(839)), new EmoteClue(10208, "Dance in the Party Room. Equip a steel full helmet, steel platebody and an iron plateskirt.", "Falador Party Room", STASHUnit.OUTSIDE_THE_FALADOR_PARTY_ROOM, new WorldPoint(3045, 3376, 0), Emote.DANCE, ItemRequirements.item(1157), ItemRequirements.item(1119), ItemRequirements.item(1081)), new EmoteClue(10180, "Dance in the shack in Lumbridge Swamp. Equip a bronze dagger, iron full helmet and a gold ring.", "Lumbridge swamp", STASHUnit.NEAR_A_SHED_IN_LUMBRIDGE_SWAMP, new WorldPoint(3203, 3169, 0), Emote.DANCE, ItemRequirements.item(1205), ItemRequirements.item(1153), ItemRequirements.item(1635)), new EmoteClue(12021, "Dance in the dark caves beneath Lumbridge Swamp. Blow a kiss before you talk to me. Equip an air staff, Bronze full helm and an amulet of power.", "Lumbridge swamp caves", STASHUnit.LUMBRIDGE_SWAMP_CAVES, new WorldPoint(3168, 9571, 0), Emote.DANCE, Emote.BLOW_KISS, 6533, ItemRequirements.item(1381), ItemRequirements.item(1155), ItemRequirements.item(1731)), new EmoteClue(10242, "Dance at the cat-doored pyramid in Sophanem. Beware of double agents! Equip a ring of life, an uncharged amulet of glory and an adamant two-handed sword.", "Pyramid Of Sophanem", STASHUnit.OUTSIDE_THE_GREAT_PYRAMID_OF_SOPHANEM, new WorldPoint(3294, 2781, 0), Enemy.DOUBLE_AGENT_108, Emote.DANCE, ItemRequirements.item(2570), ItemRequirements.item(1704), ItemRequirements.item(1317)), new EmoteClue(10254, "Dance in the centre of Canifis. Bow before you talk to me. Equip a green gnome robe top, mithril plate legs and an iron two-handed sword.", "Canifis", STASHUnit.CENTRE_OF_CANIFIS, new WorldPoint(3492, 3488, 0), Emote.DANCE, Emote.BOW, ItemRequirements.item(638), ItemRequirements.item(1071), ItemRequirements.item(1309)), new EmoteClue(19835, "Dance in the King Black Dragon's lair. Beware of double agents! Equip a black dragonhide body, black dragonhide vambraces and a black dragon mask.", "King black dragon's lair", STASHUnit.KING_BLACK_DRAGONS_LAIR, new WorldPoint(2271, 4680, 0), Enemy.DOUBLE_AGENT_141, Emote.DANCE, ItemRequirements.item(2503), ItemRequirements.item(2491), ItemRequirements.item(12524)), new EmoteClue(19831, "Dance at the entrance to the Grand Exchange. Equip a pink skirt, pink robe top and a body tiara.", "Grand Exchange", STASHUnit.SOUTH_OF_THE_GRAND_EXCHANGE, new WorldPoint(3165, 3467, 0), Emote.DANCE, ItemRequirements.item(1013), ItemRequirements.item(636), ItemRequirements.item(5533)), new EmoteClue(19835, "Goblin Salute in the Goblin Village. Beware of double agents! Equip a bandos godsword, a bandos cloak and a bandos platebody.", "Goblin Village", STASHUnit.OUTSIDE_MUDKNUCKLES_HUT, new WorldPoint(2956, 3505, 0), Enemy.DOUBLE_AGENT_141, Emote.GOBLIN_SALUTE, ItemRequirements.item(12480), ItemRequirements.item(12273), ItemRequirements.any("Bandos godsword", ItemRequirements.item(11804), ItemRequirements.item(20370))), new EmoteClue(10194, "Headbang in the mine north of Al Kharid. Equip a desert shirt, leather gloves and leather boots.", "Al Kharid mine", STASHUnit.AL_KHARID_SCORPION_MINE, new WorldPoint(3299, 3289, 0), Emote.HEADBANG, ItemRequirements.item(1833), ItemRequirements.item(1059), ItemRequirements.item(1061)), new EmoteClue(12542, "Headbang at the exam centre. Beware of double agents! Equip a mystic fire staff, a diamond bracelet and rune boots.", "Exam Centre", STASHUnit.INSIDE_THE_DIGSITE_EXAM_CENTRE, new WorldPoint(3362, 3340, 0), Enemy.DOUBLE_AGENT_108, Emote.HEADBANG, ItemRequirements.item(1401), ItemRequirements.item(11092), ItemRequirements.item(4131)), new EmoteClue(12080, "Headbang at the top of Slayer Tower. Equip a seercull, a combat bracelet and helm of Neitiznot.", "Slayer Tower", STASHUnit.OUTSIDE_THE_SLAYER_TOWER_GARGOYLE_ROOM, new WorldPoint(3421, 3537, 2), Emote.HEADBANG, ItemRequirements.item(6724), ItemRequirements.any("Combat bracelet", ItemRequirements.range(11118, 11126), ItemRequirements.item(11974), ItemRequirements.item(11972)), ItemRequirements.item(10828)), new EmoteClue(10220, "Dance a jig by the entrance to the Fishing Guild. Equip an emerald ring, a sapphire amulet, and a bronze chain body.", "Fishing Guild", STASHUnit.OUTSIDE_THE_FISHING_GUILD, new WorldPoint(2610, 3391, 0), Emote.JIG, ItemRequirements.item(1639), ItemRequirements.item(1694), ItemRequirements.item(1103)), new EmoteClue(10278, "Dance a jig under Shantay's Awning. Bow before you talk to me. Equip a pointed blue snail helmet, an air staff and a bronze square shield.", "Shantay Pass", STASHUnit.SHANTAY_PASS, new WorldPoint(3304, 3124, 0), Emote.JIG, Emote.BOW, ItemRequirements.item(3343), ItemRequirements.item(1381), ItemRequirements.item(1173)), new EmoteClue(19833, "Do a jig in Varrock's rune store. Equip an air tiara and a staff of water.", "Varrock rune store", STASHUnit.AUBURYS_SHOP_IN_VARROCK, new WorldPoint(3253, 3401, 0), Emote.JIG, ItemRequirements.item(5527), ItemRequirements.item(1383)), new EmoteClue(10214, "Jump for joy at the beehives. Equip a desert shirt, green gnome robe bottoms and a steel axe.", "Catherby", STASHUnit.CATHERBY_BEEHIVE_FIELD, new WorldPoint(2759, 3445, 0), Emote.JUMP_FOR_JOY, ItemRequirements.item(1833), ItemRequirements.item(648), ItemRequirements.item(1353)), new EmoteClue(10268, "Jump for joy in Yanille bank. Dance a jig before you talk to me. Equip a brown apron, adamantite medium helmet and snakeskin chaps.", "Yanille", STASHUnit.OUTSIDE_YANILLE_BANK, new WorldPoint(2610, 3092, 0), Emote.JUMP_FOR_JOY, Emote.JIG, ItemRequirements.item(1757), ItemRequirements.item(1145), ItemRequirements.item(6324)), new EmoteClue(12029, "Jump for joy in the TzHaar sword shop. Shrug before you talk to me. Equip a Steel longsword, Blue D'hide body and blue mystic gloves.", "Tzhaar weapon store", STASHUnit.TZHAAR_WEAPONS_STORE, new WorldPoint(2477, 5146, 0), Emote.JUMP_FOR_JOY, Emote.SHRUG, ItemRequirements.item(1295), ItemRequirements.item(2499), ItemRequirements.item(4095)), new EmoteClue(12083, "Jump for joy in the Ancient Cavern. Equip a granite shield, splitbark body and any rune heraldic helm.", "Ancient cavern", STASHUnit.ENTRANCE_OF_THE_CAVERN_UNDER_THE_WHIRLPOOL, new WorldPoint(1768, 5366, 1), Emote.JUMP_FOR_JOY, ItemRequirements.item(3122), ItemRequirements.item(3387), ItemRequirements.range("Any rune heraldic helm", 10286, 10294)), new EmoteClue(12074, "Jump for joy at the Neitiznot rune rock. Equip Rune boots, a proselyte hauberk and a dragonstone ring.", "Fremennik Isles", STASHUnit.NEAR_A_RUNITE_ROCK_IN_THE_FREMENNIK_ISLES, new WorldPoint(2375, 3850, 0), Emote.JUMP_FOR_JOY, ItemRequirements.item(4131), ItemRequirements.item(9674), ItemRequirements.item(1645)), new EmoteClue(19835, "Jump for joy in the centre of Zul-Andra. Beware of double agents! Equip a dragon 2h sword, bandos boots and an obsidian cape.", "Zul-Andra", STASHUnit.NEAR_THE_PIER_IN_ZULANDRA, new WorldPoint(2199, 3056, 0), Enemy.DOUBLE_AGENT_141, Emote.JUMP_FOR_JOY, ItemRequirements.item(7158), ItemRequirements.any("Bandos boots", ItemRequirements.item(11836), ItemRequirements.item(21733), ItemRequirements.item(28945)), ItemRequirements.item(6568)), new EmoteClue(29857, "Jump for Joy in the mine near the Twilight Temple. Bow before you talk to me. Equip a maple longbow, a ruby amulet and some steel platelegs.", "Twilight Temple", STASHUnit.TWILIGHT_TEMPLE_MINE, new WorldPoint(1672, 3284, 0), Emote.JUMP_FOR_JOY, Emote.BOW, ItemRequirements.item(851), ItemRequirements.item(1698), ItemRequirements.item(1069)), new EmoteClue(12082, "Laugh by the fountain of heroes. Equip splitbark legs, dragon boots and a Rune longsword.", "Fountain of heroes", STASHUnit.FOUNTAIN_OF_HEROES, new WorldPoint(2920, 9893, 0), Emote.LAUGH, ItemRequirements.item(3389), ItemRequirements.any("Dragon boots", ItemRequirements.item(11840), ItemRequirements.item(22234), ItemRequirements.item(13239)), ItemRequirements.item(1303)), new EmoteClue(10248, "Laugh in Jokul's tent in the Mountain Camp. Beware of double agents! Equip a rune full helmet, blue dragonhide chaps and a fire battlestaff.", "Mountain Camp", STASHUnit.MOUNTAIN_CAMP_GOAT_ENCLOSURE, new WorldPoint(2812, 3681, 0), Enemy.DOUBLE_AGENT_108, Emote.LAUGH, ItemRequirements.item(1163), ItemRequirements.item(2493), ItemRequirements.item(1393)), new EmoteClue(10226, "Laugh at the crossroads south of the Sinclair Mansion. Equip a cowl, a blue wizard robe top and an iron scimitar.", "Sinclair Mansion", STASHUnit.ROAD_JUNCTION_SOUTH_OF_SINCLAIR_MANSION, new WorldPoint(2741, 3536, 0), Emote.LAUGH, ItemRequirements.item(1167), ItemRequirements.item(577), ItemRequirements.item(1323)), new EmoteClue(19790, "Laugh in front of the gem store in Ardougne market. Equip a Castlewars bracelet, a dragonstone amulet and a ring of forging.", "Ardougne", STASHUnit.NEAR_THE_GEM_STALL_IN_ARDOUGNE_MARKET, new WorldPoint(2666, 3304, 0), Emote.LAUGH, ItemRequirements.any("Castle wars bracelet", ItemRequirements.range(11079, 11083)), ItemRequirements.item(1702), ItemRequirements.item(2568)), new EmoteClue(29858, "Nod your head where the River Ortus meets the Proudspire. Indicate 'no' before you talk to me. Equip a blue wizard hat, a blue wizard robe and wear nothing on your legs.", "East of The Proudspire", STASHUnit.ORTUS_MEETS_PROUDSPIRE, new WorldPoint(1626, 3241, 0), Emote.YES, Emote.NO, ItemRequirements.item(579), ItemRequirements.item(577), ItemRequirements.emptySlot("Nothing on legs", EquipmentInventorySlot.LEGS)), new EmoteClue(10186, "Panic in the Limestone Mine. Equip bronze platelegs, a steel pickaxe and a steel medium helmet.", "Limestone Mine", STASHUnit.LIMESTONE_MINE, new WorldPoint(3372, 3498, 0), Emote.PANIC, ItemRequirements.item(1075), ItemRequirements.item(1269), ItemRequirements.item(1141)), new EmoteClue(10256, "Panic by the mausoleum in Morytania. Wave before you speak to me. Equip a mithril plate skirt, a maple longbow and no boots.", "Morytania mausoleum, access via the experiments cave", STASHUnit.MAUSOLEUM_OFF_THE_MORYTANIA_COAST, new WorldPoint(3504, 3576, 0), Emote.PANIC, Emote.WAVE, ItemRequirements.item(1085), ItemRequirements.item(851), ItemRequirements.emptySlot("No boots", EquipmentInventorySlot.BOOTS)), new EmoteClue(12546, "Panic on the Wilderness volcano bridge. Beware of double agents! Equip any headband and crozier.", "Wilderness volcano", STASHUnit.VOLCANO_IN_THE_NORTHEASTERN_WILDERNESS, new WorldPoint(3368, 3935, 0), Enemy.DOUBLE_AGENT_65, Emote.PANIC, ItemRequirements.any("Any headband", ItemRequirements.range(2645, 2649), ItemRequirements.range(12299, 12307)), ItemRequirements.any("Any crozier", ItemRequirements.item(12199), ItemRequirements.item(12263), ItemRequirements.item(12275), ItemRequirements.range(10440, 10444))), new EmoteClue(10250, "Panic by the pilot on White Wolf Mountain. Beware of double agents! Equip mithril platelegs, a ring of life and a rune axe.", "White Wolf Mountain", STASHUnit.GNOME_GLIDER_ON_WHITE_WOLF_MOUNTAIN, new WorldPoint(2847, 3499, 0), Enemy.DOUBLE_AGENT_108, Emote.PANIC, ItemRequirements.item(1071), ItemRequirements.item(2570), ItemRequirements.item(1359)), new EmoteClue(19835, "Panic by the big egg where no one dare goes and the ground is burnt. Beware of double agents! Equip a dragon med helm, a TokTz-Ket-Xil, a brine sabre, rune platebody and an uncharged amulet of glory.", "Lava dragon isle", STASHUnit.SOUTHEAST_CORNER_OF_LAVA_DRAGON_ISLE, new WorldPoint(3227, 3831, 0), Enemy.DOUBLE_AGENT_141, Emote.PANIC, ItemRequirements.item(1149), ItemRequirements.item(6524), ItemRequirements.item(11037), ItemRequirements.item(1127), ItemRequirements.any("Uncharged Amulet of glory", ItemRequirements.item(1704))), new EmoteClue(19787, "Panic at the area flowers meet snow. Equip Blue D'hide vambraces, a dragon spear and a rune plateskirt.", "Trollweiss mountain", STASHUnit.HALFWAY_DOWN_TROLLWEISS_MOUNTAIN, new WorldPoint(2776, 3781, 0), Emote.PANIC, ItemRequirements.item(2487), ItemRequirements.item(1249), ItemRequirements.item(1093), ItemRequirements.item(4084)), new EmoteClue(29859, "Panic outside the Twilight Temple. Beware of double agents! Equip a rune longsword, rune platebody and a rune plateskirt.", "Twilight Temple", STASHUnit.OUTSIDE_TWILIGHT_TEMPLE, new WorldPoint(1694, 3247, 0), Enemy.DOUBLE_AGENT_108, Emote.PANIC, ItemRequirements.item(1303), ItemRequirements.item(1127), ItemRequirements.item(1093)), new EmoteClue(19835, "Blow a raspberry in the bank of the Warriors' Guild. Beware of double agents! Equip a dragon battleaxe, a slayer helm of any kind and a dragon defender or avernic defender.", "Warriors' guild", STASHUnit.WARRIORS_GUILD_BANK_29047, new WorldPoint(2843, 3543, 0), Enemy.DOUBLE_AGENT_141, Emote.RASPBERRY, ItemRequirements.any("Dragon battleaxe", ItemRequirements.item(1377), ItemRequirements.item(28037)), ItemRequirements.any("Dragon defender or Avernic defender", ItemRequirements.item(12954), ItemRequirements.item(19722), ItemRequirements.item(24143), ItemRequirements.item(22322), ItemRequirements.item(24186), ItemRequirements.item(27550), ItemRequirements.item(27551), ItemRequirements.item(27552), ItemRequirements.item(27553)), ANY_SLAYER_HELMET), new EmoteClue(10216, "Blow a raspberry at the monkey cage in Ardougne Zoo. Equip a studded leather body, bronze platelegs and a normal staff with no orb.", "Ardougne Zoo", STASHUnit.NEAR_THE_PARROTS_IN_ARDOUGNE_ZOO, new WorldPoint(2607, 3282, 0), Emote.RASPBERRY, ItemRequirements.item(1133), ItemRequirements.item(1075), ItemRequirements.item(1379)), new EmoteClue(10222, "Blow raspberries outside the entrance to Keep Le Faye. Equip a coif, an iron platebody and leather gloves.", "Keep Le Faye", STASHUnit.OUTSIDE_KEEP_LE_FAYE, new WorldPoint(2757, 3401, 0), Emote.RASPBERRY, ItemRequirements.item(1169), ItemRequirements.item(1115), ItemRequirements.item(1059)), new EmoteClue(10236, "Blow a raspberry in the Fishing Guild bank. Beware of double agents! Equip an elemental shield, blue dragonhide chaps and a rune warhammer.", "Fishing Guild", STASHUnit.FISHING_GUILD_BANK, new WorldPoint(2588, 3419, 0), Enemy.DOUBLE_AGENT_108, Emote.RASPBERRY, ItemRequirements.item(2890), ItemRequirements.item(2493), ItemRequirements.item(1347)), new EmoteClue(10246, "Salute in the banana plantation. Beware of double agents! Equip a diamond ring, amulet of power, and nothing on your chest and legs.", "Karamja", STASHUnit.WEST_SIDE_OF_THE_KARAMJA_BANANA_PLANTATION, new WorldPoint(2914, 3168, 0), Enemy.DOUBLE_AGENT_108, Emote.SALUTE, ItemRequirements.item(1643), ItemRequirements.item(1731), ItemRequirements.emptySlot("Nothing on chest & legs", EquipmentInventorySlot.BODY, EquipmentInventorySlot.LEGS)), new EmoteClue(12077, "Salute in the Warriors' Guild bank. Equip only a black salamander.", "Warriors' guild", STASHUnit.WARRIORS_GUILD_BANK, new WorldPoint(2844, 3542, 0), Emote.SALUTE, ItemRequirements.item(10148), ItemRequirements.emptySlot("Nothing else", EquipmentInventorySlot.HEAD, EquipmentInventorySlot.CAPE, EquipmentInventorySlot.AMULET, EquipmentInventorySlot.BODY, EquipmentInventorySlot.SHIELD, EquipmentInventorySlot.LEGS, EquipmentInventorySlot.GLOVES, EquipmentInventorySlot.BOOTS, EquipmentInventorySlot.RING, EquipmentInventorySlot.AMMO)), new EmoteClue(12552, "Salute in the centre of the mess hall. Beware of double agents! Equip a rune halberd rune platebody and an amulet of strength.", "Hosidius mess hall", STASHUnit.HOSIDIUS_MESS, new WorldPoint(1646, 3631, 0), Enemy.DOUBLE_AGENT_108, Emote.SALUTE, ItemRequirements.item(3202), ItemRequirements.item(1127), ItemRequirements.item(1725)), new EmoteClue(19835, "Salute outside the gates of Cam Torum. Beware of double agents! Equip a full set of blue moon equipment.", "Cam Torum", STASHUnit.CAM_TORUM_ENTRANCE, new WorldPoint(1436, 3115, 0), Enemy.DOUBLE_AGENT_141, Emote.SALUTE, ItemRequirements.any("Blue moon helm", ItemRequirements.item(29019), ItemRequirements.item(29041)), ItemRequirements.any("Blue moon chestplate", ItemRequirements.item(29013), ItemRequirements.item(29037)), ItemRequirements.any("Blue moon tassets", ItemRequirements.item(29016), ItemRequirements.item(29039)), ItemRequirements.item(28988)), new EmoteClue(10202, "Shrug in the mine near Rimmington. Equip a gold necklace, a gold ring and a bronze spear.", "Rimmington mine", STASHUnit.RIMMINGTON_MINE, new WorldPoint(2976, 3238, 0), Emote.SHRUG, ItemRequirements.item(1654), ItemRequirements.item(1635), ItemRequirements.item(1237)), new EmoteClue(12023, "Shrug in Catherby bank. Yawn before you talk to me. Equip a maple longbow, green d'hide chaps and an iron med helm.", "Catherby", STASHUnit.OUTSIDE_CATHERBY_BANK, new WorldPoint(2808, 3440, 0), Emote.SHRUG, Emote.YAWN, ItemRequirements.item(851), ItemRequirements.item(1099), ItemRequirements.item(1137)), new EmoteClue(10234, "Shrug in the woods east of the Level 19 Wilderness Obelisk. Beware of double agents! Equip rune platelegs, an iron platebody and blue dragonhide vambraces.", "East of the Level 19 Wilderness Obelisk", STASHUnit.EAST_OF_THE_LEVEL_19_WILDERNESS_OBELISK, new WorldPoint(3241, 3672, 0), Enemy.DOUBLE_AGENT_65, Emote.SHRUG, ItemRequirements.item(1079), ItemRequirements.item(1115), ItemRequirements.item(2487)), new EmoteClue(19788, "Shrug in the Shayzien war tent. Equip a blue mystic robe bottom, a rune kiteshield and any bob shirt.", "Shayzien war tent", STASHUnit.SHAYZIEN_WAR_TENT, new WorldPoint(1487, 3635, 0), Emote.SHRUG, ItemRequirements.item(4093), ItemRequirements.item(1201), ItemRequirements.range("Any bob shirt", 10316, 10324)), new EmoteClue(19835, "Slap your head in the centre of the Kourend catacombs. Beware of double agents! Equip arclight or emberlight along with the amulet of the damned.", "Kourend catacombs", STASHUnit.CENTRE_OF_THE_CATACOMBS_OF_KOUREND, new WorldPoint(1663, 10045, 0), Enemy.DOUBLE_AGENT_141, Emote.SLAP_HEAD, ItemRequirements.any("Arclight or Emberlight", ItemRequirements.item(19675), ItemRequirements.item(30305), ItemRequirements.item(29589)), ItemRequirements.any("Amulet of the damned", ItemRequirements.item(12853), ItemRequirements.item(12851))), new EmoteClue(10218, "Spin at the crossroads north of Rimmington. Equip a green gnome hat, cream gnome top and leather chaps.", "Rimmington", STASHUnit.ROAD_JUNCTION_NORTH_OF_RIMMINGTON, new WorldPoint(2981, 3276, 0), Emote.SPIN, ItemRequirements.item(658), ItemRequirements.item(642), ItemRequirements.item(1095)), new EmoteClue(10196, "Spin in Draynor Manor by the fountain. Equip an iron platebody, studded leather chaps and a bronze full helmet.", "Draynor Manor", STASHUnit.DRAYNOR_MANOR_BY_THE_FOUNTAIN, new WorldPoint(3088, 3336, 0), Emote.SPIN, ItemRequirements.item(1115), ItemRequirements.item(1097), ItemRequirements.item(1155)), new EmoteClue(19835, "Spin in front of the Soul altar. Beware of double agents! Equip a dragon pickaxe, helm of neitiznot and a pair of rune boots.", "Soul altar", STASHUnit.SOUL_ALTAR, new WorldPoint(1815, 3856, 0), Enemy.DOUBLE_AGENT_141, Emote.SPIN, ItemRequirements.any("Dragon or Crystal pickaxe", ItemRequirements.item(11920), ItemRequirements.item(12797), ItemRequirements.item(13243), ItemRequirements.item(13244), ItemRequirements.item(23677), ItemRequirements.item(25376), ItemRequirements.item(30351), ItemRequirements.item(23680), ItemRequirements.item(23682), ItemRequirements.item(25063), ItemRequirements.item(30345), ItemRequirements.item(25369), ItemRequirements.item(30346)), ItemRequirements.item(10828), ItemRequirements.item(4131)), new EmoteClue(12162, "Spin in the Varrock Castle courtyard. Equip a black axe, a coif and a ruby ring.", "Varrock Castle", STASHUnit.OUTSIDE_VARROCK_PALACE_COURTYARD, new WorldPoint(3213, 3463, 0), Emote.SPIN, ItemRequirements.item(1361), ItemRequirements.item(1169), ItemRequirements.item(1641)), new EmoteClue(12073, "Spin in West Ardougne Church. Equip a dragon spear and red dragonhide chaps.", "West Ardougne Church", STASHUnit.CHAPEL_IN_WEST_ARDOUGNE, new WorldPoint(2530, 3290, 0), Emote.SPIN, ItemRequirements.item(1249), ItemRequirements.item(2495)), new EmoteClue(10258, "Spin on the bridge by the Barbarian Village. Salute before you talk to me. Equip purple gloves, a steel kiteshield and a mithril full helmet.", "Barbarian Village", STASHUnit.EAST_OF_THE_BARBARIAN_VILLAGE_BRIDGE, new WorldPoint(3105, 3420, 0), Emote.SPIN, Emote.SALUTE, ItemRequirements.item(2942), ItemRequirements.item(1193), ItemRequirements.item(1159)), new EmoteClue(19835, "Stamp in the Enchanted valley west of the waterfall. Beware of double agents! Equip a dragon axe.", "Enchanted Valley (BKQ)", STASHUnit.NORTHWESTERN_CORNER_OF_THE_ENCHANTED_VALLEY, new WorldPoint(3030, 4522, 0), Enemy.DOUBLE_AGENT_141, Emote.STAMP, ItemRequirements.any("Dragon or Crystal axe", ItemRequirements.item(6739), ItemRequirements.item(25378), ItemRequirements.item(28217), ItemRequirements.item(23673), ItemRequirements.item(23675), ItemRequirements.item(28220), ItemRequirements.item(28223), ItemRequirements.item(13241), ItemRequirements.item(13242), ItemRequirements.item(25066), ItemRequirements.item(25371), ItemRequirements.item(30347), ItemRequirements.item(30348))), new EmoteClue(10198, "Think in middle of the wheat field by the Lumbridge mill. Equip a blue gnome robetop, a turquoise gnome robe bottom and an oak shortbow.", "Lumbridge mill", STASHUnit.WHEAT_FIELD_NEAR_THE_LUMBRIDGE_WINDMILL, new WorldPoint(3159, 3298, 0), Emote.THINK, ItemRequirements.item(640), ItemRequirements.item(654), ItemRequirements.item(843)), new EmoteClue(10270, "Think in the centre of the Observatory. Spin before you talk to me. Equip a mithril chain body, green dragonhide chaps and a ruby amulet.", "Observatory", STASHUnit.OBSERVATORY, new WorldPoint(2439, 3161, 0), Emote.THINK, Emote.SPIN, ItemRequirements.item(1109), ItemRequirements.item(1099), ItemRequirements.item(1698)), new EmoteClue(19835, "Think on the western coast of Salvager Overlook. Beware of double agents! Equip a Hueycoatl hide coif and some Hueycoatl hide vambraces.", "Salvager Overlook", STASHUnit.WESTERN_SALVAGER_OVERLOOK, new WorldPoint(1610, 3302, 0), Enemy.DOUBLE_AGENT_141, Emote.THINK, ItemRequirements.item(30073), ItemRequirements.item(30082)), new EmoteClue(10230, "Wave along the south fence of the Lumber Yard. Equip a hard leather body, leather chaps and a bronze axe.", "Lumber Yard", STASHUnit.NEAR_THE_SAWMILL_OPERATORS_BOOTH, new WorldPoint(3307, 3491, 0), Emote.WAVE, ItemRequirements.item(1131), ItemRequirements.item(1095), ItemRequirements.item(1351)), new EmoteClue(12164, "Wave in the Falador gem store. Equip a Mithril pickaxe, Black platebody and an Iron Kiteshield.", "Falador", STASHUnit.NEAR_HERQUINS_SHOP_IN_FALADOR, new WorldPoint(2945, 3335, 0), Emote.WAVE, ItemRequirements.item(1273), ItemRequirements.item(1125), ItemRequirements.item(1191)), new EmoteClue(10190, "Wave on Mudskipper Point. Equip a black cape, leather chaps and a steel mace.", "Mudskipper Point (AIQ)", STASHUnit.MUDSKIPPER_POINT, new WorldPoint(2989, 3110, 0), Emote.WAVE, ItemRequirements.item(1019), ItemRequirements.item(1095), ItemRequirements.item(1424)), new EmoteClue(19835, "Wave on the northern wall of Castle Drakan. Beware of double agents! Wear a dragon sq shield, splitbark body and any boater.", "Castle Drakan", STASHUnit.NORTHERN_WALL_OF_CASTLE_DRAKAN, new WorldPoint(3562, 3379, 0), Enemy.DOUBLE_AGENT_141, Emote.WAVE, ItemRequirements.any("Dragon sq shield", ItemRequirements.item(1187), ItemRequirements.item(12418)), ItemRequirements.item(3387), ItemRequirements.any("Any boater", ItemRequirements.item(7319), ItemRequirements.item(7321), ItemRequirements.item(7323), ItemRequirements.item(7325), ItemRequirements.item(7327), ItemRequirements.item(12309), ItemRequirements.item(12311), ItemRequirements.item(12313))), new EmoteClue(19835, "Yawn in the 7th room of Pyramid Plunder. Beware of double agents! Equip a pharaoh sceptre and a full set of menaphite robes.", "Pyramid Plunder", STASHUnit._7TH_CHAMBER_OF_JALSAVRAH, new WorldPoint(1944, 4427, 0), Enemy.DOUBLE_AGENT_141, Emote.YAWN, ANY_PHARAOHS_SCEPTRE, ItemRequirements.any("Full set of menaphite robes", ItemRequirements.all(ItemRequirements.item(6392), ItemRequirements.item(6394), ItemRequirements.range(6396, 6398)), ItemRequirements.all(ItemRequirements.item(6400), ItemRequirements.item(6402), ItemRequirements.range(6404, 6406)))), new EmoteClue(10204, "Yawn in the Varrock library. Equip a green gnome robe top, HAM robe bottom and an iron warhammer.", "Varrock Castle", STASHUnit.VARROCK_PALACE_LIBRARY, new WorldPoint(3209, 3492, 0), Emote.YAWN, ItemRequirements.item(638), ItemRequirements.item(4300), ItemRequirements.item(1335)), new EmoteClue(10184, "Yawn in Draynor marketplace. Equip studded leather chaps, an iron kiteshield and a steel longsword.", "Draynor", STASHUnit.DRAYNOR_VILLAGE_MARKET, new WorldPoint(3083, 3253, 0), Emote.YAWN, ItemRequirements.item(1097), ItemRequirements.item(1191), ItemRequirements.item(1295)), new EmoteClue(10262, "Yawn in the Castle Wars lobby. Shrug before you talk to me. Equip a ruby amulet, a mithril scimitar and a Wilderness cape.", "Castle Wars", STASHUnit.CASTLE_WARS_BANK, new WorldPoint(2440, 3092, 0), Emote.YAWN, Emote.SHRUG, ItemRequirements.item(1698), ItemRequirements.item(1329), ANY_TEAM_CAPE), new EmoteClue(10244, "Yawn in the rogues' general store. Beware of double agents! Equip an adamant square shield, blue dragon vambraces and a rune pickaxe.", "Rogues general store", STASHUnit.NOTERAZZOS_SHOP_IN_THE_WILDERNESS, new WorldPoint(3026, 3701, 0), Enemy.DOUBLE_AGENT_65, Emote.YAWN, ItemRequirements.item(1183), ItemRequirements.item(2487), ItemRequirements.item(1275)), new EmoteClue(12081, "Yawn at the top of Trollheim. Equip a lava battlestaff, black dragonhide vambraces and a mind shield.", "Trollheim Mountain", STASHUnit.ON_TOP_OF_TROLLHEIM_MOUNTAIN, new WorldPoint(2887, 3676, 0), Emote.YAWN, ItemRequirements.any("Lava battlestaff", ItemRequirements.item(3053), ItemRequirements.item(21198)), ItemRequirements.item(2491), ItemRequirements.item(9731)), new EmoteClue(19778, "Yawn in the centre of the Arceuus Library. Nod your head before you talk to me. Equip blue dragonhide vambraces, adamant boots and an adamant dagger.", "Arceuus library", STASHUnit.ENTRANCE_OF_THE_ARCEUUS_LIBRARY, new WorldPoint(1632, 3807, 0), Emote.YAWN, Emote.YES, ItemRequirements.item(2487), ItemRequirements.item(4129), ItemRequirements.item(1211)), new EmoteClue(28914, "Yawn in the Fortis Grand Museum. Equip an emerald necklace, blue skirt, and turqoise gnome robe top.", "Fortis Grand Museum", STASHUnit.FORTIS_GRAND_MUSEUM, new WorldPoint(1712, 3163, 0), Emote.YAWN, ItemRequirements.item(1658), ItemRequirements.item(1011), ItemRequirements.item(644)), new EmoteClue(19835, "Swing a bullroarer at the top of the Watchtower. Beware of double agents! Equip a dragon plateskirt, climbing boots and a dragon chainbody.", "Yanille Watchtower", STASHUnit.TOP_FLOOR_OF_THE_YANILLE_WATCHTOWER, new WorldPoint(2930, 4717, 2), Enemy.DOUBLE_AGENT_141, Emote.BULL_ROARER, ItemRequirements.any("Dragon plateskirt", ItemRequirements.item(4585), ItemRequirements.item(12416)), ItemRequirements.any("Climbing boots", ItemRequirements.item(3105), ItemRequirements.item(23413)), ItemRequirements.any("Dragon chainbody", ItemRequirements.item(3140), ItemRequirements.item(12414)), ItemRequirements.item(716)), new EmoteClue(23182, "Blow a raspberry at Aris in her tent. Equip a gold ring and a gold necklace.", "Varrock", STASHUnit.GYPSY_TENT_ENTRANCE, new WorldPoint(3203, 3424, 0), Emote.RASPBERRY, ItemRequirements.item(1635), ItemRequirements.item(1654)), new EmoteClue(23182, "Bow to Brugsen Bursen at the Grand Exchange.", "Grand Exchange", null, new WorldPoint(3164, 3477, 0), Emote.BOW, new ItemRequirement[0]), new EmoteClue(23182, "Cheer at Iffie Nitter. Equip a chef hat and a red cape.", "Varrock", STASHUnit.FINE_CLOTHES_ENTRANCE, new WorldPoint(3205, 3416, 0), Emote.CHEER, ItemRequirements.item(1949), ItemRequirements.item(1007)), new EmoteClue(23182, "Clap at Bob's Brilliant Axes. Equip a bronze axe and leather boots.", "Lumbridge", STASHUnit.BOB_AXES_ENTRANCE, new WorldPoint(3231, 3203, 0), Emote.CLAP, ItemRequirements.item(1351), ItemRequirements.item(1061)), new EmoteClue(23182, "Panic at Al Kharid mine.", "Al Kharid mine", null, new WorldPoint(3303, 3271, 0), Emote.PANIC, new ItemRequirement[0]), new EmoteClue(23182, "Spin at Flynn's Mace Shop.", "Falador", null, new WorldPoint(2950, 3387, 0), Emote.SPIN, new ItemRequirement[0]), new EmoteClue(25786, "Salute by the Charcoal Burners. Equip a Farmer's strawhat, Shayzien platebody (5) and Pyromancer robes.", "Charcoal Burners", STASHUnit.CHARCOAL_BURNERS, new WorldPoint(1714, 3467, 0), Emote.SALUTE, ItemRequirements.any("Farmer's strawhat", ItemRequirements.item(13646), ItemRequirements.item(13647)), ItemRequirements.item(13381), ItemRequirements.item(20706))});
    private static final String UNICODE_CHECK_MARK = "\u2713";
    private static final String UNICODE_BALLOT_X = "\u2717";
    private final int itemId;
    private final String text;
    private final String locationName;
    @Nullable
    private final STASHUnit stashUnit;
    private final WorldPoint location;
    private final Emote firstEmote;
    private final Emote secondEmote;
    private final ItemRequirement[] itemRequirements;

    private EmoteClue(int itemId, String text, String locationName, STASHUnit stashUnit, WorldPoint location, Emote firstEmote, ItemRequirement ... itemRequirements) {
        this(itemId, text, locationName, stashUnit, location, firstEmote, (Emote)null, itemRequirements);
    }

    private EmoteClue(int itemId, String text, String locationName, STASHUnit stashUnit, WorldPoint location, Enemy enemy, Emote firstEmote, ItemRequirement ... itemRequirements) {
        this(itemId, text, locationName, stashUnit, location, firstEmote, (Emote)null, itemRequirements);
        this.setEnemy(enemy);
    }

    private EmoteClue(int itemId, String text, String locationName, STASHUnit stashUnit, WorldPoint location, Emote firstEmote, Emote secondEmote, ItemRequirement ... itemRequirements) {
        this.itemId = itemId;
        this.text = text;
        this.locationName = locationName;
        this.stashUnit = stashUnit;
        this.location = location;
        this.firstEmote = firstEmote;
        this.secondEmote = secondEmote;
        this.itemRequirements = itemRequirements;
    }

    private EmoteClue(int itemId, String text, String locationName, @Nullable STASHUnit stashUnit, WorldPoint location, Emote firstEmote, Emote secondEmote, int firePitVarbitId, ItemRequirement ... itemRequirements) {
        this(itemId, text, locationName, stashUnit, location, firstEmote, secondEmote, itemRequirements);
        this.setRequiresLight(true);
        this.setFirePitVarbitId(firePitVarbitId);
    }

    @Override
    public WorldPoint getLocation(ClueScrollPlugin plugin) {
        return this.location;
    }

    @Override
    public void makeOverlayHint(PanelComponent panelComponent, ClueScrollPlugin plugin) {
        panelComponent.getChildren().add(TitleComponent.builder().text("Emote Clue").build());
        panelComponent.getChildren().add(LineComponent.builder().left("Emotes:").build());
        panelComponent.getChildren().add(LineComponent.builder().left(this.getFirstEmote().getName()).leftColor(ClueScrollOverlay.TITLED_CONTENT_COLOR).build());
        if (this.getSecondEmote() != null) {
            panelComponent.getChildren().add(LineComponent.builder().left(this.getSecondEmote().getName()).leftColor(ClueScrollOverlay.TITLED_CONTENT_COLOR).build());
        }
        panelComponent.getChildren().add(LineComponent.builder().left("Location:").build());
        panelComponent.getChildren().add(LineComponent.builder().left(this.getLocationName()).leftColor(ClueScrollOverlay.TITLED_CONTENT_COLOR).build());
        if (this.itemRequirements.length > 0) {
            Client client = plugin.getClient();
            if (this.stashUnit != null) {
                client.runScript(new Object[]{1479, this.stashUnit.getObjectId(), 0, 0, 0});
                int[] intStack = client.getIntStack();
                boolean stashUnitBuilt = intStack[0] == 1;
                panelComponent.getChildren().add(LineComponent.builder().left("STASH Unit:").right(stashUnitBuilt ? UNICODE_CHECK_MARK : UNICODE_BALLOT_X).rightFont(FontManager.getDefaultFont()).rightColor(stashUnitBuilt ? Color.GREEN : Color.RED).build());
            }
            panelComponent.getChildren().add(LineComponent.builder().left("Equip:").build());
            Item[] equipment = plugin.getEquippedItems();
            Item[] inventory = plugin.getInventoryItems();
            if (equipment == null) {
                equipment = new Item[]{};
            }
            if (inventory == null) {
                inventory = new Item[]{};
            }
            Item[] combined = new Item[equipment.length + inventory.length];
            System.arraycopy(equipment, 0, combined, 0, equipment.length);
            System.arraycopy(inventory, 0, combined, equipment.length, inventory.length);
            for (ItemRequirement requirement : this.itemRequirements) {
                boolean equipmentFulfilled = requirement.fulfilledBy(equipment);
                boolean combinedFulfilled = requirement.fulfilledBy(combined);
                panelComponent.getChildren().add(LineComponent.builder().left(requirement.getCollectiveName(client)).leftColor(ClueScrollOverlay.TITLED_CONTENT_COLOR).right(combinedFulfilled ? UNICODE_CHECK_MARK : UNICODE_BALLOT_X).rightFont(FontManager.getDefaultFont()).rightColor(equipmentFulfilled ? Color.GREEN : (combinedFulfilled ? Color.ORANGE : Color.RED)).build());
            }
        }
        this.renderOverlayNote(panelComponent, plugin);
    }

    @Override
    public void makeWorldOverlayHint(Graphics2D graphics, ClueScrollPlugin plugin) {
        LocalPoint localPoint = LocalPoint.fromWorld((Client)plugin.getClient(), (WorldPoint)this.getLocation());
        if (localPoint != null) {
            OverlayUtil.renderTileOverlay(plugin.getClient(), graphics, localPoint, plugin.getEmoteImage(), Color.ORANGE);
        }
        this.makeSTASHOverlay(graphics, plugin);
    }

    @Override
    public int[] getConfigKeys() {
        return new int[]{this.text.hashCode()};
    }

    public void makeSTASHOverlay(Graphics2D graphics, ClueScrollPlugin plugin) {
        if (this.stashUnit != null) {
            WorldPoint[] worldPoints;
            for (WorldPoint worldPoint : worldPoints = this.stashUnit.getWorldPoints()) {
                Polygon poly;
                LocalPoint stashUnitLocalPoint = LocalPoint.fromWorld((Client)plugin.getClient(), (WorldPoint)worldPoint);
                if (stashUnitLocalPoint == null || (poly = Perspective.getCanvasTilePoly((Client)plugin.getClient(), (LocalPoint)stashUnitLocalPoint)) == null) continue;
                OverlayUtil.renderPolygon(graphics, poly, Color.RED);
            }
        }
    }

    public static EmoteClue forItemId(int itemId) {
        for (EmoteClue clue : CLUES) {
            if (clue.itemId != itemId) continue;
            return clue;
        }
        return null;
    }

    public static EmoteClue forText(String text) {
        for (EmoteClue clue : CLUES) {
            if (!clue.getText().equalsIgnoreCase(text)) continue;
            return clue;
        }
        return null;
    }

    public int getItemId() {
        return this.itemId;
    }

    public String getText() {
        return this.text;
    }

    public String getLocationName() {
        return this.locationName;
    }

    @Nullable
    public STASHUnit getStashUnit() {
        return this.stashUnit;
    }

    public Emote getFirstEmote() {
        return this.firstEmote;
    }

    public Emote getSecondEmote() {
        return this.secondEmote;
    }

    public ItemRequirement[] getItemRequirements() {
        return this.itemRequirements;
    }

    private WorldPoint getLocation() {
        return this.location;
    }
}

