/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.gpu;

import java.util.ArrayList;
import java.util.List;
import net.runelite.api.Projection;
import net.runelite.api.Scene;
import net.runelite.client.plugins.gpu.VAO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class VAOList {
    private static final Logger log = LoggerFactory.getLogger(VAOList.class);
    private static final int VAO_SIZE = 0x400000;
    private int curIdx;
    final List<VAO> vaos = new ArrayList<VAO>();

    VAOList() {
    }

    VAO get(int size) {
        VAO vao;
        assert (size <= 0x400000);
        while (this.curIdx < this.vaos.size()) {
            int rem;
            vao = this.vaos.get(this.curIdx);
            if (!vao.vbo.mapped) {
                vao.vbo.map();
            }
            if (size <= (rem = vao.vbo.vb.remaining() * 4)) {
                return vao;
            }
            ++this.curIdx;
        }
        vao = new VAO(0x400000);
        vao.init();
        vao.vbo.map();
        this.vaos.add(vao);
        log.debug("Allocated VAO {} request {}", (Object)vao.vao, (Object)size);
        return vao;
    }

    int unmap() {
        int sz = 0;
        for (int i = 0; i < this.vaos.size(); ++i) {
            VAO vao = this.vaos.get(i);
            if (!vao.vbo.mapped) continue;
            ++sz;
            vao.vbo.unmap();
        }
        this.curIdx = 0;
        return sz;
    }

    void free() {
        for (VAO vao : this.vaos) {
            vao.destroy();
        }
        this.vaos.clear();
        this.curIdx = 0;
    }

    void addRange(Projection projection, Scene scene) {
        for (int i = 0; i <= this.curIdx && i < this.vaos.size(); ++i) {
            VAO vao = this.vaos.get(i);
            if (!vao.vbo.mapped) continue;
            vao.addRange(projection, scene);
        }
    }

    void debug() {
        log.debug("{} vaos allocated", (Object)this.vaos.size());
        for (VAO vao : this.vaos) {
            log.debug("vao {} mapped: {} num ranges: {} length: {}", new Object[]{vao, vao.vbo.mapped, vao.off, vao.vbo.mapped ? vao.vbo.vb.position() : -1});
            if (vao.off <= 1) continue;
            for (int i = 0; i < vao.off; ++i) {
                log.debug("  {} {} {}", new Object[]{vao.lengths[i], vao.projs[i], vao.scenes[i]});
            }
        }
    }
}

