/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.gpu;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.List;
import net.runelite.client.plugins.gpu.ShaderException;
import net.runelite.client.plugins.gpu.template.Template;
import org.lwjgl.opengl.GL33C;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Shader {
    private static final Logger log = LoggerFactory.getLogger(Shader.class);
    @VisibleForTesting
    final List<Unit> units = new ArrayList<Unit>();

    Shader() {
    }

    public Shader add(int type, String name) {
        this.units.add(new Unit(type, name));
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int compile(Template template) throws ShaderException {
        int program = GL33C.glCreateProgram();
        int[] shaders = new int[this.units.size()];
        int i = 0;
        boolean ok = false;
        try {
            String err;
            while (i < shaders.length) {
                Unit unit = this.units.get(i);
                int shader = GL33C.glCreateShader((int)unit.type);
                if (shader == 0) {
                    throw new ShaderException("Unable to create shader of type " + unit.type);
                }
                String source = template.load(unit.filename);
                GL33C.glShaderSource((int)shader, (CharSequence)source);
                GL33C.glCompileShader((int)shader);
                if (GL33C.glGetShaderi((int)shader, (int)35713) != 1) {
                    String err2 = GL33C.glGetShaderInfoLog((int)shader);
                    GL33C.glDeleteShader((int)shader);
                    Shader.logShaderSource(source);
                    throw new ShaderException(err2);
                }
                GL33C.glAttachShader((int)program, (int)shader);
                shaders[i++] = shader;
            }
            GL33C.glLinkProgram((int)program);
            if (GL33C.glGetProgrami((int)program, (int)35714) == 0) {
                err = GL33C.glGetProgramInfoLog((int)program);
                throw new ShaderException(err);
            }
            GL33C.glValidateProgram((int)program);
            if (GL33C.glGetProgrami((int)program, (int)35715) == 0) {
                err = GL33C.glGetProgramInfoLog((int)program);
                throw new ShaderException(err);
            }
            ok = true;
        }
        finally {
            while (i > 0) {
                int shader = shaders[--i];
                GL33C.glDetachShader((int)program, (int)shader);
                GL33C.glDeleteShader((int)shader);
            }
            if (!ok) {
                GL33C.glDeleteProgram((int)program);
            }
        }
        return program;
    }

    private static void logShaderSource(String source) {
        int lineNum = 1;
        for (String line : source.split("\n")) {
            log.error("{}: {}", (Object)lineNum++, (Object)line);
        }
    }

    @VisibleForTesting
    static class Unit {
        private final int type;
        private final String filename;

        public Unit(int type, String filename) {
            this.type = type;
            this.filename = filename;
        }

        public int getType() {
            return this.type;
        }

        public String getFilename() {
            return this.filename;
        }
    }
}

