/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.callback;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.inject.Singleton;
import net.runelite.api.Renderable;
import net.runelite.api.Scene;
import net.runelite.api.Tile;
import net.runelite.api.TileObject;
import net.runelite.client.callback.RenderCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class RenderCallbackManager {
    private static final Logger log = LoggerFactory.getLogger(RenderCallbackManager.class);
    private final List<RenderCallback> callbacks = new CopyOnWriteArrayList<RenderCallback>();

    public void register(RenderCallback cb) {
        this.callbacks.add(cb);
    }

    public void unregister(RenderCallback cb) {
        this.callbacks.remove(cb);
    }

    public boolean addEntity(Renderable renderable, boolean ui) {
        if (this.callbacks.isEmpty()) {
            return true;
        }
        for (RenderCallback cb : this.callbacks) {
            try {
                if (cb.addEntity(renderable, ui)) continue;
                return false;
            }
            catch (Exception ex) {
                log.error("exception in render callback", (Throwable)ex);
            }
        }
        return true;
    }

    public boolean drawTile(Scene scene, Tile tile) {
        if (this.callbacks.isEmpty()) {
            return true;
        }
        for (RenderCallback cb : this.callbacks) {
            try {
                if (cb.drawTile(scene, tile)) continue;
                return false;
            }
            catch (Exception ex) {
                log.error("exception in render callback", (Throwable)ex);
            }
        }
        return true;
    }

    public boolean drawObject(Scene scene, TileObject object) {
        if (this.callbacks.isEmpty()) {
            return true;
        }
        for (RenderCallback cb : this.callbacks) {
            try {
                if (cb.drawObject(scene, object)) continue;
                return false;
            }
            catch (Exception ex) {
                log.error("exception in render callback", (Throwable)ex);
            }
        }
        return true;
    }
}

