/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.gpu;

import java.nio.IntBuffer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import net.runelite.api.Model;
import net.runelite.api.Perspective;
import net.runelite.api.Scene;
import net.runelite.client.plugins.gpu.FacePrioritySorter;
import net.runelite.client.plugins.gpu.GpuPlugin;
import net.runelite.client.plugins.gpu.VBO;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL33C;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Zone {
    private static final Logger log = LoggerFactory.getLogger(Zone.class);
    static final int VERT_SIZE = 20;
    int glVao;
    int bufLen;
    int glVaoA;
    int bufLenA;
    int sizeO;
    int sizeA;
    VBO vboO;
    VBO vboA;
    boolean initialized;
    boolean cull;
    boolean dirty;
    boolean invalidate;
    int[] levelOffsets = new int[4];
    int[][] rids;
    int[][] roofStart;
    int[][] roofEnd;
    final List<AlphaModel> alphaModels = new ArrayList<AlphaModel>(0);
    private static final int NUM_DRAW_RANGES = 512;
    private static final IntBuffer drawOff = BufferUtils.createIntBuffer((int)512);
    private static final IntBuffer drawEnd = BufferUtils.createIntBuffer((int)512);
    static final Queue<AlphaModel> modelCache = new ArrayDeque<AlphaModel>();
    private static final IntBuffer alphaElements = BufferUtils.createIntBuffer((int)19500);
    private static final int STATIC = 1;
    private static final int TEMP = 2;
    private static final int STATIC_UNSORTED = 3;
    private static int lastDrawMode;
    private static int lastVao;
    private static int lastzx;
    private static int lastzz;
    private static int elementBufferId;
    private static final int[] numOfPriority;
    private static final int[][] orderedFaces;

    void init(VBO o, VBO a) {
        assert (this.glVao == 0);
        assert (this.glVaoA == 0);
        if (o != null) {
            this.vboO = o;
            this.glVao = GL33C.glGenVertexArrays();
            this.setupVao(this.glVao, o.bufId);
        }
        if (a != null) {
            this.vboA = a;
            this.glVaoA = GL33C.glGenVertexArrays();
            this.setupVao(this.glVaoA, a.bufId);
        }
    }

    void free() {
        if (this.vboO != null) {
            this.vboO.destroy();
            this.vboO = null;
        }
        if (this.vboA != null) {
            this.vboA.destroy();
            this.vboA = null;
        }
        if (this.glVao != 0) {
            GL33C.glDeleteVertexArrays((int)this.glVao);
            this.glVao = 0;
        }
        if (this.glVaoA != 0) {
            GL33C.glDeleteVertexArrays((int)this.glVaoA);
            this.glVaoA = 0;
        }
        this.alphaModels.clear();
    }

    void unmap() {
        if (this.vboO != null) {
            this.vboO.unmap();
        }
        if (this.vboA != null) {
            this.vboA.unmap();
        }
        if (this.vboO != null) {
            this.bufLen = this.vboO.len / 5;
        }
        if (this.vboA != null) {
            this.bufLenA = this.vboA.len / 5;
        }
    }

    private void setupVao(int vao, int buffer) {
        GL33C.glBindVertexArray((int)vao);
        GL33C.glBindBuffer((int)34962, (int)buffer);
        GL33C.glEnableVertexAttribArray((int)0);
        GL33C.glVertexAttribPointer((int)0, (int)3, (int)5122, (boolean)false, (int)20, (long)0L);
        GL33C.glEnableVertexAttribArray((int)1);
        GL33C.glVertexAttribIPointer((int)1, (int)1, (int)5124, (int)20, (long)8L);
        GL33C.glEnableVertexAttribArray((int)2);
        GL33C.glVertexAttribIPointer((int)2, (int)4, (int)5122, (int)20, (long)12L);
        GL33C.glBindVertexArray((int)0);
        GL33C.glBindBuffer((int)34962, (int)0);
    }

    void updateRoofs(Map<Integer, Integer> updates) {
        for (int level = 0; level < 4; ++level) {
            for (int i = 0; i < this.rids[level].length; ++i) {
                this.rids[level][i] = updates.getOrDefault(this.rids[level][i], this.rids[level][i]);
            }
        }
        for (AlphaModel m : this.alphaModels) {
            m.rid = (short)updates.getOrDefault(m.rid, Integer.valueOf(m.rid)).intValue();
        }
    }

    private void convertForDraw(int vertSize) {
        assert (drawOff.position() == drawEnd.position());
        drawOff.flip();
        drawEnd.flip();
        for (int i = 0; i < drawOff.limit(); ++i) {
            int off = drawOff.get(i);
            int end = drawEnd.get(i);
            assert (end >= off);
            end /= vertSize >> 2;
            drawOff.put(i, off);
            drawEnd.put(i, end -= (off /= vertSize >> 2));
        }
    }

    void renderOpaque(int zx, int zz, int minLevel, int currentLevel, int maxLevel, Set<Integer> hiddenRoofIds) {
        drawOff.clear();
        drawEnd.clear();
        for (int level = minLevel; level <= maxLevel; ++level) {
            int[] rids = this.rids[level];
            int[] roofStart = this.roofStart[level];
            int[] roofEnd = this.roofEnd[level];
            if (rids.length == 0 || hiddenRoofIds.isEmpty() || level <= currentLevel) {
                int start = level == 0 ? 0 : this.levelOffsets[level - 1];
                int end = this.levelOffsets[level];
                Zone.pushRange(start, end);
                continue;
            }
            for (int roofIdx = 0; roofIdx < rids.length; ++roofIdx) {
                int rid = rids[roofIdx];
                if (rid <= 0 || hiddenRoofIds.contains(rid)) continue;
                assert (roofEnd[roofIdx] >= roofStart[roofIdx]);
                if (roofEnd[roofIdx] <= roofStart[roofIdx]) continue;
                Zone.pushRange(roofStart[roofIdx], roofEnd[roofIdx]);
            }
            int endpos = level == 0 ? 0 : this.levelOffsets[level - 1];
            for (int roofIdx = rids.length - 1; roofIdx >= 0; --roofIdx) {
                int rid = rids[roofIdx];
                if (rid <= 0) continue;
                endpos = roofEnd[roofIdx];
                break;
            }
            Zone.pushRange(endpos, this.levelOffsets[level]);
        }
        this.convertForDraw(20);
        if (drawOff.limit() > 0) {
            GL33C.glUniform3i((int)GpuPlugin.uniBase, (int)(zx << 10), (int)0, (int)(zz << 10));
            GL33C.glBindVertexArray((int)this.glVao);
            GL33C.glMultiDrawArrays((int)4, (IntBuffer)drawOff, (IntBuffer)drawEnd);
        }
    }

    private static void pushRange(int start, int end) {
        assert (end >= start);
        if (start == end) {
            return;
        }
        int idx = drawEnd.position();
        if (idx > 0 && drawEnd.get(idx - 1) == start) {
            drawEnd.put(idx - 1, end);
        } else if (!drawEnd.hasRemaining()) {
            log.debug("draw ranges exhausted");
        } else {
            drawOff.put(start);
            drawEnd.put(end);
        }
    }

    void addAlphaModel(int vao, Model model, int startpos, int endpos, int x, int y, int z, int lx, int lz, int ux, int uz, int rid, int level, int id) {
        int maxX;
        int maxY;
        int minX;
        int minY;
        AlphaModel m = new AlphaModel();
        m.id = id;
        m.startpos = startpos;
        m.endpos = endpos;
        m.x = (short)x;
        m.y = (short)y;
        m.z = (short)z;
        m.vao = vao;
        m.rid = (short)rid;
        m.level = (byte)level;
        if (lx > -1) {
            m.lx = (byte)lx;
            m.lz = (byte)lz;
            m.ux = (byte)ux;
            m.uz = (byte)uz;
        } else {
            m.uz = (byte)-1;
            m.ux = (byte)-1;
            m.lz = (byte)-1;
            m.lx = (byte)-1;
        }
        int faceCount = model.getFaceCount();
        int[] color3 = model.getFaceColors3();
        byte[] transparencies = model.getFaceTransparencies();
        float[] vertexX = model.getVerticesX();
        float[] vertexY = model.getVerticesY();
        float[] vertexZ = model.getVerticesZ();
        int[] indices1 = model.getFaceIndices1();
        int[] indices2 = model.getFaceIndices2();
        int[] indices3 = model.getFaceIndices3();
        int minZ = minY = (minX = Integer.MAX_VALUE);
        int maxZ = maxY = (maxX = Integer.MIN_VALUE);
        for (int f = 0; f < faceCount; ++f) {
            if (color3[f] == -2 || transparencies[f] == 0) continue;
            int fx = (int)(vertexX[indices1[f]] + vertexX[indices2[f]] + vertexX[indices3[f]]);
            int fy = (int)(vertexY[indices1[f]] + vertexY[indices2[f]] + vertexY[indices3[f]]);
            int fz = (int)(vertexZ[indices1[f]] + vertexZ[indices2[f]] + vertexZ[indices3[f]]);
            minX = Math.min(minX, fx);
            maxX = Math.max(maxX, fx);
            minY = Math.min(minY, fy);
            maxY = Math.max(maxY, fy);
            minZ = Math.min(minZ, fz);
            maxZ = Math.max(maxZ, fz);
        }
        int cx = (minX + maxX) / 6;
        int cy = (minY + maxY) / 6;
        int cz = (minZ + maxZ) / 6;
        int size = Math.max(Math.max(Math.max(maxX / 3 - cx, minX / -3 - cx), Math.max(maxY / 3 - cy, minY / -3 - cy) * 2), Math.max(maxZ / 3 - cz, minZ / -3 - cz));
        int shift = 0;
        for (int v = size >> 10; v > 0; v >>= 1) {
            ++shift;
        }
        m.packedFaces = new int[(endpos - startpos) / 15];
        int[] packedFaces = m.packedFaces;
        int radius = 0;
        int bufferIdx = 0;
        for (int f = 0; f < faceCount; ++f) {
            if (color3[f] == -2 || transparencies[f] == 0) continue;
            int fx = (int)(vertexX[indices1[f]] + vertexX[indices2[f]] + vertexX[indices3[f]]) / 3 - cx >> shift;
            int fy = (int)(vertexY[indices1[f]] + vertexY[indices2[f]] + vertexY[indices3[f]]) / 3 - cy >> shift;
            int fz = (int)(vertexZ[indices1[f]] + vertexZ[indices2[f]] + vertexZ[indices3[f]]) / 3 - cz >> shift;
            radius = Math.max(radius, fx * fx + fy * fy + fz * fz);
            packedFaces[bufferIdx] = (fx & 0x7FF) << 21 | (fy & 0x3FF) << 11 | fz & 0x7FF;
            bufferIdx = (char)(bufferIdx + 1);
        }
        assert (radius >= 0);
        m.renderPriorities = model.getFaceRenderPriorities();
        m.radius = 2 + (int)Math.sqrt(radius);
        assert (packedFaces.length > 0);
        assert (bufferIdx == packedFaces.length);
        this.alphaModels.add(m);
    }

    void addTempAlphaModel(int vao, int startpos, int endpos, int level, int x, int y, int z) {
        AlphaModel m = modelCache.poll();
        if (m == null) {
            m = new AlphaModel();
        }
        m.id = -1;
        m.startpos = startpos;
        m.endpos = endpos;
        m.x = (short)x;
        m.y = (short)y;
        m.z = (short)z;
        m.vao = vao;
        m.rid = (short)-1;
        m.level = (byte)level;
        m.uz = (byte)-1;
        m.ux = (byte)-1;
        m.lz = (byte)-1;
        m.lx = (byte)-1;
        m.flags = 0;
        m.zofz = 0;
        m.zofx = 0;
        this.alphaModels.add(m);
    }

    void removeTemp() {
        for (int i = this.alphaModels.size() - 1; i >= 0; --i) {
            AlphaModel m = this.alphaModels.get(i);
            if (m.isTemp() || (m.flags & 2) != 0) {
                this.alphaModels.remove(i);
                m.packedFaces = null;
                m.renderPriorities = null;
                modelCache.add(m);
            }
            m.flags = (byte)(m.flags & 0xFFFFFFFE);
        }
    }

    static void initBuffer() {
        elementBufferId = GL33C.glGenBuffers();
    }

    static void freeBuffer() {
        GL33C.glDeleteBuffers((int)elementBufferId);
        elementBufferId = 0;
    }

    void alphaSort(int zx, int zz, int cx, int cy, int cz) {
        this.alphaModels.sort(Comparator.comparingInt(m -> {
            int mx = m.x + (zx - m.zofx << 10);
            int mz = m.z + (zz - m.zofz << 10);
            return (mx - cx) * (mx - cx) + (m.y - cy) * (m.y - cy) + (mz - cz) * (mz - cz);
        }).reversed());
    }

    void renderAlpha(int zx, int zz, int cyaw, int cpitch, int minLevel, int currentLevel, int maxLevel, int level, Set<Integer> hiddenRoofIds, boolean useStaticUnsorted) {
        drawOff.clear();
        drawEnd.clear();
        alphaElements.clear();
        lastVao = 0;
        lastDrawMode = 0;
        lastzx = zx;
        lastzz = zz;
        int yawsin = Perspective.SINE[cyaw];
        int yawcos = Perspective.COSINE[cyaw];
        int pitchsin = Perspective.SINE[cpitch];
        int pitchcos = Perspective.COSINE[cpitch];
        for (int j = 0; j < this.alphaModels.size(); ++j) {
            int face;
            int faceIdx;
            int cnt;
            int i;
            AlphaModel m = this.alphaModels.get(j);
            if ((m.flags & 1) != 0 || m.level != level) continue;
            boolean ok = false;
            if (!(level < minLevel || level > maxLevel || level > currentLevel && hiddenRoofIds.contains(m.rid))) {
                ok = true;
            }
            if (!ok) continue;
            if (lastVao != m.vao || lastzx != zx - m.zofx || lastzz != zz - m.zofz) {
                this.flush();
            }
            lastVao = m.vao;
            lastzx = zx - m.zofx;
            lastzz = zz - m.zofz;
            if (m.isTemp()) {
                lastDrawMode = 2;
                Zone.pushRange(m.startpos, m.endpos);
                continue;
            }
            if (useStaticUnsorted) {
                lastDrawMode = 3;
                Zone.pushRange(m.startpos, m.endpos);
                continue;
            }
            lastDrawMode = 1;
            int radius = m.radius;
            int diameter = 1 + radius * 2;
            int[] packedFaces = m.packedFaces;
            if (diameter >= 6000) continue;
            Arrays.fill(FacePrioritySorter.distanceFaceCount, 0, diameter, '\u0000');
            for (int i2 = 0; i2 < packedFaces.length; ++i2) {
                int pack = packedFaces[i2];
                int x = pack >> 21;
                int y = pack << 11 >> 22;
                int z = pack << 21 >> 21;
                int t = z * yawcos - x * yawsin >> 16;
                int fz = y * pitchsin + t * pitchcos >> 16;
                assert ((fz += radius) >= 0 && fz < diameter) : fz;
                int n = fz;
                char c = FacePrioritySorter.distanceFaceCount[n];
                FacePrioritySorter.distanceFaceCount[n] = (char)(c + '\u0001');
                FacePrioritySorter.distanceToFaces[fz][c] = (char)i2;
            }
            if (packedFaces.length * 3 > alphaElements.remaining()) {
                if (packedFaces.length * 3 > alphaElements.capacity()) {
                    log.debug("Alpha model too large: {}", (Object)packedFaces.length);
                    continue;
                }
                this.flush();
            }
            byte[] faceRenderPriorities = m.renderPriorities;
            int start = m.startpos / 5;
            if (faceRenderPriorities == null) {
                for (i = diameter - 1; i >= 0; --i) {
                    cnt = FacePrioritySorter.distanceFaceCount[i];
                    if (cnt <= 0) continue;
                    char[] faces = FacePrioritySorter.distanceToFaces[i];
                    for (faceIdx = 0; faceIdx < cnt; ++faceIdx) {
                        face = faces[faceIdx];
                        face *= 3;
                        face += start;
                        alphaElements.put(face++);
                        alphaElements.put(face++);
                        alphaElements.put(face++);
                    }
                }
                continue;
            }
            Arrays.fill(numOfPriority, 0);
            for (i = diameter - 1; i >= 0; --i) {
                cnt = FacePrioritySorter.distanceFaceCount[i];
                if (cnt <= 0) continue;
                char[] faces = FacePrioritySorter.distanceToFaces[i];
                for (faceIdx = 0; faceIdx < cnt; ++faceIdx) {
                    byte pri;
                    face = faces[faceIdx];
                    byte by = pri = faceRenderPriorities[face];
                    numOfPriority[by] = numOfPriority[by] + 1;
                    Zone.orderedFaces[pri][distIdx] = face;
                }
            }
            for (int pri = 0; pri < 12; ++pri) {
                int priNum = numOfPriority[pri];
                int[] priFaces = orderedFaces[pri];
                for (faceIdx = 0; faceIdx < priNum; ++faceIdx) {
                    face = priFaces[faceIdx];
                    int idx = face * 3 + start;
                    alphaElements.put(idx++);
                    alphaElements.put(idx++);
                    alphaElements.put(idx++);
                }
            }
        }
        this.flush();
    }

    private void flush() {
        if (lastDrawMode == 2) {
            this.convertForDraw(24);
            assert (drawOff.limit() > 0);
            GL33C.glUniform3i((int)GpuPlugin.uniBase, (int)0, (int)0, (int)0);
            GL33C.glBindVertexArray((int)lastVao);
            GL33C.glDepthMask((boolean)false);
            GL33C.glMultiDrawArrays((int)4, (IntBuffer)drawOff, (IntBuffer)drawEnd);
            GL33C.glDepthMask((boolean)true);
            drawOff.clear();
            drawEnd.clear();
        } else if (lastDrawMode == 1) {
            alphaElements.flip();
            GL33C.glUniform3i((int)GpuPlugin.uniBase, (int)(lastzx << 10), (int)0, (int)(lastzz << 10));
            GL33C.glBindVertexArray((int)lastVao);
            GL33C.glBindBuffer((int)34963, (int)elementBufferId);
            GL33C.glBufferData((int)34963, (IntBuffer)alphaElements, (int)35040);
            GL33C.glDepthMask((boolean)false);
            GL33C.glDrawElements((int)4, (int)alphaElements.limit(), (int)5125, (long)0L);
            GL33C.glDepthMask((boolean)true);
            GL33C.glBindBuffer((int)34963, (int)0);
            alphaElements.clear();
        } else if (lastDrawMode == 3) {
            this.convertForDraw(20);
            assert (drawOff.limit() > 0);
            GL33C.glUniform3i((int)GpuPlugin.uniBase, (int)(lastzx << 10), (int)0, (int)(lastzz << 10));
            GL33C.glBindVertexArray((int)lastVao);
            GL33C.glDepthMask((boolean)false);
            GL33C.glMultiDrawArrays((int)4, (IntBuffer)drawOff, (IntBuffer)drawEnd);
            GL33C.glDepthMask((boolean)true);
            drawOff.clear();
            drawEnd.clear();
        }
    }

    void multizoneLocs(Scene scene, int zx, int zz, int cx, int cz, Zone[][] zones) {
        int offset = scene.getWorldViewId() == -1 ? 5 : 0;
        for (int i = 0; i < this.alphaModels.size(); ++i) {
            AlphaModel m = this.alphaModels.get(i);
            if (m.lx == -1) continue;
            int max = Integer.MAX_VALUE;
            int closestZoneX = -50;
            int closestZoneZ = -50;
            for (int x = m.lx >> 3; x <= m.ux >> 3; ++x) {
                for (int z = m.lz >> 3; z <= m.uz >> 3; ++z) {
                    int centerX = (zx - m.zofx + x) * 8 + 4 << 7;
                    int centerZ = (zz - m.zofz + z) * 8 + 4 << 7;
                    int distance = (centerX - cx) * (centerX - cx) + (centerZ - cz) * (centerZ - cz);
                    if (distance >= max) continue;
                    max = distance;
                    closestZoneX = centerX >> 10;
                    closestZoneZ = centerZ >> 10;
                }
            }
            assert (closestZoneX != -50);
            if (closestZoneX == zx && closestZoneZ == zz) continue;
            assert ((m.flags & 2) == 0);
            assert (closestZoneX + offset >= 0) : closestZoneX;
            assert (closestZoneX + offset < zones.length) : closestZoneX;
            assert (closestZoneZ + offset >= 0) : closestZoneZ;
            assert (closestZoneZ + offset < zones[0].length) : closestZoneZ;
            Zone z = zones[closestZoneX + offset][closestZoneZ + offset];
            assert (z != null);
            assert (z != this);
            AlphaModel m2 = modelCache.poll();
            if (m2 == null) {
                m2 = new AlphaModel();
            }
            m2.id = m.id;
            m2.startpos = m.startpos;
            m2.endpos = m.endpos;
            m2.x = m.x;
            m2.y = m.y;
            m2.z = m.z;
            m2.vao = m.vao;
            m2.rid = m.rid;
            m2.level = m.level;
            m2.lx = m.lx;
            m2.lz = m.lz;
            m2.ux = m.ux;
            m2.uz = m.uz;
            m2.zofx = (byte)(closestZoneX - zx);
            m2.zofz = (byte)(closestZoneZ - zz);
            m2.packedFaces = m.packedFaces;
            m2.renderPriorities = m.renderPriorities;
            m2.radius = m.radius;
            m2.flags = (byte)2;
            m.flags = (byte)(m.flags | 1);
            z.alphaModels.add(m2);
        }
    }

    static {
        numOfPriority = FacePrioritySorter.numOfPriority;
        orderedFaces = FacePrioritySorter.orderedFaces;
    }

    static class AlphaModel {
        int id;
        int startpos;
        int endpos;
        short x;
        short y;
        short z;
        short rid;
        int vao;
        byte level;
        byte lx;
        byte lz;
        byte ux;
        byte uz;
        byte zofx;
        byte zofz;
        byte flags;
        int radius;
        int[] packedFaces;
        byte[] renderPriorities;
        static final int SKIP = 1;
        static final int TEMP = 2;

        AlphaModel() {
        }

        boolean isTemp() {
            return this.packedFaces == null;
        }
    }
}

