/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.cache.script.assembler;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.runelite.cache.definitions.ScriptDefinition;
import net.runelite.cache.script.Instruction;
import net.runelite.cache.script.Instructions;
import net.runelite.cache.script.assembler.LabelVisitor;
import net.runelite.cache.script.assembler.LookupCase;
import net.runelite.cache.script.assembler.LookupSwitch;
import net.runelite.cache.script.assembler.rs2asmBaseListener;
import net.runelite.cache.script.assembler.rs2asmParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ScriptWriter
extends rs2asmBaseListener {
    private static final Logger logger = LoggerFactory.getLogger(ScriptWriter.class);
    private final Instructions instructions;
    private final LabelVisitor labelVisitor;
    private final Map<String, Object> symbols;
    private int id;
    private int pos;
    private int intArgCount;
    private int objArgCount;
    private int localIntCount;
    private int localObjCount;
    private List<Integer> opcodes = new ArrayList<Integer>();
    private List<Integer> iops = new ArrayList<Integer>();
    private List<String> sops = new ArrayList<String>();
    private List<LookupSwitch> switches = new ArrayList<LookupSwitch>();

    @Override
    public void enterId_value(rs2asmParser.Id_valueContext ctx) {
        int value;
        this.id = value = Integer.parseInt(ctx.getText());
    }

    @Override
    public void enterInt_arg_value(rs2asmParser.Int_arg_valueContext ctx) {
        int value;
        this.intArgCount = value = Integer.parseInt(ctx.getText());
    }

    @Override
    public void enterObj_arg_value(rs2asmParser.Obj_arg_valueContext ctx) {
        int value;
        this.objArgCount = value = Integer.parseInt(ctx.getText());
    }

    @Override
    public void exitInstruction(rs2asmParser.InstructionContext ctx) {
        ++this.pos;
    }

    @Override
    public void enterName_string(rs2asmParser.Name_stringContext ctx) {
        String text = ctx.getText();
        Instruction i = this.instructions.find(text);
        if (i == null) {
            logger.warn("Unknown instruction {}", (Object)text);
            throw new RuntimeException("Unknown instruction " + text);
        }
        int opcode = i.getOpcode();
        this.addOpcode(opcode);
    }

    @Override
    public void enterName_opcode(rs2asmParser.Name_opcodeContext ctx) {
        String text = ctx.getText();
        int opcode = Integer.parseInt(text);
        this.addOpcode(opcode);
    }

    private void addOpcode(int opcode) {
        assert (this.opcodes.size() == this.pos);
        assert (this.iops.size() == this.pos);
        assert (this.sops.size() == this.pos);
        assert (this.switches.size() == this.pos);
        this.opcodes.add(opcode);
        this.iops.add(null);
        this.sops.add(null);
        if (opcode == 60) {
            this.switches.add(new LookupSwitch());
        } else {
            this.switches.add(null);
        }
    }

    @Override
    public void enterOperand_int(rs2asmParser.Operand_intContext ctx) {
        String text = ctx.getText();
        int value = Integer.parseInt(text);
        this.iops.set(this.pos, value);
    }

    @Override
    public void enterOperand_qstring(rs2asmParser.Operand_qstringContext ctx) {
        String text = ctx.getText();
        text = text.substring(1, text.length() - 1).replace("\\\\", "\\").replace("\\\"", "\"");
        this.sops.set(this.pos, text);
    }

    @Override
    public void enterOperand_label(rs2asmParser.Operand_labelContext ctx) {
        String text = ctx.getText();
        Integer instruction = this.labelVisitor.getInstructionForLabel(text);
        if (instruction == null) {
            throw new RuntimeException("reference to unknown label " + text);
        }
        int target = instruction - this.pos - 1;
        this.iops.set(this.pos, target);
    }

    @Override
    public void enterOperand_symbol(rs2asmParser.Operand_symbolContext ctx) {
        String symbolName = ctx.getText().substring(1);
        Object symbol = this.symbols.get(symbolName);
        if (symbol == null) {
            throw new RuntimeException("unknown symbol " + symbolName);
        }
        if (!(symbol instanceof Integer)) {
            throw new RuntimeException("non-integer symbols not supported");
        }
        this.iops.set(this.pos, (int)((Integer)symbol));
    }

    @Override
    public void exitSwitch_key(rs2asmParser.Switch_keyContext ctx) {
        String text = ctx.getText();
        int key = Integer.parseInt(text);
        LookupSwitch ls = this.switches.get(this.pos - 1);
        assert (ls != null);
        LookupCase scase = new LookupCase();
        scase.setValue(key);
        ls.getCases().add(scase);
    }

    @Override
    public void exitSwitch_value(rs2asmParser.Switch_valueContext ctx) {
        String text = ctx.getText();
        Integer instruction = this.labelVisitor.getInstructionForLabel(text);
        if (instruction == null) {
            throw new RuntimeException("reference to unknown label " + text);
        }
        int target = instruction - (this.pos - 1) - 1;
        LookupSwitch ls = this.switches.get(this.pos - 1);
        assert (ls != null);
        LookupCase scase = ls.getCases().get(ls.getCases().size() - 1);
        scase.setOffset(target);
    }

    public ScriptDefinition buildScript() {
        this.setSwitchOperands();
        this.computeLocalSizes();
        ScriptDefinition script = new ScriptDefinition();
        script.setId(this.id);
        script.setIntArgCount(this.intArgCount);
        script.setObjArgCount(this.objArgCount);
        script.setLocalIntCount(this.localIntCount);
        script.setLocalObjCount(this.localObjCount);
        script.setInstructions(this.opcodes.stream().mapToInt(Integer::valueOf).toArray());
        script.setIntOperands(this.iops.stream().map(i -> i == null ? 0 : i).mapToInt(Integer::valueOf).toArray());
        script.setStringOperands(this.sops.toArray(new String[0]));
        script.setSwitches(this.buildSwitches());
        return script;
    }

    private void computeLocalSizes() {
        int maxIntVars = this.intArgCount;
        int maxObjVars = this.objArgCount;
        for (int i = 0; i < this.opcodes.size(); ++i) {
            int op;
            int opcode = this.opcodes.get(i);
            if (opcode == 33 || opcode == 34) {
                op = this.iops.get(i);
                maxIntVars = Math.max(maxIntVars, op + 1);
                continue;
            }
            if (opcode != 35 && opcode != 36) continue;
            op = this.iops.get(i);
            maxObjVars = Math.max(maxObjVars, op + 1);
        }
        this.localIntCount = maxIntVars;
        this.localObjCount = maxObjVars;
    }

    private void setSwitchOperands() {
        int count = 0;
        for (int i = 0; i < this.opcodes.size(); ++i) {
            if (this.opcodes.get(i) != 60) continue;
            this.iops.set(i, count++);
        }
    }

    private Map<Integer, Integer>[] buildSwitches() {
        int count = (int)this.switches.stream().filter(Objects::nonNull).count();
        if (count == 0) {
            return null;
        }
        int index = 0;
        Map[] maps = new Map[count];
        for (LookupSwitch lswitch : this.switches) {
            if (lswitch == null) continue;
            int n = index++;
            LinkedHashMap<Integer, Integer> linkedHashMap = new LinkedHashMap<Integer, Integer>();
            maps[n] = linkedHashMap;
            LinkedHashMap<Integer, Integer> map = linkedHashMap;
            for (LookupCase scase : lswitch.getCases()) {
                map.put(scase.getValue(), scase.getOffset());
            }
        }
        return maps;
    }

    public ScriptWriter(Instructions instructions, LabelVisitor labelVisitor, Map<String, Object> symbols) {
        this.instructions = instructions;
        this.labelVisitor = labelVisitor;
        this.symbols = symbols;
    }
}

