/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.cache.fs.jagex;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.runelite.cache.fs.Archive;
import net.runelite.cache.fs.Container;
import net.runelite.cache.fs.Index;
import net.runelite.cache.fs.Storage;
import net.runelite.cache.fs.Store;
import net.runelite.cache.fs.jagex.DataFile;
import net.runelite.cache.fs.jagex.DataFileWriteResult;
import net.runelite.cache.fs.jagex.IndexEntry;
import net.runelite.cache.fs.jagex.IndexFile;
import net.runelite.cache.index.ArchiveData;
import net.runelite.cache.index.IndexData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiskStorage
implements Storage {
    private static final Logger logger = LoggerFactory.getLogger(DiskStorage.class);
    private static final String MAIN_FILE_CACHE_DAT = "main_file_cache.dat2";
    private static final String MAIN_FILE_CACHE_IDX = "main_file_cache.idx";
    private final File folder;
    private final DataFile data;
    private final IndexFile index255;
    private final List<IndexFile> indexFiles = new ArrayList<IndexFile>();

    public DiskStorage(File folder) throws IOException {
        this.folder = folder;
        this.data = new DataFile(new File(folder, MAIN_FILE_CACHE_DAT));
        this.index255 = new IndexFile(255, new File(folder, "main_file_cache.idx255"));
    }

    @Override
    public void init(Store store) throws IOException {
        for (int i = 0; i < this.index255.getIndexCount(); ++i) {
            store.addIndex(i);
            this.getIndex(i);
        }
        assert (store.getIndexes().size() == this.indexFiles.size());
    }

    @Override
    public void close() throws IOException {
        this.data.close();
        this.index255.close();
        for (IndexFile indexFile : this.indexFiles) {
            indexFile.close();
        }
    }

    private IndexFile getIndex(int i) throws FileNotFoundException {
        if (i == 255) {
            return this.index255;
        }
        for (IndexFile indexFile : this.indexFiles) {
            if (indexFile.getIndexFileId() != i) continue;
            return indexFile;
        }
        IndexFile indexFile = new IndexFile(i, new File(this.folder, MAIN_FILE_CACHE_IDX + i));
        this.indexFiles.add(indexFile);
        return indexFile;
    }

    @Override
    public void load(Store store) throws IOException {
        for (Index index : store.getIndexes()) {
            this.loadIndex(index);
        }
    }

    public byte[] readIndex(int indexId) throws IOException {
        IndexEntry entry = this.index255.read(indexId);
        if (entry == null) {
            return null;
        }
        byte[] indexData = this.data.read(this.index255.getIndexFileId(), entry.getId(), entry.getSector(), entry.getLength());
        return indexData;
    }

    private void loadIndex(Index index) throws IOException {
        logger.trace("Loading index {}", (Object)index.getId());
        byte[] indexData = this.readIndex(index.getId());
        if (indexData == null) {
            return;
        }
        Container res = Container.decompress(indexData, null);
        byte[] data = res.data;
        IndexData id = new IndexData();
        id.load(data);
        index.setProtocol(id.getProtocol());
        index.setRevision(id.getRevision());
        index.setNamed(id.isNamed());
        index.setSized(id.isSized());
        for (ArchiveData ad : id.getArchives()) {
            Archive archive = index.addArchive(ad.getId());
            archive.setNameHash(ad.getNameHash());
            archive.setCrc(ad.getCrc());
            archive.setCompressedSize(ad.getCompressedSize());
            archive.setDecompressedSize(ad.getDecompressedSize());
            archive.setRevision(ad.getRevision());
            archive.setFileData(ad.getFiles());
            assert (ad.getFiles().length > 0);
        }
        index.setCrc(res.crc);
        index.setCompression(res.compression);
        assert (res.revision == -1);
    }

    @Override
    public void save(Store store) throws IOException {
        logger.debug("Saving store");
        for (Index i : store.getIndexes()) {
            this.saveIndex(i);
        }
    }

    private void saveIndex(Index index) throws IOException {
        IndexData indexData = index.toIndexData();
        byte[] data = indexData.writeIndexData();
        Container container = new Container(index.getCompression(), -1);
        container.compress(data, null);
        byte[] compressedData = container.data;
        this.store(255, index.getId(), compressedData);
        index.setCrc(container.crc);
    }

    @Override
    public byte[] load(int index, int archive) throws IOException {
        IndexFile indexFile = this.getIndex(index);
        assert (indexFile.getIndexFileId() == index);
        IndexEntry entry = indexFile.read(archive);
        if (entry == null) {
            logger.debug("can't read archive {} from index {}", (Object)archive, (Object)index);
            return null;
        }
        assert (entry.getId() == archive);
        logger.trace("Loading archive {} for index {} from sector {} length {}", new Object[]{archive, index, entry.getSector(), entry.getLength()});
        byte[] archiveData = this.data.read(index, entry.getId(), entry.getSector(), entry.getLength());
        return archiveData;
    }

    @Override
    public void store(int index, int archive, byte[] archiveData) throws IOException {
        IndexFile indexFile = this.getIndex(index);
        assert (indexFile.getIndexFileId() == index);
        DataFileWriteResult res = this.data.write(index, archive, archiveData);
        indexFile.write(new IndexEntry(indexFile, archive, res.sector, res.compressedLength));
        logger.trace("Saved archive {}/{} at sector {}, compressed length {}", new Object[]{index, archive, res.sector, res.compressedLength});
    }
}

