/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.cache.definitions.loaders;

import net.runelite.cache.definitions.OverlayDefinition;
import net.runelite.cache.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OverlayLoader {
    private static final Logger logger = LoggerFactory.getLogger(OverlayLoader.class);

    public OverlayDefinition load(int id, byte[] b) {
        int opcode;
        OverlayDefinition def = new OverlayDefinition();
        InputStream is = new InputStream(b);
        def.setId(id);
        while ((opcode = is.readUnsignedByte()) != 0) {
            if (opcode == 1) {
                int color = is.read24BitInt();
                def.setRgbColor(color);
                continue;
            }
            if (opcode == 2) {
                int texture = is.readUnsignedByte();
                def.setTexture(texture);
                continue;
            }
            if (opcode == 5) {
                def.setHideUnderlay(false);
                continue;
            }
            if (opcode != 7) continue;
            int secondaryColor = is.read24BitInt();
            def.setSecondaryRgbColor(secondaryColor);
        }
        def.calculateHsl();
        return def;
    }
}

