/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.cache.definitions.loaders;

import net.runelite.cache.definitions.EnumDefinition;
import net.runelite.cache.io.InputStream;
import net.runelite.cache.util.ScriptVarType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnumLoader {
    private static final Logger logger = LoggerFactory.getLogger(EnumLoader.class);

    public EnumDefinition load(int id, byte[] b) {
        int opcode;
        if (b.length == 1 && b[0] == 0) {
            return null;
        }
        EnumDefinition def = new EnumDefinition();
        InputStream is = new InputStream(b);
        def.setId(id);
        while ((opcode = is.readUnsignedByte()) != 0) {
            this.processOp(opcode, def, is);
        }
        return def;
    }

    private void processOp(int opcode, EnumDefinition def, InputStream is) {
        switch (opcode) {
            case 1: {
                def.setKeyType(ScriptVarType.forCharKey((char)is.readUnsignedByte()));
                break;
            }
            case 2: {
                def.setValType(ScriptVarType.forCharKey((char)is.readUnsignedByte()));
                break;
            }
            case 3: {
                def.setDefaultString(is.readString());
                break;
            }
            case 4: {
                def.setDefaultInt(is.readInt());
                break;
            }
            case 5: {
                int size = is.readUnsignedShort();
                int[] keys = new int[size];
                String[] stringVals = new String[size];
                for (int index = 0; index < size; ++index) {
                    keys[index] = is.readInt();
                    stringVals[index] = is.readString();
                }
                def.setSize(size);
                def.setKeys(keys);
                def.setStringVals(stringVals);
                break;
            }
            case 6: {
                int size = is.readUnsignedShort();
                int[] keys = new int[size];
                int[] intVals = new int[size];
                for (int index = 0; index < size; ++index) {
                    keys[index] = is.readInt();
                    intVals[index] = is.readInt();
                }
                def.setSize(size);
                def.setKeys(keys);
                def.setIntVals(intVals);
                break;
            }
            default: {
                logger.warn("Unrecognized opcode {}", (Object)opcode);
            }
        }
    }
}

