/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.cache.definitions.loaders;

import net.runelite.cache.definitions.DBTableDefinition;
import net.runelite.cache.io.InputStream;
import net.runelite.cache.util.ScriptVarType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBTableLoader {
    private static final Logger log = LoggerFactory.getLogger(DBTableLoader.class);

    public DBTableDefinition load(int id, byte[] b) {
        int opcode;
        DBTableDefinition def = new DBTableDefinition(id);
        InputStream is = new InputStream(b);
        while ((opcode = is.readUnsignedByte()) != 0) {
            this.decode(opcode, def, is);
        }
        return def;
    }

    private void decode(int opcode, DBTableDefinition def, InputStream stream) {
        if (opcode == 1) {
            int numColumns = stream.readUnsignedByte();
            ScriptVarType[][] types = new ScriptVarType[numColumns][];
            Object[][] defaultValues = null;
            int setting = stream.readUnsignedByte();
            while (setting != 255) {
                int columnId = setting & 0x7F;
                boolean hasDefault = (setting & 0x80) != 0;
                ScriptVarType[] columnTypes = new ScriptVarType[stream.readUnsignedByte()];
                for (int i = 0; i < columnTypes.length; ++i) {
                    columnTypes[i] = ScriptVarType.forId(stream.readUnsignedShortSmart());
                }
                types[columnId] = columnTypes;
                if (hasDefault) {
                    if (defaultValues == null) {
                        defaultValues = new Object[types.length][];
                    }
                    defaultValues[columnId] = DBTableLoader.decodeColumnFields(stream, columnTypes);
                }
                setting = stream.readUnsignedByte();
            }
            def.setTypes(types);
            def.setDefaultColumnValues((Object[])defaultValues);
        } else {
            log.warn("Unrecognized dbtable opcode {}", (Object)opcode);
        }
    }

    public static Object[] decodeColumnFields(InputStream stream, ScriptVarType[] types) {
        int fieldCount = stream.readUnsignedShortSmart();
        Object[] values = new Object[fieldCount * types.length];
        for (int fieldIndex = 0; fieldIndex < fieldCount; ++fieldIndex) {
            for (int typeIndex = 0; typeIndex < types.length; ++typeIndex) {
                ScriptVarType type = types[typeIndex];
                int valuesIndex = fieldIndex * types.length + typeIndex;
                values[valuesIndex] = type == ScriptVarType.STRING ? stream.readString() : Integer.valueOf(stream.readInt());
            }
        }
        return values;
    }
}

