/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.cache.definitions;

public class UnderlayDefinition {
    private int id;
    private int color;
    private transient int hue;
    private transient int saturation;
    private transient int lightness;
    private transient int hueMultiplier;

    public void calculateHsl() {
        int var1 = this.color;
        double var2 = (double)(var1 >> 16 & 0xFF) / 256.0;
        double var4 = (double)(var1 >> 8 & 0xFF) / 256.0;
        double var6 = (double)(var1 & 0xFF) / 256.0;
        double var8 = var2;
        if (var4 < var2) {
            var8 = var4;
        }
        if (var6 < var8) {
            var8 = var6;
        }
        double var10 = var2;
        if (var4 > var2) {
            var10 = var4;
        }
        if (var6 > var10) {
            var10 = var6;
        }
        double var12 = 0.0;
        double var14 = 0.0;
        double var16 = (var10 + var8) / 2.0;
        if (var8 != var10) {
            if (var16 < 0.5) {
                var14 = (var10 - var8) / (var8 + var10);
            }
            if (var16 >= 0.5) {
                var14 = (var10 - var8) / (2.0 - var10 - var8);
            }
            if (var2 == var10) {
                var12 = (var4 - var6) / (var10 - var8);
            } else if (var10 == var4) {
                var12 = 2.0 + (var6 - var2) / (var10 - var8);
            } else if (var10 == var6) {
                var12 = 4.0 + (var2 - var4) / (var10 - var8);
            }
        }
        var12 /= 6.0;
        this.saturation = (int)(var14 * 256.0);
        this.lightness = (int)(var16 * 256.0);
        if (this.saturation < 0) {
            this.saturation = 0;
        } else if (this.saturation > 255) {
            this.saturation = 255;
        }
        if (this.lightness < 0) {
            this.lightness = 0;
        } else if (this.lightness > 255) {
            this.lightness = 255;
        }
        this.hueMultiplier = var16 > 0.5 ? (int)(var14 * (1.0 - var16) * 512.0) : (int)(var14 * var16 * 512.0);
        if (this.hueMultiplier < 1) {
            this.hueMultiplier = 1;
        }
        this.hue = (int)((double)this.hueMultiplier * var12);
    }

    public int getId() {
        return this.id;
    }

    public int getColor() {
        return this.color;
    }

    public int getHue() {
        return this.hue;
    }

    public int getSaturation() {
        return this.saturation;
    }

    public int getLightness() {
        return this.lightness;
    }

    public int getHueMultiplier() {
        return this.hueMultiplier;
    }

    public void setId(int id) {
        this.id = id;
    }

    public void setColor(int color) {
        this.color = color;
    }

    public void setHue(int hue) {
        this.hue = hue;
    }

    public void setSaturation(int saturation) {
        this.saturation = saturation;
    }

    public void setLightness(int lightness) {
        this.lightness = lightness;
    }

    public void setHueMultiplier(int hueMultiplier) {
        this.hueMultiplier = hueMultiplier;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UnderlayDefinition)) {
            return false;
        }
        UnderlayDefinition other = (UnderlayDefinition)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getId() != other.getId()) {
            return false;
        }
        return this.getColor() == other.getColor();
    }

    protected boolean canEqual(Object other) {
        return other instanceof UnderlayDefinition;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getId();
        result = result * 59 + this.getColor();
        return result;
    }

    public String toString() {
        return "UnderlayDefinition(id=" + this.getId() + ", color=" + this.getColor() + ", hue=" + this.getHue() + ", saturation=" + this.getSaturation() + ", lightness=" + this.getLightness() + ", hueMultiplier=" + this.getHueMultiplier() + ")";
    }
}

