/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.cache.models;

import java.io.PrintWriter;
import net.runelite.cache.TextureManager;
import net.runelite.cache.definitions.ModelDefinition;
import net.runelite.cache.definitions.TextureDefinition;
import net.runelite.cache.models.JagexColor;
import net.runelite.cache.models.VertexNormal;

public class ObjExporter {
    private static final double BRIGHTNESS = 0.9;
    private final TextureManager textureManager;
    private final ModelDefinition model;

    public ObjExporter(TextureManager textureManager, ModelDefinition model) {
        this.textureManager = textureManager;
        this.model = model;
    }

    public void export(PrintWriter objWriter, PrintWriter mtlWriter) {
        int i;
        this.model.computeNormals();
        this.model.computeTextureUVCoordinates();
        objWriter.println("mtllib " + this.model.id + ".mtl");
        objWriter.println("o runescapemodel");
        for (int i2 = 0; i2 < this.model.vertexCount; ++i2) {
            objWriter.println("v " + this.model.vertexX[i2] + " " + this.model.vertexY[i2] * -1 + " " + this.model.vertexZ[i2] * -1);
        }
        if (this.model.faceTextures != null) {
            float[][] u = this.model.faceTextureUCoordinates;
            float[][] v = this.model.faceTextureVCoordinates;
            for (int i3 = 0; i3 < this.model.faceCount; ++i3) {
                objWriter.println("vt " + u[i3][0] + " " + v[i3][0]);
                objWriter.println("vt " + u[i3][1] + " " + v[i3][1]);
                objWriter.println("vt " + u[i3][2] + " " + v[i3][2]);
            }
        }
        for (VertexNormal normal : this.model.vertexNormals) {
            objWriter.println("vn " + normal.x + " " + normal.y + " " + normal.z);
        }
        for (i = 0; i < this.model.faceCount; ++i) {
            int x = this.model.faceIndices1[i] + 1;
            int y = this.model.faceIndices2[i] + 1;
            int z = this.model.faceIndices3[i] + 1;
            objWriter.println("usemtl m" + i);
            if (this.model.faceTextures != null) {
                objWriter.println("f " + x + "/" + (i * 3 + 1) + " " + y + "/" + (i * 3 + 2) + " " + z + "/" + (i * 3 + 3));
            } else {
                objWriter.println("f " + x + " " + y + " " + z);
            }
            objWriter.println("");
        }
        for (i = 0; i < this.model.faceCount; ++i) {
            int textureId = -1;
            if (this.model.faceTextures != null) {
                textureId = this.model.faceTextures[i];
            }
            mtlWriter.println("newmtl m" + i);
            if (textureId == -1) {
                int rgb = JagexColor.HSLtoRGB(this.model.faceColors[i], 0.9);
                double r = (double)(rgb >> 16 & 0xFF) / 255.0;
                double g = (double)(rgb >> 8 & 0xFF) / 255.0;
                double b = (double)(rgb & 0xFF) / 255.0;
                mtlWriter.println("Kd " + r + " " + g + " " + b);
            } else {
                TextureDefinition texture = this.textureManager.findTexture(textureId);
                assert (texture != null);
                mtlWriter.println("map_Kd sprite/" + texture.getFileIds()[0] + "-0.png");
            }
            int alpha = 0;
            if (this.model.faceTransparencies != null) {
                alpha = this.model.faceTransparencies[i] & 0xFF;
            }
            if (alpha == 0) continue;
            mtlWriter.println("d " + (double)alpha / 255.0);
        }
    }
}

