/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.cache.fs.flat;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import net.runelite.cache.fs.Archive;
import net.runelite.cache.fs.Index;
import net.runelite.cache.fs.Storage;
import net.runelite.cache.fs.Store;
import net.runelite.cache.index.FileData;

public class FlatStorage
implements Storage {
    protected static final String EXTENSION = ".flatcache";
    private final File directory;
    private final Map<Long, byte[]> data = new HashMap<Long, byte[]>();

    public FlatStorage(File directory) throws IOException {
        this.directory = directory;
    }

    protected FlatStorage() {
        this.directory = null;
    }

    protected InputStream openReader(String filename) throws IOException {
        return new FileInputStream(new File(this.directory, filename));
    }

    protected OutputStream openWriter(String filename) throws IOException {
        return new FileOutputStream(new File(this.directory, filename));
    }

    protected String[] listFlatcacheFiles() throws IOException {
        return this.directory.list((dir, name) -> name.endsWith(EXTENSION));
    }

    @Override
    public void init(Store store) throws IOException {
        String[] idxs;
        for (String idx : idxs = this.listFlatcacheFiles()) {
            int id = Integer.parseInt(idx.substring(0, idx.length() - EXTENSION.length()));
            store.addIndex(id);
        }
    }

    @Override
    public void close() throws IOException {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void load(Store store) throws IOException {
        for (Index idx : store.getIndexes()) {
            String file = idx.getId() + EXTENSION;
            try (BufferedReader br = new BufferedReader(new InputStreamReader(this.openReader(file), StandardCharsets.UTF_8));){
                int lineNo = 0;
                Archive archive = null;
                ArrayList<FileData> fileData = null;
                String line = br.readLine();
                while (line != null) {
                    block42: {
                        ++lineNo;
                        try {
                            int lidx = line.indexOf(61);
                            String key = line.substring(0, lidx);
                            String value = line.substring(lidx + 1);
                            if ("file".equals(key)) {
                                if (fileData == null) {
                                    fileData = new ArrayList<FileData>();
                                }
                                int vidx = value.indexOf(61);
                                FileData fd = new FileData();
                                fd.setId(Integer.parseInt(value.substring(0, vidx)));
                                fd.setNameHash(Integer.parseInt(value.substring(vidx + 1)));
                                fileData.add(fd);
                                break block42;
                            }
                            if (fileData != null) {
                                archive.setFileData(fileData.toArray(new FileData[0]));
                                fileData = null;
                            }
                            if ("id".equals(key)) {
                                archive = idx.addArchive(Integer.parseInt(value));
                                break block42;
                            }
                            if (archive == null) {
                                switch (key) {
                                    case "protocol": {
                                        idx.setProtocol(Integer.parseInt(value));
                                        break block42;
                                    }
                                    case "revision": {
                                        idx.setRevision(Integer.parseInt(value));
                                        break block42;
                                    }
                                    case "compression": {
                                        idx.setCompression(Integer.parseInt(value));
                                        break block42;
                                    }
                                    case "crc": {
                                        idx.setCrc(Integer.parseInt(value));
                                        break block42;
                                    }
                                    case "named": {
                                        idx.setNamed(Boolean.parseBoolean(value));
                                        break block42;
                                    }
                                    default: {
                                        throw new IOException("unknown key: \"" + key + "\"");
                                    }
                                }
                            }
                            switch (key) {
                                case "namehash": {
                                    archive.setNameHash(Integer.parseInt(value));
                                    break;
                                }
                                case "revision": {
                                    archive.setRevision(Integer.parseInt(value));
                                    break;
                                }
                                case "crc": {
                                    archive.setCrc(Integer.parseInt(value));
                                    break;
                                }
                                case "compression": {
                                    archive.setCompression(Integer.parseInt(value));
                                    break;
                                }
                                case "contents": {
                                    this.data.put((long)idx.getId() << 32 | (long)archive.getArchiveId(), Base64.getDecoder().decode(value));
                                    break;
                                }
                                default: {
                                    throw new IOException("unknown key: \"" + key + "\"");
                                }
                            }
                        }
                        catch (Exception e) {
                            throw new IOException("error reading flatcache at " + file + ":" + lineNo, e);
                        }
                    }
                    line = br.readLine();
                }
                if (fileData == null) continue;
                archive.setFileData(fileData.toArray(new FileData[0]));
                fileData = null;
            }
        }
    }

    @Override
    public void save(Store store) throws IOException {
        store.getIndexes().sort(Comparator.comparingInt(Index::getId));
        for (Index idx : store.getIndexes()) {
            String file = idx.getId() + EXTENSION;
            try (PrintStream br = new PrintStream(this.openWriter(file), false, StandardCharsets.UTF_8.name());){
                br.printf("protocol=%d\n", idx.getProtocol());
                br.printf("revision=%d\n", idx.getRevision());
                br.printf("compression=%d\n", idx.getCompression());
                br.printf("crc=%d\n", idx.getCrc());
                br.printf("named=%b\n", idx.isNamed());
                for (Archive archive : idx.getArchives()) {
                    br.printf("id=%d\n", archive.getArchiveId());
                    br.printf("namehash=%d\n", archive.getNameHash());
                    br.printf("revision=%d\n", archive.getRevision());
                    br.printf("crc=%d\n", archive.getCrc());
                    byte[] contents = store.getStorage().loadArchive(archive);
                    if (contents != null) {
                        br.append("contents=");
                        br.write(Base64.getEncoder().encode(contents));
                        br.append("\n");
                    }
                    br.printf("compression=%d\n", archive.getCompression());
                    for (FileData fd : archive.getFileData()) {
                        br.printf("file=%d=%d\n", fd.getId(), fd.getNameHash());
                    }
                }
            }
        }
    }

    @Override
    public byte[] load(int index, int archive) {
        return this.data.get((long)index << 32 | (long)archive);
    }

    @Override
    public void store(int index, int archive, byte[] bytes) {
        this.data.put((long)index << 32 | (long)archive, bytes);
    }
}

