/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.cache.definitions.loaders;

import net.runelite.cache.definitions.SpotAnimDefinition;
import net.runelite.cache.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpotAnimLoader {
    private static final Logger logger = LoggerFactory.getLogger(SpotAnimLoader.class);

    public SpotAnimDefinition load(int id, byte[] b) {
        int opcode;
        SpotAnimDefinition def = new SpotAnimDefinition();
        InputStream is = new InputStream(b);
        def.id = id;
        while ((opcode = is.readUnsignedByte()) != 0) {
            this.decodeValues(opcode, def, is);
        }
        return def;
    }

    private void decodeValues(int opcode, SpotAnimDefinition def, InputStream stream) {
        block3: {
            block11: {
                block10: {
                    block9: {
                        block8: {
                            block7: {
                                block6: {
                                    block5: {
                                        block4: {
                                            block2: {
                                                if (opcode != 1) break block2;
                                                def.modelId = stream.readUnsignedShort();
                                                break block3;
                                            }
                                            if (opcode != 2) break block4;
                                            def.animationId = stream.readUnsignedShort();
                                            break block3;
                                        }
                                        if (opcode != 4) break block5;
                                        def.resizeX = stream.readUnsignedShort();
                                        break block3;
                                    }
                                    if (opcode != 5) break block6;
                                    def.resizeY = stream.readUnsignedShort();
                                    break block3;
                                }
                                if (opcode != 6) break block7;
                                def.rotaton = stream.readUnsignedShort();
                                break block3;
                            }
                            if (opcode != 7) break block8;
                            def.ambient = stream.readUnsignedByte();
                            break block3;
                        }
                        if (opcode != 8) break block9;
                        def.contrast = stream.readUnsignedByte();
                        break block3;
                    }
                    if (opcode != 9) break block10;
                    def.debugName = stream.readString();
                    break block3;
                }
                if (opcode != 40) break block11;
                int var3 = stream.readUnsignedByte();
                def.recolorToFind = new short[var3];
                def.recolorToReplace = new short[var3];
                for (int var4 = 0; var4 < var3; ++var4) {
                    def.recolorToFind[var4] = (short)stream.readUnsignedShort();
                    def.recolorToReplace[var4] = (short)stream.readUnsignedShort();
                }
                break block3;
            }
            if (opcode != 41) break block3;
            int var3 = stream.readUnsignedByte();
            def.textureToFind = new short[var3];
            def.textureToReplace = new short[var3];
            for (int var4 = 0; var4 < var3; ++var4) {
                def.textureToFind[var4] = (short)stream.readUnsignedShort();
                def.textureToReplace[var4] = (short)stream.readUnsignedShort();
            }
        }
    }
}

