/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.cache.definitions.loaders;

import java.util.HashMap;
import net.runelite.cache.definitions.NpcDefinition;
import net.runelite.cache.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NpcLoader {
    private static final Logger log = LoggerFactory.getLogger(NpcLoader.class);
    public static final int REV_210_NPC_ARCHIVE_REV = 1493;
    private int defaultHeadIconArchive = -1;
    private boolean rev210HeadIcons = true;
    private boolean rev233 = true;

    public NpcLoader configureForRevision(int rev) {
        this.rev210HeadIcons = rev >= 1493;
        return this;
    }

    public NpcDefinition load(int id, byte[] b) {
        int opcode;
        NpcDefinition def = new NpcDefinition(id);
        InputStream is = new InputStream(b);
        while ((opcode = is.readUnsignedByte()) != 0) {
            this.decodeValues(opcode, def, is);
        }
        this.post(def);
        return def;
    }

    private void post(NpcDefinition def) {
        if (def.footprintSize == -1) {
            def.footprintSize = (int)(0.4f * (float)(def.size * 128));
        }
    }

    private void decodeValues(int opcode, NpcDefinition def, InputStream stream) {
        if (opcode == 1) {
            int length = stream.readUnsignedByte();
            def.models = new int[length];
            for (int index = 0; index < length; ++index) {
                def.models[index] = stream.readUnsignedShort();
            }
        } else if (opcode == 2) {
            def.name = stream.readString();
        } else if (opcode == 12) {
            def.size = stream.readUnsignedByte();
        } else if (opcode == 13) {
            def.standingAnimation = stream.readUnsignedShort();
        } else if (opcode == 14) {
            def.walkingAnimation = stream.readUnsignedShort();
        } else if (opcode == 15) {
            def.idleRotateLeftAnimation = stream.readUnsignedShort();
        } else if (opcode == 16) {
            def.idleRotateRightAnimation = stream.readUnsignedShort();
        } else if (opcode == 17) {
            def.walkingAnimation = stream.readUnsignedShort();
            def.rotate180Animation = stream.readUnsignedShort();
            def.rotateLeftAnimation = stream.readUnsignedShort();
            def.rotateRightAnimation = stream.readUnsignedShort();
        } else if (opcode == 18) {
            def.category = stream.readUnsignedShort();
        } else if (opcode >= 30 && opcode < 35) {
            def.actions[opcode - 30] = stream.readString();
            if (def.actions[opcode - 30].equalsIgnoreCase("Hidden")) {
                def.actions[opcode - 30] = null;
            }
        } else if (opcode == 40) {
            int length = stream.readUnsignedByte();
            def.recolorToFind = new short[length];
            def.recolorToReplace = new short[length];
            for (int index = 0; index < length; ++index) {
                def.recolorToFind[index] = (short)stream.readUnsignedShort();
                def.recolorToReplace[index] = (short)stream.readUnsignedShort();
            }
        } else if (opcode == 41) {
            int length = stream.readUnsignedByte();
            def.retextureToFind = new short[length];
            def.retextureToReplace = new short[length];
            for (int index = 0; index < length; ++index) {
                def.retextureToFind[index] = (short)stream.readUnsignedShort();
                def.retextureToReplace[index] = (short)stream.readUnsignedShort();
            }
        } else if (opcode == 60) {
            int length = stream.readUnsignedByte();
            def.chatheadModels = new int[length];
            for (int index = 0; index < length; ++index) {
                def.chatheadModels[index] = stream.readUnsignedShort();
            }
        } else if (opcode == 74) {
            def.stats[0] = stream.readUnsignedShort();
        } else if (opcode == 75) {
            def.stats[1] = stream.readUnsignedShort();
        } else if (opcode == 76) {
            def.stats[2] = stream.readUnsignedShort();
        } else if (opcode == 77) {
            def.stats[3] = stream.readUnsignedShort();
        } else if (opcode == 78) {
            def.stats[4] = stream.readUnsignedShort();
        } else if (opcode == 79) {
            def.stats[5] = stream.readUnsignedShort();
        } else if (opcode == 93) {
            def.isMinimapVisible = false;
        } else if (opcode == 95) {
            def.combatLevel = stream.readUnsignedShort();
        } else if (opcode == 97) {
            def.widthScale = stream.readUnsignedShort();
        } else if (opcode == 98) {
            def.heightScale = stream.readUnsignedShort();
        } else if (opcode == 99) {
            def.renderPriority = 1;
        } else if (opcode == 100) {
            def.ambient = stream.readByte();
        } else if (opcode == 101) {
            def.contrast = stream.readByte();
        } else if (opcode == 102) {
            if (!this.rev210HeadIcons) {
                def.headIconArchiveIds = new int[]{this.defaultHeadIconArchive};
                def.headIconSpriteIndex = new short[]{(short)stream.readUnsignedShort()};
            } else {
                int bitfield = stream.readUnsignedByte();
                int len = 0;
                for (int var5 = bitfield; var5 != 0; var5 >>= 1) {
                    ++len;
                }
                def.headIconArchiveIds = new int[len];
                def.headIconSpriteIndex = new short[len];
                for (int i = 0; i < len; ++i) {
                    if ((bitfield & 1 << i) == 0) {
                        def.headIconArchiveIds[i] = -1;
                        def.headIconSpriteIndex[i] = -1;
                        continue;
                    }
                    def.headIconArchiveIds[i] = stream.readBigSmart2();
                    def.headIconSpriteIndex[i] = (short)stream.readUnsignedShortSmartMinusOne();
                }
            }
        } else if (opcode == 103) {
            def.rotationSpeed = stream.readUnsignedShort();
        } else if (opcode == 106) {
            def.varbitId = stream.readUnsignedShort();
            if (def.varbitId == 65535) {
                def.varbitId = -1;
            }
            def.varpIndex = stream.readUnsignedShort();
            if (def.varpIndex == 65535) {
                def.varpIndex = -1;
            }
            int length = stream.readUnsignedByte();
            def.configs = new int[length + 2];
            for (int index = 0; index <= length; ++index) {
                def.configs[index] = stream.readUnsignedShort();
                if (def.configs[index] != 65535) continue;
                def.configs[index] = -1;
            }
            def.configs[length + 1] = -1;
        } else if (opcode == 107) {
            def.isInteractable = false;
        } else if (opcode == 109) {
            def.rotationFlag = false;
        } else if (opcode == 111 && !this.rev233) {
            def.isFollower = true;
            def.lowPriorityFollowerOps = true;
        } else if (opcode == 111 && this.rev233) {
            def.renderPriority = 2;
        } else if (opcode == 114) {
            def.runAnimation = stream.readUnsignedShort();
        } else if (opcode == 115) {
            def.runAnimation = stream.readUnsignedShort();
            def.runRotate180Animation = stream.readUnsignedShort();
            def.runRotateLeftAnimation = stream.readUnsignedShort();
            def.runRotateRightAnimation = stream.readUnsignedShort();
        } else if (opcode == 116) {
            def.crawlAnimation = stream.readUnsignedShort();
        } else if (opcode == 117) {
            def.crawlAnimation = stream.readUnsignedShort();
            def.crawlRotate180Animation = stream.readUnsignedShort();
            def.crawlRotateLeftAnimation = stream.readUnsignedShort();
            def.crawlRotateRightAnimation = stream.readUnsignedShort();
        } else if (opcode == 118) {
            int var;
            def.varbitId = stream.readUnsignedShort();
            if (def.varbitId == 65535) {
                def.varbitId = -1;
            }
            def.varpIndex = stream.readUnsignedShort();
            if (def.varpIndex == 65535) {
                def.varpIndex = -1;
            }
            if ((var = stream.readUnsignedShort()) == 65535) {
                var = -1;
            }
            int length = stream.readUnsignedByte();
            def.configs = new int[length + 2];
            for (int index = 0; index <= length; ++index) {
                def.configs[index] = stream.readUnsignedShort();
                if (def.configs[index] != 65535) continue;
                def.configs[index] = -1;
            }
            def.configs[length + 1] = var;
        } else if (opcode == 122) {
            def.isFollower = true;
        } else if (opcode == 123) {
            def.lowPriorityFollowerOps = true;
        } else if (opcode == 124) {
            def.height = stream.readUnsignedShort();
        } else if (opcode == 126) {
            def.footprintSize = stream.readUnsignedShort();
        } else if (opcode == 129) {
            def.unknown1 = true;
        } else if (opcode == 145) {
            def.canHideForOverlap = true;
        } else if (opcode == 146) {
            def.overlapTintHSL = stream.readUnsignedShort();
        } else if (opcode == 249) {
            int length = stream.readUnsignedByte();
            def.params = new HashMap<Integer, Object>(length);
            for (int i = 0; i < length; ++i) {
                boolean isString = stream.readUnsignedByte() == 1;
                int key = stream.read24BitInt();
                Object value = isString ? stream.readString() : Integer.valueOf(stream.readInt());
                def.params.put(key, value);
            }
        } else {
            log.warn("Unrecognized opcode {}", (Object)opcode);
        }
    }

    public int getDefaultHeadIconArchive() {
        return this.defaultHeadIconArchive;
    }

    public boolean isRev210HeadIcons() {
        return this.rev210HeadIcons;
    }

    public boolean isRev233() {
        return this.rev233;
    }

    public NpcLoader setDefaultHeadIconArchive(int defaultHeadIconArchive) {
        this.defaultHeadIconArchive = defaultHeadIconArchive;
        return this;
    }

    public NpcLoader setRev210HeadIcons(boolean rev210HeadIcons) {
        this.rev210HeadIcons = rev210HeadIcons;
        return this;
    }

    public NpcLoader setRev233(boolean rev233) {
        this.rev233 = rev233;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NpcLoader)) {
            return false;
        }
        NpcLoader other = (NpcLoader)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getDefaultHeadIconArchive() != other.getDefaultHeadIconArchive()) {
            return false;
        }
        if (this.isRev210HeadIcons() != other.isRev210HeadIcons()) {
            return false;
        }
        return this.isRev233() == other.isRev233();
    }

    protected boolean canEqual(Object other) {
        return other instanceof NpcLoader;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getDefaultHeadIconArchive();
        result = result * 59 + (this.isRev210HeadIcons() ? 79 : 97);
        result = result * 59 + (this.isRev233() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "NpcLoader(defaultHeadIconArchive=" + this.getDefaultHeadIconArchive() + ", rev210HeadIcons=" + this.isRev210HeadIcons() + ", rev233=" + this.isRev233() + ")";
    }
}

