/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.cache;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.IOException;
import net.runelite.cache.fs.Store;
import net.runelite.cache.region.Region;
import net.runelite.cache.region.RegionLoader;
import net.runelite.cache.util.KeyProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeightMapDumper {
    private static final Logger logger = LoggerFactory.getLogger(HeightMapDumper.class);
    private static final int MAP_SCALE = 1;
    private static final float MAX_HEIGHT = 2048.0f;
    private final Store store;
    private RegionLoader regionLoader;

    public HeightMapDumper(Store store) {
        this.store = store;
    }

    public void load(KeyProvider keyProvider) throws IOException {
        this.regionLoader = new RegionLoader(this.store, keyProvider);
        this.regionLoader.loadRegions();
        this.regionLoader.calculateBounds();
    }

    public BufferedImage drawHeightMap(int z) {
        int minX = this.regionLoader.getLowestX().getBaseX();
        int minY = this.regionLoader.getLowestY().getBaseY();
        int maxX = this.regionLoader.getHighestX().getBaseX() + 64;
        int maxY = this.regionLoader.getHighestY().getBaseY() + 64;
        int dimX = maxX - minX;
        int dimY = maxY - minY;
        logger.info("Map image dimensions: {}px x {}px, {}px per map square ({} MB)", new Object[]{dimX *= 1, dimY *= 1, 1, dimX * dimY / 1024 / 1024});
        BufferedImage image = new BufferedImage(dimX, dimY, 1);
        this.draw(image, z);
        return image;
    }

    private void draw(BufferedImage image, int z) {
        int max = Integer.MIN_VALUE;
        int min = Integer.MAX_VALUE;
        for (Region region : this.regionLoader.getRegions()) {
            int baseX = region.getBaseX();
            int baseY = region.getBaseY();
            int drawBaseX = baseX - this.regionLoader.getLowestX().getBaseX();
            int drawBaseY = this.regionLoader.getHighestY().getBaseY() - baseY;
            for (int x = 0; x < 64; ++x) {
                int drawX = drawBaseX + x;
                for (int y = 0; y < 64; ++y) {
                    int drawY = drawBaseY + (63 - y);
                    int height = region.getTileHeight(z, x, y);
                    if (height > max) {
                        max = height;
                    }
                    if (height < min) {
                        min = height;
                    }
                    int rgb = this.toColor(height);
                    this.drawMapSquare(image, drawX, drawY, rgb);
                }
            }
        }
        System.out.println("max " + max);
        System.out.println("min " + min);
    }

    private int toColor(int height) {
        height = -height;
        float color = (float)height / 2048.0f;
        assert (color >= 0.0f && color <= 1.0f);
        return new Color(color, color, color).getRGB();
    }

    private void drawMapSquare(BufferedImage image, int x, int y, int rgb) {
        x *= 1;
        y *= 1;
        for (int i = 0; i < 1; ++i) {
            for (int j = 0; j < 1; ++j) {
                image.setRGB(x + i, y + j, rgb);
            }
        }
    }
}

