/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.cache;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.runelite.cache.IndexType;
import net.runelite.cache.definitions.DBTableIndex;
import net.runelite.cache.definitions.loaders.DBTableIndexLoader;
import net.runelite.cache.fs.Archive;
import net.runelite.cache.fs.ArchiveFiles;
import net.runelite.cache.fs.FSFile;
import net.runelite.cache.fs.Index;
import net.runelite.cache.fs.Storage;
import net.runelite.cache.fs.Store;

public class DBTableIndexManager {
    private final Store store;
    private final Map<Integer, DBTableIndex> indexes = new HashMap<Integer, DBTableIndex>();

    public DBTableIndexManager(Store store) {
        this.store = store;
    }

    public void load() throws IOException {
        DBTableIndexLoader loader = new DBTableIndexLoader();
        Storage storage = this.store.getStorage();
        Index index = this.store.getIndex(IndexType.DBTABLEINDEX);
        if (index == null) {
            return;
        }
        for (Archive archive : index.getArchives()) {
            byte[] archiveData = storage.loadArchive(archive);
            ArchiveFiles files = archive.getFiles(archiveData);
            for (FSFile f : files.getFiles()) {
                DBTableIndex row = loader.load(archive.getArchiveId(), f.getFileId() - 1, f.getContents());
                this.indexes.put(archive.getArchiveId() << 16 | f.getFileId(), row);
            }
        }
    }

    public Collection<DBTableIndex> getIndexes() {
        return Collections.unmodifiableCollection(this.indexes.values());
    }

    public DBTableIndex getMaster(int tableId) {
        return this.indexes.get(tableId << 16);
    }

    public DBTableIndex get(int tableId, int columnId) {
        return this.indexes.get(tableId << 16 | columnId + 1);
    }
}

