/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.cache.fs.jagex;

import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import net.runelite.cache.fs.jagex.DataFileWriteResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataFile
implements Closeable {
    private static final Logger logger = LoggerFactory.getLogger(DataFile.class);
    private static final int SECTOR_SIZE = 520;
    private final RandomAccessFile dat;

    public DataFile(File file) throws FileNotFoundException {
        this.dat = new RandomAccessFile(file, "rw");
    }

    @Override
    public void close() throws IOException {
        this.dat.close();
    }

    public void clear() throws IOException {
        this.dat.setLength(0L);
    }

    public synchronized byte[] read(int indexId, int archiveId, int sector, int size) throws IOException {
        if ((long)sector <= 0L || this.dat.length() / 520L < (long)sector) {
            logger.warn("bad read, dat length {}, requested sector {}", (Object)this.dat.length(), (Object)sector);
            return null;
        }
        byte[] readBuffer = new byte[520];
        ByteBuffer buffer = ByteBuffer.allocate(size);
        int part = 0;
        int readBytesCount = 0;
        while (size > readBytesCount) {
            int currentIndex;
            int nextSector;
            int currentPart;
            int currentArchive;
            int i;
            int headerSize;
            if (sector == 0) {
                logger.warn("Unexpected end of file");
                return null;
            }
            this.dat.seek(520 * sector);
            int dataBlockSize = size - readBytesCount;
            if (archiveId > 65535) {
                headerSize = 10;
                if (dataBlockSize > 520 - headerSize) {
                    dataBlockSize = 520 - headerSize;
                }
                if ((i = this.dat.read(readBuffer, 0, headerSize + dataBlockSize)) != headerSize + dataBlockSize) {
                    logger.warn("Short read when reading file data for {}/{}", (Object)indexId, (Object)archiveId);
                    return null;
                }
                currentArchive = (readBuffer[0] & 0xFF) << 24 | (readBuffer[1] & 0xFF) << 16 | (readBuffer[2] & 0xFF) << 8 | readBuffer[3] & 0xFF;
                currentPart = ((readBuffer[4] & 0xFF) << 8) + (readBuffer[5] & 0xFF);
                nextSector = (readBuffer[6] & 0xFF) << 16 | (readBuffer[7] & 0xFF) << 8 | readBuffer[8] & 0xFF;
                currentIndex = readBuffer[9] & 0xFF;
            } else {
                headerSize = 8;
                if (dataBlockSize > 520 - headerSize) {
                    dataBlockSize = 520 - headerSize;
                }
                if ((i = this.dat.read(readBuffer, 0, headerSize + dataBlockSize)) != headerSize + dataBlockSize) {
                    logger.warn("short read");
                    return null;
                }
                currentArchive = (readBuffer[0] & 0xFF) << 8 | readBuffer[1] & 0xFF;
                currentPart = (readBuffer[2] & 0xFF) << 8 | readBuffer[3] & 0xFF;
                nextSector = (readBuffer[4] & 0xFF) << 16 | (readBuffer[5] & 0xFF) << 8 | readBuffer[6] & 0xFF;
                currentIndex = readBuffer[7] & 0xFF;
            }
            if (archiveId != currentArchive || currentPart != part || indexId != currentIndex) {
                logger.warn("data mismatch {} != {}, {} != {}, {} != {}", new Object[]{archiveId, currentArchive, part, currentPart, indexId, currentIndex});
                return null;
            }
            if (nextSector < 0 || this.dat.length() / 520L < (long)nextSector) {
                logger.warn("Invalid next sector");
                return null;
            }
            buffer.put(readBuffer, headerSize, dataBlockSize);
            readBytesCount += dataBlockSize;
            ++part;
            sector = nextSector;
        }
        buffer.flip();
        return buffer.array();
    }

    public synchronized DataFileWriteResult write(int indexId, int archiveId, byte[] compressedData) throws IOException {
        byte[] writeBuffer = new byte[520];
        ByteBuffer data = ByteBuffer.wrap(compressedData);
        int sector = (int)((this.dat.length() + 519L) / 520L);
        if (sector == 0) {
            sector = 1;
        }
        int startSector = sector;
        int part = 0;
        while (data.hasRemaining()) {
            int dataToWrite;
            int nextSector = sector + 1;
            if (65535 < archiveId) {
                if (data.remaining() <= 510) {
                    nextSector = 0;
                }
                writeBuffer[0] = (byte)(archiveId >> 24);
                writeBuffer[1] = (byte)(archiveId >> 16);
                writeBuffer[2] = (byte)(archiveId >> 8);
                writeBuffer[3] = (byte)archiveId;
                writeBuffer[4] = (byte)(part >> 8);
                writeBuffer[5] = (byte)part;
                writeBuffer[6] = (byte)(nextSector >> 16);
                writeBuffer[7] = (byte)(nextSector >> 8);
                writeBuffer[8] = (byte)nextSector;
                writeBuffer[9] = (byte)indexId;
                this.dat.seek(520 * sector);
                this.dat.write(writeBuffer, 0, 10);
                dataToWrite = data.remaining();
                if (dataToWrite > 510) {
                    dataToWrite = 510;
                }
            } else {
                if (data.remaining() <= 512) {
                    nextSector = 0;
                }
                writeBuffer[0] = (byte)(archiveId >> 8);
                writeBuffer[1] = (byte)archiveId;
                writeBuffer[2] = (byte)(part >> 8);
                writeBuffer[3] = (byte)part;
                writeBuffer[4] = (byte)(nextSector >> 16);
                writeBuffer[5] = (byte)(nextSector >> 8);
                writeBuffer[6] = (byte)nextSector;
                writeBuffer[7] = (byte)indexId;
                this.dat.seek(520 * sector);
                this.dat.write(writeBuffer, 0, 8);
                dataToWrite = data.remaining();
                if (dataToWrite > 512) {
                    dataToWrite = 512;
                }
            }
            data.get(writeBuffer, 0, dataToWrite);
            this.dat.write(writeBuffer, 0, dataToWrite);
            sector = nextSector;
            ++part;
        }
        DataFileWriteResult res = new DataFileWriteResult();
        res.sector = startSector;
        res.compressedLength = compressedData.length;
        return res;
    }
}

