/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.cache.models;

public final class JagexColor {
    public static final double BRIGHTNESS_MAX = 0.6;
    public static final double BRIGHTNESS_HIGH = 0.7;
    public static final double BRIGHTNESS_LOW = 0.8;
    public static final double BRIGHTNESS_MIN = 0.9;
    private static final double HUE_OFFSET = 0.0078125;
    private static final double SATURATION_OFFSET = 0.0625;

    private JagexColor() {
    }

    public static short packHSL(int hue, int saturation, int luminance) {
        return (short)((short)(hue & 0x3F) << 10 | (short)(saturation & 7) << 7 | (short)(luminance & 0x7F));
    }

    public static int packHSLFull(int hue, int saturation, int luminance) {
        return (hue & 0xFF) << 16 | (saturation & 0xFF) << 8 | luminance & 0xFF;
    }

    public static int unpackHue(short hsl) {
        return hsl >> 10 & 0x3F;
    }

    public static int unpackSaturation(short hsl) {
        return hsl >> 7 & 7;
    }

    public static int unpackLuminance(short hsl) {
        return hsl & 0x7F;
    }

    public static int unpackHueFull(int hsl) {
        return hsl >> 16 & 0xFF;
    }

    public static int unpackSaturationFull(int hsl) {
        return hsl >> 8 & 0xFF;
    }

    public static int unpackLuminanceFull(int hsl) {
        return hsl & 0xFF;
    }

    public static String formatHSL(short hsl) {
        return String.format("%02Xh%Xs%02Xl", JagexColor.unpackHue(hsl), JagexColor.unpackSaturation(hsl), JagexColor.unpackLuminance(hsl));
    }

    public static int HSLtoRGB(short hsl, double brightness) {
        double lightness;
        double hue = (double)JagexColor.unpackHue(hsl) / 64.0 + 0.0078125;
        double saturation = (double)JagexColor.unpackSaturation(hsl) / 8.0 + 0.0625;
        double luminance = (double)JagexColor.unpackLuminance(hsl) / 128.0;
        double chroma = (1.0 - Math.abs(2.0 * luminance - 1.0)) * saturation;
        double x = chroma * (1.0 - Math.abs(hue * 6.0 % 2.0 - 1.0));
        double r = lightness = luminance - chroma / 2.0;
        double g = lightness;
        double b = lightness;
        switch ((int)(hue * 6.0)) {
            case 0: {
                r += chroma;
                g += x;
                break;
            }
            case 1: {
                g += chroma;
                r += x;
                break;
            }
            case 2: {
                g += chroma;
                b += x;
                break;
            }
            case 3: {
                b += chroma;
                g += x;
                break;
            }
            case 4: {
                b += chroma;
                r += x;
                break;
            }
            default: {
                r += chroma;
                b += x;
            }
        }
        int rgb = (int)(r * 256.0) << 16 | (int)(g * 256.0) << 8 | (int)(b * 256.0);
        rgb = JagexColor.adjustForBrightness(rgb, brightness);
        if (rgb == 0) {
            rgb = 1;
        }
        return rgb;
    }

    public static int HSLtoRGBFull(int hsl) {
        double lightness;
        double hue = (double)JagexColor.unpackHueFull(hsl) / 256.0;
        double saturation = (double)JagexColor.unpackSaturationFull(hsl) / 256.0;
        double luminance = (double)JagexColor.unpackLuminanceFull(hsl) / 256.0;
        double chroma = (1.0 - Math.abs(2.0 * luminance - 1.0)) * saturation;
        double x = chroma * (1.0 - Math.abs(hue * 6.0 % 2.0 - 1.0));
        double r = lightness = luminance - chroma / 2.0;
        double g = lightness;
        double b = lightness;
        switch ((int)(hue * 6.0)) {
            case 0: {
                r += chroma;
                g += x;
                break;
            }
            case 1: {
                g += chroma;
                r += x;
                break;
            }
            case 2: {
                g += chroma;
                b += x;
                break;
            }
            case 3: {
                b += chroma;
                g += x;
                break;
            }
            case 4: {
                b += chroma;
                r += x;
                break;
            }
            default: {
                r += chroma;
                b += x;
            }
        }
        int rgb = ((int)(r * 256.0) & 0xFF) << 16 | ((int)(g * 256.0) & 0xFF) << 8 | (int)(b * 256.0) & 0xFF;
        if (rgb == 0) {
            rgb = 1;
        }
        return rgb;
    }

    public static int adjustForBrightness(int rgb, double brightness) {
        double r = (double)(rgb >> 16) / 256.0;
        double g = (double)(rgb >> 8 & 0xFF) / 256.0;
        double b = (double)(rgb & 0xFF) / 256.0;
        r = Math.pow(r, brightness);
        g = Math.pow(g, brightness);
        b = Math.pow(b, brightness);
        return (int)(r * 256.0) << 16 | (int)(g * 256.0) << 8 | (int)(b * 256.0);
    }

    public static int[] createPalette(double brightness) {
        int[] colorPalette = new int[65536];
        for (int i = 0; i < colorPalette.length; ++i) {
            colorPalette[i] = JagexColor.HSLtoRGB((short)i, brightness);
        }
        return colorPalette;
    }

    public static int getRGBFull(int hsl) {
        return JagexColor.HSLtoRGBFull(hsl);
    }
}

