/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.cache;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.runelite.cache.IndexType;
import net.runelite.cache.definitions.ScriptDefinition;
import net.runelite.cache.definitions.WorldMapCompositeDefinition;
import net.runelite.cache.definitions.WorldMapElementDefinition;
import net.runelite.cache.definitions.loaders.ScriptLoader;
import net.runelite.cache.definitions.loaders.WorldMapCompositeLoader;
import net.runelite.cache.fs.Archive;
import net.runelite.cache.fs.ArchiveFiles;
import net.runelite.cache.fs.FSFile;
import net.runelite.cache.fs.Index;
import net.runelite.cache.fs.Storage;
import net.runelite.cache.fs.Store;
import net.runelite.cache.region.Position;

public class WorldMapManager {
    private final Store store;
    private final List<WorldMapCompositeDefinition> worldMapCompositeDefinitions = new ArrayList<WorldMapCompositeDefinition>();
    private final List<WorldMapElementDefinition> elements = new ArrayList<WorldMapElementDefinition>();
    private final Map<Position, Position> intermapLinks = new HashMap<Position, Position>();

    public WorldMapManager(Store store) {
        this.store = store;
    }

    public void load() throws IOException {
        Storage storage = this.store.getStorage();
        Index index = this.store.getIndex(IndexType.WORLDMAP);
        Archive compositeMapArchive = index.findArchiveByName("compositemap");
        WorldMapCompositeLoader worldMapCompositeLoader = new WorldMapCompositeLoader();
        ArchiveFiles compositeMapFiles = compositeMapArchive.getFiles(storage.loadArchive(compositeMapArchive));
        for (FSFile compositeFile : compositeMapFiles.getFiles()) {
            WorldMapCompositeDefinition composite = worldMapCompositeLoader.load(compositeFile.getContents());
            this.worldMapCompositeDefinitions.add(composite);
        }
        for (WorldMapCompositeDefinition compositeDefinition : this.worldMapCompositeDefinitions) {
            this.elements.addAll(compositeDefinition.getWorldMapElementDefinitions());
        }
        int intermapLinkScriptId = 1705;
        Index scriptIndex = this.store.getIndex(IndexType.CLIENTSCRIPT);
        Archive intermapLinkScript = scriptIndex.getArchive(1705);
        byte[] data = storage.loadArchive(intermapLinkScript);
        FSFile file = intermapLinkScript.getFiles(data).findFile(0);
        ScriptLoader scriptLoader = new ScriptLoader();
        ScriptDefinition scriptDefinition = scriptLoader.load(1705, file.getContents());
        ArrayList<Position> linkEnds = new ArrayList<Position>();
        for (int i2 = 1; i2 < scriptDefinition.getIntOperands().length; ++i2) {
            if (scriptDefinition.getIntOperands()[i2] != 1706) continue;
            linkEnds.add(Position.fromPacked(scriptDefinition.getIntOperands()[i2 - 1]));
        }
        Map<Integer, Integer> linkSwitch = scriptDefinition.getSwitches()[0];
        int[] linkStarts = Arrays.stream(linkSwitch.keySet().toArray()).sorted(Comparator.comparingInt(linkSwitch::get)).mapToInt(i -> (Integer)i).toArray();
        assert (linkStarts.length - 1 == linkEnds.size());
        for (int i3 = 0; i3 < linkStarts.length; ++i3) {
            Position linkStartPosition = Position.fromPacked(linkStarts[i3]);
            Position linkEndPosition = (Position)linkEnds.get(i3);
            this.intermapLinks.put(linkStartPosition, linkEndPosition);
        }
    }

    public List<WorldMapElementDefinition> getElements() {
        return this.elements;
    }

    public Map<Position, Position> getIntermapLinks() {
        return this.intermapLinks;
    }
}

