/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.cache;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.runelite.cache.IndexType;
import net.runelite.cache.definitions.FontDefinition;
import net.runelite.cache.definitions.loaders.FontLoader;
import net.runelite.cache.fs.Archive;
import net.runelite.cache.fs.FSFile;
import net.runelite.cache.fs.Index;
import net.runelite.cache.fs.Storage;
import net.runelite.cache.fs.Store;
import net.runelite.cache.util.Djb2;

public class FontManager {
    private final Store store;
    private final Map<Integer, FontDefinition> fonts = new HashMap<Integer, FontDefinition>();

    public FontManager(Store store) {
        this.store = store;
    }

    public void load() throws IOException {
        Storage storage = this.store.getStorage();
        Index index = this.store.getIndex(IndexType.FONTS);
        FontLoader fontLoader = new FontLoader();
        for (Archive archive : index.getArchives()) {
            byte[] data = storage.loadArchive(archive);
            FSFile file = archive.getFiles(data).findFile(0);
            FontDefinition fontDefinition = fontLoader.load(file.getContents());
            this.fonts.put(archive.getNameHash(), fontDefinition);
        }
    }

    public FontDefinition getFont(int nameHash) {
        return this.fonts.get(nameHash);
    }

    public FontDefinition findFontByName(String name) {
        int nameHash = Djb2.hash(name);
        return this.getFont(nameHash);
    }
}

