/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.cache;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.runelite.cache.ConfigType;
import net.runelite.cache.IndexType;
import net.runelite.cache.definitions.InventoryDefinition;
import net.runelite.cache.definitions.loaders.InventoryLoader;
import net.runelite.cache.fs.Archive;
import net.runelite.cache.fs.ArchiveFiles;
import net.runelite.cache.fs.FSFile;
import net.runelite.cache.fs.Index;
import net.runelite.cache.fs.Storage;
import net.runelite.cache.fs.Store;

public class InventoryManager {
    private final Store store;
    private final List<InventoryDefinition> inventories = new ArrayList<InventoryDefinition>();

    public InventoryManager(Store store) {
        this.store = store;
    }

    public void load() throws IOException {
        InventoryLoader loader = new InventoryLoader();
        Storage storage = this.store.getStorage();
        Index index = this.store.getIndex(IndexType.CONFIGS);
        Archive archive = index.getArchive(ConfigType.INV.getId());
        byte[] archiveData = storage.loadArchive(archive);
        ArchiveFiles files = archive.getFiles(archiveData);
        for (FSFile file : files.getFiles()) {
            InventoryDefinition inv = loader.load(file.getFileId(), file.getContents());
            this.inventories.add(inv);
        }
    }

    public List<InventoryDefinition> getInventories() {
        return Collections.unmodifiableList(this.inventories);
    }

    public InventoryDefinition findInventory(int id) {
        for (InventoryDefinition def : this.inventories) {
            if (def.id != id) continue;
            return def;
        }
        return null;
    }
}

