/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.cache;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.runelite.cache.ConfigType;
import net.runelite.cache.IndexType;
import net.runelite.cache.definitions.AreaDefinition;
import net.runelite.cache.definitions.loaders.AreaLoader;
import net.runelite.cache.fs.Archive;
import net.runelite.cache.fs.ArchiveFiles;
import net.runelite.cache.fs.FSFile;
import net.runelite.cache.fs.Index;
import net.runelite.cache.fs.Storage;
import net.runelite.cache.fs.Store;

public class AreaManager {
    private final Store store;
    private final Map<Integer, AreaDefinition> areas = new HashMap<Integer, AreaDefinition>();

    public AreaManager(Store store) {
        this.store = store;
    }

    public void load() throws IOException {
        Storage storage = this.store.getStorage();
        Index index = this.store.getIndex(IndexType.CONFIGS);
        Archive archive = index.getArchive(ConfigType.AREA.getId());
        byte[] archiveData = storage.loadArchive(archive);
        ArchiveFiles files = archive.getFiles(archiveData);
        for (FSFile file : files.getFiles()) {
            AreaLoader loader = new AreaLoader();
            AreaDefinition area = loader.load(file.getContents(), file.getFileId());
            this.areas.put(area.id, area);
        }
    }

    public Collection<AreaDefinition> getAreas() {
        return Collections.unmodifiableCollection(this.areas.values());
    }

    public AreaDefinition getArea(int areaId) {
        return this.areas.get(areaId);
    }
}

