/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.cache.definitions.loaders;

import java.util.LinkedHashMap;
import java.util.Map;
import net.runelite.cache.definitions.ScriptDefinition;
import net.runelite.cache.io.InputStream;

public class ScriptLoader {
    public ScriptDefinition load(int id, byte[] b) {
        ScriptDefinition def = new ScriptDefinition();
        def.setId(id);
        InputStream in = new InputStream(b);
        in.setOffset(in.getLength() - 2);
        int switchLength = in.readUnsignedShort();
        int endIdx = in.getLength() - 2 - switchLength - 12;
        in.setOffset(endIdx);
        int numOpcodes = in.readInt();
        int localIntCount = in.readUnsignedShort();
        int localObjCount = in.readUnsignedShort();
        int intArgCount = in.readUnsignedShort();
        int objArgCount = in.readUnsignedShort();
        int numSwitches = in.readUnsignedByte();
        if (numSwitches > 0) {
            Map[] switches = new Map[numSwitches];
            def.setSwitches(switches);
            for (int i = 0; i < numSwitches; ++i) {
                switches[i] = new LinkedHashMap();
                int count = in.readUnsignedShort();
                while (count-- > 0) {
                    int key = in.readInt();
                    int pcOffset = in.readInt();
                    switches[i].put(key, pcOffset);
                }
            }
        }
        def.setLocalIntCount(localIntCount);
        def.setLocalObjCount(localObjCount);
        def.setIntArgCount(intArgCount);
        def.setObjArgCount(objArgCount);
        in.setOffset(0);
        in.readStringOrNull();
        int[] instructions = new int[numOpcodes];
        int[] intOperands = new int[numOpcodes];
        String[] stringOperands = new String[numOpcodes];
        def.setInstructions(instructions);
        def.setIntOperands(intOperands);
        def.setStringOperands(stringOperands);
        int i = 0;
        while (in.getOffset() < endIdx) {
            int opcode;
            instructions[i] = opcode = in.readUnsignedShort();
            switch (opcode) {
                case 3: {
                    stringOperands[i] = in.readString();
                    break;
                }
                case 21: 
                case 38: 
                case 39: 
                case 63: {
                    intOperands[i] = in.readUnsignedByte();
                    break;
                }
                default: {
                    intOperands[i] = opcode < 100 ? in.readInt() : in.readUnsignedByte();
                }
            }
            ++i;
        }
        return def;
    }
}

