/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.cache;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.runelite.cache.ConfigType;
import net.runelite.cache.IndexType;
import net.runelite.cache.definitions.ItemDefinition;
import net.runelite.cache.definitions.exporters.ItemExporter;
import net.runelite.cache.definitions.loaders.ItemLoader;
import net.runelite.cache.definitions.providers.ItemProvider;
import net.runelite.cache.fs.Archive;
import net.runelite.cache.fs.ArchiveFiles;
import net.runelite.cache.fs.FSFile;
import net.runelite.cache.fs.Index;
import net.runelite.cache.fs.Storage;
import net.runelite.cache.fs.Store;
import net.runelite.cache.util.IDClass;

public class ItemManager
implements ItemProvider {
    private final Store store;
    private final Map<Integer, ItemDefinition> items = new HashMap<Integer, ItemDefinition>();

    public ItemManager(Store store) {
        this.store = store;
    }

    public void load() throws IOException {
        ItemLoader loader = new ItemLoader();
        Storage storage = this.store.getStorage();
        Index index = this.store.getIndex(IndexType.CONFIGS);
        Archive archive = index.getArchive(ConfigType.ITEM.getId());
        byte[] archiveData = storage.loadArchive(archive);
        ArchiveFiles files = archive.getFiles(archiveData);
        for (FSFile f : files.getFiles()) {
            ItemDefinition def = loader.load(f.getFileId(), f.getContents());
            this.items.put(f.getFileId(), def);
        }
    }

    public void link() {
        for (ItemDefinition oc : this.items.values()) {
            this.link(oc);
        }
    }

    private void link(ItemDefinition item) {
        if (item.notedTemplate != -1) {
            item.linkNote(this.getItem(item.notedTemplate), this.getItem(item.notedID));
        }
        if (item.boughtTemplateId != -1) {
            item.linkBought(this.getItem(item.boughtTemplateId), this.getItem(item.boughtId));
        }
        if (item.placeholderTemplateId != -1) {
            item.linkPlaceholder(this.getItem(item.placeholderTemplateId), this.getItem(item.placeholderId));
        }
    }

    public Collection<ItemDefinition> getItems() {
        return Collections.unmodifiableCollection(this.items.values());
    }

    public ItemDefinition getItem(int itemId) {
        return this.items.get(itemId);
    }

    public void export(File out) throws IOException {
        out.mkdirs();
        for (ItemDefinition def : this.items.values()) {
            ItemExporter exporter = new ItemExporter(def);
            File targ = new File(out, def.id + ".json");
            exporter.exportTo(targ);
        }
    }

    public void java(File java) throws IOException {
        java.mkdirs();
        try (IDClass ids = IDClass.create(java, "ItemID");
             IDClass nulls = IDClass.create(java, "NullItemID");){
            for (ItemDefinition def : this.items.values()) {
                if (def.name.equalsIgnoreCase("NULL")) {
                    nulls.add(def.name, def.id);
                    continue;
                }
                ids.add(def.name, def.id);
            }
        }
    }

    @Override
    public ItemDefinition provide(int itemId) {
        return this.getItem(itemId);
    }
}

