/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.cache.definitions.loaders;

import net.runelite.cache.definitions.TrackDefinition;
import net.runelite.cache.io.InputStream;
import net.runelite.cache.io.OutputStream;

public class TrackLoader {
    private static final int MTHD_MAGIC = 1297377380;
    private static final int MTRK_MAGIC = 1297379947;
    private static final int NOTE_ON = 144;
    private static final int NOTE_OFF = 128;
    private static final int CONTROL_CHANGE = 176;
    private static final int PITCH_WHEEL_CHANGE = 224;
    private static final int CHANNEL_PRESSURE = 208;
    private static final int POLYPHONIC_KEY_PRESSURE = 160;
    private static final int PROGRAM_CHANGE = 192;
    private static final int META = 255;
    private static final int END_OF_TRACK = 47;
    private static final int TEMPO = 81;
    private static final int CONTROLLER_BANK_SELECT = 0;
    private static final int CONTROLLER_MODULATION_WHEEL = 1;
    private static final int CONTROLLER_CHANNEL_VOLUME = 7;
    private static final int CONTROLLER_PAN = 10;
    private static final int CONTROLLER_BANK_SELECT_2 = 32;
    private static final int CONTROLLER_MODULATION_WHEEL2 = 33;
    private static final int CONTROLLER_CHANNEL_VOLUME_2 = 39;
    private static final int CONTROLLER_PAN_2 = 42;
    private static final int CONTROLLER_DAMPER_PEDAL = 64;
    private static final int CONTROLLER_PORTAMENTO = 65;
    private static final int CONTROLLER_NON_REGISTERED_PARAMETER_NUMBER_LSB = 98;
    private static final int CONTROLLER_NON_REGISTERED_PARAMETER_NUMBER_MSB = 99;
    private static final int CONTROLLER_REGISTERED_PARAMETER_NUMBER_LSB = 100;
    private static final int CONTROLLER_REGISTERED_PARAMETER_NUMBER_MSB = 101;
    private static final int CONTROLLER_ALL_SOUND_OFF = 120;
    private static final int CONTROLLER_RESET_ALL_CONTROLLERS = 121;
    private static final int CONTROLLER_ALL_NOTES_OFF = 123;
    private static final int JAG_NOTE_ON = 0;
    private static final int JAG_NOTE_OFF = 1;
    private static final int JAG_CONTROL_CHANGE = 2;
    private static final int JAG_PITCH_BEND = 3;
    private static final int JAG_CHANNEL_PRESSURE = 4;
    private static final int JAG_POLY_PRESSURE = 5;
    private static final int JAG_PROGRAM_CHANGE = 6;
    private static final int JAG_END_OF_TRACK = 7;
    private static final int JAG_TEMPO = 23;

    public TrackDefinition load(byte[] b) {
        TrackDefinition def = new TrackDefinition();
        this.load(def, new InputStream(b));
        return def;
    }

    private void load(TrackDefinition def, InputStream var1) {
        int var29;
        int controlChangeIndex;
        int opcode;
        int var13;
        var1.setOffset(var1.getLength() - 3);
        int tracks = var1.readUnsignedByte();
        int division = var1.readUnsignedShort();
        int offset = 14 + tracks * 10;
        var1.setOffset(0);
        int tempoOpcodes = 0;
        int ctrlChangeOpcodes = 0;
        int noteOnOpcodes = 0;
        int noteOffOpcodes = 0;
        int wheelChangeOpcodes = 0;
        int chnnlAfterTchOpcodes = 0;
        int keyAfterTchOpcodes = 0;
        int progmChangeOpcodes = 0;
        block0: for (var13 = 0; var13 < tracks; ++var13) {
            opcode = -1;
            while (true) {
                if ((controlChangeIndex = var1.readUnsignedByte()) != opcode) {
                    ++offset;
                }
                opcode = controlChangeIndex & 0xF;
                if (controlChangeIndex == 7) continue block0;
                if (controlChangeIndex == 23) {
                    ++tempoOpcodes;
                    continue;
                }
                if (opcode == 0) {
                    ++noteOnOpcodes;
                    continue;
                }
                if (opcode == 1) {
                    ++noteOffOpcodes;
                    continue;
                }
                if (opcode == 2) {
                    ++ctrlChangeOpcodes;
                    continue;
                }
                if (opcode == 3) {
                    ++wheelChangeOpcodes;
                    continue;
                }
                if (opcode == 4) {
                    ++chnnlAfterTchOpcodes;
                    continue;
                }
                if (opcode == 5) {
                    ++keyAfterTchOpcodes;
                    continue;
                }
                if (opcode != 6) break;
                ++progmChangeOpcodes;
            }
            throw new RuntimeException();
        }
        offset += 5 * tempoOpcodes;
        offset += 2 * (noteOnOpcodes + noteOffOpcodes + ctrlChangeOpcodes + wheelChangeOpcodes + keyAfterTchOpcodes);
        offset += chnnlAfterTchOpcodes + progmChangeOpcodes;
        var13 = var1.getOffset();
        opcode = tracks + tempoOpcodes + ctrlChangeOpcodes + noteOnOpcodes + noteOffOpcodes + wheelChangeOpcodes + chnnlAfterTchOpcodes + keyAfterTchOpcodes + progmChangeOpcodes;
        for (controlChangeIndex = 0; controlChangeIndex < opcode; ++controlChangeIndex) {
            var1.readVarInt();
        }
        offset += var1.getOffset() - var13;
        controlChangeIndex = var1.getOffset();
        int modulationWheelSize = 0;
        int modulationWheel2Size = 0;
        int channelVolumeSize = 0;
        int channelVolume2Size = 0;
        int panSize = 0;
        int pan2Size = 0;
        int nonRegisteredMsbSize = 0;
        int nonRegisteredLsbSize = 0;
        int registeredNumberMsb = 0;
        int registeredLsbSize = 0;
        int commandsSize = 0;
        int otherSize = 0;
        int controllerNumber = 0;
        for (var29 = 0; var29 < ctrlChangeOpcodes; ++var29) {
            if ((controllerNumber = controllerNumber + var1.readUnsignedByte() & 0x7F) == 0 || controllerNumber == 32) {
                ++progmChangeOpcodes;
                continue;
            }
            if (controllerNumber == 1) {
                ++modulationWheelSize;
                continue;
            }
            if (controllerNumber == 33) {
                ++modulationWheel2Size;
                continue;
            }
            if (controllerNumber == 7) {
                ++channelVolumeSize;
                continue;
            }
            if (controllerNumber == 39) {
                ++channelVolume2Size;
                continue;
            }
            if (controllerNumber == 10) {
                ++panSize;
                continue;
            }
            if (controllerNumber == 42) {
                ++pan2Size;
                continue;
            }
            if (controllerNumber == 99) {
                ++nonRegisteredMsbSize;
                continue;
            }
            if (controllerNumber == 98) {
                ++nonRegisteredLsbSize;
                continue;
            }
            if (controllerNumber == 101) {
                ++registeredNumberMsb;
                continue;
            }
            if (controllerNumber == 100) {
                ++registeredLsbSize;
                continue;
            }
            if (controllerNumber != 64 && controllerNumber != 65 && controllerNumber != 120 && controllerNumber != 121 && controllerNumber != 123) {
                ++otherSize;
                continue;
            }
            ++commandsSize;
        }
        var29 = 0;
        int commandsIndex = var1.getOffset();
        var1.skip(commandsSize);
        int polyPressureIndex = var1.getOffset();
        var1.skip(keyAfterTchOpcodes);
        int channelPressureIndex = var1.getOffset();
        var1.skip(chnnlAfterTchOpcodes);
        int pitchWheelHighIndex = var1.getOffset();
        var1.skip(wheelChangeOpcodes);
        int modulationWheelOffset = var1.getOffset();
        var1.skip(modulationWheelSize);
        int channelVolumeOffset = var1.getOffset();
        var1.skip(channelVolumeSize);
        int panOffset = var1.getOffset();
        var1.skip(panSize);
        int notesIndex = var1.getOffset();
        var1.skip(noteOnOpcodes + noteOffOpcodes + keyAfterTchOpcodes);
        int notesOnIndex = var1.getOffset();
        var1.skip(noteOnOpcodes);
        int otherIndex = var1.getOffset();
        var1.skip(otherSize);
        int notesOffIndex = var1.getOffset();
        var1.skip(noteOffOpcodes);
        int modulationWheel2Offset = var1.getOffset();
        var1.skip(modulationWheel2Size);
        int channelVolume2Offset = var1.getOffset();
        var1.skip(channelVolume2Size);
        int pan2Offset = var1.getOffset();
        var1.skip(pan2Size);
        int programChangeIndex = var1.getOffset();
        var1.skip(progmChangeOpcodes);
        int pitchWheelLowIndex = var1.getOffset();
        var1.skip(wheelChangeOpcodes);
        int nonRegisteredMsbIndex = var1.getOffset();
        var1.skip(nonRegisteredMsbSize);
        int nonRegisteredLsbIndex = var1.getOffset();
        var1.skip(nonRegisteredLsbSize);
        int registeredMsbIndex = var1.getOffset();
        var1.skip(registeredNumberMsb);
        int registeredLsbIndex = var1.getOffset();
        var1.skip(registeredLsbSize);
        int tempoOffset = var1.getOffset();
        var1.skip(tempoOpcodes * 3);
        OutputStream var51 = new OutputStream(offset);
        var51.writeInt(1297377380);
        var51.writeInt(6);
        var51.writeShort(tracks > 1 ? 1 : 0);
        var51.writeShort(tracks);
        var51.writeShort(division);
        var1.setOffset(var13);
        int channel = 0;
        int var53 = 0;
        int var54 = 0;
        int var55 = 0;
        int var56 = 0;
        int var57 = 0;
        int var58 = 0;
        int[] var59 = new int[128];
        controllerNumber = 0;
        for (int var60 = 0; var60 < tracks; ++var60) {
            int var61;
            block40: {
                var51.writeInt(1297379947);
                var51.skip(4);
                var61 = var51.getOffset();
                int var62 = -1;
                while (true) {
                    int deltaTick = var1.readVarInt();
                    var51.writeVarInt(deltaTick);
                    int status = var1.getArray()[var29++] & 0xFF;
                    boolean var65 = status != var62;
                    var62 = status & 0xF;
                    if (status == 7) break block40;
                    if (status == 23) {
                        var51.writeByte(255);
                        var51.writeByte(81);
                        var51.writeByte(3);
                        var51.writeByte(var1.getArray()[tempoOffset++]);
                        var51.writeByte(var1.getArray()[tempoOffset++]);
                        var51.writeByte(var1.getArray()[tempoOffset++]);
                        continue;
                    }
                    channel ^= status >> 4;
                    if (var62 == 0) {
                        if (var65) {
                            var51.writeByte(144 + channel);
                        }
                        int n = notesIndex++;
                        int n2 = notesOnIndex++;
                        var51.writeByte((var53 += var1.getArray()[n]) & 0x7F);
                        var51.writeByte((var54 += var1.getArray()[n2]) & 0x7F);
                        continue;
                    }
                    if (var62 == 1) {
                        if (var65) {
                            var51.writeByte(128 + channel);
                        }
                        int n = notesIndex++;
                        int n3 = notesOffIndex++;
                        var51.writeByte((var53 += var1.getArray()[n]) & 0x7F);
                        var51.writeByte((var55 += var1.getArray()[n3]) & 0x7F);
                        continue;
                    }
                    if (var62 == 2) {
                        int var67;
                        if (var65) {
                            var51.writeByte(176 + channel);
                        }
                        controllerNumber = controllerNumber + var1.getArray()[controlChangeIndex++] & 0x7F;
                        var51.writeByte(controllerNumber);
                        byte var66 = controllerNumber == 0 || controllerNumber == 32 ? var1.getArray()[programChangeIndex++] : (controllerNumber == 1 ? var1.getArray()[modulationWheelOffset++] : (controllerNumber == 33 ? var1.getArray()[modulationWheel2Offset++] : (controllerNumber == 7 ? var1.getArray()[channelVolumeOffset++] : (controllerNumber == 39 ? var1.getArray()[channelVolume2Offset++] : (controllerNumber == 10 ? var1.getArray()[panOffset++] : (controllerNumber == 42 ? var1.getArray()[pan2Offset++] : (controllerNumber == 99 ? var1.getArray()[nonRegisteredMsbIndex++] : (controllerNumber == 98 ? var1.getArray()[nonRegisteredLsbIndex++] : (controllerNumber == 101 ? var1.getArray()[registeredMsbIndex++] : (controllerNumber == 100 ? var1.getArray()[registeredLsbIndex++] : (controllerNumber != 64 && controllerNumber != 65 && controllerNumber != 120 && controllerNumber != 121 && controllerNumber != 123 ? var1.getArray()[otherIndex++] : var1.getArray()[commandsIndex++])))))))))));
                        var59[controllerNumber] = var67 = var66 + var59[controllerNumber];
                        var51.writeByte(var67 & 0x7F);
                        continue;
                    }
                    if (var62 == 3) {
                        if (var65) {
                            var51.writeByte(224 + channel);
                        }
                        var56 += var1.getArray()[pitchWheelLowIndex++];
                        var51.writeByte((var56 += var1.getArray()[pitchWheelHighIndex++] << 7) & 0x7F);
                        var51.writeByte(var56 >> 7 & 0x7F);
                        continue;
                    }
                    if (var62 == 4) {
                        if (var65) {
                            var51.writeByte(208 + channel);
                        }
                        var51.writeByte((var57 += var1.getArray()[channelPressureIndex++]) & 0x7F);
                        continue;
                    }
                    if (var62 == 5) {
                        if (var65) {
                            var51.writeByte(160 + channel);
                        }
                        int n = notesIndex++;
                        int n4 = polyPressureIndex++;
                        var51.writeByte((var53 += var1.getArray()[n]) & 0x7F);
                        var51.writeByte((var58 += var1.getArray()[n4]) & 0x7F);
                        continue;
                    }
                    if (var62 != 6) break;
                    if (var65) {
                        var51.writeByte(192 + channel);
                    }
                    var51.writeByte(var1.getArray()[programChangeIndex++]);
                }
                throw new RuntimeException();
            }
            var51.writeByte(255);
            var51.writeByte(47);
            var51.writeByte(0);
            var51.writeLengthFromMark(var51.getOffset() - var61);
        }
        def.midi = var51.flip();
    }
}

