/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.cache.script.assembler;

import java.util.HashMap;
import java.util.Map;
import net.runelite.cache.script.assembler.rs2asmBaseListener;
import net.runelite.cache.script.assembler.rs2asmParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LabelVisitor
extends rs2asmBaseListener {
    private static final Logger logger = LoggerFactory.getLogger(LabelVisitor.class);
    private int pos;
    private final Map<String, Integer> map = new HashMap<String, Integer>();

    LabelVisitor() {
    }

    @Override
    public void exitInstruction(rs2asmParser.InstructionContext ctx) {
        ++this.pos;
    }

    @Override
    public void enterLabel(rs2asmParser.LabelContext ctx) {
        String text = ctx.getText();
        text = text.substring(0, text.length() - 1);
        logger.debug("Label {} is on instruction {}", (Object)text, (Object)this.pos);
        this.map.put(text, this.pos);
    }

    public Integer getInstructionForLabel(String label) {
        return this.map.get(label);
    }
}

