/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.cache.definitions.loaders;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.runelite.cache.definitions.DBTableIndex;
import net.runelite.cache.io.InputStream;
import net.runelite.cache.util.BaseVarType;

public class DBTableIndexLoader {
    public DBTableIndex load(int tableId, int columnId, byte[] b) {
        DBTableIndex index = new DBTableIndex(tableId, columnId);
        InputStream is = new InputStream(b);
        this.decode(index, is);
        return index;
    }

    private void decode(DBTableIndex index, InputStream stream) {
        int tupleSize = stream.readVarInt2();
        BaseVarType[] tupleTypes = new BaseVarType[tupleSize];
        ArrayList<Map<Object, List<Integer>>> tupleIndexes = new ArrayList<Map<Object, List<Integer>>>(tupleSize);
        for (int i = 0; i < tupleSize; ++i) {
            tupleTypes[i] = BaseVarType.forId(stream.readUnsignedByte());
            int valueCount = stream.readVarInt2();
            HashMap valueToRows = new HashMap(valueCount);
            while (valueCount-- > 0) {
                Object value = DBTableIndexLoader.decodeValue(tupleTypes[i], stream);
                int rowCount = stream.readVarInt2();
                ArrayList<Integer> rowIds = new ArrayList<Integer>(rowCount);
                while (rowCount-- > 0) {
                    rowIds.add(stream.readVarInt2());
                }
                valueToRows.put(value, rowIds);
            }
            tupleIndexes.add(i, valueToRows);
        }
        index.setTupleTypes(tupleTypes);
        index.setTupleIndexes(tupleIndexes);
    }

    private static Object decodeValue(BaseVarType baseType, InputStream stream) {
        switch (baseType) {
            case INTEGER: {
                return stream.readInt();
            }
            case LONG: {
                return stream.readLong();
            }
            case STRING: {
                return stream.readString();
            }
        }
        return null;
    }
}

