/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.cache.region;

import java.util.ArrayList;
import java.util.List;
import net.runelite.cache.definitions.LocationsDefinition;
import net.runelite.cache.definitions.MapDefinition;
import net.runelite.cache.region.HeightCalc;
import net.runelite.cache.region.Location;
import net.runelite.cache.region.Position;

public class Region {
    public static final int X = 64;
    public static final int Y = 64;
    public static final int Z = 4;
    private final int regionID;
    private final int baseX;
    private final int baseY;
    private final int[][][] tileHeights = new int[4][64][64];
    private final byte[][][] tileSettings = new byte[4][64][64];
    private final short[][][] overlayIds = new short[4][64][64];
    private final byte[][][] overlayPaths = new byte[4][64][64];
    private final byte[][][] overlayRotations = new byte[4][64][64];
    private final short[][][] underlayIds = new short[4][64][64];
    private final List<Location> locations = new ArrayList<Location>();

    public Region(int id) {
        this.regionID = id;
        this.baseX = (id >> 8 & 0xFF) << 6;
        this.baseY = (id & 0xFF) << 6;
    }

    public Region(int x, int y) {
        this.regionID = x << 8 | y;
        this.baseX = x << 6;
        this.baseY = y << 6;
    }

    public void loadTerrain(MapDefinition map) {
        MapDefinition.Tile[][][] tiles = map.getTiles();
        for (int z = 0; z < 4; ++z) {
            for (int x = 0; x < 64; ++x) {
                for (int y = 0; y < 64; ++y) {
                    MapDefinition.Tile tile = tiles[z][x][y];
                    if (tile.height == null) {
                        if (z == 0) {
                            this.tileHeights[0][x][y] = -HeightCalc.calculate(this.baseX + x + 932731, this.baseY + y + 556238) * 8;
                        } else {
                            this.tileHeights[z][x][y] = this.tileHeights[z - 1][x][y] - 240;
                        }
                    } else {
                        int height = tile.getHeight();
                        if (height == 1) {
                            height = 0;
                        }
                        if (z == 0) {
                            this.tileHeights[0][x][y] = -height * 8;
                        } else {
                            this.tileHeights[z][x][y] = this.tileHeights[z - 1][x][y] - height * 8;
                        }
                    }
                    this.overlayIds[z][x][y] = tile.getOverlayId();
                    this.overlayPaths[z][x][y] = tile.getOverlayPath();
                    this.overlayRotations[z][x][y] = tile.getOverlayRotation();
                    this.tileSettings[z][x][y] = tile.getSettings();
                    this.underlayIds[z][x][y] = tile.getUnderlayId();
                }
            }
        }
    }

    public void loadLocations(LocationsDefinition locs) {
        for (Location loc : locs.getLocations()) {
            Location newLoc = new Location(loc.getId(), loc.getType(), loc.getOrientation(), new Position(this.getBaseX() + loc.getPosition().getX(), this.getBaseY() + loc.getPosition().getY(), loc.getPosition().getZ()));
            this.locations.add(newLoc);
        }
    }

    public int getRegionID() {
        return this.regionID;
    }

    public int getBaseX() {
        return this.baseX;
    }

    public int getBaseY() {
        return this.baseY;
    }

    public int getTileHeight(int z, int x, int y) {
        return this.tileHeights[z][x][y];
    }

    public byte getTileSetting(int z, int x, int y) {
        return this.tileSettings[z][x][y];
    }

    public int getOverlayId(int z, int x, int y) {
        return this.overlayIds[z][x][y] & Short.MAX_VALUE;
    }

    public byte getOverlayPath(int z, int x, int y) {
        return this.overlayPaths[z][x][y];
    }

    public byte getOverlayRotation(int z, int x, int y) {
        return this.overlayRotations[z][x][y];
    }

    public int getUnderlayId(int z, int x, int y) {
        return this.underlayIds[z][x][y] & Short.MAX_VALUE;
    }

    public List<Location> getLocations() {
        return this.locations;
    }

    public int getRegionX() {
        return this.baseX >> 6;
    }

    public int getRegionY() {
        return this.baseY >> 6;
    }
}

