/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.cache.item;

import java.awt.image.BufferedImage;
import net.runelite.cache.item.Rasterizer2D;

class SpritePixels {
    public int[] pixels;
    public int width;
    public int height;
    public int offsetX;
    int offsetY;

    public SpritePixels(int[] var1, int var2, int var3) {
        this.pixels = var1;
        this.width = var2;
        this.height = var3;
        this.offsetY = 0;
        this.offsetX = 0;
    }

    public SpritePixels(int var1, int var2) {
        this(new int[var2 * var1], var1, var2);
    }

    public void drawBorder(int color) {
        int[] newPixels = new int[this.width * this.height];
        int pixelIndex = 0;
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < this.width; ++x) {
                int pixel = this.pixels[pixelIndex];
                if (pixel == 0) {
                    if (x > 0 && this.pixels[pixelIndex - 1] != 0) {
                        pixel = color;
                    } else if (y > 0 && this.pixels[pixelIndex - this.width] != 0) {
                        pixel = color;
                    } else if (x < this.width - 1 && this.pixels[pixelIndex + 1] != 0) {
                        pixel = color;
                    } else if (y < this.height - 1 && this.pixels[pixelIndex + this.width] != 0) {
                        pixel = color;
                    }
                }
                newPixels[pixelIndex++] = pixel;
            }
        }
        this.pixels = newPixels;
    }

    public void drawShadow(int color) {
        for (int y = this.height - 1; y > 0; --y) {
            int rowOffset = y * this.width;
            for (int x = this.width - 1; x > 0; --x) {
                if (this.pixels[x + rowOffset] != 0 || this.pixels[x + rowOffset - 1 - this.width] == 0) continue;
                this.pixels[x + rowOffset] = color;
            }
        }
    }

    public void drawAtOn(Rasterizer2D graphics, int x, int y) {
        int deltaX;
        int pixelIndex = (x += this.offsetX) + (y += this.offsetY) * graphics.graphicsPixelsWidth;
        int deltaIndex = 0;
        int height = this.height;
        int width = this.width;
        int var7 = graphics.graphicsPixelsWidth - width;
        int var8 = 0;
        if (y < graphics.drawingAreaTop) {
            int deltaY = graphics.drawingAreaTop - y;
            height -= deltaY;
            y = graphics.drawingAreaTop;
            deltaIndex += deltaY * width;
            pixelIndex += deltaY * graphics.graphicsPixelsWidth;
        }
        if (height + y > graphics.drawingAreaBottom) {
            height -= height + y - graphics.drawingAreaBottom;
        }
        if (x < graphics.draw_region_x) {
            deltaX = graphics.draw_region_x - x;
            width -= deltaX;
            x = graphics.draw_region_x;
            deltaIndex += deltaX;
            pixelIndex += deltaX;
            var8 += deltaX;
            var7 += deltaX;
        }
        if (width + x > graphics.drawingAreaRight) {
            deltaX = width + x - graphics.drawingAreaRight;
            width -= deltaX;
            var8 += deltaX;
            var7 += deltaX;
        }
        if (width > 0 && height > 0) {
            SpritePixels.method5843(graphics.graphicsPixels, this.pixels, 0, deltaIndex, pixelIndex, width, height, var7, var8);
        }
    }

    static void method5843(int[] rasterizerPixels, int[] spritePixels, int var2, int var3, int pixelIndex, int width, int height, int var7, int var8) {
        int var9 = -(width >> 2);
        width = -(width & 3);
        for (int var10 = -height; var10 < 0; ++var10) {
            int i;
            for (i = var9 * 4; i < 0; ++i) {
                if ((var2 = spritePixels[var3++]) != 0) {
                    rasterizerPixels[pixelIndex++] = var2;
                    continue;
                }
                ++pixelIndex;
            }
            for (i = width; i < 0; ++i) {
                if ((var2 = spritePixels[var3++]) != 0) {
                    rasterizerPixels[pixelIndex++] = var2;
                    continue;
                }
                ++pixelIndex;
            }
            pixelIndex += var7;
            var3 += var8;
        }
    }

    public BufferedImage toBufferedImage() {
        int[] transPixels = new int[this.pixels.length];
        BufferedImage img = new BufferedImage(this.width, this.height, 2);
        for (int i = 0; i < this.pixels.length; ++i) {
            if (this.pixels[i] == 0) continue;
            transPixels[i] = this.pixels[i] | 0xFF000000;
        }
        img.setRGB(0, 0, this.width, this.height, transPixels, 0, this.width);
        return img;
    }
}

