/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.cache.definitions.loaders;

import net.runelite.cache.definitions.AreaDefinition;
import net.runelite.cache.io.InputStream;

public class AreaLoader {
    public AreaDefinition load(byte[] b, int id) {
        int opcode;
        InputStream in = new InputStream(b);
        AreaDefinition def = new AreaDefinition();
        def.id = id;
        while ((opcode = in.readUnsignedByte()) != 0) {
            this.processOpcode(def, in, opcode);
        }
        return def;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processOpcode(AreaDefinition def, InputStream in, int opcode) {
        if (opcode == 1) {
            def.spriteId = in.readBigSmart2();
            return;
        } else if (opcode == 2) {
            def.field3294 = in.readBigSmart2();
            return;
        } else if (opcode == 3) {
            def.name = in.readString();
            return;
        } else if (opcode == 4) {
            def.textColor = in.read24BitInt();
            return;
        } else if (opcode == 5) {
            in.read24BitInt();
            return;
        } else if (opcode == 6) {
            def.textScale = in.readUnsignedByte();
            return;
        } else {
            if (opcode == 7) {
                int var3 = in.readUnsignedByte();
                if ((var3 & 1) == 0) {
                    // empty if block
                }
                if ((var3 & 2) != 2) return;
            }
            if (opcode == 8) {
                in.readUnsignedByte();
                return;
            } else if (opcode >= 10 && opcode <= 14) {
                def.field3298[opcode - 10] = in.readString();
                return;
            } else if (opcode == 15) {
                int var5;
                int var4;
                int var3 = in.readUnsignedByte();
                def.field3300 = new int[var3 * 2];
                for (var4 = 0; var4 < var3 * 2; ++var4) {
                    def.field3300[var4] = in.readShort();
                }
                in.readInt();
                var4 = in.readUnsignedByte();
                def.field3292 = new int[var4];
                for (var5 = 0; var5 < def.field3292.length; ++var5) {
                    def.field3292[var5] = in.readInt();
                }
                def.field3309 = new byte[var3];
                for (var5 = 0; var5 < var3; ++var5) {
                    def.field3309[var5] = in.readByte();
                }
                return;
            } else {
                if (opcode == 16) return;
                if (opcode == 17) {
                    def.field3308 = in.readString();
                    return;
                } else if (opcode == 18) {
                    in.readBigSmart2();
                    return;
                } else if (opcode == 19) {
                    def.category = in.readUnsignedShort();
                    return;
                } else if (opcode == 21) {
                    in.readInt();
                    return;
                } else if (opcode == 22) {
                    in.readInt();
                    return;
                } else if (opcode == 23) {
                    in.readUnsignedByte();
                    in.readUnsignedByte();
                    in.readUnsignedByte();
                    return;
                } else if (opcode == 24) {
                    in.readShort();
                    in.readShort();
                    return;
                } else if (opcode == 25) {
                    in.readBigSmart2();
                    return;
                } else if (opcode == 28) {
                    in.readUnsignedByte();
                    return;
                } else if (opcode == 29) {
                    in.skip(1);
                    return;
                } else {
                    if (opcode != 30) return;
                    in.skip(1);
                }
            }
        }
    }
}

