/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.cache.definitions;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.runelite.cache.definitions.MapSquareDefinition;
import net.runelite.cache.definitions.WorldMapElementDefinition;
import net.runelite.cache.definitions.ZoneDefinition;
import net.runelite.cache.region.Position;

public class WorldMapCompositeDefinition {
    public final Set<MapSquareDefinition> mapSquareDefinitions = new HashSet<MapSquareDefinition>();
    public final Set<ZoneDefinition> zoneDefinitions = new HashSet<ZoneDefinition>();
    public final List<WorldMapElementDefinition> worldMapElementDefinitions = new ArrayList<WorldMapElementDefinition>();

    public Position calculateWorldOffset(Position position) {
        int shiftZ;
        int shiftX;
        int squareX = position.getX() / 64;
        int squareZ = position.getY() / 64;
        int zoneX = (position.getX() & 0x3F) / 8;
        int zoneZ = (position.getY() & 0x3F) / 8;
        Position offset = null;
        for (MapSquareDefinition mapSquare : this.mapSquareDefinitions) {
            if (squareX != mapSquare.displaySquareX || squareZ != mapSquare.displaySquareZ) continue;
            shiftX = (mapSquare.sourceSquareX - mapSquare.displaySquareX) * 64;
            shiftZ = (mapSquare.sourceSquareZ - mapSquare.displaySquareZ) * 64;
            offset = new Position(shiftX, shiftZ, mapSquare.getMinLevel());
        }
        for (ZoneDefinition zone : this.zoneDefinitions) {
            if (squareX != zone.displaySquareX || squareZ != zone.displaySquareZ || zoneX != zone.displayZoneX || zoneZ != zone.displayZoneZ) continue;
            shiftX = (zone.sourceSquareX - zone.displaySquareX) * 64 + (zone.sourceZoneX - zone.displayZoneX) * 8;
            shiftZ = (zone.sourceSquareZ - zone.displaySquareZ) * 64 + (zone.sourceZoneZ - zone.displayZoneZ) * 8;
            offset = new Position(shiftX, shiftZ, zone.getMinLevel());
        }
        return offset;
    }

    public Set<MapSquareDefinition> getMapSquareDefinitions() {
        return this.mapSquareDefinitions;
    }

    public Set<ZoneDefinition> getZoneDefinitions() {
        return this.zoneDefinitions;
    }

    public List<WorldMapElementDefinition> getWorldMapElementDefinitions() {
        return this.worldMapElementDefinitions;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WorldMapCompositeDefinition)) {
            return false;
        }
        WorldMapCompositeDefinition other = (WorldMapCompositeDefinition)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Set<MapSquareDefinition> this$mapSquareDefinitions = this.getMapSquareDefinitions();
        Set<MapSquareDefinition> other$mapSquareDefinitions = other.getMapSquareDefinitions();
        if (this$mapSquareDefinitions == null ? other$mapSquareDefinitions != null : !((Object)this$mapSquareDefinitions).equals(other$mapSquareDefinitions)) {
            return false;
        }
        Set<ZoneDefinition> this$zoneDefinitions = this.getZoneDefinitions();
        Set<ZoneDefinition> other$zoneDefinitions = other.getZoneDefinitions();
        if (this$zoneDefinitions == null ? other$zoneDefinitions != null : !((Object)this$zoneDefinitions).equals(other$zoneDefinitions)) {
            return false;
        }
        List<WorldMapElementDefinition> this$worldMapElementDefinitions = this.getWorldMapElementDefinitions();
        List<WorldMapElementDefinition> other$worldMapElementDefinitions = other.getWorldMapElementDefinitions();
        return !(this$worldMapElementDefinitions == null ? other$worldMapElementDefinitions != null : !((Object)this$worldMapElementDefinitions).equals(other$worldMapElementDefinitions));
    }

    protected boolean canEqual(Object other) {
        return other instanceof WorldMapCompositeDefinition;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Set<MapSquareDefinition> $mapSquareDefinitions = this.getMapSquareDefinitions();
        result = result * 59 + ($mapSquareDefinitions == null ? 43 : ((Object)$mapSquareDefinitions).hashCode());
        Set<ZoneDefinition> $zoneDefinitions = this.getZoneDefinitions();
        result = result * 59 + ($zoneDefinitions == null ? 43 : ((Object)$zoneDefinitions).hashCode());
        List<WorldMapElementDefinition> $worldMapElementDefinitions = this.getWorldMapElementDefinitions();
        result = result * 59 + ($worldMapElementDefinitions == null ? 43 : ((Object)$worldMapElementDefinitions).hashCode());
        return result;
    }

    public String toString() {
        return "WorldMapCompositeDefinition(mapSquareDefinitions=" + String.valueOf(this.getMapSquareDefinitions()) + ", zoneDefinitions=" + String.valueOf(this.getZoneDefinitions()) + ", worldMapElementDefinitions=" + String.valueOf(this.getWorldMapElementDefinitions()) + ")";
    }
}

