/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.cache.script.disassembler;

import com.google.common.escape.Escaper;
import com.google.common.escape.Escapers;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.runelite.cache.definitions.ScriptDefinition;
import net.runelite.cache.script.Instruction;
import net.runelite.cache.script.Instructions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Disassembler {
    private static final Logger logger = LoggerFactory.getLogger(Disassembler.class);
    private static final Escaper ESCAPER = Escapers.builder().addEscape('\"', "\\\"").addEscape('\\', "\\\\").build();
    private final Instructions instructions = new Instructions();
    private final Map<Object, String> symbols;

    public Disassembler() {
        this.instructions.init();
        this.symbols = Collections.emptyMap();
    }

    public Disassembler(Map<String, Object> symbols) {
        this.instructions.init();
        this.symbols = new HashMap<Object, String>();
        for (Map.Entry<String, Object> e : symbols.entrySet()) {
            this.symbols.put(e.getValue(), e.getKey());
        }
    }

    private boolean isJump(int opcode) {
        switch (opcode) {
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 31: 
            case 32: {
                return true;
            }
        }
        return false;
    }

    private boolean[] needLabel(ScriptDefinition script) {
        int[] instructions = script.getInstructions();
        int[] iops = script.getIntOperands();
        Map<Integer, Integer>[] switches = script.getSwitches();
        boolean[] jumped = new boolean[instructions.length];
        for (int i = 0; i < instructions.length; ++i) {
            int opcode = instructions[i];
            int iop = iops[i];
            if (opcode == 60) {
                Map<Integer, Integer> switchMap = switches[iop];
                for (Map.Entry<Integer, Integer> entry : switchMap.entrySet()) {
                    int offset = entry.getValue();
                    int to = i + offset + 1;
                    assert (to >= 0 && to < instructions.length);
                    jumped[to] = true;
                }
            }
            if (!this.isJump(opcode)) continue;
            int to = i + iop + 1;
            assert (to >= 0 && to < instructions.length);
            jumped[to] = true;
        }
        return jumped;
    }

    public String disassemble(ScriptDefinition script) throws IOException {
        int[] instructions = script.getInstructions();
        int[] iops = script.getIntOperands();
        String[] sops = script.getStringOperands();
        Map<Integer, Integer>[] switches = script.getSwitches();
        assert (iops.length == instructions.length);
        assert (sops.length == instructions.length);
        boolean[] jumps = this.needLabel(script);
        StringBuilder writer = new StringBuilder();
        this.writerHeader(writer, script);
        for (int i = 0; i < instructions.length; ++i) {
            int opcode = instructions[i];
            int iop = iops[i];
            String sop = sops[i];
            Instruction ins = this.instructions.find(opcode);
            if (ins == null) {
                logger.debug("Unknown instruction {} in script {}", (Object)opcode, (Object)script.getId());
            }
            if (jumps[i]) {
                writer.append("LABEL").append(i).append(":\n");
            }
            String name = ins != null && ins.getName() != null ? ins.getName() : String.format("%03d", opcode);
            writer.append(String.format("   %-22s", name));
            if (this.shouldWriteIntOperand(opcode, iop)) {
                if (this.isJump(opcode)) {
                    writer.append(" LABEL").append(i + iop + 1);
                } else if (this.symbols.containsKey(iop)) {
                    writer.append(" :").append(this.symbols.get(iop));
                } else {
                    writer.append(" ").append(iop);
                }
            }
            if (sop != null) {
                writer.append(" \"").append(ESCAPER.escape(sop)).append("\"");
            }
            if (opcode == 60) {
                Map<Integer, Integer> switchMap = switches[iop];
                for (Map.Entry<Integer, Integer> entry : switchMap.entrySet()) {
                    int value = entry.getKey();
                    int jump = entry.getValue();
                    writer.append("\n");
                    writer.append("      ").append(value).append(": LABEL").append(i + jump + 1);
                }
            }
            writer.append("\n");
        }
        return writer.toString();
    }

    private boolean shouldWriteIntOperand(int opcode, int operand) {
        if (opcode == 60) {
            return false;
        }
        if (operand != 0) {
            return true;
        }
        switch (opcode) {
            case 0: 
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                return true;
            }
        }
        return false;
    }

    private void writerHeader(StringBuilder writer, ScriptDefinition script) {
        int id = script.getId();
        int intStackCount = script.getIntArgCount();
        int stringStackCount = script.getObjArgCount();
        writer.append(".id                       ").append(id).append('\n');
        writer.append(".int_arg_count            ").append(intStackCount).append('\n');
        writer.append(".obj_arg_count            ").append(stringStackCount).append('\n');
    }
}

