/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.cache;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import net.runelite.cache.AreaManager;
import net.runelite.cache.ConfigType;
import net.runelite.cache.FontManager;
import net.runelite.cache.FontName;
import net.runelite.cache.IndexType;
import net.runelite.cache.ObjectManager;
import net.runelite.cache.SpriteManager;
import net.runelite.cache.TextureManager;
import net.runelite.cache.WorldMapManager;
import net.runelite.cache.definitions.AreaDefinition;
import net.runelite.cache.definitions.FontDefinition;
import net.runelite.cache.definitions.ObjectDefinition;
import net.runelite.cache.definitions.OverlayDefinition;
import net.runelite.cache.definitions.SpriteDefinition;
import net.runelite.cache.definitions.UnderlayDefinition;
import net.runelite.cache.definitions.WorldMapElementDefinition;
import net.runelite.cache.definitions.loaders.OverlayLoader;
import net.runelite.cache.definitions.loaders.SpriteLoader;
import net.runelite.cache.definitions.loaders.UnderlayLoader;
import net.runelite.cache.fs.Archive;
import net.runelite.cache.fs.ArchiveFiles;
import net.runelite.cache.fs.FSFile;
import net.runelite.cache.fs.Index;
import net.runelite.cache.fs.Storage;
import net.runelite.cache.fs.Store;
import net.runelite.cache.item.RSTextureProvider;
import net.runelite.cache.models.JagexColor;
import net.runelite.cache.region.Location;
import net.runelite.cache.region.Position;
import net.runelite.cache.region.Region;
import net.runelite.cache.region.RegionLoader;
import net.runelite.cache.util.BigBufferedImage;
import net.runelite.cache.util.KeyProvider;
import net.runelite.cache.util.XteaKeyManager;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapImageDumper {
    private static final Logger log = LoggerFactory.getLogger(MapImageDumper.class);
    private static final int MAP_SCALE = 4;
    private static final int BLEND = 5;
    private static byte[][][] TILE_SHAPE_2D;
    private final int wallColor = (238 + (int)(this.random() * 20.0) - 10 << 16) + (238 + (int)(this.random() * 20.0) - 10 << 8) + (238 + (int)(this.random() * 20.0) - 10);
    private final int doorColor = 238 + (int)(this.random() * 20.0) - 10 << 16;
    private final Store store;
    private final Map<Integer, UnderlayDefinition> underlays = new HashMap<Integer, UnderlayDefinition>();
    private final Map<Integer, OverlayDefinition> overlays = new HashMap<Integer, OverlayDefinition>();
    private SpriteDefinition[] mapDecorations;
    private final RegionLoader regionLoader;
    private final AreaManager areas;
    private final SpriteManager sprites;
    private final FontManager fonts;
    private final WorldMapManager worldMapManager;
    private RSTextureProvider rsTextureProvider;
    private final ObjectManager objectManager;
    private boolean labelRegions;
    private boolean outlineRegions;
    private boolean renderMap = true;
    private boolean renderObjects = true;
    private boolean renderIcons = true;
    private boolean renderWalls = true;
    private boolean renderOverlays = true;
    private boolean renderLabels = true;
    private boolean transparency = false;
    private boolean lowMemory = true;

    public MapImageDumper(Store store, KeyProvider keyProvider) {
        this(store, new RegionLoader(store, keyProvider));
    }

    public MapImageDumper(Store store, RegionLoader regionLoader) {
        this.store = store;
        this.regionLoader = regionLoader;
        this.areas = new AreaManager(store);
        this.sprites = new SpriteManager(store);
        this.fonts = new FontManager(store);
        this.worldMapManager = new WorldMapManager(store);
        this.objectManager = new ObjectManager(store);
    }

    public static void main(String[] args) throws IOException {
        CommandLine cmd;
        Options options = new Options();
        options.addOption(Option.builder().longOpt("cachedir").hasArg().required().build());
        options.addOption(Option.builder().longOpt("xteapath").hasArg().required().build());
        options.addOption(Option.builder().longOpt("outputdir").hasArg().required().build());
        DefaultParser parser = new DefaultParser();
        try {
            cmd = parser.parse(options, args);
        }
        catch (ParseException ex) {
            System.err.println("Error parsing command line options: " + ex.getMessage());
            System.exit(-1);
            return;
        }
        String cacheDirectory = cmd.getOptionValue("cachedir");
        String xteaJSONPath = cmd.getOptionValue("xteapath");
        String outputDirectory = cmd.getOptionValue("outputdir");
        XteaKeyManager xteaKeyManager = new XteaKeyManager();
        try (FileInputStream fin = new FileInputStream(xteaJSONPath);){
            xteaKeyManager.loadKeys(fin);
        }
        File base = new File(cacheDirectory);
        File outDir = new File(outputDirectory);
        outDir.mkdirs();
        try (Store store = new Store(base);){
            store.load();
            MapImageDumper dumper = new MapImageDumper(store, xteaKeyManager);
            dumper.load();
            for (int i = 0; i < 4; ++i) {
                BufferedImage image = dumper.drawMap(i);
                File imageFile = new File(outDir, "img-" + i + ".png");
                ImageIO.write((RenderedImage)image, "png", imageFile);
                log.info("Wrote image {}", (Object)imageFile);
            }
        }
    }

    protected double random() {
        return -1.2;
    }

    public MapImageDumper load() throws IOException {
        this.loadUnderlays(this.store);
        this.loadOverlays(this.store);
        this.objectManager.load();
        TextureManager textureManager = new TextureManager(this.store);
        textureManager.load();
        this.rsTextureProvider = new RSTextureProvider(textureManager, this.sprites);
        this.loadRegions();
        this.areas.load();
        this.sprites.load();
        this.loadSprites();
        this.fonts.load();
        this.worldMapManager.load();
        return this;
    }

    public BufferedImage drawMap(int z) {
        int minX = this.regionLoader.getLowestX().getBaseX();
        int minY = this.regionLoader.getLowestY().getBaseY();
        int maxX = this.regionLoader.getHighestX().getBaseX() + 64;
        int maxY = this.regionLoader.getHighestY().getBaseY() + 64;
        int dimX = maxX - minX;
        int dimY = maxY - minY;
        int pixelsX = dimX * 4;
        int pixelsY = dimY * 4;
        log.info("Map image dimensions: {}px x {}px, {}px per map square ({} MB). Max memory: {}mb", new Object[]{pixelsX, pixelsY, 4, pixelsX * pixelsY * 3 / 1024 / 1024, Runtime.getRuntime().maxMemory() / 1024L / 1024L});
        BufferedImage image = this.lowMemory ? BigBufferedImage.create(pixelsX, pixelsY, this.transparency ? 2 : 1) : new BufferedImage(pixelsX, pixelsY, this.transparency ? 2 : 1);
        this.drawMap(image, z);
        this.drawObjects(image, z);
        this.drawMapIcons(image, z);
        this.drawMapLabels(image, z);
        return image;
    }

    private void drawNeighborObjects(BufferedImage image, int rx, int ry, int dx, int dy, int z) {
        Region neighbor = this.regionLoader.findRegionForRegionCoordinates(rx + dx, ry + dy);
        if (neighbor == null) {
            return;
        }
        this.drawObjects(image, 64 * dx, 64 * -dy, neighbor, z);
    }

    public BufferedImage drawRegion(Region region, int z) {
        int pixelsX = 256;
        int pixelsY = 256;
        BufferedImage image = new BufferedImage(pixelsX, pixelsY, this.transparency ? 2 : 1);
        this.drawMap(image, 0, 0, z, region);
        this.drawNeighborObjects(image, region.getRegionX(), region.getRegionY(), -1, -1, z);
        this.drawNeighborObjects(image, region.getRegionX(), region.getRegionY(), -1, 0, z);
        this.drawNeighborObjects(image, region.getRegionX(), region.getRegionY(), -1, 1, z);
        this.drawNeighborObjects(image, region.getRegionX(), region.getRegionY(), 0, -1, z);
        this.drawObjects(image, 0, 0, region, z);
        this.drawNeighborObjects(image, region.getRegionX(), region.getRegionY(), 0, 1, z);
        this.drawNeighborObjects(image, region.getRegionX(), region.getRegionY(), 1, -1, z);
        this.drawNeighborObjects(image, region.getRegionX(), region.getRegionY(), 1, 0, z);
        this.drawNeighborObjects(image, region.getRegionX(), region.getRegionY(), 1, 1, z);
        this.drawMapIcons(image, 0, 0, region, z);
        return image;
    }

    private void drawMap(BufferedImage image, int drawBaseX, int drawBaseY, int z, Region region) {
        if (!this.renderMap) {
            return;
        }
        int[][][] map = new int[4][][];
        for (int x = 0; x < 64; ++x) {
            for (int y = 0; y < 64; ++y) {
                byte upTileSetting;
                boolean isBridge = (region.getTileSetting(1, x, 64 - y - 1) & 2) != 0;
                int tileZ = z + (isBridge ? 1 : 0);
                if (tileZ >= 4) continue;
                byte tileSetting = region.getTileSetting(z, x, 64 - y - 1);
                if ((tileSetting & 0x18) == 0) {
                    if (z == 0 && isBridge) {
                        this.drawTile(image, map, region, drawBaseX, drawBaseY, 0, x, y);
                    }
                    this.drawTile(image, map, region, drawBaseX, drawBaseY, tileZ, x, y);
                }
                if (tileZ >= 3 || ((upTileSetting = region.getTileSetting(z + 1, x, 64 - y - 1)) & 8) == 0) continue;
                this.drawTile(image, map, region, drawBaseX, drawBaseY, tileZ + 1, x, y);
            }
        }
    }

    private void drawMap(BufferedImage image, int z) {
        for (Region region : this.regionLoader.getRegions()) {
            int baseX = region.getBaseX();
            int baseY = region.getBaseY();
            int drawBaseX = baseX - this.regionLoader.getLowestX().getBaseX();
            int drawBaseY = this.regionLoader.getHighestY().getBaseY() - baseY;
            this.drawMap(image, drawBaseX, drawBaseY, z, region);
        }
    }

    private void drawTile(BufferedImage to, int[][][] planes, Region region, int drawBaseX, int drawBaseY, int z, int x, int y) {
        int[][] pixels = planes[z];
        if (pixels == null) {
            planes[z] = new int[256][256];
            pixels = planes[z];
            this.drawMap(pixels, region, z);
        }
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                int argb = pixels[x * 4 + i][y * 4 + j];
                if (argb == 0) continue;
                to.setRGB(drawBaseX * 4 + x * 4 + i, drawBaseY * 4 + y * 4 + j, argb);
            }
        }
    }

    private void drawMap(int[][] pixels, Region region, int z) {
        if (TILE_SHAPE_2D == null) {
            this.generateTileShapes();
        }
        int baseX = region.getBaseX();
        int baseY = region.getBaseY();
        int len = 74;
        int[] hues = new int[len];
        int[] sats = new int[len];
        int[] light = new int[len];
        int[] mul = new int[len];
        int[] num = new int[len];
        boolean hasLeftRegion = this.regionLoader.findRegionForWorldCoordinates(baseX - 1, baseY) != null;
        boolean hasRightRegion = this.regionLoader.findRegionForWorldCoordinates(baseX + 64, baseY) != null;
        boolean hasUpRegion = this.regionLoader.findRegionForWorldCoordinates(baseX, baseY + 64) != null;
        boolean hasDownRegion = this.regionLoader.findRegionForWorldCoordinates(baseX, baseY - 1) != null;
        for (int xi = hasLeftRegion ? -10 : -5; xi < 64 + (hasRightRegion ? 10 : 5); ++xi) {
            for (int yi = hasDownRegion ? -5 : 0; yi < 64 + (hasUpRegion ? 5 : 0); ++yi) {
                int underlayId;
                Region r;
                int xl;
                int underlayId2;
                Region r2;
                int xr = xi + 5;
                if (xr >= (hasLeftRegion ? -5 : 0) && xr < 64 + (hasRightRegion ? 5 : 0) && (r2 = this.regionLoader.findRegionForWorldCoordinates(baseX + xr, baseY + yi)) != null && (underlayId2 = r2.getUnderlayId(z, MapImageDumper.convert(xr), MapImageDumper.convert(yi))) > 0) {
                    UnderlayDefinition underlay = this.findUnderlay(underlayId2 - 1);
                    int n = yi + 5;
                    hues[n] = hues[n] + underlay.getHue() * 256 / underlay.getHueMultiplier();
                    int n2 = yi + 5;
                    sats[n2] = sats[n2] + underlay.getSaturation();
                    int n3 = yi + 5;
                    light[n3] = light[n3] + underlay.getLightness();
                    int n4 = yi + 5;
                    mul[n4] = mul[n4] + underlay.getHueMultiplier();
                    int n5 = yi + 5;
                    num[n5] = num[n5] + 1;
                }
                if ((xl = xi - 5) < (hasLeftRegion ? -5 : 0) || xl >= 64 + (hasRightRegion ? 5 : 0) || (r = this.regionLoader.findRegionForWorldCoordinates(baseX + xl, baseY + yi)) == null || (underlayId = r.getUnderlayId(z, MapImageDumper.convert(xl), MapImageDumper.convert(yi))) <= 0) continue;
                UnderlayDefinition underlay = this.findUnderlay(underlayId - 1);
                int n = yi + 5;
                hues[n] = hues[n] - underlay.getHue() * 256 / underlay.getHueMultiplier();
                int n6 = yi + 5;
                sats[n6] = sats[n6] - underlay.getSaturation();
                int n7 = yi + 5;
                light[n7] = light[n7] - underlay.getLightness();
                int n8 = yi + 5;
                mul[n8] = mul[n8] - underlay.getHueMultiplier();
                int n9 = yi + 5;
                num[n9] = num[n9] - 1;
            }
            if (xi < 0 || xi >= 64) continue;
            int runningHues = 0;
            int runningSat = 0;
            int runningLight = 0;
            int runningMultiplier = 0;
            int runningNumber = 0;
            for (int yi = hasDownRegion ? -10 : -5; yi < 64 + (hasUpRegion ? 10 : 5); ++yi) {
                int ix;
                int iy;
                int drawY;
                int drawX;
                int shape;
                int rotation;
                Region r;
                int yd;
                int yu = yi + 5;
                if (yu >= (hasDownRegion ? -5 : 0) && yu < 64 + (hasUpRegion ? 5 : 0)) {
                    runningHues += hues[yu + 5];
                    runningSat += sats[yu + 5];
                    runningLight += light[yu + 5];
                    runningMultiplier += mul[yu + 5];
                    runningNumber += num[yu + 5];
                }
                if ((yd = yi - 5) >= (hasDownRegion ? -5 : 0) && yd < 64 + (hasUpRegion ? 5 : 0)) {
                    runningHues -= hues[yd + 5];
                    runningSat -= sats[yd + 5];
                    runningLight -= light[yd + 5];
                    runningMultiplier -= mul[yd + 5];
                    runningNumber -= num[yd + 5];
                }
                if (yi < 0 || yi >= 64 || (r = this.regionLoader.findRegionForWorldCoordinates(baseX + xi, baseY + yi)) == null) continue;
                int underlayId = r.getUnderlayId(z, MapImageDumper.convert(xi), MapImageDumper.convert(yi));
                int overlayId = r.getOverlayId(z, MapImageDumper.convert(xi), MapImageDumper.convert(yi));
                if (underlayId <= 0 && overlayId <= 0) continue;
                int underlayHsl = -1;
                if (underlayId > 0) {
                    int avgHue = runningHues / runningNumber;
                    int avgSat = runningSat / runningNumber;
                    int avgLight = runningLight / runningNumber;
                    if (avgLight < 0) {
                        avgLight = 0;
                    } else if (avgLight > 255) {
                        avgLight = 255;
                    }
                    underlayHsl = this.packHslFull(avgHue, avgSat, avgLight);
                }
                int underlayRgb = 0;
                if (underlayHsl != -1) {
                    underlayRgb = JagexColor.getRGBFull(underlayHsl);
                }
                int overlayRgb = 0;
                if (overlayId == 0) {
                    rotation = 0;
                    shape = 0;
                } else {
                    int hsl;
                    shape = r.getOverlayPath(z, MapImageDumper.convert(xi), MapImageDumper.convert(yi)) + 1;
                    rotation = r.getOverlayRotation(z, MapImageDumper.convert(xi), MapImageDumper.convert(yi));
                    OverlayDefinition overlayDefinition = this.findOverlay(overlayId - 1);
                    int overlayTexture = overlayDefinition.getTexture();
                    if (overlayTexture >= 0) {
                        hsl = this.rsTextureProvider.getAverageTextureRGB(overlayTexture);
                        hsl = this.packHslFull(JagexColor.unpackHue((short)hsl) * 4, JagexColor.unpackSaturation((short)hsl) * 32, JagexColor.unpackLuminance((short)hsl) * 2);
                    } else {
                        hsl = overlayDefinition.getRgbColor() == 0xFF00FF ? -2 : this.packHslFull(overlayDefinition.getHue(), overlayDefinition.getSaturation(), overlayDefinition.getLightness());
                    }
                    if (hsl != -2) {
                        hsl = MapImageDumper.adjustHSLListness0(hsl);
                        overlayRgb = JagexColor.getRGBFull(hsl);
                    }
                    if (overlayDefinition.getSecondaryRgbColor() != -1) {
                        int hue = overlayDefinition.getOtherHue();
                        int sat = overlayDefinition.getOtherSaturation();
                        int olight = overlayDefinition.getOtherLightness();
                        hsl = this.packHslFull(hue, sat, olight);
                        overlayRgb = JagexColor.getRGBFull(hsl);
                    }
                }
                if (!this.renderOverlays) {
                    overlayRgb = underlayRgb;
                }
                if (shape == 0) {
                    drawX = xi;
                    drawY = 63 - yi;
                    if (underlayRgb == 0) continue;
                    this.drawMapSquare(pixels, drawX, drawY, underlayRgb);
                    continue;
                }
                if (shape == 1) {
                    drawX = xi;
                    drawY = 63 - yi;
                    this.drawMapSquare(pixels, drawX, drawY, overlayRgb);
                    continue;
                }
                drawX = xi * 4;
                drawY = (63 - yi) * 4;
                rotation = this.convertTileRotation(rotation, --shape);
                shape = this.convertTileShape(shape);
                if (underlayRgb != 0) {
                    int idx = 0;
                    for (iy = 0; iy < 4; ++iy) {
                        for (ix = 0; ix < 4; ++ix) {
                            int p = TILE_SHAPE_2D[shape - 1][rotation][idx++] == 0 ? underlayRgb : overlayRgb;
                            this.setPixels(pixels, drawX + ix, drawY + iy, p);
                        }
                    }
                    continue;
                }
                int rotIdx = 0;
                for (iy = 0; iy < 4; ++iy) {
                    for (ix = 0; ix < 4; ++ix) {
                        if (TILE_SHAPE_2D[shape - 1][rotation][rotIdx++] == 0) continue;
                        this.setPixels(pixels, drawX + ix, drawY + iy, overlayRgb);
                    }
                }
            }
        }
    }

    private void setPixels(int[][] pixels, int x, int y, int value) {
        if (x >= 0 && y >= 0 && x < pixels.length && y < pixels[x].length) {
            pixels[x][y] = value;
        } else {
            System.err.println("Ground drawing out of bounds! " + x + ", " + y);
        }
    }

    private int convertTileRotation(int rotation, int shape) {
        if (shape == 9) {
            rotation = rotation + 1 & 3;
        }
        if (shape == 10) {
            rotation = rotation + 3 & 3;
        }
        if (shape == 11) {
            rotation = rotation + 3 & 3;
        }
        return rotation;
    }

    int convertTileShape(int shape) {
        return shape != 9 && shape != 10 ? (shape == 11 ? 8 : shape) : 1;
    }

    private void generateTileShapes() {
        TILE_SHAPE_2D = new byte[8][4][];
        this.genTileShapes1();
        this.genTileShapes2();
        this.genTileShapes3();
        this.genTileShapes4();
        this.genTileShapes5();
        this.genTileShapes6();
        this.genTileShapes7();
        this.genTileShapes8();
    }

    private void genTileShapes1() {
        int y;
        int x;
        byte[] shape = new byte[16];
        int index = 0;
        for (x = 0; x < 4; ++x) {
            for (y = 0; y < 4; ++y) {
                if (y <= x) {
                    shape[index] = -1;
                }
                ++index;
            }
        }
        MapImageDumper.TILE_SHAPE_2D[0][0] = shape;
        shape = new byte[16];
        index = 0;
        for (x = 3; x >= 0; --x) {
            for (y = 0; y < 4; ++y) {
                if (y <= x) {
                    shape[index] = -1;
                }
                ++index;
            }
        }
        MapImageDumper.TILE_SHAPE_2D[0][1] = shape;
        shape = new byte[16];
        index = 0;
        for (x = 0; x < 4; ++x) {
            for (y = 0; y < 4; ++y) {
                if (y >= x) {
                    shape[index] = -1;
                }
                ++index;
            }
        }
        MapImageDumper.TILE_SHAPE_2D[0][2] = shape;
        shape = new byte[16];
        index = 0;
        for (x = 3; x >= 0; --x) {
            for (y = 0; y < 4; ++y) {
                if (y >= x) {
                    shape[index] = -1;
                }
                ++index;
            }
        }
        MapImageDumper.TILE_SHAPE_2D[0][3] = shape;
    }

    void genTileShapes2() {
        int var4;
        int var3;
        byte[] shape = new byte[16];
        int var2 = 0;
        for (var3 = 3; var3 >= 0; --var3) {
            for (var4 = 0; var4 < 4; ++var4) {
                if (var4 <= var3 >> 1) {
                    shape[var2] = -1;
                }
                ++var2;
            }
        }
        MapImageDumper.TILE_SHAPE_2D[1][0] = shape;
        shape = new byte[16];
        var2 = 0;
        for (var3 = 0; var3 < 4; ++var3) {
            for (var4 = 0; var4 < 4; ++var4) {
                if (var2 >= 0 && var2 < shape.length) {
                    if (var4 >= var3 << 1) {
                        shape[var2] = -1;
                    }
                    ++var2;
                    continue;
                }
                ++var2;
            }
        }
        MapImageDumper.TILE_SHAPE_2D[1][1] = shape;
        shape = new byte[16];
        var2 = 0;
        for (var3 = 0; var3 < 4; ++var3) {
            for (var4 = 3; var4 >= 0; --var4) {
                if (var4 <= var3 >> 1) {
                    shape[var2] = -1;
                }
                ++var2;
            }
        }
        MapImageDumper.TILE_SHAPE_2D[1][2] = shape;
        shape = new byte[16];
        var2 = 0;
        for (var3 = 3; var3 >= 0; --var3) {
            for (var4 = 3; var4 >= 0; --var4) {
                if (var4 >= var3 << 1) {
                    shape[var2] = -1;
                }
                ++var2;
            }
        }
        MapImageDumper.TILE_SHAPE_2D[1][3] = shape;
    }

    void genTileShapes3() {
        int var4;
        int var3;
        byte[] shape = new byte[16];
        int var2 = 0;
        for (var3 = 3; var3 >= 0; --var3) {
            for (var4 = 3; var4 >= 0; --var4) {
                if (var4 <= var3 >> 1) {
                    shape[var2] = -1;
                }
                ++var2;
            }
        }
        MapImageDumper.TILE_SHAPE_2D[2][0] = shape;
        shape = new byte[16];
        var2 = 0;
        for (var3 = 3; var3 >= 0; --var3) {
            for (var4 = 0; var4 < 4; ++var4) {
                if (var4 >= var3 << 1) {
                    shape[var2] = -1;
                }
                ++var2;
            }
        }
        MapImageDumper.TILE_SHAPE_2D[2][1] = shape;
        shape = new byte[16];
        var2 = 0;
        for (var3 = 0; var3 < 4; ++var3) {
            for (var4 = 0; var4 < 4; ++var4) {
                if (var4 <= var3 >> 1) {
                    shape[var2] = -1;
                }
                ++var2;
            }
        }
        MapImageDumper.TILE_SHAPE_2D[2][2] = shape;
        shape = new byte[16];
        var2 = 0;
        for (var3 = 0; var3 < 4; ++var3) {
            for (var4 = 3; var4 >= 0; --var4) {
                if (var4 >= var3 << 1) {
                    shape[var2] = -1;
                }
                ++var2;
            }
        }
        MapImageDumper.TILE_SHAPE_2D[2][3] = shape;
    }

    void genTileShapes4() {
        int var4;
        int var3;
        byte[] shape = new byte[16];
        int var2 = 0;
        for (var3 = 3; var3 >= 0; --var3) {
            for (var4 = 0; var4 < 4; ++var4) {
                if (var4 >= var3 >> 1) {
                    shape[var2] = -1;
                }
                ++var2;
            }
        }
        MapImageDumper.TILE_SHAPE_2D[3][0] = shape;
        shape = new byte[16];
        var2 = 0;
        for (var3 = 0; var3 < 4; ++var3) {
            for (var4 = 0; var4 < 4; ++var4) {
                if (var4 <= var3 << 1) {
                    shape[var2] = -1;
                }
                ++var2;
            }
        }
        MapImageDumper.TILE_SHAPE_2D[3][1] = shape;
        shape = new byte[16];
        var2 = 0;
        for (var3 = 0; var3 < 4; ++var3) {
            for (var4 = 3; var4 >= 0; --var4) {
                if (var4 >= var3 >> 1) {
                    shape[var2] = -1;
                }
                ++var2;
            }
        }
        MapImageDumper.TILE_SHAPE_2D[3][2] = shape;
        shape = new byte[16];
        var2 = 0;
        for (var3 = 3; var3 >= 0; --var3) {
            for (var4 = 3; var4 >= 0; --var4) {
                if (var4 <= var3 << 1) {
                    shape[var2] = -1;
                }
                ++var2;
            }
        }
        MapImageDumper.TILE_SHAPE_2D[3][3] = shape;
    }

    void genTileShapes5() {
        int var4;
        int var3;
        byte[] shape = new byte[16];
        int var2 = 0;
        for (var3 = 3; var3 >= 0; --var3) {
            for (var4 = 3; var4 >= 0; --var4) {
                if (var4 >= var3 >> 1) {
                    shape[var2] = -1;
                }
                ++var2;
            }
        }
        MapImageDumper.TILE_SHAPE_2D[4][0] = shape;
        shape = new byte[16];
        var2 = 0;
        for (var3 = 3; var3 >= 0; --var3) {
            for (var4 = 0; var4 < 4; ++var4) {
                if (var4 <= var3 << 1) {
                    shape[var2] = -1;
                }
                ++var2;
            }
        }
        MapImageDumper.TILE_SHAPE_2D[4][1] = shape;
        shape = new byte[16];
        var2 = 0;
        for (var3 = 0; var3 < 4; ++var3) {
            for (var4 = 0; var4 < 4; ++var4) {
                if (var4 >= var3 >> 1) {
                    shape[var2] = -1;
                }
                ++var2;
            }
        }
        MapImageDumper.TILE_SHAPE_2D[4][2] = shape;
        shape = new byte[16];
        var2 = 0;
        for (var3 = 0; var3 < 4; ++var3) {
            for (var4 = 3; var4 >= 0; --var4) {
                if (var4 <= var3 << 1) {
                    shape[var2] = -1;
                }
                ++var2;
            }
        }
        MapImageDumper.TILE_SHAPE_2D[4][3] = shape;
    }

    void genTileShapes6() {
        int var5;
        int var4;
        byte[] shape = new byte[16];
        boolean var2 = false;
        shape = new byte[16];
        int var3 = 0;
        for (var4 = 0; var4 < 4; ++var4) {
            for (var5 = 0; var5 < 4; ++var5) {
                if (var5 <= 2) {
                    shape[var3] = -1;
                }
                ++var3;
            }
        }
        MapImageDumper.TILE_SHAPE_2D[5][0] = shape;
        shape = new byte[16];
        var3 = 0;
        for (var4 = 0; var4 < 4; ++var4) {
            for (var5 = 0; var5 < 4; ++var5) {
                if (var4 <= 2) {
                    shape[var3] = -1;
                }
                ++var3;
            }
        }
        MapImageDumper.TILE_SHAPE_2D[5][1] = shape;
        shape = new byte[16];
        var3 = 0;
        for (var4 = 0; var4 < 4; ++var4) {
            for (var5 = 0; var5 < 4; ++var5) {
                if (var5 >= 2) {
                    shape[var3] = -1;
                }
                ++var3;
            }
        }
        MapImageDumper.TILE_SHAPE_2D[5][2] = shape;
        shape = new byte[16];
        var3 = 0;
        for (var4 = 0; var4 < 4; ++var4) {
            for (var5 = 0; var5 < 4; ++var5) {
                if (var4 >= 2) {
                    shape[var3] = -1;
                }
                ++var3;
            }
        }
        MapImageDumper.TILE_SHAPE_2D[5][3] = shape;
    }

    void genTileShapes7() {
        int var5;
        int var4;
        byte[] shape = new byte[16];
        boolean var2 = false;
        shape = new byte[16];
        int var3 = 0;
        for (var4 = 0; var4 < 4; ++var4) {
            for (var5 = 0; var5 < 4; ++var5) {
                if (var5 <= var4 - 2) {
                    shape[var3] = -1;
                }
                ++var3;
            }
        }
        MapImageDumper.TILE_SHAPE_2D[6][0] = shape;
        shape = new byte[16];
        var3 = 0;
        for (var4 = 3; var4 >= 0; --var4) {
            for (var5 = 0; var5 < 4; ++var5) {
                if (var5 <= var4 - 2) {
                    shape[var3] = -1;
                }
                ++var3;
            }
        }
        MapImageDumper.TILE_SHAPE_2D[6][1] = shape;
        shape = new byte[16];
        var3 = 0;
        for (var4 = 3; var4 >= 0; --var4) {
            for (var5 = 3; var5 >= 0; --var5) {
                if (var5 <= var4 - 2) {
                    shape[var3] = -1;
                }
                ++var3;
            }
        }
        MapImageDumper.TILE_SHAPE_2D[6][2] = shape;
        shape = new byte[16];
        var3 = 0;
        for (var4 = 0; var4 < 4; ++var4) {
            for (var5 = 3; var5 >= 0; --var5) {
                if (var5 <= var4 - 2) {
                    shape[var3] = -1;
                }
                ++var3;
            }
        }
        MapImageDumper.TILE_SHAPE_2D[6][3] = shape;
    }

    void genTileShapes8() {
        int var5;
        int var4;
        byte[] shape = new byte[16];
        boolean var2 = false;
        shape = new byte[16];
        int var3 = 0;
        for (var4 = 0; var4 < 4; ++var4) {
            for (var5 = 0; var5 < 4; ++var5) {
                if (var5 >= var4 - 2) {
                    shape[var3] = -1;
                }
                ++var3;
            }
        }
        MapImageDumper.TILE_SHAPE_2D[7][0] = shape;
        shape = new byte[16];
        var3 = 0;
        for (var4 = 3; var4 >= 0; --var4) {
            for (var5 = 0; var5 < 4; ++var5) {
                if (var5 >= var4 - 2) {
                    shape[var3] = -1;
                }
                ++var3;
            }
        }
        MapImageDumper.TILE_SHAPE_2D[7][1] = shape;
        shape = new byte[16];
        var3 = 0;
        for (var4 = 3; var4 >= 0; --var4) {
            for (var5 = 3; var5 >= 0; --var5) {
                if (var5 >= var4 - 2) {
                    shape[var3] = -1;
                }
                ++var3;
            }
        }
        MapImageDumper.TILE_SHAPE_2D[7][2] = shape;
        shape = new byte[16];
        var3 = 0;
        for (var4 = 0; var4 < 4; ++var4) {
            for (var5 = 3; var5 >= 0; --var5) {
                if (var5 >= var4 - 2) {
                    shape[var3] = -1;
                }
                ++var3;
            }
        }
        MapImageDumper.TILE_SHAPE_2D[7][3] = shape;
    }

    private static int convert(int d) {
        if (d >= 0) {
            return d % 64;
        }
        return 64 - -(d % 64) - 1;
    }

    private void drawObjects(BufferedImage image, int drawBaseX, int drawBaseY, Region region, int z) {
        if (!this.renderObjects) {
            return;
        }
        ArrayList<Location> planeLocs = new ArrayList<Location>();
        ArrayList<Location> pushDownLocs = new ArrayList<Location>();
        List<List> layers = Arrays.asList(planeLocs, pushDownLocs);
        for (int localX = 0; localX < 64; ++localX) {
            int regionX = localX + region.getBaseX();
            for (int localY = 0; localY < 64; ++localY) {
                int regionY = localY + region.getBaseY();
                planeLocs.clear();
                pushDownLocs.clear();
                boolean isBridge = (region.getTileSetting(1, localX, localY) & 2) != 0;
                int tileZ = z + (isBridge ? 1 : 0);
                for (Location loc : region.getLocations()) {
                    Position pos = loc.getPosition();
                    if (pos.getX() != regionX || pos.getY() != regionY) continue;
                    if (pos.getZ() == tileZ && (region.getTileSetting(z, localX, localY) & 0x18) == 0) {
                        planeLocs.add(loc);
                        continue;
                    }
                    if (z >= 3 || pos.getZ() != tileZ + 1 || (region.getTileSetting(z + 1, localX, localY) & 8) == 0) continue;
                    pushDownLocs.add(loc);
                }
                for (List locs : layers) {
                    int drawY;
                    int type;
                    if (this.renderWalls) {
                        int yOffset;
                        int xOffset;
                        int rgb;
                        int drawX;
                        ObjectDefinition object;
                        int rotation;
                        for (Location location : locs) {
                            type = location.getType();
                            if (type < 0 || type > 3) continue;
                            rotation = location.getOrientation();
                            object = this.findObject(location.getId());
                            drawX = (drawBaseX + localX) * 4;
                            drawY = (drawBaseY + (64 - object.getSizeY() - localY)) * 4;
                            rgb = this.wallColor;
                            if (object.getWallOrDoor() != 0) {
                                rgb = this.doorColor;
                            }
                            rgb |= 0xFF000000;
                            if (object.getMapSceneID() != -1) {
                                this.blitMapDecoration(image, drawX, drawY, object);
                                continue;
                            }
                            if (drawX < 0 || drawY < 0 || drawX >= image.getWidth() || drawY >= image.getHeight()) continue;
                            if (type == 0 || type == 2) {
                                xOffset = rotation == 2 ? 3 : 0;
                                yOffset = rotation == 3 ? 3 : 0;
                                do {
                                    image.setRGB(drawX + xOffset, drawY + yOffset, rgb);
                                    switch (rotation) {
                                        case 0: 
                                        case 2: {
                                            ++yOffset;
                                            break;
                                        }
                                        case 1: 
                                        case 3: {
                                            ++xOffset;
                                        }
                                    }
                                } while (xOffset < 4 && yOffset < 4);
                            }
                            if (type == 3) {
                                if (rotation == 0) {
                                    image.setRGB(drawX + 0, drawY + 0, rgb);
                                } else if (rotation == 1) {
                                    image.setRGB(drawX + 4 - 1, drawY + 0, rgb);
                                } else if (rotation == 2) {
                                    image.setRGB(drawX + 4 - 1, drawY + 4 - 1, rgb);
                                } else if (rotation == 3) {
                                    image.setRGB(drawX + 0, drawY + 4 - 1, rgb);
                                }
                            }
                            if (type != 2) continue;
                            xOffset = rotation == 1 ? 3 : 0;
                            yOffset = rotation == 2 ? 3 : 0;
                            do {
                                image.setRGB(drawX + xOffset, drawY + yOffset, rgb);
                                switch (rotation) {
                                    case 1: 
                                    case 3: {
                                        ++yOffset;
                                        break;
                                    }
                                    case 0: 
                                    case 2: {
                                        ++xOffset;
                                    }
                                }
                            } while (xOffset < 4 && yOffset < 4);
                        }
                        for (Location location : locs) {
                            type = location.getType();
                            if (type != 9) continue;
                            rotation = location.getOrientation();
                            object = this.findObject(location.getId());
                            drawX = (drawBaseX + localX) * 4;
                            drawY = (drawBaseY + (64 - object.getSizeY() - localY)) * 4;
                            if (object.getMapSceneID() != -1) {
                                this.blitMapDecoration(image, drawX, drawY, object);
                                continue;
                            }
                            if (drawX < 0 || drawY < 0 || drawX >= image.getWidth() || drawY >= image.getHeight()) continue;
                            rgb = this.wallColor;
                            if (object.getWallOrDoor() != 0) {
                                rgb = this.doorColor;
                            }
                            if (rotation != 0 && rotation != 2) {
                                xOffset = 0;
                                yOffset = 0;
                                do {
                                    image.setRGB(drawX + xOffset, drawY + yOffset, rgb);
                                } while (++xOffset < 4 && ++yOffset < 4);
                                continue;
                            }
                            xOffset = 0;
                            yOffset = 3;
                            do {
                                image.setRGB(drawX + xOffset, drawY + yOffset, rgb);
                            } while (++xOffset < 4 && --yOffset >= 0);
                        }
                    }
                    for (Location location : locs) {
                        type = location.getType();
                        if (type != 22 && (type < 9 || type > 11)) continue;
                        ObjectDefinition object = this.findObject(location.getId());
                        int drawX = (drawBaseX + localX) * 4;
                        int objSizeOffset = Math.max(2, object.getOffsetY());
                        drawY = (drawBaseY + (64 - objSizeOffset - localY)) * 4;
                        if (object.getMapSceneID() == -1) continue;
                        this.blitMapDecoration(image, drawX, drawY, object);
                    }
                }
            }
        }
    }

    private void drawObjects(BufferedImage image, int z) {
        for (Region region : this.regionLoader.getRegions()) {
            int baseX = region.getBaseX();
            int baseY = region.getBaseY();
            int drawBaseX = baseX - this.regionLoader.getLowestX().getBaseX();
            int drawBaseY = this.regionLoader.getHighestY().getBaseY() - baseY;
            this.drawObjects(image, drawBaseX, drawBaseY, region, z);
        }
    }

    private void drawMapIcons(BufferedImage image, int drawBaseX, int drawBaseY, Region region, int z) {
        int baseX = region.getBaseX();
        int baseY = region.getBaseY();
        Graphics2D graphics = image.createGraphics();
        this.drawMapIcons(image, region, z, drawBaseX, drawBaseY);
        if (this.labelRegions) {
            graphics.setColor(Color.WHITE);
            String str = baseX + "," + baseY + " (" + region.getRegionX() + "," + region.getRegionY() + ")";
            graphics.drawString(str, drawBaseX * 4, drawBaseY * 4 + graphics.getFontMetrics().getHeight());
        }
        if (this.outlineRegions) {
            graphics.setColor(Color.WHITE);
            graphics.drawRect(drawBaseX * 4, drawBaseY * 4, 256, 256);
        }
        graphics.dispose();
    }

    private void drawMapIcons(BufferedImage image, int z) {
        for (Region region : this.regionLoader.getRegions()) {
            int baseX = region.getBaseX();
            int baseY = region.getBaseY();
            int drawBaseX = baseX - this.regionLoader.getLowestX().getBaseX();
            int drawBaseY = this.regionLoader.getHighestY().getBaseY() - baseY;
            this.drawMapIcons(image, drawBaseX, drawBaseY, region, z);
        }
    }

    private void drawMapLabels(BufferedImage image, int z) {
        if (!this.renderLabels) {
            return;
        }
        FontName[] fontSizes = new FontName[]{FontName.VERDANA_11, FontName.VERDANA_13, FontName.VERDANA_15};
        List<WorldMapElementDefinition> elements = this.worldMapManager.getElements();
        for (WorldMapElementDefinition element : elements) {
            AreaDefinition area = this.areas.getArea(element.getAreaDefinitionId());
            Position worldPosition = element.getWorldPosition();
            if (area == null || area.getName() == null || worldPosition.getZ() != z) continue;
            FontName fontSize = fontSizes[area.getTextScale()];
            FontDefinition font = this.fonts.findFontByName(fontSize.getName());
            String areaLabel = area.getName();
            String[] lines = areaLabel.split("<br>");
            int ascent = 0;
            for (String line : lines) {
                int advance = 0;
                int stringWidth = font.stringWidth(line);
                for (int i = 0; i < line.length(); ++i) {
                    char c = line.charAt(i);
                    SpriteDefinition sprite = this.sprites.findSpriteByArchiveName(fontSize.getName(), c);
                    if (sprite.getWidth() != 0 && sprite.getHeight() != 0) {
                        int drawX = worldPosition.getX() - this.regionLoader.getLowestX().getBaseX();
                        int drawY = this.regionLoader.getHighestY().getBaseY() - worldPosition.getY() + 64 - 2;
                        this.blitGlyph(image, drawX * 4 + advance - stringWidth / 2, drawY * 4 + ascent - font.getAscent() / 2, area.getTextColor(), sprite);
                    }
                    advance += font.getAdvances()[c];
                }
                ascent += font.getAscent() / 2;
            }
        }
    }

    private ObjectDefinition findObject(int id) {
        return this.objectManager.getObject(id);
    }

    private int packHslFull(int hue, int saturation, int light) {
        return JagexColor.packHSLFull(hue, saturation, light);
    }

    static int adjustHSL_something(int hsl, int constant) {
        if (hsl == -1) {
            return 12345678;
        }
        if ((constant = (hsl & 0x7F) * constant / 128) < 2) {
            constant = 2;
        } else if (constant > 126) {
            constant = 126;
        }
        return (hsl & 0xFF80) + constant;
    }

    static final int adjustHSLListness0(int hsl) {
        double multiplier = 0.898;
        int hue = JagexColor.unpackHueFull(hsl);
        int saturation = JagexColor.unpackSaturationFull(hsl);
        int light = JagexColor.unpackLuminanceFull(hsl);
        int constant = (int)((double)light * multiplier);
        if (constant < 2) {
            constant = 2;
        } else if (constant > 255) {
            constant = 255;
        }
        return JagexColor.packHSLFull(hue, saturation, constant);
    }

    private void drawMapSquare(int[][] pixels, int x, int y, int rgb) {
        x *= 4;
        y *= 4;
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                pixels[x + i][y + j] = rgb;
            }
        }
    }

    private void drawMapIcons(BufferedImage img, Region region, int z, int drawBaseX, int drawBaseY) {
        if (!this.renderIcons) {
            return;
        }
        for (Location location : region.getLocations()) {
            int localX = location.getPosition().getX() - region.getBaseX();
            int localY = location.getPosition().getY() - region.getBaseY();
            if (z != location.getPosition().getZ()) continue;
            ObjectDefinition od = this.findObject(location.getId());
            assert (od != null);
            int drawX = drawBaseX + localX;
            int drawY = drawBaseY + (63 - localY);
            if (od.getMapAreaId() == -1) continue;
            AreaDefinition area = this.areas.getArea(od.getMapAreaId());
            assert (area != null);
            SpriteDefinition sprite = this.sprites.findSprite(area.spriteId, 0);
            assert (sprite != null);
            this.blitIcon(img, drawX * 4 - sprite.getMaxWidth() / 2, drawY * 4 - sprite.getMaxHeight() / 2, sprite, 1.0f);
        }
        List<WorldMapElementDefinition> elements = this.worldMapManager.getElements();
        for (WorldMapElementDefinition element : elements) {
            AreaDefinition area = this.areas.getArea(element.getAreaDefinitionId());
            Position worldPosition = element.getWorldPosition();
            int regionX = worldPosition.getX() / 64;
            int regionY = worldPosition.getY() / 64;
            if (area == null || area.getName() != null || worldPosition.getZ() != z || regionX != region.getRegionX() || regionY != region.getRegionY()) continue;
            int localX = worldPosition.getX() - region.getBaseX();
            int localY = worldPosition.getY() - region.getBaseY();
            int drawX = drawBaseX + localX;
            int drawY = drawBaseY + (63 - localY);
            SpriteDefinition sprite = this.sprites.findSprite(area.spriteId, 0);
            this.blitIcon(img, drawX * 4 - sprite.getMaxWidth() / 2, drawY * 4 - sprite.getMaxHeight() / 2, sprite, 1.0f);
        }
    }

    private void loadRegions() throws IOException {
        this.regionLoader.loadRegions();
        this.regionLoader.calculateBounds();
        log.debug("North most region: {}", (Object)this.regionLoader.getLowestY().getBaseY());
        log.debug("South most region: {}", (Object)this.regionLoader.getHighestY().getBaseY());
        log.debug("West most region:  {}", (Object)this.regionLoader.getLowestX().getBaseX());
        log.debug("East most region:  {}", (Object)this.regionLoader.getHighestX().getBaseX());
    }

    private void loadUnderlays(Store store) throws IOException {
        Storage storage = store.getStorage();
        Index index = store.getIndex(IndexType.CONFIGS);
        Archive archive = index.getArchive(ConfigType.UNDERLAY.getId());
        byte[] archiveData = storage.loadArchive(archive);
        ArchiveFiles files = archive.getFiles(archiveData);
        for (FSFile file : files.getFiles()) {
            UnderlayLoader loader = new UnderlayLoader();
            UnderlayDefinition underlay = loader.load(file.getFileId(), file.getContents());
            this.underlays.put(underlay.getId(), underlay);
        }
    }

    private UnderlayDefinition findUnderlay(int id) {
        return this.underlays.get(id);
    }

    private void loadOverlays(Store store) throws IOException {
        Storage storage = store.getStorage();
        Index index = store.getIndex(IndexType.CONFIGS);
        Archive archive = index.getArchive(ConfigType.OVERLAY.getId());
        byte[] archiveData = storage.loadArchive(archive);
        ArchiveFiles files = archive.getFiles(archiveData);
        for (FSFile file : files.getFiles()) {
            OverlayLoader loader = new OverlayLoader();
            OverlayDefinition overlay = loader.load(file.getFileId(), file.getContents());
            this.overlays.put(overlay.getId(), overlay);
        }
    }

    private OverlayDefinition findOverlay(int id) {
        return this.overlays.get(id);
    }

    private void loadSprites() throws IOException {
        Storage storage = this.store.getStorage();
        Index index = this.store.getIndex(IndexType.SPRITES);
        Archive a = index.findArchiveByName("mapscene");
        byte[] contents = a.decompress(storage.loadArchive(a));
        SpriteLoader loader = new SpriteLoader();
        this.mapDecorations = loader.load(a.getArchiveId(), contents);
    }

    private void blitMapDecoration(BufferedImage dst, int x, int y, ObjectDefinition object) {
        SpriteDefinition sprite = this.mapDecorations[object.getMapSceneID()];
        float scale = 1.0f;
        this.blitIcon(dst, x, y + 4, sprite, scale);
    }

    private void blitIcon(BufferedImage dst, int x, int y, SpriteDefinition sprite, float scale) {
        sprite.normalize();
        x += sprite.getOffsetX();
        int displayHeight = (int)((float)sprite.getHeight() * scale);
        int displayWidth = (int)((float)sprite.getWidth() * scale);
        float stepSizeHeight = 2.0f - scale;
        float stepSizeWidth = 2.0f - scale;
        int ymin = Math.max(0, -(y += sprite.getOffsetY()));
        int ymax = Math.min(displayHeight, dst.getHeight() - y);
        int xmin = Math.max(0, -x);
        int xmax = Math.min(displayWidth, dst.getWidth() - x);
        float indexX = 0.0f;
        float indexY = 0.0f;
        for (int yo = ymin; yo < ymax; ++yo) {
            for (int xo = xmin; xo < xmax; ++xo) {
                int index = (int)indexX + (int)indexY * sprite.getWidth();
                byte color = sprite.pixelIdx[index];
                if (color != 0) {
                    dst.setRGB(x + xo, y + yo, sprite.palette[color & 0xFF] | 0xFF000000);
                }
                indexX += stepSizeWidth;
            }
            indexY += stepSizeHeight;
            indexX = 0.0f;
        }
    }

    private void blitGlyphIcon(BufferedImage dst, int x, int y, SpriteDefinition sprite) {
        int ymin = Math.max(0, -(y += sprite.getOffsetY()));
        int ymax = Math.min(sprite.getHeight(), dst.getHeight() - y);
        int xmin = Math.max(0, -(x += sprite.getOffsetX()));
        int xmax = Math.min(sprite.getWidth(), dst.getWidth() - x);
        for (int yo = ymin; yo < ymax; ++yo) {
            for (int xo = xmin; xo < xmax; ++xo) {
                int rgb = sprite.getPixels()[xo + yo * sprite.getWidth()];
                if (rgb == 0) continue;
                dst.setRGB(x + xo, y + yo, rgb | 0xFF000000);
            }
        }
    }

    private void blitGlyph(BufferedImage dst, int x, int y, int color, SpriteDefinition glyph) {
        int[] pixels = glyph.getPixels();
        int[] shadowPixels = new int[pixels.length];
        for (int i = 0; i < pixels.length; ++i) {
            if (pixels[i] == 0) continue;
            pixels[i] = color;
            shadowPixels[i] = -16777216;
        }
        SpriteDefinition shadow = new SpriteDefinition();
        shadow.setPixels(shadowPixels);
        shadow.setOffsetX(glyph.getOffsetX());
        shadow.setOffsetY(glyph.getOffsetY());
        shadow.setWidth(glyph.getWidth());
        shadow.setHeight(glyph.getHeight());
        this.blitGlyphIcon(dst, x + 1, y + 1, shadow);
        this.blitGlyphIcon(dst, x, y, glyph);
    }

    public boolean isLabelRegions() {
        return this.labelRegions;
    }

    public MapImageDumper setLabelRegions(boolean labelRegions) {
        this.labelRegions = labelRegions;
        return this;
    }

    public boolean isOutlineRegions() {
        return this.outlineRegions;
    }

    public MapImageDumper setOutlineRegions(boolean outlineRegions) {
        this.outlineRegions = outlineRegions;
        return this;
    }

    public boolean isRenderMap() {
        return this.renderMap;
    }

    public MapImageDumper setRenderMap(boolean renderMap) {
        this.renderMap = renderMap;
        return this;
    }

    public boolean isRenderObjects() {
        return this.renderObjects;
    }

    public MapImageDumper setRenderObjects(boolean renderObjects) {
        this.renderObjects = renderObjects;
        return this;
    }

    public boolean isRenderIcons() {
        return this.renderIcons;
    }

    public MapImageDumper setRenderIcons(boolean renderIcons) {
        this.renderIcons = renderIcons;
        return this;
    }

    public boolean isRenderWalls() {
        return this.renderWalls;
    }

    public MapImageDumper setRenderWalls(boolean renderWalls) {
        this.renderWalls = renderWalls;
        return this;
    }

    public boolean isRenderOverlays() {
        return this.renderOverlays;
    }

    public MapImageDumper setRenderOverlays(boolean renderOverlays) {
        this.renderOverlays = renderOverlays;
        return this;
    }

    public boolean isRenderLabels() {
        return this.renderLabels;
    }

    public MapImageDumper setRenderLabels(boolean renderLabels) {
        this.renderLabels = renderLabels;
        return this;
    }

    public boolean isTransparency() {
        return this.transparency;
    }

    public MapImageDumper setTransparency(boolean transparency) {
        this.transparency = transparency;
        return this;
    }

    public boolean isLowMemory() {
        return this.lowMemory;
    }

    public MapImageDumper setLowMemory(boolean lowMemory) {
        this.lowMemory = lowMemory;
        return this;
    }
}

