/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.cache.util;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.runelite.cache.util.KeyProvider;
import net.runelite.cache.util.XteaKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XteaKeyManager
implements KeyProvider {
    private static final Logger logger = LoggerFactory.getLogger(XteaKeyManager.class);
    private final Map<Integer, int[]> keys = new HashMap<Integer, int[]>();

    public void loadKeys(InputStream in) {
        List k = (List)new Gson().fromJson((Reader)new InputStreamReader(in, StandardCharsets.UTF_8), new TypeToken<List<XteaKey>>(){}.getType());
        for (XteaKey key : k) {
            this.keys.put(key.getRegion(), key.getKeys());
        }
        logger.info("Loaded {} keys", (Object)this.keys.size());
    }

    @Override
    public int[] getKey(int region) {
        return this.keys.get(region);
    }
}

