/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.cache.util;

import java.util.HashSet;
import java.util.Set;

public class Namer {
    private final Set<String> used = new HashSet<String>();

    public String name(String name, int id) {
        if ((name = Namer.sanitize((String)name)) == null) {
            return null;
        }
        if (this.used.contains(name)) {
            name = (String)name + "_" + id;
            assert (!this.used.contains(name));
        }
        this.used.add((String)name);
        return name;
    }

    private static String sanitize(String in) {
        String s = Namer.removeTags(in).toUpperCase().replace(' ', '_').replaceAll("[^a-zA-Z0-9_]", "");
        if (s.isEmpty()) {
            return null;
        }
        if (Character.isDigit(s.charAt(0))) {
            return "_" + s;
        }
        return s;
    }

    public static String removeTags(String str) {
        StringBuilder builder = new StringBuilder(str.length());
        boolean inTag = false;
        for (int i = 0; i < str.length(); ++i) {
            char currentChar = str.charAt(i);
            if (currentChar == '<') {
                inTag = true;
                continue;
            }
            if (currentChar == '>') {
                inTag = false;
                continue;
            }
            if (inTag) continue;
            builder.append(currentChar);
        }
        return builder.toString();
    }
}

