/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.cache.util;

import com.sun.jna.Memory;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import net.runelite.cache.util.BzStream;
import net.runelite.cache.util.LibBZip2;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorOutputStream;

public class BZip2 {
    private static final boolean USE_NATIVE_BZIP2 = "true".equalsIgnoreCase(System.getProperty("runelite.useNativeBzip"));
    private static final byte[] BZIP_HEADER = new byte[]{66, 90, 104, 49};

    public static byte[] compress(byte[] bytes) throws IOException {
        return USE_NATIVE_BZIP2 ? BZip2.compressLibBZip2(bytes) : BZip2.compressApache(bytes);
    }

    public static byte[] compressApache(byte[] bytes) throws IOException {
        ByteArrayInputStream is = new ByteArrayInputStream(bytes);
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        try (BZip2CompressorOutputStream os = new BZip2CompressorOutputStream((OutputStream)bout, 1);){
            ((InputStream)is).transferTo((OutputStream)os);
        }
        byte[] out = bout.toByteArray();
        assert (BZIP_HEADER[0] == out[0]);
        assert (BZIP_HEADER[1] == out[1]);
        assert (BZIP_HEADER[2] == out[2]);
        assert (BZIP_HEADER[3] == out[3]);
        return Arrays.copyOfRange(out, BZIP_HEADER.length, out.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] compressLibBZip2(byte[] data) throws IOException {
        LibBZip2 libBZip2 = LibBZip2.INSTANCE;
        BzStream stream = new BzStream();
        stream.next_in = new Memory((long)data.length);
        stream.avail_in = data.length;
        stream.next_in.write(0L, data, 0, data.length);
        int outsz = 65536;
        Memory out = new Memory((long)outsz);
        stream.next_out = out;
        stream.avail_out = outsz;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        if (libBZip2.BZ2_bzCompressInit(stream, 1, 0, 0) != 0) {
            throw new IOException("BZ2_bzCompressInit() error");
        }
        try {
            int i;
            int offset = BZIP_HEADER.length;
            do {
                if ((i = libBZip2.BZ2_bzCompress(stream, 2)) != 3 && i != 4) {
                    throw new IOException("BZ2_bzCompress() error");
                }
                int wrote = outsz - stream.avail_out;
                buffer.write(out.getByteArray((long)offset, wrote - offset));
                offset = 0;
                stream.next_out = out;
                stream.avail_out = outsz;
            } while (i != 4);
        }
        finally {
            if (libBZip2.BZ2_bzCompressEnd(stream) != 0) {
                throw new IOException("BZ2_bzCompressEnd() error");
            }
        }
        return buffer.toByteArray();
    }

    public static byte[] decompress(byte[] bytes, int len) throws IOException {
        byte[] data = new byte[len + BZIP_HEADER.length];
        System.arraycopy(BZIP_HEADER, 0, data, 0, BZIP_HEADER.length);
        System.arraycopy(bytes, 0, data, BZIP_HEADER.length, len);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try (BZip2CompressorInputStream is = new BZip2CompressorInputStream((InputStream)new ByteArrayInputStream(data));){
            is.transferTo(os);
        }
        return os.toByteArray();
    }
}

