/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.cache.script.assembler;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Map;
import net.runelite.cache.definitions.ScriptDefinition;
import net.runelite.cache.script.Instructions;
import net.runelite.cache.script.assembler.LabelVisitor;
import net.runelite.cache.script.assembler.LexerErrorListener;
import net.runelite.cache.script.assembler.ScriptWriter;
import net.runelite.cache.script.assembler.rs2asmLexer;
import net.runelite.cache.script.assembler.rs2asmParser;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.ParseTreeWalker;

public class Assembler {
    private final Instructions instructions;
    private final Map<String, Object> symbols;

    public Assembler(Instructions instructions) {
        this.instructions = instructions;
        this.symbols = Collections.emptyMap();
    }

    public Assembler(Instructions instructions, Map<String, Object> symbols) {
        this.instructions = instructions;
        this.symbols = symbols;
    }

    public ScriptDefinition assemble(InputStream in) throws IOException {
        rs2asmLexer lexer = new rs2asmLexer((CharStream)new ANTLRInputStream((Reader)new InputStreamReader(in, StandardCharsets.UTF_8)));
        LexerErrorListener errorListener = new LexerErrorListener();
        lexer.addErrorListener((ANTLRErrorListener)errorListener);
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        rs2asmParser parser = new rs2asmParser((TokenStream)tokens);
        rs2asmParser.ProgContext progContext = parser.prog();
        if (errorListener.getErrors() > 0) {
            throw new RuntimeException("syntax error");
        }
        ParseTreeWalker walker = new ParseTreeWalker();
        LabelVisitor labelVisitor = new LabelVisitor();
        walker.walk((ParseTreeListener)labelVisitor, (ParseTree)progContext);
        ScriptWriter listener = new ScriptWriter(this.instructions, labelVisitor, this.symbols);
        walker.walk((ParseTreeListener)listener, (ParseTree)progContext);
        return listener.buildScript();
    }
}

