/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.cache.region;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.runelite.cache.IndexType;
import net.runelite.cache.definitions.LocationsDefinition;
import net.runelite.cache.definitions.MapDefinition;
import net.runelite.cache.definitions.loaders.LocationsLoader;
import net.runelite.cache.definitions.loaders.MapLoader;
import net.runelite.cache.fs.Archive;
import net.runelite.cache.fs.Index;
import net.runelite.cache.fs.Storage;
import net.runelite.cache.fs.Store;
import net.runelite.cache.region.Region;
import net.runelite.cache.util.KeyProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegionLoader {
    private static final Logger log = LoggerFactory.getLogger(RegionLoader.class);
    private static final int MAX_REGION = 32768;
    private final Store store;
    private final Index index;
    private final KeyProvider keyProvider;
    private final Map<Integer, Region> regions = new HashMap<Integer, Region>();
    private Region lowestX = null;
    private Region lowestY = null;
    private Region highestX = null;
    private Region highestY = null;

    public RegionLoader(Store store, KeyProvider keyProvider) {
        this.store = store;
        this.index = store.getIndex(IndexType.MAPS);
        this.keyProvider = keyProvider;
    }

    public void loadRegions() throws IOException {
        if (!this.regions.isEmpty()) {
            return;
        }
        for (int i = 0; i < 32768; ++i) {
            try {
                this.loadRegionFromArchive(i);
                continue;
            }
            catch (IOException ex) {
                log.debug("Can't decrypt region " + i, (Throwable)ex);
            }
        }
    }

    public Region loadRegionFromArchive(int i) throws IOException {
        int x = i >> 8;
        int y = i & 0xFF;
        Storage storage = this.store.getStorage();
        Archive map = this.index.findArchiveByName("m" + x + "_" + y);
        Archive land = this.index.findArchiveByName("l" + x + "_" + y);
        assert (map == null == (land == null));
        if (map == null || land == null) {
            return null;
        }
        byte[] data = map.decompress(storage.loadArchive(map));
        MapDefinition mapDef = new MapLoader().load(x, y, data);
        Region region = new Region(i);
        region.loadTerrain(mapDef);
        int[] keys = this.keyProvider.getKey(i);
        if (keys != null) {
            data = land.decompress(storage.loadArchive(land), keys);
            LocationsDefinition locDef = new LocationsLoader().load(x, y, data);
            region.loadLocations(locDef);
        }
        this.regions.put(i, region);
        return region;
    }

    public Region loadRegion(int id, MapDefinition map, LocationsDefinition locs) {
        Region r = new Region(id);
        r.loadTerrain(map);
        if (locs != null) {
            r.loadLocations(locs);
        }
        this.regions.put(id, r);
        return r;
    }

    public void calculateBounds() {
        for (Region region : this.regions.values()) {
            if (this.lowestX == null || region.getBaseX() < this.lowestX.getBaseX()) {
                this.lowestX = region;
            }
            if (this.highestX == null || region.getBaseX() > this.highestX.getBaseX()) {
                this.highestX = region;
            }
            if (this.lowestY == null || region.getBaseY() < this.lowestY.getBaseY()) {
                this.lowestY = region;
            }
            if (this.highestY != null && region.getBaseY() <= this.highestY.getBaseY()) continue;
            this.highestY = region;
        }
    }

    public Collection<Region> getRegions() {
        return this.regions.values();
    }

    public Region findRegionForWorldCoordinates(int x, int y) {
        return this.regions.get((x >>>= 6) << 8 | (y >>>= 6));
    }

    public Region findRegionForRegionCoordinates(int x, int y) {
        return this.regions.get(x << 8 | y);
    }

    public Region getLowestX() {
        return this.lowestX;
    }

    public Region getLowestY() {
        return this.lowestY;
    }

    public Region getHighestX() {
        return this.highestX;
    }

    public Region getHighestY() {
        return this.highestY;
    }
}

