/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.cache.region;

public final class Position {
    private final int x;
    private final int y;
    private final int z;

    public static Position fromPacked(int packedPosition) {
        if (packedPosition == -1) {
            return new Position(-1, -1, -1);
        }
        int z = packedPosition >> 28 & 3;
        int x = packedPosition >> 14 & 0x3FFF;
        int y = packedPosition & 0x3FFF;
        return new Position(x, y, z);
    }

    public Position(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getZ() {
        return this.z;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Position)) {
            return false;
        }
        Position other = (Position)o;
        if (this.getX() != other.getX()) {
            return false;
        }
        if (this.getY() != other.getY()) {
            return false;
        }
        return this.getZ() == other.getZ();
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getX();
        result = result * 59 + this.getY();
        result = result * 59 + this.getZ();
        return result;
    }

    public String toString() {
        return "Position(x=" + this.getX() + ", y=" + this.getY() + ", z=" + this.getZ() + ")";
    }
}

